#include	<defs.h>
#include	<string.h>
#include	"telnet.h"
#include	"menu.h"

#include "dialout.h"

/****************************************************************************
	Routine		: abort_output
	Input			: Index to TELNET structure corresponding to this connection.
						Character received.
	Synopsis		: Stops the current process. Sends a DM in URGent mode so that
						the client can flush its buffers and resynchronize.
****************************************************************************/

USHORT	abort_output(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	static	BYTE	dm[] = { TCIAC, TCDM };


	/* server's input will get flushed if client sent the IP/AO followed by 'Synch'
	or without 'synch' */
	client_info_ptr->recv_buffer_index = 0;
	
	/* send a 'Synch' so that the client can flush what it has received but 
	not yet displayed.*/

	if( character == TCAO)
		send_telnet_packet(client_info_ptr, dm, sizeof(dm), MSG_OOB);

	/* If we are waiting for the password, we send the request again without
	incrementing the attempts */	
	if(client_info_ptr->verifying_pwd) {
		return (send_telnet_packet(client_info_ptr, PasswordStr, strlen(PasswordStr), 0));
	}

	/* If we are waiting for the dialout password, we send the request again
	*/
	if (client_info_ptr->verifying_dialout_pwd == TRUE)
	{
		return (send_telnet_packet(client_info_ptr, PasswordStr, strlen(PasswordStr), 0));
	}

	/* if we are in the middle of sending some info, stop sending it.
	We display the previous menu . Only way a user can stop the session, 
	is by typing 'exit' or with IP. */


	if (client_info_ptr->menustate == TMS_DIALOUT_CHAT)
	{
		/* Clean up for dialout in session and reshow parameters to choose
		** WAN ports, bauds, etc.
		*/
		client_info_ptr->interrupted = TRUE;
		dialout_chat_hdlr(client_info_ptr, NULL);
		return 1;				/* Do nothing if in dial-out mode */
	}

	/* Stop chatting; if we were. */

	if (client_info_ptr->more > 0 || client_info_ptr->menustate == TMS_CHATMODE)
		back_to_normal_mode(client_info_ptr);
	
	return (menu_state_machine(client_info_ptr, NULL));
	
}


/****************************************************************************
	Routine		: interrupt_process
	Input			: Index to TELNET structure corresponding to this connection.
						Character received.
	Synopsis		: Closes this TELNET connection
****************************************************************************/
USHORT	interrupt_process(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	/* ULONG	counter; */

	if (client_info_ptr == ChatClientPtr) {
		send_telnet_packet(client_info_ptr, ChatEnd, strlen(ChatEnd), 0);
		/* for (counter = 0; counter < 0x80000; counter++); */
	}

	if (client_info_ptr->verifying_dialout_pwd == TRUE)
	{
		client_info_ptr->verifying_dialout_pwd = FALSE;
	}

	if (client_info_ptr->menustate == TMS_DIALOUT_CHAT)
	{
		client_info_ptr->force_close = TRUE;
		dialout_chat_hdlr(client_info_ptr, NULL);
		return 0;
	}

	send_telnet_packet(client_info_ptr, CloseCnx, strlen(CloseCnx), 0);
	close_connection(client_info_ptr);
	return 0;
}	

