#include <defs.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>   

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
/*#include <stddef.h>	  */


#include	"telnet.h"
#include	"vmenu.h"

#include <incall.h>
#include <cfgmgr.h>



BYTE ProperChoiceApp[]=
"\n\r\
\n\r\
Invalid Choice!\n\r\
\n\r\
Enter your choice (1, exit, ESC to Previous menu) : ";

extern TFTP_CLASS tftp ;
extern BYTE ChoiceBuffer[80];

/*TELNET_CLASS telnet;*/
/* extern AG_CLASS ag; */
extern int modify_config_visited;

extern BYTE is_an_ip_address(BYTE* address);
extern void	generate_no_of_ports_strings(int no_of_ports, int section_id);
extern enum BOOLEAN validate_time (BYTE *, char *, int *, int *);


BYTE *modify_applications_menu_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
		return (menufsmhdlr[client_info_ptr->menustate].menu);

	switch ( atoi(buffer))
	{
		case MODIFY_TFTP_SERVER:
			client_info_ptr->menustate = TMS_MODI_TFTPINFO;
			break;

		case MODIFY_TELNET_SERVER:
			client_info_ptr->menustate = TMS_MODI_TELNETINFO;
			break;

      case MODIFY_DTTY:
         client_info_ptr->menustate = TMS_MODI_DTTYINFO;
         break;

      case MODIFY_WEB_SERVER: /* Added by Sreelu */
         client_info_ptr->menustate = TMS_MODI_WEBINFO;
         break;

/* sudhir 16/6/96 */
      case MODIFY_PASSWORD:
         client_info_ptr->menustate = TMS_MODIFY_RTR_PASSWORD;
         break;
   
/* Added by Sreelu for SNTP */
		case SNTP_CLIENT: 
			client_info_ptr->menustate = TMS_MODIFY_SNTP_INFO;
			break;

 		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



BYTE *modify_dtty_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		get_parameter (CM_TELNET_SECTION, (void *) &telnet.dumb_tty_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0],
				10);				

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0],				
			GoBack, EnterSingleChoice);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer);

	if (client_info_ptr->modify_option_rcvd == DTTY_STATUS)  
	{
		client_info_ptr->menustate = TMS_DTTY_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *dtty_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *lhs_para_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case DTTY_STATUS:
				ret_str = EnaOrDis;
				break;

			default:
				sprintf(telnet.tx_buffer, ProperChoiceApp, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case DTTY_STATUS:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ; 
			
			switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.dumb_tty_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	client_info_ptr->menustate = TMS_MODI_DTTYINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_tftp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		get_parameter (CM_TFTP_SECTION, (void *) &tftp.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0],
				10);				

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0],				
			GoBack, EnterSingleChoice);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer);

	if (client_info_ptr->modify_option_rcvd == TFTP_STATUS)  
	{
		client_info_ptr->menustate = TMS_TFTP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *tftp_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *lhs_para_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case TFTP_STATUS:
				ret_str = EnaOrDis;
				break;

			default:
				sprintf(telnet.tx_buffer, ProperChoiceApp, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case TFTP_STATUS:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ; 
			
			switch (set_parameter (CM_TFTP_SECTION, (void *) &tftp.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	client_info_ptr->menustate = TMS_MODI_TFTPINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_telnet_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		get_parameter (CM_TELNET_SECTION, (void *) &telnet.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);				

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0]);

		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if (client_info_ptr->modify_option_rcvd == 1)  
	{
		client_info_ptr->menustate = TMS_TELNET_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *telnet_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 1:	
				ret_str = EnaOrDis;
				break;

		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case 1:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
			switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
	}
	client_info_ptr->menustate = TMS_MODI_TELNETINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_ag_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
/*
		get_parameter (CM_AG_SECTION, (void *) &ag.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				
*/
		
		sprintf (ChoiceBuffer, EnterChoice,
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0],
				GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;

	if (client_info_ptr->modify_option_rcvd <= AG_PORTINFO &&
   	client_info_ptr->modify_option_rcvd >= 1)  
	{
		client_info_ptr->menustate = TMS_AG_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *ag_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  AG_STATUS:	ret_str = EnaOrDis;
									break;

			case  AG_PORTINFO:
				client_info_ptr->menustate = TMS_AG_MODIFY_PORT;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
		case AG_STATUS:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
   				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
/*			switch (set_parameter (CM_AG_SECTION, (void *) &ag.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			} */
			break;

		case AG_PORTINFO:
			client_info_ptr->menustate = TMS_AG_MODIFY_PORT;
			break; 
		
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   return(telnet.tx_buffer);
		}
	client_info_ptr->menustate = TMS_MODI_AGINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
			
BYTE	*modify_ag_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer)
	{
			generate_no_of_ports_strings(telnet.number_of_ports  - 1, AG_ID);
			return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);	  

	if (port_number > (telnet.number_of_ports - 1) ||	port_number <= 0)
	{
      sprintf(telnet.tx_buffer, EnterProperChoice, telnet.number_of_ports-1);
		return(telnet.tx_buffer);
	}
 	client_info_ptr->menustate = TMS_MODI_AGPORTINFO;
	client_info_ptr->menu_selected_port = port_number - 1; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_AG_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int ag_inactivity_time;
   ULONG idle_time;

/*	ag_inactivity_time = ag.line_info_array[client_info_ptr->menu_selected_port].line_vars.idle_time /(20 * 60); */

	if (!buffer)
	{
/*		get_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.general_name,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				

		get_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.specific_name,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 10);				

		get_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.idle_time,
				client_info_ptr->menu_selected_port, CM_ULONG_FORMAT, &idle_time, 10);				*/

		sprintf (ChoiceBuffer, EnterChoice,
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu, 
			client_info_ptr->menu_selected_port+1,
			&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0], 
         idle_time,
			GoBack, ChoiceBuffer);

/*			ag.line_info_array[client_info_ptr->menu_selected_port].line_vars.general_name,
			ag.line_info_array[client_info_ptr->menu_selected_port].line_vars.specific_name,
			ag_inactivity_time); */
		return (telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= MOD_AG_GENNAME) &&
		(client_info_ptr->modify_option_rcvd <= MOD_AG_IDLETIME))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_AGPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}

BYTE *upd_modify_ag_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str;
	ULONG new_value, port_no;
   BYTE *new_rhs;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
		 	case MOD_AG_GENNAME:
			case MOD_AG_SPECNAME:
			case MOD_AG_IDLETIME:  
            ret_str = NewValue;
				break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	port_no = client_info_ptr->menu_selected_port;
	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_AG_GENNAME:
			new_rhs = buffer;
         if (strlen (buffer) > 9)
         {
            client_info_ptr->menustate = TMS_WRONG_VALUE;
            menufsmhdlr[TMS_WRONG_VALUE].parentstate = TMS_MODI_AGPORTINFO;

            return wrong_value;
         }

/*			switch (set_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.general_name,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
            case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			} */
			break;
			
		case MOD_AG_SPECNAME:
			new_rhs = buffer;
         if (strlen (buffer) > 14)
         {
            client_info_ptr->menustate = TMS_WRONG_VALUE;
            menufsmhdlr[TMS_WRONG_VALUE].parentstate = TMS_MODI_AGPORTINFO;
            return wrong_value;
         }

/*			switch (set_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.specific_name,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
            case CM_ERROR_WHILE_VALIDATING:
					return InvalidChoice;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			} */
			break;
		
		case MOD_AG_IDLETIME:
			new_rhs = buffer;
/*			switch (set_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.idle_time,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			} */
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}

	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_MODI_AGPORTINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_terminals_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		get_parameter (CM_TELNET_SECTION, (void *) &telnet.terminal_server_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				

      get_parameter (CM_TELNET_SECTION, (void *) &telnet.telnet_server_ip_address_string[0],
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);				
		
		sprintf (ChoiceBuffer, EnterChoice,
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0],
            &ReplyStrs[1].ReplyStr[0],
				GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;

	if (client_info_ptr->modify_option_rcvd <= 2 &&
   	client_info_ptr->modify_option_rcvd >= 1)  
	{
		client_info_ptr->menustate = TMS_TERMS_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *terms_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  TERMS_STATUS:	
            ret_str = EnaOrDis;
				break;

         case TERMS_SERV_ADDR:
            ret_str = NewValue;
            break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
		case TERMS_STATUS:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
   				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
			switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.terminal_server_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
      
      case TERMS_SERV_ADDR:
         new_rhs = buffer;
         if (validate_ip_address (buffer) == FALSE)
            return InvalidIP;

         switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.telnet_server_ip_address_string,
			   CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
         {
            case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   return(telnet.tx_buffer);
		}
   client_info_ptr->menustate = TMS_TERMS_MENU;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
			

BYTE *modify_router_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE router_password[50], decrypted_pass[50];
   USHORT length;
   
   ReplyStrs[0].ReplyStr[0] = 0 ;

   get_parameter (CM_TELNET_SECTION, (void *) &telnet.password,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);				

	decrypt (&ReplyStrs[0].ReplyStr[0], &decrypted_pass[0]);

   length = strlen (&decrypted_pass[0]);
	if (length)
		memset(&router_password[0], (int)'*', length);  
	router_password[length] = 0;

   if (!buffer)
   {
      sprintf (telnet.tx_buffer, RouterPassword, router_password);
      return telnet.tx_buffer;
   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);

   if (client_info_ptr->modify_option_rcvd != 1)
   {
      sprintf(telnet.tx_buffer, ProperChoiceApp,1);
      return telnet.tx_buffer;
   }       
   else
   {
      client_info_ptr->menustate = TMS_UPD_RTR_PASSWORD;
      client_info_ptr->verifying_ppp_pwd = TRUE;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }      
}

BYTE *update_router_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

   if (!buffer)
      return ("\n\rEnter Firewall Password :");

   client_info_ptr->verifying_ppp_pwd = FALSE;

   if (strlen (buffer) > 40)
   {
      return (wrong_pass);
   }

   switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.password,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, buffer))
   {
      case CM_NOT_ENOUGH_MEMORY:
   		return Insufficient_memory;
   }      
   client_info_ptr->menustate = TMS_MODIFY_RTR_PASSWORD;
   modify_config_visited = 1;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Added by Sreelu */

BYTE *modify_web_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		get_parameter (CM_WEB_SECTION, (void *) &web.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);				

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0]);

		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if (client_info_ptr->modify_option_rcvd == 1)  
	{
		client_info_ptr->menustate = TMS_WEB_MODIFY_MENU; 
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *web_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 1:	
				ret_str = EnaOrDis;
				break;
		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case 1:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
			switch (set_parameter (CM_WEB_SECTION, (void *) &web.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
	}
	client_info_ptr->menustate = TMS_MODI_WEBINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Added by Sreelu for SNTP */
char *get_week_day(int index)
{
    char *WeekDay[] = { 
                         "Sunday",
                         "Monday",
                         "Tuesday",
                         "Wednesday",
                         "Thursday",
                         "Friday",
                         "Saturday"
                       };
	return (WeekDay [index-1]);
}

char *get_month_name(int index)
{
    char *MonthName[] =    { 
                         "January",
                         "Februuary",
                         "March",
                         "April",
                         "May",
                         "June",
                         "July",
                         "August",
                         "September",
                         "October",
                         "November",
                         "December"
                       };

	return (MonthName [index-1]);
}

char *get_ordinal_name(int index)
{
    char *OrdinalValue[] = { 
                         "First",
                         "Second",
                         "Third",
                         "Fourth",
                         "Last"
                       };

	return (OrdinalValue[index-1]);
}

BYTE *modify_sntp_client_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	char enabled[10];

	if (!buffer)
	{
      get_parameter_by_name (CM_SNTP_SECTION, "SNTP",
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 20);

      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Server IP Address",
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);

      get_parameter_by_name (CM_SNTP_SECTION, "SNTP TimeZone Standard Name",
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[2].ReplyStr[0], 20);

      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Offset From UTC",
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[3].ReplyStr[0], 20);

      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Savings",
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[4].ReplyStr[0], 20);

		get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Offset",
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[5].ReplyStr[0], 20);

		sprintf (ChoiceBuffer, EnterChoice, 1);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
				&ReplyStrs[2].ReplyStr[0], &ReplyStrs[3].ReplyStr[0],
				&ReplyStrs[4].ReplyStr[0], &ReplyStrs[5].ReplyStr[0],
			GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	client_info_ptr->temp_modify_option_rcvd = client_info_ptr->modify_option_rcvd;
	if ((client_info_ptr->modify_option_rcvd < 1) || 
		(client_info_ptr->modify_option_rcvd > 
				menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	else if ((client_info_ptr->modify_option_rcvd == 7) || (client_info_ptr->modify_option_rcvd == 8 ))
	{
		client_info_ptr->menustate = TMS_MODIFY_SNTP_TIME_INFO;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		client_info_ptr->menustate = TMS_UPD_MODIFY_SNTP_INFO ;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}

BYTE *update_modify_sntp_client_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE 	*ret_str, *new_rhs;
	int hrs, mins;
	ULONG   new_value;
	char time[10], enabled[10];

   get_parameter_by_name (CM_SNTP_SECTION, "SNTP",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&enabled[0], 20);

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  MODIFY_SNTP_ENABLE:
				ret_str = EnaOrDis;
		     	break;

         case  MODIFY_SNTP_DAYLIGHT_ENABLE:
				if(!strcmp(enabled, telnet_enabled_str))
					ret_str = EnaOrDis;
				else
					ret_str = SntpDisabled;
		     	break;

         case  MODIFY_SNTP_SERVER_IP_ADDRESS:
         case  MODIFY_SNTP_OFFSETET_FROM_UTC:
         case  MODIFY_SNTP_DAYLIGHT_OFFSET:	
			case  MODIFY_SNTP_TIME_ZONE:
				if(!strcmp(enabled, telnet_enabled_str))
	            ret_str = NewValue;
				else
					ret_str = SntpDisabled;
		  		break;

			case MODIFY_SNTP_DS_START_TIME: 
			case MODIFY_SNTP_DS_END_TIME:
				if(strcmp(enabled, telnet_enabled_str))
					ret_str = SntpDisabled;
				break;				

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
      }                 
		return (ret_str);
   }                         
  
   new_value = atoi (buffer);
	switch(client_info_ptr->modify_option_rcvd)
	{
		case MODIFY_SNTP_ENABLE :
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
				else
					return (InvalidChoice);
         switch (set_parameter_by_name (CM_SNTP_SECTION, "SNTP",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
		  	break;

		case MODIFY_SNTP_SERVER_IP_ADDRESS :
         new_rhs = buffer;			
         if (validate_ip_address (buffer) == FALSE)
            return InvalidIP;

         if (is_an_ip_address (buffer) == FALSE)
            return InvalidIP;

         switch (set_parameter_by_name (CM_SNTP_SECTION, "SNTP Server IP Address",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;

		case MODIFY_SNTP_TIME_ZONE :
         new_rhs = buffer;			
         switch(set_parameter_by_name (CM_SNTP_SECTION, "SNTP TimeZone Standard Name",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;

		case MODIFY_SNTP_OFFSETET_FROM_UTC :
         if (validate_time (buffer, &time[0], &hrs, &mins) == FALSE)
				return InvalidTime;

         switch(set_parameter_by_name (CM_SNTP_SECTION, "SNTP Offset From UTC",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &time[0]))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;

		case MODIFY_SNTP_DAYLIGHT_ENABLE :
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
				else
					return (InvalidChoice);

         switch (set_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Savings",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
		  	break;

		case MODIFY_SNTP_DAYLIGHT_OFFSET :
         new_rhs = buffer;			

         switch(set_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Offset",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;
	}		  
	modify_config_visited = 1 ; 
	client_info_ptr->menustate = TMS_MODIFY_SNTP_INFO ;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_sntp_time_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	char header[10];

	if(!buffer)
	{
		if(client_info_ptr->temp_modify_option_rcvd == 7)
		{
			strcpy(header, "Start");
	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Day",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 20);

   	   get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start WeekDay",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);

	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Month",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[2].ReplyStr[0], 20);

	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Time Hour",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[3].ReplyStr[0], 20);

	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Time Minute",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[4].ReplyStr[0], 20);
		}
		else
		if(client_info_ptr->temp_modify_option_rcvd == 8)
		{
			strcpy(header, "End");

	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Day",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 20);

   	   get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End WeekDay",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);

	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Month",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[2].ReplyStr[0], 20);

	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Time Hour",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[3].ReplyStr[0], 20);

	      get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Time Minute",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[4].ReplyStr[0], 20);
		}
		sprintf (ChoiceBuffer, EnterChoice, 1);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu, header,
				get_ordinal_name(atoi(&ReplyStrs[0].ReplyStr[0])), get_week_day(atoi(&ReplyStrs[1].ReplyStr[0])),
				get_month_name(atoi(&ReplyStrs[2].ReplyStr[0])), &ReplyStrs[3].ReplyStr[0],
				&ReplyStrs[4].ReplyStr[0], GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd < DAYLIGHT_DAY) || 
		(client_info_ptr->modify_option_rcvd > DAYLIGHT_MINUTE)) 
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	else
	{
		client_info_ptr->menustate = TMS_UPD_MODIFY_SNTP_TIME_INFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}

BYTE *update_modify_sntp_time_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE 	*ret_str, *new_rhs;
	ULONG   new_value;
	char lhs[100];

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case DAYLIGHT_DAY:
				ret_str = SntpTimeOrdinalMenu;
		     	break;

         case DAYLIGHT_WEEKDAY:
            ret_str = SntpTimeWeekMenu;
	     		break;

         case DAYLIGHT_MONTH: 
            ret_str = SntpTimeMonthMenu;
		   	break;

         case DAYLIGHT_HOUR:
            ret_str = NewValue;
		   	break;

         case DAYLIGHT_MINUTE:
            ret_str = NewValue;
		  		break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
      }                 
		return (ret_str);
   }                         

   new_value = atoi (buffer);
	new_rhs = buffer;		
	switch(client_info_ptr->modify_option_rcvd)
	{
		case DAYLIGHT_DAY:
			if (new_value < 1 || new_value > 5)
				return (InvalidChoice);

			if(client_info_ptr->temp_modify_option_rcvd == 7)	
				strcpy(lhs, "SNTP Daylight Start Day");

			if(client_info_ptr->temp_modify_option_rcvd == 8)	
				strcpy(lhs, "SNTP Daylight End Day");

         switch (set_parameter_by_name (CM_SNTP_SECTION, lhs,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
		  	break;

		case DAYLIGHT_WEEKDAY:
			if (new_value < 1 || new_value > 7)
				return (InvalidChoice);

			if(client_info_ptr->temp_modify_option_rcvd == 7)	
				strcpy(lhs, "SNTP Daylight Start WeekDay");

			if(client_info_ptr->temp_modify_option_rcvd == 8)	
				strcpy(lhs, "SNTP Daylight End WeekDay");

         switch (set_parameter_by_name (CM_SNTP_SECTION, lhs,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;

		case DAYLIGHT_MONTH:
			if (new_value < 1 || new_value > 12)
				return (InvalidChoice);

			if(client_info_ptr->temp_modify_option_rcvd == 7)	
				strcpy(lhs, "SNTP Daylight Start Month");

			if(client_info_ptr->temp_modify_option_rcvd == 8)	
				strcpy(lhs, "SNTP Daylight End Month");

         switch (set_parameter_by_name (CM_SNTP_SECTION, lhs,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;

		case DAYLIGHT_HOUR:
			if (new_value < 0 || new_value > 24)
				return (InvalidChoice);

			if(client_info_ptr->temp_modify_option_rcvd == 7)	
				strcpy(lhs, "SNTP Daylight Start Time Hour");

			if(client_info_ptr->temp_modify_option_rcvd == 8)	
				strcpy(lhs, "SNTP Daylight End Time Hour");

         switch (set_parameter_by_name (CM_SNTP_SECTION, lhs,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;


		case DAYLIGHT_MINUTE:
			if (new_value < 0 || new_value > 60)
				return (InvalidChoice);

			if(client_info_ptr->temp_modify_option_rcvd == 7)	
				strcpy(lhs, "SNTP Daylight Start Time Minute");

			if(client_info_ptr->temp_modify_option_rcvd == 8)	
				strcpy(lhs, "SNTP Daylight End Time Minute");

         switch (set_parameter_by_name (CM_SNTP_SECTION, lhs,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
	  		break;
	}
	modify_config_visited = 1 ; 
	client_info_ptr->menustate = TMS_MODIFY_SNTP_TIME_INFO ;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


