#include <defs.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>   

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>


#include	"telnet.h"
#include	"vmenu.h"


#include <incall.h>
#include <cfgmgr.h>

extern int modify_config_visited;

extern BYTE ChoiceBuffer[80];

CM_STRUCT_DHCP_RANGE temp_dhcp_server_info;
CM_STRUCT_DHCP_BIND temp_dhcp_server_bind_info;
CM_STRUCT_DHCP_OPTION temp_dhcp_option_info;

BYTE DHCPMainMenu[]=
"\n\r\
\n\r\
                  << DHCP SERVER >>\n\r\
\n\r\
[1] DHCP Server Enable : %s\n\r\
[2] Address Range\n\r\
\n\r\Enter Your Choice (1 to 2 ,Esc to Prv Menu,exit) :" ;

BYTE DHCPAddMenu[]= 
"\n\r\
\n\r\
[1] IP Address From         : %s\n\r\
[2] IP Address To           : %s\n\r\
[3] IP Address Mask         : %s\n\r\
[4] Exclude Address From    : %s\n\r\
[5] Exclude Address To      : %s\n\r\
\n\r\
Enter Your Choice (1 to 5, C: confirm changes, exit , ESC to previous menu) : ";


BYTE BindMainmenu[]=
"\n\r\
\n\r\
No:   IP Address        MAC Address        Length\n\r\
---   ----------        -----------        ------\n\r\
";

BYTE BindMenu[] = 
"\n\r\
\n\r\
[1] IP Address to Bind      : %s\n\r\
[2] MAC Address Length      : %d\n\r\
[3] MAC Address             : %s\n\r\
\n\r\
Enter Your Choice (1 to 3, C:confirm changes, exit, ESC to previous menu) : ";



BYTE DHCPoptionsmenu[] = 
"\n\r\
\n\r\
[1] Router Address (3)\n\r\
[2] DNS Server (6)\n\r\
[3] Domain Name (15)\n\r\
[4] Reassembly Size (22)\n\r\
[5] Default IP TTL (23)\n\r\
[6] MTU (26)\n\r\
[7] Default TCP TTL (37)\n\r\
[8] Lease Time (51)\n\r\
\n\r\
Enter Your Choice (1 to 8, exit, ESC to previous menu) : ";

BYTE DHCPRoutermenu[] = 
"\n\r\
\n\r\
[1] Router Address(Dot Decimal) : %s\n\r\
[2] Add value at position       : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPDNSseraddr[] = 
"\n\r\
\n\r\
[1] DNS Server Address(Dot Decimal) : %s\n\r\
[2] Add value at position           : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPDomainname[] = 
"\n\r\
\n\r\
[1] Domain Name(Character String) : %s\n\r\
[2] Add value at position         : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPreassize[] =
"\n\r\
\n\r\
[1] Reassembly Size(Unsigned 16 bit) : %s\n\r\
[2] Add value at position            : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPipttl[] = 
"\n\r\
\n\r\
[1] Default IP TTL(Unsigned 8 bit) : %s\n\r\
[2] Add value at position          : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPmtu[] = 
"\n\r\
\n\r\
[1] Maximum Transmit Unit(Unsigned 16 bit) : %s\n\r\
[2] Add value at position                  : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPtcpttl[] = 
"\n\r\
\n\r\
[1] Default TCP TTL(Unsigned 8 bit) : %s\n\r\
[2] Add value at position           : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPleasetime[] =
"\n\r\
\n\r\
[1] Lease Time(Unsigned 32 bit) : %s\n\r\
[2] Add value at position       : %d\n\r\
\n\r\
Enter Your choice (1 to 2, C:confirm addition) : ";

BYTE DHCPManageaddress[] =
"\n\r\
\n\r\
No: IPAddress From  IPAddress to    Exclude From   Exclude upto\n\r\
--  --------------- -------------   ------------   ------------\n\r\
";




void initialize_dhcp_server_parameters ()
{
	temp_dhcp_server_info.ip_address_lower[0] = 0;
	temp_dhcp_server_info.ip_address_higher[0] = 0;
	temp_dhcp_server_info.net_mask[0] = 0;
	temp_dhcp_server_info.exclude_ip_address_lower[0] = 0;
	temp_dhcp_server_info.exclude_ip_address_higher[0] = 0;
}

void initialize_dhcp_option_info ()
{
	temp_dhcp_option_info.option_value[0] = 0;
	temp_dhcp_option_info.position = 1;
	return;
}

BYTE *dhcp_server_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT total_address_ranges=0, tag_number=0;
	CM_STRUCT_DHCP_RANGE *ptr_to_dhcp_addr_range, struct_address_range;
	BYTE temp_buffer[400],dhcp_enable[10],*new_rhs;
   ULONG new_value;

	ptr_to_dhcp_addr_range = &struct_address_range;

	total_address_ranges = cm_get_total_number_of_ranges ();

/* Added by Sreelu */

   if(!buffer)
   {
		if (total_address_ranges == 0)
		{
			strcpy (telnet.tx_buffer, DHCPManageaddress);
	      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, B:Bind , exit, ESC to previous menu): "); 
	   	return telnet.tx_buffer;
		}

		strcpy (telnet.tx_buffer, DHCPManageaddress);
		
		if (client_info_ptr->next_screen)
			tag_number = client_info_ptr->index;

		while (total_address_ranges)
		{
			
			if (cm_get_dhcp_address_range (tag_number, ptr_to_dhcp_addr_range) == FALSE)
			{
				client_info_ptr->next_screen = 0;
				break;
			}

			if (ptr_to_dhcp_addr_range == NULL)
			{
				client_info_ptr->next_screen = 0;
				break;
			}

/*			printf ("Address Range is %s\n",ptr_to_dhcp_addr_range->ip_address_lower); */

			total_address_ranges--; tag_number++;
			sprintf (temp_buffer, "%2d %-15s  %-15s  %-15s  %-15s\n\r" ,
				tag_number,
				ptr_to_dhcp_addr_range->ip_address_lower,
				ptr_to_dhcp_addr_range->ip_address_higher,
				ptr_to_dhcp_addr_range->exclude_ip_address_lower,
				ptr_to_dhcp_addr_range->exclude_ip_address_higher);

			strcat (telnet.tx_buffer, temp_buffer);

			if (tag_number % 10 == 0)
			{
				client_info_ptr->next_screen++;
				client_info_ptr->index = tag_number;
				break;
			} 
		}

      strcat (telnet.tx_buffer, "\n\rEnter choice(A:Add, D:Delete, E:Edit, B:Bind, O:Options \n\r"); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit, ESC to PREV menu):"); 
   	return telnet.tx_buffer;
#if 0
		strcat (telnet.tx_buffer, "Enter Your Choice (A: Add, E: Edit, D: Delete, B: Bind) : ");
		return telnet.tx_buffer;
#endif

	}

	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
		client_info_ptr->next_screen = 0;
		client_info_ptr->edit_filter = 0;
		initialize_dhcp_server_parameters ();
      client_info_ptr->menustate = TMS_ADD_DHCP_ADDRESS;      
   }
	else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1))
	{
		client_info_ptr->edit_filter = 1;
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_DHCP_ADDRESS;
	}
	else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
	{
		client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_DHCP_ADDRESS;
	}
	else if ((*buffer == 'B' || *buffer == 'b') && strlen (buffer) == 1)
	{
		client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_BIND_DHCP_ADDRESS;
	}
	else if ((*buffer == 'O' || *buffer == 'o') && strlen (buffer) == 1)
	{
		client_info_ptr->next_screen = 0;
		initialize_dhcp_option_info ();
		client_info_ptr->menustate = TMS_DHCP_OPTION_HDLR;
	}
	else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
		client_info_ptr->menustate = TMS_MODI_DHCP_INFO;

	else
		return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *add_dhcp_address_information (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	CM_STRUCT_DHCP_RANGE *ptr_to_dhcp_addr_range, struct_address_range;

   if (!buffer)
   {
      sprintf (telnet.tx_buffer, DHCPAddMenu, 
			temp_dhcp_server_info.ip_address_lower,
			temp_dhcp_server_info.ip_address_higher, 
			temp_dhcp_server_info.net_mask,
			temp_dhcp_server_info.exclude_ip_address_lower, 
			temp_dhcp_server_info.exclude_ip_address_higher);
		return telnet.tx_buffer;
	}

   client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= DHCP_ADDR_LOWER_BOUND &&
     client_info_ptr->modify_option_rcvd <= DHCP_EXCLUDE_UPPER_BOUND)
	{
      client_info_ptr->menustate = TMS_DHCP_UPD_ADDR_INFO;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}                    
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
   	modify_config_visited = 1;      

		ptr_to_dhcp_addr_range = &struct_address_range;

   	if (client_info_ptr->edit_filter)
		{
			if (cm_get_dhcp_address_range (client_info_ptr->dhcp_tag_number, ptr_to_dhcp_addr_range) == FALSE)
				return ("\n\rInvalid index entered\n\r");

			if (ptr_to_dhcp_addr_range == NULL)
				return ("\n\rInvalid index entered\n\r");

			client_info_ptr->edit_filter = 0;
         switch (cm_edit_dhcp_address_range (ptr_to_dhcp_addr_range, &temp_dhcp_server_info))
			{
			   case CM_DHCP_EDITING_FAILED_IP_IS_BOUND_TO_MAC_ADDRESS:
					printf ("DHCP Editing failed\n");
					break;

			   case CM_DHCP_EDITING_FAILED_TO_GET_OLD_RANGE:
					printf ("Failed to get old range\n");
					break;
			}
			client_info_ptr->next_screen = 0;
			client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
   	   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

		}
      else
		{
      	switch(cm_insert_dhcp_address_range (&temp_dhcp_server_info))
			{
				case CM_DHCP_INSERTION_SUCCESS:
					printf ("Address inserted\n");
					break;

				case CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS:
					return ("\n\rInvalid lower ip adress\n\r");
					break;
				case CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS:
					return ("\n\rInvalid higher ip adress\n\r"); 
/*					printf ("Invalid hogher ip adress\n"); 
					break; */
					
				case CM_DHCP_INSERTION_FAILED_INVALID_SUBNET_MASK:
					return ("\n\rInvalid Subnet Mask\n\r");
/*					printf ("Invalid mask\n");
					break; */
					
				case CM_DHCP_INSERTION_FAILED_INVALID_RANGE:
					return ("\n\rInvalid Address range\n\r");
/*					printf ("Invalid range\n");
					break; */
					
				case CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS_EXCLUDE:
					return ("\n\rInvalid lower exclusion range\n\r");
/*					printf ("Invalid lower exclude\n");
					break; */

				case CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS_EXCLUDE:
					return ("\n\rInvalid higher exclusion range\n\r");
/*					printf ("Invalid higher exclude\n");
					break; */
					
			   case CM_DHCP_INSERTION_FAILED_INVALID_EXCLUSION:
					return ("\n\rInvalid exclusion range\n\r");
/*					printf ("Invalid exclusion\n");
					break; */

			   case CM_DHCP_INSERTION_FAILED_RANGE_DUPLICATION:
					return ("\n\rRange duplication not allowed\n\r");
/*					printf ("range duplication\n");
					break; */
					
				case CM_DHCP_INSERTION_FAILED_OVERLAPING_WITH_OTHER_RANGE_EXCLUSION:
					return ("\n\r Exclusion range overlaps with other ranges\n\r");
/*					printf ("overlapping with other range\n"); 
					break; */
					
				case CM_DHCP_INSERTION_FAILED_INSUFFICIENT_MEMORY:
					printf ("Insufficient memory\n");
					break;

			   case CM_DHCP_EDITING_FAILED_IP_IS_BOUND_TO_MAC_ADDRESS:
					printf ("Editing failed bind\n");
					break;

				case CM_DHCP_EDITING_FAILED_TO_GET_OLD_RANGE:
					printf ("Invalid edit old range\n");
					break;
			}
		}	
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
	else
		return InvalidChoice;
}


BYTE *upd_dhcp_addrress_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT new_value=0;

   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
			case 	DHCP_ADDR_LOWER_BOUND:
				return stat_rt_target;

			case  DHCP_ADDR_UPPER_BOUND:
				return stat_rt_target;

			case  DHCP_SERV_SNET_MASK:
				if (client_info_ptr->edit_filter)
					return ("\n\rSubnet Mask can't be modified.\n\r\
                     Enter Your Choice ( exit or ESC to PREV menu ) : ");
				else
					return stat_rt_mask; 
				
			case  DHCP_EXCLUDE_LOWER_BOUND:
				return stat_rt_target;
				
			case  DHCP_EXCLUDE_UPPER_BOUND:
				return stat_rt_target;
		}									
	}

	new_value = atoi (buffer);
   switch (client_info_ptr->modify_option_rcvd)
   {
		case 	DHCP_ADDR_LOWER_BOUND:
			if (is_an_ip_address (buffer) == FALSE)
				return (InvalidIP);
			
			strcpy (temp_dhcp_server_info.ip_address_lower, buffer);
			break;

		case  DHCP_ADDR_UPPER_BOUND:
			if (is_an_ip_address (buffer) == FALSE)
				return (InvalidIP);
			
			strcpy (temp_dhcp_server_info.ip_address_higher, buffer);
			break;

		case  DHCP_SERV_SNET_MASK:
         if (client_info_ptr->edit_filter)
					return ("\n\rSubnet Mask can't be modified.\n\r\
                    Enter Your Choice ( exit or ESC to PREV menu ) : ");
			else
			  if (validate_subnetmask (buffer) == FALSE)
			   	return ("\n\rInvalid Subnetmask\n\r");

			strcpy (temp_dhcp_server_info.net_mask, buffer);
			break;
	
		case  DHCP_EXCLUDE_LOWER_BOUND:
			if (is_an_ip_address (buffer) == FALSE)
				return (InvalidIP);
			
			strcpy (temp_dhcp_server_info.exclude_ip_address_lower, buffer);
			break;				
				
		case  DHCP_EXCLUDE_UPPER_BOUND:
			if (is_an_ip_address (buffer) == FALSE)
				return (InvalidIP);
			
			strcpy (temp_dhcp_server_info.exclude_ip_address_higher, buffer);
			break;
	}									
   client_info_ptr->menustate = TMS_ADD_DHCP_ADDRESS;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}	
					

BYTE *edit_dhcp_server_address_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT index=0;
	CM_STRUCT_DHCP_RANGE *ptr_to_dhcp_addr_range, struct_address_range;

	if (!buffer)
		return ("\n\rEnter address range index :");

	ptr_to_dhcp_addr_range = &struct_address_range;
	
	index = atoi (buffer);

	if (index == 1)
	{
		client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
		return ("\n\rDefault range can't be modified\n\r");
	}

	if (cm_get_dhcp_address_range (index-1, ptr_to_dhcp_addr_range ) == FALSE)
		return ("\n\rInvalid index entered\n\r");

	if (ptr_to_dhcp_addr_range == NULL)
		return ("\n\rInvalid index entered\n\r");

	client_info_ptr->edit_filter = 1;
	client_info_ptr->dhcp_tag_number = index-1;
		
	strcpy (temp_dhcp_server_info.ip_address_lower, ptr_to_dhcp_addr_range->ip_address_lower);
	strcpy (temp_dhcp_server_info.ip_address_higher, ptr_to_dhcp_addr_range->ip_address_higher);
	strcpy (temp_dhcp_server_info.net_mask, ptr_to_dhcp_addr_range->net_mask);
	strcpy (temp_dhcp_server_info.exclude_ip_address_lower, ptr_to_dhcp_addr_range->exclude_ip_address_lower);
	strcpy (temp_dhcp_server_info.exclude_ip_address_higher, ptr_to_dhcp_addr_range->exclude_ip_address_higher);
	
   modify_config_visited = 1;      

   client_info_ptr->menustate = TMS_ADD_DHCP_ADDRESS;      
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *delete_dhcp_server_address_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT index=0, total_address_ranges=0;
   CM_STRUCT_DHCP_RANGE *ptr_to_dhcp_addr_range,struct_address_range;

	if (!buffer)
		return ("\n\rEnter the Address range index :");

	index = atoi (buffer);
	if (index == 1)
	{
		client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
		return ("\n\rDefault range can't be deleted\n\r");
	}

	total_address_ranges = cm_get_total_number_of_ranges ();
	ptr_to_dhcp_addr_range = &struct_address_range;

	if ((index-1) > total_address_ranges)
		return ("\n\rIndex is wrong\n\r");


	if (cm_get_dhcp_address_range (index-1, ptr_to_dhcp_addr_range) == FALSE)
		return ("\n\rWrong index entered\n\r");

	switch (cm_delete_dhcp_address_range (ptr_to_dhcp_addr_range))
	{
		case CM_DHCP_DELETION_SUCCESS:
			printf ("DHCP server range removed\n");
			break;

		case CM_DHCP_DELETION_RANGE_NOT_FOUND:
			printf ("DHCP server range removal failed\n");
			break;

	   case CM_DHCP_DELETION_FAILED_TRYING_TO_DELETE_DEFAULT:
			return ("\n\rDefault entry can't be removed\n\r");
/*			printf ("DHCP address range failed due to default delete\n");
			break; */
		default:
			printf("Unknown Error\n");
			break;
	}
   modify_config_visited = 1;      
	
	client_info_ptr->next_screen = 0;
	client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *get_dhcp_binding_tag_index (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT number_of_tags=0, index=0;

	if (!buffer)
		return ("\n\rEnter the address range index:");

	client_info_ptr->dhcp_tag_number = atoi (buffer) - 1 ;
	number_of_tags = cm_get_total_number_of_ranges ();

	index = atoi (buffer);

	if (index <= 0)
		return ("\n\rInvalid address range selected\n\r");
	
	if (index == 1)
	{
		client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
		return ("\n\rDefault range can't be binded\n\r");
	}

	if (index > number_of_tags)
		return ("\n\rInvalid address range selected\n\r");

	client_info_ptr->menustate = TMS_DHCP_DISPLAY_BIND_ADDRESS;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}	

void initialize_dhcp_address_binding_parameters ()
{
	temp_dhcp_server_bind_info.ip_address_to_bind[0] = 0;
	temp_dhcp_server_bind_info.mac_address_length =6;
	temp_dhcp_server_bind_info.mac_address_to_bind[0] = 0;
}

BYTE *display_dhcp_address_bindings (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT number_of_bindings=0;
	BYTE index=0;
	CM_STRUCT_DHCP_BIND *ptr_to_address_binding, struct_dhcp_addr_bind;
	BYTE temp_buffer[200];

	ptr_to_address_binding = &struct_dhcp_addr_bind;

	if (!buffer)
	{
		number_of_bindings = cm_get_total_number_of_bindings_in_a_range(client_info_ptr->dhcp_tag_number);

		strcpy (telnet.tx_buffer, BindMainmenu);
		if (number_of_bindings == 0)
		{
			strcat (telnet.tx_buffer, "Enter your choice (A: Add, exit, ESc to previous menu) :");
			return telnet.tx_buffer;
		}
		if (client_info_ptr->next_screen)
		{
			index = client_info_ptr->index;
/*			number_of_bindings -= client_info_ptr->index; */
		}

		while (number_of_bindings)
		{
			if (cm_get_dhcp_binding (client_info_ptr->dhcp_tag_number, index, ptr_to_address_binding) == FALSE)
			{
				client_info_ptr->next_screen = 0;
				break;
			}
			if (ptr_to_address_binding == NULL)
			{
				client_info_ptr->next_screen = 0;
				break;
			}
			index++;  number_of_bindings--;

			sprintf (temp_buffer, "%3d   %-15s   %-12s       %-5d\n\r",
				index, ptr_to_address_binding->ip_address_to_bind,
				ptr_to_address_binding->mac_address_to_bind,
				ptr_to_address_binding->mac_address_length);

			strcat (telnet.tx_buffer, temp_buffer);

			if (index % 10 == 0)
			{
				client_info_ptr->next_screen++;
				client_info_ptr->index = index;
				break;
			}
		}

      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, "); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit, ESC to PREV menu):"); 
   	return telnet.tx_buffer;

#if 0
		strcat (telnet.tx_buffer, "Enter your choice (A: Add, D: Delete, exit, ESC to previous menu) :");
		return telnet.tx_buffer;
#endif
	}

	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
		client_info_ptr->next_screen = 0;
		initialize_dhcp_address_binding_parameters ();
      client_info_ptr->menustate = TMS_ADD_DHCP_ADDRESS_BIND;      
   }

	else if ((*buffer == 'D') || (*buffer == 'd') && (strlen (buffer) == 1))
	{
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_REMOVE_DHCP_ADDRESS_BIND;
	}

	else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
		client_info_ptr->menustate = TMS_DHCP_DISPLAY_BIND_ADDRESS;

	else
		return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_dhcp_bind_info ()
{
	temp_dhcp_server_bind_info.ip_address_to_bind[0] = 0;
	temp_dhcp_server_bind_info.mac_address_length = (BYTE) 0;
	temp_dhcp_server_bind_info.mac_address_to_bind[0] = 0;
}
	
BYTE *add_dhcp_address_bind_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, BindMenu,
			temp_dhcp_server_bind_info.ip_address_to_bind,
			temp_dhcp_server_bind_info.mac_address_length,
			temp_dhcp_server_bind_info.mac_address_to_bind);
		return telnet.tx_buffer;
	}

   client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= IP_ADDRESS_TO_BIND &&
     client_info_ptr->modify_option_rcvd <= MAPPED_MAC_ADDRESS)
	{
      client_info_ptr->menustate = TMS_UPD_BIND_ADDR_INFO;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if (*buffer == 'c'  || *buffer == 'C')
	{
   	modify_config_visited = 1;      
		switch (cm_bind_mac_and_ip_address (client_info_ptr->dhcp_tag_number,&temp_dhcp_server_bind_info)) 
		{
			case CM_DHCP_BINDING_SUCCESS:
				printf ("DHCP address binded successfuly\n");
				break;

			case CM_DHCP_BINDING_FAILED_DUPLICATED_IP_ADDRESS:
				return ("\n\rDuplicate IP adderss not allowed\n\r");
/*				printf ("Binding failed duplicate IP address\n");
				break; */

			case CM_DHCP_BINDING_FAILED_DUPLICATED_MAC_ADDRESS:
				return ("\n\rDuplicate MAC address not allowed\n\r");
/*				printf ("Binding failed, duplicate mac address\n");
				break; */

			case CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS_LENGTH:
				return ("\n\rInvalid MAC address length\n\r");
/*				printf ("Binding failed, invalid mac address length\n");
				break; */

			case CM_DHCP_BINDING_FAILED_MAC_ADDRESS_GREATER_THAN_LENGTH:
				return ("\n\rInvalid MAC address\n\r");
/*				printf ("Binding failed, mac addr length greater\n");
				break; */

			case CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS:
				return ("\n\rInvalid MAC address\n\r");
/*				printf ("Binding failed, invalid MAC address\n");
				break; */

			case CM_DHCP_BINDING_FAILED_INVALID_IP_ADDRESS:
				printf ("Binding failed, invalid IP address\n");
				break;

			case CM_DHCP_BINDING_FAILED_IP_ADDRESS_OUT_OF_RANGE:
				return ("\n\rIP address out of range\n\r");
/*				printf ("Binding failed, out of range IP address\n");
				break; */

			case CM_DHCP_BINDING_FAILED_INSUFFICIENT_MEMORY:
				printf ("Binding failed, insufficient memory\n");
				break;
		}
		client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DHCP_DISPLAY_BIND_ADDRESS;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}
	
BYTE *update_bind_address_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT option=0;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case IP_ADDRESS_TO_BIND:
				return stat_rt_target;
			
			case MAC_ADDR_LENGTH:
				return ("\n\rEnter MAC address length :");
		
			case MAPPED_MAC_ADDRESS:
				return ("\n\rEnter MAC Address :");
		}		
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case IP_ADDRESS_TO_BIND:
			if (is_an_ip_address (buffer) == FALSE)
				return (InvalidIP);

			strcpy (temp_dhcp_server_bind_info.ip_address_to_bind, buffer);
			break;
			
		case MAC_ADDR_LENGTH:
			option = atoi (buffer);
			if (option > 10)
				return InvalidChoice;

			temp_dhcp_server_bind_info.mac_address_length = option;
			break;
		
		case MAPPED_MAC_ADDRESS: /* Changed by Sreelu */

			if (strlen (buffer) > (temp_dhcp_server_bind_info.mac_address_length * 2) )
				return ("\n\rMAC address is wrong\n\r");

			strcpy (temp_dhcp_server_bind_info.mac_address_to_bind, buffer);		
			break;
	}		
   client_info_ptr->menustate = TMS_ADD_DHCP_ADDRESS_BIND;      
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *delete_dhcp_addr_bind_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT number_of_bindings=0, index=0;
	CM_STRUCT_DHCP_BIND *ptr_to_address_binding, struct_dhcp_addr_bind;
	
	if (!buffer)
		return ("\n\rEnter address index to delete :");

	ptr_to_address_binding = &struct_dhcp_addr_bind;

	number_of_bindings = cm_get_total_number_of_bindings_in_a_range(client_info_ptr->dhcp_tag_number);
	index = atoi (buffer);

	if (index > number_of_bindings)
		return ("\n\rIndex entered is invalid\n\r");


	if (cm_get_dhcp_binding (client_info_ptr->dhcp_tag_number, index-1, ptr_to_address_binding) == FALSE)
		return ("\n\rIndex entered is invalid\n\r");

	switch (cm_unbind_mac_and_ip_address (client_info_ptr->dhcp_tag_number, 
		ptr_to_address_binding))
	{
		case CM_DHCP_UNBIND_SUCCESS:
			printf ("Address is unbinded\n");
			break; 
		
		case CM_DHCP_UNBIND_FAILED :
			return ("\n\rUnbinding of address failed\n\r");

		default:
			printf ("Unknown error\n");
			break;
	}

   modify_config_visited = 1;      

	client_info_ptr->next_screen = 0;
	client_info_ptr->menustate = TMS_DHCP_DISPLAY_BIND_ADDRESS;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *dhcp_addr_option_handler (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT total_ranges=0, index=0;

	if (!buffer)
		return ("\n\rEnter the address range index :");

	index = atoi (buffer);
	total_ranges = cm_get_total_number_of_ranges ();

	if ((index-1) > total_ranges)
		return ("\n\rInvalid index entered\n\r");

	if (index <= 0 || index > 100)
		return ("\n\rInvalid index entered\n\r");
	
	client_info_ptr->dhcp_tag_number = index-1;

   client_info_ptr->menustate = TMS_SELECT_OPTION_FOR_RANGE;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

USHORT get_dhcp_option_value_from_index (USHORT index)
{
	USHORT ret_val=0;

	switch (index)
	{
		case (1):
			ret_val = 3;
			break;

		case (2):
			ret_val = 6;
			break;

		case (3):
			ret_val = 15;
			break;

		case (4):
			ret_val = 22;
			break;

		case (5):
			ret_val = 23;
			break;

		case (6):
			ret_val = 26;
			break;

		case (7):
			ret_val = 37;
			break;
		
		case (8):
			ret_val = 51;
			break;
		
		default:
			printf ("Unknown option\n");
			break;
	}

	return ret_val;
}


BYTE *dhcp_select_option_to_address(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
		return DHCPoptionsmenu;

	client_info_ptr->modify_option_rcvd = atoi (buffer);

	client_info_ptr->dhcp_option_value =  get_dhcp_option_value_from_index (client_info_ptr->modify_option_rcvd);

	
	if (client_info_ptr->modify_option_rcvd >= 1 &&
 		client_info_ptr->modify_option_rcvd <= 8)
	{
		client_info_ptr->menustate = TMS_DHCP_DISPLAY_OPTIONS;
   	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}

BYTE *dhcp_display_options_for_address(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT number_of_option_values=0, index=0;
	BYTE temp_buffer[200];
	CM_STRUCT_DHCP_OPTION *ptr_to_dhcp_option, struct_dhcp_addr_option;

	ptr_to_dhcp_option = &struct_dhcp_addr_option;

	if (!buffer)
	{
		number_of_option_values = cm_get_number_of_option_values(client_info_ptr->dhcp_option_value);
		strcpy (telnet.tx_buffer, "\n\r\n\rindex   Option Value\n\r-----   ------------\n\r\n\r");

		while (number_of_option_values)
		{
			if (cm_get_dhcp_range_option_by_option (client_info_ptr->dhcp_tag_number, client_info_ptr->dhcp_option_value, ptr_to_dhcp_option) == FALSE)
				break;

			if (ptr_to_dhcp_option == NULL)
				break;

			number_of_option_values--; index++;

			sprintf (temp_buffer, "%d        %s\n\r", index,ptr_to_dhcp_option->option_value);
			strcat (telnet.tx_buffer, temp_buffer);
		}
      if ( index == 0 )
         strcat (telnet.tx_buffer, "Enter Your Choice (A: ADD, exit or ESC to PREV menu ) :");
      else
		   strcat (telnet.tx_buffer, "Enter your choice (A: Add, D: Delete, E: Edit) :");
		return telnet.tx_buffer;
	}

	if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
	{
		client_info_ptr->edit_filter = 0;
		client_info_ptr->menustate = TMS_ADD_SELECTED_DHCP_OPTION;
   	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if ((*buffer == 'E' || *buffer == 'e') && strlen (buffer) == 1)
	{
		client_info_ptr->menustate = TMS_EDIT_SELECTED_DHCP_OPTION;
   	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1)
	{
		client_info_ptr->menustate = TMS_DELETE_SELECTED_DHCP_OPTION;
   	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}

BYTE *delete_selected_dhcp_option (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT index=0;
	CM_STRUCT_DHCP_OPTION *ptr_to_dhcp_option, struct_dhcp_addr_option;

	ptr_to_dhcp_option = &struct_dhcp_addr_option;

	if (!buffer)
		return ("\n\rEnter the index of option to delete :");

	index = atoi (buffer);
	
	if (cm_get_dhcp_range_option_by_option (client_info_ptr->dhcp_tag_number, client_info_ptr->dhcp_option_value, ptr_to_dhcp_option) == FALSE)
		return ("\n\rInvalid index entered\n\r");

	if (ptr_to_dhcp_option == NULL)
		return ("\n\rInvalid index entered\n\r");

	switch (cm_delete_dhcp_range_option (client_info_ptr->dhcp_tag_number, ptr_to_dhcp_option))
	{
      case CM_DHCP_DELETING_OPTION_FAILED_OPTION_NOT_FOUND:
      case CM_DHCP_DELETING_OPTION_FAILED_CANNOT_DELETE:
			return ("\n\rDeleting of option failed\n\r");
	}
   modify_config_visited = 1;      
	
	client_info_ptr->menustate = TMS_DHCP_DISPLAY_OPTIONS;
  	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *add_selected_dhcp_option_to_address (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *temp_ptr;
	USHORT ret_val=0;
	CM_STRUCT_DHCP_OPTION *ptr_to_dhcp_option, struct_dhcp_addr_option;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case (DHCP_ROUTER_ADDRESS):
				temp_ptr = DHCPRoutermenu;
				break;

			case (DHCP_DNS_SERVER):
				temp_ptr = DHCPDNSseraddr;
				break;

			case (DHCP_DOMAIN_NAME):
				temp_ptr = DHCPDomainname;
				break;

			case (DHCP_REASSEMBLY_SIZE):
				temp_ptr = DHCPreassize;
				break;

			case (DHCP_IP_TTL):
				temp_ptr = DHCPipttl;
				break;

			case (DHCP_MTU):
				temp_ptr = DHCPmtu;
				break;

			case (DHCP_TCP_TTL):
				temp_ptr = DHCPtcpttl;
				break;

			case (DHCP_LEASE_TIME):
				temp_ptr = DHCPleasetime;
				break;
		}
		sprintf (telnet.tx_buffer, temp_ptr, temp_dhcp_option_info.option_value,
					temp_dhcp_option_info.position);
		return telnet.tx_buffer;
	}

	client_info_ptr->temp_modify_option_rcvd  = client_info_ptr->modify_option_rcvd;
	client_info_ptr->modify_option_rcvd = atoi (buffer);


	if ((client_info_ptr->modify_option_rcvd > 0) && 
   	(client_info_ptr->modify_option_rcvd<= 2))
	{
		client_info_ptr->menustate = TMS_DHCP_OPTION_UPD_HDLR;
  		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
	{
   	modify_config_visited = 1;      
		
		if (client_info_ptr->edit_filter)
		{
			ptr_to_dhcp_option = &struct_dhcp_addr_option;
			if (cm_get_dhcp_range_option_by_option (client_info_ptr->dhcp_tag_number, client_info_ptr->dhcp_option_value, ptr_to_dhcp_option) == FALSE)
				return ("Invalid Choice\n\r");

			client_info_ptr->edit_filter = 0;
			ret_val = cm_edit_dhcp_range_option (client_info_ptr->dhcp_tag_number, ptr_to_dhcp_option, &temp_dhcp_option_info); 
		}
		else
			ret_val = cm_insert_dhcp_range_option (client_info_ptr->dhcp_tag_number, &temp_dhcp_option_info);

		client_info_ptr->edit_filter = 0;
		switch (ret_val)
		{
		  	case CM_DHCP_INSERTING_OPTION_SUCCESS:
				break;
			
			case CM_DHCP_INSERTING_OPTION_FAILED_INVALID_DATA:
				printf ("Invalid data not allowed\n");
				break;
	
			case CM_DHCP_INSERTING_OPTION_FAILED_DUPLICATE_ENTRY:
				printf ("Duplicate entries not allowed\n");
				break;

			default:
				printf ("Unknown return value\n");
				break;
		}
		client_info_ptr->menustate = TMS_DHCP_DISPLAY_OPTIONS;
  		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}	

BYTE *upd_selected_dhcp_option_to_address (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT option=0;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case TELNET_DHCP_OPTION_VALUE:
				return ("\n\rEnter option value :");
			
			case TELNET_DHCP_OPTION_POSITION:
				return ("\n\rEnter option position :");
		}
	}

	option = atoi (buffer);
	temp_dhcp_option_info.option = client_info_ptr->dhcp_option_value;
	switch (client_info_ptr->modify_option_rcvd)
	{
		case TELNET_DHCP_OPTION_VALUE:
			switch (client_info_ptr->dhcp_option_value)
			{
				case 3:
					if (is_an_ip_address (buffer) == FALSE)
						return (InvalidIP);
					break;

				case 6:
					if (is_an_ip_address (buffer) == FALSE)
						return (InvalidIP);
					break;

			   case	15:
					if (strlen (buffer) > 40)
						return InvalidChoice;
					break;

				case 22:
					if (option > MAX_PORT_NUMBER)
						return InvalidChoice;
					break;

				case 23:
					if (option > 255)
						return InvalidChoice;
					break;

				case 26:
					if (option > MAX_PORT_NUMBER)
						return InvalidChoice;
					break;

				case 37:
					if (option > 255)
						return InvalidChoice;
					break;

				case 51:
					if (strlen(buffer) > 10)
						return InvalidChoice;
					break;

			}
			strcpy (temp_dhcp_option_info.option_value, buffer);
			break;
			
		case TELNET_DHCP_OPTION_POSITION:
			temp_dhcp_option_info.position = atoi (buffer);
			break;
	}
	client_info_ptr->modify_option_rcvd  = client_info_ptr->temp_modify_option_rcvd;
	client_info_ptr->menustate = TMS_ADD_SELECTED_DHCP_OPTION;
  	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *edit_selected_dhcp_option_to_address (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT number_of_option_values=0, index=0;
	CM_STRUCT_DHCP_OPTION *ptr_to_dhcp_option, struct_dhcp_addr_option;

	ptr_to_dhcp_option = &struct_dhcp_addr_option;
			
	if (!buffer)
		return ("\n\rEnter the option index :");

	index = atoi (buffer);
	number_of_option_values = cm_get_number_of_option_values(client_info_ptr->dhcp_option_value);
	

	if (index > number_of_option_values)
		return ("\n\rInvalid index entered\n\r");

	if (cm_get_dhcp_range_option_by_option (client_info_ptr->dhcp_tag_number, client_info_ptr->dhcp_option_value, ptr_to_dhcp_option) == FALSE)
		return ("\n\rInvalid index entered\n\r");
		

	strcpy (temp_dhcp_option_info.option_value, ptr_to_dhcp_option->option_value);
	temp_dhcp_option_info.position = ptr_to_dhcp_option->position;
	temp_dhcp_option_info.option = ptr_to_dhcp_option->option;
	
	client_info_ptr->edit_filter = 1;
	client_info_ptr->menustate = TMS_ADD_SELECTED_DHCP_OPTION;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Added by Sreelu */	


BYTE *modify_dhcp_main_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{				
	ULONG new_value = 0;
   BYTE dhcp_enable[10] , *new_rhs;

   if(!buffer)	
   {
    switch(client_info_ptr->modify_option_rcvd)
    {
      case DHCP_SERVER_ENABLE :
	      return(EnaOrDis);
  	      break;	
	   case ADD_RANGE :
         client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
         client_info_ptr->next_screen=0;
         return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr , NULL ));
	   default :	
	   	sprintf(telnet.tx_buffer, EnterProperChoice, 
		   	menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
    }

  }
   new_value = atoi(buffer);

	switch (client_info_ptr->modify_option_rcvd)	
   {
 	  case DHCP_SERVER_ENABLE :
         if (new_value == 1)
            new_rhs = telnet_enabled_str;
         else
            if (new_value == 2)
   	         new_rhs = telnet_disabled_str;
            else
   	         return (InvalidChoice);

         switch(set_parameter_by_name (CM_DHCP_SECTION, "DHCP Server", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
         {
      	   case CM_NOT_ENOUGH_MEMORY:
      		   return Insufficient_memory;
         }
         break;  
     case ADD_RANGE :
         get_parameter_by_name (CM_DHCP_SECTION, "DHCP Server", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)dhcp_enable, 10); 
         if(strcmp(dhcp_enable,telnet_disabled_str) == 0)
            return("\n\rDHCP Server is not Enabled.\n\rEnter Esc to the PRV menu.");
         else
            client_info_ptr->menustate = TMS_MODI_DHCP_INFO;
            client_info_ptr->next_screen = 0;
            return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr , NULL ));
         break;
     default :
		   sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
   		return(telnet.tx_buffer);
   }
   modify_config_visited = 1;
   client_info_ptr->menustate = TMS_MODI_MAIN_DHCP;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *dhcp_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
  	{
		initialize_replystr ();

		get_parameter_by_name (CM_DHCP_SECTION,"DHCP Server",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10); 
      
      sprintf (ChoiceBuffer, 	EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);

      sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0],
			GoBack, ChoiceBuffer);
		return (telnet.tx_buffer);
	}
		
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd < 1) ||
		 (client_info_ptr->modify_option_rcvd >
				menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	else
	{
		client_info_ptr->menustate = TMS_MODI_UPD_MAIN_DHCP;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}	
