#include	<defs.h>

#include	<stdlib.h>
#include	<stdio.h>
#include <string.h>

#include	"telnet.h"
#include	"vmenu.h"

#if 0
#include "..\..\store\boot.h" 
#endif

/* Added by Sreelu */
#include "\rtrware\devdrvrs\script\scrtutls.h"



#include "..\..\stacks\ip\karp.h"
#include "..\..\stacks\ip\kip.h"
#include "..\..\stacks\ip\kipuser.h"
#include "..\..\stacks\ip\varpuser.h"
#include "..\..\stacks\ip\varpstr.h"
#include "..\..\stacks\ip\vrarpusr.h"
#include "..\..\stacks\ip\vrarpstr.h"
#include "..\..\stacks\ip\kroute.h"	  
#include "..\..\stacks\ip\viprtstr.h"	  
#include "..\..\stacks\ip\vipusstr.h"  
#include "..\..\stacks\ip\vsktstr.h"
#include "..\..\stacks\ip\kudp.h"
#include "..\..\stacks\ip\vipktstr.h"
#include "..\..\stacks\ip\kicmp.h"
#include "..\..\stacks\ip\vudpuser.h"
#include "..\..\stacks\ip\vudpbuf.h"
#include "..\..\stacks\ip\vudpstr.h"
#include "..\..\stacks\ip\krip.h"
#include "..\..\stacks\ip\vripstr.h"
#include "..\..\stacks\ip\vicmpstr.h"
#include "..\..\stacks\ip\viprastr.h"
#include "..\..\stacks\ip\vipstr.h" 
#include "..\..\stacks\ip\ipfilt.h"

/*	sudhir 5-10-96 */
#include "..\..\stacks\ip\vip.h"
/* sudhir 5-10-96 */


#include <incall.h>
#include <cfgmgr.h>

/* Added by sreelu */
extern BYTE tcp_application_list[],udp_application_list[],DHCP_InvalidEnable[];
extern BYTE *my_itoa (long number, BYTE *buf, int radix) ;
/* Added by Sreelu */

extern int modify_config_visited;
extern BYTE is_lan_port(USHORT port_number);

PARAMETER_NODE *ptr_to_current_node;
enum internet_gateway_ports {INTERNET_LAN_IS_GATEWAY = 1, WAN_IS_GATEWAY};

#define	ICMP_PROTOCOL	  1
#define	TCP_PROTOCOL	  6
#define	UDP_PROTOCOL	  17
#define	ARP_PROTOCOL	  34
#define	IP_PROTOCOL		  35

/* Added By Ravi on 03 Nov 1998 ... */
#define TCP_UDP_PROTOCOL  50 	
/* ... Added By Ravi on 03 Nov 1998 */


extern	TCP_CLASS	tcp;
extern	IP_CLASS	ip;
extern   DHCP_CLASS dhcp;
extern	IP_FILTER_DEFAULT_ACTION	ip_filter_default_action;
extern	IP_FILTERING_ENTRY *sptr_ip_src_filter_chain, *sptr_ip_dest_filter_chain;
extern 	int frame_relay_enabled;  	/* oss on 3-3-97 */
extern 	int no_of_ip_ports;			/* oss on 3-3-97 */
extern   ULONG dot2ulong(BYTE* ip_address_in_dot_format);


void force_write_string (BYTE *, BYTE *, ULONG , BYTE *);

/* sudhir 5-10-96 */
extern int toupper (int);
enum BOOLEAN is_default_route_valid (ULONG);

/* sudhir */
extern BYTE *net_to_str (BYTE *Addr, ULONG Address);
extern BYTE *get_port_type (USHORT port_type);


BYTE *get_ip_address_str (BYTE *buf, USHORT port_number);
int get_number_of_ip_ports();

void	generate_no_of_ip_ports_strings(int value);
void	initialize_values_of_new_ip_port();

void	generate_no_of_ports_strings(int no_of_ports, int section_id);
void	add_delete_values_of_ip_port(int Flag, int PortNo);

int num_of_ip_ports = 2;
/* added by oss on 28-3-97 */
#define OFFSET_TO_RHS 3
#define OFFSET_OF_PORT_STATS 5
#define PTR_TO_PORT_NO 2

PARA_STR *test_linked_list (PARA_STR *);

BYTE *to_upper_string (BYTE *);
ULONG str_to_net(BYTE *);

BYTE ChoiceBuffer[80];

/* sudhir 3/4/97 */
STRUCT_IP_ADDRESS_FILTER dup_ip_addr_filter;
STRUCT_IP_ADDRESS_FILTER *dummy_ip_addr_filter;
STRUCT_IP_ADDRESS_FILTER temp_ip_addr_filter;

STRUCT_IP_PORT_FILTER dup_ip_port_filter;
STRUCT_IP_PORT_FILTER *dummy_ip_port_filter;
STRUCT_IP_PORT_FILTER temp_ip_port_filter;
STRUCT_STATIC_ROUTE temp_static_route;

STRUCT_IP_ICMP_FILTER tel_ip_icmp_filter;
STRUCT_IP_ICMP_FILTER *old_ip_icmp_filter;

extern BYTE is_an_ip_address(BYTE* address);
BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);

/* Added by Sreelu */
extern BYTE local_ip_address_and_remote_ip_address_on_same_network(BYTE* isp_ip_address,BYTE* buffer,BYTE* isp_subnet_mask);

/* extern DNS_CLASS dns;  */

extern void  delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr);
extern void  modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr);
extern BYTE  *get_rhs_from_linked_list(BYTE *lhs_para_str, ULONG PortNo, PARA_STR *starting_addr);
extern BYTE  *get_rhs_for_disp (ULONG offset, CONFIGURATION_TABLE configuration_table, ULONG PortNo, PARA_STR *starting_addr);
extern void  set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr,
										BYTE *new_rhs);
extern PARA_STR *search_for_string (BYTE *lhs_para_str, BYTE *rhs_string, PARA_STR *start_addr);
extern void force_write_string_with_port_num (BYTE *, ULONG , BYTE *, PARA_STR *);
extern BYTE *copy_to_temp_struct(BYTE *buffer, BYTE *char_array);

/* sudhir 5-10-96 */


BYTE *get_ip_port_type (USHORT port_type)
{
	switch (port_type) 
   {
		case 0:	return ("SECURED LAN ");
		case 1:  return ("INTERNET LAN");
		case 2:  return ("WAN         ");
		default: return ("Unknown     ");
	}
}


static BYTE * ip_protocol_string (USHORT_ENUM (IP_PORT_FILTER_PROTOCOL) protocol)
{
	switch (protocol) {
      case PROTOCOL_TCP:
		   return ("TCP");
      case PROTOCOL_UDP:
		   return ("UDP");
		default: return ("Unknown");
	}
}

static BYTE * ip_fd_entry_port_string (USHORT_ENUM (FILTER) entry_type)
{
	switch (entry_type) 
   {
      case FILTER_ON_SOURCE: return ("Filter on source port");
		case FILTER_ON_DESTINATION: return ("Filter on destination port");
		case FORWARD_ON_SOURCE: return ("Forward on source port");
		case FORWARD_ON_DESTINATION: return ("Forward on destination port"); 
      default: return ("Invalid");
   }
}


static BYTE * ip_fd_entry_addr_string (USHORT_ENUM (FILTER) entry_type)
{
	switch (entry_type) 
   {
		case FILTER_ON_SOURCE: return ("Filter on source address");
		case FORWARD_ON_SOURCE: return ("Forward on source address");
		case FILTER_ON_DESTINATION: return ("Filter on destination address");
		case FORWARD_ON_DESTINATION: return ("Forward on destination address"); 
		default:return ("Invalid");
	}
}

static enum BOOLEAN	ip_add_filt_entry_to_buffer (IP_FILTERING_ENTRY *sptr_ip_fdt_entry, BYTE index, BYTE filter_type)
{
	BYTE	tmp_buffer[81];

	if (filter_type == IP_FILTER_ADDR)
	{
		switch (sptr_ip_fdt_entry->type)
		{
			case IP_FILTER_ON_SOURCE_ADDRESS: 
			case IP_FORWARD_ON_SOURCE_ADDRESS: 
			case IP_FILTER_ON_DESTINATION_ADDRESS: 
			case IP_FORWARD_ON_DESTINATION_ADDRESS:
				sprintf(tmp_buffer, "%3d. %-15s ---------------  %2d  %s\n\r", 
					index,
					convert_ip_address_to_dot_format(&ReplyStrs[0].ReplyStr[0], sptr_ip_fdt_entry->lower_end.ip_address),
					sptr_ip_fdt_entry->port,
					ip_fd_entry_addr_string (sptr_ip_fdt_entry->type));
				break;					

			case IP_FILTER_ON_SOURCE_RANGE: 
			case IP_FILTER_ON_DESTINATION_RANGE: 
			case IP_FORWARD_ON_SOURCE_RANGE: 
			case IP_FORWARD_ON_DESTINATION_RANGE: 
				sprintf(tmp_buffer, "%3d. %-15s %-15s  %2d  %s\n\r", 
					index,
					convert_ip_address_to_dot_format(&ReplyStrs[0].ReplyStr[0], sptr_ip_fdt_entry->lower_end.ip_address),
					convert_ip_address_to_dot_format(&ReplyStrs[1].ReplyStr[0], sptr_ip_fdt_entry->higher_end.ip_address),
					sptr_ip_fdt_entry->port,
					ip_fd_entry_addr_string (sptr_ip_fdt_entry->type));
				break;
			default:
				return(FALSE);
		}
	}
	else if (filter_type == IP_FILTER_PORT)
	{
		switch (sptr_ip_fdt_entry->type)
		{
			case IP_FILTER_ON_SOURCE_PORT: 
			case IP_FILTER_ON_DESTINATION_PORT: 
			case IP_FORWARD_ON_SOURCE_PORT: 
			case IP_FORWARD_ON_DESTINATION_PORT: 
				sprintf(tmp_buffer, "%3d.  %-8s      %04d        %2d    %s\n\r", 
					index,
					ip_protocol_string(sptr_ip_fdt_entry->lower_end.protocol_port.protocol),
					sptr_ip_fdt_entry->lower_end.protocol_port.port_number,
					sptr_ip_fdt_entry->port,
					ip_fd_entry_addr_string (sptr_ip_fdt_entry->type));
				break;
			default:
				return(FALSE);
		}
	}
	else 
	{
		return(FALSE);
	}
	strcat(telnet.tx_buffer, tmp_buffer);
	return(TRUE);
}


BYTE *modify_dns_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
#if 1
	if (!buffer)
	{
		initialize_replystr ();
   
      get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 20);				

#if 0		/* sri */
      get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address2",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);				
#endif	/* sri */


		sprintf (ChoiceBuffer, EnterChoice, 1);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], 
			GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd <= 1) && 
		(client_info_ptr->modify_option_rcvd >= 1))
	{
		client_info_ptr->menustate = TMS_DNS_UPD_PARA;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
#endif
}

BYTE *update_dns_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
#if 1
	BYTE *ret_str, *new_rhs ;
	ULONG new_value, port_no;
 	
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_DNS_ROOT_ADDR:				
            ret_str = NewValue;
            break;

#if 0		/* sri */
			case MOD_DNS_LOCAL_ADDR:
            ret_str = NewValue;
            break;
#endif	/* sri */

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}
	port_no = NOT_PORT_PARAMETER;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_DNS_ROOT_ADDR:
         new_rhs = buffer;			
         if (validate_ip_address (buffer) == FALSE)
            return InvalidIP;

         switch (set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

#if 0		/* sri */
		case MOD_DNS_LOCAL_ADDR:
         new_rhs = buffer;
         if (validate_ip_address (buffer) == FALSE)
            return InvalidIP;
         switch (set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address2",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;  
#endif	/* sri */

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
   client_info_ptr->menustate =  TMS_DNS_MODI_PARA;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
#endif
}
/* sudhir 22-9-96*/

BYTE *modify_dhcp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();
		get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.dhcp_client_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);   /* Changed by Sreelu */				

		get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.relay_agent_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 10);				

		get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[2].ReplyStr[0], 20);				

		sprintf (ChoiceBuffer, EnterChoice, 3);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0], &ReplyStrs[2].ReplyStr[0],
			GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd >= 1) && 
		(client_info_ptr->modify_option_rcvd <= 
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_DHCP_UPD_PARA;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *update_dhcp_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs ,dhcp_rel_enbl[10];
	ULONG new_value, port_no;
 	
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_DHCP:				
			case MOD_DHCP_REL_AGT:		ret_str = EnaOrDis;
												break;
			case MOD_DHCP_SER_IP_ADD:	
                  /* Added by Sreelu */
         
#if 0
         get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.relay_agent_enabled,
         	0, CM_STRING_FORMAT, &dhcp_rel_enbl[0],10);
         
         if(strcmp(dhcp_rel_enbl,telnet_enabled_str) != 0 ) 
           strcpy(ret_str,"\n\rInvalid IP Address!\n\rDHCP Relay Agent is disabled :\n\rEnter (exit , ESC to previous menu ):");
         else
#endif
         ret_str = NewValue;
			break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}
	port_no = NOT_PORT_PARAMETER;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_DHCP:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
				else
					return (InvalidChoice);
			
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.dhcp_client_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))      /* Changed by Sreelu */
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_DHCP_REL_AGT:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.relay_agent_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;  

		case MOD_DHCP_SER_IP_ADD:
			new_rhs = buffer;
         /* Added by Sreelu */

         get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.relay_agent_enabled,
         	0, CM_STRING_FORMAT, &dhcp_rel_enbl[0],10);

         if(strcmp(dhcp_rel_enbl,telnet_enabled_str) == 0 ) 
        {
			switch (set_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
        }
        else
        {
        strcpy(new_rhs,"0.0.0.0");
        set_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address,
           CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs);
        }

		  break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_DHCP_MODI_PARA;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*ip_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer) 
		return (menufsmhdlr[client_info_ptr->menustate].menu);

 	switch (atoi(buffer)) 
   {
 		case IP_GEN_INFO:			
			client_info_ptr->menustate = TMS_MODI_IP;
			break;

#if 0		/* Sri */
 		case IP_STATS:				
			client_info_ptr->menustate = TMS_IPSTAT;
			break;

 		case IP_TCP:				
			client_info_ptr->menustate = TMS_IPTCP;
			break;

/* 		case IP_RIP:				
			client_info_ptr->menustate = TMS_IPRIP;
			break; */

 		case IP_ARP:				
			client_info_ptr->menustate = TMS_IPARP;
			break;

 		case IP_RARP:				
			client_info_ptr->menustate = TMS_IPRARP;
			break;

 		case IP_ICMP:				
			client_info_ptr->menustate = TMS_IPICMP;
			break;

 		case IP_UDP:				
			client_info_ptr->menustate = TMS_IPUDP;
			break;

 		case IP_FILTER_TABLE:

/*         client_info_ptr->menustate = TMS_NULL_FUNC;
         menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_IPMAIN;

         return (not_supported);						 */
#ifdef IP_FILTERING
			client_info_ptr->menustate = TMS_IPFILTER;
#endif
			break;
#endif 	/* Sri */

/* 		case IP_RIP_TABLE:		
			client_info_ptr->menustate = TMS_IPNW;
			break; */

 		case IP_PORT:				
			client_info_ptr->menustate = TMS_MODI_IPPORT;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_ip_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
#define LAN_2 1
	BYTE IPF_def[] = "IP Filtering Default Action";
	BYTE IP_defrt[] = "IP Default Route";
   BYTE address[IP_ADDRES_LENGTH];
   ULONG value;

	if (!buffer)
	{
		initialize_replystr ();
#if 0
		get_parameter (CM_IP_SECTION, (void *) &ip.mib.ipDefaultTTL ,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void *)&ReplyStrs[0].ReplyStr[0], 10);				
#endif
		/* Added by Ravi on 30 Oct ... */
		get_parameter_by_name (CM_DHCP_SECTION, "DHCP Host Name",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void *)&ReplyStrs[0].ReplyStr[0], 50);				
		/* ... Added by Ravi on 30 Oct */
	
      /* Check whether the DHCP Client is Enabled or Not */
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, 
           client_info_ptr->menu_selected_port,CM_STRING_FORMAT, (void *)&ReplyStrs[1].ReplyStr[0], 10);

#if 0			/* commented by Sreelu */
		get_parameter_by_name (CM_IP_SECTION, IPF_def,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[2].ReplyStr[0], 10);				

      if (!ReplyStrs[1].ReplyStr[0])
         strcpy (&ReplyStrs[1].ReplyStr[0], "forward");

		get_parameter_by_name (CM_IP_SECTION, IP_defrt,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[3].ReplyStr[0],	10);				

		get_parameter (CM_IP_SECTION, (void *) &ip.mib.ipReasmTimeout,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[4].ReplyStr[0], 10);				
#endif

		get_parameter_by_name (CM_IP_SECTION, IP_defrt,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[3].ReplyStr[0],	10);				

      get_parameter(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&ReplyStrs[4].ReplyStr[0], 10);

      get_parameter(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&ReplyStrs[5].ReplyStr[0], 10);

#if 0
      if (get_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value, 0) == CM_GET_SUCCESSFUL)
      {
         /* Check whether the port is Internet LAN port or WAN */
         if (value == (BYTE)INTERNET_LAN_IS_GATEWAY)
         {
            /* Get the Internet Gateway Address */
            get_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&address, IP_ADDRES_LENGTH);
            strcpy(&ReplyStrs[6].ReplyStr[0], address);
         }
         else
         {
            strcpy(&ReplyStrs[6].ReplyStr[0], "0.0.0.0");
         }
      }
      			
      strcpy(&ReplyStrs[7].ReplyStr[0], "");
#endif
		sprintf (ChoiceBuffer, 	EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0], 
			&ReplyStrs[3].ReplyStr[0],
         &ReplyStrs[4].ReplyStr[0],&ReplyStrs[5].ReplyStr[0],
			GoBack, ChoiceBuffer);

		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;

/*	if (client_info_ptr->modify_option_rcvd == IP_STATIC_ROUTE)
	{
		client_info_ptr->menustate = TMS_IP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else */

  /*	if (client_info_ptr->modify_option_rcvd == IP_IGWAY_ADDRESS)
	{
		client_info_ptr->menustate = TMS_GATEWAY_MODI;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
   else*/

	if ((client_info_ptr->modify_option_rcvd >= DHCP_HOST_NAME) && 
		(client_info_ptr->modify_option_rcvd <= IP_DNS_INFO))
	{
		client_info_ptr->menustate = TMS_IP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
#undef LAN_2
}


BYTE *ip_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str, *new_rhs, *ptr_to_metric,dhcp_rel_enbl[10],temp_buf;
	ULONG  new_value, value, k = 0;
	BYTE ip_fid[] = "IP Filtering Default Action";
	BYTE ip_defr[] = "IP Default Route";
   /*BYTE *buf,*temp;*/

	if(!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
/*			case IP_STATE:				
            ret_str = EnaOrDis;
				break; */

/*			case  IP_DEFAULT_TTL:	*/
/*			case IP_RIP_RESPONSE:
			case  IP_RIP_AGE_TIME:	 */
/*			case  IP_REAS_TIMOUT:	
            ret_str = NewValue;
				break;					*/

			case DHCP_HOST_NAME:
				  ret_str = NewValue;		
				  break;

/*sri			case  IP_DEFAULT_ACTION:
            ret_str = ForOrFilt;
				break; */

			case  IP_DEFAULT_GWAY:	
            ret_str = Default_Route;
				break;

         case DHCP_CLIENT:
				ret_str = EnaOrDis; /* Added by Sreelu */
				break;

         case DHCP_RELAY_AGENT:
				ret_str = EnaOrDis;
				break;

         case DHCP_SERVER_IP_ADDRESS:  /* Changed by Sreelu */

            get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.relay_agent_enabled,
            	CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dhcp_rel_enbl[0],10);

            if(strcmp(dhcp_rel_enbl,telnet_enabled_str) != 0 ) 
            {
              set_parameter (CM_DHCP_SECTION, (void*) &dhcp.config.server_ip_address,
                 CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, "0.0.0.0");
              ret_str = DHCP_InvalidEnable;
            }
            else
               ret_str = NewValue;
               break;            

         case IP_IGWAY_ADDRESS:
            /* ret_str = NewValue; */

/* Added by Sreelu */
				client_info_ptr->menustate = TMS_GATEWAY_MODI;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
            break;            

/*			case  IP_DHCP_INFO:
				client_info_ptr->menustate =  TMS_DHCP_MODI_PARA;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); */

         case  IP_STATIC_ROUTE:
            client_info_ptr->next_screen = 0;
            client_info_ptr->menustate =  TMS_IP_STATIC_RT;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
            
         case  IP_DNS_INFO:
            client_info_ptr->menustate =  TMS_DNS_MODI_PARA;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 

 			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
/*		case IP_STATE:
			if (new_value == 1)
				new_rhs = telnet_enabled_str;
			else if (new_value == 2)
				new_rhs = telnet_disabled_str;
			else
				return (InvalidChoice);
            
			switch (set_parameter_by_name (CM_IP_SECTION, "IP",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break; */

/* Added by Ravi on 30 Oct 1998 ... */
		case DHCP_HOST_NAME:
			if (strlen (buffer) > 50)
				return (InvalidChoice);
         new_rhs = buffer;
			switch (set_parameter_by_name (CM_DHCP_SECTION, "DHCP Host Name" ,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,new_rhs))			
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
/* ... Added by Ravi on 30 Oct 1998 */
		

      case DHCP_CLIENT:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.dhcp_client_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
         break;

      case IP_IGWAY_ADDRESS:
#if 0
         new_rhs = buffer;
         
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.internet_gateway_address,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
         if (dot2ulong(new_rhs))
            value = 1;
         else
            value = 2;
         set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
#endif


			break;
#if 0
		case IP_DEFAULT_TTL :
         new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.mib.ipDefaultTTL,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return (wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
#endif
#if 0		
		case IP_RIP_RESPONSE:
         new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.rip.config.update_time_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

      case IP_RIP_AGE_TIME:
         new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.rip.config.route_aging_timeout_value,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
#endif

#if 0
		case IP_REAS_TIMOUT :
         new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.mib.ipReasmTimeout,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		case IP_DEFAULT_ACTION:
         new_rhs = buffer;
			if (new_value == 1)
				new_rhs = Forward;
			else
				if (new_value == 2)
					new_rhs = Filter;
			else
				return (InvalidChoice);

			switch (set_parameter_by_name (CM_IP_SECTION, ip_fid,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
#endif

      case DHCP_RELAY_AGENT:

			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
            {
					new_rhs = &telnet_disabled_str[0];
               set_parameter (CM_DHCP_SECTION, (void*) &dhcp.config.server_ip_address,
                  CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, "0.0.0.0");
            }
			else
				return (InvalidChoice);
         
			switch (set_parameter (CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
         break;

      case DHCP_SERVER_IP_ADDRESS:
         new_rhs = buffer;   

         /* Added by Sreelu */

         get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.relay_agent_enabled,
         	CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dhcp_rel_enbl[0],10);

         if(strcmp(dhcp_rel_enbl,telnet_enabled_str) != 0 ) 
         {    
            set_parameter (CM_DHCP_SECTION, (void*) &dhcp.config.server_ip_address,
               CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, "0.0.0.0");
         }
         else
         {
          if(!strcmp(buffer,"0.0.0.0")) /* Added by Sreelu */
              return(InvalidIP);
          else
			   switch (set_parameter (CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address,
				  CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			   {
				  case CM_ERROR_WHILE_VALIDATING:
				   	return InvalidIP;

			     case CM_NOT_ENOUGH_MEMORY:
				   	return Insufficient_memory;
			   }
         }
         break;

		case IP_DEFAULT_GWAY:
			ptr_to_metric = strchr (buffer, ',');
			if (ptr_to_metric == NULL)
				return (use_pro_format);
         
         new_rhs = buffer;

         if(!strcmp(buffer,"0.0.0.0"))
             return(InvalidIP);
         else
         {
			   switch (set_parameter_by_name (CM_IP_SECTION, ip_defr,
				  CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			   {
				  case CM_ERROR_WHILE_VALIDATING:
				   	return wrong_value;

				  case CM_NOT_ENOUGH_MEMORY:
				   	return Insufficient_memory;

			   }
         }
			break;
		
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   return(telnet.tx_buffer);
		}
	modify_config_visited = 1 ; 

	client_info_ptr->menustate = TMS_MODI_IP;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Added by Sreelu */

BYTE *modify_gateway_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	 ULONG port_num;

    if(!buffer)
	 {
      get_parameter_by_name (CM_IP_SECTION, "IP Internet Gateway Port",	    
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT,&port_num, 10);					    
      get_parameter_by_name (CM_IP_SECTION, "IP Internet Gateway Address",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);					   

		if(port_num == 1)
			strcpy(&ReplyStrs[0].ReplyStr[0],lan_str);		   
		if(port_num == 2)
			strcpy(&ReplyStrs[0].ReplyStr[0],wan_str);		   

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0]);
			
		return (telnet.tx_buffer);
	 }
	 client_info_ptr->modify_option_rcvd = atoi(buffer);
	 if ((client_info_ptr->modify_option_rcvd >= 1) && 
		(client_info_ptr->modify_option_rcvd <= 
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_GATEWAY_UPD_PARA;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

/* Added by Sreelu */

BYTE *update_gateway_info(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	  BYTE *ret_str,*new_rhs,dhcp_enbl[10];
	  ULONG new_value,port_num;

     get_parameter_by_name (CM_IP_SECTION, "IP Internet Gateway Port",	    
	    CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT,&port_num, 10);					    
     get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.dhcp_client_enabled,
	    client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&dhcp_enbl[0], 10);   /* Changed by Sreelu */				


	  if (!buffer)
	  {
		 switch (client_info_ptr->modify_option_rcvd)
		 {
		   case MOD_GATEWAY_PORT :
 			     ret_str = LanOrWan;
				  break;
			case LAN_GATEWAY_ADD:
				  if(port_num == 1 && (strcmp(dhcp_enbl,telnet_disabled_str) == 0))
				     ret_str = NewValue;
				  else
				  {
					strcpy(new_rhs,"0.0.0.0");
					set_parameter_by_name (CM_IP_SECTION, "IP Internet Gateway Address",
						CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs);
               return("\n\rInvalid Choice!\n\rEnter ESC to PRV Menu :");
				  }
				  break;
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		 }
		return (ret_str);			      
	  } 
	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_GATEWAY_PORT:
	      new_value = atoi(buffer);
			switch (set_parameter_by_name (CM_IP_SECTION, "IP Internet Gateway Port",
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &new_value))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		case LAN_GATEWAY_ADD:
			new_rhs = buffer;
			if(!is_an_ip_address(buffer) || !strcmp(buffer,"0.0.0.0"))
			   return(InvalidIP);

			switch (set_parameter_by_name (CM_IP_SECTION, "IP Internet Gateway Address",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
	  	   break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	} /* End of Switch */
	modify_config_visited = 1 ; 
   client_info_ptr->menustate =  TMS_GATEWAY_MODI;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}												


BYTE	*modify_ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

   frame_relay_enabled = 0;

	if (!buffer)
	{
		if (frame_relay_enabled)	/* added by oss on 3-3-97 */
		{
			generate_no_of_ports_strings(no_of_ip_ports, IP_ID);
			return (telnet.tx_buffer);
		}
		generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
		return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);

	if (frame_relay_enabled) /* added by oss on 3-3-97 */
	{
		if (port_number == no_of_ip_ports + 1)
		{
			return not_supported;

			if (no_of_ip_ports >= MAX_NUM_OF_PORTS)
				return (MAX_16_ports);
			no_of_ip_ports ++;
			add_delete_values_of_ip_port(0, no_of_ip_ports);
			client_info_ptr->menu_selected_port = port_number - 1; 
		 	client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if (port_number == no_of_ip_ports + 2)
		{
			return not_supported;

			client_info_ptr->menustate = TMS_IP_DELETE_PORT;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if ((port_number > no_of_ip_ports) || (port_number < 1)) 
		{
			sprintf(telnet.tx_buffer, EnterProperChoice, no_of_ip_ports);
			return(telnet.tx_buffer);
		}
		else
		{
			client_info_ptr->menu_selected_port = port_number - 1; 
		 	client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
	}

	if (port_number > telnet.number_of_ports ||	port_number < 1)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, telnet.number_of_ports);
		return(telnet.tx_buffer);
	}
 	client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
	client_info_ptr->menu_selected_port = port_number - 1; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ip_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG port_no;
	BYTE ip_frame[] = "IP Port Frame Type";
	BYTE temp_buff[300];

	port_no = client_info_ptr->menu_selected_port + 1;
	if (!buffer)
	{
		initialize_replystr ();

		if (!is_lan_port(client_info_ptr->menu_selected_port))
		{
			strcpy (temp_buff, "**This should be 0.0.0.0 if the IP address is to be assigned by ISP\n\r");
			strcat (temp_buff, GoBack );
		}
		else
		{
			strcpy (temp_buff, GoBack );
		}

		get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 20);	 
		get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);

		sprintf (ChoiceBuffer, 	EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port+1,
		   &ReplyStrs[0].ReplyStr[0],	&ReplyStrs[1].ReplyStr[0],
			temp_buff, ChoiceBuffer); 
		return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= MOD_IP_NODE_ADDRESS) &&
			(client_info_ptr->modify_option_rcvd <=
			 menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_IPPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}

BYTE *upd_modify_ip_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str, *new_rhs;
	ULONG  new_value, port_no;
	BYTE IP_frame[] = "IP Port Frame Type",dhcp_str[10];

	port_no = client_info_ptr->menu_selected_port + 1;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_IP_SUBNETMASK:		  /* Added by Sreelu */
            if(port_no != 2)
              ret_str = NewValue;
            else
            {
              get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.dhcp_client_enabled,
                 			client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&dhcp_str[0], 10);

              if(strcmp(dhcp_str,telnet_enabled_str) != 0 )
                 ret_str = NewValue;
              else
              {
                 ret_str = InvalidChoice;
                 strcat(ret_str,"\n\rDHCP Client is Enabled:");
              }
            } 
				break;

			case MOD_IP_NODE_ADDRESS: /* Added by Sreelu */

            if(port_no != 2)
               ret_str = NewValue;
            else
            {
              get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.dhcp_client_enabled,
                 			client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&dhcp_str[0], 10);

              if(strcmp(dhcp_str,telnet_enabled_str) != 0 )
                 ret_str = NewValue;
              else
              {
                 ret_str = InvalidChoice;
                 strcat(ret_str,"\n\rDHCP Client is Enabled:");
              }
            } 
            break;		

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_IP_SUBNETMASK:
         new_rhs = buffer;
printf("\n\rIP Subnet Mask of port % d is : %s",client_info_ptr->menu_selected_port,new_rhs);
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidSubnet;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IP_NODE_ADDRESS: 
			new_rhs = buffer;
printf("\n\rIP Address of port %d is : %s",client_info_ptr->menu_selected_port,new_rhs);
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_MODI_IPPORTINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


/* sudhir 3-10-96 */
PARA_STR *test_linked_list (PARA_STR *start_of_linked_list)
{	
/*
	while (start_of_linked_list)
	{
		if (!i)
		{
			printf("The first string is %s\n", &start_of_linked_list->parameter[0]);
			i = 25 ;
		}
		else
		{
			start_of_linked_list = start_of_linked_list->next ;
			i-- ;
		}
	}
*/
	return (start_of_linked_list);
}





enum BOOLEAN is_default_route_valid (ULONG default_rout)
{
	int port_no;
	ULONG default_net, port_net;

	for (port_no =0; port_no < telnet.number_of_ports ; port_no++)
	{
		 default_net = default_rout & ip.port[port_no].config.subnetmask;
		 port_net = ip.port[port_no].config.ip_address & ip.port[port_no].config.subnetmask;
		 if (default_net == port_net)
		 	return (TRUE);
	}
	return (FALSE);
}	 

BYTE *get_ip_address_str (BYTE *buf, USHORT port_number)
{
	convert_ip_address_to_dot_format (buf, ip.port[port_number].config.ip_address);
	return (buf);
}

int get_number_of_ip_ports()
{
	USHORT no_of_ports=0;
	
	return ip.number_of_ports;

	get_parameter (CM_IP_SECTION, (void *) &ip.number_of_ports,
			CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT,&no_of_ports, 10);				
	return no_of_ports;
}

void	generate_no_of_ip_ports_strings(int Flag)
{
	BYTE temp_buf[75];
	int i;

	strcpy (telnet.tx_buffer, "\n\r             << Select IP Port >> \n\r");
	for (i = 1; i <= no_of_ip_ports; i++)
	{
		if (!Flag)
			sprintf (temp_buf, "\n\r[%d] Port %2d",i,i);
		else
			sprintf (temp_buf, "\n\r[%d] Port %2d     : %s", i, i,
				enabled_or_disabled (ip.port[i-1].config.port_enabled));
		strcat (telnet.tx_buffer, temp_buf);
	}
	if (!Flag)
	{
		sprintf (temp_buf, "\n\r[%d] Add a Virtual Port", no_of_ip_ports + 1);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r[%d] Delete a Virtual Port", no_of_ip_ports + 2);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, EnterChoice, no_of_ip_ports + 2);
	}
	else
		sprintf (temp_buf, EnterChoice, no_of_ip_ports);
	strcat (telnet.tx_buffer, temp_buf);
}

BYTE  *ip_port_delete_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, PortNoToDelete, "IP");
		return (telnet.tx_buffer);
	}

	new_value = atoi (buffer);
	if (new_value > no_of_ip_ports)
	{
		sprintf (telnet.tx_buffer, EnterProperChoice, no_of_ip_ports);
		return (telnet.tx_buffer);
	}
	else
	{
	}
	client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
 	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *ip_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.mib.ipInReceives),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.mib.ipInHdrErrors),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.mib.ipForwDatagrams),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.statistics.number_of_packets_that_couldnot_be_forwarded),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.mib.ipOutRequests),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.mib.ipOutNoRoutes));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE *ip_tcp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], tcp.mib.tcpPassiveOpens),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], tcp.mib.tcpAttemptFails),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], tcp.mib.tcpInSegs),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], tcp.mib.tcpOutSegs),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], tcp.mib.tcpRetransSegs),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], tcp.mib.tcpInErrs),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], tcp.mib.tcpOutRsts));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr); 
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE *ip_rip_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0],
				ip.rip.statistics.number_of_request_packets_sent + ip.rip.statistics.number_of_response_packets_sent),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.rip.statistics.number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.rip.statistics.number_of_packets_rejected),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.rip.statistics.number_of_request_packets_received),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.rip.statistics.number_of_response_packets_received),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.rip.statistics.number_of_unrecongnized_packets_received),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.rip.statistics.number_of_bad_versions),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.rip.statistics.number_of_bad_address_families),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.rip.statistics.number_of_bad_metrics));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE *ip_arp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.arp.statistics.total_number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.arp.statistics.total_number_of_incoming_requests),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.arp.statistics.total_number_of_short_packets_received),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.arp.statistics.bad_length_field),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.arp.statistics.unsupported_hardware),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.arp.statistics.unsupported_protocol),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.arp.statistics.bad_address),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.arp.statistics.total_number_of_replies_sent),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.arp.statistics.total_number_of_pending_packets_discarded),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.arp.statistics.total_number_of_requests_sent));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}



BYTE *ip_rarp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.rarp.statistics.total_number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.rarp.statistics.total_number_of_incoming_requests),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.rarp.statistics.total_number_of_short_packets_received),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.rarp.statistics.bad_length_field),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.rarp.statistics.unsupported_hardware),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.rarp.statistics.unsupported_protocol),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.rarp.statistics.bad_address),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.rarp.statistics.total_number_of_replies_sent),
/*				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.rarp.statistics.total_number_of_pending_packets_discarded),*/
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], 0),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.rarp.statistics.total_number_of_requests_sent));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}



BYTE *ip_icmp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.icmp.mib.icmpInMsgs),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.icmp.mib.icmpInErrors),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.icmp.mib.icmpInDestUnreachs),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.icmp.mib.icmpInEchos),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.icmp.mib.icmpInEchoReps),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.icmp.mib.icmpOutMsgs),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.icmp.mib.icmpOutErrors),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.icmp.mib.icmpOutDestUnreachs),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.icmp.mib.icmpOutEchos),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.icmp.mib.icmpOutEchoReps));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}



BYTE *ip_udp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.udp.mib.udpInDatagrams),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.udp.mib.udpNoPorts),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.udp.mib.udpInErrors),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.udp.mib.udpOutDatagrams));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE *ip_filt_db_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE	filter_type;

	if (!buffer) 
		return (menufsmhdlr[client_info_ptr->menustate].menu);

	filter_type = atoi(buffer);
 	switch( filter_type) {
      case IP_FILTER_ADDR:
			client_info_ptr->menustate = TMS_IPFILTADDR;
			client_info_ptr->ptr_to_last_read_linked_list = NULL;

			/** menu_selected_port is used to save the display_filter_type selected.
			 	 It is later used to ditinguish between address & port filters.
			**/
			client_info_ptr->menu_selected_port = filter_type;
			break;
 		case IP_FILTER_PORT:
			client_info_ptr->menustate = TMS_IPFILTPORT;
			client_info_ptr->ptr_to_last_read_linked_list = NULL;
			client_info_ptr->menu_selected_port = filter_type;
			break;
 		case IP_FILTER_ICMP:
			client_info_ptr->menustate = TMS_IPFILTICMP;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
   client_info_ptr->next_screen = 0;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_ip_addr_filter ()
{
	strcpy (temp_ip_addr_filter.ip_address, "0.0.0.0");
	temp_ip_addr_filter.physical_port = 0;
	temp_ip_addr_filter.filter_type = 0;
}	

BYTE	*display_ip_addr_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_addr_filter;
   STRUCT_IP_ADDRESS_FILTER ip_addr_filter;
   BYTE temp_buff[200];
   USHORT index=0;
   PARAMETER_NODE *ptr_to_previous_node;

	if (!buffer)
	{
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_node != NULL)
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_addr_filter);
		}
		else
		{
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address Filter", (void *) &ip_addr_filter);

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, IPFilterAddrDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit, ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;

		}

		strcpy (telnet.tx_buffer, IPFilterAddrDB);
      if (client_info_ptr->next_screen)
      {
         index++;
      	sprintf (temp_buff,"%3d.  %-15s     %-4s     %s\n\r", 
            client_info_ptr->index++,
            dummy_ip_addr_filter->ip_address,
            get_ip_port_type(dummy_ip_addr_filter->physical_port),
            ip_fd_entry_addr_string(dummy_ip_addr_filter->filter_type));
      	strcat (telnet.tx_buffer,temp_buff);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_IPA;
			}
      }

      ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;

   	while (ptr_to_current_node != NULL)
   	{
         client_info_ptr->no_filters = 0;
      	index++;
      	sprintf (temp_buff,"%3d.  %-15s     %-4s     %s\n\r", 
            client_info_ptr->index++,
            ptr_to_ip_addr_filter->ip_address,
            get_ip_port_type(ptr_to_ip_addr_filter->physical_port),
            ip_fd_entry_addr_string(ptr_to_ip_addr_filter->filter_type));
      	strcat (telnet.tx_buffer,temp_buff);

         if (ptr_to_current_node != NULL)
            ptr_to_current_node =  cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void*)&ip_addr_filter);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_node != NULL)
         {
            memcpy ((char *) &dup_ip_addr_filter, (char *) &ip_addr_filter, sizeof (STRUCT_IP_ADDRESS_FILTER));
            dummy_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &dup_ip_addr_filter;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;
	   }
SENDFILT_IPA:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit,"); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit, ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}
	
	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_ip_addr_filter ();
      client_info_ptr->edit_filter = 0;
      client_info_ptr->menustate = TMS_ADD_ADDR_FILT;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_ADDR_EDIT_FILTER;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters )
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_ADDR_FILT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IPFILTADDR;
   }
   else
      return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_ADDRESS_FILTER ip_addr_filter;
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_addr_filter;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return InvalidFilter;
   }
   client_info_ptr->edit_index = index;


   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address Filter",(void *) &ip_addr_filter);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_addr_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }                  
   }  
   ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;

   temp_ip_addr_filter.physical_port = ptr_to_ip_addr_filter->physical_port;         
   temp_ip_addr_filter.filter_type = ptr_to_ip_addr_filter->filter_type;
   strcpy (temp_ip_addr_filter.ip_address, ptr_to_ip_addr_filter->ip_address);

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_ADD_ADDR_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *add_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT i=0;
   STRUCT_IP_ADDRESS_FILTER ip_address_filter;
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_address_filter;

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, IPaddrfiltopt,
			temp_ip_addr_filter.ip_address,
			get_ip_port_type (temp_ip_addr_filter.physical_port),
			ip_fd_entry_addr_string (temp_ip_addr_filter.filter_type));
		return telnet.tx_buffer;
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= IP_ADDRF_IPADDR &&
      client_info_ptr->modify_option_rcvd <= IP_ADDRF_FTYPE )
   {
      client_info_ptr->menustate = TMS_IP_UPD_ADDRF;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address filter",(void *) &ip_address_filter);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_address_filter);
            if (ptr_to_current_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return (InvalidFilter);
            }
         }  
         ptr_to_ip_address_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_address_filter;
         client_info_ptr->edit_filter = 0;
         cm_edit_string (CM_IP_SECTION, "IP Address Filter", (void *)ptr_to_ip_address_filter, (void *) &temp_ip_addr_filter);
      }
      else
         cm_insert_string (CM_IP_SECTION, "IP address Filter", (void *) &temp_ip_addr_filter);

		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IPFILTADDR;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}  	

BYTE *upd_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case IP_ADDRF_IPADDR:
				return ("\n\rEnter IP Address:");
		
			case IP_ADDRF_PORTNO:
				return PortChoice;

			case IP_ADDRF_FTYPE:
				return Filtertype;
		}
	}

	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case IP_ADDRF_IPADDR:
			if (!is_an_ip_address(buffer) || !strcmp(buffer,"0.0.0.0")) /* Added by Sreelu */
				return (InvalidIP);
         strcpy (temp_ip_addr_filter.ip_address, buffer);
         break;
	
		case IP_ADDRF_PORTNO:
			if (value < 1 || value > 4)
				return InvalidChoice;
			temp_ip_addr_filter.physical_port = value-1;
			break;
			
		case IP_ADDRF_FTYPE:
			if (value < 1 || value > 4)
				return InvalidChoice;

         temp_ip_addr_filter.filter_type = value-1;
         break;
	}
	client_info_ptr->menustate = TMS_ADD_ADDR_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *delete_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_addr_filter;
   STRUCT_IP_ADDRESS_FILTER ip_addr_filter;

   if (!buffer)
   {
      return EnterFilter;
   }


   index = atoi (buffer) - 1;


   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address Filter",(void *) &ip_addr_filter);
   for (i=0; i < index; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_addr_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }
   }  

   ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;
   cm_remove_string (CM_IP_SECTION, "IP Address Filter", (void *)ptr_to_ip_addr_filter);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

	client_info_ptr->menustate = TMS_IPFILTADDR;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE	*ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer) {
		if (telnet.number_of_ports == 2)
		{
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				enabled_or_disabled (ip.port[0].config.port_enabled),
				enabled_or_disabled (ip.port[1].config.port_enabled));
		}
		else
		{
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				enabled_or_disabled (ip.port[0].config.port_enabled),
				enabled_or_disabled (ip.port[1].config.port_enabled),
				enabled_or_disabled (ip.port[2].config.port_enabled),
				enabled_or_disabled (ip.port[3].config.port_enabled));
		}
		return (telnet.tx_buffer);
	}

	port_number = atoi(buffer);
	/* Sanjay */
	if (port_number > menufsmhdlr[client_info_ptr->menustate].num_of_items ||
		port_number <= 0)
	{
		/* Invalid choice */
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	else if (port_number == menufsmhdlr[client_info_ptr->menustate].num_of_items)
	{	
		/* Move to parent menu */
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
	}
	else
	{
		/* One of the ports */
		client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
		client_info_ptr->menu_selected_port = port_number-1;
	}
	/* Sanjay */
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *to_upper_string (BYTE *in_str)
{
	BYTE *ptr = in_str;

	while (*ptr)
	{
		*ptr = (char) toupper ((int) *ptr) ;
		ptr ++ ;
	}
	return in_str ;
}

ULONG str_to_net(BYTE *Str)
{
	int f1, f2, f3, f4;

	if (sscanf(Str,"%03u.%03u.%03u.%03u", &f1, &f2, &f3, &f4) != 4)
		return(-1l);

	if ((f1 < 0) || (f1 > 255) || (f2 < 0) || (f2 > 255) ||
			(f3 < 0) || (f3 > 255) || (f4 < 0) || (f4 > 255))
		return(-1l);

	return ((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
}

BYTE *read_till_next_comma (BYTE *start_ptr, USHORT *length)
{
   USHORT count=0;
   BYTE *buf_ptr, *temp_ptr;

   temp_ptr = malloc (10);
   if (temp_ptr == NULL)
   {
      printf ("Malloc failed\n");
      return NULL;
   }
   buf_ptr = temp_ptr;
   while (*start_ptr != ',')
   {
      *temp_ptr++ = *start_ptr++;
      count++;
   }
   *temp_ptr = 0;
   *length = count;
   return buf_ptr;
}
                  
      
void initialize_static_route ()
{
   strcpy (temp_static_route.ip_address ,"0.0.0.0");
   strcpy (temp_static_route.gateway_address, "0.0.0.0");
   strcpy (temp_static_route.address_mask, "0.0.0.0");
   strcpy (temp_static_route.metric, "1"); 
   strcpy (temp_static_route.port, "0"); 
}

BYTE *display_static_routes (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE temp_buff[200];
   USHORT index=0;
   STRUCT_STATIC_ROUTE ptr_to_static_route;
   STRUCT_STATIC_ROUTE *ptr_to_route;
   PARAMETER_NODE *ptr_to_previous_node;
   

   if (!buffer)
   {
      if (client_info_ptr->next_screen)
      {
         ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ptr_to_static_route);
      }         
      else
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries", (void *) &ptr_to_static_route);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->no_filters = 1;
            strcpy (telnet.tx_buffer,static_route_table);
            strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit, ESC to PREV menu):");            
            return telnet.tx_buffer;
         }            
         client_info_ptr->index = 1;
      }

         
      strcpy (telnet.tx_buffer, static_route_table);

      ptr_to_route = (STRUCT_STATIC_ROUTE *) &ptr_to_static_route;

      while (ptr_to_route != NULL)
      {
         client_info_ptr->no_filters = 0;
/*         printf ("Address %s\n",ptr_to_route->ip_address); */
         index++;
			sprintf (temp_buff, "%3d.  %-15s    %-15s  %-15s  %-5s %-6s\n\r",
            client_info_ptr->index++,
            ptr_to_route->ip_address,
            ptr_to_route->gateway_address,
            ptr_to_route->address_mask,
            ptr_to_route->metric,
				get_physical_port(atoi(ptr_to_route->port)));
         strcat (telnet.tx_buffer, temp_buff);

         
         ptr_to_previous_node = ptr_to_current_node;
         ptr_to_current_node =  cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void*)&ptr_to_static_route);
      
         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_node != NULL)
         {
            ptr_to_current_node = ptr_to_previous_node;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_route = (STRUCT_STATIC_ROUTE *) &ptr_to_static_route;
      }

      strcat (telnet.tx_buffer, "\n\rNote : Gateway address '0.0.0.0' indicates Dynamically Assigned Address");  
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit, ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit, ESC to PREV menu):"); 

      return telnet.tx_buffer;
   }

   if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_static_route ();
      client_info_ptr->menustate = TMS_IP_ADD_ROUTE;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_EDIT_ROUTE;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_STATIC_RT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IP_STATIC_RT;
   }
   else
      return InvalidChoice;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_STATIC_ROUTE static_route;
   STRUCT_STATIC_ROUTE *ptr_to_static_route;
   USHORT i;
   USHORT index;
	BYTE ip_address[20],check;

   if (!buffer)
      return ("\n\rEnter index of Route:");

   index = atoi (buffer);

   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
   }
      


   client_info_ptr->edit_index = index;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries", (void *) &static_route);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &static_route);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
      }
   }  
   ptr_to_static_route = (STRUCT_STATIC_ROUTE *) &static_route;

   strcpy (temp_static_route.ip_address, ptr_to_static_route->ip_address);
   strcpy (temp_static_route.gateway_address, ptr_to_static_route->gateway_address);
   strcpy (temp_static_route.address_mask, ptr_to_static_route->address_mask);
   strcpy (temp_static_route.metric, ptr_to_static_route->metric);
   strcpy (temp_static_route.port, ptr_to_static_route->port);

   switch (atoi(temp_static_route.port))
   {
      case 1:
            get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, atoi(temp_static_route.port), CM_INDEX_FORMAT, (void*)&check, 0);
				if (check && !strcmp(temp_static_route.gateway_address, "0.0.0.0")) /* Yes DHCP is Enabled, go out */
				{
               strcpy(temp_static_route.gateway_address,"DHCP Assigned");
				}
            break;

      case 2:
				get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, atoi(temp_static_route.port), CM_STRING_FORMAT, (void*)ip_address, 20);
				if (!strcmp(ip_address, "0.0.0.0") && !strcmp(temp_static_route.gateway_address, "0.0.0.0"))
					strcpy(temp_static_route.gateway_address, "ISP Assigned");
            break;
   }

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_IP_ADD_ROUTE;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}


BYTE *add_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT i=0;
   STRUCT_STATIC_ROUTE ip_route;
   STRUCT_STATIC_ROUTE *ptr_to_ip_route;

   if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf (telnet.tx_buffer, static_route_menu,
			 get_physical_port(atoi(temp_static_route.port)),
          temp_static_route.ip_address,
          temp_static_route.gateway_address,
          temp_static_route.address_mask,
          temp_static_route.metric);
      return (telnet.tx_buffer);
	}

    client_info_ptr->modify_option_rcvd = atoi (buffer);
      
    if (client_info_ptr->modify_option_rcvd >= STATIC_ROUTE_PORT &&
      client_info_ptr->modify_option_rcvd <= STATIC_ROUTE_METRIC )
    {
      client_info_ptr->menustate = TMS_IP_UPD_ROUTE;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
    {
      modify_config_visited = 1;
      

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries",(void *) &ip_route);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_route);
            if (ptr_to_current_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
            }
         }  
         ptr_to_ip_route = (STRUCT_STATIC_ROUTE *) &ip_route;
         client_info_ptr->edit_filter = 0;

/* sudhir 16/6/97 */
         cm_edit_string (CM_IP_SECTION, "IP Static Route Table Entries", (void *)ptr_to_ip_route,(void *) &temp_static_route);
      }
      else
         cm_insert_string (CM_IP_SECTION, "IP Static Route Table Entries", (void *) &temp_static_route);
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_STATIC_RT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    return InvalidChoice;
}

BYTE *upd_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   ULONG value=0,value1=0;
   BYTE isp_ip_address[20],isp_subnet_mask[20];
	BYTE ip_address[20],flag;
   
   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
         case STATIC_ROUTE_PORT:
				generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
				return (telnet.tx_buffer);
				break;				


         case STATIC_ROUTE_ADDRESS:
            return stat_rt_target;
         
         case STATIC_ROUTE_GWAY:
				if (!strcmp(temp_static_route.gateway_address, "ISP Assigned") || !strcmp(temp_static_route.gateway_address, "DHCP Assigned"))
				{
               client_info_ptr->menustate = TMS_NULL_FUNC;
               menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_IP_ADD_ROUTE;
               return (not_supported);
				}

				return stat_rt_target;

         case STATIC_ROUTE_SMASK:
            return stat_rt_mask;

         case STATIC_ROUTE_METRIC:
            return ("\n\rEnter Metric:");
				get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, atoi(temp_static_route.port), CM_STRING_FORMAT, (void*)ip_address, 20);
				if (strcmp(ip_address, "0.0.0.0") == 0)
					strcpy(temp_static_route.gateway_address, "ISP Assigned");

      }
   }
	value1 = atoi(buffer);
   switch (client_info_ptr->modify_option_rcvd)
   {
      case STATIC_ROUTE_PORT:
/*         sscanf (buffer, "%lu", &value1);*/
         if (value1 < 0 || value1 > telnet.number_of_ports )
            return InvalidChoice;
         sprintf(temp_static_route.port,"%d", (USHORT) (value1-1));
         printf("Menuip:port = %s\n",temp_static_route.port);
			if(atoi(temp_static_route.port) == 1)
			{
		      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, atoi(temp_static_route.port), CM_INDEX_FORMAT, (void*)&flag, 0);
				printf("menuips:flag = %s\n",flag);		
				printf("menuip:flag = %d\n",atoi(flag));		
				if (flag) /* Yes DHCP is Enabled, go out */
				{
					printf("MenuIp:DHCP Enable\n") ;
					strcpy(temp_static_route.gateway_address,"DHCP Assigned");
				}
								
			}
			else if (atoi(temp_static_route.port) == 2)
			{
				get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, atoi(temp_static_route.port), CM_STRING_FORMAT, (void*)ip_address, 20);
				if (strcmp(ip_address, "0.0.0.0") == 0)
					strcpy(temp_static_route.gateway_address, "ISP Assigned");
			}
				
			break;

      case STATIC_ROUTE_ADDRESS:
         if (!is_an_ip_address(buffer))
				return (InvalidIP);
         strcpy (temp_static_route.ip_address, buffer);
         break;
         
      case STATIC_ROUTE_GWAY:
                            /* Added by Sreelu */     
         if (!is_an_ip_address(buffer))
				return (InvalidIP);
         strcpy (temp_static_route.gateway_address, buffer);
         break;
      
      case STATIC_ROUTE_SMASK:
         if (is_an_ip_address_mask(temp_static_route.ip_address, buffer) == FALSE)
				return (InvalidSubnet);
         strcpy (temp_static_route.address_mask, buffer);
         break;

      case STATIC_ROUTE_METRIC:
         sscanf (buffer, "%lu", &value);
         if (value < 1 || value > 15 )
            return InvalidChoice;
         strcpy (temp_static_route.metric, buffer);
         break;

   }
   client_info_ptr->menustate = TMS_IP_ADD_ROUTE;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *delete_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   BYTE ptr_to_static_route[100];
   STRUCT_STATIC_ROUTE *ptr_to_route;


   if (!buffer)
   {
      return ("\n\rEnter index of Route to delete:");
   }

   index = atoi (buffer) - 1;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries",(void *) &ptr_to_static_route[0]);
   for (i=0; i < index; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ptr_to_static_route[0]);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
      }
   }  

   ptr_to_route = (STRUCT_STATIC_ROUTE *) ptr_to_static_route;
   cm_remove_string (CM_IP_SECTION, "IP Static Route Table Entries", (void *)ptr_to_route);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_IP_STATIC_RT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_ip_port_filter ()
{
	temp_ip_port_filter.protocol = 0;
	strcpy (temp_ip_port_filter.protocol_port, "0");
	temp_ip_port_filter.physical_port = 0;
	temp_ip_port_filter.filter_type = 0;
}	

BYTE	*display_ip_port_filters(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;
   STRUCT_IP_PORT_FILTER ip_port_filter;
   BYTE temp_buff[200];
   PARAMETER_NODE *ptr_to_previous_node;

   USHORT index=0;

	if (!buffer)
	{
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_node != NULL)
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
		}
		else
		{
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter", (void *) &ip_port_filter);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, IPFilterPortDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit, ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
		}

		strcpy (telnet.tx_buffer, IPFilterPortDB);
      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "%3d     %-4s      %-4s         %-4s   %s\n\r",
            client_info_ptr->index++,
            ip_protocol_string(dummy_ip_port_filter->protocol),
            dummy_ip_port_filter->protocol_port,
            get_ip_port_type(dummy_ip_port_filter->physical_port),
            ip_fd_entry_port_string(dummy_ip_port_filter->filter_type));
         strcat (telnet.tx_buffer, temp_buff);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_IPP;
         }
      }         

      ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;

   	while (ptr_to_ip_port_filter != NULL)
   	{
         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "%3d     %-4s      %-4s         %-4s   %s\n\r",
            client_info_ptr->index++,
            ip_protocol_string(ptr_to_ip_port_filter->protocol),
            ptr_to_ip_port_filter->protocol_port,
            get_ip_port_type(ptr_to_ip_port_filter->physical_port),
            ip_fd_entry_port_string(ptr_to_ip_port_filter->filter_type));

         strcat (telnet.tx_buffer, temp_buff);
         
         if (ptr_to_current_node != NULL)
            ptr_to_current_node =  cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void*)&ip_port_filter);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_node != NULL)
         {
            memcpy ((char *) &dup_ip_port_filter, (char *) &ip_port_filter,sizeof (STRUCT_IP_PORT_FILTER));
            dummy_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &dup_ip_port_filter;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;
		}
SENDFILT_IPP:

      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit, ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit, ESC to PREV menu):"); 

   	return telnet.tx_buffer;
	}
   	
	if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_ip_port_filter ();
      client_info_ptr->menustate = TMS_ADD_PORT_FILT;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_PORT_EDIT_FILTER;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_PORT_FILT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IPFILTPORT;
   }
   else
      return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



BYTE *te_edit_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_PORT_FILTER ip_port_filter;
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index >= client_info_ptr->index || index == 0)
      return InvalidFilter;

   client_info_ptr->edit_index = index;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter",(void *) &ip_port_filter);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidChoice);
      }
   }  
   ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;

   temp_ip_port_filter.protocol = ptr_to_ip_port_filter->protocol;
   strcpy (temp_ip_port_filter.protocol_port, ptr_to_ip_port_filter->protocol_port);
   temp_ip_port_filter.protocol = ptr_to_ip_port_filter->protocol;
   temp_ip_port_filter.protocol = ptr_to_ip_port_filter->protocol;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;
      
   client_info_ptr->menustate = TMS_ADD_PORT_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}



BYTE *delete_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_IP_PORT_FILTER ip_port_filter;
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;


   if (!buffer)
   {
      return EnterFilter;
   }

   index = atoi (buffer) - 1;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter",(void *) &ip_port_filter);
   for (i=0; i < index; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }
   }  

   ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;
   cm_remove_string (CM_IP_SECTION, "IP Port Filter", (void *)ptr_to_ip_port_filter);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;


	client_info_ptr->menustate = TMS_IPFILTPORT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *add_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_PORT_FILTER ip_port_filter;
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;
   USHORT i;

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, PortFiltopt,
			ip_protocol_string(temp_ip_port_filter.protocol),
			temp_ip_port_filter.protocol_port,
			get_ip_port_type(temp_ip_port_filter.physical_port),
			ip_fd_entry_port_string(temp_ip_port_filter.filter_type));
		return telnet.tx_buffer;
	}
	
	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= IP_PORTF_PROTOCOL &&
      client_info_ptr->modify_option_rcvd <= IP_PORTF_TYPE )
   {
      client_info_ptr->menustate = TMS_IP_UPD_PORTF;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter",(void *) &ip_port_filter);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
            if (ptr_to_current_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return InvalidChoice;                  
            }
         }  
         ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;
         client_info_ptr->edit_filter = 0;

/* sudhir 16/6/97 */
         cm_edit_string (CM_IP_SECTION, "IP Port Filter", (void *)ptr_to_ip_port_filter,(void *) &temp_ip_port_filter);
      }
      else
         cm_insert_string (CM_IP_SECTION, "IP Port Filter", (void *) &temp_ip_port_filter);
   
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IPFILTPORT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}

BYTE *upd_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value=0,new_value;
   BYTE port_buf,port_buff[20],buf;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case IP_PORTF_PROTOCOL:
				return (Protochoice);

   		case IP_PORTF_PROTPORT:
                                 /* Added by Sreelu */
            if (temp_ip_port_filter.protocol == 0)
            	return tcp_application_list;
            else if (temp_ip_port_filter.protocol == 1)
            	return udp_application_list;
            else
            	return ("\n\rUnknown Protocol");		

			case IP_PORTF_PORT:
            return PortChoice;

			case IP_PORTF_TYPE:
				return FilterTypePort;
		}
	}
	
	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case IP_PORTF_PROTOCOL:
			if (value == 1)
				temp_ip_port_filter.protocol = value-1;
			else if ( value == 2)
				temp_ip_port_filter.protocol = value-1;
			else
				return InvalidChoice;

            break;

   	case IP_PORTF_PROTPORT:
                              /* Added by Sreelu */
      	if (temp_ip_port_filter.protocol == 0)
         {
      		if (value < 21)
               my_itoa(get_protocol_port_number ( TCP_PROTOCOL, value),buf,10);
            else 
             return InvalidChoice;
          }
         else if (temp_ip_port_filter.protocol == 1)
      	 {
      		if (value < 20) 
               my_itoa(get_protocol_port_number ( TCP_PROTOCOL, value),buf,10);
            else 
              return InvalidChoice;
          }
        else
      		return ("\n\rUnknown Protocol");

			if ((strlen (buf) > 4) || (atoi(buf) == 0))  /* Added by Sreelu */
				return InvalidChoice;
         if (atoi(buf)!=0)
			   strcpy (temp_ip_port_filter.protocol_port, buf);
         else
            return("\n\rInvalid Choice!\n\rEnter Again:");
			break;
				
		case IP_PORTF_PORT:

         if (value < 1 || value > telnet.number_of_ports )
         	return InvalidChoice;
         temp_ip_port_filter.physical_port = value - 1;
			break;
	
		case IP_PORTF_TYPE:
			if (value < 1 || value > 4)
				return InvalidChoice;
			temp_ip_port_filter.filter_type = value -1 ;
			break;
	}
	client_info_ptr->menustate = TMS_ADD_PORT_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

static void add_IP_RIP_entry_to_buffer(IP_ROUTE_ENTRY *sptr_RIP_entry, BYTE index) 
{
	BYTE	tmp_buffer[81];

	sprintf(tmp_buffer, "%3d.   %-15s    %-15s    %-15s     %2ld      %2d\n\r", 
		index,
		convert_ip_address_to_dot_format(&ReplyStrs[0].ReplyStr[0], sptr_RIP_entry->target),
		convert_ip_address_to_dot_format(&ReplyStrs[1].ReplyStr[0], sptr_RIP_entry->gateway),
		convert_ip_address_to_dot_format(&ReplyStrs[2].ReplyStr[0], sptr_RIP_entry->mask),
		sptr_RIP_entry->metric,
		sptr_RIP_entry->port_number+1);
	strcat(telnet.tx_buffer, tmp_buffer);
}


BYTE *ip_rip_table_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	i = 0;
	IP_ROUTE_ENTRY		*sptr_RIP_entry;
	BYTE	index;

	if (client_info_ptr->more) {
		sptr_RIP_entry = (IP_ROUTE_ENTRY *)client_info_ptr->ptr_last_read_primary_table_entry;
	} else {
		/* First set of entries. Go into character-at-a-time mode */
		will_temp_echo(client_info_ptr, TOECHO);
      client_info_ptr->echoing = FALSE;

		sptr_RIP_entry = ip.route_list.sptr_forward_link;
	}

	strcpy (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu);
	index = client_info_ptr->more * MAX_ENTRIES_PER_PAGE;

	while (i < MAX_ENTRIES_PER_PAGE && sptr_RIP_entry) {
		add_IP_RIP_entry_to_buffer (sptr_RIP_entry, ++index);
 		sptr_RIP_entry = sptr_RIP_entry->links.sptr_forward_link;
		i++;
	}

	client_info_ptr->more++;

/*	if (i == MAX_ENTRIES_PER_PAGE) 
		client_info_ptr->ptr_last_read_primary_table_entry = (BYTE *)sptr_RIP_entry;
*/

	if (i) {
		client_info_ptr->ptr_last_read_primary_table_entry = (BYTE *)sptr_RIP_entry;
		/* There are entries to be displayed. Add the continue message */
		if (i == MAX_ENTRIES_PER_PAGE && sptr_RIP_entry) 
			strcat(telnet.tx_buffer, MoreContinue);
		else
			strcat(telnet.tx_buffer, Continue);
		return (telnet.tx_buffer);
	} else {
		/* No more entries. Go back to the parent menu */
		back_to_normal_mode(client_info_ptr);
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}		

void	initialize_values_of_new_ip_port()
{
}


void	generate_no_of_ports_strings(int no_of_ports, int section_id)
{
	BYTE temp_buf[75];
	int i;

	strcpy (temp_buf, "\n\r\n\r\             << Select %s Port >> \n\r");
	switch (section_id)
	{
		case IP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "IP");
							break;
		case IPX_ID : 	sprintf (telnet.tx_buffer, temp_buf, "IPX");
							break;
		case STP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "STP");
							break;
		case PPP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "PPP");
							break;
		case WAN_ID : 	sprintf (telnet.tx_buffer, temp_buf, "WAN");
							break;
		case MUX_ID : 	sprintf (telnet.tx_buffer, temp_buf, "MUX Data");
							break;
		case AG_ID : 	sprintf (telnet.tx_buffer, temp_buf, "AG");
							break;
      case SLIP_ID :	sprintf (telnet.tx_buffer, temp_buf, "SLIP"); /* Added by Sreelu */
                    	break;
		default	:
							break;
	}

	for (i = 1; i <= no_of_ports; i++)
	{
		/*sprintf (temp_buf, "\n\r[%d] Port %2d", i, i);*/
		if(i == 1)  /* Added by Sreelu */
		  sprintf (temp_buf," \n\r[%d] Port %2d(Secured LAN)",i,i);
		if(i == 2)
		  sprintf (temp_buf," \n\r[%d] Port %2d(Internet LAN)",i,i);
		if(i == 3)
		  sprintf (temp_buf," \n\r[%d] Port %2d(WAN)",i,i);
		strcat (telnet.tx_buffer, temp_buf);
	}
	strcat (telnet.tx_buffer, "\n\r");
	if ((frame_relay_enabled) && (section_id < PPP_ID))
	{
		sprintf (temp_buf, "[%d] Add a Virtual Port", no_of_ports + 1);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r[%d] Delete a Virtual Port\n\r", no_of_ports + 2);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, EnterChoice, no_of_ports + 2);
	}
	else
		if (no_of_ports > 1)
			sprintf (temp_buf, EnterChoice, no_of_ports);
		else
			strcpy (temp_buf, EnterSingleChoice);
	strcat (telnet.tx_buffer, temp_buf);
}
      

static BYTE * ip_default_action_string (USHORT_ENUM (IP_FILTER_DEFAULT_ACTION) state)
{
	switch (state) {
		case IP_FILTER_DEFAULT_ACTION_FORWARD: return ("Forward");
		case IP_FILTER_DEFAULT_ACTION_FILTER: return ("Filter");
		default: return ("Unknown");
	}
}


BYTE *null_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   
/*         if (client_info_ptr->modify_option_rcvd == MOD_ETHER_FRAME)
              return ("\n\rFrame Type is not configurable for WAN Port\n\r\
Enter your choice (exit, ESC to previous menu):");

   else  */
      return not_supported;

}


BYTE *wrong_value_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   return wrong_value;
}

BYTE	*ip_icmp_port_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT port_number=0;

   if (!buffer)
   {
      generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
		return (telnet.tx_buffer);
   }
   
   port_number = atoi (buffer);
   client_info_ptr->menu_selected_port = port_number-1;

   if (port_number > telnet.number_of_ports ||	port_number < 1)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, telnet.number_of_ports);
		return(telnet.tx_buffer);
	}
   client_info_ptr->more = 1;
   client_info_ptr->menustate = TMS_IP_ICMP_FILTERS;
	client_info_ptr->menu_selected_port = port_number - 1; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*display_ip_icmp_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_ICMP_FILTER *ptr_to_ip_icmp_filter;
   STRUCT_IP_ICMP_FILTER ip_icmp_filter;
   USHORT i=0;

   if (!buffer)
   {
      if (client_info_ptr->more)
      {
         client_info_ptr->more = 0;
         ip_icmp_filter.physical_port = client_info_ptr->menu_selected_port;

         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP ICMP Filter", (void *) &ip_icmp_filter);
      
         ptr_to_ip_icmp_filter = (STRUCT_IP_ICMP_FILTER *) &ip_icmp_filter;
         old_ip_icmp_filter = ptr_to_ip_icmp_filter;
         
         tel_ip_icmp_filter.physical_port = client_info_ptr->menu_selected_port;

         tel_ip_icmp_filter.echo_reply  = ptr_to_ip_icmp_filter->echo_reply;
         tel_ip_icmp_filter.destination_unreachable = ptr_to_ip_icmp_filter->destination_unreachable;
         tel_ip_icmp_filter.source_quench = ptr_to_ip_icmp_filter->source_quench;
         tel_ip_icmp_filter.redirect = ptr_to_ip_icmp_filter->redirect;
         tel_ip_icmp_filter.echo_request = ptr_to_ip_icmp_filter->echo_request;
         tel_ip_icmp_filter.time_exceeded = ptr_to_ip_icmp_filter->time_exceeded;
         tel_ip_icmp_filter.parameter_problem = ptr_to_ip_icmp_filter->parameter_problem;
         tel_ip_icmp_filter.time_stamp_request = ptr_to_ip_icmp_filter->time_stamp_request;
         tel_ip_icmp_filter.time_stamp_reply = ptr_to_ip_icmp_filter->time_stamp_reply;
         tel_ip_icmp_filter.address_mask_request = ptr_to_ip_icmp_filter->address_mask_request;
         tel_ip_icmp_filter.address_mask_reply = ptr_to_ip_icmp_filter->address_mask_reply;
      }   

      sprintf (telnet.tx_buffer, IPFilterICMPDB,
         enabled_or_disabled (tel_ip_icmp_filter.echo_reply),
         enabled_or_disabled (tel_ip_icmp_filter.destination_unreachable),
         enabled_or_disabled (tel_ip_icmp_filter.source_quench),
         enabled_or_disabled (tel_ip_icmp_filter.redirect),
         enabled_or_disabled (tel_ip_icmp_filter.echo_request),
         enabled_or_disabled (tel_ip_icmp_filter.time_exceeded),
         enabled_or_disabled (tel_ip_icmp_filter.parameter_problem),
         enabled_or_disabled (tel_ip_icmp_filter.time_stamp_request),
         enabled_or_disabled (tel_ip_icmp_filter.time_stamp_reply),
         enabled_or_disabled (tel_ip_icmp_filter.address_mask_request),
         enabled_or_disabled (tel_ip_icmp_filter.address_mask_reply));
      return telnet.tx_buffer;

   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);


   if (client_info_ptr->modify_option_rcvd >= 1 &&
      client_info_ptr->modify_option_rcvd <= 11)
   {
      client_info_ptr->menustate = TMS_IP_UPD_ICMP_FILTERS;
      return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      modify_config_visited = 1;
		client_info_ptr->more = 0;
      client_info_ptr->menustate = TMS_IP_ICMP_FILTERS;
      cm_edit_string (CM_IP_SECTION, "IP ICMP Filter", (void *) old_ip_icmp_filter, (void *) &tel_ip_icmp_filter);
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}

BYTE	*upd_ip_icmp_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT option=0;
   BYTE *new_rhs;

   if (!buffer)
      return EnaOrDis;
         
   option = atoi (buffer);

   if ( (option < 1) || (option > 2) || strlen (buffer) != 1)
		return (InvalidChoice);
   else 
      if(option == 2)  /* Added by Sreelu */
        option = 0;

   switch (client_info_ptr->modify_option_rcvd)
   {
      case 1:
         tel_ip_icmp_filter.echo_reply = option;
         break;

      case 2:
         tel_ip_icmp_filter.destination_unreachable = option;
         break;

      case 3:
         tel_ip_icmp_filter.source_quench = option;
         break;

      case 4:
         tel_ip_icmp_filter.redirect = option;
         break;

      case 5:
         tel_ip_icmp_filter.echo_request = option;
         break;

      case 6:
         tel_ip_icmp_filter.time_exceeded = option;
         break;

      case 7:
         tel_ip_icmp_filter.parameter_problem = option;
         break;

      case 8:
         tel_ip_icmp_filter.time_stamp_request = option;
         break;

      case 9:
         tel_ip_icmp_filter.time_stamp_reply = option;
         break;

      case 10:
         tel_ip_icmp_filter.address_mask_request = option;
         break;

      case 11:
         tel_ip_icmp_filter.address_mask_reply = option;
         break;
   }

   client_info_ptr->menustate = TMS_IP_ICMP_FILTERS;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}  
   



