#include	<defs.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include <stddef.h>

#include	"telnet.h" 
#include	"vmenu.h"
#include "telip.h"

#include <incall.h>

#include <cfgmgr.h>


/* added by oss on 4-4-97 */
ULONG PAP_enabled;
ULONG CHAP_enabled;
int PPP_Flag_enable = 0;
extern BYTE ChoiceBuffer[80];

extern	PPP_CLASS	ppp;

BYTE user_password[15], password_str[15];

extern int modify_config_visited;


extern void *memset(void *,int ,size_t);
/*extern int  strlen (const char *); */
extern void	generate_no_of_ports_strings(int no_of_ports, int section_id);
/* sudhir 3-10-96 */


BYTE	*modify_slip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number,number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);

	if (!buffer) 
	{
      /*if (telnet.number_of_ports == 2)
         return SelectSLIPPort_2Port;
      else if (telnet.number_of_ports == 4)
         return SelectSLIPPort_4Port;*/

		generate_no_of_ports_strings(telnet.number_of_ports - number_of_lan_ports, SLIP_ID);
		return (telnet.tx_buffer);  
	}

	port_number = atoi (buffer);
	if (port_number > ((telnet.number_of_ports) - number_of_lan_ports ) || port_number < 1)
	{
		/* Bad choice */
		sprintf(telnet.tx_buffer, EnterProperChoice,((telnet.number_of_ports) - 1)); 
		return(telnet.tx_buffer);
	}
	else
	{
		/* One of the ports */
		client_info_ptr->menustate = TMS_SLIP_PORTINFO;
/*		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO; */
		client_info_ptr->menu_selected_port = port_number-1;
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_slip_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
   {
      initialize_replystr ();

		get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].slip_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);
   
      get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].cslip_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[1].ReplyStr[0], 10);
   
      get_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Inbound Authentication",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[2].ReplyStr[0], 10);

      get_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Maximum Transmit Unit",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[3].ReplyStr[0], 10);

      sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
         client_info_ptr->menu_selected_port+1,
         &ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
         &ReplyStrs[2].ReplyStr[0], &ReplyStrs[3].ReplyStr[0]);
       
      return telnet.tx_buffer;
   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);

   if ((client_info_ptr->modify_option_rcvd >= 1) && 
  		(client_info_ptr->modify_option_rcvd <=
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_SLIP_UPD_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
		menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
 	}
}   

BYTE *slip_modify_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value,port_no = client_info_ptr->menu_selected_port;
	BYTE  *ret_str;
   BYTE *new_rhs,ppp_str[10],slip_enbl[10];
   BYTE  ans_enabled,async_enabled;

   /* Added by Sreelu */

   get_parameter(CM_WAN_SECTION, (void *)&wan.port[0].asyncport,
         port_no, CM_INDEX_FORMAT, (void *)&async_enabled, 0) ;
   get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer,
         port_no, CM_INDEX_FORMAT, (void *)&ans_enabled,  0) ;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
          case TEL_SLIP:
            if(!async_enabled)
               return("\n\rSynchronous Mode.So Slip Can't be Enabled.\n\rEsc to prv Menu.");  
            else
               ret_str = EnaOrDis; 
            break;
          case TEL_CSLIP:
            ret_str = EnaOrDis;
            break;

          case SLIP_CALLER:

            client_info_ptr->menustate = TMS_NULL_FUNC;
            menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_SLIP_PORTINFO;

            ret_str = not_supported;
            break;

          case SLIP_MTU:
            ret_str = NewValue;
            break;
      }
      return ret_str;
   }

   new_value = atoi (buffer);

   switch (client_info_ptr->modify_option_rcvd)
	{
      case TEL_SLIP:
         if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

         /* Added by Sreelu */
      
         if( (strcmp(new_rhs,telnet_enabled_str) == 0) && !ans_enabled)
           set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].enabled,
         				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &telnet_disabled_str[0]);

         switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].slip_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
         {
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			} 
         break;
  
      case TEL_CSLIP:
         if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);
		   get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].slip_enabled,
			   	client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &slip_enbl[0], 10);
         if(( strcmp(slip_enbl,telnet_enabled_str) != 0 ) && ( strcmp(new_rhs,telnet_enabled_str) == 0 ))
            return("\n\r SLIP is also Disabled.\n\r Enter (exit , ESC to previous menu ):");
         else 
         {         
          switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].cslip_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
          {

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			 }
         }
         break;

      case SLIP_CALLER:
         return not_supported;
         break;

/*         if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

         switch (set_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Inbound Authentication",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
         {
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
         break; */

      case SLIP_MTU:
         new_rhs = buffer;
         if (strlen (new_rhs) > 5)
            return (wrong_value);

         switch (set_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Maximum Transmit Unit",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
         {
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidChoice;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
         break;
   }
	modify_config_visited = 1 ; 
   client_info_ptr->menustate = TMS_SLIP_PORTINFO;
   return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_ppp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG ppp1,ppp2,ppp3,ppp4,ppp5,ppp6,ppp7;

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_configuration_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp1, 10);

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_termination_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp2, 10);		

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_unacknowledged_echo_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp3, 10);	

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp4,	10);	

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_termination_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp5,	10); 
		
		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_echo_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp6, 10);	

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_backoff_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp7, 10);	
/* Changed by Sreelu */
#if 0
		get_parameter_by_name (CM_PPP_SECTION, "MLPPP",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);
				
#endif
		sprintf (ChoiceBuffer, EnterChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			MakePunctNumStr(&ReplyStrs[7].ReplyStr[0], ppp1),
			MakePunctNumStr(&ReplyStrs[8].ReplyStr[0], ppp2),
			MakePunctNumStr(&ReplyStrs[9].ReplyStr[0], ppp3),
			MakePunctNumStr(&ReplyStrs[10].ReplyStr[0], ppp4),
			MakePunctNumStr(&ReplyStrs[11].ReplyStr[0], ppp5),
			MakePunctNumStr(&ReplyStrs[12].ReplyStr[0], ppp6),
			MakePunctNumStr(&ReplyStrs[13].ReplyStr[0], ppp7),
   		&ReplyStrs[0].ReplyStr[0]);
		return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= 1) && 
  		(client_info_ptr->modify_option_rcvd <=
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_PPP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
		menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
 	}
}

BYTE *ppp_modify_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	BYTE  *ret_str;
   BYTE *new_rhs;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 	PPP_MAX_CONF_REQ:
			case  PPP_MAX_TERM_REQ:
			case  PPP_MAX_UNACKECH_REQ:
			case  PPP_MAX_CONF_REQ_SENDI: 
			case  PPP_MAX_TERM_REQ_SENDI:
			case  PPP_MAX_ECHO_REQ_SENDI:
			case  PPP_MAX_CONF_REQ_BACKO: ret_str = NewValue;
				break;
/* Changed by Sreelu */
#if 0       
			case MULTI_PPP:
				ret_str = EnaOrDis;
				break;
#endif
			case PPP_PORT_INFO:
/*sri		client_info_ptr->menustate = TMS_MODI_PPPPORT; */
				client_info_ptr->menustate = TMS_MODI_PPPPORTINFO;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

			
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);

		}
		return (ret_str);

	}
	new_value = atoi (buffer);

	switch(client_info_ptr->modify_option_rcvd)
	{
		case 	PPP_MAX_CONF_REQ:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_configuration_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  PPP_MAX_TERM_REQ:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_termination_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  PPP_MAX_UNACKECH_REQ:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_unacknowledged_echo_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  PPP_MAX_CONF_REQ_SENDI: 
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  PPP_MAX_TERM_REQ_SENDI:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_termination_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  PPP_MAX_ECHO_REQ_SENDI:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_echo_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  PPP_MAX_CONF_REQ_BACKO:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_backoff_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case	PPP_PORT_INFO:      	
/*sri			client_info_ptr->menustate = TMS_MODI_PPPPORT; */
			client_info_ptr->menustate = TMS_MODI_PPPPORTINFO;
			break;
/* Changed by Sreelu */
#if 0
		case MULTI_PPP:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter_by_name (CM_PPP_SECTION, "MLPPP",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}

			break; 
#endif
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	} 
	modify_config_visited = 1 ; 
	client_info_ptr->menustate = TMS_MODI_PPPMAIN;	
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ppp_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number, number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);

	if (!buffer) 
	{
		generate_no_of_ports_strings(telnet.number_of_ports - number_of_lan_ports, PPP_ID);
		return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);
	if (port_number > ((telnet.number_of_ports) - number_of_lan_ports ) || port_number < 1)
	{
		/* Bad choice */
		sprintf(telnet.tx_buffer, EnterProperChoice,((telnet.number_of_ports) - number_of_lan_ports)); /* Changed by Sreelu */
		return(telnet.tx_buffer);
	}
	else
	{
		/* One of the ports */
		client_info_ptr->menustate = TMS_PPP_PORTINFO;
/*		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO; */
		client_info_ptr->menu_selected_port = port_number-1;
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* sudhir 19-9-96 */

BYTE	*ppp_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				client_info_ptr->menu_selected_port+1);
		return (telnet.tx_buffer);
	}

 	switch( atoi(buffer)) {
 		case PPP_PORT_SETUP:
			client_info_ptr->menustate = TMS_MODI_PPPPORTINFO;
			break;

/* 		case PPP_PORT_STATS: 
			client_info_ptr->menustate = TMS_PPPPORTSTAT;
			break; */

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ppp_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE user_password[50] , slip_enabled,async_enabled,ans_enabled;
	ULONG port_no = client_info_ptr->menu_selected_port, len;

   ReplyStrs[11].ReplyStr[0] = 0 ;
	get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].authentication.password,
				port_no, CM_STRING_FORMAT, &ReplyStrs[11].ReplyStr[0], 48);

	len = strlen (&ReplyStrs[11].ReplyStr[0]);
	if (len)
		memset(&user_password[0], (int)'*', len);  
	user_password[len] = 0;

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].enabled,
				port_no, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);

		get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].slip_enabled,
				port_no, CM_INDEX_FORMAT, (void *)&slip_enabled, 0);
      get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer,
            port_no, CM_INDEX_FORMAT, (void *)&ans_enabled,  0) ;
      get_parameter(CM_WAN_SECTION, (void *)&wan.port[0].asyncport,
            port_no, CM_INDEX_FORMAT, (void *)&async_enabled, 0) ;

      if(async_enabled && !ans_enabled && slip_enabled)    /* Async & Dialing */
            strcpy(&ReplyStrs[0].ReplyStr[0],telnet_disabled_str);

		get_parameter (CM_CCP_SECTION, (void*)&ccp.ports[0].enabled,
				port_no, CM_STRING_FORMAT, &ReplyStrs[1].ReplyStr[0], 10); 

		get_parameter (CM_VJC_SECTION, (void*)&vjc.port[0].vjc_compression_enabled,
				port_no, CM_STRING_FORMAT, &ReplyStrs[2].ReplyStr[0], 10);

		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand,
				port_no, CM_STRING_FORMAT, &ReplyStrs[3].ReplyStr[0], 10);

		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout,
				port_no, CM_STRING_FORMAT, &ReplyStrs[4].ReplyStr[0], 10);

		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.user_name,
				port_no, CM_STRING_FORMAT, &ReplyStrs[5].ReplyStr[0], 48);
      
		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout,
				port_no, CM_STRING_FORMAT, &ReplyStrs[6].ReplyStr[0], 10);
         
		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries,
				port_no, CM_STRING_FORMAT, &ReplyStrs[7].ReplyStr[0], 10);

		sprintf (ChoiceBuffer, EnterChoice,
				menufsmhdlr[client_info_ptr->menustate].num_of_items);

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port+1,
			&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0], &ReplyStrs[2].ReplyStr[0],
			&ReplyStrs[3].ReplyStr[0], &ReplyStrs[4].ReplyStr[0], &ReplyStrs[5].ReplyStr[0],
			user_password,
			&ReplyStrs[6].ReplyStr[0], &ReplyStrs[7].ReplyStr[0], 
			GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= 1) &&
		(client_info_ptr->modify_option_rcvd <=
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_PPPPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}   	 
/* sudhir 19-9-96 */

BYTE *upd_modify_ppp_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG  new_value, port_no;
	BYTE   *ret_str, *new_rhs,dod_enbl[10],ppp_enbl[10],wan_enbl[10];
   BYTE   asyc_enbl[10] ;

   port_no = client_info_ptr->menu_selected_port;

	get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].enabled,
	       port_no, CM_STRING_FORMAT, &ppp_enbl[0], 10);
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  MOD_PPP_PORT_ENABLE: 	
           get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].enabled,
         				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &wan_enbl[0], 10); 
           if(!strcmp(wan_enbl,telnet_enabled_str))
              ret_str = EnaOrDis;
           else
           {
             set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].enabled,
             				port_no, CM_STRING_FORMAT, &telnet_disabled_str[0]);
             return("\n\rWAN is Disabled.\n\rEnter(Esc to Prv menu,exit)");
           }
           break;

         case  MOD_PPP_PORT_DATACOMP: 	  /* Added by Sreelu */
           if(!strcmp(ppp_enbl,telnet_enabled_str))
				  ret_str = EnaOrDis;
           else
              return("\n\rPPP is disabled\n\rEnter Esc to the PRV menu");
			  break;

			case  MOD_PPP_PORT_VJC_HC: 	/* Added by Sreelu */
           if(!strcmp(ppp_enbl,telnet_enabled_str))
				ret_str = EnaOrDis;
           else
            return("\n\rPPP is disabled\n\rEnter Esc to the PRV menu");
			  break;

			case  MOD_PPP_PORT_DODE: 	 /* Added by Sreelu */
      		get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].asyncport,	
		   		client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &asyc_enbl[0], 10);
            if(!strcmp(asyc_enbl,telnet_enabled_str))
				   ret_str = EnaOrDis;
            else
            {
               set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand,
            		client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &telnet_disabled_str[0]);
               return("\n\rWAN is in Synchronous Mode.\n\rEnter Esc to the PRV menu");
            }
				break;

			case  MOD_PPP_PORT_DOD_HANG: 	/* Added by Sreelu */
	        get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand,
			         port_no, CM_STRING_FORMAT, &dod_enbl[0], 10);
           if(!strcmp(dod_enbl,telnet_enabled_str))
				ret_str = NewValue;
           else
            return("\n\rDOD is disabled\n\rEnter Esc to the PRV menu");
			  break;

			case  MOD_PPP_PORT_USER_NAME: ret_str = NewValue;
												 	break;
			case  MOD_PPP_PORT_USER_PWD:  
						client_info_ptr->verifying_ppp_pwd = TRUE;
			case  MOD_PPP_PORT_TIMER	: 	
			case  MOD_PPP_PORT_RETRIES	: 	ret_str = NewValue;
												 	break;

			default:
			  sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
			  return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case  MOD_PPP_PORT_ENABLE:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);
         /* Added by Sreelu */

#if 0
         get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].slip_port.enabled,
            port_no, CM_STRING_FORMAT, &slip_str[0],10);         
                                                                                            
         if (( strcmp(slip_str,telnet_enabled_str) == 0 ) && ( strcmp(new_rhs,telnet_enabled_str) == 0 ))
                                                                                            
            return("\n\r SLIP is also Enabled.\n\r Enter (exit , ESC to previous menu) ");        
                                                                                            
         else 
         {                                                                                  
#endif

			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].enabled,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
         }
			break;

		case  MOD_PPP_PORT_DATACOMP:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);


			switch (set_parameter (CM_CCP_SECTION, (void*)&ccp.ports[0].enabled,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
         }
			break;

		case  MOD_PPP_PORT_VJC_HC:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
   		else
				return (InvalidChoice);

			switch (set_parameter (CM_VJC_SECTION,(void*)&vjc.port[0].vjc_compression_enabled,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		case  MOD_PPP_PORT_DODE:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
			 	return (InvalidChoice);

			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

	   case  MOD_PPP_PORT_DOD_HANG: /* Added by Sreelu */
			new_rhs = buffer;
	      get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand,
			       port_no, CM_STRING_FORMAT, &dod_enbl[0], 10);
         if(!strcmp(dod_enbl,telnet_enabled_str))
         {
			   switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout,
				  port_no, CM_STRING_FORMAT, new_rhs))
			   {
				 case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				 case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			   }
         }
			break;

	   case  MOD_PPP_PORT_USER_NAME:
			if (strlen (buffer) > 25)
				return (InvalidChoice);
         new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.user_name,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  MOD_PPP_PORT_USER_PWD:
			if (strlen (buffer) > 15)
			{
/*				client_info_ptr->verifying_ppp_pwd = FALSE;  Commented by Sreelu */
				ret_str = &InvalidPass[0];
				return (ret_str);	
			}
			modify_config_visited = 1 ; 
			strcpy (password_str, buffer);
			client_info_ptr->menustate = TMS_RETRY_PASSWORD ;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

      case  MOD_PPP_PORT_TIMER:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

      case  MOD_PPP_PORT_RETRIES:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	modify_config_visited = 1 ;
	client_info_ptr->menustate = TMS_MODI_PPPPORTINFO ;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
} 


BYTE *retry_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT port_no;


	if (!buffer)
		return (retry_pass);

	client_info_ptr->verifying_ppp_pwd = FALSE;

	port_no = client_info_ptr->menu_selected_port ;
	if (strcmp (buffer, password_str))
		return (wrong_pass);

   switch (set_parameter (CM_PPP_SECTION, (void *)&ppp.port[0].authentication.password,
				port_no, CM_STRING_FORMAT, buffer))
   {
     	case CM_NOT_ENOUGH_MEMORY:
			return Insufficient_memory;
   }

	client_info_ptr->menustate = TMS_MODI_PPPPORTINFO;
/*	client_info_ptr->echoing = FALSE; */
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE	*ppp_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	PPP_LCP_STATISTICS	*sptr_lcp_stats;
	PPP_LCP_MIBS	*sptr_lcp_mibs;
	PPP_NCP_STATISTICS	*sptr_ipxcp_stats;
	PPP_NCP_STATISTICS	*sptr_ipcp_stats;
	PPP_AUTHENTICATION_STATISTICS	*sptr_auth_stats;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;

			sptr_lcp_stats = &ppp.port[client_info_ptr->menu_selected_port].lcp_statistics;
			sptr_lcp_mibs = &ppp.port[client_info_ptr->menu_selected_port].lcp_mibs;

			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				client_info_ptr->menu_selected_port+1,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_lcp_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_lcp_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_lcp_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_lcp_stats->number_of_rx_bytes),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusBadAddresses),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusBadControls),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusPacketTooLongs),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusBadFCSs),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], sptr_lcp_mibs->pppLqrOutLQRs),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], sptr_lcp_mibs->pppLqrInLQRs));
			return(telnet.tx_buffer);
		case 1:
			client_info_ptr->more++;

/*			sptr_ipxcp_stats =&ppp.port[client_info_ptr->menu_selected_port].ncp[(enum NCP_STACK_INDEX)PPP_IPX_NCP_STACK_INDEX].statistics;
			sptr_ipcp_stats =&ppp.port[client_info_ptr->menu_selected_port].ncp[(enum NCP_STACK_INDEX)PPP_IP_NCP_STACK_INDEX].statistics; */
			sprintf(telnet.tx_buffer, PPPPortStats2,
				client_info_ptr->menu_selected_port+1,
/*				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_ipxcp_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_ipxcp_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_ipxcp_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_ipxcp_stats->number_of_rx_bytes), */

				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], sptr_ipcp_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], sptr_ipcp_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], sptr_ipcp_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], sptr_ipcp_stats->number_of_rx_bytes));
			return(telnet.tx_buffer);
		case 2:
			client_info_ptr->more++;

			sptr_auth_stats =&ppp.port[client_info_ptr->menu_selected_port].authentication.statistics;
			sprintf(telnet.tx_buffer, PPPPortStats3,
				client_info_ptr->menu_selected_port+1,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_auth_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_auth_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_auth_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_auth_stats->number_of_rx_bytes));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}

BYTE * auth_protocol_string (USHORT_ENUM (PPP_PROTOCOL_TYPE) protocol)
{
	switch (protocol) {
		case IP_PROTOCOL: return ("IP");
		case IPX_PROTOCOL: return ("IPX");
		case APPLETALK_PROTOCOL: return ("APPLETALK");
		case VAN_JACOBSON_COMPRESSED_PROTOCOL: return ("VJ_COMPRESSED");
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL: return ("VJ_UNCOMPRESSED");
		case BRIDGING_PROTOCOL: return ("BRIDGING");
		case NETBIOS_PROTOCOL : return ("NETBIOS");

		case _8021D_SPANNING_TREE_BPDU : return ("802.1D");
		case SOURCE_ROUTING_BPDU : return ("SOURCE_ROUTING");
		case DEC_LAN_BRIDGE_100 : return ("DEC_LAN_BRIDGE_100");

		case IPCP_PROTOCOL : return ("IPCP");
		case IPXCP_PROTOCOL: return ("IPXCP");
		case ATCP_PROTOCOL : return ("ATCP");
		case BCP_PROTOCOL : return ("BCP");
		case NBFCP_PROTOCOL: return ("NBFCP");
	
		case LCP_PROTOCOL : return ("LCP");
		case PAP_PROTOCOL : return ("PAP");
		case CHAP_PROTOCOL: return ("CHAP");
		case LINK_QUALITY_PROTOCOL: return ("LINK_QUALITY");
		default: return ("Unknown");
	}
}

BYTE *ipxcp_compr_protocol_string( USHORT_ENUM(IPXCP_COMPRESSION_OPTION_TYPE) protocol)
{
	switch (protocol) {
		case TELEBIT_IPX_COMPRESSION:
			return ("TELEBIT IPX");
		case SHIVA_COMPRESSED_NCP_IPX:
			return ("SHIVA	COMPRESSED NCP");
		default:
			return ("Unknown");
	}
}

BYTE *ipxcp_route_protocol_string( USHORT_ENUM (IPXCP_ROUTING_PROTOCOL_TYPE) protocol)
{
	 switch (protocol) 
    {
		case NO_IPXCP_ROUTING_PROTOCOL_REQUIRED:
			return ("Not Required");
		case NOVELL_RIP_SAP_REQUIRED:
			return ("NOVELL RIP-SAP");
		case NOVELL_NLSP_REQUIRED:
			return ("NOVELL NLSP");
		default:
			return ("Unknown");
	 }
}

int  checkif_fr_enabled()
{
		
/*	get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].all_other_parameters,
				0, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10); */


	if (strcmp (&ReplyStrs[0].ReplyStr[0], telnet_disabled_str))
		return 1;
	else
		return 0;

}


BYTE *confirm_client_only (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *new_rhs;

	if (!buffer)
		return (ClientOnlymes);

	if (*buffer == 'Y' || *buffer == 'y')
	{
		new_rhs = &telnet_enabled_str[0];
		switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].client_only,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
 		{
 			case CM_NOT_ENOUGH_MEMORY:
 				return Insufficient_memory;
 		}
		modify_config_visited = 1;
		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO ;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if (*buffer == 'N' || *buffer == 'n')
	{
		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO ;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}
