#if 0

#include	<defs.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include	"telnet.h"
#include	"vmenu.h"

#include	"..\..\stacks\spantree\kmacbr.h"
#include "..\..\stacks\spantree\vfdtstr.h"
#include "..\..\stacks\spantree\vmacbstr.h"

extern	STP_CLASS	stp_class;

/*	sudhir 3-10-96 */
#include "..\..\include\vnvrmstr.h"
#include <cfgmgr.h>

extern	enum FILTER_ACTION stp_filter_default_action;
extern void *malloc(ULONG);

extern 	CONFIGURATION_TABLE stp_configuration_table ;
extern int modify_config_visited;

extern 	int frame_relay_enabled;  	/* oss on 3-3-97 */
extern 	int no_of_stp_ports;			
/*void	generate_no_of_stp_ports_strings(int Flag); */	/* oss on 3-3-97 */ 
extern void	generate_no_of_ports_strings(int no_of_ports, int section_id);
void	add_delete_values_of_stp_port(int Flag, int port_no);
extern BYTE *get_port_type (USHORT port_type);


extern BYTE ChoiceBuffer[80];
extern void  delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr);
extern void  modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr);
extern void  set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr,
										BYTE *new_rhs);
extern void force_write_string_with_port_num (BYTE *, ULONG , BYTE *, PARA_STR *);
extern USHORT get_number_of_filters (BYTE *str_ptr);


/* sudhir 10/4/97 */
typedef struct STP_FILTER_TABLE
{
   USHORT port_number;
   enum	FD_TABLE_ENTRY_TYPE  filter_type;
   struct STP_FILTER_TABLE *next_ptr;
	BYTE mac_address[13];
}STP_FILTER_TABLE;

STRUCT_STP_FILTER temp_stp_filter;
STRUCT_STP_FILTER dup_stp_filter;
STRUCT_STP_FILTER *dummy_stp_filter;
PARAMETER_NODE *ptr_to_current_stp_node;
extern BYTE *get_ip_port_type (USHORT port_type);



BYTE stp_addr_filt[4][]={
"Spanning Tree Filter Destination Address",
"Spanning Tree Filter Source Address",
"Spanning Tree Forward Destination Address",
"Spanning Tree Forward Source Address"};



/*	sudhir 3-10-96 */
BYTE * fd_entry_type_string (USHORT_ENUM (FILTER) entry_type)
{
	switch (entry_type) 
	{
		case FILTER_ON_SOURCE: return ("Filter on source address") ;
		case FORWARD_ON_SOURCE : return ("Forward on source address") ; 
		case FILTER_ON_DESTINATION : return ("Filter on destination address") ; 
		case FORWARD_ON_DESTINATION : return ("Forward on destination address") ; 
		default:return ("Unknown");
	}
}


void add_fdt_entry_to_buffer(FILTERING_DATABASE_ENTRY *sptr_fdt_entry, BYTE index) 
{
	BYTE		tmp_buffer[81];

	sprintf(tmp_buffer, "%3d.   %08lx%04x        %2d        %s\n\r", 
		index,
		sptr_fdt_entry->source_address._ulong,
		sptr_fdt_entry->source_address._ushort,
		sptr_fdt_entry->port_number,
		fd_entry_type_string (sptr_fdt_entry->type));
	strcat(telnet.tx_buffer, tmp_buffer);

}



BYTE * port_state_string (USHORT_ENUM (PORT_STATE) state)
{
	switch (state) 
	{
		case DISABLED: return ("Disabled");
		case LISTENING: return ("Listening");
		case LEARNING: return ("Learning");
		case FORWARDING: return ("Forwarding");
		case BLOCKING: return ("Blocking");
		default: return ("Unknown");
	}
}


BYTE * stp_default_action_string (USHORT_ENUM (FILTER_ACTION) state)
{
	switch (state) 
	{
		 case FORWARD_PACKET: return ("Forward"); 
		 case FILTER_PACKET: return ("Filter"); 
		default: return ("Unknown");
	}
}


/* sudhir 13-9-96 */
BYTE	*modify_stp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE stp_def[] = "Spanning Tree Default Action";

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_SPANTREE_SECTION, (void *) &stp_class.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				

		get_parameter (CM_SPANTREE_SECTION, (void *) &stp_class.stp_algorithm_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 10);				

		get_parameter_by_name (CM_SPANTREE_SECTION, stp_def,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[2].ReplyStr[0], 10);				

      if (!ReplyStrs[2].ReplyStr[0])
         strcpy (&ReplyStrs[2].ReplyStr[0], "forward");

		sprintf (ChoiceBuffer, EnterChoice, 
						menufsmhdlr[client_info_ptr->menustate].num_of_items);

	 	sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0], &ReplyStrs[2].ReplyStr[0],
				GoBack, ChoiceBuffer);

	 	return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer) ;
	if ((client_info_ptr->modify_option_rcvd >= STP_BRIDGING_ENABLE) && 
	  (client_info_ptr->modify_option_rcvd <= STP_FILTERS))
	{
		client_info_ptr->menustate = TMS_STP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *stp_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;
	BYTE stp_def[] = "Spanning Tree Default Action";

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case STP_BRIDGING_ENABLE : 
			case STP_ALGORITHM_ENABLE: 
            ret_str = EnaOrDis;
				break;

			case STP_DEFAULT_ACTION	 : 
            ret_str = ForOrFilt;
				break;

			case STP_PORT_INFO       :
				client_info_ptr->menustate =  TMS_MODI_STPPORT;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
         
         case STP_FILTERS:
/*            client_info_ptr->menustate = TMS_NULL_FUNC;
            menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_STPMAIN;

				return (not_supported);  */

            client_info_ptr->menustate =  TMS_STP_FILTERS;
            client_info_ptr->next_screen = 0;
				client_info_ptr->ptr_to_last_read_linked_list = NULL;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
            
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);

		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
		case  STP_BRIDGING_ENABLE:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_SPANTREE_SECTION, (void *) &stp_class.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case  STP_ALGORITHM_ENABLE:	
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);
			
			switch (set_parameter (CM_SPANTREE_SECTION, (void *) &stp_class.stp_algorithm_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case  STP_DEFAULT_ACTION:	
			modify_config_visited = 1 ; 
			if (new_value == 1)
				new_rhs = Forward;
			else if (new_value == 2)
				new_rhs = Filter;
			else
				return (InvalidChoice);

			switch (set_parameter_by_name (CM_SPANTREE_SECTION, stp_def,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case  STP_PORT_INFO:
			client_info_ptr->menustate = TMS_MODI_STPPORT;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);

	}
   modify_config_visited = 1;
	client_info_ptr->menustate = TMS_MODI_STPMAIN;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE	*modify_stp_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

   frame_relay_enabled = 0;
	if (!buffer)
	{
		if (frame_relay_enabled)	//added by oss on 3-3-97
		{
			generate_no_of_ports_strings(no_of_stp_ports, STP_ID);
			return (telnet.tx_buffer);
		}
		generate_no_of_ports_strings(telnet.number_of_ports, STP_ID);
		return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);

	if (frame_relay_enabled)	/* added by oss on 3-3-97 */
	{
		if (port_number == no_of_stp_ports + 1)
		{
			return not_supported;

			if (no_of_stp_ports >= MAX_NUM_OF_PORTS)
				return (MAX_16_ports);
			no_of_stp_ports ++;
			add_delete_values_of_stp_port (0, port_number);
	 		client_info_ptr->menustate = TMS_STPPORT_INFO;
			client_info_ptr->menu_selected_port = port_number;  
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if (port_number == no_of_stp_ports + 2)
		{
			return not_supported;

		 	client_info_ptr->menustate = TMS_STP_DELETE_PORT;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if ((port_number > no_of_stp_ports) || (port_number < 1))
		{
			sprintf(telnet.tx_buffer, EnterProperChoice, no_of_stp_ports);
			return(telnet.tx_buffer);
		}
		else
		{
		 	client_info_ptr->menustate = TMS_STPPORT_INFO;
			client_info_ptr->menu_selected_port = port_number; 
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
	}

	if (port_number > telnet.number_of_ports ||	port_number < 1)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice,telnet.number_of_ports); 
		return(telnet.tx_buffer);
	}
   else
    	client_info_ptr->menustate = TMS_STPPORT_INFO;

	client_info_ptr->menu_selected_port = port_number; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE	*stp_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer) {
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port);
		return (telnet.tx_buffer);
	}

 	switch( atoi(buffer)) {
 		case STP_PORT_SETUP:
			client_info_ptr->menustate = TMS_MODI_STPPORTINFO;
			break;
 		case STP_PORT_STATS:
			client_info_ptr->menustate = TMS_STPPORTSTAT;
			break;
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_stp_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	STP_PORT_CLASS	*sptr_stp_port_class;
	BYTE stp_state[] = "Spanning Tree Port State";
	ULONG path_cost;

	sptr_stp_port_class = &stp_class.port[client_info_ptr->menu_selected_port];
	
	if (!buffer)
	{
		initialize_replystr ();

		get_parameter_by_name (CM_SPANTREE_SECTION, stp_state,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				

		get_parameter (CM_SPANTREE_SECTION, (void *) &stp_class.port[0].path_cost,
				client_info_ptr->menu_selected_port, CM_ULONG_FORMAT, &path_cost, 10);				

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port,
			&ReplyStrs[0].ReplyStr[0],
			MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], path_cost));
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= MOD_STP_PORT_STATE) &&
			(client_info_ptr->modify_option_rcvd <= MOD_STP_ROOT_PATHCOST))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_STPPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}			  


BYTE *upd_modify_stp_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value, port_no;
	BYTE span_st[] = "Spanning Tree Port State";

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_STP_PORT_STATE:
				ret_str = PortState;
				break;

			case MOD_STP_ROOT_PATHCOST	:
				ret_str = NewValue;
				break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   	return(telnet.tx_buffer);

		}
		return (ret_str);
	}
											/* in ini file stp port no: start at 01 */
	port_no = client_info_ptr->menu_selected_port ;		

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_STP_PORT_STATE:
			modify_config_visited = 1 ; 
			new_value = atoi (buffer);

			if (new_value == 1)
				new_rhs = "Disabled";
			else if (new_value == 2)
				new_rhs = "Listening";
			else if (new_value == 3)
				new_rhs = "Learning";
			else if (new_value == 4)
				new_rhs = "Forwarding";
			else if (new_value == 5)
				new_rhs = "Blocking";
			else
				return (InvalidChoice);
			
			switch (set_parameter_by_name (CM_SPANTREE_SECTION, span_st,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_STP_ROOT_PATHCOST	:
			modify_config_visited = 1 ; 

         new_value = atoi (buffer);
/*         if (new_value <= 0 || new_value > 50000)
         {
            return wrong_value; 
         }  */

			new_rhs = buffer;
			switch (set_parameter (CM_SPANTREE_SECTION, (void *) &stp_class.port[0].path_cost,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
            {
               client_info_ptr->menustate = TMS_WRONG_VALUE;
               menufsmhdlr[TMS_WRONG_VALUE].parentstate = TMS_MODI_STPPORTINFO;
					return wrong_value;
            }

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	client_info_ptr->menustate = TMS_MODI_STPPORTINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

int get_number_of_stp_ports()
{
	USHORT no_of_ports=0;

	return stp_class.number_of_spanning_tree_ports;
 
	get_parameter (CM_SPANTREE_SECTION, (void *) &stp_class.number_of_spanning_tree_ports ,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&no_of_ports, 10);				
	return no_of_ports;
}

void	generate_no_of_stp_ports_strings(int Flag)
{
	BYTE temp_buf[75];
	int i;

	strcpy (telnet.tx_buffer, "\n\r             << Select STP Port >> \n\r");
	for (i = 1; i <= no_of_stp_ports; i++)
	{
		sprintf (temp_buf, "\n\r[ %02d] Port %2d", i, i);
		strcat (telnet.tx_buffer, temp_buf);
	}
	if (!Flag)
	{
		sprintf (temp_buf, "\n\r[ %02d] Add Virtual Port", no_of_stp_ports + 1);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r[ %02d] Delete Virtual Port", no_of_stp_ports + 2);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r\n\rEnter Your Choice (1 to %d, exit, or ESC to PREV Menu):",
					no_of_stp_ports + 2);
	}
	else
		sprintf (temp_buf, "\n\r\n\rEnter Your Choice (1 to %d, exit, or ESC to PREV Menu):",
					no_of_stp_ports);
	strcat (telnet.tx_buffer, temp_buf);
}



void initialize_temp_stp_filter()
{
	temp_stp_filter.physical_port = 0;
	temp_stp_filter.filter_type = 0;
	strcpy (temp_stp_filter.ethernet_address, "0");
}  





BYTE *display_stp_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_STP_FILTER *ptr_to_stp_filter;
   STRUCT_STP_FILTER stp_filter;
   BYTE temp_buff[200];
   USHORT count=0, no_of_filters=0, index=0;
   PARAMETER_NODE *ptr_to_previous_node;
	
   
   if (!buffer)
   {
      if (client_info_ptr->next_screen)
      {
         if (ptr_to_current_stp_node != NULL)
            ptr_to_current_stp_node = cm_get_next_entry (CM_SPANTREE_SECTION, ptr_to_current_stp_node, (void *) &stp_filter);
      }
      else
      {
         ptr_to_current_stp_node = cm_get_first_entry (CM_SPANTREE_SECTION, "STP Filter", (void *) &stp_filter);

         if (ptr_to_current_stp_node == NULL)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, STPFilteringDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit, ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
      }
   
		strcpy (telnet.tx_buffer, STPFilteringDB);

      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "%3d      %-12s       %-4s        %s\n\r",
            client_info_ptr->index++,
            dummy_stp_filter->ethernet_address,
            get_ip_port_type (dummy_stp_filter->physical_port),
            fd_entry_type_string (dummy_stp_filter->filter_type));
         strcat (telnet.tx_buffer, temp_buff);
         if (ptr_to_current_stp_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT;
         }
      }


      ptr_to_stp_filter = (STRUCT_STP_FILTER *) &stp_filter;

      while (ptr_to_current_stp_node != NULL)
      {
         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "%3d      %-12s       %-4s        %s\n\r",
            client_info_ptr->index++,
            ptr_to_stp_filter->ethernet_address,
            get_ip_port_type (ptr_to_stp_filter->physical_port),
            fd_entry_type_string (ptr_to_stp_filter->filter_type));
         strcat (telnet.tx_buffer, temp_buff);

         
         if (ptr_to_current_stp_node != NULL)
            ptr_to_current_stp_node =  cm_get_next_entry (CM_SPANTREE_SECTION, ptr_to_current_stp_node, (void*)&stp_filter);

			if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_stp_node != NULL)
         {
            memcpy ((char *) &dup_stp_filter, (char *) &stp_filter, sizeof (STRUCT_STP_FILTER));
            dummy_stp_filter = (STRUCT_STP_FILTER *) &dup_stp_filter;
            client_info_ptr->next_screen++;
            break;
         }

/*       if (ptr_to_current_stp_node != NULL)
            ptr_to_current_stp_node =  cm_get_next_entry (CM_SPANTREE_SECTION, ptr_to_current_stp_node, (void*)&stp_filter); */

         if (ptr_to_current_stp_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }

         ptr_to_stp_filter = (STRUCT_STP_FILTER *) &stp_filter;

      }
SENDFILT:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit ,");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit, ESC to PREV menu):"); 

      return telnet.tx_buffer;
   }

	if ((*buffer == 'A') || (*buffer == 'a') && (strlen (buffer) == 1))
   {
      client_info_ptr->next_screen = 0;
      initialize_temp_stp_filter(); 
      client_info_ptr->menustate = TMS_STP_ADD_FILT;
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_STP_EDIT_FILTER;
   }
   else if ((*buffer == 'D') || (*buffer == 'd') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_STP_DEL_FILT;
   }
   else if ((*buffer == 'N') || (*buffer == 'n') && (strlen (buffer) == 1) && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_STP_FILTERS;
   }
   else
      return InvalidChoice;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



BYTE *te_edit_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_STP_FILTER stp_filter;
   STRUCT_STP_FILTER *ptr_to_stp_filter;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return InvalidFilter;
   }

   client_info_ptr->edit_index = index;

   ptr_to_current_stp_node = cm_get_first_entry (CM_SPANTREE_SECTION, "STP Filter",(void *) &stp_filter);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_stp_node = cm_get_next_entry (CM_SPANTREE_SECTION, ptr_to_current_stp_node, (void *) &stp_filter);
      if (ptr_to_current_stp_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }
   }  
   ptr_to_stp_filter = (STRUCT_STP_FILTER *) &stp_filter;
   temp_stp_filter.physical_port = ptr_to_stp_filter->physical_port;         
   temp_stp_filter.filter_type = ptr_to_stp_filter->filter_type;
   strcpy (temp_stp_filter.ethernet_address, ptr_to_stp_filter->ethernet_address);

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_STP_ADD_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *add_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

   STRUCT_STP_FILTER stp_filter;
   STRUCT_STP_FILTER *ptr_to_stp_filter;
   USHORT i=0;

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, STPfiltopt,
			temp_stp_filter.ethernet_address,
			get_ip_port_type (temp_stp_filter.physical_port),
			fd_entry_type_string (temp_stp_filter.filter_type));

		return telnet.tx_buffer;
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
    if (client_info_ptr->modify_option_rcvd >= STP_ETHER_ADDR &&
      client_info_ptr->modify_option_rcvd <= STP_FILTER_TYPE )
    {
      client_info_ptr->menustate = TMS_STP_UPD_FILT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer))
    {
      modify_config_visited = 1;
		client_info_ptr->next_screen = 0;
      
      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_stp_node = cm_get_first_entry (CM_SPANTREE_SECTION, "STP Filter",(void *) &stp_filter);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_stp_node = cm_get_next_entry (CM_SPANTREE_SECTION, ptr_to_current_stp_node, (void *) &stp_filter);
            if (ptr_to_current_stp_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return (InvalidFilter);                  
            }
         }  
         ptr_to_stp_filter = (STRUCT_STP_FILTER *) &stp_filter;
         client_info_ptr->edit_filter = 0;
         cm_edit_string (CM_SPANTREE_SECTION, "STP Filter", (void *)ptr_to_stp_filter, (void *) &temp_stp_filter);
      }
      else
         cm_insert_string (CM_SPANTREE_SECTION, "STP Filter", (void *) &temp_stp_filter);

      client_info_ptr->menustate = TMS_STP_FILTERS;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    else
      return InvalidChoice;
}

BYTE *upd_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   ULONG value=0;
   
   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
			case STP_ETHER_ADDR:
				return ("\n\rEnter Ethernet address:");

			case STP_PORT_NUMBER:
				return PortChoice;

			case STP_FILTER_TYPE:
				return Filtertype;
		}
	}

	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
   {
		case STP_ETHER_ADDR:
			if (strlen (buffer) > 12)
				return InvalidChoice;
			strcpy (temp_stp_filter.ethernet_address, buffer);
			break;
	
		case STP_PORT_NUMBER:
			if (value < 1 || value > 4)
				return InvalidChoice;
			temp_stp_filter.physical_port = value - 1;
			break;

		case STP_FILTER_TYPE:
			if (value < 1 || value > 4)
				return InvalidChoice;

			temp_stp_filter.filter_type = value - 1;
         break;
	}
	client_info_ptr->menustate = TMS_STP_ADD_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*stp_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{			
	STP_PORT_CLASS	*sptr_stp_port_class;

	sptr_stp_port_class = &stp_class.port[client_info_ptr->menu_selected_port];

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				client_info_ptr->menu_selected_port,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_stp_port_class->dot1dTpPortInFrames),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_stp_port_class->number_of_frames_discarded),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_stp_port_class->number_of_frames_forwarded),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_stp_port_class->number_of_forward_transitions),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], sptr_stp_port_class->number_of_rx_frames_filtered),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], sptr_stp_port_class->number_of_tx_frames_filtered));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}



BYTE *delete_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0 ;
   STRUCT_STP_FILTER stp_filter;
   STRUCT_STP_FILTER *ptr_to_stp_filter;

   if (!buffer)
   {
      return EnterFilter;
   }

   index = atoi (buffer) - 1;
   printf ("delete index %d\n",index);

   ptr_to_current_stp_node = cm_get_first_entry (CM_SPANTREE_SECTION, "STP Filter",(void *) &stp_filter);
   for (i=0; i < index; i++)
   {
      ptr_to_current_stp_node = cm_get_next_entry (CM_SPANTREE_SECTION, ptr_to_current_stp_node, (void *) &stp_filter);
      if (ptr_to_current_stp_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }            
   }  

   ptr_to_stp_filter = (STRUCT_STP_FILTER *) &stp_filter;
   cm_remove_string (CM_SPANTREE_SECTION, "STP Filter", (void *)ptr_to_stp_filter);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;


	client_info_ptr->menustate = TMS_STP_FILTERS;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*stp_port_delete_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, PortNoToDelete, "STP");
		return(telnet.tx_buffer);
	}

	new_value = atoi (buffer);
	if ((new_value < 2 ) || (new_value > no_of_stp_ports))
	{
		sprintf (telnet.tx_buffer, EnterOption, 2, no_of_stp_ports);
		return (telnet.tx_buffer);
	}
	else
	{
		no_of_stp_ports -- ;
		add_delete_values_of_stp_port (1, new_value);
	}
 	client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
 	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



void	add_delete_values_of_stp_port(int Flag, int port_no)
{
	BYTE *new_rhs, *lhs_para_str;
	ULONG offset;
	BYTE temp_store_for_del[100], temp[25], store_lhs[40];
	int i;

	sprintf (temp, "%02d", no_of_stp_ports);
	set_rhs_in_link_list ( (ULONG) ((ULONG) &stp_class.number_of_spanning_tree_ports -
			(ULONG) &stp_class), stp_configuration_table, NOT_PORT_PARAMETER,
			Pointers_SectHdr.ptrs[2], &temp[0]);

	strcpy (store_lhs, "Spanning Tree Port State");
	lhs_para_str = store_lhs;
	if (!Flag)
	{
		port_no ++;
		strcpy (temp, "forwarding");
		new_rhs = &temp[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[2]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[2]);
		for (i = port_no; i <= no_of_stp_ports; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[2]);
	}

	offset = (BYTE *) &stp_class.port[0].path_cost - (BYTE *) &stp_class;
/*	lhs_para_str = get_lhs_str (offset, stp_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "1000");
		new_rhs = &temp[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[2]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[2]);
		for (i = port_no; i <= no_of_stp_ports; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[2]);
	}

	offset = (BYTE *) &stp_class.port[0].maximum_packet_size - (BYTE *) &stp_class;
/*	lhs_para_str = get_lhs_str (offset, stp_configuration_table); */
	if (!Flag)
	{
  		strcpy (temp, "1534");
		new_rhs = &temp[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[2]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[2]);
		for (i = port_no; i <= no_of_stp_ports; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[2]);
	}

	offset = (BYTE *) &stp_class.port[0].wan_port - (BYTE *) &stp_class;
/*	lhs_para_str = get_lhs_str (offset, stp_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_disabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[2]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[2]);
		for (i = port_no; i <= no_of_stp_ports; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[2]);
	}
	modify_config_visited = 1 ; 
}
#endif




