#include	<defs.h>
#include	"telnet.h"

BYTE	subnegfsm[NSSTATES][NCHRS];

struct	fsm_trans	subnegstab[] = {
	/* State			Input				NextState			Action	*/
	/* -----			-----				---------			------	*/
	{ SS_START,		TOTERMTYPE,		SS_TERMTYPE,		no_opt },
	{ SS_START,		TCANY,			SS_END,				no_opt },

	{ SS_TERMTYPE,	TT_IS,			SS_TERMNAME,		no_opt },
	{ SS_TERMTYPE,	TCANY,			SS_END,				no_opt },

/*	{ SS_TERMNAME,	TCANY,			SS_TERMNAME,		subtermtype	}, */

	{ SS_END,		TCANY,			SS_END,				no_opt },
	{ FSINVALID,	TCANY,			FSINVALID,			abort	},
};

			
/****************************************************************************
	Routine		: subopt
	Input			: Index to TELNET structure corresponding to this connection.
						Character - received.
	Synopsis		: Call FSM for sub-negotiation characters reeived.
****************************************************************************/

USHORT	subopt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	struct	fsm_trans	*pt;
	USHORT					ti;

	ti = subnegfsm[client_info_ptr->subnegstate][character];
	pt = &subnegstab[ti];
	(pt->ft_action)(client_info_ptr, character);
	client_info_ptr->subnegstate = pt->ft_next;
	return 1;
}


/****************************************************************************
	Routine		: subend
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: End of option subnegotiation. Go back to start state.
****************************************************************************/

USHORT	subend(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT	subnegstate;

	subnegstate = client_info_ptr->subnegstate;
	client_info_ptr->subnegstate = SS_START;

	if( subnegstate == SS_TERMNAME) {
		/* If terminal type was negotiated, check if it is supported */
	}
	return 1;
}

#if 0	
/****************************************************************************
	Routine		: subtermtype
	Input			: Index to TELNET structure corresponding to this connection.
						Character - received.
	Synopsis		: Saves the Terminal Type string sent by the client.
****************************************************************************/

USHORT	subtermtype(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	if(strlen(client_info_ptr->terminal) < TERMINAL_NAME ) 
		strcat(client_info_ptr->terminal, character);
	return 1;
}	

/****************************************************************************
	Routine		: request_termtype
	Input			: Index to TELNET structure corresponding to this connection.
	Synopsis		: Sends a request to the client asking for its terminal type.
****************************************************************************/

void	request_termtype(TELNET_CLIENT_CLASS *client_info_ptr)
{
	USHORT			i=0;

	telnet.tx_buffer[i++] = TCIAC;
	telnet.tx_buffer[i++] = TCSB;
	telnet.tx_buffer[i++] = TOTERMTYPE;
	telnet.tx_buffer[i++] = TT_SEND;
	telnet.tx_buffer[i++] = TCIAC;
	telnet.tx_buffer[i++] = TCSE;
	send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0);
}
#endif


