#include	<defs.h>
#include	<string.h>
#include	<stdio.h>

#include	"telnet.h"
#include	"ksocket.h"
#include	"menu.h"
#include	"dialout.h"

#include "..\..\store\boot.h"

#include	"..\..\devdrvrs\uim\chat\kchat.h"
#include	"..\..\devdrvrs\uim\chat\vchatstr.h"
#include	"..\..\devdrvrs\uim\chat\vchat.h"

#include <incall.h> 
#include <cfgmgr.h>


extern delayed_transmit(TELNET_CLIENT_CLASS *);
extern telnet_flash_write_timer (void) ;


/* Deepak 12/05/97... */
extern BYTE configuration_through_SMC_in_progress (void);
/* ...Deepak 12/05/97 */

extern int modify_config_visited;
extern int test_pass;

extern void terminal_server_timer () ;

void connect_to_server (TELNET_CLIENT_CLASS *client_info_ptr);

/****************************************************************************
	Routine		: check_for_telnet_request
	Input			: Nil					  	
	Synopsis		: Accepts any connection requests if maximum connections is
						not reached. Reads requests from already connected clients. 
****************************************************************************/
void	check_for_telnet_request(void)
{
	int		wConSock;		/* TCP (Connected) Socket */
	SOCKADDR_IN  stClientAddr;      /* Sockets Remote Address Structure */
	int		index,Inlen;
	TELNET_CLIENT_CLASS	*connection_ptr;
	USHORT	wAddrLen = sizeof(SOCKADDR_IN);
	ULONG		socket_error;

	if (telnet.timer_enabled == FALSE) 
		return;
  
   

/* Sudhir 28/10/1996 */
	telnet_flash_write_timer () ;
/* Sudhir 28/10/1996 */

	/* When Chat is going on with a TELNET client, we will not accept any
	** new TELNET client connection requests. All existing clients will be 
	** closed and only the chatting client will remain open. 
	*/

	if (ChatClientPtr) 
	{
		/* If this connection has a SEND waiting, send NOW. */
		if (ChatClientPtr->delayed_tx_buffer != NULL)
				delayed_transmit(ChatClientPtr);
		else
		{
			if ((Inlen = recv(ChatClientPtr->socket_num, telnet.recv_buffer, MAX_TCP_PKT, 0)) <= 0) 
			{
				/* get the error number */
				lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
				if (socket_error != WOULD_BLOCK_ERROR && (configuration_through_SMC_in_progress () != 1)) 
				{
					tel_printf(TELNET_ALARM,"TELNET: Socket read error, closing connection\n");
					close_connection(ChatClientPtr);
				}
			} 
			else 
			{
				tel_printf(TELNET_RXTX,"TELNET: Received a packet from a client.\n");
				socket_in(ChatClientPtr, telnet.recv_buffer, Inlen );
			} 		
		}
		return;
	}
	

	if (telnet.num_of_connected_clients < telnet.max_telnet_connections) 
	{
		if ((wConSock = accept(telnet.socket_descriptor, (SOCKADDR *)&stClientAddr, &wAddrLen)) == FAILED) 
		{
			/* get the error number */
			lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
			if (socket_error != WOULD_BLOCK_ERROR)
				tel_printf (TELNET_ALARM,"TELNET: Socket accept failed\n");
		} 
		else 
		{
			if ((connection_ptr = get_free_client_entry())) 
			{
				/* Fill in structure for new connection & allocate buffers */

				if (initialize_client(connection_ptr, wConSock)) 
				{
					tel_printf(TELNET_RXTX,"TELNET: Accepted a new connection.\n");

					telnet.num_of_connected_clients++;
					memcpy(&connection_ptr->stClientAddr, &stClientAddr, wAddrLen);

					/* start option negotiation */
					options_negotiate(connection_ptr);
					welcome_to_telnet(connection_ptr);
				} 
				else
					closesocket(wConSock);
			}
			else
				closesocket(wConSock);
		}
	}
	
	connection_ptr = telnet.clients_info;
	for (index = 0; index < telnet.max_telnet_connections; index++, connection_ptr++) 
	{
		if (connection_ptr->in_use == FALSE || connection_ptr->force_close == TRUE)
			continue;
		

/* sudhir for proxy statistics */
		if (connection_ptr->menustate == TMS_DISPLAY_PROXY_STATI || 
			connection_ptr->menustate == TMS_DISPLAY_PORT_STATUS || 
				connection_ptr->menustate == TMS_PROXY_PORT_STAT_INFO)
		{
			connection_ptr->stati_update_timeout--;
			if (!connection_ptr->stati_update_timeout)
			{
				connection_ptr->stati_update_timeout = 1200;
				menu_state_machine (connection_ptr, NULL);
			}
		}

		if (connection_ptr->menustate == TMS_DIALOUT_MODEM_INIT ||
				connection_ptr->menustate == TMS_DIALOUT_MODEM_HUP)
			continue;	/* Do no socket send or receive in such states */

		/* If this connection has a SEND waiting, send NOW. */
		if (connection_ptr->delayed_tx_buffer) 
			delayed_transmit(connection_ptr);

		if (connection_ptr->bytes_in_char_buffer != 0 && connection_ptr->menustate == TMS_DIALOUT_CHAT)
		{
			/* A previous socket read was not able to send the packet out onto
			** the serial side. So do no further socket reads until the old
			** read packet is sent out.
			*/
			/* Also note that for this check, we are using a variable that is 
			** not updated in all places. This is okay as only file transfer's 
			** are buffered.
			*/
			if (chat_send_wan_packet(connection_ptr->char_buffer_ptr, connection_ptr->bytes_in_char_buffer, connection_ptr->menu_selected_port) == FAIL)
			{
				/* Send failed, keep the buffer until later. Do no further
				** socket reads until then in the timer code. Rather try to
				** do this serial send.
				*/
			}
			else
			{
		 		connection_ptr->bytes_in_char_buffer = 0;
			}
		}
		if (connection_ptr->menustate == TMS_DIALOUT_CHAT)
		{
			/* For sessions in dialout mode, decrement the idle timer.
			** If timer has gone to 0, terminate the session forcibly.
			** This timer is set back to max whenever there is serial
			** activity on this connection.
			*/
			if (connection_ptr->dialout_idle_timer == 0)
			{
				dialout_session_timed_out(connection_ptr);
			}
			else
				--connection_ptr->dialout_idle_timer;
		}
	} 
   if (telnet.terminal_server_enabled)
	   terminal_server_timer () ;
}


/****************************************************************************
	Routine		: options_negotiate
	Input			: Index to TELNET structure corresponding to this connection.					  	
	Synopsis		: Starts option negotiation by refusing to send GA.
****************************************************************************/

void	options_negotiate(TELNET_CLIENT_CLASS	*client_info_ptr)
{
	test_pass = 1;
	/* send will suppress go-ahead */
	client_info_ptr->option_cmd = TCDO;
	will_noga (client_info_ptr, TONOGA);

	/* send will echo */
	client_info_ptr->option_cmd = TCDO;
	will_echo(client_info_ptr, TOECHO);

	/* send will termtype */
	/* send will transmit-binary */
}





