#include	<defs.h>
#include	<string.h>

#include	"telnet.h"

/****************************************************************************
	Routine		: do_txbinary
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: Generates Response/Request for clients Binary-Tx option.
****************************************************************************/

USHORT	do_txbinary(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->rcvbinary) {
		if (client_info_ptr->option_cmd == TCWILL)
			return 1;
	} else if (client_info_ptr->option_cmd == TCWONT)
			return 1;

	client_info_ptr->rcvbinary = !client_info_ptr->rcvbinary;

	telnet.tx_buffer[i++] = TCIAC;
	if (client_info_ptr->rcvbinary)
		telnet.tx_buffer[i++] = TCDO;
	else
		telnet.tx_buffer[i++] = TCDONT;

	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}
 
	
/****************************************************************************
	Routine		: will_txbinary
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: Generates Response/Request for Binary-Transmission option.
****************************************************************************/

USHORT	will_txbinary(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->sndbinary) {
		if (client_info_ptr->option_cmd == TCDO)
			return 1;
	} else if (client_info_ptr->option_cmd == TCDONT)
			return 1;

	client_info_ptr->sndbinary = !client_info_ptr->sndbinary;

	telnet.tx_buffer[i++] = TCIAC;
	if (client_info_ptr->sndbinary)
		telnet.tx_buffer[i++] = TCWILL;
	else
		telnet.tx_buffer[i++] = TCWONT;

	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));

}

