#ifndef _TFTPIO_H_
#define _TFTPIO_H_

enum LOCK_STATUS { LOCK_STATUS_OFF, LOCK_STATUS_ON } ;
enum OPEN_MODE { OPEN_FOR_READ, OPEN_FOR_WRITE } ;

typedef struct FILE_INFO
{
	BYTE *file_name ;
	BYTE *file_address ;
	enum LOCK_STATUS write_lock ;
   ULONG file_length ;
} FILE_INFO ;

typedef struct MEMORY_BLOCK
{
	struct MEMORY_BLOCK *ptr_to_next_block ;
	ULONG block_length ;
	BYTE start_of_data[1] ;
} MEMORY_BLOCK ;

typedef struct FILE_HANDLE
{
	enum OPEN_MODE open_mode ;
	BYTE file_name[20] ;
	BYTE *file_address ;
	ULONG file_length ;
	BYTE *file_seek_ptr ;
	ULONG no_of_bytes_read ;
	MEMORY_BLOCK *memory_blocks_chain ;
	MEMORY_BLOCK *last_memory_block ;
	USHORT accumulated_crc ;
#ifdef USER_EVENT_LOG
	ULONG	user_log_descriptor;			/* Imran 22.3.99 */
#endif
} FILE_HANDLE ;

enum TFTP_FILEIO_ERROR_CODE
{
	SUCCESS = 0,
	FILE_NOT_FOUND,
	HANDLE_TABLE_FULL,
	INVALID_HANDLE,
	MEM_ALLOC_FAILED,
	READ_ACCESS_DENIED,
	WRITE_ACCESS_DENIED,
	INCORRECT_MAGIC_NUMBER,
	INCORRECT_CHECKSUM
} ;


typedef struct HEADER_TYPE
{
	BYTE version[10] ;
	BYTE date_stamp[25] ;
	BYTE dummy ;
	USHORT magic_number ;
	USHORT crc ;
	ULONG code_length ;
	BYTE *down_load_address ;
	BYTE *load_address ;
	BYTE *start_address ;
	BYTE reserved[20] ;
	BYTE padding[436] ;
} HEADER_TYPE ;



FILE_HANDLE *tftp_open (BYTE *file_name, enum OPEN_MODE open_mode) ;
ULONG tftp_read (BYTE *buffer, ULONG buffer_length, FILE_HANDLE *file_handle) ;
ULONG tftp_write (BYTE *buffer, ULONG buffer_length, FILE_HANDLE *file_handle) ;
int tftp_close (FILE_HANDLE *file_handle) ;
void tftp_release (FILE_HANDLE *file_handle) ;

#endif
