#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "userdata.h"

GROUP_PROFILE_NODE far *sptr_group_profile_tree;

static GROUP_PROFILE_NODE far *get_new_group_rb_node ()
{
	return ((GROUP_PROFILE_NODE far *) malloc (sizeof (GROUP_PROFILE_NODE))) ;
}

int group_RB_profile_insert_node(GROUP_PROFILE_NODE far *Tree, GROUP_PROFILE_KEY_TYPE  key, GROUP_PROFILE *info, GROUP_PROFILE_NODE far **ptr_sptr_new_node)
{
	GROUP_PROFILE_NODE far *nptr ;

	int retVal ;

	retVal = group_rb_profile_compare_key(Tree, key);	  

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (group_RB_profile_insert_node ((GROUP_PROFILE_NODE far *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_group_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
	
			nptr->key = key ;
			nptr->info = info ;
		
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER *)nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
			return (group_RB_profile_insert_node ((GROUP_PROFILE_NODE far *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_group_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;

			nptr->key = key ;
			nptr->info = info ;

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER *) nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}

	return USER_RB_UPDATED ;
}

int group_RB_profile_insert(GROUP_PROFILE_KEY_TYPE key, GROUP_PROFILE *info)
{
	GROUP_PROFILE_NODE far *nptr, far *sptr_new_node ;
	int retVal ;

	if (sptr_group_profile_tree == (GROUP_PROFILE_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_group_rb_node() ;

		if (nptr == NULL)
			return USER_RB_INSERT_OVERFLOW ;

		nptr->key = key ;
		nptr->info = info ;

		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_group_profile_tree = nptr ;

		return USER_RB_NEW_ENTRY ;
	}

	retVal = group_RB_profile_insert_node (sptr_group_profile_tree, key, info, &sptr_new_node) ;

	if (retVal == USER_RB_NEW_ENTRY)
	{
		sptr_group_profile_tree = (GROUP_PROFILE_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER *)sptr_new_node, (RED_BLACK_NODE_HEADER *)sptr_group_profile_tree) ;
	}

	return retVal ;
}

void add_entry_to_group_profile_rb_tree (GROUP_PROFILE *group_info,unsigned char *vptr_buffer)
{
	GROUP_PROFILE *info;

	if (sptr_group_profile_tree == NULL)
		sptr_group_profile_tree = (GROUP_PROFILE_NODE far *) sptr_RB_sentinal_node;

	info = group_info;

   group_RB_profile_insert (*((GROUP_PROFILE_KEY_TYPE *)(vptr_buffer)), info) ;
}

GROUP_PROFILE_NODE far *group_rb_profile_search(GROUP_PROFILE_NODE far *Tree, GROUP_PROFILE_KEY_TYPE key)
{
	int ret_val ;
	
	if (Tree == NULL)
		return NULL ;

	if (Tree == (GROUP_PROFILE_NODE far  *)sptr_RB_sentinal_node)
		return NULL ;

/*	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (GROUP_PROFILE_KEY_TYPE)) ; */

	ret_val = group_rb_profile_compare_key(Tree, key);	 

	if (ret_val < 0)
	{
		return group_rb_profile_search ((GROUP_PROFILE_NODE far *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return group_rb_profile_search((GROUP_PROFILE_NODE far *)Tree->rb_header.LChild, key) ;
	}
	else
	{
 		return Tree ;
 	}
}

int delete_entry_from_group_profile_rb_tree (GROUP_PROFILE_KEY_TYPE key)
{
   GROUP_PROFILE_NODE far *sptr_node_to_delete ;

   sptr_node_to_delete = group_rb_profile_search (sptr_group_profile_tree, key) ;

   if (sptr_node_to_delete)
   {
      RB_delete ((RED_BLACK_NODE_HEADER *)sptr_group_profile_tree, (RED_BLACK_NODE_HEADER *)sptr_node_to_delete, (unsigned long) sizeof (GROUP_PROFILE_NODE), (RED_BLACK_NODE_HEADER **)&sptr_node_to_delete) ;
		free(sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}


int group_rb_profile_compare_key ( GROUP_PROFILE_NODE far *Tree, GROUP_PROFILE_KEY_TYPE key)
{

#if 0
	printf("\nTree Parameter:.......");
	printf("\ngroup Name : %s",Tree->key.group_name);
	printf("\nKey Parameter:........");
	printf("\ngroup Name : %s",key.group_name);
#endif

	if (!strcmp(Tree->key.group_name, key.group_name))
		return 0;
	else
		return(strcmp(Tree->key.group_name, key.group_name));			
}


void display_group_profile_tree ()
{
	int index=0 ;
	GROUP_PROFILE_NODE far  *sptr_root = sptr_group_profile_tree, far *sptr_next_node;

	if(sptr_group_profile_tree == NULL)
		return;

	sptr_next_node = (GROUP_PROFILE_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	if (sptr_next_node == NULL)
	{
		printf("\n The Group Profile Tree is empty") ;
		return;
	}

	printf ("\n **");
	printf ("\n          Displaying Group Profile Tree             ") ;
	printf ("\n **");


	while (sptr_next_node)
	{
		printf ("\n [%s] ", sptr_next_node->info->group_name);

		++index ;
					
		sptr_next_node = (GROUP_PROFILE_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

	printf ("\n **");
	printf ("\n     Total Number of Entries : %d", index) ;
	printf ("\n **\n\n");
}

void 
age_group_profile_rb_tree ()
{
	GROUP_PROFILE_NODE far *sptr_next_node, far *sptr_temp;
	GROUP_PROFILE_KEY_TYPE key;

	if(sptr_group_profile_tree == NULL)
		return;
	
	sptr_next_node = (GROUP_PROFILE_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *) sptr_group_profile_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;

      if (sptr_temp->info->group_age_flag == DONOT_AGE_FLAG)
		{
 	       sptr_group_profile_tree = (GROUP_PROFILE_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_group_profile_tree,
				          (RED_BLACK_NODE_HEADER *)sptr_temp,
                      (unsigned long) sizeof (GROUP_PROFILE_NODE),
                      (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
			free(sptr_temp);
		}
#if 0		/* Commented by Sreelu */
		else
		{
	      if (sptr_temp->info->group_age_flag == MARK_AGE_FLAG)
				sptr_temp->info->group_age_flag = DONOT_AGE_FLAG;
      }
#endif
		sptr_next_node = (GROUP_PROFILE_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
   }
}

/* Added by Sreelu */
void update_group_profile_tree()
{
	GROUP_PROFILE_NODE far *sptr_root = sptr_group_profile_tree, far *sptr_next_node;
	
	if(sptr_group_profile_tree == NULL)
		return;

	sptr_next_node = (GROUP_PROFILE_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		sptr_next_node->info->group_age_flag = DONOT_AGE_FLAG;
		sptr_next_node = (GROUP_PROFILE_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
}
