/**  **/
/*	Author	: Ravi																		*/
/*	Date		: 19 Feb 1999																*/
/*	Synopsis	: Complete authentication of an user is done here				*/
/**  **/
#include <defs.h>

#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <kstart.h>

#include <string.h>
#include <memory.h>
#include "userdata.h"

#include "\rtrware\rwutils\evntstr.h"

/* Function Prototypes */
extern APP_FILTER_NODE far *spr_app_filter_tree;
extern IP_ADD_FILTER_NODE far *sptr_ipadd_filter_tree;
enum BOOLEAN check_if_packet_is_authenticated_for_access (UNION_IP_PACKET *, IP_PARAMETERS *, enum BOOLEAN *, enum BOOLEAN *);
extern USER_ONLINE_TRANSITION_NODE *sptr_user_online_tree;
extern USER_ONLINE_TRANSITION_NODE *user_rb_demo_search (USER_ONLINE_TRANSITION_NODE *, USER_ONLINE_TRANSITION_KEY_TYPE );
extern ULONG user_online_transition_timeout;
extern APP_FILTER_NODE far *app_filter_rb_search(APP_FILTER_NODE far * , APP_FILTER_KEY );
extern IP_ADD_FILTER_NODE far *ipadd_filter_rb_search(IP_ADD_FILTER_NODE far *, IP_ADD_FILTER_KEY );
extern enum BOOLEAN is_filter_enabled(USHORT , BYTE *);
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern USHORT get_application_port_number (BYTE *, IP_PARAMETERS *,USHORT *, enum IP_PROTOCOL_VALUE *);
extern GROUP_PROFILE_NODE far *group_rb_profile_search(GROUP_PROFILE_NODE far *, GROUP_PROFILE_KEY_TYPE );
extern GROUP_PROFILE_NODE far *sptr_group_profile_tree;
extern IP_ADD_DEFAULT_NODE far *ipadd_default_rb_search(ULONG); 
extern APP_DEFAULT_NODE far *app_default_rb_search(USHORT, USHORT);
extern void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);
extern USER_DATABASE_CLASS user_database;

/* Added by Sreelu for Filters.......... */
enum BOOLEAN check_in_forbidden_list_for_destination_address (ULONG destination_address, USHORT group_no, BYTE_ENUM (BOOLEAN) *default_filter_action)
{
	IP_ADD_FILTER_KEY  key;
	IP_ADD_FILTER_NODE far *ptr_ip_add_node;
	
	key.ip_address = destination_address;
	ptr_ip_add_node = ipadd_filter_rb_search(sptr_ipadd_filter_tree, key);

/* if *default_filter_action is TRUE - check for application list else don't */

	if(!user_database.user_database_enabled)
	{
		if(user_database.default_action == FORWARD_ACTION)
		{
			*default_filter_action = TRUE;
			if (ptr_ip_add_node == NULL) 
				return TRUE;
			else
			   return FALSE;
		}
		else
		{
			*default_filter_action = (ptr_ip_add_node != NULL) ? FALSE : TRUE;
			return TRUE;
		}
	}

	if(ptr_ip_add_node == NULL)
		return TRUE;
	else
		*default_filter_action = TRUE; /* default_filter_action is used to indicate whether default action should be taken or not */

	if(is_filter_enabled(group_no, &ptr_ip_add_node->info->group_mask))
	{ 
		if(ptr_ip_add_node->info->action == FORWARD_ACTION)
		{
/*			printf("IP Forward & Enabled\n"); */
			return TRUE;
		}
		else
			return FALSE;
	}
	else
	{
		*default_filter_action = FALSE; /* default_filter_action is used to indicate whether default action should be taken or not */
		return TRUE;
	}
}

enum BOOLEAN check_if_application_is_to_be_restricted (USHORT protocol , USHORT application_port, USHORT group_no, BYTE_ENUM (BOOLEAN) *default_filter_action)
{
	APP_FILTER_KEY  key;
	APP_FILTER_NODE far *ptr_ip_app_node;

	key.port	= application_port;
	key.protocol = protocol;
	ptr_ip_app_node = app_filter_rb_search(spr_app_filter_tree, key);

	if(!user_database.user_database_enabled && *default_filter_action)
	{
		if(user_database.default_action == FORWARD_ACTION)
		{
			if (ptr_ip_app_node == NULL) 
				return TRUE;
			else
				return FALSE;
		}
		else
		{
			if (ptr_ip_app_node != NULL) 
				return TRUE;
			else
				return FALSE;
		}
	}
		
	if(ptr_ip_app_node == NULL)
		return TRUE;
	else
		*default_filter_action = TRUE; /* default_filter_action is used to indicate whether default action should be taken or not */
	
	if(is_filter_enabled(group_no, &ptr_ip_app_node->info->group_mask))
	{
		if(ptr_ip_app_node->info->action == FORWARD_ACTION)
		{
/*			printf("App Forward & Enabled\n"); */
			return TRUE;
		}
		else
			return FALSE;
	}
	else
	{
		*default_filter_action = FALSE; /* default_filter_action is used to indicate whether default action should be taken or not */
		return TRUE;
	}
}

USHORT check_for_default_filter_action(USER_ONLINE_TRANSITION_NODE *ptr_to_online)
{
	return (ptr_to_online->info->ptr_user_profile_node->info->sptr_user_group_profile_node->info->allow_sites);
}

enum BOOLEAN check_if_packet_is_to_accessed_without_authentication(ULONG ip_address, USHORT port, USHORT protocol)
{
	if(ipadd_default_rb_search(ip_address) == NULL)
	{		
		if(app_default_rb_search(port,protocol) == NULL)
			return FALSE;
	}
	return TRUE;		
}

enum BOOLEAN check_if_packet_is_to_be_filtered(IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN *abort_forwarding, USHORT application_port)
{
	BYTE_ENUM (BOOLEAN) default_filter_action;

/*	(user_database.default_action) ? default_filter_action = TRUE : default_filter_action = FALSE; */
		
	if (check_in_forbidden_list_for_destination_address (sptr_ip_parameters->destination_address, 0, &default_filter_action) == FALSE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}
	else
	if (check_if_application_is_to_be_restricted (sptr_ip_parameters->protocol, 
			application_port, 0, &default_filter_action) == FALSE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}
	return TRUE;
}
	
/* ..........Added by Sreelu for Filters */	
		  
enum BOOLEAN check_if_packet_is_authenticated_for_access (UNION_IP_PACKET *uptr_ip_rx_packet,IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN *abort_forwarding, enum BOOLEAN *user_authenticated)
{
	USER_ONLINE_TRANSITION_NODE *temp_user_online_transition_node;
	USER_ONLINE_TRANSITION_KEY_TYPE	user_online_tranistion_key_type;
	USHORT application_port=0, destination_port=0, group_no;
	enum IP_PROTOCOL_VALUE protocol_type;
	BYTE_ENUM (BOOLEAN) default_filter_action = FALSE;
	EVENT_HEADER event_broadcast_packet;

	application_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
				sptr_ip_parameters, &destination_port, &protocol_type );

	if(!user_database.user_database_enabled)
	{
/*		printf("Userdatabase is disabled\n");  */
		if (check_if_packet_is_to_be_filtered(sptr_ip_parameters, abort_forwarding, application_port) == TRUE)
			return TRUE;
		else
			return FALSE;
	}


	if(check_if_packet_is_to_accessed_without_authentication(sptr_ip_parameters->source_address, 
			application_port, sptr_ip_parameters->protocol) == TRUE)
		return TRUE;		

	user_online_tranistion_key_type.ip_address = sptr_ip_parameters->source_address;
	temp_user_online_transition_node = user_rb_demo_search(sptr_user_online_tree, user_online_tranistion_key_type);
	if (temp_user_online_transition_node != NULL)
	{
		/* Todo : Check if the packet is to be Filtered.
					 Enforce Filtering scheme here.		 
		*/

		group_no = temp_user_online_transition_node->info->group_no;	/* Added by Sreelu */	

		temp_user_online_transition_node->info->age = user_online_transition_timeout;
		
/* Added by Sreelu for Filters.......... */
		if (check_in_forbidden_list_for_destination_address (sptr_ip_parameters->destination_address, group_no, &default_filter_action) == FALSE)
		{
			if(temp_user_online_transition_node->info->ptr_user_profile_node->info->sptr_user_group_profile_node->info->defaulter_blacklisted_sites)		
				temp_user_online_transition_node->info->ptr_user_profile_node->info->defaulter_number_of_attempts_of_blacklisted_sites++ ;
				
			strcpy(event_broadcast_packet.username, temp_user_online_transition_node->info->user_name);
			strcpy(event_broadcast_packet.groupname, temp_user_online_transition_node->info->group_name);
			strcpy(event_broadcast_packet.login_time, temp_user_online_transition_node->info->login_time);
			event_broadcast_packet.ip_address = temp_user_online_transition_node->info->ip_address;
			event_broadcast_packet.user_event_type = USER_ACCESSING_FILTERED_SITES;
			event_broadcast_packet.event_type = USER_EVENT_BDCAST;
			
			event_broadcast_packets_on_all_ports (&event_broadcast_packet);

/*			printf("Not forwarded IP Group No, DA : %d, %d\n", group_no, default_filter_action); */
			*abort_forwarding = TRUE;			
			return FALSE;
		}
		else
		if (check_if_application_is_to_be_restricted (sptr_ip_parameters->protocol, 
				application_port, group_no, &default_filter_action) == FALSE)
		{
			if(temp_user_online_transition_node->info->ptr_user_profile_node->info->sptr_user_group_profile_node->info->defaulter_blacklisted_sites)		
				temp_user_online_transition_node->info->ptr_user_profile_node->info->defaulter_number_of_attempts_of_blacklisted_sites++ ;

			strcpy(event_broadcast_packet.username, temp_user_online_transition_node->info->user_name);
			strcpy(event_broadcast_packet.groupname, temp_user_online_transition_node->info->group_name);
			strcpy(event_broadcast_packet.login_time, temp_user_online_transition_node->info->login_time);
			event_broadcast_packet.ip_address = temp_user_online_transition_node->info->ip_address;
			event_broadcast_packet.user_event_type = USER_ACCESSING_FILTERED_SITES;
			event_broadcast_packet.event_type = USER_EVENT_BDCAST;
			
			event_broadcast_packets_on_all_ports (&event_broadcast_packet);

/*			printf("Not forwarded APP Group No, DA : %d, %d\n", group_no, default_filter_action); */
			*abort_forwarding = TRUE;			
			return FALSE;
		}

		if(!default_filter_action)
		{
			if(check_for_default_filter_action(temp_user_online_transition_node) == FILTER_ACTION)
			{
/*				printf("Not forwarded Default Action Group No : %d\n", group_no); */
				*abort_forwarding = TRUE;			
				return FALSE;
			}
			else
			{
/*				printf("Not Checked in Any of the if condition\n"); */
			}
		}
		return TRUE;
/* ..........Added by Sreelu for Filters */	
	}
	else
	{
		*user_authenticated = FALSE;
		return FALSE;
	}
}
