/**  **/
/*	Author 	: Ravi																		*/
/*	Module	: UserDatabases Management												*/
/*	Synopsis	: User Authentication when a request comes from the client	*/
/*				  of secured LAN															*/
/**  **/

#include <defs.h>

#include	<stdio.h>
#include	<stdarg.h>
#include <stddef.h>
#include	<stdlib.h>

#include "userdata.h"
#include "\rtrware\rwutils\evntstr.h" 
/*Neelu for event broadcast*/

/* Added by Sreelu For Filters... */
DOMAIN_NAME_LIST *current_domain_name = NULL;
DOMAIN_NAME_LIST  *sptr_to_restricted_domain_address = NULL;
/* ...Added by Sreelu For Filters */

extern void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);/* Neelu For Event Broadcast*/
extern void user_authentication_timer (); // to be defined in userutil.c
extern enum TEST user_data_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, 
		ULONG parameter_1);
extern void display_user_online_tree ();
extern void display_user_profile_tree ();
extern void display_group_profile_tree ();
extern void display_app_filter_tree ();
extern void display_ip_filter_tree ();
extern void display_domain_name_filters();
extern void display_sntp_date_time();
extern void display_ip_address_resolved_for_domain_name ();
extern void display_ip_default_tree();
extern void display_app_default_tree();
extern enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature) ;
extern USER_DATABASE_CLASS user_database;

/* Ravi 09 Dec 1999 */
extern USHORT  get_the_internet_gateway_port_number(); 
extern BYTE    is_insecured_lan(USHORT port_number);

				  
enum TEST initialize_user_authentication (ULONG clock_ticks_per_second)
{
	USHORT user_data_application_id;
	USHORT port_number; /* Ravi on 09 Dec 1999 */

/* Added by Neelu */
	EVENT_PACKET *event_packet;
	EVENT_HEADER event_broadcast_packet;
	
#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "User Authentication", USERDATA_AUTHENTICATION_APPLICATION, user_authentication_timer, 
			user_data_control, &user_data_application_id) == FAIL)	
	{
		printf ("User Authentication: register_application () failed to register User Authentication with lsl\n");
		return (FAIL);
	}
#endif

	register_debugger (display_user_online_tree, "USERONLINE");
	register_debugger (display_user_profile_tree, "USERPROFILE");
	register_debugger (display_group_profile_tree, "GROUPPROFILE");
	register_debugger (display_app_filter_tree, "APPFILTER");
	register_debugger (display_ip_filter_tree, "IPFILTER");
	register_debugger (display_domain_name_filters, "DOMFILTER");
	register_debugger (display_sntp_date_time, "DATETIME");
	register_debugger (display_ip_address_resolved_for_domain_name, "IPDOMAIN");
	register_debugger (display_ip_default_tree, "IPDEFAULT");
	register_debugger (display_app_default_tree, "APPDEFAULT");

/* Sreelu for filter... */
	user_database.dns_resolver_state = PROXY_START_DNS_CLIENT;
	user_database.number_of_restricted_domain_address = 0;

/* Ravi on 09 Dec 1999 ... */
	port_number = get_the_internet_gateway_port_number();
	if (is_insecured_lan(port_number))
		user_database.start_resolving_dns_filters = TRUE;
	else
		user_database.start_resolving_dns_filters = FALSE;
/* ... Ravi on 09 Dec 1999 */
/* ...Sreelu for filter */

	printf ("\nUser Authentication Application Initialized Successfully\n");

/* Added by Neelu */
/*New Addition*/
	strcpy(event_broadcast_packet.username,"");
	strcpy(event_broadcast_packet.groupname,"");
	event_broadcast_packet.ip_address = 0;
	event_broadcast_packet.user_event_type = FIREWALL_REBOOTED;
	event_broadcast_packet.event_type = USER_EVENT_BDCAST;
	strcpy(event_broadcast_packet.login_time,"");
  	
	event_broadcast_packets_on_all_ports(&event_broadcast_packet); 

/*New Addition Ends*/

/* Added By Ravi on 16 July 1999 */
	user_database.user_database_enabled = 0;
	user_database.default_action = 1;

	initialize_user_database () ;

	return (PASS);
}

enum TEST user_data_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, 
		ULONG parameter_1)
{
	return PASS;
}

