#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "userdata.h"
#include "\rtrware\rwutils\evntstr.h"

extern void update_user_profile_defaulter_in_the_flash(USER_PROFILE_NODE *user_profile);
extern void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);

USER_PROFILE_NODE far *sptr_user_profile_tree;

static USER_PROFILE_NODE far *get_new_user_rb_node ()
{
	return ((USER_PROFILE_NODE far *) malloc (sizeof (USER_PROFILE_NODE))) ;
}

int user_RB_profile_insert_node(USER_PROFILE_NODE far *Tree, USER_PROFILE_KEY_TYPE  key, USER_PROFILE *info, USER_PROFILE_NODE far **ptr_sptr_new_node)
{
	USER_PROFILE_NODE far *nptr ;

	int retVal ;

/*	retVal = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (USER_PROFILE_KEY_TYPE)) ;*/

	retVal = user_rb_profile_compare_key(Tree, key);	  

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (user_RB_profile_insert_node ((USER_PROFILE_NODE far *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_user_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
	
			nptr->key = key ;
			nptr->info = info ;
		
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER *)nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
			return (user_RB_profile_insert_node ((USER_PROFILE_NODE far *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_user_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;

			nptr->key = key ;
			nptr->info = info ;

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER *) nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}

	return USER_RB_UPDATED ;
}

int user_RB_profile_insert(USER_PROFILE_KEY_TYPE key, USER_PROFILE *info)
{
	USER_PROFILE_NODE far *nptr, far *sptr_new_node ;
	int retVal ;

	if (sptr_user_profile_tree == (USER_PROFILE_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_user_rb_node() ;

		if (nptr == NULL)
			return USER_RB_INSERT_OVERFLOW ;

		nptr->key = key ;
		nptr->info = info ;

		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_user_profile_tree = nptr ;

		return USER_RB_NEW_ENTRY ;
	}

	retVal = user_RB_profile_insert_node (sptr_user_profile_tree, key, info, &sptr_new_node) ;

	if (retVal == USER_RB_NEW_ENTRY)
	{
		sptr_user_profile_tree = (USER_PROFILE_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER *)sptr_new_node, (RED_BLACK_NODE_HEADER *)sptr_user_profile_tree) ;
	}

	return retVal ;
}

void add_entry_to_user_profile_rb_tree (USER_PROFILE *user_info,unsigned char *vptr_buffer)
{
	USER_PROFILE *info;

	if (sptr_user_profile_tree == NULL)
		sptr_user_profile_tree = (USER_PROFILE_NODE far *) sptr_RB_sentinal_node;

	info = user_info;

   user_RB_profile_insert (*((USER_PROFILE_KEY_TYPE *)(vptr_buffer)), info) ;
}

USER_PROFILE_NODE far *user_rb_profile_search(USER_PROFILE_NODE far *Tree, USER_PROFILE_KEY_TYPE key)
{
	int ret_val ;
	
	if (Tree == NULL)
		return NULL ;

	if (Tree == (USER_PROFILE_NODE far  *)sptr_RB_sentinal_node)
		return NULL ;

/*	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (USER_PROFILE_KEY_TYPE)) ; */

	ret_val = user_rb_profile_compare_key(Tree, key);	 

	if (ret_val < 0)
	{
		return user_rb_profile_search ((USER_PROFILE_NODE far *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return user_rb_profile_search((USER_PROFILE_NODE far *)Tree->rb_header.LChild, key) ;
	}
	else
	{
 		return Tree ;
 	}
}

int delete_entry_from_user_profile_rb_tree (USER_PROFILE_KEY_TYPE key)
{
   USER_PROFILE_NODE far *sptr_node_to_delete ;

   sptr_node_to_delete = user_rb_profile_search (sptr_user_profile_tree, key) ;

   if (sptr_node_to_delete)
   {
      RB_delete ((RED_BLACK_NODE_HEADER *)sptr_user_profile_tree, (RED_BLACK_NODE_HEADER *)sptr_node_to_delete, (unsigned long) sizeof (USER_PROFILE_NODE), (RED_BLACK_NODE_HEADER **)&sptr_node_to_delete) ;
		free(sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}


int user_rb_profile_compare_key ( USER_PROFILE_NODE far *Tree, USER_PROFILE_KEY_TYPE key)
{

#if 0
	printf("\nApplication Tree Parameter:.......");
	printf("\nUser Name : %s",Tree->key.user_name);
	printf("\nApplication Key Parameter:........");
	printf("\nUser Name : %s",key.user_name);
#endif

	if (!strcmp(Tree->key.user_name, key.user_name))
		return 0;
	else
		return(strcmp(Tree->key.user_name, key.user_name));			
}


void display_user_profile_tree ()
{
	int index=0 ;
	USER_PROFILE_NODE far  *sptr_root = sptr_user_profile_tree, *sptr_next_node;

	if(sptr_user_profile_tree == NULL)
		return;

	sptr_next_node = (USER_PROFILE_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	if (sptr_next_node == NULL)
	{
		printf("\n The User Profile Tree is empty") ;
		return;
	}

	printf ("\n **");
	printf ("\n          Displaying User Profile Tree             ") ;
	printf ("\n **");


	while (sptr_next_node)
	{
		printf ("\n [%s]\t[%d]", sptr_next_node->info->user_name,
						sptr_next_node->info->user_age_flag) ;

		++index ;
					
		sptr_next_node = (USER_PROFILE_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

	printf ("\n **");
	printf ("\n     Total Number of Entries : %d", index) ;
	printf ("\n **\n\n");
}


void 
age_user_profile_rb_tree ()
{
	USER_PROFILE_NODE far *sptr_next_node, far *sptr_temp;

	if(sptr_user_profile_tree == NULL)
		return;
	
	sptr_next_node = (USER_PROFILE_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *) sptr_user_profile_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;

      if(sptr_temp->info->user_age_flag == DONOT_AGE_FLAG) 
      {
	      sptr_user_profile_tree = (USER_PROFILE_NODE far *) 
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_user_profile_tree,
				          (RED_BLACK_NODE_HEADER *)sptr_temp,
                      (unsigned long) sizeof (USER_PROFILE_NODE),
                      (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
		free(sptr_temp);
      }
#if 0		/* Commented by Sreelu */
		else 
		{
			if (sptr_temp->info->user_age_flag == MARK_AGE_FLAG)
				sptr_temp->info->user_age_flag = DONOT_AGE_FLAG; 
		}
#endif
		sptr_next_node = (USER_PROFILE_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
   }
}

/* Added by Sreelu */
void update_user_profile_tree()
{
	USER_PROFILE_NODE far  *sptr_root = sptr_user_profile_tree, *sptr_next_node;
	
	if(sptr_user_profile_tree == NULL)
		return;

	sptr_next_node = (USER_PROFILE_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		sptr_next_node->info->user_age_flag = DONOT_AGE_FLAG;
		sptr_next_node = (USER_PROFILE_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
}

void check_if_any_users_are_to_be_marked_as_defaulter()
{
	USER_PROFILE_NODE far *sptr_next_node, far *sptr_temp;
	EVENT_HEADER event_broadcast_packet;

	if(sptr_user_profile_tree == NULL)
		return;
	
	sptr_next_node = (USER_PROFILE_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *) sptr_user_profile_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
		if((sptr_temp->info->sptr_user_group_profile_node->info->defaulter_login_attempts != 0) &&
			(sptr_temp->info->defaulter_number_of_login_attempts >= sptr_temp->info->sptr_user_group_profile_node->info->defaulter_number_of_login_attempts))	
		{
			sptr_temp->info->defaulter = LOGIN_ATTEMPTS;
			sptr_temp->info->defaulter_number_of_login_attempts = 0;			

			update_user_profile_defaulter_in_the_flash(sptr_temp);
 
			strcpy(event_broadcast_packet.username, sptr_temp->info->user_name);
			strcpy(event_broadcast_packet.groupname, sptr_temp->info->group_name);
			strcpy(event_broadcast_packet.login_time, " ");
			event_broadcast_packet.ip_address = 0;
			event_broadcast_packet.user_event_type = USER_MARKED_AS_DEFAULTER;
			event_broadcast_packet.event_type = USER_EVENT_BDCAST;
			
			event_broadcast_packets_on_all_ports (&event_broadcast_packet);
		}

		sptr_next_node = (USER_PROFILE_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
   }
}
