/* This c files contains the functions of RED-BLACK tree for Inserting,
	Deleting, Search,etc.. the USER_ONLINE_TRANSITION_NODE
*/

#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "userdata.h"

#include "\rtrware\rwutils\evntstr.h"

#include "\rtrware\applicat\sntp\ksntp.h"
#include "\rtrware\applicat\sntp\vsntpstr.h"
#include "\rtrware\applicat\sntp\vsntp.h"


USER_ONLINE_TRANSITION_NODE *sptr_user_online_tree;
extern char *status_debug_convert_ip_address_to_dot_format (char *cptr_array_to_store_dot_format_address, ULONG ip_address);
extern void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);
extern void update_user_profile_defaulter_in_the_flash(USER_PROFILE_NODE *user_profile);
extern void GetDateTime (SntpDateTime far *dt_ptr);
extern enum BOOLEAN check_for_time_restrictions (USHORT hrs, USER_PROFILE_NODE *sptr_user_profile_node, BYTE dayofweek);

static USER_ONLINE_TRANSITION_NODE *get_new_user_rb_node ()
{
	return ((USER_ONLINE_TRANSITION_NODE *) malloc (sizeof (USER_ONLINE_TRANSITION_NODE))) ;
}

int user_RB_demo_insert_node(USER_ONLINE_TRANSITION_NODE *Tree, USER_ONLINE_TRANSITION_KEY_TYPE  key, USER_ONLINE_TRANSITION_TABLE *info, USER_ONLINE_TRANSITION_NODE **ptr_sptr_new_node)
{
	USER_ONLINE_TRANSITION_NODE *nptr ;

	int retVal ;

	retVal = user_rb_demo_compare_key(Tree, key);	 

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (user_RB_demo_insert_node ((USER_ONLINE_TRANSITION_NODE *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_user_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
	
			nptr->key = key ;
			nptr->info = info ;
		
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER *)nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
			return (user_RB_demo_insert_node ((USER_ONLINE_TRANSITION_NODE *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_user_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;

			nptr->key = key ;
			nptr->info = info ;

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER *) nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}

	return USER_RB_UPDATED ;
}

int user_RB_demo_insert(USER_ONLINE_TRANSITION_KEY_TYPE key, USER_ONLINE_TRANSITION_TABLE *info)
{
	USER_ONLINE_TRANSITION_NODE *nptr, *sptr_new_node ;
	int retVal ;

	if (sptr_user_online_tree == (USER_ONLINE_TRANSITION_NODE *)sptr_RB_sentinal_node)
	{
		nptr = get_new_user_rb_node() ;

		if (nptr == NULL)
			return USER_RB_INSERT_OVERFLOW ;

		nptr->key = key ;
		nptr->info = info ;

		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_user_online_tree = nptr ;

		return USER_RB_NEW_ENTRY ;
	}

	retVal = user_RB_demo_insert_node (sptr_user_online_tree, key, info, &sptr_new_node) ;

	if (retVal == USER_RB_NEW_ENTRY)
	{
		sptr_user_online_tree = (USER_ONLINE_TRANSITION_NODE *) RB_red_balance ((RED_BLACK_NODE_HEADER *)sptr_new_node, (RED_BLACK_NODE_HEADER *)sptr_user_online_tree) ;
	}

	return retVal ;
}

void add_entry_to_user_rb_tree (USER_ONLINE_TRANSITION_TABLE *user_info,unsigned char *vptr_buffer)
{
	USER_ONLINE_TRANSITION_TABLE *info;

	if (sptr_user_online_tree == NULL)
		sptr_user_online_tree = (USER_ONLINE_TRANSITION_NODE *) sptr_RB_sentinal_node;

	info = user_info;

   user_RB_demo_insert (*((USER_ONLINE_TRANSITION_KEY_TYPE *)(vptr_buffer)), info) ;
}


USER_ONLINE_TRANSITION_NODE *user_rb_demo_search(USER_ONLINE_TRANSITION_NODE *Tree, USER_ONLINE_TRANSITION_KEY_TYPE key)
{
	int ret_val ;
	
	if (Tree == NULL)
		return NULL ;

	if (Tree == (USER_ONLINE_TRANSITION_NODE  *)sptr_RB_sentinal_node)
		return NULL ;

	ret_val = user_rb_demo_compare_key(Tree, key);	 

	if (ret_val < 0)
	{
		return user_rb_demo_search ((USER_ONLINE_TRANSITION_NODE *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return user_rb_demo_search((USER_ONLINE_TRANSITION_NODE *)Tree->rb_header.LChild, key) ;
	}
	else
	{
 		return Tree ;
 	}
}

int delete_entry_from_user_rb_tree (USER_ONLINE_TRANSITION_KEY_TYPE key)
{
   USER_ONLINE_TRANSITION_NODE *sptr_node_to_delete ;

   sptr_node_to_delete = user_rb_demo_search (sptr_user_online_tree, key) ;

   if (sptr_node_to_delete)
   {
      sptr_user_online_tree = RB_delete ((RED_BLACK_NODE_HEADER *)sptr_user_online_tree, (RED_BLACK_NODE_HEADER *)sptr_node_to_delete, (unsigned long) sizeof (USER_ONLINE_TRANSITION_NODE), (RED_BLACK_NODE_HEADER **)&sptr_node_to_delete) ;
		free(sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}


int user_rb_demo_compare_key ( USER_ONLINE_TRANSITION_NODE *Tree, USER_ONLINE_TRANSITION_KEY_TYPE key)
{

#if Ravi
	printf("\nApplication Tree Parameter:.......");
	printf("\nIP Address : %8x",Tree->key.ip_address);
	printf("\nApplication Key Parameter:........");
	printf("\nIP Address : %8x",key.ip_address);
#endif

	if(Tree->key.ip_address == key.ip_address)
		return 0;
	else
		return(Tree->key.ip_address - key.ip_address);			
}


void age_user_online_rb_tree ()
{
	USER_ONLINE_TRANSITION_NODE *sptr_temp, *sptr_next_node ;
	EVENT_HEADER event_broadcast_packet;
	SntpDateTime *dt_ptr;
	BYTE dayofweek;
	USHORT hrs;
	USHORT flag_for_event_broadcast=0;

	if(sptr_user_online_tree == NULL)
		return;

	/* For Time Restriction */
	dt_ptr = (SntpDateTime *) malloc(sizeof(SntpDateTime));
	GetDateTime (dt_ptr);
	hrs = dt_ptr->Hour;
	dayofweek=dt_ptr->WeekDay;
	free(dt_ptr);

	
	sptr_next_node = (USER_ONLINE_TRANSITION_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_user_online_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
      sptr_next_node = (USER_ONLINE_TRANSITION_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;

		if((sptr_temp->info->ptr_user_profile_node->info->sptr_user_group_profile_node->info->defaulter_blacklisted_sites != 0) &&
			(sptr_temp->info->ptr_user_profile_node->info->defaulter_number_of_attempts_of_blacklisted_sites >= sptr_temp->info->ptr_user_profile_node->info->sptr_user_group_profile_node->info->defaulter_number_of_attempts_of_blacklisted_sites))	
		{
			sptr_temp->info->ptr_user_profile_node->info->defaulter = BLACKLISTED_SITES;
			sptr_temp->info->ptr_user_profile_node->info->defaulter_number_of_attempts_of_blacklisted_sites = 0;			
			sptr_temp->info->age = 0;
			flag_for_event_broadcast = 1;

			update_user_profile_defaulter_in_the_flash(sptr_temp->info->ptr_user_profile_node);
		}

		if (!check_for_time_restrictions (hrs, sptr_temp->info->ptr_user_profile_node, dayofweek))
		{
			sptr_temp->info->age = 0;
			flag_for_event_broadcast = 2;
		}

      if (sptr_temp->info->age)
      {
         sptr_temp->info->age-- ;
      }
      else
      {
			strcpy(event_broadcast_packet.username, sptr_temp->info->user_name);
			strcpy(event_broadcast_packet.groupname, sptr_temp->info->group_name);
			strcpy(event_broadcast_packet.login_time, sptr_temp->info->login_time);
			event_broadcast_packet.ip_address = sptr_temp->info->ip_address;
			event_broadcast_packet.event_type = USER_EVENT_BDCAST;

			if (flag_for_event_broadcast == 0)
				event_broadcast_packet.user_event_type = LOG_USER_EVENT_LOGOFF;
			else if (flag_for_event_broadcast == 1)
				event_broadcast_packet.user_event_type = USER_MARKED_AS_DEFAULTER;
			else if (flag_for_event_broadcast == 2)
				event_broadcast_packet.user_event_type = TIME_RESTRICTION_ENFORCED;
			
			event_broadcast_packets_on_all_ports (&event_broadcast_packet);

         sptr_user_online_tree = (USER_ONLINE_TRANSITION_NODE *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_user_online_tree,
				          (RED_BLACK_NODE_HEADER *)sptr_temp,
                      (unsigned long) sizeof (USER_ONLINE_TRANSITION_NODE),
                      (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
			free(sptr_temp);
      }
   }
}


void display_user_online_tree ()
{
	int index=0 ;
   BYTE ip_address_string[50];

	USER_ONLINE_TRANSITION_NODE  *sptr_root = sptr_user_online_tree, *sptr_next_node;

	if(sptr_user_online_tree == NULL)
		return;

	sptr_next_node = (USER_ONLINE_TRANSITION_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	if (sptr_next_node == NULL)
	{
		printf("\n The User Online Transition Table is empty") ;
		return;
	}

	printf ("\n **");
	printf ("\n       Displaying User Online Transition Table     ") ;
	printf ("\n **");

	while (sptr_next_node)
	{
		printf ("\n [%s]\t[%s]\t[%4x] mins", status_debug_convert_ip_address_to_dot_format(ip_address_string, sptr_next_node->info->ip_address),
						sptr_next_node->info->user_name, ((USHORT *)(sptr_next_node->info->age / 60))) ;

		++index ;
					
		sptr_next_node = (USER_ONLINE_TRANSITION_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

	printf ("\n **");
	printf ("\n   Number if Entries in Online Transition Table : %d    ", index);
	printf ("\n **\n\n");
}

void 
age_user_online_transition_tree ()
{
	USER_ONLINE_TRANSITION_NODE *sptr_temp, *sptr_next_node ;

	if(sptr_user_online_tree == NULL)
		return;
	
	sptr_next_node = (USER_ONLINE_TRANSITION_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_user_online_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;

      if (sptr_temp->info->ptr_user_profile_node->info->user_age_flag != MARK_AGE_FLAG)
      {
         sptr_user_online_tree = (USER_ONLINE_TRANSITION_NODE *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_user_online_tree,
            			 (RED_BLACK_NODE_HEADER *)sptr_temp,
                      (unsigned long) sizeof (USER_ONLINE_TRANSITION_NODE),
                      (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
		free(sptr_temp);
      }
      sptr_next_node = (USER_ONLINE_TRANSITION_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
   }
}
