#include <defs.h>

#include	<stdio.h>
#include	<stdarg.h>
#include <stddef.h>
#include	<stdlib.h>
#include <string.h>
#include <kstart.h>
#include <memory.h>

#include <redblack.h>
#include <kstart.h>

#include "userdata.h"
#include "vnvuser.h"

#include "\rtrware\store\boot.h"

/* Function Proto Types */
extern void add_entry_ipadd_filter_rb_tree (IP_ADD_FILTER_INFO *user_info,unsigned char *vptr_buffer);
extern void add_entry_to_app_filter_rb_tree (ULONG ,unsigned char * );
extern ULONG dot2ulong(BYTE *);
extern ULONG str_to_net (char *) ;
extern int get_ulong_ip_address(char *dot_decimal_ip_address, ULONG *int_ip_address);
extern void add_entry_to_user_rb_tree (USER_ONLINE_TRANSITION_TABLE *user_info, unsigned char *vptr_buffer);
extern void add_entry_to_user_profile_rb_tree (USER_PROFILE *user_info,unsigned char *vptr_buffer);
extern void add_entry_to_group_profile_rb_tree (GROUP_PROFILE *,unsigned char *);
void set_the_time_restriction_bit (USHORT time, USER_PROFILE *sptr_user_profile);
extern ULONG router_up_time;
ULONG user_online_transition_timeout;
extern DOMAIN_NAME_LIST  *sptr_to_restricted_domain_address, *current_domain_name;
extern IP_ADD_FILTER_NODE far *sptr_ipadd_filter_tree;
extern APP_FILTER_NODE far *spr_app_filter_tree;
extern APP_FILTER_NODE far *app_filter_rb_search(APP_FILTER_NODE far *, APP_FILTER_KEY );
extern IP_ADD_FILTER_NODE far *ipadd_filter_rb_search(IP_ADD_FILTER_NODE far *, IP_ADD_FILTER_KEY );
extern void add_entry_to_domain_name_list(DOMAIN_NAME_LIST *);
extern void display_domain_name_filters();
extern void update_group_profile_tree();
extern void update_user_profile_tree();
extern void update_application_filter_tree();
extern IP_ADD_DEFAULT_NODE far *sptr_ipdefault_filter_tree;
extern APP_DEFAULT_NODE far *spr_appdefault_filter_tree;
extern void add_entry_ipadd_default_rb_tree (IP_ADD_DEFAULT_INFO *info,unsigned char *vptr_buffer);
extern void add_entry_app_default_rb_tree (APP_DEFAULT_INFO *,unsigned char *);
extern IP_ADD_DEFAULT_NODE far *ipadd_default_rb_search(ULONG);
extern APP_DEFAULT_NODE far *app_default_rb_search(USHORT , USHORT );

/* Added By Ravi */
BYTE *current_ptr_remote_user_database ;
USER_DATABASE *user_data_base_ptr;
extern USER_PROFILE_NODE far *sptr_user_profile_tree;
extern USER_PROFILE_NODE far *user_rb_profile_search(USER_PROFILE_NODE far *Tree, USER_PROFILE_KEY_TYPE key);
extern GROUP_PROFILE_NODE far *sptr_group_profile_tree;
extern GROUP_PROFILE_NODE far *group_rb_profile_search(GROUP_PROFILE_NODE far *Tree, GROUP_PROFILE_KEY_TYPE key);
void update_user_profile_defaulter_in_the_flash(USER_PROFILE_NODE *user_profile);
extern UDB_HEADER *ptr_user_database_hdr;
void user_details_update_in_flash(BYTE *current_ptr_user_database_hdr, USHORT number_of_items, USER_PROFILE_NODE *user_profile);
void display_details_in_flash (BYTE *current_ptr_user_database_hdr, USHORT number_of_items, USER_PROFILE_NODE *user_profile);
extern void c_write_to_flash (char *source, char *destination, int size) ;


BYTE Enabled[] = "enabled";

/* Added by Sreelu... */

enum TEST user_online_transition_table_string (char *cptr_proxy_server_app_string)
{
	/* To Do : Read the string from Ini and then add it in 
				  USER_ONLINE_TRANSITION_TABLE */

	BYTE *cptr_proxy = cptr_proxy_server_app_string, *ptr_proxy; 
	BYTE string[15];
	USER_ONLINE_TRANSITION_KEY_TYPE user_ip_mac_address_list;
	USER_ONLINE_TRANSITION_TABLE *user_transition_table;

	while (1)
   {
		if (cptr_proxy == NULL)
			break;

		user_transition_table = (USER_ONLINE_TRANSITION_TABLE *) malloc(sizeof(USER_ONLINE_TRANSITION_TABLE));
		if(user_transition_table == NULL)
		{
			printf("USER: Error allocating Memory\n");
			return FAIL;
		}

		ptr_proxy = strchr(cptr_proxy, ',');
		if(cptr_proxy == NULL)
			printf("\n Configuration Error\n");
		*ptr_proxy = 0;
		user_transition_table->ip_address = str_to_net (cptr_proxy);
		ptr_proxy++;
		cptr_proxy = ptr_proxy;

		ptr_proxy = strchr(cptr_proxy, ',');			
		*ptr_proxy = '\0';
		strcpy(user_transition_table->mac_address, cptr_proxy);
		ptr_proxy++;
		cptr_proxy = ptr_proxy;

		ptr_proxy = strchr(cptr_proxy, ',');			
		*ptr_proxy = '\0';
		strcpy(user_transition_table->user_name, cptr_proxy);
		ptr_proxy++;
		cptr_proxy = ptr_proxy;

		strcpy(user_transition_table->group_name, cptr_proxy);

		user_ip_mac_address_list.ip_address = user_transition_table->ip_address;

/* Initialize Online Transition Table */
#if 0
		printf("MAC :%s",user_transition_table->mac_address);
		printf("User Name :%s",user_transition_table->user_name);
		printf("Group Name :%s",user_transition_table->group_name);
#endif

		user_transition_table->account_status = 1;	
		user_transition_table->defaulter = NONE; 

		add_entry_to_user_rb_tree (user_transition_table, &user_ip_mac_address_list);

		if (strchr(cptr_proxy, ',') == NULL)
			break;

   }
	return PASS;
}

enum TEST user_profile_table_string (char *cptr_proxy_server_app_string)
{
	/* To Do : Read the string from Ini and then add it in 
				  USER_PROFILE */

	BYTE *cptr_user = cptr_proxy_server_app_string, *ptr_user; 
	USER_PROFILE_KEY_TYPE user_profile_key;
	USER_PROFILE *user_profile;
	int defaulter, account_status, from_time, to_time, time_index;

	while (1)
   {
		if (cptr_user == NULL)
			break;

		user_profile = (USER_PROFILE *) malloc(sizeof(USER_PROFILE));
		if(user_profile == NULL)
		{
			printf("USER: Error Allocating Memory\n");
			return (FAIL);
		}
		ptr_user = strchr(cptr_user, ',');
		*ptr_user = '\0';
		strcpy(user_profile->user_name,cptr_user);
		ptr_user++;
		cptr_user = ptr_user;

		ptr_user = strchr(cptr_user, ',');
		*ptr_user = '\0';
		strcpy(user_profile->user_password,cptr_user);
		ptr_user++;
		cptr_user = ptr_user;

		ptr_user = strchr(cptr_user, ',');
		*ptr_user = '\0';
		strcpy(user_profile->group_name,cptr_user);
		ptr_user++;
		cptr_user = ptr_user;

    	sscanf (cptr_user, "%d,%d,%d,%d", &defaulter, &account_status, 
													 &from_time, &to_time);
		user_profile->defaulter = (USHORT) defaulter;

		if (account_status == 1)
			user_profile->account_status = TRUE;
		else
			user_profile->account_status = FALSE;
		
#if 0
		printf("User Password is :%s",user_profile->user_password);
		printf("User Key Name is :%s",user_profile_key.user_name);
		printf("User Group is :%s",user_profile->group_name);
#endif

		user_profile->time_restriction =  calloc (24,1);

		for (time_index = from_time; time_index <= to_time ; time_index++)
		{
			set_the_time_restriction_bit (time_index, user_profile);
		}

		strcpy(user_profile_key.user_name,user_profile->user_name);
		add_entry_to_user_profile_rb_tree (user_profile, &user_profile_key);

		break;

   }
	return PASS;
}

enum TEST group_profile_table_string(char *cptr_proxy_server_app_string)
{
	BYTE *cptr_group = cptr_proxy_server_app_string, *ptr_group;
	GROUP_PROFILE_KEY_TYPE group_key;
	GROUP_PROFILE *ptr_group_profile;

	while(1) 
	{
		if(cptr_group == NULL)
			break;
		ptr_group_profile = (GROUP_PROFILE *) malloc (sizeof(GROUP_PROFILE));
		if(ptr_group_profile == NULL)
		{
			printf("GROUP: Error Allocating Memory\n");
			return (FAIL);
		}
		ptr_group = strchr(cptr_group, ',');
		*ptr_group = '\0';
		strcpy(ptr_group_profile->group_name, ptr_group);
		ptr_group++;
		cptr_group = ptr_group;

		sscanf(cptr_group, "%d", &ptr_group_profile->group_no);
		if(strchr(cptr_group, ',') == NULL)
			break;
		break;
	}
	return PASS;
}

enum TEST proxy_application_filter (char *cptr_proxy_server_app_string)
{
	
	APP_FILTER_KEY *ptr_app_filter_key;
	int port, protocol;
	ULONG mask;		
	
	while (1)
	{
		if(cptr_proxy_server_app_string == NULL)
			break;

		sscanf(cptr_proxy_server_app_string, "%04x,%04x,%04x",
		&port,&protocol,&mask);
		
		ptr_app_filter_key = (APP_FILTER_KEY *) malloc(sizeof(APP_FILTER_KEY));

		ptr_app_filter_key->port = port;
		ptr_app_filter_key->protocol = protocol;

#if 0
		printf("Port Number :%d\n",ptr_app_filter_key->port);
		printf("Protocol :%d\n",ptr_app_filter_key->protocol);
		printf("Mask :%d\n",mask);
#endif

		add_entry_to_app_filter_rb_tree (mask,ptr_app_filter_key);

		if(strchr(cptr_proxy_server_app_string, ',') == NULL)
			break;

		break;
	}
	return PASS;
}

enum TEST proxy_ip_address_filter (char *cptr_proxy_server_app_string)
{
	BYTE ip_address[20];
	ULONG mask;
	IP_ADD_FILTER_KEY *ptr_ip_filter_key;
	IP_ADD_FILTER_INFO *ptr_ip_filter_info;

	while (1)
	{
		if(cptr_proxy_server_app_string == NULL)
			break;
	
		sscanf(cptr_proxy_server_app_string, "%15s,%04x",
		&ip_address[0], &mask);
		ptr_ip_filter_key = (IP_ADD_FILTER_KEY *)	 malloc(sizeof(IP_ADD_FILTER_KEY));
		ptr_ip_filter_info = (IP_ADD_FILTER_INFO *)	 malloc(sizeof(IP_ADD_FILTER_INFO));

		ptr_ip_filter_key->ip_address = dot2ulong(&ip_address[0]);
		ptr_ip_filter_info->group_mask = mask;

/*		convert_ip_address_to_dot_format(&string[0], ptr_ip_filter_key->ip_address); */

#if 0
		printf("IP Address: %s \n", ip_address);
		printf("Mask: %x \n", mask);
#endif
	
		add_entry_ipadd_filter_rb_tree(ptr_ip_filter_info,ptr_ip_filter_key);

		if(strchr(cptr_proxy_server_app_string, ',') == NULL)
			break;

		break;
  	}
	return PASS;
}
/* ...Added by Sreelu */

/* Added by Sreelu for New Filters.... */

#if 0
enum TEST proxy_restricted_domain_name_string (char *cptr_restricted_domain_name_string)
{
	DOMAIN_NAME_LIST *sptr_next_restricted_domain_address;
	BYTE *cptr_domain = cptr_restricted_domain_name_string, *ptr_domain;
	
	if (user_database.number_of_restricted_domain_address == 0)
	{
		if ((sptr_to_restricted_domain_address = (DOMAIN_NAME_LIST *) table_malloc (user_database.max_number_of_restricted_domain_address, sizeof (DOMAIN_NAME_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}
		
	sptr_next_restricted_domain_address = sptr_to_restricted_domain_address +
												user_database.number_of_restricted_domain_address;

	ptr_domain = strchr(cptr_domain, ',');	
	ptr_domain = '\0';
	strcpy (sptr_next_restricted_domain_address->domain_name, cptr_restricted_domain_name_string);
	ptr_domain++;
	
	sscanf(ptr_domain, "%04x", &sptr_next_restricted_domain_address->group_mask);

	sptr_next_restricted_domain_address->is_resolved = FALSE;

#if 0
	printf("Domain Name :%s\n", sptr_next_restricted_domain_address->domain_name);
	printf("Domain Mask :%x\n", sptr_next_restricted_domain_address->group_mask);
#endif
	
	user_database.number_of_restricted_domain_address++;

	return PASS;
	
}
#endif
/* For Default IP Address & Application Filter.... */

enum TEST proxy_default_address_string (char *cptr_proxy_server_app_string)
{
	BYTE *cptr_ip = cptr_proxy_server_app_string, *ptr_ip; 
	BYTE ip_address1[20], ip_address2[20];
/*	ULONG mask; */
	IP_ADD_DEFAULT_KEY *ptr_ip_filter_key;
	IP_ADD_DEFAULT_INFO *ptr_ip_filter_info;

	while (1)
	{
		if(cptr_ip == NULL) 
			break;

		ptr_ip_filter_key = (IP_ADD_DEFAULT_KEY *)	 malloc(sizeof(IP_ADD_DEFAULT_KEY));
		ptr_ip_filter_info = (IP_ADD_DEFAULT_INFO *)	 malloc(sizeof(IP_ADD_DEFAULT_INFO));

		ptr_ip = strchr(cptr_ip, ',');
		*ptr_ip = '\0';

		ptr_ip_filter_key->lower_ip_range = dot2ulong(cptr_ip);
		ptr_ip++;
		cptr_ip = ptr_ip;
		ptr_ip_filter_key->upper_ip_range = dot2ulong(cptr_ip);

		add_entry_ipadd_default_rb_tree(ptr_ip_filter_info,ptr_ip_filter_key);

		if(strchr(cptr_ip, ',') == NULL)
			break;

		break;
  	}
	return PASS;
}

enum TEST proxy_default_application_string (char *cptr_proxy_server_app_string)
{
	APP_DEFAULT_KEY *ptr_app_filter_key;
	APP_DEFAULT_INFO *info;
	int lport, uport, protocol;
/*	ULONG mask;	*/	
	
	while (1)
	{
		if(cptr_proxy_server_app_string == NULL)
			break;

		sscanf(cptr_proxy_server_app_string, "%04x,%04x,%04x",
		&lport,&uport,&protocol);
		
		ptr_app_filter_key = (APP_DEFAULT_KEY *) malloc(sizeof(APP_DEFAULT_KEY));
		info = (APP_DEFAULT_INFO *) malloc(sizeof(APP_DEFAULT_INFO));

		ptr_app_filter_key->lower_port = lport;
		ptr_app_filter_key->upper_port = uport;
		if(protocol != TCP_UDP_PROTOCOL)
			ptr_app_filter_key->protocol = protocol;

/*		info->group_mask = mask; */
#if 0
		printf("Port Number L:U :: %d:%d - Protocol : %d\n",ptr_app_filter_key->lower_port, 
				ptr_app_filter_key->upper_port, ptr_app_filter_key->protocol);
#endif

		if(protocol != TCP_UDP_PROTOCOL)
			add_entry_app_default_rb_tree (info,ptr_app_filter_key);
		else
		{
			ptr_app_filter_key->protocol = TCP_PROTOCOL;
			add_entry_app_default_rb_tree (info,ptr_app_filter_key);
			ptr_app_filter_key->protocol = UDP_PROTOCOL;
			add_entry_app_default_rb_tree (info,ptr_app_filter_key);
		}

		if(strchr(cptr_proxy_server_app_string, ',') == NULL)
			break;

		break;
	}
	return PASS;
}
/* ....Added by Sreelu for New Filters */


void set_the_time_restriction_bit (USHORT time, USER_PROFILE *sptr_user_profile)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status;
	BYTE exp_bit_mask[] = {1,2,4,8,16,32,64,128};

	offset = time / 8;
	bit_position = time % 8;

	if (sptr_user_profile->time_restriction != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG ) sptr_user_profile->time_restriction +  (ULONG) offset);
		*ptr_to_bit_status |= exp_bit_mask[bit_position];
	}
	return;		
}


enum TEST proxy_server_time (char *cptr_proxy_server_app_string)
{
	int hrs;		

 	sscanf (cptr_proxy_server_app_string, "%d", &hrs);

	router_up_time = (ULONG *)	(hrs * 360000);
}

enum TEST proxy_server_timeout (char *cptr_proxy_server_app_string)
{
	int timeout;		

 	sscanf (cptr_proxy_server_app_string, "%d", &timeout);

	user_online_transition_timeout = (ULONG *)(timeout * 60);
}

/* Added by Sreelu for Filters...... */
enum TEST proxy_user_group_name (char *cptr_proxy_server_app_string)
{
	BYTE *cptr_group = cptr_proxy_server_app_string, *ptr_group; 
	USHORT count = 1;
	GROUP_PROFILE *ptr_to_group_profile;
	GROUP_PROFILE_KEY_TYPE  key;
	
	while(1)
	{
		if(cptr_group == NULL) 
			break;
		ptr_to_group_profile = (GROUP_PROFILE *) malloc(sizeof(GROUP_PROFILE));
		if(ptr_to_group_profile == NULL)
		{
			printf("GROUP: Error Allocating Memory\n");
			return (FAIL);
		}
		ptr_group = strchr(cptr_group, ',');
		*ptr_group = '\0';
		strcpy(key.group_name,cptr_group);
		strcpy(ptr_to_group_profile->group_name,cptr_group);
		ptr_to_group_profile->group_no = count;
		count++;
		ptr_group++;
		cptr_group = ptr_group;
											 
		add_entry_to_group_profile_rb_tree(ptr_to_group_profile, &key); 

		if(strchr(cptr_group, ',') == NULL)
			break;

	}			
	return PASS;
}

void set_group_filter_enabled(USHORT group_no, ULONG *ptr_to_group_mask)
{
	ULONG group_mask_enable = 0x00000001;
	ULONG group_mask;

	group_mask = group_mask_enable << (group_no - 1);
	*ptr_to_group_mask |= group_mask;
}

void set_group_filter_disabled(USHORT group_no, ULONG *ptr_to_group_mask)
{
	ULONG group_mask_enable = 0x00000001;
	ULONG group_mask;

	group_mask = group_mask_enable << (group_no -1);
	*ptr_to_group_mask  ^= group_mask;	
}

enum BOOLEAN is_filter_enabled(USHORT group_no, ULONG *ptr_to_group_mask)
{
	ULONG group_mask, group_result;
	ULONG group_mask_enable = 0x00000001;

	group_mask = group_mask_enable << (group_no - 1);
	group_result = *ptr_to_group_mask & group_mask;
	if(group_result)
		return TRUE;

	return FALSE;
}

void change_filter_masks(int GroupNo)
{
	int i;
	FILTER_DATA *ptr_to_filter;
	ULONG mask = 0xffffffff;
	ULONG group_mask_enable = 0x00000001;
	ULONG group_mask1, group_mask2 = 0x00000000L, group_mask;

	group_mask1 = mask << GroupNo;
	for (i = 0; i < GroupNo-1; i++)
	{
		group_mask = group_mask_enable << i;
		group_mask2 |= group_mask;
	}		

	ptr_to_filter = user_database.sptr_temp_filter_data;
	while(ptr_to_filter != NULL)
	{
		ULONG Result1, Result2;

		Result1 = group_mask1;		
		Result2 = group_mask2;		

		Result1 &= ptr_to_filter->header->mask;
		Result1 = Result1 >> 1;
		Result2 &= ptr_to_filter->header->mask;
		ptr_to_filter->header->mask = Result1 | Result2;
		ptr_to_filter = ptr_to_filter->next_node;
	}
}

void update_domain_name_masks_to_ip_list()
{
/* When we try to update Group masks or Action of Domain Names, the same is not reflected back in IP Address
	List as we don't resolve those domain names again. This function will reflect both the group mask
	and action to the corresponding IP Address List */

	IP_ADD_FILTER_NODE *sptr_next_node;

	if(sptr_ipadd_filter_tree == NULL)
		return;

	sptr_next_node = (IP_ADD_FILTER_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *) sptr_ipadd_filter_tree) ;

	while(sptr_next_node != NULL)
	{
		if(sptr_next_node->info->ptr_to_domain_name_list != NULL)
		{
		  sptr_next_node->info->group_mask = sptr_next_node->info->ptr_to_domain_name_list->group_mask;
		  sptr_next_node->info->action = sptr_next_node->info->ptr_to_domain_name_list->action;
		}
		sptr_next_node = (IP_ADD_FILTER_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
}
/* ......Added by Sreelu for Filters */

void ip_default_profile()
{
	TEMP_IP_DEFAULT *temp_ip, temp_key;
	IP_ADD_DEFAULT_INFO *info;
	IP_ADD_DEFAULT_KEY *key;
	IP_ADD_DEFAULT_NODE *ptr_to_ip_node;

	int index;

	user_database.user_database_enabled = *(USHORT *)current_ptr_remote_user_database;
	current_ptr_remote_user_database += sizeof(USHORT);	 
	user_database.default_action = *(USHORT *)current_ptr_remote_user_database;
	current_ptr_remote_user_database += sizeof(USHORT);	 

/*	printf("Enabled : %d, Filter Action : %d\n", user_database.user_database_enabled, user_database.default_action); */
	for (index = 0; index < user_data_base_ptr->number_of_items; index++)
	{
		temp_ip = (TEMP_IP_DEFAULT *) current_ptr_remote_user_database;
		memcpy(&temp_key, temp_ip, sizeof(TEMP_IP_DEFAULT));

		key = (IP_ADD_DEFAULT_KEY *) calloc (sizeof(IP_ADD_DEFAULT_KEY), 1);
		if (key == NULL)
		{
			printf("IP_DEFAULT: Error Allocating Memory\n");
			return;
		}
	
		info = (IP_ADD_DEFAULT_INFO *) calloc (sizeof(IP_ADD_DEFAULT_INFO), 1);
		if (info == NULL)
		{
			printf("IP_DEFAULT: Error Allocating Memory\n");
			return;
		}
		info->ip_default_age = MARK_AGE_FLAG;
		key->lower_ip_range = dot2ulong(&temp_key.lower_address[0]);
		key->upper_ip_range = dot2ulong(&temp_key.upper_address[0]);

		ptr_to_ip_node = ipadd_default_rb_search (key->lower_ip_range);
		if(ptr_to_ip_node == NULL)
			add_entry_ipadd_default_rb_tree (info, (unsigned char *) key);
		else
		{
			memcpy(&ptr_to_ip_node->key, key, sizeof(IP_ADD_DEFAULT_KEY));
			memcpy(ptr_to_ip_node->info, info, sizeof(IP_ADD_DEFAULT_INFO));
			free (info);
			free (key);
		}
		
		current_ptr_remote_user_database += sizeof(TEMP_IP_DEFAULT);
	}	
}


void app_default_profile()
{
	TEMP_APP_DEFAULT *temp_app, temp_key;
	APP_DEFAULT_INFO *info;
	APP_DEFAULT_KEY *key;
	APP_DEFAULT_NODE *ptr_to_app_node;

	int index;

	for (index = 0; index < user_data_base_ptr->number_of_items; index++)
	{
		temp_app = (TEMP_APP_DEFAULT *) current_ptr_remote_user_database;

		key = (APP_DEFAULT_KEY *) calloc (sizeof(APP_DEFAULT_KEY), 1);
		if (key == NULL)
		{
			printf("APP_DEFAULT: Error Allocating Memory\n");
			return;
		}
		memcpy(key, temp_app, sizeof(TEMP_APP_DEFAULT));
	
		info = (APP_DEFAULT_INFO *) calloc (sizeof(APP_DEFAULT_INFO), 1);
		if (info == NULL)
		{
			printf("APP_DEFAULT: Error Allocating Memory\n");
			return;
		}
		info->app_default_age = MARK_AGE_FLAG;

		ptr_to_app_node = app_default_rb_search(key->lower_port, key->protocol);
		if(ptr_to_app_node == NULL)
			add_entry_app_default_rb_tree (info, (unsigned char *) key);
		else
		{
			memcpy(&ptr_to_app_node->key, key, sizeof(APP_DEFAULT_KEY));
			memcpy(ptr_to_app_node->info, info, sizeof(APP_DEFAULT_INFO));
			free (info);
			free (key);
		}
		
		current_ptr_remote_user_database += sizeof(TEMP_APP_DEFAULT);
	}	
}

void GroupProfile()
{
	TEMP_GROUP_PROFILE *temp_group_profile;
	GROUP_PROFILE *group_profile;
	GROUP_PROFILE_KEY_TYPE group_profile_key;
	GROUP_PROFILE_NODE far *group_profile_node;

	int index;

	for (index = 0; index < user_data_base_ptr->number_of_items; index++)
	{
		temp_group_profile = (TEMP_GROUP_PROFILE *) current_ptr_remote_user_database;

		group_profile = (GROUP_PROFILE *) calloc(sizeof(GROUP_PROFILE),1);
		if (group_profile == NULL)
		{
			printf("GROUP: Error Allocating Memory\n");
			current_ptr_remote_user_database += sizeof(TEMP_GROUP_PROFILE);
			return;
		}

		memcpy(group_profile, temp_group_profile, sizeof(TEMP_GROUP_PROFILE));
		group_profile->group_age_flag = MARK_AGE_FLAG;
/*
		group_profile->allow_sites can have values 
		2 : Default, Hence need to forward the packets
		1 : ALLOW  , Hence the default action should be Filter.
		0 : BLOCK  , The default action should be Forward.
	 	 For convinience of programming, we have never changed the allow_sites
		in the procon side, instead we do the change in the bin side.	
*/
/* Added by Sreelu - Check */
		if((group_profile->allow_sites == 0) || (group_profile->allow_sites == 2))		
			group_profile->allow_sites	= FORWARD_ACTION;
		else
			group_profile->allow_sites = FILTER_ACTION;

		strcpy(group_profile_key.group_name, group_profile->group_name);
		group_profile_node = group_rb_profile_search(sptr_group_profile_tree, group_profile_key);
		if (group_profile_node == NULL)
		{
			add_entry_to_group_profile_rb_tree(group_profile, &group_profile_key); 
		}
		else
		{
			memcpy(group_profile_node->info, group_profile, sizeof(GROUP_PROFILE));
			free(group_profile);
		}

		current_ptr_remote_user_database += sizeof(TEMP_GROUP_PROFILE);
	}	
}

void UserProfile ()
{
	TEMP_USER_PROFILE *temp_user_profile;
	USER_PROFILE *user_profile;
	USER_PROFILE_KEY_TYPE user_profile_key;
	USER_PROFILE_NODE far *user_profile_node;
	GROUP_PROFILE_NODE far *group_profile_node;
	GROUP_PROFILE *group_profile;
	GROUP_PROFILE_KEY_TYPE group_profile_key;
	int index;

	for (index = 0; index < user_data_base_ptr->number_of_items; index++)
	{
		temp_user_profile = (TEMP_USER_PROFILE *) current_ptr_remote_user_database;

#if 0
		printf("Ravi : User Name : %s\n", temp_user_profile->user_name);
		printf("Ravi : Password  : %s\n", temp_user_profile->user_password);
		printf("Ravi : Group Name: %s\n", temp_user_profile->group_name);
		printf("Ravi : Defaulter : %x\n", temp_user_profile->defaulter);
		printf("Ravi : Account   : %x\n", temp_user_profile->account_status);
#endif

		user_profile = (USER_PROFILE *) calloc(sizeof(USER_PROFILE),1);
		if (user_profile == NULL)
		{
			printf("User : Error Allocating Memory \n"); 
			current_ptr_remote_user_database += sizeof(TEMP_USER_PROFILE);
			return;
		}

		memcpy(user_profile, temp_user_profile, sizeof(TEMP_USER_PROFILE));

		strcpy(group_profile_key.group_name, user_profile->group_name);
		group_profile_node = group_rb_profile_search(sptr_group_profile_tree, group_profile_key);
		if (group_profile_node == NULL)
		{
			/* This condition should not occur for any reason */
			current_ptr_remote_user_database += sizeof(TEMP_USER_PROFILE);
			return;
		}
		else
		{
			user_profile->sptr_user_group_profile_node = (GROUP_PROFILE_NODE far *) group_profile_node;
		}

		user_profile->user_age_flag = MARK_AGE_FLAG;

		strcpy(user_profile_key.user_name, user_profile->user_name);
		user_profile_node = user_rb_profile_search(sptr_user_profile_tree, user_profile_key); 
		if(user_profile_node == NULL)
		{
			/* Addition of a new Node */
			add_entry_to_user_profile_rb_tree (user_profile, &user_profile_key);
		}
		else
		{
			/* Update the existing Node */
			memcpy(user_profile_node->info, user_profile, sizeof(USER_PROFILE));
			free(user_profile);
		}

		current_ptr_remote_user_database += sizeof(TEMP_USER_PROFILE);
	}
}

void FilterProfile()
{
	TEMP_FILTER_HEADER *ptr_filter_header;
	BYTE *temp_filter_profile;
	USHORT port, protocol;
	char address[260];
/* For Application Filter */
	APP_FILTER_KEY *app_key;
	APP_FILTER_INFO *app_info;
	APP_FILTER_NODE far *ptr_app_filter_node;
	
/* For IP Address Filter */	
	IP_ADD_FILTER_KEY *add_key;
	IP_ADD_FILTER_INFO *add_info;
	IP_ADD_FILTER_NODE far *ptr_add_filter_node;

/* For Domain Name Filter */
	DOMAIN_NAME_LIST *sptr_next_restricted_domain_address;

/* Filter Profile Storage Format:
			USER_DATABASE;
			Number Of Domain Names;
			TEMP_FILTER_HEADER;
			Filters(App or IP or Domain Name).
*/

	USHORT index, num_of_domain_name;
/*	printf("Num of Domain Names : %d\n", user_database.max_number_of_restricted_domain_address); */

	temp_filter_profile = (TEMP_FILTER_HEADER *) current_ptr_remote_user_database;
	user_database.number_of_restricted_domain_address = 0;

	for (index = 0; index < user_data_base_ptr->number_of_items; index++)
	{
		ptr_filter_header = (TEMP_FILTER_HEADER *) calloc (sizeof(TEMP_FILTER_HEADER), 1);
		memcpy(ptr_filter_header, temp_filter_profile, sizeof(TEMP_FILTER_HEADER));
		temp_filter_profile += sizeof(TEMP_FILTER_HEADER); 
#if 0
		printf("Type:Mask:Action:Length :: %d:%d:%d:%d\n",ptr_filter_header->type, ptr_filter_header->mask,
		ptr_filter_header->action,ptr_filter_header->length);
#endif		
		switch(ptr_filter_header->type)
		{
			case APPLICATION_FILTER :
				app_info = (APP_FILTER_INFO *) calloc(sizeof(APP_FILTER_INFO), 1);
				app_key = (APP_FILTER_KEY *) calloc(sizeof(APP_FILTER_KEY), 1);
				memcpy(app_key, temp_filter_profile, sizeof(APP_FILTER_KEY));
				temp_filter_profile += sizeof(APP_FILTER_KEY);
				app_info->group_mask = ptr_filter_header->mask;
				app_info->action = ptr_filter_header->action;
				app_info->age_app = MARK_AGE_FLAG;
#if 0
		printf("Port:Protocol:Mask:Action :: %d:%d:%d:%d\n", app_key->port,
				app_key->protocol, app_info->group_mask, app_info->action);
#endif				
				ptr_app_filter_node = app_filter_rb_search(spr_app_filter_tree, *app_key);
				if(ptr_app_filter_node == NULL)
				{
					add_entry_to_app_filter_rb_tree (app_info, app_key);
				}
				else
				{
					memcpy(&ptr_app_filter_node->key, app_key, sizeof(APP_FILTER_KEY));
					memcpy(ptr_app_filter_node->info, app_info, sizeof(APP_FILTER_INFO));
					free(app_info);
				}
/* To Do Add Filter Profile to Application Tree */
				free(app_key);
				break;
			case IP_ADDRESS_FILTER :
				add_info = (IP_ADD_FILTER_INFO *) calloc(sizeof(IP_ADD_FILTER_INFO), 1);
				add_key = (IP_ADD_FILTER_KEY *) calloc(sizeof(IP_ADD_FILTER_KEY), 1);
				memcpy(&address[0], temp_filter_profile, ptr_filter_header->length+1);
				temp_filter_profile += ptr_filter_header->length+1;
				add_key->ip_address = dot2ulong((BYTE *) &address[0]);
				add_info->group_mask = ptr_filter_header->mask;
				add_info->action = ptr_filter_header->action;
				add_info->ptr_to_domain_name_list = NULL;
				add_info->age_ip = MARK_AGE_FLAG;
#if 0
		printf("Address:Mask:Action :: %s:%d:%d\n", address,
				 add_info->group_mask, add_info->action);
#endif				
				ptr_add_filter_node = ipadd_filter_rb_search(sptr_ipadd_filter_tree, *add_key);
				if(ptr_add_filter_node == NULL)
				{
					add_entry_ipadd_filter_rb_tree (add_info, add_key);
				}
				else
				{
/*					memcpy(&ptr_add_filter_node->key, add_key, sizeof(IP_ADD_FILTER_KEY)); */
					memcpy(ptr_add_filter_node->info, add_info, sizeof(IP_ADD_FILTER_INFO));
					ptr_add_filter_node->info->age_ip = MARK_AGE_FLAG;  /* sri-temp */
					free(add_info);
				}
/* To Do Add Filter Profile to IP Address Tree */
				free(add_key);
				break;
			case DOMAIN_NAME_FILTER :
				sptr_next_restricted_domain_address = (DOMAIN_NAME_LIST *) calloc( 1, sizeof(DOMAIN_NAME_LIST));
				if(sptr_next_restricted_domain_address == NULL)
				{
					printf("Error Allocating Memory for Domain Name Filters\n");
					return;
				}

				memcpy(&address[0], temp_filter_profile, ptr_filter_header->length+1);
				temp_filter_profile += ptr_filter_header->length+1;
				strcpy(sptr_next_restricted_domain_address->domain_name, address);
				sptr_next_restricted_domain_address->is_resolved = FALSE;
				sptr_next_restricted_domain_address->group_mask = ptr_filter_header->mask;
				sptr_next_restricted_domain_address->action = ptr_filter_header->action;
				sptr_next_restricted_domain_address->forward_link = NULL;
				sptr_next_restricted_domain_address->age_domain = MARK_AGE_FLAG;
#if 0
		printf("Domain Name:Mask:Action :: %s:%d:%d\n", sptr_next_restricted_domain_address->domain_name,
				 sptr_next_restricted_domain_address->group_mask, sptr_next_restricted_domain_address->action);
#endif				
				add_entry_to_domain_name_list(sptr_next_restricted_domain_address);
				user_database.number_of_restricted_domain_address++;
				break;
		}
		free(ptr_filter_header);
	}
	current_ptr_remote_user_database = temp_filter_profile;
}

/* Added by Ravi for Parsing the User Database from the Flash */
void update_remote_user_database_structures (BYTE *ptr_remote_user_database)
{
	/* Todo : Parse the remote userdatabase and initialize the respective
		Data structure. */
	USHORT num_of_domain_name;

	current_ptr_remote_user_database = ptr_remote_user_database;
	user_data_base_ptr = (USER_DATABASE *) current_ptr_remote_user_database;

	while(user_data_base_ptr->magic_id != INVALID_MAGIC_ID)	
	{
#if 0
		printf("Ravi : Magic Id    : %x \n", user_data_base_ptr->magic_id);
		printf("Ravi : No of Items : %x \n", user_data_base_ptr->number_of_items);
		printf("Ravi : Length      : %x \n", user_data_base_ptr->length_of_items);
#endif

		current_ptr_remote_user_database += sizeof(USER_DATABASE);

		switch (user_data_base_ptr->magic_id)
		{
			case IP_DEFAULT_MAGIC_ID	:
				  ip_default_profile();	
				  break;	

			case APP_DEFAULT_MAGIC_ID	:
				  app_default_profile();	
				  break;	

			case GROUP_PROFILE_MAGIC_ID :
				  GroupProfile ();
				  break;	
																
			case USER_PROFILE_MAGIC_ID :
				  UserProfile ();
				  break;

			case FILTER_PROFILE_MAGIC_ID :
				  num_of_domain_name = *(USHORT *)current_ptr_remote_user_database;
				  current_ptr_remote_user_database += sizeof(USHORT);	 
				  user_database.max_number_of_restricted_domain_address = num_of_domain_name;

				  FilterProfile ();
				  break;

			case DEFAULT_FILTER_MAGIC_ID :   
				  break;
			
			default :	
				  break;
		}
		user_data_base_ptr = (USER_DATABASE *) current_ptr_remote_user_database;
	}
}

/* Added by Ravi for Aging the Remote User Databases */
void age_remote_user_database_structures()
{
	age_user_online_transition_tree();
	age_user_profile_rb_tree();
	age_group_profile_rb_tree();	
	age_domain_name_list();		/* Sreelu For Domain Name Filters */
	age_app_filter_rb_tree();
	age_ip_filter_rb_tree();
	age_ip_default_filter_rb_tree();
	age_app_default_filter_rb_tree();
	update_group_profile_tree();
	update_user_profile_tree();
	update_resolved_ip_address();
	update_application_filter_tree();		/* Added by Sreelu */
	update_ip_default_tree();
	update_app_default_tree();
	update_domain_name_masks_to_ip_list(); /* Added by Sreelu */

/* Sreelu for filter... */
/*	printf("Number Of Add Resolved : %d\n", user_database.number_of_address_resolved); */
	if(user_database.max_number_of_restricted_domain_address != 0)
	{
		user_database.start_resolving_dns_filters = TRUE;
		user_database.dns_resolver_state == PROXY_START_DNS_CLIENT;
		current_domain_name = sptr_to_restricted_domain_address;
	}
	else
		user_database.start_resolving_dns_filters = FALSE;

/* ...Sreelu for filter */
}

void update_user_profile_defaulter_in_the_flash(USER_PROFILE_NODE *user_profile)
{
	BYTE *current_ptr_user_database_hdr;
	USER_DATABASE *current_user_data_base_ptr;

	current_ptr_user_database_hdr	= (BYTE *) ptr_user_database_hdr->down_load_address;
	current_user_data_base_ptr	= (USER_DATABASE *) current_ptr_user_database_hdr;

	while(current_user_data_base_ptr->magic_id != INVALID_MAGIC_ID)	
	{
#if 0
		printf("Ravi : Magic Id    : %x \n", current_user_data_base_ptr->magic_id);
		printf("Ravi : No of Items : %x \n", current_user_data_base_ptr->number_of_items);
		printf("Ravi : Length      : %x \n", current_user_data_base_ptr->length_of_items);
#endif
		current_ptr_user_database_hdr += sizeof(USER_DATABASE);

		switch (current_user_data_base_ptr->magic_id)
		{
			case IP_DEFAULT_MAGIC_ID :
					current_ptr_user_database_hdr += sizeof(ULONG);
					current_ptr_user_database_hdr += current_user_data_base_ptr->number_of_items * sizeof(TEMP_IP_DEFAULT);
					break;

			case APP_DEFAULT_MAGIC_ID :
					current_ptr_user_database_hdr += current_user_data_base_ptr->number_of_items * sizeof(TEMP_APP_DEFAULT);
					break;

			case GROUP_PROFILE_MAGIC_ID :
					current_ptr_user_database_hdr += sizeof(TEMP_GROUP_PROFILE) * current_user_data_base_ptr->number_of_items;
				   break;	
																
			case USER_PROFILE_MAGIC_ID :
			 	   user_details_update_in_flash(current_ptr_user_database_hdr, current_user_data_base_ptr->number_of_items, user_profile);
					return;
		
			default : break;
		}
		current_user_data_base_ptr	= (USER_DATABASE *) current_ptr_user_database_hdr;
	}
	return;
}

void user_details_update_in_flash (BYTE *current_ptr_user_database_hdr, USHORT number_of_items, USER_PROFILE_NODE *user_profile)
{
	TEMP_USER_PROFILE *temp_user_profile, *temp_user_profile_for_defaulter;
	int index;
	BYTE *temp_ptr_c_write_to_flash;
	USHORT udb_crc = 0xFFFF;
	BYTE   two_zeroes[] = {0, 0} ;
	UDB_HEADER *udb_hdr ;


	temp_user_profile = (TEMP_USER_PROFILE *) current_ptr_user_database_hdr;

	for (index = 0; index < number_of_items; index++)
	{
		if(!strcmp(temp_user_profile->user_name, user_profile->info->user_name))
		{
			temp_ptr_c_write_to_flash = calloc(sizeof(TEMP_USER_PROFILE),1);
			if (temp_ptr_c_write_to_flash == NULL)
			{
				printf("Insufficient Memory for flash write\n");
				return;
			}
			memcpy(temp_ptr_c_write_to_flash, current_ptr_user_database_hdr, sizeof(TEMP_USER_PROFILE));

			temp_user_profile_for_defaulter = (TEMP_USER_PROFILE *) temp_ptr_c_write_to_flash;
			temp_user_profile_for_defaulter->defaulter = user_profile->info->defaulter;

			write_record_to_flash(temp_ptr_c_write_to_flash, current_ptr_user_database_hdr, sizeof(TEMP_USER_PROFILE));
			free (temp_ptr_c_write_to_flash);

			/* Update the Checksum. Very Important */
			temp_ptr_c_write_to_flash = calloc(FL_PAGE_SIZE, 1);
			if (temp_ptr_c_write_to_flash == NULL)
			{
				printf ("No memory for flash write\n\r") ;
				return;
			}
			memcpy (temp_ptr_c_write_to_flash, (BYTE *)ptr_user_database_hdr, FL_PAGE_SIZE);
			udb_hdr = (UDB_HEADER *)temp_ptr_c_write_to_flash ;

			udb_crc = update_crc (udb_crc,
									(BYTE *)ptr_user_database_hdr->down_load_address,
	      	               (ULONG)ptr_user_database_hdr->length) ;
			udb_crc = update_crc (udb_crc, &two_zeroes[0], 2) ;

			udb_hdr->crc = udb_crc ;

			c_write_to_flash (temp_ptr_c_write_to_flash, (BYTE *)UDB_HEADER_ADDRESS, FL_PAGE_SIZE);
			free (temp_ptr_c_write_to_flash) ;

#if 0
			printf("Ravi : Match Found. Defaulter Updated\n");
			printf("Ravi : Defaulter : %d\n", user_profile->info->defaulter);
#endif
			return;
		}

		current_ptr_user_database_hdr += sizeof(TEMP_USER_PROFILE);
		temp_user_profile = (TEMP_USER_PROFILE *) current_ptr_user_database_hdr;
	}
}

int write_record_to_flash(byte *src, byte *dst, int len)
{
	byte temp[FL_PAGE_SIZE];
	ULONG  offset;
	int  bytes_to_copy_from_src; 

	while (len > 0)	 
	{
		/* Is Destination on a FL_PAGE_SIZE Boundary */
		offset = (ULONG) dst % FL_PAGE_SIZE;

		/* Align Destination to FL_PAGE_SIZE Boundary */
		dst -= offset;
	
		/* Copy Contents from Flash to Dram */
		memcpy(temp, dst, FL_PAGE_SIZE);

		/* How much of the Flash should be modified */
		bytes_to_copy_from_src = (len >= FL_PAGE_SIZE - offset) ? FL_PAGE_SIZE - offset : len;

		/* Modify */
		memcpy(temp+offset, src, bytes_to_copy_from_src);

		/* Write back to flash */
		c_write_to_flash(temp, dst, FL_PAGE_SIZE);

/*		printf("Dst:%x,Src:%x,len:%d\r\n", dst, src, bytes_to_copy_from_src);  */

		/* Update modified size */
		len -= bytes_to_copy_from_src;

		/*  Update Src and Dst */
		src += bytes_to_copy_from_src;
		dst += FL_PAGE_SIZE;
	}
}

/* Add the ip address to Range of IP Address that needs no authentication.
	Called from prnat.c */	
void
add_nat_entry_to_ip_default_profile(ULONG ip_address)
{
	IP_ADD_DEFAULT_INFO *info;
	IP_ADD_DEFAULT_KEY *key;
	IP_ADD_DEFAULT_NODE *ptr_to_ip_node;

	key = (IP_ADD_DEFAULT_KEY *) calloc (sizeof(IP_ADD_DEFAULT_KEY), 1);
	if (key == NULL)
	{
		printf("IP_DEFAULT: Error Allocating Memory\n");
		return;
	}

	key->lower_ip_range = ip_address;
	key->upper_ip_range = ip_address;

	ptr_to_ip_node = ipadd_default_rb_search (key->lower_ip_range);
	if(ptr_to_ip_node == NULL)
	{
		info = (IP_ADD_DEFAULT_INFO *) calloc (sizeof(IP_ADD_DEFAULT_INFO), 1);
		if (info == NULL)
		{
			printf("IP_DEFAULT: Error Allocating Memory\n");
			free(key);
			return;
		}
	
		info->ip_default_age = NAT_AGE_FLAG;

		add_entry_ipadd_default_rb_tree (info, (unsigned char *) key);
	}
	else
		free(key);

	return;
}
