#include <defs.h>

#include <stdio.h>
#include <stdlib.h>
#include <kstart.h>
#include "userdata.h"

#include <redblack.h>
#include "..\..\stacks\ip\kdns.h" 

/* Function Prototypes */
void user_authentication_timer (void);
extern void age_user_online_rb_tree ();
int ticks_into_second_timer;

extern USER_DATABASE_CLASS user_database;
extern DOMAIN_NAME_LIST *sptr_to_restricted_domain_address;
extern DOMAIN_NAME_LIST *current_domain_name;
extern void add_entry_ipadd_filter_rb_tree (IP_ADD_FILTER_INFO *user_info,unsigned char *vptr_buffer);
extern enum TEST get_ip_address_from_name (BYTE *domain_name, USHORT port_number, void (*fptr_complete_routine)(ULONG *, USHORT,USHORT, enum DNS_STATE));
void set_resolved_address_in_list(ULONG *resolved_ip_address, USHORT count,USHORT port_number, enum DNS_STATE status);
void process_proxy_server_domain_name_filters ();
extern void check_if_any_users_are_to_be_marked_as_defaulter();

void user_authentication_timer (void)
{
    /* To Do : 
	 **	1. Aging of the User accounts in the online transition
	 **		table.
	 **   2.	If the account is aged, Remove it from the online transition
	 **	   table.
	 **	3. If an account becomes a defaulter, then remove it from the
	 ** 		user online transition table and update the master. 
	 */

	/* Every 20 ticks makes 1 sec. Timer is called at 50ms */

	if (++ticks_into_second_timer == 20)
	{										 
		check_if_udb_updated () ;
		age_user_online_rb_tree (); 
		check_if_any_users_are_to_be_marked_as_defaulter();
		ticks_into_second_timer = 0;

/* Sreelu for Filters... */
	if (user_database.start_resolving_dns_filters == TRUE && 
		user_database.dns_resolver_state == PROXY_START_DNS_CLIENT)
			process_proxy_server_domain_name_filters ();
/* ...Sreelu for Filters */
	}
}

void start_resolving_proxy_dns_filters ()
{
	user_database.start_resolving_dns_filters = TRUE;
}

void process_proxy_server_domain_name_filters ()
{
	BYTE domain_name_buffer[255];

	if (user_database.number_of_address_resolved == user_database.max_number_of_restricted_domain_address)
	{
		printf ("USER: All Domain names resolved\n"); 
		user_database.start_resolving_dns_filters = FALSE;
		return;
	}

	if(current_domain_name == NULL)
		current_domain_name = sptr_to_restricted_domain_address;
	
NEXT_DOMAIN:
	if(current_domain_name->is_resolved == FALSE)
		strcpy (&domain_name_buffer[0], current_domain_name->domain_name);
	else
	{
		current_domain_name = current_domain_name->forward_link;
		if(current_domain_name == NULL)
			return;
		goto NEXT_DOMAIN;
	}
	user_database.number_of_address_resolved++;

	printf ("USER_DNS: Trying to Resolve %s\n",domain_name_buffer);
	
	user_database.dns_resolver_state = PROXY_WAIT_TO_RESOLVE;
  	if (get_ip_address_from_name (domain_name_buffer, 0, set_resolved_address_in_list) == FAIL)
  	{
		user_database.dns_resolver_state = PROXY_START_DNS_CLIENT;
		printf ("USER :resolving failed\n");
		return;
  	} 
	return;
}

void set_resolved_address_in_list(ULONG *resolved_ip_address, USHORT count,USHORT port_number, enum DNS_STATE status)
{
	IP_ADD_FILTER_INFO *ptr_ip_add_info;
	IP_ADD_FILTER_KEY key;
	USHORT domain_name_index=0,index = 0;
	BYTE dns_buffer[50];

	if (status == RESOLVED)
	{
		for (index = 0;index < count;index++)
		{
			ptr_ip_add_info = (IP_ADD_FILTER_INFO *) malloc (sizeof(IP_ADD_FILTER_INFO));
			key.ip_address = *resolved_ip_address;
			ptr_ip_add_info->group_mask = current_domain_name->group_mask;
			ptr_ip_add_info->action = current_domain_name->action;
			ptr_ip_add_info->ptr_to_domain_name_list = current_domain_name;
			ptr_ip_add_info->age_ip = MARK_AGE_FLAG;

			convert_ip_address_to_dot_format (&dns_buffer[0], key.ip_address);
			printf ("PROXY: Resolved Name is %s %s\n",current_domain_name->domain_name, dns_buffer);
			current_domain_name->is_resolved = TRUE;
			add_entry_ipadd_filter_rb_tree(ptr_ip_add_info, &key);
			resolved_ip_address++;
		}
	}
	else
	{
		current_domain_name->is_resolved = FALSE;
		current_domain_name = current_domain_name->forward_link;
		user_database.number_of_address_resolved--;
		printf ("USER: DNS Resolving Failed\n");
	}

	user_database.dns_resolver_state = PROXY_START_DNS_CLIENT;
	return;
}



