/* This c files contains the functions of RED-BLACK tree for Inserting,
	Deleting, Search,etc.. the APP_DEFAULT_NODE
*/

#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "userdata.h"

APP_DEFAULT_NODE far *sptr_appdefault_filter_tree;
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;

static APP_DEFAULT_NODE far *get_new_app_default_rb_node ()
{
	return ((APP_DEFAULT_NODE far *) malloc (sizeof (APP_DEFAULT_NODE))) ;
}

int app_default_RB_insert_node(APP_DEFAULT_NODE far *Tree, APP_DEFAULT_KEY  key, APP_DEFAULT_INFO *info, APP_DEFAULT_NODE far **ptr_sptr_new_node)
{
	APP_DEFAULT_NODE far *nptr ;

	int retVal ;

	retVal = app_default_rb_compare_key(Tree, key);	 

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (app_default_RB_insert_node ((APP_DEFAULT_NODE far *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_app_default_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
	
			nptr->key = key ;
			nptr->info = info ;
		
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER far *)nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
			return (app_default_RB_insert_node ((APP_DEFAULT_NODE far *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_app_default_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;

			nptr->key = key ;
			nptr->info = info ;

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER far *) nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}

	return USER_RB_UPDATED ;
}

int app_default_RB_insert(APP_DEFAULT_KEY key, APP_DEFAULT_INFO *info)
{
	APP_DEFAULT_NODE far *nptr, far *sptr_new_node ;
	int retVal ;

	if (sptr_appdefault_filter_tree == (APP_DEFAULT_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_app_default_rb_node() ;

		if (nptr == NULL)
			return USER_RB_INSERT_OVERFLOW ;

		nptr->key = key ;
		nptr->info = info ;

		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_appdefault_filter_tree = nptr ;

		return USER_RB_NEW_ENTRY ;
	}

	retVal = app_default_RB_insert_node (sptr_appdefault_filter_tree, key, info, &sptr_new_node) ;

	if (retVal == USER_RB_NEW_ENTRY)
	{
		sptr_appdefault_filter_tree = (APP_DEFAULT_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER far *)sptr_new_node, (RED_BLACK_NODE_HEADER far *)sptr_appdefault_filter_tree) ;
	}

	return retVal ;
}

void add_entry_app_default_rb_tree (APP_DEFAULT_INFO *info,unsigned char *vptr_buffer)
{
	if (sptr_appdefault_filter_tree == NULL)
		sptr_appdefault_filter_tree = (APP_DEFAULT_NODE far *) sptr_RB_sentinal_node;

   app_default_RB_insert (*((APP_DEFAULT_KEY *)(vptr_buffer)), info) ;
}

APP_DEFAULT_NODE far *app_default_rb_search(USHORT port, USHORT protocol)
{
	APP_DEFAULT_NODE far *sptr_next_node, far *sptr_temp;
	if(sptr_appdefault_filter_tree == NULL)
		return NULL;
	
	sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *) sptr_appdefault_filter_tree) ;
   while (sptr_next_node != NULL)
	{
		sptr_temp = sptr_next_node ;
		if((sptr_temp->key.protocol == protocol) || (sptr_temp->key.protocol == TCP_UDP_PROTOCOL))
		{
			if (port >= sptr_temp->key.lower_port && port <= sptr_temp->key.upper_port)
				return (sptr_temp);
		}

		sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
	return NULL;
}

#if 0		/* Commented by Sreelu */
int delete_entry_from_app_default_rb_tree (APP_DEFAULT_KEY key)
{
   APP_DEFAULT_NODE far *sptr_node_to_delete ;

   sptr_node_to_delete = app_default_rb_search (sptr_appdefault_filter_tree, key) ;

   if (sptr_node_to_delete)
   {
      RB_delete ((RED_BLACK_NODE_HEADER far *)sptr_appdefault_filter_tree, (RED_BLACK_NODE_HEADER far *)sptr_node_to_delete, (unsigned long) sizeof (APP_DEFAULT_NODE), (RED_BLACK_NODE_HEADER far **)&sptr_node_to_delete) ;
		free(sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}
#endif


int app_default_rb_compare_key ( APP_DEFAULT_NODE far *Tree, APP_DEFAULT_KEY key)
{
	if(Tree->key.lower_port == key.lower_port)
	{
		if(Tree->key.upper_port == key.upper_port)
		{
			if(Tree->key.protocol == key.protocol)
				return 0;
			else
				return(Tree->key.protocol - key.protocol);			
		}
		else
			return(Tree->key.upper_port - key.upper_port);			
	}
	else
		return(Tree->key.lower_port - key.lower_port);			
}

void display_app_default_tree ()
{
	int index=0 ;
	char address1[50], address2[50];
	APP_DEFAULT_NODE far *sptr_root = sptr_appdefault_filter_tree, far *sptr_next_node;

	if(sptr_appdefault_filter_tree == NULL)
	{
/*		printf("\n APP Filter Tree ptr is NULL") ; */
		return;
	}

	sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	if (sptr_next_node == NULL)
	{
		printf("\n The APP Default Filter Tree is empty");
		return;
	}

	printf ("\n **");
	printf ("\n          Displaying IP Filter Tree               ") ;
	printf ("\n **");


	while (sptr_next_node)
	{
		printf ("\n [%d]  [%d]  [%d]" , sptr_next_node->key.lower_port, sptr_next_node->key.upper_port, sptr_next_node->key.protocol);
		++index ;
					
		sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}

	printf ("\n **");
	printf ("\n     Total Number of Entries : %d", index) ;
	printf ("\n **\n\n");
}

void age_app_default_filter_rb_tree()
{
	APP_DEFAULT_NODE far *sptr_next_node, far *sptr_temp;
	APP_DEFAULT_KEY key;
	char string[50];

	if(sptr_appdefault_filter_tree == NULL)
	{
/*		printf("\n The APP Default Tree is empty") ; */
		return;
	}
	
	sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *) sptr_appdefault_filter_tree) ;
   while (sptr_next_node != NULL)
	{
      sptr_temp = sptr_next_node ;

     if (sptr_temp->info->app_default_age == DONOT_AGE_FLAG)
		{
			sptr_appdefault_filter_tree = (APP_DEFAULT_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)sptr_appdefault_filter_tree,
				          (RED_BLACK_NODE_HEADER far *)sptr_temp,
                      (unsigned long) sizeof (APP_DEFAULT_NODE),
                      (RED_BLACK_NODE_HEADER far **)&sptr_temp) ;
			free(sptr_temp);
		}

		sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
}

void update_app_default_tree()
{
	APP_DEFAULT_NODE far  *sptr_root = sptr_appdefault_filter_tree, *sptr_next_node;
	
	if(sptr_appdefault_filter_tree == NULL)
		return;

	sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		sptr_next_node->info->app_default_age = DONOT_AGE_FLAG;
		sptr_next_node = (APP_DEFAULT_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
}
