/* This c files contains the functions of RED-BLACK tree for Inserting,
	Deleting, Search,etc.. the APP_FILTER_NODE
*/

#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "userdata.h"

APP_FILTER_NODE far *spr_app_filter_tree;

static APP_FILTER_NODE far *get_new_app_filter_rb_node ()
{
	return ((APP_FILTER_NODE far *) malloc (sizeof (APP_FILTER_NODE))) ;
}

int app_filter_RB_insert_node(APP_FILTER_NODE far *Tree, APP_FILTER_KEY  key, APP_FILTER_INFO *info, APP_FILTER_NODE far **ptr_sptr_new_node)
{
	APP_FILTER_NODE far *nptr ;

	int retVal ;

	retVal = app_filter_rb_compare_key(Tree, key);	 

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (app_filter_RB_insert_node ((APP_FILTER_NODE far *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_app_filter_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
	
			nptr->key = key ;
			nptr->info = info;
		
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER *)nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
			return (app_filter_RB_insert_node ((APP_FILTER_NODE far *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_app_filter_rb_node() ;
			if (nptr == NULL)
			{
				return USER_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;

			nptr->key = key ;
			nptr->info = info;

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER *) nptr ;

			return USER_RB_NEW_ENTRY ;
		}
	}

	return USER_RB_UPDATED ;
}

int app_filter_RB_insert(APP_FILTER_KEY key, APP_FILTER_INFO *info)
{
	APP_FILTER_NODE far *nptr, far *sptr_new_node ;
	int retVal ;

	if (spr_app_filter_tree == (APP_FILTER_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_app_filter_rb_node() ;

		if (nptr == NULL)
			return USER_RB_INSERT_OVERFLOW ;

		nptr->key = key ;
		nptr->info = info;

		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		spr_app_filter_tree = nptr ;

		return USER_RB_NEW_ENTRY ;
	}

	retVal = app_filter_RB_insert_node (spr_app_filter_tree, key, info, &sptr_new_node) ;

	if (retVal == USER_RB_NEW_ENTRY)
	{
		spr_app_filter_tree = (APP_FILTER_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER *)sptr_new_node, (RED_BLACK_NODE_HEADER *)spr_app_filter_tree) ;
	}

	return retVal ;
}

void add_entry_to_app_filter_rb_tree (APP_FILTER_INFO *info,unsigned char *vptr_buffer)
{
	if (spr_app_filter_tree == NULL)
		spr_app_filter_tree = (APP_FILTER_NODE far *) sptr_RB_sentinal_node;

   app_filter_RB_insert (*((APP_FILTER_KEY *)(vptr_buffer)), info) ;
}


APP_FILTER_NODE far *app_filter_rb_search(APP_FILTER_NODE far *Tree, APP_FILTER_KEY key)
{
	int ret_val ;
	
	if (Tree == NULL)
		return NULL ;

	if (Tree == (APP_FILTER_NODE far  *)sptr_RB_sentinal_node)
		return NULL ;

	ret_val = app_filter_rb_compare_key(Tree, key);	 

	if (ret_val < 0)
	{
		return app_filter_rb_search ((APP_FILTER_NODE far *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return app_filter_rb_search((APP_FILTER_NODE far *)Tree->rb_header.LChild, key) ;
	}
	else
	{
 		return Tree ;
 	}
}

int delete_entry_from_app_filter_rb_tree (APP_FILTER_KEY key)
{
   APP_FILTER_NODE far *sptr_node_to_delete ;

   sptr_node_to_delete = app_filter_rb_search (spr_app_filter_tree, key) ;

   if (sptr_node_to_delete)
   {
      RB_delete ((RED_BLACK_NODE_HEADER *)spr_app_filter_tree, (RED_BLACK_NODE_HEADER *)sptr_node_to_delete, (unsigned long) sizeof (APP_FILTER_NODE), (RED_BLACK_NODE_HEADER **)&sptr_node_to_delete) ;
		free(sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}


int app_filter_rb_compare_key ( APP_FILTER_NODE far *Tree, APP_FILTER_KEY key)
{
	if(Tree->key.port == key.port)
	{
		if(Tree->key.protocol == key.protocol)
			return 0;
		else
			return(Tree->key.protocol - key.protocol);
	}
	else
		return(Tree->key.port - key.port);			
}

void display_app_filter_tree ()
{
	int index=0 ;
	APP_FILTER_NODE far  *sptr_root = spr_app_filter_tree, far *sptr_next_node;

	if(spr_app_filter_tree == NULL)
	{
/*		printf("\n App Filter Tree ptr is NULL") ; */
		return;
	}

	sptr_next_node = (APP_FILTER_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	if (sptr_next_node == NULL)
	{
		printf("\n The Application Filter Tree is empty") ;
		return;
	}

	printf ("\n **");
	printf ("\n          Displaying App Filter Tree               ") ;
	printf ("\n **");


	while (sptr_next_node)
	{
		printf ("\n [%d]  [%d]  [%x]", sptr_next_node->key.port, sptr_next_node->key.protocol, sptr_next_node->info->group_mask);

		++index ;
					
		sptr_next_node = (APP_FILTER_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

	printf ("\n **");
	printf ("\n     Total Number of Entries : %d", index) ;
	printf ("\n **\n\n");
}

void age_app_filter_rb_tree()
{
	APP_FILTER_NODE far *sptr_next_node, far *sptr_temp;
	APP_FILTER_KEY key;

	if(spr_app_filter_tree == NULL)
		return;
	
	sptr_next_node = (APP_FILTER_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *) spr_app_filter_tree) ;
   while (sptr_next_node)
	{
      sptr_temp = sptr_next_node ;

      if (sptr_temp->info->age_app == DONOT_AGE_FLAG)
		{
 	       spr_app_filter_tree = (APP_FILTER_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)spr_app_filter_tree,
				          (RED_BLACK_NODE_HEADER far *)sptr_temp,
                      (unsigned long) sizeof (APP_FILTER_NODE),
                      (RED_BLACK_NODE_HEADER far **)&sptr_temp) ;
			free(sptr_temp);
		}
#if 0		/* Commented by Sreelu */
		else
		{
				sptr_temp->info->age_app = DONOT_AGE_FLAG;
      }
#endif
		sptr_next_node = (APP_FILTER_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
}

void update_application_filter_tree()
{
	APP_FILTER_NODE far  *sptr_root = spr_app_filter_tree, *sptr_next_node;
	
	if(spr_app_filter_tree == NULL)
		return;

	sptr_next_node = (APP_FILTER_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		sptr_next_node->info->age_app = DONOT_AGE_FLAG;
		sptr_next_node = (APP_FILTER_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
}
