/* This c files contains the functions for Inserting,
	Deleting, Search,etc.. the DOMAIN_NAME_LIST
	Added by Sreelu.
*/

#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "userdata.h"

extern USER_DATABASE_CLASS user_database;
extern DOMAIN_NAME_LIST  *sptr_to_restricted_domain_address;
extern IP_ADD_FILTER_NODE far *sptr_ipadd_filter_tree;

void display_domain_name_filters()
{
	int i, index=0;
	DOMAIN_NAME_LIST *sptr_next_node = sptr_to_restricted_domain_address;

	printf ("\n **");
	printf ("\n          Displaying Domain Filters                ") ;
	printf ("\n **");
	if(sptr_to_restricted_domain_address == NULL)
	{
		printf("\n Domain Filter ptr is NULL") ;
		return;
	}

	while(1)
	{
		printf ("\n [%s] : [%d] : [%x] ", sptr_next_node->domain_name, sptr_next_node->is_resolved, sptr_next_node->group_mask);
		index++;
		if(sptr_next_node->forward_link == NULL)
			break;
		sptr_next_node = sptr_next_node->forward_link;
	}
	printf ("\n **");
	printf ("\n     Total Number of Entries : %d", index) ;
	printf ("\n **\n\n");
}

void add_entry_to_domain_name_list(DOMAIN_NAME_LIST *sptr_domain_name_list)
{
	DOMAIN_NAME_LIST *ptr_to_list = sptr_to_restricted_domain_address, *temp_ptr;
	BYTE_ENUM (BOOLEAN)	is_resolved;

	if(sptr_to_restricted_domain_address == NULL)
	{
		sptr_to_restricted_domain_address = sptr_domain_name_list;
		sptr_to_restricted_domain_address->forward_link = NULL;
		return;
	}

	while(1)
	{
		if(strcmpi(ptr_to_list->domain_name, sptr_domain_name_list->domain_name) == 0)
		{
			ptr_to_list->group_mask = sptr_domain_name_list->group_mask;
			ptr_to_list->action = sptr_domain_name_list->action;
			ptr_to_list->age_domain = sptr_domain_name_list->age_domain;
			free(sptr_domain_name_list);
			return;
		}
		else
		if(ptr_to_list->forward_link == NULL)
		{
			ptr_to_list->forward_link = sptr_domain_name_list;
			ptr_to_list->forward_link->forward_link = NULL;
			return;
		}
		else
		{
			ptr_to_list = ptr_to_list->forward_link;
		}
	}
}

void delete_next_node_from_list (DOMAIN_NAME_LIST *sptr_to_list)
{
	DOMAIN_NAME_LIST *temp_ptr;
	
	if(sptr_to_list == NULL)
		return;

	temp_ptr = sptr_to_list->forward_link->forward_link;
	free(sptr_to_list->forward_link);
	user_database.number_of_address_resolved--;
	sptr_to_list->forward_link = temp_ptr;
}

void age_entries_from_ip_add_filter(DOMAIN_NAME_LIST *ptr_to_list)
{
	IP_ADD_FILTER_NODE far *sptr_next_node, far *sptr_temp;
	char string[50];

	if(sptr_ipadd_filter_tree == NULL)
		return;

	sptr_next_node = (IP_ADD_FILTER_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *) sptr_ipadd_filter_tree) ;
   while (sptr_next_node != NULL)
	{
      sptr_temp = sptr_next_node ;

      if (!strcmp(sptr_temp->info->ptr_to_domain_name_list->domain_name,ptr_to_list->domain_name))
		{
			convert_ip_address_to_dot_format(&string[0], sptr_temp->key.ip_address);
/*			printf("Aging - %s : %s : %s\n", string, sptr_temp->info->ptr_to_domain_name_list->domain_name,ptr_to_list->domain_name); */

#if 0		/* Commented by Sreelu */
			sptr_ipadd_filter_tree = (IP_ADD_FILTER_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_ipadd_filter_tree,
			   (RED_BLACK_NODE_HEADER *)sptr_temp,
            (unsigned long) sizeof (IP_ADD_FILTER_NODE),
            (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
			free(sptr_temp);
#endif
			sptr_temp->info->ptr_to_domain_name_list = NULL;
			sptr_temp->info->age_ip = DONOT_AGE_FLAG;
		}

		sptr_next_node = (IP_ADD_FILTER_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;

#if 0
		if(sptr_next_node == NULL)
			printf("sptr_next_node is NULL\n");
#endif
	}
}

void age_domain_name_list()
{
	DOMAIN_NAME_LIST *sptr_next_node, *sptr_temp;

	if(sptr_to_restricted_domain_address == NULL)
		return;

	sptr_temp = sptr_to_restricted_domain_address;
   while (sptr_temp != NULL)
	{
		sptr_next_node = sptr_temp->forward_link;
		if(sptr_next_node == NULL)
			break;

      if (sptr_next_node->age_domain == DONOT_AGE_FLAG)
		{
			age_entries_from_ip_add_filter(sptr_next_node);
			delete_next_node_from_list(sptr_temp);
		}
		else
		{
			sptr_next_node->age_domain = DONOT_AGE_FLAG;
			sptr_temp = sptr_temp->forward_link;
      }
	}

	if(sptr_to_restricted_domain_address->age_domain == DONOT_AGE_FLAG)
	{
		sptr_temp = sptr_to_restricted_domain_address;
		age_entries_from_ip_add_filter(sptr_to_restricted_domain_address);
		sptr_to_restricted_domain_address = sptr_temp->forward_link;
		free(sptr_temp);
		user_database.number_of_address_resolved--;
	}
	else
		sptr_to_restricted_domain_address->age_domain = DONOT_AGE_FLAG;
}

void update_resolved_ip_address()
{
	IP_ADD_FILTER_NODE far  *sptr_root = sptr_ipadd_filter_tree, far *sptr_next_node;
	
	if(sptr_ipadd_filter_tree == NULL)
		return;

	sptr_next_node = (IP_ADD_FILTER_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	if (sptr_next_node == NULL)
	{
		printf("\n Couldn't Update Resolved IP Address") ;
		return;
	}

	while (sptr_next_node != NULL)
	{
		if(sptr_next_node->info->ptr_to_domain_name_list != NULL) 
			sptr_next_node->info->age_ip = MARK_AGE_FLAG;
		else
			sptr_next_node->info->age_ip = DONOT_AGE_FLAG;

		sptr_next_node = (IP_ADD_FILTER_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
}
