typedef struct GROUP_PROFILE
{
	char						group_name [MAX_LENGTH_GROUP_PROFILE_NAME];
	char						group_description [MAX_LENGTH_GROUP_PROFILE_DESC];
	USHORT 					defaulter_login_attempts;
	USHORT					defaulter_number_of_login_attempts;
	USHORT					defaulter_blacklisted_sites;
	USHORT					defaulter_number_of_attempts_of_blacklisted_sites;
	USHORT					audit_log_for_login_attempts;
	USHORT					audit_log_for_blacklisted_sites;
	USHORT					allow_sites;
	ULONG						user_permission [7]; // Number of Days in a week
	USHORT					group_no;
	USHORT					group_age_flag;
}GROUP_PROFILE;


typedef struct GROUP_PROFILE_KEY_TYPE
{
	char						group_name [MAX_LENGTH_GROUP_PROFILE_NAME];
}GROUP_PROFILE_KEY_TYPE;


typedef struct GROUP_PROFILE_NODE
{
	RED_BLACK_NODE_HEADER rb_header ;
	GROUP_PROFILE_KEY_TYPE key;
	GROUP_PROFILE *info ;
}GROUP_PROFILE_NODE;


typedef struct USER_PROFILE
{
	char					user_name [MAX_LENGTH_USER_NAME];
	char					user_password [MAX_LENGTH_USER_PASSWORD];
	char					group_name [MAX_LENGTH_GROUP_PROFILE_NAME];
	enum DEFAULTER_STATE	defaulter;
	USHORT				account_status;
	GROUP_PROFILE_NODE	*sptr_user_group_profile_node;
	BYTE					*time_restriction;
	USHORT				user_age_flag;
	USHORT				defaulter_number_of_login_attempts;
	USHORT				defaulter_number_of_attempts_of_blacklisted_sites;
}USER_PROFILE;


typedef struct USER_PROFILE_KEY_TYPE
{
	char					user_name [MAX_LENGTH_USER_NAME];
}USER_PROFILE_KEY_TYPE;


typedef struct USER_PROFILE_NODE
{
	RED_BLACK_NODE_HEADER rb_header ;
	USER_PROFILE_KEY_TYPE key;
	USER_PROFILE *info ;
}USER_PROFILE_NODE;


typedef struct USER_ONLINE_TRANSITION_TABLE
{
	ULONG					ip_address;
	BYTE					mac_address[MAX_LENGTH_MAC_ADDRESS];
	BYTE					user_name [MAX_LENGTH_USER_NAME];
	BYTE					group_name [MAX_LENGTH_GROUP_PROFILE_NAME];
	USHORT				group_no;	/* Added by Sreelu */
	BYTE_ENUM (BOOLEAN)	account_status;
	enum DEFAULTER_STATE	defaulter;
	ULONG					age;
	char					login_time[15];
	USER_PROFILE_NODE	*ptr_user_profile_node;
}USER_ONLINE_TRANSITION_TABLE;


typedef struct USER_ONLINE_TRANSITION_KEY_TYPE
{
	ULONG					ip_address;
}USER_ONLINE_TRANSITION_KEY_TYPE;


typedef struct USER_ONLINE_TRANSITION_NODE
{
	RED_BLACK_NODE_HEADER rb_header ;
	USER_ONLINE_TRANSITION_KEY_TYPE key;
	USER_ONLINE_TRANSITION_TABLE *info ;
}USER_ONLINE_TRANSITION_NODE;

/* added by Ravi */
typedef struct USER_DATABASE
{
	USHORT		magic_id;
	USHORT		number_of_items;
	ULONG			length_of_items;
}USER_DATABASE;


/* Added by Sreelu for Filters.... */
enum PROTOCOL
{
	TCP = 17,
	UDP = 06
};

/* Domain Names are in Linked List */

typedef struct DOMAIN_NAME_LIST
{
	BYTE  domain_name[260];
	BYTE_ENUM(BOOLEAN) is_resolved;
	ULONG group_mask; 
	USHORT action;		
	USHORT age_domain;
	struct DOMAIN_NAME_LIST *forward_link;
}DOMAIN_NAME_LIST;

/* IP Address Tree */
typedef struct IP_ADD_FILTER_KEY
{
   ULONG ip_address;
}IP_ADD_FILTER_KEY;

typedef struct IP_ADD_FILTER_INFO
{
   ULONG group_mask;
	USHORT action;		
   DOMAIN_NAME_LIST  *ptr_to_domain_name_list; 
	USHORT	age_ip;
}IP_ADD_FILTER_INFO;

typedef struct IP_ADD_FILTER_NODE
{
   RED_BLACK_NODE_HEADER  rb_header;
   IP_ADD_FILTER_KEY  key;
	IP_ADD_FILTER_INFO *info;
}IP_ADD_FILTER_NODE;

/* Application Filter Tree */
typedef struct APP_FILTER_KEY
{
	USHORT port;
	USHORT protocol;
}APP_FILTER_KEY;

typedef struct APP_FILTER_INFO
{
	ULONG	group_mask;
	USHORT action;		
	USHORT  age_app;
}APP_FILTER_INFO;

typedef struct APP_FILTER_NODE
{
   RED_BLACK_NODE_HEADER  rb_header;
	APP_FILTER_KEY key;
	APP_FILTER_INFO *info;
}APP_FILTER_NODE;

/* For IP Addresses & Application Ports that need no Authentication.... */
typedef struct IP_ADD_DEFAULT_KEY
{
   ULONG lower_ip_range;
   ULONG upper_ip_range;
}IP_ADD_DEFAULT_KEY;

typedef struct IP_ADD_DEFAULT_INFO
{
	USHORT  ip_default_age;	
}IP_ADD_DEFAULT_INFO;

typedef struct IP_ADD_DEFAULT_NODE
{
   RED_BLACK_NODE_HEADER  rb_header;
   IP_ADD_DEFAULT_KEY  key;
	IP_ADD_DEFAULT_INFO *info; 
}IP_ADD_DEFAULT_NODE;

typedef struct APP_DEFAULT_KEY
{
	USHORT lower_port;
	USHORT upper_port;
	USHORT protocol;
}APP_DEFAULT_KEY;

typedef struct APP_DEFAULT_INFO
{
	USHORT  app_default_age;	
}APP_DEFAULT_INFO;

typedef struct APP_DEFAULT_NODE
{
   RED_BLACK_NODE_HEADER  rb_header;
	APP_DEFAULT_KEY key;
	APP_DEFAULT_INFO *info; 
}APP_DEFAULT_NODE;
/* ....For IP Addresses & Application Ports that need no Authentication */

typedef struct TEMP_FILTER_HEADER
{
	USHORT type;
	ULONG mask;
	USHORT action;		
	USHORT length;
}TEMP_FILTER_HEADER;

/* ....Added by Sreelu for Filters */

/* Added By Ravi */
typedef struct TEMP_GROUP_PROFILE
{
	char						group_name [MAX_LENGTH_GROUP_PROFILE_NAME];
	char						group_description [MAX_LENGTH_GROUP_PROFILE_DESC];
	USHORT 					defaulter_login_attempts;
	USHORT					defaulter_number_of_login_attempts;
	USHORT					defaulter_blacklisted_sites;
	USHORT					defaulter_number_of_attempts_of_blacklisted_sites;
	USHORT					audit_log_for_login_attempts;
	USHORT					audit_log_for_blacklisted_sites;
	USHORT					allow_sites;
	ULONG						user_permission [7]; // Number of Days in a week
	USHORT					group_no;			//sreelu
}TEMP_GROUP_PROFILE;


typedef struct TEMP_USER_PROFILE
{
	char					user_name [MAX_LENGTH_USER_NAME];
	char					user_password [MAX_LENGTH_USER_PASSWORD];
	char					group_name [MAX_LENGTH_GROUP_PROFILE_NAME];
	USHORT				defaulter;
	USHORT				account_status;
}TEMP_USER_PROFILE;

typedef struct TEMP_IP_DEFAULT
{
	char lower_address[16];
	char upper_address[16];
}TEMP_IP_DEFAULT;

typedef struct TEMP_APP_DEFAULT
{
	USHORT lower_port;
	USHORT upper_port;
	USHORT protocol;
}TEMP_APP_DEFAULT;


/* Linked List For User Database - User, Group, & Filter Profiles */
typedef struct USER_DATA
{
	TEMP_USER_PROFILE *data;
	struct USER_DATA *prev_node;
	struct USER_DATA *next_node;
}USER_DATA;

typedef struct GROUP_DATA
{
	TEMP_GROUP_PROFILE *data;
	USHORT count;  /* This is for convinience of programming configuration */
	USHORT filter_action;  /* This is for convinience of programming configuration */
	struct GROUP_DATA *prev_node;
	struct GROUP_DATA *next_node;
}GROUP_DATA;

typedef struct IP_DEFAULT_DATA
{
	TEMP_IP_DEFAULT *data;
	struct IP_DEFAULT_DATA *prev_node;
	struct IP_DEFAULT_DATA *next_node;
}IP_DEFAULT_DATA;

typedef struct APP_DEFAULT_DATA
{
	TEMP_APP_DEFAULT *data;
	struct APP_DEFAULT_DATA *prev_node;
	struct APP_DEFAULT_DATA *next_node;
}APP_DEFAULT_DATA;

typedef struct FILTER_DATA
{
	TEMP_FILTER_HEADER *header;
	USHORT port;
	USHORT protocol;
	BYTE  address[260];
	struct FILTER_DATA *prev_node;
	struct FILTER_DATA *next_node;
}FILTER_DATA;

typedef	struct 	USER_DATABASE_CLASS
{
	USHORT user_database_enabled;
	USHORT default_action;		

	USHORT temp_enabled;
	USHORT temp_action;

	GROUP_DATA *sptr_temp_group_data;
	USER_DATA *sptr_temp_user_data;
	IP_DEFAULT_DATA *sptr_temp_ip_default_data;
	APP_DEFAULT_DATA *sptr_temp_app_default_data;
	FILTER_DATA *sptr_temp_filter_data;

	USHORT num_of_users;
	USHORT num_of_groups;
	USHORT num_of_ipdefaults;
	USHORT num_of_appdefaults;
	USHORT num_of_domains;
	USHORT num_of_filters;

/* Added by Sreelu for Domain Name Filters */
	USHORT number_of_restricted_domain_address;
	USHORT max_number_of_restricted_domain_address;
	USHORT number_of_address_resolved;

	BYTE	start_resolving_dns_filters;
	USHORT  dns_resolver_state;
}USER_DATABASE_CLASS;



