/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"


#define MAX_FN 100 
#define MAX_FIELD_NAME 15 
#define CHAR_BUFFER_SIZE 10 

typedef struct {
char local_fn[MAX_FN];
char field_name[MAX_FIELD_NAME] ;
int nof_bytes_so_far ; 
unsigned char first_chars[CHAR_BUFFER_SIZE];
unsigned char cyclic_last_chars[CHAR_BUFFER_SIZE];
int next_to_add_to_last_chars ; 
int test_checksum ; 
int mod_3_byte ; /** values 1,2,3,1,2,3, etc ***/
} CheckSum_t ; 


void deallocate_checksum_results(void *results) 
{
free(results);
}


void *return_initialized_checksum_results(char *local_file_name,
					char *field_name) 
{
CheckSum_t *checksum; 

checksum = malloc(sizeof(CheckSum_t ) ) ; 

strncpy(checksum->local_fn, local_file_name, MAX_FN  ) ;
strncpy(checksum->field_name, field_name, MAX_FIELD_NAME ) ; 



checksum->nof_bytes_so_far = 0 ; 
checksum->test_checksum = 0 ; 
checksum->next_to_add_to_last_chars = 0 ; 
checksum->mod_3_byte = 1 ; 

return checksum ; 
}

void add_data_to_checksum_results(void *handle, 
				  void *data, 
				  int nof_bytes ) 
{
CheckSum_t *checksum; 
unsigned char *input_data ; 
int i ; 
unsigned char c ; 

checksum = (CheckSum_t *)handle; 
input_data = (unsigned char *)data ; 

for(i=0 ; i< nof_bytes ; i++ ) 
  {
    c = input_data[i] ;

    if (checksum->nof_bytes_so_far < CHAR_BUFFER_SIZE )
      {
	checksum->first_chars[checksum->nof_bytes_so_far] = c ; 
      }

    checksum->nof_bytes_so_far++ ; 


    checksum->cyclic_last_chars[checksum->next_to_add_to_last_chars] = c ;
    checksum->next_to_add_to_last_chars++;
    if (checksum->next_to_add_to_last_chars == CHAR_BUFFER_SIZE )
      {
	checksum->next_to_add_to_last_chars = 0 ; 
      }


    checksum->test_checksum += checksum->mod_3_byte*c ; 
    checksum->test_checksum %= 256 ;
    checksum->mod_3_byte++ ; 
    if (checksum->mod_3_byte == 4 )
      {
	checksum->mod_3_byte = 1 ;
      }


  }



}


void write_chars(char *output_string, 
		 char *input_string, 
		 int size)
{
int i ;
char tmp[10];

  sprintf(output_string, "%.*s", size , input_string );
  for(i=0 ; i < size ; i++ )
    {
      sprintf(tmp, " %x" , input_string[i]  ) ; 
      strcat(output_string, tmp ) ;
    }



}


void get_checksum_test_string(char *char_buffer,
			 void *handle )
{
CheckSum_t *checksum; 


char first_chars_string[200],last_chars_string[200] ; 
char tmp_last_chars[CHAR_BUFFER_SIZE] ; 

checksum = (CheckSum_t *)handle; 

memcpy(tmp_last_chars, 
       checksum->cyclic_last_chars + checksum->next_to_add_to_last_chars, 
       (size_t)(CHAR_BUFFER_SIZE - checksum->next_to_add_to_last_chars) ) ;

memcpy(tmp_last_chars + CHAR_BUFFER_SIZE -  
                          checksum->next_to_add_to_last_chars,
       checksum->cyclic_last_chars,
       (size_t)checksum->next_to_add_to_last_chars ) ;
       


write_chars(first_chars_string, checksum->first_chars, CHAR_BUFFER_SIZE ) ; 
write_chars(last_chars_string, tmp_last_chars, CHAR_BUFFER_SIZE ) ; 



sprintf(char_buffer, "local fn:%s<BR>\nFirld Name:%s<BR>\nFile Size:%d<BR>\nChecksum:%d<BR>\nFirst chars (hex) %s<BR>\nLast chars (hex)%s<BR>\n" ,
       checksum->local_fn ,
       checksum->field_name , 
       checksum->nof_bytes_so_far , 
       checksum->test_checksum , 
       first_chars_string,
       last_chars_string ) ;



}

