/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <fcntl.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "c:\rnrtr\applicat\webserv\prochttp\src\httpd.h"
#include "c:\rnrtr\applicat\webserv\prochttp\src\httperr.h"
#include "c:\rnrtr\applicat\webserv\htmlform\src\streamfl.h"
#include "c:\rnrtr\applicat\webserv\prochttp\src\util.h"
#include "streamw.h"

#include "c:\rnrtr\applicat\webserv\sysdep\src\sysfile.h"

typedef struct {
 void (* file_name_factory)(char *, char *, void *, UploadedFile_t*);
void *file_name_factory_param ; 
int current_fd  ; 
int file_is_open; 
} WriteStreamState_t ; 



void write_stream_to_file_operation(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{

/**** BLOCKING CODE !!! ****/

DataTransferStatus_t *transfer_status;

OutputStreamMessage_t *stream_message_vec ; 
int i_buf ; 
int i_message ; 
WriteStreamState_t *input_state ; 
UploadedFile_t *uploaded_file ; 
int nof_bytes_written ; 

input_state = (WriteStreamState_t *) operation_status->handle ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

	for(i_buf = 0 ; i_buf < transfer_status->nof_buffers ; i_buf++ )
	{
   	stream_message_vec  = 
      	(OutputStreamMessage_t  *) transfer_status->data_buffers[i_buf];
    	for(i_message = 0 ; i_message < transfer_status->buffer_sizes[i_buf] ; 
			i_message++ )
		{
			switch( stream_message_vec[i_message].message_type ) 
			{
				case OPEN_STREAM_MESSAGE: 
				{
					if (input_state->file_is_open)
				   {
						HTTP_REPORT_ERROR(" file open message with no file close ") ; 
					}
					uploaded_file = malloc (sizeof(UploadedFile_t ) ) ; 

				  	(*input_state->file_name_factory)
              		(stream_message_vec[i_message].file_name ,
	       			stream_message_vec[i_message].field_name ,
	       			input_state->file_name_factory_param,
	       			uploaded_file );
	  
	   			*stream_message_vec[i_message].stream_handle  = uploaded_file ; 

	  				input_state->current_fd = open 
#ifdef  TWO_PARAMETER_OPEN_FILE
               (uploaded_file->local_file_name,  O_WRONLY | O_CREAT );
#else
               (uploaded_file->local_file_name,  O_WRONLY | O_CREAT, 0777 );
#endif

	  				input_state->file_is_open = TRUE ; 
	  				if ( input_state->current_fd == -1 )
	    			{
	      			HTTP_REPORT_ERROR(" can not open file " ) ; 
	      			input_state->file_is_open = FALSE ; 
	    			}
				}
	  			break ; 
				case CLOSE_STREAM_MESSAGE:
				{
					if (!input_state->file_is_open)
	    			{
	      			HTTP_REPORT_ERROR(" trying to close uploaded file with no open "); 
	    			}
	  				close(  input_state->current_fd ) ; 
	  				input_state->file_is_open = FALSE ; 
	  				break ; 
	  			}
				case ADD_DATA_MESSAGE:
	  			{
	  				if (!input_state->file_is_open)
	    			{
	      			HTTP_REPORT_ERROR("trying to write to uploaded file with no open");
	    			}
	  				else
	    			{
	      			nof_bytes_written = 
							write(input_state->current_fd, 
		      				stream_message_vec[i_message].data  , 
		     					stream_message_vec[i_message].nof_bytes ) ; 
	      			if (nof_bytes_written != stream_message_vec[i_message].nof_bytes)
						{
		  					HTTP_REPORT_ERROR("write uploaded file failed ");
						}
	    			}
	  				break ; 
	  			}
				default: 
	  			{
	    			HTTP_REPORT_ERROR("wrong file upload message code") ; 
	    			break ; 
	  			}

			}
		}
	}
operation_status->status = END_OPERATION ; 
}





void   close_write_stream( OperationStatus_t *operation_status)
{

WriteStreamState_t *input_state ; 

input_state = (WriteStreamState_t *) operation_status->handle ; 

if (input_state->file_is_open)
  {
    HTTP_REPORT_ERROR(" write stream ended with no close file message ! ") ; 
    close(input_state->current_fd) ; 
  }

free(operation_status->handle) ; 
}



void InitWriteStreamToFiles(OperationStatus_t *operation_status,

/**			    StreamFileNameFactory_t file_name_factory,**/
 void (* file_name_factory)(char *, char *, void *, UploadedFile_t*),
			    void *file_name_factory_param)
{
WriteStreamState_t *input_state ; 



operation_status->do_operation = write_stream_to_file_operation ; 
operation_status->handle = input_state = malloc(sizeof( WriteStreamState_t)) ; 
input_state->file_is_open = FALSE ; 
input_state->file_name_factory = file_name_factory ; 
input_state->file_name_factory_param = file_name_factory_param ; 

operation_status->close_operation = close_write_stream ; 

}

