/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"
#include "..\..\sysdep\src\tcprw.h" 


typedef struct {
  Socket_t *socket ; 
  int buffer_number ; 
  int nof_bytes_written_so_far ; 
} NonBlockingOutputState_t ; 


void NonBlockingOutput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
int nof_bytes_written  ; 
int error ; 
DataTransferStatus_t *transfer_status; 
NonBlockingOutputState_t *output_state ; 
int client_closed_socket ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

output_state = ( NonBlockingOutputState_t *) operation_status->handle ; 

if (operation_status->status == START_OPERATION)
  {
    output_state->buffer_number =0 ; 
    output_state->nof_bytes_written_so_far = 0 ; 
  }



while (1) {

   write_data_to_socket(output_state->socket , 
	     (char *)transfer_status->data_buffers[output_state->buffer_number]
                            +output_state->nof_bytes_written_so_far , 
	     transfer_status->buffer_sizes[output_state->buffer_number] 
                             - output_state->nof_bytes_written_so_far , 
	     &nof_bytes_written, 
	     &client_closed_socket , 
	     &error ) ; 


 if ( (error == NO_ERROR) && (nof_bytes_written == 0 ) )
    {
      operation_status->status = IN_OPERATION ; 
      return ; 
    }


  
  if ( (error != 0 ) || client_closed_socket )
    {
      operation_status->status = END_OPERATION ; 
      transfer_status->end_of_processing = TRUE ; 
      transfer_status->socket_should_be_closed = TRUE ; 
      return ; 
    }

  output_state->nof_bytes_written_so_far += nof_bytes_written ; 
  if (output_state->nof_bytes_written_so_far == 
      transfer_status->buffer_sizes[output_state->buffer_number] )
    {
      output_state->buffer_number++ ; 
      output_state->nof_bytes_written_so_far = 0 ; 
      if (output_state->buffer_number == transfer_status->nof_buffers )
		{
		  operation_status->status = END_OPERATION ; 
	  	  return ; 
		}
    }
  

   }



}

void  FreeNonBlockingOutput( OperationStatus_t *operation_status)
{
free(operation_status->handle) ; 
}

void InitNonBlockingOutput(Request_t *request , 
			 OperationStatus_t *operation_status)
{
NonBlockingOutputState_t *output_state ; 



operation_status->do_operation = NonBlockingOutput ; 
operation_status->handle = output_state = 
              malloc(sizeof(NonBlockingOutputState_t)) ; 
output_state->socket =  &request->socket ; 
operation_status->close_operation = FreeNonBlockingOutput ; 
}


