/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"
#include "flowcont.h"
#include "apputil.h"

#include "strout.h"

typedef struct {
  void *buffer ; 
  int length ; 
} SimpleInputState_t ; 


void SimpleStringInput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
SimpleInputState_t *input_state  ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 
input_state = (SimpleInputState_t *) operation_status->handle ; 

transfer_status->nof_buffers = 1 ; 
transfer_status->data_buffers[0] = input_state->buffer ; 
transfer_status->buffer_sizes[0] = input_state->length ; 

operation_status->status = END_OPERATION ; 

}



void InitSimpleConstBufferInput(OperationStatus_t *operation_status, 
				char *buffer, int buffer_size )
/*** DOES NOT MAKE COPY OF THE STRING !!!! *****/
{
SimpleInputState_t *input_state ; 


operation_status->do_operation = SimpleStringInput ; 
operation_status->handle = input_state = malloc(sizeof(SimpleInputState_t) ) ; 
input_state->buffer = buffer ; 
input_state->length = buffer_size ; 
operation_status->close_operation =  GenericSimpleFreeState ; 
}
void InitSimpleConstStringInput(OperationStatus_t *operation_status, 
				char *string)
/*** DOES NOT MAKE COPY OF THE STRING !!!! *****/
{
InitSimpleConstBufferInput(operation_status, string, strlen(string) ) ; 
}


void   FreeCopiedString( OperationStatus_t *operation_status)
{
SimpleInputState_t *input_state ; 

input_state = (SimpleInputState_t *) operation_status->handle ; 

free(input_state->buffer) ; 

free(input_state) ; 
}


void InitCopiedBufferInput(OperationStatus_t *operation_status, 
				char *buffer, 
			   int buffer_size)
/***  MAKES COPY OF THE STRING *****/
{
SimpleInputState_t *input_state ; 


operation_status->do_operation = SimpleStringInput ; 
operation_status->handle = input_state = malloc(sizeof(SimpleInputState_t) ) ; 
input_state->length = buffer_size ; 


input_state->buffer =  malloc( input_state->length ) ; 

memcpy(input_state->buffer, buffer ,  (size_t)input_state->length  ) ; 
operation_status->close_operation =  FreeCopiedString ; 
}

void InitCopiedStringInput(OperationStatus_t *operation_status, 
				char *string)
/***  MAKES COPY OF THE STRING *****/
{
InitCopiedBufferInput(operation_status, string, strlen(string) ) ; 
}



#if 0 
void *InitReturnNotFoundHandle(Request_t *request,
                            char *error_message )
{

DataTransferStatus_t *data_transfer ; 


data_transfer = malloc(sizeof(DataTransferStatus_t) ) ; 

InitDataTransferStatus(data_transfer) ; 

data_transfer->nof_operations = 3 ; 

InitSimpleConstStringInput(&data_transfer->io_operations[0], error_message) ; 


InitNonBlockingOutput( request, &data_transfer->io_operations[1] ) ;


InitStopProcessingOperation( &data_transfer->io_operations[2] ) ;

data_transfer->end_of_processing = FALSE ; 
data_transfer->socket_should_be_closed = FALSE ; 

return data_transfer ; 
}


void InitReturnNotFound(Request_t *request)
{
request->header_info.status = NOT_FOUND ; 
request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
request->response_entity_function = DataTransfer ; 
request->response_entity_handle = InitReturnNotFoundHandle(request,
"<HEAD><TITLE>404 Not Found</TITLE></HEAD><BODY><H1>404 Not Found</H1>The requested URL was not found on this server.<P></BODY>"  ) ; 

}

#endif


void InitReturnErrorMessage(Request_t *request, 
			    HttpStatusType_t status, 
			    char *error_message, 
			    int error_message_should_be_copied)
{
DataTransferStatus_t *data_transfer ; 


request->header_info.status = status ; 
request->header_info.content_type = HTML_CONTENT_TYPE ; 
request->response_entity_function = OneIterationDataTransfer ; 

request->response_entity_handle = data_transfer =
      get_initialized_data_transfer() ; 

data_transfer->nof_operations = 2 ; 

if (!error_message_should_be_copied)
  {
    InitSimpleConstStringInput(&data_transfer->io_operations[0],
			   error_message) ;
  }
else
  {
    InitCopiedStringInput(&data_transfer->io_operations[0],
			   error_message) ;
  }
InitNonBlockingOutput( request, &data_transfer->io_operations[1] ) ;


request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 




}


void InitReturnUnauthorized(Request_t *request, 
			    char * challenge, 
			    char *error_message, 
			    int error_message_should_be_copied)
{
request->header_info.chalange =  challenge; 

InitReturnErrorMessage(request,  NOT_AUTHORIZED, error_message, 
		        error_message_should_be_copied);
}


void InitReturnForbidden(Request_t *request, 
			    char *error_message, 
			    int error_message_should_be_copied)
{

InitReturnErrorMessage(request,  FORBIDDEN , error_message, 
		        error_message_should_be_copied);
}

void InitReturnNotFound(Request_t *request, 
			    char *error_message, 
			    int error_message_should_be_copied)
{

InitReturnErrorMessage(request,  NOT_FOUND , error_message, 
		        error_message_should_be_copied);
}


void InitReturnUrlWasNotFound(Request_t *request)

{
	printf("404 in InitReturnUrlWasNotFound\n");
	InitReturnNotFound(request,
	  "<HEAD><TITLE>404 Not Found</TITLE></HEAD><BODY><H1>404 Not Found</H1>The requested URL was not found on this server.<P></BODY>" ,
		FALSE ) ; 


}





void CompiledBuffInput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 

CompiledBuffer_t *compiled_buf; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 
compiled_buf = (CompiledBuffer_t *) operation_status->handle ;


transfer_status->nof_buffers = 1 ; 
transfer_status->data_buffers[0] = compiled_buf->data_ptr; 
transfer_status->buffer_sizes[0] = compiled_buf->data_size ; 

operation_status->status = END_OPERATION ; 



}


void InitCompiledBufferInput(OperationStatus_t *operation_status, 
			     CompiledBuffer_t *compiled_buf )
{
operation_status->do_operation = CompiledBuffInput ; 
operation_status->handle = compiled_buf ; 
operation_status->close_operation = NULL ; 
}


void InitCompiledBuffRequest(Request_t *request , 
				 CompiledBuffer_t *compiled_buff)
{

DataTransferStatus_t *data_transfer ; 

int end_of_request_processing ; 

SetEntityDate(request, &compiled_buff->date_last_modified, 
	      &end_of_request_processing ) ;
if (end_of_request_processing)
  {
    return ; 
  }



request->header_info.status = STATUS_OK ; 
request->header_info.content_type = compiled_buff->content_type ; 
request->response_entity_function = OneIterationDataTransfer ; 

request->response_entity_handle = data_transfer =
      get_initialized_data_transfer() ; 

data_transfer->nof_operations = 2 ; 

InitCompiledBufferInput(&data_transfer->io_operations[0],
			   compiled_buff ) ;
InitNonBlockingOutput( request, &data_transfer->io_operations[1] ) ;

request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
}



void InitReturnBuffer(Request_t *request, 
		      char *buffer, 
		      int buffer_size, 
		      HttpContentType_t content_type , 
		      int buffer_should_be_copied )
{

DataTransferStatus_t *data_transfer ; 

request->header_info.status = STATUS_OK ; 
request->header_info.content_type =  content_type ; 
request->response_entity_function = OneIterationDataTransfer ; 

request->response_entity_handle = data_transfer =
      get_initialized_data_transfer() ; 

data_transfer->nof_operations = 2 ; 

if (buffer_should_be_copied)
  {
    InitCopiedBufferInput(&data_transfer->io_operations[0],
			  buffer, 
			  buffer_size) ; 
  }
else
  {
    InitSimpleConstBufferInput(&data_transfer->io_operations[0],
			  buffer, 
			  buffer_size) ; 


  }


InitNonBlockingOutput( request, &data_transfer->io_operations[1] ) ;

request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 





}






