/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/

#ifndef UPLOAD_H
#define UPLOAD_H


#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"

typedef void* (*OpenUploadFunction_t)
/**** returns stream handle ***/
              (void *form_handle,
	       char *local_file_name,
	       char *field_name, 
	       int *was_done /** used for non-blocking I/O ***/) ; 
	       

typedef void (*WriteDataToUploadFunction_t)
              (void *form_handle, 
	       void *file_handle, 
	       void *data, 
	       int nof_bytes, 
	       int *was_done /** used for non-blocking I/O ***/ );


typedef void (*CloseUploadFunction_t)
              (void *form_handle, 
	       void *file_handle, 
	       int *was_done /** used for non-blocking I/O ***/);
	       


typedef void (*CleanupUploadFunction_t)
              (void *form_handle);	       





void InitDumpUpload(OperationStatus_t *operation_status,
		    void *form_handle, 
		    OpenUploadFunction_t open_upload_function, 
		    WriteDataToUploadFunction_t write_data_to_upload,
		    CloseUploadFunction_t close_upload , 
		    CleanupUploadFunction_t cleanup_dump_upload);




#endif

