/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\htmlform\src\strfind.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\httpd.h"



void init_string_search( StringSearch_t *string_search, char *string, 
			int length)
{
NewCharOption_t tmp_options[MAX_NOF_CHAR_OPTIONS] ; 

int current_char_option ; 
char new_char ; 
int i_option ; 
int i_new_pos ; 
int i_old_pos ; 

int already_found ; 
int string_match_was_found ; 
int i_char_test; 


string_search->string_to_match = malloc( length ) ; 
strncpy(string_search->string_to_match, string, length ); 
string_search->string_length = length ; 


string_search->start_index_of_new_char_options = malloc(sizeof(int)*length) ; 
string_search->nof_new_char_options = malloc(sizeof(int)*length) ; 

current_char_option = 0 ; 



for(i_old_pos = 0 ; i_old_pos < length-1 ; i_old_pos++ )
  {
    string_search->start_index_of_new_char_options[i_old_pos] = 
      current_char_option; 
    string_search->nof_new_char_options[i_old_pos] = 0 ; 


    for(i_new_pos = i_old_pos ; i_new_pos > 0 ; i_new_pos-- )
      {
	string_match_was_found = TRUE ; 
	for(i_char_test = 0 ; i_char_test < i_new_pos-1 ; i_char_test++ )
	  {
	    if (string[i_char_test] != string[i_char_test + i_old_pos - 
					      i_new_pos + 1 ] )
	      {
		string_match_was_found = FALSE ; 
		break ; 
	      }
	  }
	
	if (string_match_was_found)
	  {
	    new_char =  string[i_new_pos-1] ;
	    if (string[i_old_pos] != new_char )
	      {
		already_found = FALSE ; 
		for(i_option = 0 ; 
		    i_option <  string_search->nof_new_char_options[i_old_pos];
		    i_option++ )
		  {
		    if (tmp_options[
			string_search->start_index_of_new_char_options[i_old_pos]
				   + i_option].new_char == new_char )
		      {
			already_found = TRUE ; 
			break ;
		      }
		  }
		if (!already_found)
		  {
		    tmp_options[current_char_option].new_char = new_char; 
		    tmp_options[current_char_option].new_position = 
		      i_new_pos; 
		    current_char_option++ ; 
		    string_search->nof_new_char_options[i_old_pos]++ ; 
		  }
	      }
	  }

      }
  }


string_search->new_char_option_vector  = 
  malloc(current_char_option*sizeof( NewCharOption_t ) ) ; 

memcpy(string_search->new_char_option_vector, tmp_options,
       (size_t)current_char_option*sizeof( NewCharOption_t )  ) ; 
}


void one_more_char(StringSearch_t *string_search, 
		   int *position, 
                /*** "position" is "how many chars were matched already ***/
		   char c , 
		   int *match_found )
{
int nof_options_to_check; 
NewCharOption_t *new_char_option_to_check; 
int i_option ; 

if ( string_search->string_to_match[*position] == c )
  {
    (*position)++;
    *match_found = (*position == string_search->string_length );
    if (*match_found) 
      {
	*position = 0 ; 
      }
    return ; 
  }

*match_found = FALSE ; 

if (*position == 0 ) 
  {
    *position = 0 ; 
    return ; 
  }


new_char_option_to_check = string_search->new_char_option_vector +
           string_search->start_index_of_new_char_options[*position ];
nof_options_to_check = string_search->nof_new_char_options[*position ];

for(i_option = 0 ; i_option < nof_options_to_check; 
    i_option++,new_char_option_to_check++)
  {
    if (c == new_char_option_to_check->new_char )
      {
	*position =  new_char_option_to_check->new_position ; 
	return ; 
      }
  }


*position = 0 ; 
*match_found = FALSE ; 

return ; 
}






void destroy_string_search( StringSearch_t *string_search)
{
free(string_search->string_to_match ) ; 
free(string_search->start_index_of_new_char_options) ; 
free(string_search->nof_new_char_options) ; 
free(string_search->new_char_option_vector ) ; 
}




