/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef STRFIND_H
#define STRFIND_H

#define MAX_STRING_SEARCH_SIZE 1024 
#define MAX_NOF_CHAR_OPTIONS 1024 

typedef struct {
char new_char ; 
int new_position ; 
/**** means that if the new char is "new_char" then position should change 
***** to new_position for examples, boundary string is AAABBBAAX, current 
***** string is   AAABBBAA, new char is A, then (A, 3 ) is on the list
****/
} NewCharOption_t ; 


typedef struct {
char *string_to_match ; 
int string_length ; 
NewCharOption_t *new_char_option_vector ; 
int *start_index_of_new_char_options ;
int *nof_new_char_options ; 
/*** the new char options if our positio index is POSITION  starts from 
**** new_char_option_vector[POITION] and there are 
**** nof_new_char_options[POSITION] such options 
***/
} StringSearch_t ;

void init_string_search( StringSearch_t *string_search, char *string, 
			int length);


void one_more_char(StringSearch_t *string_search, 
		   int *position, 
		   char c , 
		   int *match_found ) ; 


void destroy_string_search( StringSearch_t *string_search); 

#endif /** STRFIND_H ****/
