#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/


#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"


#include "\rtrware\store\boot.h"

#include "MAINDHCP.H"
#include "ADDDHCP.H"
#include "FMADHCP.H"
#include "BINDDHCP.H"
#include "FMBNDHCP.H"
#include "BINDLIST.H"
#include "FMBNDLST.H"
#include "EDITDHCP.H"
#include "FMEDHCP.H"
#include "ADEOPT.H"
#include "FMADEOPT.H"
#include "DHCPOPT.H"
#include "FMOPT.H"
#include "VEBDDHCP.H"
#include "enbdhcp.h"
#include "endhcpfm.h"
/*#include "FMVEDHCP.H"*/

#include "dhcp.h"
#include <incall.h>
#include <cfgmgr.h>


#if 0
#define WEB_DEBUG /* Used Only For Debug : REMOVE FOR RELEASE VERSION */
#endif

#define MAX_NUMBER_OF_LISTINGS_IN_A_PAGE 10

BYTE OPTION_NAME_STRING[] = "#____________________________________OPTIONNAME";
BYTE OPTION_TYPE_STRING[] = "#____________________________________OPTIONTYPE";
BYTE OPTION_VALUE_TEMPLATE[] = "#_________#_________#_________#_________";
BYTE OPTION_POSITION_TEMPLATE[] = "#__#";
BYTE MAC_ADDRESS_LENGTH_TEMPLATE[] = "#__#";
BYTE IP_ADDRESS_TEMPLATE[] = "#___TEXT___#___";
BYTE HTML_COMMENT_STRING[] = "<!--";
BYTE HTML_CLOSE_COMMENT_STRING[] = "-->";
BYTE MAC_ADDRESS_TEMPLATE[] = "#_________#_________#";
BYTE BIND_BUTTON_TEMPLATE[] = "BINDING_ACTION";

BYTE BIND_IP_ADDRESS_TEMPLATE[] = "#_____IPADDRESS";
BYTE BIND_MAC_ADDRESS_TEMPLATE[] = "#_________MACADDRESS";
BYTE BIND_MAC_ADDRESS_LENGTH_TEMPLATE[] = "#_LEN";

BYTE LOWER_IP_ADDRESS_TEMPLATE[]     = "#____IPFROMADDR";
BYTE HIGHER_IP_ADDRESS_TEMPLATE[]    = "#______IPTOADDR";
BYTE EX_LOWER_IP_ADDRESS_TEMPLATE[]  = "#__EXCLFROMADDR";
BYTE EX_HIGHER_IP_ADDRESS_TEMPLATE[] = "#____EXCLTOADDR";

BYTE LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE[] = "#____IPADDRFROM";
BYTE HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE[] = "#______IPADDRTO";
BYTE EX_LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE[] = "#__EXCLADDRFROM";
BYTE EX_HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE[] = "#____EXCLADDRTO";

/* Extern Declerations... */
extern BYTE check_whether_user_is_authenticated_or_not(Request_t* request);
extern int  search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE is_valid_string_to_read_data(BYTE* buffer);
extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern void display_framed_or_standard_main_page(Request_t* request) ;
/* ...Extern Declerations */

extern BYTE user_viewing_with_frames ;



/* Local Prototypes ... */
void     display_dhcp_menu_page(Request_t* request);
void     display_page_to_add_new_range(Request_t* request);
void     add_the_given_range(Request_t* request);
void     edit_delete_bind_range(Request_t* request);
void     edit_range(Request_t* request, DHCP_EDIT_RANGE_form_output_type* new_range_values);
void     delete_range(Request_t* request);
USHORT   current_tag_number(USHORT new_tag_number, BYTE save);
void     select_option_type_from_the_list(Request_t* request);
USHORT   convert_index_to_corr_option_type(USHORT index);
USHORT   convert_option_type_to_index(USHORT option);
USHORT   current_option_type(USHORT new_option, BYTE save);
void     display_option_info(Request_t* request, USHORT option);
void     add_delete_edit_option(Request_t* request);
void     add_option(Request_t* request, USHORT option, DHCP_ADD_EDIT_DELETE_OPTION_form_output_type* option_to_insert);
void     edit_option(Request_t* request, USHORT option, DHCP_ADD_EDIT_DELETE_OPTION_form_output_type* option_action);
void     delete_option(Request_t* request, USHORT option);
void     display_detailed_range_for_the_link(Request_t* request, USHORT link_number_in_page);
void     display_tag_contents_of_link_1(Request_t* request);
void     display_tag_contents_of_link_2(Request_t* request);
void     display_tag_contents_of_link_3(Request_t* request);
void     display_tag_contents_of_link_4(Request_t* request);
void     display_tag_contents_of_link_5(Request_t* request);
void     display_tag_contents_of_link_6(Request_t* request);
void     display_tag_contents_of_link_7(Request_t* request);
void     display_tag_contents_of_link_8(Request_t* request);
void     display_tag_contents_of_link_9(Request_t* request);
void     display_tag_contents_of_link_10(Request_t* request);
USHORT   start_from(USHORT new_value, BYTE save);
void     display_ranges(Request_t* request);
void     display_next_10_ranges(Request_t* request);
void     add_or_delete_binding(Request_t* request);
void     add_binding(Request_t* request);
void     delete_binding(Request_t* request);
void     display_detailed_info_of_bind(Request_t* request, BYTE link_number);
USHORT   current_bind_number(USHORT new_value, BYTE save);
void     display_bind_info_of_link_1(Request_t* request);
void     display_bind_info_of_link_2(Request_t* request);
void     display_bind_info_of_link_3(Request_t* request);
void     display_bind_info_of_link_4(Request_t* request);
void     display_bind_info_of_link_5(Request_t* request);
void     display_bind_info_of_link_6(Request_t* request);
void     display_bind_info_of_link_7(Request_t* request);
void     display_bind_info_of_link_8(Request_t* request);
void     display_bind_info_of_link_9(Request_t* request);
void     display_bind_info_of_link_10(Request_t* request);
void     do_bind_operations_for_the_range(Request_t* request);
void     display_next_10_binding(Request_t* request);
void     dispaly_add_binding_page(Request_t* request);
void     display_options_list(Request_t* request);
USHORT   start_bind_listing_from(USHORT new_value, BYTE save);
/* ... Local Prototypes */


/* Globals in this file ... */
BYTE number_of_bind_lists_displayed = 0;
BYTE number_of_listings_displayed = 0;
/* ... Globals in this file */



void display_dhcp_menu_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   InitReturnBuffer(request, DHCP_MENU_data_ptr, strlen(DHCP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_page_to_add_new_range(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   InitReturnBuffer(request, DHCP_ADD_RANGE_data_ptr, strlen(DHCP_ADD_RANGE_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_page_to_enable_dhcp(Request_t* request)
{
   BYTE* buffer, value[10] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	buffer = (BYTE*)malloc(strlen(DHCP_ENABLE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display DHCP Enable Page\n");
/* 		display_framed_or_standard_main_page(request); */
      display_framed_or_standard_main_page(request) ;
		return ;
	} 	
	strcpy(buffer, DHCP_ENABLE_data_ptr) ;
	get_parameter_by_name (CM_DHCP_SECTION, "DHCP Server", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)value, 10); 

   if (strcmp(value, "enabled") == 0)
	  search_and_replace("#__CBOX", "checked", buffer, TRUE, 0) ;
   else
     search_and_replace ("#__CBOX", "       ", buffer, TRUE, 0) ;


   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
}

void add_the_given_range(Request_t* request)
{
   DHCP_ADD_RANGE_form_output_type* range_to_add;
   CM_STRUCT_DHCP_RANGE new_range_info;
   enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE return_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   range_to_add = (DHCP_ADD_RANGE_form_output_type*)form_data_of_request(request);
   
   if (range_to_add == NULL)
   {
#ifdef WEB_DEBUG
      printf("Nothing to add for DHCP RANGE\n");
#endif
      return;
   }
   
   /* Fill the values and send them to configuration */
   if( is_an_ip_address(range_to_add->ip_address_from) )
     strcpy(new_range_info.ip_address_lower, range_to_add->ip_address_from);
   if( is_an_ip_address(range_to_add->ip_address_to) )
     strcpy(new_range_info.ip_address_higher, range_to_add->ip_address_to);
   if( is_an_ip_address_mask(range_to_add->ip_address_from,range_to_add->ip_address_mask) )
     strcpy(new_range_info.net_mask, range_to_add->ip_address_mask);
   if( is_an_ip_address(range_to_add->exclude_addresses_from) )
     strcpy(new_range_info.exclude_ip_address_lower, range_to_add->exclude_addresses_from);
   if(is_an_ip_address(range_to_add->exclude_addresses_to))
     strcpy(new_range_info.exclude_ip_address_higher, range_to_add->exclude_addresses_to);

   /* Try to add */
   return_value = cm_insert_dhcp_address_range(&new_range_info);

   /* Verify the result */
   switch(return_value)
   {
      case CM_DHCP_INSERTION_SUCCESS:
      printf("WEB:NEW RANGE Inserted Successfully\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS:
      printf("WEB:Invalid Lower IP Address, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS:
      printf("WEB:Invalid Higher IP Address, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_SUBNET_MASK:
      printf("WEB:Invalid Subnet Mask, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_RANGE:
      printf("WEB:Invalid Range , failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS_EXCLUDE: 
      printf("WEB:Invalid Exclude Lower IP Address, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS_EXCLUDE:
      printf("WEB:Invalid Exclude Higher IP Address, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_EXCLUSION:
      printf("WEB:Invalid Exclusion, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_RANGE_DUPLICATION:
      printf("WEB:This Range already exists, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_OVERLAPING_WITH_OTHER_RANGE_EXCLUSION:
      printf("WEB:This Range overlaps with other Range, failed to insert NEW RANGE\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INSUFFICIENT_MEMORY:
      printf("WEB:Insufficient Memory, failed to insert NEW RANGE\n");
      break;
      default:
      printf("WEB:NEW RANGE Insertion failed due to unknown error\n");
      break;
   }
   display_dhcp_menu_page(request);
}
void add_from_enable_dhcp_page(Request_t* request)
{
   DHCP_ENABLE_form_output_type* range_to_add;
   BYTE enabled_value[20], disabled_value[20] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   range_to_add = (DHCP_ENABLE_form_output_type*)form_data_of_request(request);
   
   if (range_to_add == NULL)
   {
#ifdef WEB_DEBUG
      printf("Nothing to add for DHCP Enable\n");
#endif
      return;
   }
   strcpy (enabled_value, "enabled") ;
   strcpy (disabled_value, "disabled") ;
   if (range_to_add->dhcp_server_enable)
     set_parameter_by_name (CM_DHCP_SECTION, "DHCP Server", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&enabled_value) ;
   else
     set_parameter_by_name (CM_DHCP_SECTION, "DHCP Server", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&disabled_value) ;
   display_dhcp_menu_page(request);
}
void edit_delete_bind_range(Request_t* request)
{
   DHCP_EDIT_RANGE_form_output_type* range_action;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   range_action = (DHCP_EDIT_RANGE_form_output_type*)form_data_of_request(request);

#ifdef WEB_DEBUG
   if (range_action == NULL)
   {
      printf("WEB: Nothing to edit range\n");
      display_dhcp_menu_page(request);
      return;   
   }
#endif

   if (!strcmpi(range_action->add_options, "Options"))
   {
      display_options_list(request);
   }
   else
   if (!strcmpi(range_action->bind_range, "Bind Range"))
   {
      do_bind_operations_for_the_range(request);
   }
   else
   if (!strcmpi(range_action->edit_range, "Edit Range"))
   {
      edit_range(request, range_action);
   }
   else
   if (!strcmpi(range_action->delete_range, "Delete Range"))
   {
      delete_range(request);
   }
}


void edit_range(Request_t* request, DHCP_EDIT_RANGE_form_output_type* new_range_values)
{
   CM_STRUCT_DHCP_RANGE new_range_info, old_range_info;
   enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE return_value;
   USHORT tag_number;

   tag_number = current_tag_number(0, FALSE);
   cm_get_dhcp_address_range(tag_number, &old_range_info);
   
   /* Fill the values and send them to configuration */
   strcpy(new_range_info.ip_address_lower, new_range_values->ip_address_from);
   strcpy(new_range_info.ip_address_higher, new_range_values->ip_address_to);
   strcpy(new_range_info.net_mask, new_range_values->ip_address_mask);
   strcpy(new_range_info.exclude_ip_address_lower, new_range_values->exclude_addresses_from);
   strcpy(new_range_info.exclude_ip_address_higher, new_range_values->exclude_addresses_to);

   /* Try to change */
   return_value = cm_edit_dhcp_address_range(&old_range_info, &new_range_info);

   /* Verify the result */
   switch(return_value)
   {
      case CM_DHCP_INSERTION_SUCCESS:
      printf("WEB:Range Changed Successfully\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS:
      printf("WEB:Invalid Lower IP Address, failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS:
      printf("WEB:Invalid Higher IP Address, failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_SUBNET_MASK:
      printf("WEB:Invalid Subnet Mask, failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_RANGE:
      printf("WEB:Invalid Range , failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS_EXCLUDE: 
      printf("WEB:Invalid Exclude Lower IP Address, failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS_EXCLUDE:
      printf("WEB:Invalid Exclude Higher IP Address, failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INVALID_EXCLUSION:
      printf("WEB:Invalid Exclusion , failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_RANGE_DUPLICATION:
      printf("WEB:Modified range already present, failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_OVERLAPING_WITH_OTHER_RANGE_EXCLUSION:
      printf("WEB:Range Overlaps with other Range, failed to modify range\n");
      break;
      case CM_DHCP_INSERTION_FAILED_INSUFFICIENT_MEMORY:
      printf("WEB:Insufficient Memory, failed to modify range\n");
      break;
      case CM_DHCP_EDITING_FAILED_IP_IS_BOUND_TO_MAC_ADDRESS:
      printf("WEB:Old IP Address is bound to MAC Address, failed to modify range\n");
      break;
      case CM_DHCP_EDITING_FAILED_TO_GET_OLD_RANGE:
      printf("WEB:Failed to get range to modify\n");
      break;
      case CM_DHCP_EDITING_FAILED_TO_CHANGE_DEFAULT:
      printf("WEB:Default Range can not be modified\n");
      break;
      default:
      printf("WEB:Unknown Error while editing range\n");
      break;
   }
   display_dhcp_menu_page(request);
}

void delete_range(Request_t* request)
{
   USHORT tag_number;
   enum CM_DHCP_RANGE_DELETION_RETURN_TYPE return_value;

   tag_number = current_tag_number(0, FALSE);
   return_value = cm_delete_dhcp_address_range_by_tag_number(tag_number);

   switch(return_value)
   {
      case CM_DHCP_DELETION_SUCCESS:
      printf("WEB:Specified Range Deleted Successfully\n");
      break;
      case CM_DHCP_DELETION_RANGE_NOT_FOUND:
      printf("WEB:Range not found, failed to delete specified range\n");
      break;
      case CM_DHCP_DELETION_FAILED_TRYING_TO_DELETE_DEFAULT:
      printf("WEB:Default Range can not be deleted\n");
      break;
      default:
      printf("WEB:Unknown Error while deleting specified range\n");
      break;
   }
   display_dhcp_menu_page(request);
}

USHORT current_tag_number(USHORT new_tag_number, BYTE save)
{
   static USHORT value = 0;

   if (save)
      value = new_tag_number;
   else
      return value;
}

/* Operating on options */

void select_option_type_from_the_list(Request_t* request)
{
   DHCP_OPTION_LIST_form_output_type* selected_option;
   USHORT option_type;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   selected_option = (DHCP_OPTION_LIST_form_output_type*)form_data_of_request(request);

#ifdef _WEB_DEBUG
   if (selected_option == NULL)
   {
      printf("Nothing select from Option Type List\n");
      return;
   }
#endif
   option_type = convert_index_to_corr_option_type(selected_option->options);
   current_option_type(option_type, TRUE);
   display_option_info(request, option_type);
}

USHORT convert_index_to_corr_option_type(USHORT index)
{
   return(lib_of_options_and_corr_strings[index].option);
}

USHORT convert_option_type_to_index(USHORT option)
{
   USHORT index = 0;

   while (lib_of_options_and_corr_strings[index].option != 0XFFFF)
   {  
      if (lib_of_options_and_corr_strings[index].option == option)
         return index;

      index++;
   }
   return 0; /* If unknown then take Zero as Default */
}

USHORT current_option_type(USHORT new_option, BYTE save)
{
   static USHORT option_type = 0;

   if (save)
      option_type = new_option;
   else
      return option_type;
}

void display_option_info(Request_t* request, USHORT option)
{
   BYTE* buffer, temp_buffer[20];
   USHORT index, search_to_start_at = 0, tag_number;
   CM_STRUCT_DHCP_OPTION option_info;

   tag_number = current_tag_number(0, FALSE);

   buffer = (BYTE*)malloc(strlen(DHCP_ADD_EDIT_DELETE_OPTION_data_ptr));

   if (buffer == NULL)
   {
      printf("WEB:Insufficient memory to display option information...\n");
      display_dhcp_menu_page(request);
      return;
   }

   strcpy(buffer, DHCP_ADD_EDIT_DELETE_OPTION_data_ptr);

   index = convert_option_type_to_index(option);

   strcpy(buffer, DHCP_ADD_EDIT_DELETE_OPTION_data_ptr);
   search_to_start_at = search_and_replace(OPTION_NAME_STRING, lib_of_options_and_corr_strings[index].option_name, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(OPTION_TYPE_STRING, lib_of_options_and_corr_strings[index].option_value_type, buffer, TRUE, search_to_start_at);

   if (cm_get_dhcp_range_option_by_option(tag_number, option, &option_info))
   {
      search_to_start_at = search_and_replace(OPTION_VALUE_TEMPLATE, option_info.option_value, buffer, TRUE, search_to_start_at);
      sprintf(temp_buffer, "%d\0", option_info.position);
      search_to_start_at = search_and_replace(OPTION_POSITION_TEMPLATE, temp_buffer, buffer, TRUE, search_to_start_at);

      /* Remove ADD Button  PENDING */
   }
   else
   {
      search_to_start_at = search_and_replace(OPTION_VALUE_TEMPLATE, "", buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(OPTION_POSITION_TEMPLATE, "", buffer, TRUE, search_to_start_at);

      /* Remove Edit and Delete Button PENDING */
      
   }
   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

void add_delete_edit_option(Request_t* request)
{
   DHCP_ADD_EDIT_DELETE_OPTION_form_output_type* option_action;
   USHORT option;

   option = current_option_type(0, FALSE);

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   option_action = (DHCP_ADD_EDIT_DELETE_OPTION_form_output_type*)form_data_of_request(request);

#ifdef WEB_DEBUG
   if (option_action == NULL)
   {
      printf("Nothing to do in OPTION ACTION\n");
      return;
   }
#endif

   if (!strcmpi(option_action->add, "Add Option"))
   {
      add_option(request, option, option_action);
      return;
   }
   else
   if (!strcmpi(option_action->edit, "Edit Option"))
   {
      edit_option(request, option, option_action);
      return;
   }
   else
   if (!strcmpi(option_action->delete, "Delete Option"))
   {
      delete_option(request, option);
      return;
   }
#ifdef WEB_DEBUG
   printf("WEB:UNKNOWN Value received from Browser\n");
#endif
}

void add_option(Request_t* request, USHORT option, DHCP_ADD_EDIT_DELETE_OPTION_form_output_type* option_to_insert)
{
   enum CM_DHCP_INSERT_OPTION_RETURN_TYPE return_value;
   CM_STRUCT_DHCP_OPTION option_info;
   USHORT tag_number;

   tag_number = current_tag_number(0, FALSE);
   option_info.option = option;
   strcpy(option_info.option_value, option_to_insert->option_value);
   option_info.position = 1 /*atoi(option_to_insert->option_position)*/;

   return_value = cm_insert_dhcp_range_option(tag_number, &option_info);
   switch(return_value)
   {
      case CM_DHCP_INSERTING_OPTION_SUCCESS:
      printf("WEB:Given Option inserted successfully\n");
      break;
      case CM_DHCP_INSERTING_OPTION_FAILED_INVALID_DATA:
      printf("WEB:Invalid data, failed to insert Option\n");
      break;
      case CM_DHCP_INSERTING_OPTION_FAILED_DUPLICATE_ENTRY:
      printf("WEB:For this option there is a data already, failed to insert Option\n");
      break;
      case CM_DHCP_EDITING_OPTION_FAILED_INSUFFICIENT_MEMORY:
      printf("WEB:Insufficent Memory, failed to insert Option\n");
      break;
      default:
      printf("WEB:Unknown Error while inserting option\n");
      break;
   };

   display_dhcp_menu_page(request);
}


void edit_option(Request_t* request, USHORT option, DHCP_ADD_EDIT_DELETE_OPTION_form_output_type* modified_option)
{
   enum CM_DHCP_INSERT_OPTION_RETURN_TYPE return_value;
   CM_STRUCT_DHCP_OPTION option_info, old_option_info;
   USHORT tag_number;

   tag_number = (USHORT) current_tag_number(0, FALSE);
   if (cm_get_dhcp_range_option_by_option(tag_number, option, &old_option_info) == FALSE)
   {
      printf("WEB:Failed to get old option to modify, returning to DHCP Menu...\n");
      display_dhcp_menu_page(request);
      return;
   }

   option_info.option = option;
   strcpy(option_info.option_value, modified_option->option_value);
   option_info.position = 1 /*atoi(option_to_insert->option_position)*/;

   return_value = cm_edit_dhcp_range_option(tag_number, &old_option_info, &option_info);
   switch(return_value)
   {
      case CM_DHCP_INSERTING_OPTION_SUCCESS:
      printf("WEB:Option modified successfully\n");
      break;
      case CM_DHCP_INSERTING_OPTION_FAILED_INVALID_DATA:
      printf("WEB:Invalid data, failed to modify option\n");
      break;
#if 0
      case CM_DHCP_INSERTING_OPTION_FAILED_DUPLICATE_ENTRY:
      printf("WEB:Already \n");
      break;
#endif
      case CM_DHCP_EDITING_OPTION_FAILED_INSUFFICIENT_MEMORY:
      printf("WEB:Insufficient Memory, failed to change option\n");
      break;
      default:
      printf("WEB:Unknown Error, while changing option\n");
      break;
   };

   display_dhcp_menu_page(request);
}


void delete_option(Request_t* request, USHORT option)
{
   enum CM_DHCP_DELETE_OPTION_RETURN_TYPE return_value;
   CM_STRUCT_DHCP_OPTION old_option_info;
   USHORT tag_number;

   tag_number = current_tag_number(0, FALSE);
   if (cm_get_dhcp_range_option_by_option(tag_number, option, &old_option_info) == FALSE)
   {
      printf("WEB:Option to be deleted not found...\n");
      display_dhcp_menu_page(request);
      return;
   }

   return_value = cm_delete_dhcp_range_option(tag_number, &old_option_info);
   switch(return_value)
   {
      case CM_DHCP_DELETING_OPTION_SUCCESS:
      printf("WEB:Specified option deleted successfully\n");
      break;
      case CM_DHCP_DELETING_OPTION_FAILED_OPTION_NOT_FOUND:
      printf("WEB:Failed to delete specified option\n");
      break;
      case CM_DHCP_DELETING_OPTION_FAILED_CANNOT_DELETE:
      printf("WEB:Can not delete this option\n");
      break;
      default:
      break;
      printf("WEB:Unknown Error, while deleting\n");
   };
   display_dhcp_menu_page(request);
}


void display_detailed_range_for_the_link(Request_t* request, USHORT link_number_in_page)
{
   CM_STRUCT_DHCP_RANGE range_info;
   USHORT tag_selected = (number_of_listings_displayed-1) * MAX_NUMBER_OF_LISTINGS_IN_A_PAGE + link_number_in_page - 1; /* Minus 1 is to make it 0 relative */
   BYTE* buffer;
   USHORT search_to_start_at = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;


   buffer = (BYTE*)malloc(strlen(DHCP_EDIT_RANGE_data_ptr));
   if (buffer == NULL)
   {
      printf("WEB:Not Enough Memory to display range for editing...\n");
      display_dhcp_menu_page(request);
      return;   
   }

   strcpy(buffer, DHCP_EDIT_RANGE_data_ptr);
   current_tag_number(tag_selected, TRUE);
   if (cm_get_dhcp_address_range(tag_selected, &range_info) == FALSE)
   {
      printf("WEB:Failed to get information on selected link...\n");
      display_dhcp_menu_page(request);
      free(buffer);
      return;
   }
   
   search_to_start_at = search_and_replace(IP_ADDRESS_TEMPLATE, range_info.ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(IP_ADDRESS_TEMPLATE, range_info.ip_address_higher, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(IP_ADDRESS_TEMPLATE, range_info.net_mask, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(IP_ADDRESS_TEMPLATE, range_info.exclude_ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(IP_ADDRESS_TEMPLATE, range_info.exclude_ip_address_higher, buffer, TRUE, search_to_start_at);

   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

void display_tag_contents_of_link_1(Request_t* request)
{
   display_detailed_range_for_the_link(request, 1);
}

void display_tag_contents_of_link_2(Request_t* request)
{
   display_detailed_range_for_the_link(request, 2);
}


void display_tag_contents_of_link_3(Request_t* request)
{
   display_detailed_range_for_the_link(request, 3);
}


void display_tag_contents_of_link_4(Request_t* request)
{
   display_detailed_range_for_the_link(request, 4);
}


void display_tag_contents_of_link_5(Request_t* request)
{
   display_detailed_range_for_the_link(request, 5);
}


void display_tag_contents_of_link_6(Request_t* request)
{
   display_detailed_range_for_the_link(request, 6);
}


void display_tag_contents_of_link_7(Request_t* request)
{
   display_detailed_range_for_the_link(request, 7);
}


void display_tag_contents_of_link_8(Request_t* request)
{
   display_detailed_range_for_the_link(request, 8);
}


void display_tag_contents_of_link_9(Request_t* request)
{
   display_detailed_range_for_the_link(request, 9);
}


void display_tag_contents_of_link_10(Request_t* request)
{
   display_detailed_range_for_the_link(request, 10);
}

USHORT start_from(USHORT new_value, BYTE save)
{
   static USHORT value = 0;

   if (save)
      value = new_value;
   else
      return value;
}

void display_ranges(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   number_of_listings_displayed = 0;

   if (cfgmgr_class.total_number_of_tags == 0)
   {
      display_dhcp_menu_page(request);
      return;
   }
   start_from(0, TRUE);
   display_next_10_ranges(request);
}

void display_next_10_ranges(Request_t* request)
{
   USHORT start_from_the_tag;
   CM_STRUCT_DHCP_RANGE range_info;
   USHORT search_to_start_at = 0, index = 0;
   BYTE* buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   buffer =  (BYTE*)malloc(strlen(DHCP_VED_RANGE_data_ptr));

   if (buffer == NULL)
   {
      printf("WEB: Insufficient Memory to display Range List...\n");
      display_dhcp_menu_page(request);
      return;     
   }
   
   strcpy(buffer, DHCP_VED_RANGE_data_ptr);

   start_from_the_tag = start_from(0, FALSE);

   if (start_from_the_tag > cfgmgr_class.total_number_of_tags)
   {
#ifdef WEB_DEBUG
      printf("WEB: DANGER something wrong in keeping track of tags\n");
#endif
      free(buffer);
      display_dhcp_menu_page(request);
      return;     
   }

   for( index = 0 ; index < MAX_NUMBER_OF_LISTINGS_IN_A_PAGE ; ++index)
   {
      if (start_from_the_tag+index+1 > cfgmgr_class.total_number_of_tags)
      {
         search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "", buffer, FALSE, search_to_start_at);
         continue;
      }

      if (cm_get_dhcp_address_range(start_from_the_tag+index, &range_info) == FALSE)
      {
#ifdef WEB_DEBUG
         printf("WEB: DANGER Failed to get info for the tag %d\n", start_from_the_tag);
#endif
         free(buffer);
         display_dhcp_menu_page(request);
         return;
      }
      search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "", buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(LOWER_IP_ADDRESS_TEMPLATE, range_info.ip_address_lower, buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(HIGHER_IP_ADDRESS_TEMPLATE, range_info.ip_address_higher, buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(EX_LOWER_IP_ADDRESS_TEMPLATE, range_info.exclude_ip_address_lower, buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(EX_HIGHER_IP_ADDRESS_TEMPLATE, range_info.exclude_ip_address_higher, buffer, TRUE, search_to_start_at);
   }

    search_to_start_at = search_and_replace(HTML_CLOSE_COMMENT_STRING, "", buffer, TRUE, search_to_start_at);

   /* Are there any more entries */
   if (start_from_the_tag + MAX_NUMBER_OF_LISTINGS_IN_A_PAGE < cfgmgr_class.total_number_of_tags)
   {
      /* There are more entries */
      search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "", buffer, FALSE, search_to_start_at);
      search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "<A", buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace("--> ", "</A>", buffer, TRUE, search_to_start_at);
   }

   number_of_listings_displayed ++;
   start_from_the_tag += MAX_NUMBER_OF_LISTINGS_IN_A_PAGE;
   start_from(start_from_the_tag, TRUE);
   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}



/* Added by CHRIS ... */

void add_remove_bind(Request_t* request)
{
   DHCP_ADD_DELETE_BINDING_form_output_type*	bind_action;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   bind_action = (DHCP_ADD_DELETE_BINDING_form_output_type*)form_data_of_request(request);
#ifdef WEB_DEBUG
   if (bind_action == NULL)
   {
      printf("Nothing to do in binding\n");
      display_dhcp_menu_page(request);
      return;
   }

#endif

   if (!strcmpi(bind_action->binding_action, "AddBinding")) 
   {
      add_binding(request);
   }
   else 
   if (!strcmpi(bind_action->binding_action, "DeleteBinding")) 
   {
      delete_binding(request);
   }
}


void add_binding(Request_t* request)
{
	DHCP_ADD_DELETE_BINDING_form_output_type*	binding_info;
	CM_STRUCT_DHCP_BIND								binding_to_add;
   USHORT                                    tag_number;
   enum CM_DHCP_BIND_RETURN_TYPE					return_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	binding_info = (DHCP_ADD_DELETE_BINDING_form_output_type*)form_data_of_request(request);

#ifdef WEB_DEBUG
   if (binding_info == NULL) {
      printf("Nothing to do in ADD_BINDING\n");
      return;
   }
#endif

	if (!is_valid_string_to_read_data(binding_info->mac_address_length)) 
   {
		printf("WEB:Invalid MAC address length...\n");
   	display_dhcp_menu_page(request);
		return;
	}

	binding_to_add.mac_address_length = (BYTE) atoi(binding_info->mac_address_length);

	strcpy(binding_to_add.ip_address_to_bind, binding_info->ip_address);
	strcpy(binding_to_add.mac_address_to_bind, binding_info->mac_address);

   tag_number = current_tag_number(0, FALSE);
	return_value = cm_bind_mac_and_ip_address(tag_number, &binding_to_add);

	switch (return_value) {
   	case CM_DHCP_BINDING_SUCCESS:
      printf("WEB:Binding done Successfully\n");
			break;
   	case CM_DHCP_BINDING_FAILED_DUPLICATED_IP_ADDRESS:
      printf("WEB:IP Address already bound, failed to do specified binding\n");
			break;
   	case CM_DHCP_BINDING_FAILED_DUPLICATED_MAC_ADDRESS:
      printf("WEB:MAC Address already bound, failed to do specified binding\n");
			break;
   	case CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS_LENGTH:
      printf("WEB:Invalid Mac Address, failed to do specified binding\n");
			break;
   	case CM_DHCP_BINDING_FAILED_MAC_ADDRESS_GREATER_THAN_LENGTH:
      printf("WEB:MAC Address and length incompatible, failed to do specified binding\n");
			break;
   	case CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS:
      printf("WEB:Invalid Mac Address, failed to do specified binding\n");
			break;
   	case CM_DHCP_BINDING_FAILED_INVALID_IP_ADDRESS:
      printf("WEB:Invalid IP Address, failed to do specified binding\n");
			break;
   	case CM_DHCP_BINDING_FAILED_IP_ADDRESS_OUT_OF_RANGE:
      printf("WEB:IP Address Out Of Range, failed to do specified binding\n");
			break;
   	case CM_DHCP_BINDING_FAILED_INSUFFICIENT_MEMORY:
      printf("WEB:Insufficient Memory, failed to do specified binding\n");
			break;
      case CM_DHCP_BINDING_FAILED_CAN_NOT_BIND_DEFAULT_RANGE:
      printf("WEB:Bindings can not be done for Default Range\n");
		default:
      printf("WEB: Unknown Error, while binding\n");
			break;
	}

	display_dhcp_menu_page(request);
}


void delete_binding(Request_t* request)
{
	CM_STRUCT_DHCP_BIND								binding_to_delete;
   USHORT                                    tag_number, bind_number;
   enum CM_DHCP_UNBIND_RETURN_TYPE				return_value;
#if 0
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	binding_info = (DHCP_ADD_DELETE_BINDING_form_output_type*)form_data_of_request(request);

#ifdef WEB_DEBUG
   if (binding_info == NULL) 
   {
      printf("Nothing to do in delete BINDING\n");
      return;
   }
#endif

	if (!is_valid_string_to_read_data(binding_info->mac_address_length)) 
   {
   	display_dhcp_menu_page(request);
		return;
	}

	binding_to_delete.mac_address_length = (BYTE) atoi(binding_info->mac_address_length);

	strcpy(binding_to_delete.ip_address_to_bind, binding_info->ip_address);
	strcpy(binding_to_delete.mac_address_to_bind, binding_info->mac_address);
#endif

   /* Get the current tag Number */
   tag_number = current_tag_number(0, FALSE);

   /* Get the bind information of selected link */
   bind_number = current_bind_number(0, FALSE);
   if (cm_get_dhcp_binding(tag_number, bind_number, &binding_to_delete) == FALSE)
   {
   	display_dhcp_menu_page(request);
		return;
   }

	return_value = cm_unbind_mac_and_ip_address(tag_number, &binding_to_delete);

	switch (return_value) {
   	case CM_DHCP_UNBIND_SUCCESS:
      printf("WEB:Unbinding done successfully\n");
			break;
   	case CM_DHCP_UNBIND_FAILED:
      printf("WEB:Failed to Unbind\n");
			break;
		default:
      printf("WEB: Unknown Error, while unbinding\n");
			break;
	}

	display_dhcp_menu_page(request);
}
/* ... Added by CHRIS */

void display_detailed_info_of_bind(Request_t* request, BYTE link_number)
{
   USHORT bind_selected = (number_of_bind_lists_displayed - 1) * MAX_NUMBER_OF_LISTINGS_IN_A_PAGE + link_number - 1; /* Minus 1 is to make it 0 relative */
   CM_STRUCT_DHCP_BIND dhcp_bind_info;
   BYTE* buffer, temp_buffer[20];
   USHORT tag_number, search_to_start_at = 0;
   CM_STRUCT_DHCP_RANGE range_info;
   
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   buffer = (BYTE*)malloc(strlen(DHCP_ADD_DELETE_BINDING_data_ptr));
   if (buffer == NULL)
   {
      printf("WEB: Not Enough Memory to display Bind for editing\n");
      display_dhcp_menu_page(request);
      return;   
   }
   strcpy(buffer, DHCP_ADD_DELETE_BINDING_data_ptr);
   current_bind_number(bind_selected, TRUE);   
   tag_number = current_tag_number(0, FALSE);

   if (cm_get_dhcp_address_range(tag_number, &range_info) == FALSE)
   {
      printf("WEB:Failed to get Range Info ...\n");
      free(buffer);
      display_dhcp_menu_page(request);
      return;
   }

   search_to_start_at = search_and_replace(LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.ip_address_higher, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(EX_LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.exclude_ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(EX_HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.exclude_ip_address_higher, buffer, TRUE, search_to_start_at);

   if (cm_get_dhcp_binding(tag_number, bind_selected, &dhcp_bind_info) == FALSE)
   {  
      printf("WEB:Failed to get bind information on selected link\n");
      display_dhcp_menu_page(request);
      free(buffer);
      return;
   }  

   search_to_start_at = search_and_replace(IP_ADDRESS_TEMPLATE, dhcp_bind_info.ip_address_to_bind, buffer, TRUE, search_to_start_at);
   sprintf(temp_buffer, "%d\0", dhcp_bind_info.mac_address_length);
   search_to_start_at = search_and_replace(MAC_ADDRESS_TEMPLATE, dhcp_bind_info.mac_address_to_bind, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(MAC_ADDRESS_LENGTH_TEMPLATE, temp_buffer, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(BIND_BUTTON_TEMPLATE, "DeleteBinding", buffer, TRUE, search_to_start_at);

   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

USHORT current_bind_number(USHORT new_value, BYTE save)
{
   static USHORT value = 0;

   if (save)
      value = new_value;
   else
      return value;
}

void display_bind_info_of_link_1(Request_t* request)
{
   display_detailed_info_of_bind(request, 1);
}

void display_bind_info_of_link_2(Request_t* request)
{
   display_detailed_info_of_bind(request, 2);
}

void display_bind_info_of_link_3(Request_t* request)
{
   display_detailed_info_of_bind(request, 3);
}

void display_bind_info_of_link_4(Request_t* request)
{
   display_detailed_info_of_bind(request, 4);
}

void display_bind_info_of_link_5(Request_t* request)
{                               
   display_detailed_info_of_bind(request, 5);
}

void display_bind_info_of_link_6(Request_t* request)
{
   display_detailed_info_of_bind(request, 6);
}

void display_bind_info_of_link_7(Request_t* request)
{
   display_detailed_info_of_bind(request, 7);
}

void display_bind_info_of_link_8(Request_t* request)
{
   display_detailed_info_of_bind(request, 8);
}

void display_bind_info_of_link_9(Request_t* request)
{
   display_detailed_info_of_bind(request, 9);
}

void display_bind_info_of_link_10(Request_t* request)
{
   display_detailed_info_of_bind(request, 10);
}

void do_bind_operations_for_the_range(Request_t* request)
{
   USHORT tag_number;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   number_of_bind_lists_displayed = 0;

   tag_number = current_tag_number(0, FALSE);

#if 0
   if (cfgmgr_class.sptr_tag_list[tag_number].sptr_binding_list == NULL)
   {
      display_dhcp_menu_page(request);
      return;
   }
#endif
   start_bind_listing_from(0, TRUE);
   display_next_10_binding(request);
}  

void display_next_10_binding(Request_t* request)
{
   BYTE* buffer, temp_buffer[20];
   USHORT tag_number, start_from_the_bind, search_to_start_at = 0, index;
   CM_STRUCT_DHCP_BIND bind_info;
   CM_STRUCT_DHCP_RANGE range_info;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   tag_number = current_tag_number(0, FALSE);

   buffer =  (BYTE*)malloc(strlen(DHCP_BINDING_LIST_data_ptr));
   
   if (buffer == NULL)
   {
      printf("WEB:Insufficient Memory to display Binding List...\n");
      display_dhcp_menu_page(request);
      return;     
   }
   strcpy(buffer, DHCP_BINDING_LIST_data_ptr);
   start_from_the_bind = start_bind_listing_from(0, FALSE);

   if (cm_get_dhcp_address_range(tag_number, &range_info) == FALSE)
   {
#ifdef WEB_DEBUG  
      printf("WEB:Failed to get info on tag %d\n" , tag_number);
#endif      
      display_dhcp_menu_page(request);
      return;     
   }

   search_to_start_at = search_and_replace(LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.ip_address_higher, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(EX_LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.exclude_ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(EX_HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.exclude_ip_address_higher, buffer, TRUE, search_to_start_at);

   if (start_from_the_bind > cm_get_total_number_of_bindings_in_a_range(tag_number))
   {
#ifdef WEB_DEBUG
      printf("WEB: DANGER something wrong in keeping track of bindings\n");
#endif
      free(buffer);
      display_dhcp_menu_page(request);
      return;     
   }


   for( index = 0 ; index < MAX_NUMBER_OF_LISTINGS_IN_A_PAGE ; ++index)
   {
      if (start_from_the_bind+index+1 > cm_get_total_number_of_bindings_in_a_range(tag_number))
      {
         search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "", buffer, FALSE, search_to_start_at);
         continue;
      }

      if (cm_get_dhcp_binding(tag_number, start_from_the_bind+index, &bind_info) == FALSE)
      {
#ifdef WEB_DEBUG
         printf("WEB: DANGER Failed to get info for the tag %d\n", start_from_the_bind);
#endif
         free(buffer);
         display_dhcp_menu_page(request);
         return;
      }
      search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "", buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(BIND_IP_ADDRESS_TEMPLATE, bind_info.ip_address_to_bind, buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(BIND_MAC_ADDRESS_TEMPLATE, bind_info.mac_address_to_bind, buffer, TRUE, search_to_start_at);
      sprintf(temp_buffer, "%d\0", bind_info.mac_address_length);
      search_to_start_at = search_and_replace(BIND_MAC_ADDRESS_LENGTH_TEMPLATE, temp_buffer, buffer, TRUE, search_to_start_at);
   }

   search_to_start_at = search_and_replace(HTML_CLOSE_COMMENT_STRING, "", buffer, TRUE, search_to_start_at);
   /* Are there any more entries */
   if (start_from_the_bind + MAX_NUMBER_OF_LISTINGS_IN_A_PAGE < cm_get_total_number_of_bindings_in_a_range(tag_number))
   {
      /* There are more entries */
      search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "", buffer, FALSE, search_to_start_at);
      search_to_start_at = search_and_replace(HTML_COMMENT_STRING, "<A", buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace("--> ", "</A>", buffer, TRUE, search_to_start_at);
   }

   number_of_bind_lists_displayed ++;

   start_from_the_bind += MAX_NUMBER_OF_LISTINGS_IN_A_PAGE;
   start_bind_listing_from(start_from_the_bind, TRUE);
   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

void display_add_binding_page(Request_t* request)
{
   BYTE* buffer;
   USHORT search_to_start_at = 0, tag_number = 0;
   CM_STRUCT_DHCP_RANGE range_info;
   
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   buffer = (BYTE*)malloc(strlen(DHCP_ADD_DELETE_BINDING_data_ptr));

   if (buffer == NULL)
   {
      printf("WEB: Insufficient Memory to display page to add binding\n");
      display_dhcp_menu_page(request);
      return;     
   }
   strcpy(buffer, DHCP_ADD_DELETE_BINDING_data_ptr);

   tag_number = current_tag_number(0, FALSE);
   if (cm_get_dhcp_address_range(tag_number, &range_info) == FALSE)
   {
#ifdef WEB_DEBUG  
      printf("WEB: Failed to get Range Info ...\n");
#endif      
      free(buffer);
      display_dhcp_menu_page(request);
      return;
   }

   search_to_start_at = search_and_replace(LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.ip_address_higher, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(EX_LOWER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.exclude_ip_address_lower, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(EX_HIGHER_IP_ADDRESS_TEMPLATE_IN_BIND_PAGE, range_info.exclude_ip_address_higher, buffer, TRUE, search_to_start_at);


   search_to_start_at = search_and_replace(IP_ADDRESS_TEMPLATE, "", buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(MAC_ADDRESS_TEMPLATE, "", buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(MAC_ADDRESS_LENGTH_TEMPLATE, "", buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(BIND_BUTTON_TEMPLATE, "AddBinding", buffer, TRUE, search_to_start_at);

   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

void display_options_list(Request_t* request)
{
   InitReturnBuffer(request, DHCP_OPTION_LIST_data_ptr, strlen(DHCP_OPTION_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

USHORT start_bind_listing_from(USHORT new_value, BYTE save)
{
   static USHORT value = 0;

   if (save)
      value = new_value;
   else
      return value;
}
