#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/


#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"

#include "\rtrware\store\boot.h"

#include "ipicmp.h"
#include "ipicmpfm.h"

#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

enum ip_port_types ip_icmp_config_port;
USHORT get_value_and_handle_error_for_icmp_filter(BYTE value, USHORT search_to_start_at, BYTE* buffer);
void save_the_value_from_ip_icmp_form(CHANGE_IP_ICMP_PARAMS_form_output_type* ip_changed_params, BYTE port_number);
STRUCT_IP_ICMP_FILTER lastly_given_icmp_filter(STRUCT_IP_ICMP_FILTER ip_filter, BYTE is_to_save);
void	make_changes_to_corresponding_ip_icmp_port(enum ip_port_types config_port, CHANGE_IP_ICMP_PARAMS_form_output_type* ip_changed_params);
void fill_the_ip_icmp_form_with_appropriate_values(char* buffer, BYTE port_number);
void display_ip_icmp_page(Request_t* request, BYTE* buffer, BYTE port_number);
void display_ip_icmp_filter_page_for_lan_port_1(Request_t* request);

extern BYTE 		check_whether_user_is_authenticated_or_not(Request_t* request);
extern USHORT 		disable_hyperlink_and_change_text_colour(USHORT port_type, BYTE* buffer);
extern void 		check_for_need_and_hide_irrelevent_fields();
extern void 		enable_hyperlink(USHORT replaced_anchor_index_in_the_buffer, BYTE* buffer);
extern void 		show_the_hidden_fields();
extern void 		revert_back_form(char* buffer);
extern void 		display_main_page(Request_t* request);




extern BYTE* templates[];



void display_ip_icmp_filter_page(Request_t* request)
{
	display_ip_icmp_filter_page_for_lan_port_1(request);
}


void display_ip_icmp_filter_page_for_lan_port_1(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying IP ICMP Page for Secured LAN... \n");

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)ETHERNET_PORT, IP_ICMP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(ETHERNET_PORT);
	display_ip_icmp_page(request, IP_ICMP_CONFIG_PAGE_data_ptr, 0);
	enable_hyperlink(replaced_anchor_index_in_the_buffer, IP_ICMP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ip_icmp_config_port = ETHERNET_PORT;
}

void display_ip_icmp_filter_page_for_lan_port_2(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	printf("Displaying IP ICMP Configuration Page of Internet LAN...\n");

	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_1, IP_ICMP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_1);

	display_ip_icmp_page(request, IP_ICMP_CONFIG_PAGE_data_ptr, 1);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, IP_ICMP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ip_icmp_config_port = WAN_PORT_1;
}

void display_ip_icmp_filter_page_for_wan_port(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			

	if(!this_port_present_in_the_current_router(request, 2))
	{
		return;
	}

	printf("Displaying IP ICMP Configuration Page for WAN...\n");

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_2, IP_ICMP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_2);

	display_ip_icmp_page(request, IP_ICMP_CONFIG_PAGE_data_ptr, 2);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, IP_ICMP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ip_icmp_config_port = WAN_PORT_2;
}

void display_ip_icmp_filter_page_for_wan_port_3(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			

	if(!this_port_present_in_the_current_router(request, 3))
	{
		return;
	}

	printf("Displaying IP Configuration Page for WAN3...\n");

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_3, IP_ICMP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_3);

	display_ip_icmp_page(request, IP_ICMP_CONFIG_PAGE_data_ptr, 3);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, IP_ICMP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ip_icmp_config_port = WAN_PORT_3;
}

void display_ip_icmp_page(Request_t* request, BYTE* buffer, BYTE port_number)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	fill_the_ip_icmp_form_with_appropriate_values(buffer, port_number);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void fill_the_ip_icmp_form_with_appropriate_values(char* buffer, BYTE port_number)
{
     
	USHORT search_to_start_at = 0;
	PARAMETER_NODE* node;
	STRUCT_IP_ICMP_FILTER ip_filter;

	number_of_saved_indices = 0;
   
   /* Read the data */ 
	ip_filter.physical_port = port_number;
   node = cm_get_first_entry(CM_IP_SECTION, "IP ICMP Filter", (void*)&ip_filter);
	lastly_given_icmp_filter(ip_filter, TRUE);

	/* Echo Reply*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.echo_reply, search_to_start_at, buffer);

	/* Destination Unreachable*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.destination_unreachable, search_to_start_at, buffer);

	/* Source Quench*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.source_quench, search_to_start_at, buffer);

	/* Redirect*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.redirect, search_to_start_at, buffer);

	/* Echo Request*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.echo_request, search_to_start_at, buffer);

	/* Time Exceeded*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.time_exceeded, search_to_start_at, buffer);

	/* Parameter Problem*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.parameter_problem, search_to_start_at, buffer);

	/* Time Stamp Request*/
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.time_stamp_request, search_to_start_at, buffer);

	/* Time Stamp Reply */
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.time_stamp_reply, search_to_start_at, buffer);

	/* Address Mask Request */
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.address_mask_request, search_to_start_at, buffer);

	/* Address Mask Reply */
	search_to_start_at = get_value_and_handle_error_for_icmp_filter(ip_filter.address_mask_reply, search_to_start_at, buffer);

	number_of_saved_indices --;	/* Very Important statement */
}

USHORT get_value_and_handle_error_for_icmp_filter(BYTE value, USHORT search_to_start_at, BYTE* buffer)
{
	saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, value, search_to_start_at);
	search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
	saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
	return search_to_start_at;
}

void change_ip_icmp_filter_parameters(Request_t* request)
{
	CHANGE_IP_ICMP_PARAMS_form_output_type* ip_changed_params;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			

	ip_changed_params = (CHANGE_IP_ICMP_PARAMS_form_output_type*)form_data_of_request(request);
	if (ip_changed_params == NULL)
	{
		return;
	}
	make_changes_to_corresponding_ip_icmp_port(ip_icmp_config_port, ip_changed_params);
	display_filter_menu(request);
}

void	make_changes_to_corresponding_ip_icmp_port(enum ip_port_types config_port, CHANGE_IP_ICMP_PARAMS_form_output_type* ip_changed_params)
{
	switch(config_port)
	{
	case ETHERNET_PORT:
		save_the_value_from_ip_icmp_form(ip_changed_params, 0);
		break;
	case WAN_PORT_1:
		save_the_value_from_ip_icmp_form(ip_changed_params, 1);
		break;
	case WAN_PORT_2:
		save_the_value_from_ip_icmp_form(ip_changed_params, 2);
		break;
	case WAN_PORT_3:
		save_the_value_from_ip_icmp_form(ip_changed_params, 3);
		break;
	default:
#ifdef _NAVDEBUG_
	   for (i=0;i <= 100; ++i)
			printf("make_changes_to_corresponding_port None of the case are matching *\n");
#endif
	  	break;
	}
}


void save_the_value_from_ip_icmp_form(CHANGE_IP_ICMP_PARAMS_form_output_type* ip_changed_params, BYTE port_number)
{
	STRUCT_IP_ICMP_FILTER ip_filter, old_ip_filter, temp_ip_filter;
	
	ip_filter.echo_reply = ip_changed_params->echo_reply;
	ip_filter.destination_unreachable = ip_changed_params->destination_unreachable;
	ip_filter.source_quench = ip_changed_params->source_quench;
	ip_filter.redirect = ip_changed_params->redirect;
	ip_filter.echo_request = ip_changed_params->echo_request;
	ip_filter.time_exceeded = ip_changed_params->time_exceeded;
	ip_filter.parameter_problem = ip_changed_params->parameter_problem;
	ip_filter.time_stamp_request = ip_changed_params->time_stamp_request;
	ip_filter.time_stamp_reply = ip_changed_params->time_stamp_reply;
	ip_filter.address_mask_request = ip_changed_params->address_mask_request;
	ip_filter.address_mask_reply = ip_changed_params->address_mask_reply;

	ip_filter.physical_port = port_number;
	old_ip_filter = lastly_given_icmp_filter(temp_ip_filter, FALSE);
	if (cm_edit_string(CM_IP_SECTION, "IP ICMP Filter", (void*)&old_ip_filter, (void*)&ip_filter) != CM_STRING_EDIT_SUCCESSFUL)
	{
		printf("Failed to change the parameter for IP ICMP filter\n");
	}
}

STRUCT_IP_ICMP_FILTER lastly_given_icmp_filter(STRUCT_IP_ICMP_FILTER ip_filter, BYTE is_to_save)
{
	STRUCT_IP_ICMP_FILTER saved_icmp_filter;
	
	if(is_to_save)
		saved_icmp_filter = ip_filter;
	else
		return saved_icmp_filter;
}

