/* Author : Jyothi
   Date   : 10/3/98
   Description : Contains routines to handle VIRTUAL SERVER */

#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"

#include "natmenu.h"
#include "natglbad.h"
#include "natgadfm.h"
#include "natglbdl.h"
#include "natgdlfm.h"
#include "vdglbnat.h"
#include "natstadd.h"
#include "natsadfm.h"
#include "natstdel.h"
#include "natsdlfm.h"
#include "vdstnat.h"
#include "natdyadd.h"
#include "natdadfm.h"
#include "natdydel.h"
#include "natddlfm.h"
#include "vddynat.h"
#include "natprlst.h"
#include "natlstfm.h"

#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg) ;
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at) ;
extern void    display_framed_or_standard_main_page(Request_t* request) ;
BYTE    is_numeric_value(BYTE* buffer) ;
extern void    match_port_number_to_name(USHORT port_number, BYTE* name) ;
extern void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port);

#define	TCP		     0		
#define	UDP		     1		

#define	GLOBAL_ADDRESS	        0		
#define	STATIC_MAPPING		     1		
#define	DYNAMIC_MAPPING	     2		

#define	SIZEOF_GLOBAL_TEMPLATE	     16
#define	SIZEOF_TEMPLATE	           6

typedef struct NAT_ADDR_LIST 
{
 BYTE addr[16];
 struct NAT_ADDR_LIST *next;
}NAT_ADDR_LIST;

NAT_ADDR_LIST *nat_global_addr_list=NULL;


/* sudha 23 Aug 1999 */
#if 0
typedef struct
{
   BYTE name[70]; 
   USHORT port_number;
}STRUCT_NAT_PORT_NAME_LIB;

STRUCT_NAT_PORT_NAME_LIB NAT_port_names_lib[] = 
{
  {"CHAT", 531},
  {"DNS", 53},
   {"ECHO", 7},
   {"FINGER", 79},
   {"FTP20", 20},
   {"FTP21", 21},
   {"GOPHER", 70},
   {"HTTPS", 443},
   {"IMAP", 143},
   {"IMAP3", 220},
   {"IRC", 194},
   {"MIRC", 6667},
   {"MS-STREAMING", 1755},
   {"NAMESERVER", 42},
   {"NEWS", 144},
   {"NNTP", 119},
   {"POP3", 110},
   {"READNEWS", 532},
   {"REALAUDIO/VIDEO1090", 1090},
   {"REALAUDIO/VIDEO7070", 7070},
   {"RLOGIN", 513},
   {"SMTP", 25},
   {"SNMP", 161},
   {"SNMP-TRAP", 162},
   {"SSL-FTP989", 989},
   {"SSL-FTP990", 990},
   {"SSL-IRC", 994},
   {"SSL-IMAP4", 993},
   {"SSL-NNTP", 563},
   {"SSL-POP3", 995},
   {"SSL-SMTP", 465},
   {"SSL-TELNET", 992},
   {"TELNET", 23},
   {"TFTP", 69},
   {"VXTREME", 8000},
   {"WWW-HTTP", 80},
   {NULL, 0}
};
#endif



int mapping_action ;
/*...Extern Decleration*/

/* Local ProtoType ...*/

void display_nat_menu(Request_t* request) ;
void display_add_global_address_form (Request_t* request) ;
void display_add_static_mapping_form (Request_t* request) ;
void display_add_dynamic_mapping_form (Request_t* request) ;
void display_vd_global_address_page(Request_t* request) ;
void display_vd_static_mapping_page(Request_t* request) ;
void display_vd_dynamic_mapping_page(Request_t* request) ;
void add_global_address(Request_t* request) ;
void add_static_mapping(Request_t* request) ;
void add_dynamic_mapping(Request_t* request) ;
void delete_the_static_dynamic_entry(Request_t* request) ;
void delete_the_global_entry(Request_t* request) ;
void remove_a_particular_NAT_entry(USHORT index) ;
void display_global_address_for_deleting(Request_t* request, BYTE temp_global_addr[16]) ;
void display_static_mapping_for_deleting(Request_t* request, STRUCT_NAT_STATIC_ENTRY *temp_static_entry) ;
void display_dynamic_mapping_for_deleting(Request_t* request, STRUCT_NAT_DYNAMIC_ENTRY *temp_dynamic_entry) ;
USHORT modify_global_address_template(BYTE* buffer, BYTE temp_global_entry[16], USHORT search_to_start_at) ;
USHORT modify_static_mapping_template(BYTE* buffer, STRUCT_NAT_STATIC_ENTRY *temp_static_entry, USHORT search_to_start_at) ;
USHORT modify_dynamic_mapping_template(BYTE* buffer, STRUCT_NAT_DYNAMIC_ENTRY *temp_dynamic_entry, USHORT search_to_start_at) ;
USHORT get_the_number_of_global_address() ;
USHORT get_the_number_of_static_mapping() ;
USHORT get_the_number_of_dynamic_mapping() ;
void free_nat_global_addr_list() ;
void get_global_addr_list() ;
BYTE is_valid_global_address(BYTE *string_ptr) ;
BYTE check_if_is_duplicate_entry(BYTE *string_ptr) ;
BYTE is_global_address_mapped_for_static(BYTE *string_ptr) ;
BYTE is_duplicate_dynamic_protocol_port_entry(USHORT protocol, USHORT port) ;
void NAT_select_the_port_from_port_list_for_dynamic_mapping(Request_t* request) ;
void display_the_list_for_port_for_dynamic_mapping(Request_t* request) ;


void display_ten_NAT_entries(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page) ;
void display_next_ten_NAT_entries(Request_t* request) ;
USHORT hide_remaining_hyper_links_on_which_there_is_no_NAT_entry_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer) ;

BYTE save_the_number_of_NAT_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save) ;
BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save) ;
BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save) ;
PARAMETER_NODE* next_NAT_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save) ;
PARAMETER_NODE* first_NAT_entry_of_the_current_page(PARAMETER_NODE* new_value, BYTE is_required_to_save) ;
/* ... Local ProtoType*/


/*Extern Decleration ... */
/* sudha 23 Aug 1999 */
extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);

/*...Extern Decleration*/

PARAMETER_NODE* ptr_to_start_of_NAT_entries[3], *ptr_to_first_NAT_entries_of_current_page[3] ;
USHORT NAT_entries_till_current_page[3] = 0 , total_number_of_NAT_entries[3] = 0 ;
STRUCT_NAT_STATIC_ENTRY contents_of_static_mappings_page[NUMBER_OF_ROUTES_PER_PAGE] ;
STRUCT_NAT_DYNAMIC_ENTRY contents_of_dynamic_mappings_page[NUMBER_OF_ROUTES_PER_PAGE] ;
BYTE contents_of_global_address_page[NUMBER_OF_ROUTES_PER_PAGE][16] ;

void display_nat_menu(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
        InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_add_global_address_form (Request_t* request)
{
    BYTE* buffer ;
    USHORT search_to_start_at ;
    if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	mapping_action = GLOBAL_ADDRESS ;
	buffer = (BYTE*)malloc(strlen(ADD_GLOBAL_ADDRESS_data_ptr)) ;
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display Add Global Address Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	
	strcpy(buffer, ADD_GLOBAL_ADDRESS_data_ptr) ;

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}

void display_add_static_mapping_form (Request_t* request)
{
    BYTE* buffer ;
    USHORT search_to_start_at, number_of_global_address ;
    NAT_ADDR_LIST *temp_ptr ;
    
    if(!check_whether_user_is_authenticated_or_not(request))
		return ;
  
 	mapping_action = STATIC_MAPPING ;

   number_of_global_address = get_the_number_of_global_address() ;
	buffer = (BYTE*) malloc ((strlen(ADD_STATIC_MAPPING_data_ptr)) + (SIZEOF_GLOBAL_TEMPLATE  * number_of_global_address)) ;
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display Add Static Mapping Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	

   /* Jo display available global address list */

   get_global_addr_list() ;
   temp_ptr = nat_global_addr_list ;
   buffer[0] = 0 ;
   search_to_start_at = search_and_replace ("#GLAD#", " ", ADD_STATIC_MAPPING_data_ptr, FALSE, 0) ;
   strncpy(buffer, ADD_STATIC_MAPPING_data_ptr, search_to_start_at) ;
   buffer[search_to_start_at] = 0 ;
   while (temp_ptr != NULL)
   {
     strcat (buffer, temp_ptr->addr) ;
     temp_ptr = temp_ptr->next ;
   }

   strcat(buffer, (ADD_STATIC_MAPPING_data_ptr + search_to_start_at + SIZEOF_TEMPLATE)) ;

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}

void display_add_dynamic_mapping_form (Request_t* request)
{
    BYTE* buffer ;
    USHORT search_to_start_at, number_of_global_address ;
    BYTE dynamic_address[16] ;
    USHORT number_of_dynamic_mappings = 0 ;
    NAT_ADDR_LIST *temp_ptr ;

    if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
    mapping_action = DYNAMIC_MAPPING ;
    number_of_global_address = get_the_number_of_global_address() ;
    number_of_dynamic_mappings = get_the_number_of_dynamic_mapping() ;

   if (number_of_dynamic_mappings != 0)
      buffer = (BYTE*)malloc(strlen(ADD_DYNAMIC_MAPPING_data_ptr)) ;
   else
      buffer = (BYTE*)malloc ((strlen (ADD_DYNAMIC_MAPPING_data_ptr)) + (SIZEOF_GLOBAL_TEMPLATE  * number_of_global_address)) ;

	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display Add Dynamic Mapping Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	
   if (number_of_dynamic_mappings == 0)
   {
      /* Jo display global address list */

      get_global_addr_list() ;
      temp_ptr = nat_global_addr_list ;
      buffer[0] = 0 ;
      search_to_start_at = search_and_replace ("#GLAD#", " ", ADD_DYNAMIC_MAPPING_data_ptr, FALSE, 0) ;
      strncpy(buffer, ADD_DYNAMIC_MAPPING_data_ptr, search_to_start_at) ;
      buffer[search_to_start_at] = 0 ;
      while (temp_ptr != NULL)
      {
        strcat (buffer, temp_ptr->addr) ;
        temp_ptr = temp_ptr->next ;
      }

      strcat(buffer, (ADD_DYNAMIC_MAPPING_data_ptr + search_to_start_at + SIZEOF_TEMPLATE)) ;

      search_to_start_at = search_and_replace("#SG#", "", buffer, TRUE, 0) ; 
      search_to_start_at = search_and_replace("#EG#", "", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#SD#", "<!--", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#ED#", "-->", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at) ;
      search_to_start_at = search_and_replace("#TS#", "", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#TE#", "", buffer, TRUE, search_to_start_at) ; 
   }
   else
   {
	   strcpy(buffer, ADD_DYNAMIC_MAPPING_data_ptr) ;
      search_to_start_at = search_and_replace("#SG#", "<!--", buffer, TRUE, 0) ; 
      search_to_start_at = search_and_replace("#EG#", "-->", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#SD#", "", buffer, TRUE, search_to_start_at) ; 

      get_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_address[0], 16);

      search_to_start_at = search_and_replace("#___ADDRESS___#", dynamic_address, buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#ED#", "", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at) ;
      search_to_start_at = search_and_replace("#TS#", "<!--", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#TE#", "-->", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#GLAD#", "", buffer, TRUE, search_to_start_at) ; 
   }
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}

void display_vd_global_address_page(Request_t* request)
{
   BYTE temp_global_addr[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	mapping_action = GLOBAL_ADDRESS ;
   ptr_to_first_NAT_entries_of_current_page[mapping_action] = ptr_to_start_of_NAT_entries[mapping_action] = cm_get_first_entry(CM_PROXY_SECTION, "Proxy Server Global Address List", (void*)&temp_global_addr) ;
      
   total_number_of_NAT_entries[mapping_action] = get_the_number_of_global_address() ;
	if (total_number_of_NAT_entries[mapping_action] == 0)
	{
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;	
	}

	NAT_entries_till_current_page[mapping_action] = 0 ;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE) ;
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE) ;
	next_NAT_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_NAT_entries[mapping_action], TRUE) ;
	display_next_ten_NAT_entries(request) ;
}

void display_vd_static_mapping_page(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_struct ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	mapping_action = STATIC_MAPPING ;
   ptr_to_first_NAT_entries_of_current_page[mapping_action] = ptr_to_start_of_NAT_entries[mapping_action] = cm_get_first_entry(CM_PROXY_SECTION, "NAT_Static Mapping", (void*)&temp_static_struct) ;
      
   total_number_of_NAT_entries[mapping_action] = get_the_number_of_static_mapping() ;
	if (!total_number_of_NAT_entries[mapping_action])
	{
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;	
	}

	NAT_entries_till_current_page[mapping_action] = 0 ;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE) ;
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE) ;
	next_NAT_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_NAT_entries[mapping_action], TRUE) ;
	display_next_ten_NAT_entries(request) ;
}

void display_vd_dynamic_mapping_page(Request_t* request)
{
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_struct ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	mapping_action = DYNAMIC_MAPPING ;
	ptr_to_first_NAT_entries_of_current_page[mapping_action] = ptr_to_start_of_NAT_entries[mapping_action] = cm_get_first_entry(CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void*)&temp_dynamic_struct) ;
      
   total_number_of_NAT_entries[mapping_action] = get_the_number_of_dynamic_mapping() ;
	if (total_number_of_NAT_entries[mapping_action] == 0)
	{
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;	
	}

	NAT_entries_till_current_page[mapping_action] = 0 ;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE) ;
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE) ;
	next_NAT_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_NAT_entries[mapping_action], TRUE) ;
	display_next_ten_NAT_entries(request) ;
}

void add_global_address(Request_t* request)
{
	PARAMETER_NODE* new_node ;
	ADD_GLOBAL_ADDRESS_form_output_type* global_address_to_add ;
	BYTE temp_global_addr[16] ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
		
   global_address_to_add = (ADD_GLOBAL_ADDRESS_form_output_type*) form_data_of_request(request) ;

   if (strcmp (global_address_to_add->nat_ip_address, "0.0.0.0") == 0)
   {
     printf ("Invalid Global Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }

   strcpy (temp_global_addr, global_address_to_add->nat_ip_address) ;
   if (check_if_is_duplicate_entry(&temp_global_addr))
   {
     printf ("Invalid Global Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }

   if (is_valid_global_address(&temp_global_addr))
   {
     printf ("Duplicate Global Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }
   new_node = cm_insert_string (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *)&temp_global_addr[0]);
	if (new_node == NULL)
	{
		printf("Failed to Insert the global Mapping\n") ;
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}
	if (ptr_to_start_of_NAT_entries[mapping_action] == NULL)
		ptr_to_first_NAT_entries_of_current_page[mapping_action] = ptr_to_start_of_NAT_entries[mapping_action] = new_node ;
	total_number_of_NAT_entries[mapping_action] ++ ;
   
   InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}


void add_static_mapping(Request_t* request)
{
	PARAMETER_NODE* new_node ;
	ADD_STATIC_MAPPING_form_output_type* static_mapping_to_add ;
	STRUCT_NAT_STATIC_ENTRY temp_static_struct ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
		
   static_mapping_to_add = (ADD_STATIC_MAPPING_form_output_type*) form_data_of_request(request) ;
 	strcpy (temp_static_struct.global_addr, static_mapping_to_add->nat_global_ip_address) ;
 	strcpy (temp_static_struct.local_addr, static_mapping_to_add->nat_local_ip_address) ;
   
   if (!is_valid_global_address (temp_static_struct.global_addr))
   {
     printf ("Invalid Global Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }

   if (is_global_address_mapped_for_static(temp_static_struct.global_addr))
   {
     printf ("Global Address already mapped\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }
   if (check_if_is_duplicate_entry (temp_static_struct.local_addr)) 
   {
     printf ("Duplicate local Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }
   if (strcmp (temp_static_struct.local_addr, "0.0.0.0") == 0)
   {
     printf ("Invalid local Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }
	new_node = cm_insert_string(CM_PROXY_SECTION, "NAT_Static Mapping", (void*)&temp_static_struct) ;
	if (new_node == NULL)
	{
		printf("Failed to Insert the Static Mapping\n") ;
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}
	if (ptr_to_start_of_NAT_entries[mapping_action] == NULL)
		ptr_to_first_NAT_entries_of_current_page[mapping_action] = ptr_to_start_of_NAT_entries[mapping_action] = new_node ;
	total_number_of_NAT_entries[mapping_action] ++ ;
   InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void add_dynamic_mapping(Request_t* request)
{
	PARAMETER_NODE* new_node ;
	ADD_DYNAMIC_MAPPING_form_output_type* dynamic_mapping_to_add ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_struct ;
   USHORT number_of_dynamic_mappings = 0 ;
   BYTE dynamic_addr[16] ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
		
   dynamic_mapping_to_add = (ADD_DYNAMIC_MAPPING_form_output_type*) form_data_of_request(request) ;
   if (!strcmpi(dynamic_mapping_to_add->choose, "Choose From List..."))
   {
      display_the_list_for_port_for_dynamic_mapping(request);
      return;
   }
   if (!is_numeric_value(dynamic_mapping_to_add->port))
   {
      printf("Invalid Port Number Failed to add Port Entry\n");
   	InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      return;
   }

 	strcpy (temp_dynamic_struct.local_addr, dynamic_mapping_to_add->nat_local_ip_address) ;
	temp_dynamic_struct.protocol = dynamic_mapping_to_add->protocol ;
	temp_dynamic_struct.port = atoi(dynamic_mapping_to_add->port) ;

   number_of_dynamic_mappings = get_the_number_of_dynamic_mapping() ;

#if 0
   if (is_valid_global_address (temp_dynamic_struct.local_addr)) 
   {
     printf ("Duplicate local Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }
#endif

   if (is_global_address_mapped_for_static(dynamic_mapping_to_add->nat_global_ip_address))
   {
     printf ("Global Address already mapped\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }

   if (is_duplicate_dynamic_protocol_port_entry (temp_dynamic_struct.protocol, temp_dynamic_struct.port))
   {
     printf ("Duplicate protocal_port pair Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }

   if (strcmp (temp_dynamic_struct.local_addr, "0.0.0.0") == 0)
   {
     printf ("Invalid local Address\n") ;
	  InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
     return ;
   }

   if (number_of_dynamic_mappings == 0)
   {
      if (!is_valid_global_address (dynamic_mapping_to_add->nat_global_ip_address))
      {
         printf ("Invalid Global Address\n") ;
	      InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
         return ;
      }

      set_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
             CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, dynamic_mapping_to_add->nat_global_ip_address) ;
   }

   new_node = cm_insert_string(CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void*)&temp_dynamic_struct) ;
	if (new_node == NULL)
	{

   /* Jo Reset set parameter  */
      dynamic_addr[0] = 0 ;
      set_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
             CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_addr[0]) ;
		printf("Failed to Insert the dynamic Mapping\n") ;
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}

	if (ptr_to_start_of_NAT_entries[mapping_action] == NULL)
		ptr_to_first_NAT_entries_of_current_page[mapping_action] = ptr_to_start_of_NAT_entries[mapping_action] = new_node ;
	total_number_of_NAT_entries[mapping_action] ++ ;
   InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void display_the_list_for_port_for_dynamic_mapping(Request_t* request)
{
	USHORT ctrl_port = 0, data_port = 0;
	char c_port[10], d_port[10];

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
/* sudha 23 Aug 1999.To have unique port list display everywhere. */
/*   InitReturnBuffer(request, NAT_PORT_LIST_data_ptr, strlen(NAT_PORT_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE); */

	get_ftp_port_numbers(&ctrl_port, &data_port);
	sprintf(c_port,"%d", ctrl_port);
	sprintf(d_port,"%d", data_port);

	search_and_replace("#CTRL#", c_port, NAT_PORT_LIST_data_ptr, TRUE, 0);
	search_and_replace("#DATA#", d_port, NAT_PORT_LIST_data_ptr, TRUE, 0);

   InitReturnBuffer(request, NAT_PORT_LIST_data_ptr, strlen(NAT_PORT_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void select_the_port_from_port_list_for_dynamic_mapping(Request_t* request)
{
   NAT_PORT_LIST_form_output_type* selected_port;
   BYTE name[80] ;
   BYTE *buffer;
   USHORT search_to_start_at, number_of_global_address;
   BYTE dynamic_address[16] ;
   USHORT number_of_dynamic_mappings = 0, reserved_port_number = 0;
   NAT_ADDR_LIST *temp_ptr ;
	USHORT def_protocol = 0x0006; /* TCP_PROTOCOL */

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   selected_port = (NAT_PORT_LIST_form_output_type*)form_data_of_request(request);
   
/*   sprintf(name, "%d", NAT_port_names_lib[selected_port->port].port_number);*/

/* sudha 23 Aug 1999 */
  	reserved_port_number = get_protocol_port_number(def_protocol, selected_port->port+1);
   sprintf(name, "%d", reserved_port_number);
   	
    mapping_action = DYNAMIC_MAPPING ;
    number_of_global_address = get_the_number_of_global_address() ;
    number_of_dynamic_mappings = get_the_number_of_dynamic_mapping() ;

   if (number_of_dynamic_mappings != 0)
      buffer = (BYTE*)malloc(strlen(ADD_DYNAMIC_MAPPING_data_ptr)) ;
   else
      buffer = (BYTE*)malloc ((strlen (ADD_DYNAMIC_MAPPING_data_ptr)) + (SIZEOF_GLOBAL_TEMPLATE  * number_of_global_address)) ;

	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display Add Dynamic Mapping Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	

   if (number_of_dynamic_mappings == 0)
   {
      /* Jo display global address list */

      get_global_addr_list() ;
      temp_ptr = nat_global_addr_list ;
      buffer[0] = 0 ;
      search_to_start_at = search_and_replace ("#GLAD#", " ", ADD_DYNAMIC_MAPPING_data_ptr, FALSE, 0) ;
      strncpy(buffer, ADD_DYNAMIC_MAPPING_data_ptr, search_to_start_at) ;
      buffer[search_to_start_at] = 0 ;
      while (temp_ptr != NULL)
      {
        strcat (buffer, temp_ptr->addr) ;
        temp_ptr = temp_ptr->next ;
      }

      strcat(buffer, (ADD_DYNAMIC_MAPPING_data_ptr + search_to_start_at + SIZEOF_TEMPLATE)) ;

      search_to_start_at = search_and_replace("#SG#", "", buffer, TRUE, 0) ; 
      search_to_start_at = search_and_replace("#EG#", "", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#SD#", "<!--", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#ED#", "-->", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at) ;
      search_to_start_at = search_and_replace("#TS#", "", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#TE#", "", buffer, TRUE, search_to_start_at) ; 
   }
   else
   {
	   strcpy(buffer, ADD_DYNAMIC_MAPPING_data_ptr) ;
      search_to_start_at = search_and_replace("#SG#", "<!--", buffer, TRUE, 0) ; 
      search_to_start_at = search_and_replace("#EG#", "-->", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#SD#", "", buffer, TRUE, search_to_start_at) ; 

      get_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_address[0], 16);

      search_to_start_at = search_and_replace("#___ADDRESS___#", dynamic_address, buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#ED#", "", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, 0);
      search_to_start_at = search_and_replace("#TS#", "<!--", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#TE#", "-->", buffer, TRUE, search_to_start_at) ; 
      search_to_start_at = search_and_replace("#GLAD#", "", buffer, TRUE, search_to_start_at) ; 
   }

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}

void delete_the_static_dynamic_entry(Request_t* request)
{
	BYTE index ;
	PARAMETER_NODE* node, *prev_first_node_of_the_page ;
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   USHORT number_of_dynamic_mappings = 0 ;
   BYTE dynamic_addr[16] ;
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	index = save_the_number_of_NAT_entry_being_edited(NULL, FALSE) ;
	if (index == 1)
	{
		prev_first_node_of_the_page = first_NAT_entry_of_the_current_page(NULL, FALSE) ;
		
    	if (mapping_action == STATIC_MAPPING)
	    	node =  cm_get_first_entry(CM_PROXY_SECTION, "NAT_Static Mapping", (void*)&temp_static_entry) ;
      else
	    	node =  cm_get_first_entry(CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void*)&temp_dynamic_entry) ;

		while (node != prev_first_node_of_the_page)
		{
       	if (mapping_action == STATIC_MAPPING)
	       	node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_static_entry) ;
         else
	    	   node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_dynamic_entry) ;
		}
     	if (mapping_action == STATIC_MAPPING)
	    	node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_static_entry) ;
      else
	      node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_dynamic_entry) ;

		if (node)
			first_NAT_entry_of_the_current_page(node, TRUE) ;
	}
	remove_a_particular_NAT_entry(index) ;
   number_of_dynamic_mappings = get_the_number_of_dynamic_mapping() ;
   if (number_of_dynamic_mappings == 0)
   {
      dynamic_addr[0] = 0 ;
      set_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
             CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_addr[0]) ;
   }
	if (total_number_of_NAT_entries[mapping_action] == 0)
	{
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}

	InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void delete_the_global_entry(Request_t* request)
{
	BYTE index ;
	PARAMETER_NODE* node, *prev_first_node_of_the_page, *ptr_to_node ;
	STRUCT_NAT_STATIC_ENTRY nat_static_entry ;
   BYTE temp_global_entry[16] ;
   BYTE dynamic_addr[16];
   USHORT number_of_static_mappings = 0, number_of_dynamic_mappings = 0 ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
   dynamic_addr[0] = 0 ;
	index = save_the_number_of_NAT_entry_being_edited(NULL, FALSE) ;

   if (index == 1)
	{
		prev_first_node_of_the_page = first_NAT_entry_of_the_current_page(NULL, FALSE) ;
		
    	node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy Server Global Address List", (void*)&temp_global_entry) ;

		while (node != prev_first_node_of_the_page)
    	   node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_global_entry) ;

      node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_global_entry) ;

		if (node)
			first_NAT_entry_of_the_current_page(node, TRUE) ;
	}

   strcpy (temp_global_entry, &contents_of_global_address_page[index-1]) ;
   number_of_dynamic_mappings = get_the_number_of_dynamic_mapping() ;
   if (number_of_dynamic_mappings != 0)
   {
      get_parameter (CM_PROXY_SECTION, (void *)&proxy_server.proxy_local_internet_server_address,
            CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_addr[0], 16);

      if (!(strcmp (&dynamic_addr[0], &temp_global_entry[0])))
      {
         printf("Dynamic Mapping exists : Cannot delete\n" ) ;
		   InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
         return ;
      }
   }
   number_of_static_mappings = get_the_number_of_static_mapping() ;
   if (number_of_static_mappings != 0)
   {
      ptr_to_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry);
      while (ptr_to_node)
      {
         if ( !(strcmp (nat_static_entry.global_addr, &temp_global_entry[0])))
         {
            printf ("Static mapping exists : Can't delete\n") ;
   		   InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
            return ;
         }
         else
            ptr_to_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_node, (void *) &nat_static_entry);
      }
   }

	remove_a_particular_NAT_entry(index) ;
	if (total_number_of_NAT_entries[mapping_action] == 0)
	{
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}
	InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}


void remove_a_particular_NAT_entry(USHORT index)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
	PARAMETER_NODE* last_displayed_NAT_entry ;
   BYTE temp_global_entry[16] ;

  	if (mapping_action == STATIC_MAPPING)
   {    
      temp_static_entry = contents_of_static_mappings_page[index-1] ;
	   if (cm_remove_string(CM_PROXY_SECTION, "NAT_Static Mapping", (void*)&temp_static_entry) != CM_REMOVING_STRING_SUCCESSFUL)
	   {
		   printf("Failed to remove the Static Mapping \n") ;
		   return ;
	   }
   }
   else
   if(mapping_action == DYNAMIC_MAPPING)
   {
     	temp_dynamic_entry = contents_of_dynamic_mappings_page[index-1] ;
      if (contents_of_dynamic_mappings_page[index-1].protocol == 6)
          temp_dynamic_entry.protocol = 0 ;
      else
          temp_dynamic_entry.protocol = 1 ;

      if (cm_remove_string(CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void*)&temp_dynamic_entry) != CM_REMOVING_STRING_SUCCESSFUL)
	   {
		   printf("Failed to remove the Dynamic Mapping \n") ;
		   return ;
	   }
   }
   else
   {
     	strcpy (temp_global_entry, &contents_of_global_address_page[index-1]) ;
	   if (cm_remove_string (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *)temp_global_entry) != CM_REMOVING_STRING_SUCCESSFUL)
	   {
		   printf("Failed to remove the Global Address \n") ;
		   return ;
	   }
   }
	last_displayed_NAT_entry = next_NAT_entry_from_where_display_is_reqd_to_continue(NULL, FALSE) ;
	if (index == 10)
	{
		if (NAT_entries_till_current_page[mapping_action] == total_number_of_NAT_entries[mapping_action])
		{
			last_displayed_NAT_entry = last_displayed_NAT_entry->previous ;
			NAT_entries_till_current_page[mapping_action] -- ;
		}
		else
		{
			last_displayed_NAT_entry = last_displayed_NAT_entry->next ;
		}
	}
	else
	if (index == total_number_of_NAT_entries[mapping_action])
	{
			last_displayed_NAT_entry = last_displayed_NAT_entry->previous ;
			NAT_entries_till_current_page[mapping_action] -- ;
	}
	else
	if(NAT_entries_till_current_page[mapping_action] < 10)
	{
			NAT_entries_till_current_page[mapping_action] -- ;
	}
	next_NAT_entry_from_where_display_is_reqd_to_continue(last_displayed_NAT_entry, TRUE) ;
	total_number_of_NAT_entries[mapping_action] -- ;

	/* if the first node is deleted take care */
	if (total_number_of_NAT_entries[mapping_action] == 0)
	{
		ptr_to_start_of_NAT_entries[mapping_action] = NULL ;	
		return ;
	}
	if (NAT_entries_till_current_page[mapping_action]  <= 10 && index == 1)
	{
		 ptr_to_start_of_NAT_entries[mapping_action] = ptr_to_start_of_NAT_entries->next ;
	}
   return ;
}

void display_global_address_for_deleting(Request_t* request, BYTE temp_global_addr[16])
{
	BYTE* buffer, i ;
	USHORT search_to_start_at ;

  	buffer = malloc(strlen(DELETE_GLOBAL_ADDRESS_data_ptr)) ;
   
	if (buffer == NULL)
	{
		printf("Out Of memory to display Global Address for deleting\n") ;
		return ;
	}
   strcpy(buffer, DELETE_GLOBAL_ADDRESS_data_ptr) ;
   search_to_start_at = search_and_replace("#___ADDRESS___#", temp_global_addr, buffer, TRUE, 0) ; 
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
	free(buffer) ;
}

void display_static_mapping_for_deleting(Request_t* request, STRUCT_NAT_STATIC_ENTRY *temp_static_entry)
{
	BYTE* buffer, i ;
	USHORT search_to_start_at ;

  	buffer = malloc(strlen(DELETE_STATIC_MAPPING_data_ptr)) ;
   
	if (buffer == NULL)
	{
		printf("Out Of memory to display Static Mapping for deleting\n") ;
		return ;
	}
   strcpy(buffer, DELETE_STATIC_MAPPING_data_ptr) ;
   search_to_start_at = search_and_replace("#___ADDRESS___#", temp_static_entry->global_addr, buffer, TRUE, 0) ; 
   search_to_start_at = search_and_replace("#___ADDRESS___#", temp_static_entry->local_addr, buffer, TRUE, search_to_start_at) ; 
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
	free(buffer) ;
}

void display_dynamic_mapping_for_deleting(Request_t* request, STRUCT_NAT_DYNAMIC_ENTRY *temp_dynamic_entry)
{
	BYTE* buffer, i ;
	USHORT search_to_start_at ;
   char* protocol_string ;
   BYTE dynamic_addr[16];
   BYTE temp_buffer[100], app_type[50];

	buffer = malloc(strlen(DELETE_DYNAMIC_MAPPING_data_ptr)) ;
	if (buffer == NULL)
	{
		printf("Out Of memory to display a Dynamic Mapping for deleting\n") ;
		return ;
	}
	strcpy(buffer, DELETE_DYNAMIC_MAPPING_data_ptr) ;


   get_parameter (CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_addr[0], 16);

   search_to_start_at = search_and_replace("#___ADDRESS___#", dynamic_addr, buffer, TRUE, 0) ; 
   search_to_start_at = search_and_replace("#___ADDRESS___#", temp_dynamic_entry->local_addr, buffer, TRUE, search_to_start_at) ; 

   if (temp_dynamic_entry->protocol == 0x0006)
      strcpy(temp_buffer, "TCP");
   else
      strcpy(temp_buffer, "UDP");

   search_to_start_at = search_and_replace("#___#", temp_buffer, buffer, TRUE, search_to_start_at);
/* sudha 23 Aug 1999 */
	strcpy(app_type, get_port_type(app_type,temp_dynamic_entry->protocol,temp_dynamic_entry->port));
	sprintf(temp_buffer,"%s(%d)", app_type,temp_dynamic_entry->port);
/*   match_port_number_to_name(temp_dynamic_entry->port, temp_buffer); */
	search_to_start_at = search_and_replace("#____#____#____PORT____#____#", temp_buffer, buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
	free(buffer) ;
}

void display_delete_NAT_entry_1(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[0] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[0] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[0]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(1, TRUE) ;
}

void display_delete_NAT_entry_2(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[1] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[1] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[1]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(2, TRUE) ;
}

void display_delete_NAT_entry_3(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[2] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[2] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[2]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(3, TRUE) ;
}

void display_delete_NAT_entry_4(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[3] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[3] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[3]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(4, TRUE) ;
}

void display_delete_NAT_entry_5(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[4] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[4] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[4]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(5, TRUE) ;
}

void display_delete_NAT_entry_6(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[5] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[5] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[5]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(6, TRUE) ;
}

void display_delete_NAT_entry_7(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[6] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[6] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[6]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(7, TRUE) ;
}

void display_delete_NAT_entry_8(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[7] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[7] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[7]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(8, TRUE) ;
}

void display_delete_NAT_entry_9(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[8] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[8] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[8]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(9, TRUE) ;
}

void display_delete_NAT_entry_10(Request_t* request)
{
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (mapping_action == STATIC_MAPPING)
	{
      temp_static_entry = contents_of_static_mappings_page[9] ;
	   display_static_mapping_for_deleting(request, &temp_static_entry) ;
   }
   else
	 if (mapping_action == DYNAMIC_MAPPING)
    {
      temp_dynamic_entry = contents_of_dynamic_mappings_page[9] ;
	   display_dynamic_mapping_for_deleting(request, &temp_dynamic_entry) ;
    }
    else
    {
      strcpy (&temp_global_entry, &contents_of_global_address_page[9]) ;
	   display_global_address_for_deleting(request, temp_global_entry) ;
    }
	save_the_number_of_NAT_entry_being_edited(10, TRUE) ;
}

void display_next_ten_NAT_entries(Request_t* request)
{
	PARAMETER_NODE* temp_ptr ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;                                    
			
	temp_ptr = next_NAT_entry_from_where_display_is_reqd_to_continue(NULL, FALSE) ;
 	display_ten_NAT_entries(request, temp_ptr, TRUE) ;

}

void display_ten_NAT_entries(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page ;
	USHORT i, search_to_start_at = 0 ;
	STRUCT_NAT_STATIC_ENTRY temp_static_entry ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_entry ;
   BYTE temp_global_entry[16] ;
	PARAMETER_NODE* node, *prev_node ;
   static BYTE number_of_entries_read_in_the_current_node = 0 ;

	first_NAT_entry_of_the_current_page(starting_from, TRUE) ;

	if(NAT_entries_till_current_page[mapping_action] == total_number_of_NAT_entries[mapping_action])
	{
		InitReturnBuffer(request, NAT_MENU_data_ptr, strlen(NAT_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}

   if (mapping_action == STATIC_MAPPING)
    	temp_page = malloc(strlen(VIEW_DELETE_STATIC_MAPPING_data_ptr)) ;
   else
     if (mapping_action == DYNAMIC_MAPPING)
    	  temp_page = malloc(strlen(VIEW_DELETE_DYNAMIC_MAPPING_data_ptr)) ;
      else
    	  temp_page = malloc(strlen(VIEW_DELETE_GLOBAL_ADDRESS_data_ptr)) ;

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display list.\n") ;
		return ;
	}

   if (mapping_action == STATIC_MAPPING)
	{
      strcpy(temp_page, VIEW_DELETE_STATIC_MAPPING_data_ptr) ;
	   node =  cm_get_first_entry(CM_PROXY_SECTION, "NAT_Static Mapping", (void*)&temp_static_entry) ;
   }
   else
    if (mapping_action == DYNAMIC_MAPPING)
    {
      strcpy(temp_page, VIEW_DELETE_DYNAMIC_MAPPING_data_ptr) ;
	   node =  cm_get_first_entry(CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void*)&temp_dynamic_entry) ;
    }
    else
    {
      strcpy(temp_page, VIEW_DELETE_GLOBAL_ADDRESS_data_ptr) ;
	   node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy Server Global Address List", (void*)&temp_global_entry) ;
    }
	if (node == starting_from)
		number_of_entries_read_in_the_current_node = 0 ;
	while (node != starting_from)
	{
     if (mapping_action == STATIC_MAPPING)
	      node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_static_entry) ;
	   else	
         if (mapping_action == DYNAMIC_MAPPING)
            node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_dynamic_entry) ;
         else
            node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_global_entry) ;
	}
	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i = 0 ; i < number_of_entries_read_in_the_current_node ; ++i)
		{
			if (!node)
				return ;
          if (mapping_action == STATIC_MAPPING)
	           node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_static_entry) ;
          else
              if (mapping_action == DYNAMIC_MAPPING)
			         node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_dynamic_entry) ;
              else
			         node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_global_entry) ;
		}
	}
	number_of_entries_read_in_the_current_node = 0 ;
	prev_node = starting_from ;

	for(i = 0 ; i < NUMBER_OF_ROUTES_PER_PAGE ; ++i)
	{
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at) ;
      if (mapping_action == STATIC_MAPPING)
   	{
         search_to_start_at = modify_static_mapping_template(temp_page, &temp_static_entry, search_to_start_at) ;
         contents_of_static_mappings_page[i] = temp_static_entry ;
      }
      else
        if (mapping_action == DYNAMIC_MAPPING)
        {
          search_to_start_at = modify_dynamic_mapping_template(temp_page, &temp_dynamic_entry, search_to_start_at) ;
		    contents_of_dynamic_mappings_page[i] =  temp_dynamic_entry ;
        }
        else
        {
          search_to_start_at = modify_global_address_template(temp_page, &temp_global_entry, search_to_start_at) ;
		    strcpy (contents_of_global_address_page[i], temp_global_entry) ;
        }

		NAT_entries_till_current_page[mapping_action]++ ;
		if ((NAT_entries_till_current_page[mapping_action] == total_number_of_NAT_entries[mapping_action] && is_displaying_next_page)
		    || (NAT_entries_till_current_page[mapping_action] == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_NAT_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE) ;

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_NAT_entry_to_display(i+1, search_to_start_at, temp_page) ;
			if (is_displaying_next_page)
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
			else
			{
				/* while displaying if we each first page just remove back link */

				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_number_of_NAT_entries[mapping_action] > NUMBER_OF_ROUTES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
			}
			InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
			free(temp_page) ;
			return ;
		}
		if (is_displaying_next_page)
		{
         if (mapping_action == STATIC_MAPPING)
		     	starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&temp_static_entry) ;
         else
             if (mapping_action == DYNAMIC_MAPPING)
		        	starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&temp_dynamic_entry) ;
             else
		        	starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&temp_global_entry) ;
		}
		if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++ ;
		else
      {
			number_of_entries_read_in_the_current_node = 0 ;
         prev_node = starting_from ;
      }
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_NAT_entry_to_display(i+1, search_to_start_at, temp_page) ;
			InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
			free(temp_page) ;
			return ;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at) ;

	/* Save the lastly displayed node */
	next_NAT_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE) ;

	/* Check if back link is required or not */
	/* Check if forward link is required or not */
	if (total_number_of_NAT_entries[mapping_action] > NAT_entries_till_current_page[mapping_action])
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;

	InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
	free(temp_page) ;
}

USHORT modify_global_address_template(BYTE* buffer, BYTE temp_global_entry[16], USHORT search_to_start_at)
{
      search_to_start_at = search_and_replace("#___ADDRESS___#", temp_global_entry, buffer, TRUE, search_to_start_at) ;
      return (search_to_start_at) ;
}


USHORT modify_static_mapping_template(BYTE* buffer, STRUCT_NAT_STATIC_ENTRY *temp_static_entry, USHORT search_to_start_at)
{
      search_to_start_at = search_and_replace("#_GL_ADDRESS__#", temp_static_entry->global_addr, buffer, TRUE, search_to_start_at) ;
      search_to_start_at = search_and_replace("#_LC_ADDRESS__#", temp_static_entry->local_addr, buffer, TRUE, search_to_start_at) ;
      return (search_to_start_at) ;
}

USHORT modify_dynamic_mapping_template(BYTE* buffer, STRUCT_NAT_DYNAMIC_ENTRY *temp_dynamic_entry, USHORT search_to_start_at)
{
     BYTE dynamic_addr[16];
     BYTE temp_buffer[100], app_type[50];
    
      get_parameter (CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_addr[0], 16);
     search_to_start_at = search_and_replace("#_GL_ADDRESS__#", dynamic_addr, buffer, TRUE, search_to_start_at) ;
     search_to_start_at = search_and_replace("#_LC_ADDRESS__#", temp_dynamic_entry->local_addr, buffer, TRUE, search_to_start_at) ;

     if (temp_dynamic_entry->protocol == 0x0006)
        strcpy(temp_buffer, "TCP");
     else
        strcpy(temp_buffer, "UDP");
     
     search_to_start_at = search_and_replace("#___#", temp_buffer, buffer, TRUE, search_to_start_at);
/* sudha 23 Aug 1999 */
		strcpy(app_type, get_port_type(app_type,temp_dynamic_entry->protocol,temp_dynamic_entry->port));
		sprintf(temp_buffer, "%s(%d)", app_type, temp_dynamic_entry->port);
/*     match_port_number_to_name(temp_dynamic_entry->port, temp_buffer); */
	  search_to_start_at = search_and_replace("#____#____#____PORT____#____#", temp_buffer, buffer, TRUE, search_to_start_at);
     return (search_to_start_at) ;
}


USHORT get_the_number_of_global_address()
{
	USHORT count = 0 ;
	PARAMETER_NODE* node ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_struct ;
   BYTE temp_global_addr[16] ;

	node = cm_get_first_entry(CM_PROXY_SECTION, "Proxy Server Global Address List", (void*)&temp_global_addr) ;
	while (node)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_global_addr) ;
		count ++ ;	
	}
	return count ;
}


USHORT get_the_number_of_static_mapping()
{
	USHORT count = 0 ;
	PARAMETER_NODE* node ;
	STRUCT_NAT_STATIC_ENTRY temp_static_struct ;

	node = cm_get_first_entry(CM_PROXY_SECTION, "NAT_Static Mapping", (void*)&temp_static_struct) ;
	while (node)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_static_struct) ;
		count ++ ;	
	}
	return count ;
}

USHORT get_the_number_of_dynamic_mapping()
{
	USHORT count = 0 ;
	PARAMETER_NODE* node ;
	STRUCT_NAT_DYNAMIC_ENTRY temp_dynamic_struct ;

	node = cm_get_first_entry(CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void*)&temp_dynamic_struct) ;
	while (node)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_dynamic_struct) ;
 		count ++ ;	
	}
	return count ;
}

void free_nat_global_addr_list()
{
   NAT_ADDR_LIST *list_ptr;
   NAT_ADDR_LIST *list;

   list = nat_global_addr_list;

   if (list == NULL)
      return;
   printf ("Nat Global Addr List does not contain any entries\n");
   while ( list->next != NULL )
   {
      list_ptr = list->next;
      free (list);
      list = list_ptr;
   }
   printf ("Freed Nat Global Addr List\n");
   return;
}

void get_global_addr_list()
{
   BYTE nat_global_addr[16], temp_buffer[25] ;
   STRUCT_NAT_STATIC_ENTRY nat_static_entry ;
   PARAMETER_NODE *ptr_to_current_global_node,*ptr_to_current_static_node ;
   BYTE dynamic_addr[16],temp_str[70] ;
	NAT_ADDR_LIST *temp_ptr ;
   USHORT index ;
   
   free_nat_global_addr_list ();
   nat_global_addr_list = NULL;

   ptr_to_current_global_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *)&nat_global_addr[0]) ;

   get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_addr[0], 16) ;
   ptr_to_current_static_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *)&nat_static_entry);

   if ((!dynamic_addr[0]) && (ptr_to_current_static_node == NULL))  
   {
      while (ptr_to_current_global_node)
      {
         temp_ptr = (NAT_ADDR_LIST *)malloc(sizeof (NAT_ADDR_LIST ));
            if (temp_ptr == NULL)
				{
               printf("Insufficient memory\n") ;
               return ;
	         }
		      sprintf(temp_buffer, "%s\n\0", nat_global_addr) ;
            strcpy(temp_ptr->addr, temp_buffer);
			   temp_ptr->next = nat_global_addr_list;
				nat_global_addr_list = temp_ptr;
         
         ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
      }
      return ;
   }

   while (ptr_to_current_global_node)
   {
      if (strcmp(nat_global_addr, dynamic_addr))
      {
         ptr_to_current_static_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *)&nat_static_entry);
         while (ptr_to_current_static_node) 
         {
            if (strcmp(nat_global_addr,nat_static_entry.global_addr) != 0)
               ptr_to_current_static_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_static_node, (void *)&nat_static_entry);
            else
               break ;
         }
         if (ptr_to_current_static_node == NULL) 
         {
            temp_ptr = (NAT_ADDR_LIST *)malloc(sizeof (NAT_ADDR_LIST )) ;
            if (temp_ptr == NULL)
               printf("Insufficient memory\n") ;
		      sprintf(temp_buffer, "%s\n\0", nat_global_addr) ;
            strcpy(temp_ptr->addr, temp_buffer);
			   temp_ptr->next = nat_global_addr_list;
				nat_global_addr_list = temp_ptr;
         }
      }
      ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
   }
   return ;
}

BYTE check_if_is_duplicate_entry(BYTE *string_ptr)
{
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   PARAMETER_NODE *ptr_to_current_local_node;
   BYTE nat_global_addr[16];
   PARAMETER_NODE *ptr_to_current_global_node;
   USHORT number_of_static_mappings = 0, number_of_dynamic_mappings = 0 ;
   ptr_to_current_global_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *) &nat_global_addr[0]);

#if 0
   while (ptr_to_current_global_node)
   {
      if (strcmp (nat_global_addr,string_ptr) == 0)
      {
         printf ("Duplicate Global Address\n") ;
         return TRUE;
      }
      else
         ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
   }
#endif

   number_of_static_mappings = get_the_number_of_static_mapping() ;
   if (number_of_static_mappings != 0)
   {
      ptr_to_current_local_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry) ;
      while (ptr_to_current_local_node)
      {
         if (strcmp (nat_static_entry.local_addr,string_ptr) == 0)
         {
            printf ("Duplicate Static Address\n") ;
            return TRUE;
         }
         else
            ptr_to_current_local_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_local_node, (void *) &nat_static_entry);
      }               
   }
   number_of_dynamic_mappings = get_the_number_of_dynamic_mapping() ;
   if (number_of_dynamic_mappings != 0)
   {
      ptr_to_current_local_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *) &nat_dynamic_entry) ;
      while (ptr_to_current_local_node)
      {
         if (strcmp (nat_dynamic_entry.local_addr,string_ptr) == 0)
         {
            printf ("Duplicate Dynamic Address\n") ;
            return TRUE;
         }
         else
            ptr_to_current_local_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_local_node, (void *) &nat_dynamic_entry);
      } 
   }
   return FALSE;
}


BYTE is_global_address_mapped_for_static(BYTE *string_ptr)
{
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   PARAMETER_NODE *ptr_to_current_local_node;
   BYTE dynamic_addr[16] ;
   USHORT number_of_static_mappings = 0 , number_of_dynamic_mappings = 0 ;

   number_of_static_mappings = get_the_number_of_static_mapping() ;
   if (number_of_static_mappings != 0)
   {
      ptr_to_current_local_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry) ;
      while (ptr_to_current_local_node)
      {
         if (strcmp (nat_static_entry.global_addr,string_ptr) == 0)
         {
            printf ("Global Address already mapped to static mapping\n") ;
            return TRUE;
         }
         else
            ptr_to_current_local_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_local_node, (void *) &nat_static_entry);
      }               
   }

   number_of_dynamic_mappings = get_the_number_of_dynamic_mapping() ;
   if (number_of_dynamic_mappings != 0)
   {
      get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dynamic_addr[0], 16) ;
         if (strcmp (dynamic_addr,string_ptr) == 0)
         {
            printf ("Global Address already mapped to dynamic mapping\n") ;
            return TRUE;
         }
   }
   return FALSE ;
}

BYTE is_valid_global_address(BYTE *string_ptr)
{
   BYTE nat_global_addr[16];
   PARAMETER_NODE *ptr_to_current_global_node;

   ptr_to_current_global_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *) &nat_global_addr[0]);
   while (ptr_to_current_global_node)
   {
      if (strcmp (nat_global_addr,string_ptr) == 0)
      {
         printf ("Valid Global Address\n") ;
         return TRUE;
      }
      else
         ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
   }
   return FALSE ;
}

BYTE is_duplicate_dynamic_protocol_port_entry(USHORT protocol, USHORT port)
{
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   PARAMETER_NODE *ptr_to_current_dynamic_node;
   USHORT temp_protocol ;

   if (protocol == 0)
      temp_protocol = 6 ;
   else
      temp_protocol = 17 ;

   ptr_to_current_dynamic_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *) &nat_dynamic_entry);
   while (ptr_to_current_dynamic_node)
   {
      if ( (nat_dynamic_entry.protocol == temp_protocol) &&
         (nat_dynamic_entry.port == port))
      {
         printf ("Duplicate Protocol_Port Pair\n") ;
         return TRUE;
      }
      else
         ptr_to_current_dynamic_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_dynamic_node, (void *) &nat_dynamic_entry);
   }
   return FALSE;
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_NAT_entry_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i ;
	BYTE comment_opened = FALSE ;
	for(i=0 ;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from ;++i)
	{
		comment_opened = TRUE ;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at) ;
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at) ;
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at) ;
		
	return search_to_start_at ;
}




BYTE save_the_number_of_NAT_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte ;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte ;
	else
		return saved_byte ;
}

PARAMETER_NODE* next_NAT_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node ;

	if (is_required_to_save)
		saved_node = last_node ;
	else
		return saved_node ;
} 

PARAMETER_NODE* first_NAT_entry_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node ;

	if (is_required_to_save)
		saved_node = new_node ;
	else
		return saved_node ;
}

/* Moved from Proxyflt.c as Proxyflt.c is removed from makefile */
BYTE is_numeric_value(BYTE* buffer)
{
   BYTE i;
   for (i=0 ; i<strlen(buffer) ; ++i)
   {
      if (buffer[i] < '0' || buffer[i] > '9')
         return FALSE;
   }
   return TRUE;   
}

