#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"

#define NUMBER_OF_ENTRIES_PER_PAGE 10



#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

#include "proxy.h"
#include "addproxy.h"
#include "edtproxy.h"
#include "vedproxy.h"
#include "tcplist.h"
#include "udplist.h"

#include "adprxyfm.h"
#include "edtprxfm.h"
#include "tcplstfm.h"
#include "udplstfm.h"
#include "ftpports.h"
#include "ftpprxfm.h"

#define ADD_ENTRY 1
#define EDIT_ENTRY 2

/* Brindha on 29/1/99 */
#define RESERVED_ENTRY 0
#define USER_ENTRY 1

int entry_type; 

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE*   templates[];

/* Included on 29/1/99 */
extern BOOL is_user_defined_port_not_in_reserved_port_list(USHORT lower_port, USHORT higher_port);
extern enum TEST_RESULT is_user_defined_port_range_unique(USHORT lower_port, USHORT higher_port,USHORT protocol);

/* sudha 23 Aug 1999 */
extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);
extern BOOL IsStrNumericAndValid(char *Str);
extern enum TEST_RESULT is_user_defined_port_range_unique(USHORT lower_port, USHORT higher_port,USHORT protocol);
extern void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port);

/*...Extern Decleration*/

/* Local ProtoType ...*/
void display_the_proxy_entry_for_editing(Request_t* request, STRUCT_PROXY_ENTRY* proxy_entry);
void display_ten_proxy_entries_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page);
void display_prev_proxy_entries(Request_t* request);
void display_next_ten_proxy_entries(Request_t* request);
USHORT get_the_number_of_proxy_entries();
void change_the_edited_proxy_entries(Request_t* request);
USHORT hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer);

void go_back_to_proxy_entry_listing_page(Request_t* request);
BYTE save_the_number_of_proxy_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
USHORT enable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT enable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
PARAMETER_NODE* next_proxy_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save);
void remove_a_perticular_proxy_entry(USHORT index);
PARAMETER_NODE* first_proxy_entry_of_the_current_page(PARAMETER_NODE* new_value, BYTE is_required_to_save);
USHORT modify_the_proxy_entry_template(BYTE* buffer, STRUCT_PROXY_ENTRY* proxy_entry, USHORT search_to_start_at);
void display_the_list_for_tcp(Request_t* request);
void display_the_list_for_udp(Request_t* request);
void select_the_port_from_tcp_port_list(Request_t* request);
void select_the_port_from_udp_port_list(Request_t* request);
BYTE is_numeric(BYTE* buffer);

/* Brindha on 29/1/99 */
void write_the_port_number_and_name(USHORT lower_port_number, USHORT higher_port_number, BYTE description[25], BYTE* name);
USHORT modify_the_proxy_user_entry_template(BYTE* buffer, STRUCT_PROXY_USER_ENTRY* proxy_user_entry, USHORT search_to_start_at);
USHORT get_the_number_of_proxy_user_entries();


/* ... Local ProtoType*/

PARAMETER_NODE* ptr_to_start_of_proxy_entries[2], *ptr_to_first_proxy_entry_of_current_page[2];
USHORT proxy_entries_till_current_page[2] = 0, total_proxy_entries[2] = 0;

STRUCT_PROXY_ENTRY contents_of_proxy_entry_page[NUMBER_OF_ENTRIES_PER_PAGE];
STRUCT_PROXY_USER_ENTRY contents_of_proxy_user_entry_page[NUMBER_OF_ENTRIES_PER_PAGE];

/* sudha 23 Aug 1999 */
#if 0
typedef struct
{
   BYTE name[70]; /* NOTE: Change this if u change/add names in names_lib struct */
   USHORT port_number;
}STRUCT_NAME_PORT_LIB;

STRUCT_NAME_PORT_LIB names_lib[] = 
{
   {"Conference", 531},
   {"Domain Name Server", 53},
   {"Echo Application", 7},
   {"Finger User Information Protocol", 79},
   {"File Transfer Protocol", 20},
   {"File Transfer Protocol", 21},
   {"Gopher - Distributed Documentation Search and Retrieval", 70},
   {"On-line Host Name Service", 42},
   {"News", 144},
   {"Post Office Protocol(Ver3) e-mail", 110},
   {"Readnews", 532},
   {"Simple Mail Transfer Protocol", 25},
   {"Telnet Application", 23},
   {"Trivial File Transfer Protocol", 69},
   {"World Wide Web-Hyper Text Transfer Protocol", 80},
   {"Network News Transfer Protocol", 119},
   {"Internet Relay Chat Protocol", 194},
   {"Secure Socket Layer Hyper Text Transfer Protocol", 443},
   {"Secure Socket Layer Network News Transfer Protocol", 563},
   {"Secure Socket Layer Simple Mail Transfer Protocol", 465},
   {"Remote Login - Telnet", 513},
   {NULL, 0}
};
#endif


void display_proxy_menu(Request_t* request)
{
	/* STRUCT_PROXY_ENTRY temp_proxy_entry; */
	

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
   /* ptr_to_first_proxy_entry_of_current_page = ptr_to_start_of_proxy_entries = cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	proxy_entries_till_current_page = 0;
	if (ptr_to_first_proxy_entry_of_current_page)
		total_proxy_entries = get_the_number_of_proxy_entries(); */
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

/* sudha 21 Aug 1999 */
void display_page_to_configure_proxy_ftp_port_entries(Request_t* request)
{
   USHORT search_to_start_at = 0;
	char ctrl_port[10], data_port[10];   
   BYTE* buffer;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	buffer =  (BYTE*)malloc(strlen(FTP_PORTS_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for configuring ftp port numbers \n");
		return;
	}
	strcpy(buffer, FTP_PORTS_CONFIG_PAGE_data_ptr);

   get_parameter(CM_PROXY_SECTION, (void*)&proxy_server.ftp_ctrl_conn_port, CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,(void *)&ctrl_port, 10);
   get_parameter(CM_PROXY_SECTION, (void*)&proxy_server.ftp_data_conn_port, CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,(void *)&data_port, 10);

   search_to_start_at = search_and_replace("#___TEXT___#___", ctrl_port, buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace("#___TEXT___#___", data_port, buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

void set_the_values_of_ftp_ports(Request_t* request)
{
	CHANGE_FTP_PORTS_PARAMS_form_output_type*  proxy_ftp_entries_to_add; 
	STRUCT_PROXY_ENTRY ptr_to_old_proxy_app, ptr_to_new_proxy_app;	
	USHORT ctrl_port = 0, data_port = 0, higher_port = 0;
	USHORT ftp_prev_ctrl_port = 0, ftp_prev_data_port = 0;   
	USHORT protocol = 0x0006; /* TCP_PROTOCOL */
	enum TEST_RESULT result;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
   get_parameter(CM_PROXY_SECTION, (void*)&proxy_server.ftp_ctrl_conn_port, CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,(void *)&ftp_prev_ctrl_port, sizeof(USHORT));
   get_parameter(CM_PROXY_SECTION, (void*)&proxy_server.ftp_data_conn_port, CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,(void *)&ftp_prev_data_port, sizeof(USHORT));

	proxy_ftp_entries_to_add = (CHANGE_FTP_PORTS_PARAMS_form_output_type*) form_data_of_request(request);

	sscanf(proxy_ftp_entries_to_add->ftp_ctrl_port, "%05d", &ctrl_port);
	sscanf(proxy_ftp_entries_to_add->ftp_data_port, "%05d", &data_port);

printf("\n\rPROXY: ctrl port is %s, %d, data port is %s, %d", 
proxy_ftp_entries_to_add->ftp_ctrl_port, ctrl_port, 
proxy_ftp_entries_to_add->ftp_data_port, data_port);

	ctrl_port = atoi(proxy_ftp_entries_to_add->ftp_ctrl_port);
	data_port = atoi(proxy_ftp_entries_to_add->ftp_data_port);
		
printf("\n\rPROXY: ctrl port is %d, data port is %d", ctrl_port, data_port);

	if (!*proxy_ftp_entries_to_add->ftp_ctrl_port)
	{
		printf("\n\rPROXY: Invalid Control Port.");
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
		
	if (!*proxy_ftp_entries_to_add->ftp_data_port)
	{
		printf("\n\rPROXY: Invalid Data Port.");
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if ((IsStrNumericAndValid(proxy_ftp_entries_to_add->ftp_ctrl_port) == FALSE) || (ctrl_port == 0))
	{
		printf("\n\rUnknown Port type %d.Re-Enter value from 1 to 65535.", ctrl_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if ((is_user_defined_port_not_in_reserved_port_list(ctrl_port, higher_port) == FALSE) 
		&& (ctrl_port != ftp_prev_ctrl_port) && (ctrl_port != ftp_prev_data_port))
	{
		printf ("\n\rEntered value %d conflict with reserved port entries.", ctrl_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	result = is_user_defined_port_range_unique(ctrl_port, higher_port, protocol);
	if (( result == PROXY_ENTRY )	&& 
		(ctrl_port != ftp_prev_ctrl_port) && 
			(ctrl_port != ftp_prev_data_port))
	{
		printf ("\n\r\Entered value %d conflict with proxy port entries.", ctrl_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	else if (( result == PROXY_RANGE_ENTRY ) &&
		(ctrl_port != ftp_prev_ctrl_port) && 
			(ctrl_port != ftp_prev_data_port))
	{
		printf("\n\r\Entered value %d conflict with proxy port range entries.", ctrl_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if(ctrl_port == data_port)
	{
		printf("\n\rPROXY: Control & data port %d are the same.",ctrl_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if ((IsStrNumericAndValid(proxy_ftp_entries_to_add->ftp_data_port) == FALSE) || (data_port == 0))
	{
		printf("\n\rUnknown Port type %d.Re-Enter value from 1 to 65535.", data_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if ((is_user_defined_port_not_in_reserved_port_list(data_port, higher_port) == FALSE) 
		&& (data_port != ftp_prev_ctrl_port) && (data_port != ftp_prev_data_port))
	{
		printf ("\n\rEntered value %d conflict with reserved port entries.", data_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	result = is_user_defined_port_range_unique(data_port, higher_port, protocol);
	if (( result == PROXY_ENTRY )	&& 
		(data_port != ftp_prev_ctrl_port) && 
			(data_port != ftp_prev_data_port))
	{
		printf ("\n\r\Entered value %d conflict with proxy port entries.", data_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	else if (( result == PROXY_RANGE_ENTRY ) &&
		(data_port != ftp_prev_ctrl_port) && 
			(data_port != ftp_prev_data_port))
	{
		printf("\n\r\Entered value %d conflict with proxy port range entries.", data_port);
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	set_parameter (CM_PROXY_SECTION,&proxy_server.ftp_ctrl_conn_port,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, (void *)&ctrl_port);

	set_parameter (CM_PROXY_SECTION,&proxy_server.ftp_data_conn_port,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, (void *)&data_port);

	ptr_to_old_proxy_app.protocol = 0; /* TCP_PROTOCOL */
	ptr_to_old_proxy_app.port = ftp_prev_ctrl_port;

	ptr_to_new_proxy_app.protocol = 0; /* TCP_PROTOCOL */
	ptr_to_new_proxy_app.port = ctrl_port;

   cm_edit_string (CM_PROXY_SECTION, "Proxy", (void *)&ptr_to_old_proxy_app,(void *) &ptr_to_new_proxy_app);

	ptr_to_old_proxy_app.protocol = 1; /* UDP_PROTOCOL */
	ptr_to_new_proxy_app.protocol = 1; /* UDP_PROTOCOL */

	cm_edit_string (CM_PROXY_SECTION, "Proxy", (void *)&ptr_to_old_proxy_app,(void *) &ptr_to_new_proxy_app);

	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	return;
}

void display_page_to_add_proxy_entry(Request_t* request)
{
   USHORT search_to_start_at=0;   
   BYTE* buffer;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	buffer =  (BYTE*)malloc(strlen(ADD_PROXY_ENTRY_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
	strcpy(buffer, ADD_PROXY_ENTRY_data_ptr);
	/* Added By Ravi on 06 Nov 1998 ... */
   search_to_start_at = get_value_and_handle_error_1(CM_PROXY_SECTION, (void*)&proxy_server.proxy_any_application_enabled, CM_NO_PORT_PARAMETER_PRESENT, "Proxy Any Application", search_to_start_at, buffer);

	/* Brindha &  Neelu  on 29/1/99 */
	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* Range Enabled */
	/* ... Added By Ravi on 06 Nov 1998 */
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);

	/* Neelu & Brindha on 29/1/99 */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Higher Port */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Description */

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

/* Neelu & Brindha on 29/1/99 */
void display_ved_proxy_entry_page(Request_t* request)
{
	STRUCT_PROXY_ENTRY temp_proxy_entry;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	entry_type = RESERVED_ENTRY; 		
	ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	if (ptr_to_start_of_proxy_entries[entry_type])
		total_proxy_entries[entry_type] = get_the_number_of_proxy_entries();

	if (!total_proxy_entries[entry_type])
	{
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	
	}

	proxy_entries_till_current_page[entry_type] = 0;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE);
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE);
	next_proxy_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_proxy_entries[entry_type], TRUE);
	display_next_ten_proxy_entries(request);
}

/* Neelu & Brindha on 29/1/99 */
void display_ved_proxy_user_entry_page(Request_t* request)
{
	STRUCT_PROXY_USER_ENTRY temp_proxy_user_entry;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	entry_type = USER_ENTRY; 		
	total_proxy_entries[entry_type] = 0;
	
	ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = cm_get_first_entry(CM_PROXY_SECTION, "Proxy User App", (void*)&temp_proxy_user_entry);
	if (ptr_to_start_of_proxy_entries[entry_type] != NULL)
		total_proxy_entries[entry_type] = get_the_number_of_proxy_user_entries();
				
	printf("\n Total Number of User Defined Entries : %d", total_proxy_entries[entry_type]);

	if (total_proxy_entries[entry_type] == 0)
	{
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	
	}

	proxy_entries_till_current_page[entry_type] = 0;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE);
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE);
	next_proxy_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_proxy_entries[entry_type], TRUE);
	display_next_ten_proxy_entries(request);
}


BYTE display_port_list_called_from(BYTE new_value, BYTE is_to_save)
{
   static BYTE value = 0;
   if (is_to_save)
      value = new_value;
   else
      return value;
}


void add_the_proxy_entry(Request_t* request)
{
	PARAMETER_NODE* new_node;
	ADD_PROXY_ENTRY_form_output_type*  proxy_entry_to_add;
/*	ADD_PROXY_USER_ENTRY_form_output_type*  proxy_user_entry_to_add;*/
	ULONG temp_value=0,temp_value1=0;
   int unique_entry;
	STRUCT_PROXY_ENTRY proxy_entry;
	STRUCT_PROXY_USER_ENTRY proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			

proxy_entry_to_add = (ADD_PROXY_ENTRY_form_output_type*) form_data_of_request(request);

   
	/* Added By Ravi on 06 Nov 1998 ... */
   set_value_and_handle_error_1(CM_PROXY_SECTION, (void*)&proxy_server.proxy_any_application_enabled, CM_NO_PORT_PARAMETER_PRESENT, (void *)&proxy_entry_to_add->proxy_any_application, "Proxy Any Application") ;
	/* ... Added By Ravi on 06 Nov 1998 */

   if (!strcmpi(proxy_entry_to_add->choose, "Choose From List..."))
   {
      display_port_list_called_from(ADD_ENTRY, TRUE);
/*      if (!(proxy_entry_to_add->protocol))
         display_the_list_for_tcp(request);
      else
         display_the_list_for_udp(request);*/
   
      display_the_list_for_tcp(request);
      return;
   }

	/* Neelu on 27/1/99 */
/*	printf("%s  %s",proxy_entry_to_add->lower_port,proxy_entry_to_add->higher_port);*/
	sscanf(proxy_entry_to_add->lower_port, "%d", &temp_value);

	if(proxy_entry_to_add->higher_port == NULL || !proxy_entry_to_add->range_enable)
		proxy_entry_to_add->higher_port = 0; 

	
	sscanf(proxy_entry_to_add->higher_port, "%d", &temp_value1);
/*	printf("low %d   high %d",temp_value,temp_value1);*/
  	
	
	if (is_user_defined_port_not_in_reserved_port_list(temp_value , temp_value1))
	{
		if (!is_numeric(proxy_entry_to_add->lower_port))
   	{
   		printf("1:Invalid Port Number Failed to add Proxy Entry\n");
			InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
			return;
		}
		
		entry_type = USER_ENTRY;
      if (proxy_entry_to_add->range_enable)
      {
		
			if (!is_numeric(proxy_entry_to_add->higher_port))
   	   {
      	   printf("2:Invalid Higher Port Number Failed to add Proxy Entry\n");
   		   InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	         return;
   	   }
			unique_entry= (is_user_defined_port_range_unique(temp_value,temp_value1,proxy_entry_to_add->protocol));
/*		   printf("unique_entry=%d",unique_entry);*/
			if (unique_entry != UNIQUE_ENTRY)
		   {
      	   printf("4:User Defined Port Range isnt Unique Failed to add Proxy User Entry\n");
   		   InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	         return;
   	   }

		   proxy_user_entry.lower_port = atoi(proxy_entry_to_add->lower_port);
		   proxy_user_entry.higher_port = atoi(proxy_entry_to_add->higher_port);

		   strcpy(proxy_user_entry.descrptn, proxy_entry_to_add->descrptn);

		   if (proxy_entry_to_add->tcp_protocol)
		   {
			   proxy_user_entry.protocol = 0 ;

			   new_node = cm_insert_string(CM_PROXY_SECTION, "Proxy User App", (void*)&proxy_user_entry);
			   if (new_node == NULL)
			   {
				   printf("5:Failed to Insert the Proxy User Entry\n");
/*				   InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
				   return;*/
			   }

			   if (ptr_to_start_of_proxy_entries[entry_type] == NULL)
				    ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = new_node; 

			      total_proxy_entries[entry_type] ++;
		   }
	
		   if (proxy_entry_to_add->udp_protocol)
		   {
			   proxy_user_entry.protocol = 1 ;

			   new_node = cm_insert_string(CM_PROXY_SECTION, "Proxy User App", (void*)&proxy_user_entry);
			   if (new_node == NULL)
			   {
				   printf("6:Failed to Insert the Proxy User Entry\n");
				   InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
				   return;
			   }

			   if (ptr_to_start_of_proxy_entries[entry_type] == NULL)
	 				ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = new_node; 

			   total_proxy_entries[entry_type] ++;
      
         }
      }
      else
      {
			unique_entry= (is_user_defined_port_range_unique(temp_value,temp_value1,proxy_entry_to_add->protocol));
/*		   printf("unique_entry=%d",unique_entry);*/
			if (unique_entry != UNIQUE_ENTRY)
		   {
      	   printf("13:User Defined Port Range isnt Unique Failed to add Proxy User Entry\n");
   		   InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	         return;
   	   }
			
			proxy_user_entry.lower_port = atoi(proxy_entry_to_add->lower_port);
			proxy_user_entry.higher_port = 0;

			strcpy(proxy_user_entry.descrptn, proxy_entry_to_add->descrptn);

			if (proxy_entry_to_add->tcp_protocol)
			{
				proxy_user_entry.protocol = 0 ;

				new_node = cm_insert_string(CM_PROXY_SECTION, "Proxy User App", (void*)&proxy_user_entry);
				if (new_node == NULL)
				{
					printf("8:Failed to Insert the Proxy User Entry\n");
/*					InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
					return;*/
				}

				if (ptr_to_start_of_proxy_entries[entry_type] == NULL)
					ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = new_node; 

				total_proxy_entries[entry_type] ++;
			}
	
			if (proxy_entry_to_add->udp_protocol)
			{
				proxy_user_entry.protocol = 1 ;

				new_node = cm_insert_string(CM_PROXY_SECTION, "Proxy User App", (void*)&proxy_user_entry);
				if (new_node == NULL)
				{
					printf("9:Failed to Insert the Proxy User Entry\n");
					InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
					return;
				}

				if (ptr_to_start_of_proxy_entries[entry_type] == NULL)
					ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = new_node;

				total_proxy_entries[entry_type] ++;
         }
      }
   }
   else
   {
			entry_type = RESERVED_ENTRY;
			proxy_entry.port = atoi(proxy_entry_to_add->lower_port);

			/* Added By Ravi on 06 Nov 1998 ... */
			if (proxy_entry_to_add->tcp_protocol)
			{
				proxy_entry.protocol = 0 ;

				new_node = cm_insert_string(CM_PROXY_SECTION, "Proxy", (void*)&proxy_entry);
				if (new_node == NULL)
				{
					printf("10:Failed to Insert the Proxy Entry\n");
/*					InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
					return;*/
				}

				if (ptr_to_start_of_proxy_entries[entry_type] == NULL)
					ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = new_node;
				total_proxy_entries[entry_type] ++;
			}
	
			if (proxy_entry_to_add->udp_protocol)
			{
				proxy_entry.protocol = 1 ;

				new_node = cm_insert_string(CM_PROXY_SECTION, "Proxy", (void*)&proxy_entry);
				if (new_node == NULL)
				{
					printf("11:Failed to Insert the Proxy Entry\n");
					InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
					return;
				}

				if (ptr_to_start_of_proxy_entries[entry_type] == NULL)
					ptr_to_first_proxy_entry_of_current_page[entry_type] = ptr_to_start_of_proxy_entries[entry_type] = new_node;
				total_proxy_entries[entry_type] ++;
			}
   }
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}   


void display_the_list_for_tcp(Request_t* request)
{
	USHORT ctrl_port = 0, data_port = 0;
	char c_port[10], d_port[10];

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	get_ftp_port_numbers(&ctrl_port, &data_port);
	sprintf(c_port,"%d", ctrl_port);
	sprintf(d_port,"%d", data_port);

	search_and_replace("#CTRL#", c_port, TCP_LIST_data_ptr, TRUE, 0);
	search_and_replace("#DATA#", d_port, TCP_LIST_data_ptr, TRUE, 0);
   InitReturnBuffer(request, TCP_LIST_data_ptr, strlen(TCP_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_the_list_for_udp(Request_t* request)
{
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   InitReturnBuffer(request, UDP_LIST_data_ptr, strlen(UDP_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void select_the_port_from_tcp_port_list(Request_t* request)
{
   TCP_LIST_form_output_type* selected_port;
   BYTE name[80], *buffer;
   USHORT search_to_start_at, reserved_port_number = 0;
	USHORT def_protocol = 0x0006; /* TCP_PROTOCOL */

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   selected_port = (TCP_LIST_form_output_type*)form_data_of_request(request);

/* sudha 23 Aug 1999 */
  /* sprintf(name, "%d", names_lib[selected_port->port].port_number); */
  	reserved_port_number = get_protocol_port_number(def_protocol, selected_port->port+1);
   sprintf(name, "%d", reserved_port_number);

   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	buffer = malloc(strlen(ADD_PROXY_ENTRY_data_ptr));
   }
   else
   {
   	buffer = malloc(strlen(EDIT_PROXY_ENTRY_data_ptr));
   }

	if (buffer == NULL)
	{
		printf("Out Of memory to display page for Proxy Entry \n");
		return;
	}
   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	strcpy(buffer, ADD_PROXY_ENTRY_data_ptr);
   }
   else
   {
   	strcpy(buffer, EDIT_PROXY_ENTRY_data_ptr);
   }

	if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
	{
		search_to_start_at = get_value_and_handle_error_1(CM_PROXY_SECTION, (void*)&proxy_server.proxy_any_application_enabled, CM_NO_PORT_PARAMETER_PRESENT, "Proxy Any Application", search_to_start_at, buffer);
   	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at); 
   	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at); 
   	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at); 
   	search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at);
   	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
   	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
	}
	else
	{
		search_to_start_at = search_and_replace("#SRE", "<!--", buffer, TRUE, 0); 
		search_to_start_at = search_and_replace("#ERE", "-->", buffer, TRUE, search_to_start_at); 
   	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at); 
   	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at); 
   	search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at);
		search_to_start_at = search_and_replace("#SCL", "", buffer, TRUE, search_to_start_at); 
		search_to_start_at = search_and_replace("#ECL", "", buffer, TRUE, search_to_start_at); 
   	search_to_start_at = search_and_replace("#SHP", "<!--", buffer, TRUE, search_to_start_at); 
		search_to_start_at = search_and_replace("#EHP", "-->", buffer, TRUE, search_to_start_at); 
		search_to_start_at = search_and_replace("#SUD", "<!--", buffer, TRUE, search_to_start_at); 
		search_to_start_at = search_and_replace("#EUD", "-->", buffer, TRUE, search_to_start_at); 
	}

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void select_the_port_from_udp_port_list(Request_t* request)
{
   UDP_LIST_form_output_type* selected_port;
   BYTE name[80], *buffer;
   USHORT search_to_start_at, reserved_port_number = 0;
	USHORT def_protocol = 0x0011; /* UDP_PROTOCOL */

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   selected_port = (UDP_LIST_form_output_type*)form_data_of_request(request);
/* sudha 23 Aug 1999 */
	reserved_port_number = get_protocol_port_number(def_protocol, selected_port->port+1);
   sprintf(name, "%d", reserved_port_number);

/*   sprintf(name, "%d", names_lib[selected_port->port].port_number); */

   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	buffer = malloc(strlen(ADD_PROXY_ENTRY_data_ptr));
   }
   else
   {
   	buffer = malloc(strlen(EDIT_PROXY_ENTRY_data_ptr));
   }
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	strcpy(buffer, ADD_PROXY_ENTRY_data_ptr);
   }
   else
   {
   	strcpy(buffer, EDIT_PROXY_ENTRY_data_ptr);
   }

   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, FALSE, 0); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void match_the_port_number_to_name(USHORT port_number, BYTE* name)
{
   BYTE i = 0;

/* sudha 23 Aug 1999 */
#if 0
   while (names_lib[i].port_number != 0)
   {
      if (port_number == names_lib[i].port_number)
      {
         sprintf(name, "%s(%d)", names_lib[i].name, names_lib[i].port_number);
         return;
      }
      i++;
   }
   sprintf(name, "%d", port_number);
#endif
}
/* Brindha & Neelu on 29/1/99 */
void write_the_port_number_and_name(USHORT lower_port_number, USHORT higher_port_number, BYTE description[25], BYTE* name)
{
	 if (higher_port_number)  /* if higher_port != 0 */
	 	sprintf(name, "%s(%d,%d)", description, lower_port_number, higher_port_number);
	 else
	 	sprintf(name, "%s(%d)", description, lower_port_number);
}


void delete_the_proxy_entry(Request_t* request)
{
	BYTE index;
	PARAMETER_NODE* node, *prev_first_node_of_the_page;
	STRUCT_PROXY_ENTRY proxy_entry;
	STRUCT_PROXY_USER_ENTRY proxy_user_entry;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	index = save_the_number_of_proxy_entry_being_edited(NULL, FALSE);
	if (index == 1)
	{
		prev_first_node_of_the_page = first_proxy_entry_of_the_current_page(NULL, FALSE);
		if(entry_type == RESERVED_ENTRY)
			node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&proxy_entry);
		else
			node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy User App", (void*)&proxy_user_entry);
			
		while (node != prev_first_node_of_the_page)
		{
			if(entry_type == RESERVED_ENTRY)
				node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_entry);
			else
				node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_user_entry);
		}

		if(entry_type == RESERVED_ENTRY)
			node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_entry);
		else
			node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_user_entry);

		if (node != NULL)
			first_proxy_entry_of_the_current_page(node, TRUE);
	}
	remove_a_perticular_proxy_entry(index);
	if (total_proxy_entries[entry_type] == 0)
	{
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void remove_a_perticular_proxy_entry(USHORT index)
{
	STRUCT_PROXY_ENTRY proxy_entry;
	STRUCT_PROXY_USER_ENTRY proxy_user_entry;
  
	PARAMETER_NODE* last_displayed_proxy_entry;
	
	if(entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[index-1];
   	if (contents_of_proxy_entry_page[index-1].protocol == 6)
      	proxy_entry.protocol = 0;
      else
      	proxy_entry.protocol = 1;

		if (cm_remove_string(CM_PROXY_SECTION, "Proxy", (void*)&proxy_entry) != CM_REMOVING_STRING_SUCCESSFUL)
		{
			printf("Failed to remove the Proxy Entry\n");
			return;
		}
	}
	else
	{
		proxy_user_entry = contents_of_proxy_user_entry_page[index-1];
		if (contents_of_proxy_user_entry_page[index-1].protocol == 6)
      	proxy_user_entry.protocol = 0;
      else
      	proxy_user_entry.protocol = 1;

		if (cm_remove_string(CM_PROXY_SECTION, "Proxy User App", (void*)&proxy_user_entry) != CM_REMOVING_STRING_SUCCESSFUL)
		{
			printf("Failed to remove the Proxy User Entry\n");
			return;
		}
	}
	last_displayed_proxy_entry = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	
	if (index == 10)
	{
		if (proxy_entries_till_current_page[entry_type] == total_proxy_entries[entry_type])
		{
			last_displayed_proxy_entry = last_displayed_proxy_entry->previous;
			proxy_entries_till_current_page[entry_type] --;
		}
		else
		{
			last_displayed_proxy_entry = last_displayed_proxy_entry->next;
		}
	}
	else
	if (index == total_proxy_entries[entry_type])
	{
			last_displayed_proxy_entry = last_displayed_proxy_entry->previous;
			proxy_entries_till_current_page[entry_type] --;
	}
	else
	if(proxy_entries_till_current_page[entry_type] < 10)
	{
			proxy_entries_till_current_page[entry_type] --;
	}
	next_proxy_entry_from_where_display_is_reqd_to_continue(last_displayed_proxy_entry, TRUE);

	total_proxy_entries[entry_type] --;
/*	total_proxy_entries = get_the_number_of_proxy_entries();*/


	/* if the first node is deleted take care */
	if (total_proxy_entries[entry_type] == 0)
	{
		ptr_to_start_of_proxy_entries[entry_type] = NULL;	
		return;
	}
	if (proxy_entries_till_current_page[entry_type]  <= 10 && index == 1)
	{
		 ptr_to_start_of_proxy_entries[entry_type] = ptr_to_start_of_proxy_entries->next;
	}
}

/* Brindha & Neelu on 29/1/99 */
void display_the_proxy_entry_for_editing(Request_t* request, STRUCT_PROXY_ENTRY* proxy_entry)
{
	BYTE* buffer, temp_buffer[20];
	USHORT search_to_start_at;

	buffer = malloc(strlen(EDIT_PROXY_ENTRY_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display a Proxy Entry for editing\n");
		return;
	}
	strcpy(buffer, EDIT_PROXY_ENTRY_data_ptr);

	search_to_start_at = search_and_replace("#SRE", "<!--", buffer, TRUE, 0); 
	search_to_start_at = search_and_replace("#ERE", "-->", buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, proxy_entry->protocol == 0x0006, search_to_start_at); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, proxy_entry->protocol == 0x0011, search_to_start_at); 
   sprintf(temp_buffer, "%d", proxy_entry->port);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#SCL", "", buffer, TRUE, search_to_start_at); 
	search_to_start_at = search_and_replace("#ECL", "", buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#SHP", "<!--", buffer, TRUE, search_to_start_at); 
	search_to_start_at = search_and_replace("#EHP", "-->", buffer, TRUE, search_to_start_at); 
	search_to_start_at = search_and_replace("#SUD", "<!--", buffer, TRUE, search_to_start_at); 
	search_to_start_at = search_and_replace("#EUD", "-->", buffer, TRUE, search_to_start_at); 
   
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

/* Brindha & Neelu on 29/1/99 */
void display_the_proxy_user_entry_for_editing(Request_t* request, STRUCT_PROXY_USER_ENTRY* proxy_user_entry)
{
	BYTE* buffer, temp_buffer[20];
	USHORT search_to_start_at;

	buffer = malloc(strlen(EDIT_PROXY_ENTRY_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display a Proxy Entry for editing\n");
		return;
	}
	strcpy(buffer, EDIT_PROXY_ENTRY_data_ptr);

	if (proxy_user_entry->higher_port)
	{
		search_to_start_at = search_and_replace("#SRE", "", buffer, TRUE, 0); 
		search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 	
		search_to_start_at = search_and_replace("#ERE", "", buffer, TRUE, search_to_start_at); 
	}
	else
	{
		search_to_start_at = search_and_replace("#SRE", "<!--", buffer, TRUE, 0); 
		/* search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, FALSE, search_to_start_at); 	 */
		search_to_start_at = search_and_replace("#ERE", "-->", buffer, TRUE, search_to_start_at); 
	}

   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, proxy_user_entry->protocol == 0x0006, search_to_start_at); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, proxy_user_entry->protocol == 0x0011, search_to_start_at); 
   sprintf(temp_buffer, "%d", proxy_user_entry->lower_port);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer, buffer, TRUE, search_to_start_at);

	search_to_start_at = search_and_replace("#SCL", "<!--", buffer, TRUE, search_to_start_at); 
	search_to_start_at = search_and_replace("#ECL", "-->", buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#SHP", "", buffer, TRUE, search_to_start_at); 
	sprintf(temp_buffer, "%d", proxy_user_entry->higher_port);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#EHP", "", buffer, TRUE, search_to_start_at); 
	search_to_start_at = search_and_replace("#SUD", "", buffer, TRUE, search_to_start_at); 
	sprintf(temp_buffer, "%s", proxy_user_entry->descrptn);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#EUD", "", buffer, TRUE, search_to_start_at); 

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}


void display_edit_proxy_entry_1(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[0];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[0];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(1, TRUE);
}


void display_edit_proxy_entry_2(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[1];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[1];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(2, TRUE);
}

void display_edit_proxy_entry_3(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[2];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[2];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(3, TRUE);
}

void display_edit_proxy_entry_4(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[3];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[3];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(4, TRUE);
}

void display_edit_proxy_entry_5(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[4];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[4];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(5, TRUE);
}

void display_edit_proxy_entry_6(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[5];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[5];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(6, TRUE);
}

void display_edit_proxy_entry_7(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[6];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[6];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(7, TRUE);
}

void display_edit_proxy_entry_8(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[7];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[7];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(8, TRUE);
}

void display_edit_proxy_entry_9(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[8];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[8];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(9, TRUE);
}


void display_edit_proxy_entry_10(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;
	STRUCT_PROXY_USER_ENTRY  proxy_user_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (entry_type == RESERVED_ENTRY)
	{
		proxy_entry = contents_of_proxy_entry_page[9];
		display_the_proxy_entry_for_editing(request, &proxy_entry);
	}
	else
	{
	  proxy_user_entry = contents_of_proxy_user_entry_page[9];
	  display_the_proxy_user_entry_for_editing(request, &proxy_user_entry);
	}


	save_the_number_of_proxy_entry_being_edited(10, TRUE);
}


void display_next_ten_proxy_entries(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	display_ten_proxy_entries_from(request, temp_ptr, TRUE);
}

void display_prev_ten_proxy_entries(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (proxy_entries_till_current_page[entry_type] <= 2*NUMBER_OF_ENTRIES_PER_PAGE)
	{
		for(i=1;i<proxy_entries_till_current_page[entry_type];++i)
		{
			temp_ptr = cm_get_previous_entry(CM_PROXY_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		proxy_entries_till_current_page[entry_type] = 0;
	}
	else
	{
		for(i=1;i<NUMBER_OF_ENTRIES_PER_PAGE+(proxy_entries_till_current_page[entry_type]%NUMBER_OF_ENTRIES_PER_PAGE?proxy_entries_till_current_page[entry_type]:NUMBER_OF_ENTRIES_PER_PAGE);++i)
		{
			temp_ptr = cm_get_previous_entry(CM_PROXY_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		proxy_entries_till_current_page[entry_type] -= (NUMBER_OF_ENTRIES_PER_PAGE+(proxy_entries_till_current_page[entry_type]%NUMBER_OF_ENTRIES_PER_PAGE?proxy_entries_till_current_page[entry_type]:NUMBER_OF_ENTRIES_PER_PAGE));
	}
	display_ten_proxy_entries_from(request, temp_ptr, TRUE);
}

void display_ten_proxy_entries_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page;
	USHORT i, search_to_start_at = 0;
	STRUCT_PROXY_ENTRY temp_proxy_entry;
	STRUCT_PROXY_USER_ENTRY temp_proxy_user_entry;
	PARAMETER_NODE* node, *prev_node;
	static BYTE number_of_entries_read_in_the_current_node = 0;

	first_proxy_entry_of_the_current_page(starting_from, TRUE);

	if(proxy_entries_till_current_page[entry_type]  == total_proxy_entries[entry_type])
	{
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	temp_page = malloc(strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr));

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display Proxy Entry list.\n");
		return;
	}

	strcpy(temp_page, VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr);


	if (entry_type == RESERVED_ENTRY)
		node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	else
		node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy User App", (void*)&temp_proxy_user_entry);
	if (node == starting_from)
		number_of_entries_read_in_the_current_node = 0;
	while (node != starting_from)
	{
		if (entry_type == RESERVED_ENTRY)
			node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_entry);
	   else
			node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_user_entry);
	}
	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i=0; i<number_of_entries_read_in_the_current_node ;++i)
		{
			if (!node)
			{
				return;
			}
			if (entry_type == RESERVED_ENTRY)
				node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_entry);
	   	else
				node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_user_entry);
		}
	}
	number_of_entries_read_in_the_current_node = 0;
	prev_node = starting_from;

	for(i=0;i < NUMBER_OF_ENTRIES_PER_PAGE;++i)
	{
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		if (entry_type == RESERVED_ENTRY)
		{
			search_to_start_at = modify_the_proxy_entry_template(temp_page, &temp_proxy_entry, search_to_start_at);
			contents_of_proxy_entry_page[i] =  temp_proxy_entry;
		}
		else
		{
			search_to_start_at = modify_the_proxy_user_entry_template(temp_page, &temp_proxy_user_entry, search_to_start_at);
			contents_of_proxy_user_entry_page[i] =  temp_proxy_user_entry;
		}

		proxy_entries_till_current_page[entry_type]++;
		if ((proxy_entries_till_current_page[entry_type]  == total_proxy_entries[entry_type] && is_displaying_next_page)
		    || (proxy_entries_till_current_page[entry_type]  == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_proxy_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE);

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(i+1, search_to_start_at, temp_page);
			if (is_displaying_next_page)
			{
				/* if some Proxy Entry in the previous page enable the link hence disable */

				/* No More Proxy Entries are there hence remove the link */
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			else
			{
				/* while displaying if we each first page just remove back link */

				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_proxy_entries[entry_type] > NUMBER_OF_ENTRIES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at);
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
		if (is_displaying_next_page)
		{
			if (entry_type == RESERVED_ENTRY)
				starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&temp_proxy_entry);
			else
				starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&temp_proxy_user_entry);
/*			proxy_entries_till_current_page++;*/
		}
		else
		{
			starting_from = cm_get_previous_entry(CM_PROXY_SECTION, starting_from, NULL);
			proxy_entries_till_current_page[entry_type]--;
		}
		if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++;
		else
			number_of_entries_read_in_the_current_node = 0;
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(i+1, search_to_start_at, temp_page);
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at);

	/* Save the lastly displayed node */
	next_proxy_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE);

	/* Check if back link is required or not */

	/* Check if forward link is required or not */
	if (total_proxy_entries[entry_type] > proxy_entries_till_current_page[entry_type])
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at);
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);

	InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}
/*
void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node)
{
	USHORT i=0, j=0;

	if (node == NULL)
	{
		buffer[0] = 0;
		return;
	}

	while(node->parameter[i] != '=')
	{
		++i;
	}
  	i+=2;
	while(node->parameter[i] != '\0' &&	node->parameter[i] != '\n' && node->parameter[i] != '\r')
		buffer[j++] = node->parameter[i++];
  buffer[j] = 0;
}
*/
USHORT modify_the_proxy_entry_template(BYTE* buffer, STRUCT_PROXY_ENTRY* proxy_entry, USHORT search_to_start_at)
{
   BYTE temp_buffer[100], app_type[50];

   if (proxy_entry->protocol == 0x0006)
      strcpy(temp_buffer, "TCP");
   else
      strcpy(temp_buffer, "UDP");

	search_to_start_at = search_and_replace("#_PRT", temp_buffer, buffer, TRUE, 0);
/* sudha 23 Aug 1999 */
	strcpy(app_type, get_port_type(app_type,proxy_entry->protocol,proxy_entry->port));
	sprintf(temp_buffer, "%s(%d)", app_type, proxy_entry->port);
   /* match_the_port_number_to_name(proxy_entry->port, temp_buffer); */
	search_to_start_at = search_and_replace("#_______________________________________________________PORT", temp_buffer, buffer, TRUE, 0);
   return (search_to_start_at);
}
/* Brindha & Neelu on 29/1/99 */
USHORT modify_the_proxy_user_entry_template(BYTE* buffer, STRUCT_PROXY_USER_ENTRY* proxy_user_entry, USHORT search_to_start_at)
{
   BYTE temp_buffer[100];

   if (proxy_user_entry->protocol == 0x0006)
      strcpy(temp_buffer, "TCP");
   else
      strcpy(temp_buffer, "UDP");

	search_to_start_at = search_and_replace("#_PRT", temp_buffer, buffer, TRUE, 0);
   write_the_port_number_and_name(proxy_user_entry->lower_port, proxy_user_entry->higher_port, proxy_user_entry->descrptn, temp_buffer);
	search_to_start_at = search_and_replace("#_______________________________________________________PORT", temp_buffer, buffer, TRUE, 0);
   return (search_to_start_at);
}

USHORT get_the_number_of_proxy_entries()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	STRUCT_PROXY_ENTRY temp_proxy_entry;

	node = cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	while (node != NULL)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_entry);
		count ++;	
	}
	return count;
}
/* Brindha &  Neelu on 29/1/99 */
USHORT get_the_number_of_proxy_user_entries()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	STRUCT_PROXY_USER_ENTRY temp_proxy_user_entry;

	node = cm_get_first_entry(CM_PROXY_SECTION, "Proxy User App", (void*)&temp_proxy_user_entry);
	while (node != NULL)
	{
		printf("\n User Entries are Present");
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_user_entry);
		count ++;	
	}
	return count;
}


void change_the_edited_proxy_entry(Request_t* request)
{
	EDIT_PROXY_ENTRY_form_output_type* edited_proxy_entry;
	BYTE edited_proxy_entry_index;
	enum CM_EDIT_STRING_RESULTS result;
	STRUCT_PROXY_ENTRY new_proxy_entry, old_proxy_entry;
	STRUCT_PROXY_USER_ENTRY new_proxy_user_entry, old_proxy_user_entry;
	ULONG temp_value = 0,temp_value1 = 0;
   int unique_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	edited_proxy_entry = (EDIT_PROXY_ENTRY_form_output_type*)form_data_of_request(request);

	if (!strcmp(edited_proxy_entry->delete_entry, "Delete"))
	{
		delete_the_proxy_entry(request);
		return;
	}

   if (!strcmpi(edited_proxy_entry->choose, "Choose From List..."))
   {
      display_port_list_called_from(EDIT_ENTRY, TRUE);
/*      if (!(edited_proxy_entry->protocol))
         display_the_list_for_tcp(request);
      else
         display_the_list_for_udp(request);*/

      display_the_list_for_tcp(request);
      return;
   }

	if (entry_type == RESERVED_ENTRY)
	{
   	if (!is_numeric(edited_proxy_entry->lower_port))
   	{
      	printf("Invalid Port Number Failed to change Proxy Entry\n");
   		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      	return;
   	}

		edited_proxy_entry_index = save_the_number_of_proxy_entry_being_edited(NULL, FALSE);
		old_proxy_entry = contents_of_proxy_entry_page[edited_proxy_entry_index-1];
  	 	if (old_proxy_entry.protocol == 6)
      	old_proxy_entry.protocol = 0;
   	else
      	old_proxy_entry.protocol = 1;

		new_proxy_entry.protocol = edited_proxy_entry->protocol;
		new_proxy_entry.port = atoi(edited_proxy_entry->lower_port);

   	result = cm_edit_string(CM_PROXY_SECTION, "Proxy", (void*)&old_proxy_entry, (void*)&new_proxy_entry);
		if (result != CM_STRING_EDIT_SUCCESSFUL)
		{
			printf("Configuration manager refused to make the changes \n");
		}
	}
	else
	{
   	if (!is_numeric(edited_proxy_entry->lower_port))
   	{
      	printf("Invalid Port Number Failed to change Proxy Entry\n");
   		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      	return;
   	}

   	if (!is_numeric(edited_proxy_entry->higher_port))
   	{
      	printf("Invalid Port Number Failed to change Proxy Entry\n");
   		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      	return;
   	}
		
		edited_proxy_entry_index = save_the_number_of_proxy_entry_being_edited(NULL, FALSE);
		old_proxy_user_entry = contents_of_proxy_user_entry_page[edited_proxy_entry_index-1];
  	 	if (old_proxy_user_entry.protocol == 6)
      	old_proxy_user_entry.protocol = 0;
   	else
      	old_proxy_user_entry.protocol = 1;

		sscanf(edited_proxy_entry->lower_port, "%d", &temp_value);
		sscanf(edited_proxy_entry->higher_port, "%d", &temp_value1);
		printf("\nlow = %d,high = %d",temp_value,temp_value1);
		if (!is_user_defined_port_not_in_reserved_port_list(temp_value , temp_value1))
		{
			printf("User Defined Port Range is in Reserved Port List, Failed to Edit Proxy User Entry\n");
   		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	      return;
		}
		
		new_proxy_user_entry.protocol = edited_proxy_entry->protocol;
		new_proxy_user_entry.lower_port = atoi(edited_proxy_entry->lower_port);
		new_proxy_user_entry.higher_port = atoi(edited_proxy_entry->higher_port);
		strcpy(new_proxy_user_entry.descrptn, edited_proxy_entry->descrptn);

   	result = cm_edit_string(CM_PROXY_SECTION, "Proxy User App", (void*)&old_proxy_user_entry, (void*)&new_proxy_user_entry);
		if (result != CM_STRING_EDIT_SUCCESSFUL)
		{
			printf("Configuration manager refused to make the changes \n");
		}
		
	}
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < NUMBER_OF_ENTRIES_PER_PAGE - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

BYTE save_the_number_of_proxy_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}
#if 0 /* Function not used */
void go_back_to_proxy_entry_listing_page(Request_t* request)
{
	PARAMETER_NODE* temp_node;
	BYTE index;
	temp_node = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);

	index = (proxy_entries_till_current_page%10)?proxy_entries_till_current_page:NUMBER_OF_ENTRIES_PER_PAGE;

	temp_node = first_proxy_entry_of_the_current_page(NULL, FALSE);

	proxy_entries_till_current_page -= ((proxy_entries_till_current_page%10)?proxy_entries_till_current_page:NUMBER_OF_ENTRIES_PER_PAGE);
		
	next_proxy_entry_from_where_display_is_reqd_to_continue(temp_node, TRUE);
	display_next_ten_proxy_entries(request);
}
#endif


PARAMETER_NODE* next_proxy_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = last_node;
	else
		return saved_node;
} 

PARAMETER_NODE* first_proxy_entry_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = new_node;
	else
		return saved_node;
}

BYTE is_numeric(BYTE* buffer)
{
   BYTE i;
   for (i=0 ; i<strlen(buffer) ; ++i)
   {
      if (buffer[i] < '0' || buffer[i] > '9')
         return FALSE;
   }
   return TRUE;   
}


