#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include <redblack.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>

#include "\rtrware\rwutils\evntstr.h"
/* ... Naveen.P.N.*/

#include "..\..\..\..\stacks\ip\karp.h"
#include "..\..\..\..\stacks\ip\kip.h"
#include "..\..\..\..\stacks\ip\kipuser.h"
#include "..\..\..\..\stacks\ip\varpuser.h"
#include "..\..\..\..\stacks\ip\varpstr.h"
#include "..\..\..\..\stacks\ip\vrarpusr.h"
#include "..\..\..\..\stacks\ip\vrarpstr.h"
#include "..\..\..\..\stacks\ip\kroute.h"	  
#include "..\..\..\..\stacks\ip\viprtstr.h"	  
#include "..\..\..\..\stacks\ip\vipusstr.h"  
#include "..\..\..\..\stacks\ip\vsktstr.h"
#include "..\..\..\..\stacks\ip\kudp.h"
#include "..\..\..\..\stacks\ip\vipktstr.h"
#include "..\..\..\..\stacks\ip\kicmp.h"
#include "..\..\..\..\stacks\ip\vudpuser.h"
#include "..\..\..\..\stacks\ip\vudpbuf.h"
#include "..\..\..\..\stacks\ip\vudpstr.h"
#include "..\..\..\..\stacks\ip\krip.h"
#include "..\..\..\..\stacks\ip\vripstr.h"
#include "..\..\..\..\stacks\ip\vicmpstr.h"
#include "..\..\..\..\stacks\ip\viprastr.h"
#include "..\..\..\..\stacks\ip\vipstr.h" 
#include "..\..\..\userdata\kuser.h"
#include "..\..\..\userdata\vuserstr.h"

#include "..\..\..\sntp\ksntp.h"
#include "..\..\..\sntp\vsntpstr.h"
#include "..\..\..\sntp\vsntp.h"
#include "..\..\..\telnet\menufsm.h"

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"


#include "\rtrware\store\boot.h"
extern WEB_CLASS web;

ParseResults_t error_return = 
  { ATTACH_PROCESS_FUNCTION,  InitReturnUrlWasNotFound  , NULL } ;

#include "weburl.h"
#include "welcome.h"
#include "mainpage.h"
#include "display.h"
#include "frames.h"
#include "blank.h"
#include "blank1.h"

#include "advanppp.h"
#include "ip.h"
#include "advanip.h"

/* #include "ipx.h"
#include "advanipx.h"
#include "spantree.h" */

#include "wan.h"
/* #include "snmp.h" */
#include "applicat.h"
#include "ppp.h"
#include "filtmenu.h"  
#include "backlogo.h"
#include "mtslogo.h"
#include "mtrlogo.h"
#include "constrct.h" 

#include "adnpppfm.h"
#include "ipfm.h"
#include "advnipfm.h"

/* #include "ipxfm.h"
#include "adipxfm.h"
#include "spatrefm.h" */
 
#include "wanfm.h"
/* #include "snmpfm.h" */
#include "appfm.h"
#include "pppfm.h"

#include "authsucc.h"
#include "authfail.h"
#include "blankau.h"
#include "acdisabl.h"
#include "default.h"
#include "timerest.h"
#include "logon.h"
#include "logoff.h"
#include "userper.h"

#include "sntp.h"
#include "sntpfm.h"

#if 0

#include "igway.h"
#include "igwayfm.h"
#endif

#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"



/* Extern declerations ...*/
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern void		free_linked_list(PARAMETER_NODE* root);
extern void 	initialize_ip_params();
extern void 	get_the_values_for_the_port(BYTE port_number, struct_ip_config* port_values);

extern void  	initialize_spantree_params();
extern void  	initialize_wan_params();
extern void  	initialize_snmp_params();
extern void  	initialize_app_params();
extern USHORT 	get_value_and_handle_error_1(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_2(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_3(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_4(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_5(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_6(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_7(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_8(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_9(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_10(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_11(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_12(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_13(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer) ;

extern void    set_value_and_handle_error_1(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_2(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_3(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_4(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, void* new_value, BYTE* string);

extern enum CM_WRITE_RESULTS cm_write_configuration();
extern void cm_deinitialize_configuration_manager(enum CM_AGENT_TYPE agent_type);
extern void decrypt (char *src, char *dest) ;
extern void encrypt (char *src, char *dest) ;
extern BYTE *to_upper_string (BYTE*);
extern void append_quotes(BYTE* buffer);
extern BOOL flag_for_time_permission;
/* ... Extern Declerations*/

/* Local Prototypes ... */

void     display_welcome_page(Request_t* request) ;
void     display_standard_main_page(Request_t* request) ;
void     display_framed_main_page(Request_t* request) ;
void     display_blank_page(Request_t * request) ;
void 		fill_the_ip_form_with_appropriate_values(char* outputbuffer, BYTE port_number);
int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
void 		revert_back_form(char* buffer);
void 		replace_string_starting_from_index(BYTE* search_string, USHORT search_string_starting_index, char* replace_string, char* buffer);
USHORT 	disable_hyperlink_and_change_text_colour(USHORT port_type, BYTE* buffer);
void 		display_ip_page(Request_t* request, BYTE* buffer, BYTE port_number);
void 		check_for_need_and_hide_irrelevent_fields();
void 		show_the_hidden_fields();
void 		enable_hyperlink(USHORT replaced_anchor_index_in_the_buffer, BYTE* buffer);
void		make_changes_to_corresponding_port(enum ip_port_types config_port, void* ip_changed_params);
void 		display_advanced_ip_page(Request_t* request);
void 		send_advanced_ip_page(Request_t* request, BYTE* buffer);
void 		fill_the_advanced_ip_form_with_appropriate_values(BYTE* buffer);
void	   make_changes_to_corresponding_port(enum ip_port_types config_port, CHANGE_IP_PARAMS_form_output_type* ip_changed_params);
void 		make_changes_to_advanced_config(CHANGE_ADVANCED_IP_PARAMS_form_output_type* advanced_ip_changed_params);
void 		save_the_value_from_ip_form(CHANGE_IP_PARAMS_form_output_type* ip_changed_params, BYTE port_number);


void		fill_the_wan_form_with_appropriate_values(BYTE* buffer, BYTE port_number );
void		make_changes_to_corresponding_wan_port(enum wan_port_types wan_config_port, CHANGE_WAN_PARAMS_form_output_type* wan_changed_params);
void  	save_the_values_from_wan_form(CHANGE_WAN_PARAMS_form_output_type* wan_changed_params, BYTE port_number);

void 		fill_the_application_form_with_appropriate_values(BYTE* buffer);
void 		make_changes_to_corresponding_app_port(CHANGE_APPLICATION_PARAMS_form_output_type* app_changed_params);
void 		display_wan_page(Request_t* request, BYTE* buffer, BYTE port_number);
void 		convert_to_lower_case(BYTE* the_string);
void 		display_filter_menu(Request_t* request);

PARAMETER_NODE* read_setup_and_build_linked_list_for_each_line(BYTE* start_of_cfg);
void  display_ppp_cfg_page_for_wan1(Request_t* request);
void  display_ppp_cfg_page_for_wan2(Request_t* request);
void  display_ppp_cfg_page_for_wan3(Request_t* request);
void 	display_ppp_page(Request_t* request, BYTE* buffer, BYTE port_number);
void 	fill_the_ppp_form_with_appropriate_values(BYTE* buffer, BYTE port_number);
void 	change_the_ppp_parameters(Request_t* request);
void 	make_changes_to_corresponding_ppp_port(enum wan_port_types ppp_config_port, CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params);
void  save_the_values_from_ppp_form(CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params, BYTE port_number);
void	display_ppp_advanced_page(Request_t* request);
void	send_advanced_ppp_page(Request_t* request, BYTE* buffer);
void	fill_the_advanced_ppp_form_with_appropriate_values(BYTE* buffer);
void 	change_advanced_ppp_parameters(Request_t* request);
void 	make_changes_to_advanced_ppp_config(CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type* advanced_ppp_changed_params);
void	old_default_route(BYTE* ip_address, BYTE* metric, BYTE is_to_save);

/* Added by Ravi on 24 Feb 1999 ... */
void user_authentication_page(Request_t * request);
enum BOOLEAN check_for_time_restrictions (USHORT hrs, USER_PROFILE_NODE *sptr_user_profile_node, BYTE dayofweek);
static USHORT get_time_in_hrs (ULONG seconds);
extern void add_entry_to_user_rb_tree (USER_ONLINE_TRANSITION_TABLE *user_info,unsigned char *vptr_buffer);
extern USER_PROFILE_NODE *user_rb_profile_search(USER_PROFILE_NODE *Tree, USER_PROFILE_KEY_TYPE key);
extern GROUP_PROFILE_NODE *group_rb_profile_search(GROUP_PROFILE_NODE *Tree, GROUP_PROFILE_KEY_TYPE key);
extern USER_ONLINE_TRANSITION_NODE *user_rb_demo_search(USER_ONLINE_TRANSITION_NODE *Tree, USER_ONLINE_TRANSITION_KEY_TYPE key);
extern int delete_entry_from_user_rb_tree (USER_ONLINE_TRANSITION_KEY_TYPE key);
extern BYTE is_an_ip_address(BYTE* address);
extern void GetDateTime (SntpDateTime far *dt_ptr);
extern USER_ONLINE_TRANSITION_NODE far *sptr_user_online_tree;
extern USER_PROFILE_NODE far *sptr_user_profile_tree;
extern GROUP_PROFILE_NODE *sptr_group_profile_tree;
extern ULONG user_online_transition_timeout;
void user_logon_procedure(USER_AUTHENTICATION_form_output_type *user_authentication_form, Request_t *request);
void user_logoff_procedure(USER_AUTHENTICATION_form_output_type *user_authentication_form, Request_t *request);
/*extern void event_broadcast_packets_on_all_ports (EVENT_TYPE_ENUM event_type,BYTE username[MAX_LEN_USER_NAME]);*/
extern void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);

/* ... Added by Ravi on 24 Feb 1999 */
extern void set_ftp_port_numbers_during_init(); /* sudha 19 Aug 1999 */

/* ... Local Prototypes */

BYTE current_process_is_reading_setup;

/* ... End of Global Variable Decleration which will interact with forms*/

BYTE ip_node_address[15];
int  if_standard_or_frames=0 ;

SAVE_INDEX_STRUCT  		saved_indices[50];
USHORT             		number_of_saved_indices; 
enum ip_port_types		ip_config_port;
enum wan_port_types 		wan_config_port;
enum wan_port_types		ppp_config_port;

BYTE* templates[] = {"#__CBOX", "#___TEXT___#___", "#___STATIC_TEXT","#_SELECT", "#__CBOX", "#___IP__ADDRESS", "#___GATEWAY_ADD", 
	"#___IP_ADD_MASK", "#_M_", "###___###___###___###___###___$", "#___TEXT___#___#___TEXT___#___#___TEXT___#___", 
	"#___TEXT___#___TEXT___#___TEXT___#___#___TEXT___#___"};


PARAMETER_NODE* sptr_to_ptr_to_sections[20];
					
BYTE index_to_sections;
BYTE user_viewing_with_frames = TRUE;


BYTE check_whether_user_is_authenticated_or_not(Request_t* request)
{
	enum CM_INIT_RESULTS  init_result;
	BYTE encrypted_password[50], buffer[20], temp_password[50];
	BYTE bptr_not_enough_memory[] = "Not enough Memory to Initialize Configuration Manager \n";
	BYTE bptr_owned_by_other[200];
   BYTE notification[] = "Configuration manager deinitialized after expiry of idle timer. You must restart ...";

#if 0
	if (UserAuthenticated && configuration_manager_deinitialized == FALSE)
	 	return(TRUE);

	if (UserAuthenticated && configuration_manager_deinitialized == TRUE)
   {
      InitReturnBuffer(request, notification, strlen(notification), HTML_CONTENT_TYPE, TRUE);
      return FALSE;  
   }
#endif

	if( request->params.authorization.scheme == BASIC_AUTHORIZATION ) 
	{
      strcpy(temp_password, request->params.authorization.password);
		encrypt(to_upper_string(temp_password), encrypted_password);
		if(strcmpi(request->params.authorization.user_name, "supervisor") == 0 && (strcmpi(encrypted_password, telnet.password) == 0)) 
		{
         if (web.configuration_manager_deinitialized == TRUE && (web.address_in_the_process_of_configuring == request->client_address.sin_addr.s_addr))
         {
            InitReturnBuffer(request, notification, strlen(notification), HTML_CONTENT_TYPE, TRUE);
            web.address_in_the_process_of_configuring = 0;
            return FALSE;  
         }

         if (web.configuration_manager_deinitialized == TRUE)
         {
            web.address_in_the_process_of_configuring = 0;
         }

         if (web.configuration_manager_deinitialized == FALSE && (web.address_in_the_process_of_configuring == request->client_address.sin_addr.s_addr))
         {
            /* This user is authenticated already he can proceed */
            return TRUE;
         }

       	init_result = cm_initialize_configuration_manager(CM_OWNED_BY_HTTP);
       	if (init_result == CM_INIT_FAILED_NOT_ENOUGH_MEMORY)
       	{
       		InitReturnBuffer(request, bptr_not_enough_memory, strlen(bptr_not_enough_memory),HTML_CONTENT_TYPE, TRUE);
       		return FALSE;
       	}
			strcpy(bptr_owned_by_other,"Could not Initialize Configuration Manager - Manager Owned by");
       	if (init_result != CM_INIT_SUCCESSFUL)
       	{
				switch (init_result)
				{
					case CM_MANAGER_IS_SNMP:
						strcat(bptr_owned_by_other, " SNMP Module");
						break;
					case CM_MANAGER_IS_TELNET:
						strcat(bptr_owned_by_other, " Telnet Module");
						break;
					case CM_MANAGER_IS_HTTP:
                  sprintf(buffer, "%d\0", (web.http_idle_timeout)/20);
						strcat(bptr_owned_by_other, " Some Web client or Configuration Manager is in the process of Deinitialization. Retry after ");
                  strcat(bptr_owned_by_other,buffer);
                  strcat(bptr_owned_by_other, " seconds...");
						break;
					case CM_MANAGER_IS_UIM:
						strcat(bptr_owned_by_other, " Management Port");
						break;
					case CM_MANAGER_IS_DTTY:
						strcat(bptr_owned_by_other, " Dumb TTY Module");
						break;
					default:;
				}

       		InitReturnBuffer(request, bptr_owned_by_other, strlen(bptr_owned_by_other),HTML_CONTENT_TYPE, TRUE);
       		return FALSE;
       	}
		 	web.http_timer = web.http_idle_timeout;
         web.address_in_the_process_of_configuring = request->client_address.sin_addr.s_addr;
       	printf("WEB:Configuration Manager Initialization Successful.\n");
      	web.configuration_manager_deinitialized = FALSE;
		 	request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
/* sudha 23 Aug 1999 */
			set_ftp_port_numbers_during_init(); 
		 		return(TRUE);
		}
	}

	web.configuration_manager_deinitialized = FALSE;
#if Ravi
   InitReturnUnauthorized(request, "Basic real=\" ",
#endif
   InitReturnUnauthorized(request, "Basic realm=\" ",
      		"<head><title>401 Unauthorized</title></head><body><h2>401 Unauthorized Access: Incorrect user/password.</h2><p></body>", 
				FALSE ); 
	request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
   web.address_in_the_process_of_configuring = 0;
   return (FALSE);
}

char* initialize_request(Request_t *request)
{
	char* buffer;
	if ((buffer = malloc( (size_t)MAX_BUFFER_SIZE )) == NULL)
		return NULL;
	buffer[0] = '\0';
	return(buffer);
}

void display_welcome_page(Request_t * request)
{
#if 0
	InitReturnBuffer(request, WELCOME_PAGE_data_ptr, strlen(WELCOME_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
#endif
	InitReturnBuffer(request, BLANK_PAGE_data_ptr, strlen(BLANK_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

/* Added by Ravi on 24 Feb 1999 ... */
void user_authentication_page(Request_t * request)
{
	USER_AUTHENTICATION_form_output_type *user_authentication_form;

	user_authentication_form = (USER_AUTHENTICATION_form_output_type*)form_data_of_request(request);
	if(user_authentication_form == NULL)
	{
		printf("\n User Database : User Authentication Form failed");
		return;
	}

	if (user_authentication_form->Logon)
	{
		user_logon_procedure(user_authentication_form, request);
	}
	else if (user_authentication_form->Logoff)
	{
		user_logoff_procedure(user_authentication_form, request);
	}
	return;
}

void user_logon_procedure(USER_AUTHENTICATION_form_output_type *user_authentication_form, Request_t *request)
{
	USER_PROFILE_NODE *user_profile_node;
	USER_PROFILE_KEY_TYPE user_profile_key;
	USER_ONLINE_TRANSITION_NODE *user_online_transition_node;
	USER_ONLINE_TRANSITION_KEY_TYPE user_online_key_type;
	USER_ONLINE_TRANSITION_TABLE *user_transition_table;
	GROUP_PROFILE_KEY_TYPE  group_key;
/*	GROUP_PROFILE_NODE *ptr_group_profile; */
	USHORT hrs, group_no, search_to_start_at = 0;
	SntpDateTime *dt_ptr;
	char string[50], ipaddress_string[15],systemtime[15];
	BYTE *userbuffer;
	EVENT_PACKET *event_packet;
	EVENT_HEADER event_broadcast_packet;
	enum BOOLEAN add_edit_flag=FALSE;

	strcpy(user_profile_key.user_name, user_authentication_form->user_name);
	user_profile_node = user_rb_profile_search(sptr_user_profile_tree, user_profile_key); 

	if(user_profile_node == NULL)
	{
		/* Broadcast the event : Username Invalid */
		strcpy(event_broadcast_packet.username, user_authentication_form->user_name);
		event_broadcast_packet.ip_address = request->client_address.sin_addr.s_addr;
		event_broadcast_packet.user_event_type = LOG_USER_EVENT_INVALID_NAME;
		event_broadcast_packet.event_type = USER_EVENT_BDCAST;
		strcpy(event_broadcast_packet.groupname,"Invalid Group Name");
		strcpy(event_broadcast_packet.login_time,"Invalid Login Time");
		
		event_broadcast_packets_on_all_ports(&event_broadcast_packet); 
		
		InitReturnBuffer(request, AUTHFAIL_PAGE_data_ptr, strlen(AUTHFAIL_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
	}
	else
	{
	  	/* Todo : Check the password. If the username and password combination
		**			 happens to be correct, then execute the following segment.
		** 	 	 else display the Authentication Fail page. 
		*/

		if(strcmp(user_profile_node->info->user_password, user_authentication_form->user_password))
		{
			if (user_profile_node->info->sptr_user_group_profile_node->info->defaulter_login_attempts)
				user_profile_node->info->defaulter_number_of_login_attempts++;				

			/* Broadcast the event : User Password Invalid */
			strcpy(event_broadcast_packet.username, user_authentication_form->user_name);
			event_broadcast_packet.ip_address = request->client_address.sin_addr.s_addr;
			event_broadcast_packet.user_event_type = LOG_USER_EVENT_INVALID_PASSWORD;
			event_broadcast_packet.event_type = USER_EVENT_BDCAST;
			strcpy(event_broadcast_packet.groupname,"Invalid Group Name");
			strcpy(event_broadcast_packet.login_time,"Invalid Login Time");


			event_broadcast_packets_on_all_ports(&event_broadcast_packet); 

			InitReturnBuffer(request, AUTHFAIL_PAGE_data_ptr, strlen(AUTHFAIL_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
			return;
		}

		/* Check if the account is disabled */
		if (user_profile_node->info->account_status == 0)
		{
			/* Broadcast the event : User account disabled */
			strcpy(event_broadcast_packet.username, user_authentication_form->user_name);
			event_broadcast_packet.ip_address = request->client_address.sin_addr.s_addr;
			event_broadcast_packet.user_event_type = LOG_USER_EVENT_ACCOUNT_DISABLED;
			event_broadcast_packet.event_type = USER_EVENT_BDCAST;
			strcpy(event_broadcast_packet.groupname,"Invalid Group Name");
			strcpy(event_broadcast_packet.login_time,"Invalid Login Time");


			event_broadcast_packets_on_all_ports(&event_broadcast_packet); 

			InitReturnBuffer(request, ACCOUNT_DISABLED_PAGE_data_ptr, strlen(ACCOUNT_DISABLED_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
			return;
		}

		/* Check if the account happens to be a defaulter */
		if (user_profile_node->info->defaulter != 0)
		{
			/* Broadcast the event : User account marked as a defaulter */
			strcpy(event_broadcast_packet.username, user_authentication_form->user_name);
			event_broadcast_packet.ip_address = request->client_address.sin_addr.s_addr;
			event_broadcast_packet.user_event_type = LOG_USER_EVENT_DEFAULTER;
			event_broadcast_packet.event_type = USER_EVENT_BDCAST;
			strcpy(event_broadcast_packet.groupname,"Invalid Group Name");
			strcpy(event_broadcast_packet.login_time,"Invalid Login Time");


			event_broadcast_packets_on_all_ports(&event_broadcast_packet); 

			InitReturnBuffer(request, DEFAULTER_PAGE_data_ptr, strlen(DEFAULTER_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
			return;
		}

		/* Check for Time restrictions - Sreelu */
		dt_ptr = (SntpDateTime *) malloc(sizeof(SntpDateTime));
		GetDateTime (dt_ptr);
		hrs = dt_ptr->Hour;
	
		sprintf(systemtime,"%02d:%02d:%02d", dt_ptr->Hour, dt_ptr->Minute, dt_ptr->Second);

		if (!check_for_time_restrictions (hrs, user_profile_node, dt_ptr->WeekDay))
		{
			InitReturnBuffer(request, TIME_RESTRICTION_PAGE_data_ptr, strlen(TIME_RESTRICTION_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
			free(dt_ptr);
			return;
		}
		free(dt_ptr);

		user_transition_table = (USER_ONLINE_TRANSITION_TABLE *) malloc(sizeof(USER_ONLINE_TRANSITION_TABLE));
		if(user_transition_table == NULL)
		{
			printf("USER: Error allocating Memory\n");
			return ;
		}

		user_online_key_type.ip_address = request->client_address.sin_addr.s_addr;

		user_transition_table->ip_address = request->client_address.sin_addr.s_addr;
/*		strcpy(user_transition_table->mac_address,mac_address); */
		strcpy(user_transition_table->user_name, user_authentication_form->user_name);
		strcpy(user_transition_table->group_name,user_profile_node->info->group_name);
		user_transition_table->group_no = user_profile_node->info->sptr_user_group_profile_node->info->group_no;
		user_transition_table->account_status = user_profile_node->info->account_status;	
		user_transition_table->defaulter = user_profile_node->info->defaulter; 
		user_transition_table->age = user_online_transition_timeout;
		strcpy(user_transition_table->login_time, systemtime);
		user_transition_table->ptr_user_profile_node = user_profile_node;

/*		add_entry_to_user_rb_tree (user_transition_table, &user_online_key_type); */

/* Added by Neelu.... */
/* New addition*/
		user_online_transition_node = user_rb_demo_search(sptr_user_online_tree, user_online_key_type);
		if (user_online_transition_node == NULL)
		{
			add_edit_flag = TRUE;
			add_entry_to_user_rb_tree (user_transition_table, &user_online_key_type);
		}
		else
		{
			add_edit_flag = FALSE;
			user_online_transition_node->info->ip_address = request->client_address.sin_addr.s_addr;
			strcpy(user_online_transition_node->info->user_name,user_authentication_form->user_name);
			strcpy(user_online_transition_node->info->group_name,user_profile_node->info->group_name);
			user_online_transition_node->info->group_no = user_profile_node->info->sptr_user_group_profile_node->info->group_no;
		  	user_online_transition_node->info->account_status = user_profile_node->info->account_status;	
		  	user_online_transition_node->info->defaulter = user_profile_node->info->defaulter; 
		  	user_online_transition_node->info->age = user_online_transition_timeout;
			strcpy(user_online_transition_node->info->login_time, systemtime);
			user_online_transition_node->info->ptr_user_profile_node = user_profile_node;
		}
/* New addition ends */		

		/* Broadcast the event : User logon */
		strcpy(event_broadcast_packet.username, user_transition_table->user_name);
		strcpy(event_broadcast_packet.groupname, user_transition_table->group_name);
		strcpy(event_broadcast_packet.login_time, user_transition_table->login_time);
		event_broadcast_packet.ip_address = user_transition_table->ip_address;
		event_broadcast_packet.user_event_type = LOG_USER_EVENT_LOGON;
		event_broadcast_packet.event_type = USER_EVENT_BDCAST;

		event_broadcast_packets_on_all_ports(&event_broadcast_packet); 

	   userbuffer = (BYTE*) malloc(strlen(USER_PERMISSION_PAGE_data_ptr));
	   if (userbuffer == NULL)
	   {
	      printf("WEB:Not enough memory\n");
	      return;
	   }

	   strcpy(userbuffer, USER_PERMISSION_PAGE_data_ptr);

		convert_ip_address_to_dot_format(&ipaddress_string[0],user_transition_table->ip_address);
      search_to_start_at = search_and_replace("#________STATIC_TEXT_________STATIC_TEXT", user_transition_table->user_name , userbuffer, TRUE, 0);
      search_to_start_at = search_and_replace("#________STATIC_TEXT_________STATIC_TEXT", user_transition_table->group_name , userbuffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace("#___STATIC_TEXT", ipaddress_string, userbuffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace("#___STATIC_TEXT", systemtime, userbuffer, TRUE, search_to_start_at);
      InitReturnBuffer(request, userbuffer, strlen(userbuffer), HTML_CONTENT_TYPE, TRUE);
      free(userbuffer);
	}
}

void user_logoff_procedure(USER_AUTHENTICATION_form_output_type *user_authentication_form, Request_t *request)
{
	USER_ONLINE_TRANSITION_NODE *user_online_transition_node;
	USER_ONLINE_TRANSITION_KEY_TYPE user_online_key;
	USER_ONLINE_TRANSITION_TABLE *user_transition_table;
	SntpDateTime *dt_ptr;
	char systemtime[15], ipaddress_string[15];
	BYTE *buffer;
	USHORT search_to_start_at = 0;
	EVENT_HEADER event_broadcast_packet;
		
	user_online_key.ip_address = request->client_address.sin_addr.s_addr;
	user_online_transition_node = user_rb_demo_search(sptr_user_online_tree, user_online_key);
	if (user_online_transition_node != NULL)
	{
		if(strcmp(user_online_transition_node->info->user_name, user_authentication_form->user_name))
		{
			InitReturnBuffer(request, LOGOFF_data_ptr, strlen(LOGOFF_data_ptr),HTML_CONTENT_TYPE, TRUE);
			return;
		}

		if(strcmp(user_online_transition_node->info->ptr_user_profile_node->info->user_password, user_authentication_form->user_password))
		{
			InitReturnBuffer(request, LOGOFF_data_ptr, strlen(LOGOFF_data_ptr),HTML_CONTENT_TYPE, TRUE);
			return;
		}
		
		/* Logoff Time Calcu...*/
		dt_ptr = (SntpDateTime *) malloc(sizeof(SntpDateTime));
		GetDateTime (dt_ptr);
		sprintf(systemtime,"%02d:%02d:%02d", dt_ptr->Hour, dt_ptr->Minute, dt_ptr->Second);
		free(dt_ptr);

		buffer = (BYTE*) malloc(strlen(LOGON_data_ptr));
		if(buffer == NULL)
		{
	      printf("WEB:Not enough memory\n");
	      return;
		}

	   strcpy(buffer, LOGON_data_ptr);
		convert_ip_address_to_dot_format(&ipaddress_string[0], user_online_transition_node->info->ip_address);

      search_to_start_at = search_and_replace("#________STATIC_TEXT_________STATIC_TEXT", user_online_transition_node->info->user_name, buffer, TRUE, 0);
      search_to_start_at = search_and_replace("#________STATIC_TEXT_________STATIC_TEXT", user_online_transition_node->info->group_name, buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace("#___STATIC_TEXT", ipaddress_string, buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace("#___STATIC_TEXT", user_online_transition_node->info->login_time, buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace("#___STATIC_TEXT", systemtime, buffer, TRUE, search_to_start_at);
      InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
      free(buffer);

		user_online_transition_node->info->age = 0;

		strcpy(event_broadcast_packet.username, user_online_transition_node->info->user_name);
		strcpy(event_broadcast_packet.groupname, user_online_transition_node->info->group_name);
		strcpy(event_broadcast_packet.login_time, user_online_transition_node->info->login_time);
		event_broadcast_packet.ip_address = user_online_transition_node->info->ip_address;
		event_broadcast_packet.user_event_type = LOG_USER_EVENT_LOGOFF;
		event_broadcast_packet.event_type = USER_EVENT_BDCAST;
			
		if(delete_entry_from_user_rb_tree(user_online_key))
			event_broadcast_packets_on_all_ports (&event_broadcast_packet);
	}
	else
	{	
		InitReturnBuffer(request, LOGOFF_data_ptr, strlen(LOGOFF_data_ptr),HTML_CONTENT_TYPE, TRUE);
	}

	return;
}
/* ... Added by Ravi on 24 Feb 1999 */

static USHORT get_time_in_hrs (ULONG seconds)
{
	USHORT	days, hrs, mins, secs;
	ULONG		rest;

	days = (USHORT)( seconds / ((int)3600 * 24));
	rest = seconds % ((int)3600 * 24);
	hrs = (USHORT) (rest / 3600);
	rest %= 3600;
	mins = (USHORT) (rest / 60);
	secs = (USHORT) (rest % 60);

	return (hrs);
}

enum BOOLEAN check_for_time_restrictions (USHORT hrs, USER_PROFILE_NODE *sptr_user_profile_node, BYTE dayofweek)
{
	ULONG time_status;

	if (sptr_user_profile_node->info->sptr_user_group_profile_node->info->user_permission[dayofweek] != NULL)
   {
		time_status = 	sptr_user_profile_node->info->sptr_user_group_profile_node->info->user_permission[dayofweek] & (0x01L << hrs);
		if (time_status)
			return TRUE;
	}
	return FALSE;
}


void display_blank_page(Request_t * request)
{
	InitReturnBuffer(request, BLANK_PAGE_data_ptr, strlen(BLANK_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

void display_standard_main_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   if (user_viewing_with_frames)
   {	
		flag_for_time_permission = FALSE;
		InitReturnBuffer(request, SELECT_BLANK_PAGE_data_ptr, strlen(SELECT_BLANK_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
	}
   else
	{
	  	flag_for_time_permission = FALSE;
		InitReturnBuffer(request, MAIN_PAGE_data_ptr, strlen(MAIN_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
	}
}

void start_standard_view(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   user_viewing_with_frames = FALSE;

	InitReturnBuffer(request, MAIN_PAGE_data_ptr, strlen(MAIN_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

void display_framed_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   user_viewing_with_frames = TRUE;
	InitReturnBuffer(request, DISPLAY_PAGE_data_ptr, strlen(DISPLAY_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}
void display_framed_or_standard_main_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   if(if_standard_or_frames)
     display_blank_page(request) ;
   else
     display_standard_main_page(request) ;
}

void display_framed_main_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	InitReturnBuffer(request, FRAMES_PAGE_data_ptr, strlen(FRAMES_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

#if 0
void display_internet_gateway_page(Request_t* request)
{
   BYTE* buffer, address[IP_ADDRES_LENGTH];
   USHORT search_to_start_at = 0;
   ULONG value;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   buffer = (BYTE*)malloc(strlen(IGWAY_CONFIG_PAGE_data_ptr));
   if (buffer == NULL)
   {
      printf("WEB:Not enough memory\n");
      display_ip_page_for_ethernet(request);
      return;
   }
   strcpy(buffer, IGWAY_CONFIG_PAGE_data_ptr);

   /* Check whether the value is present the current configuration and if not
   then assume WAN as default Port */
   if (get_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value, 0) == CM_GET_SUCCESSFUL)
   {
      /* Check whether the port is Internet LAN port or WAN */
      if (value == (BYTE)INTERNET_LAN_IS_GATEWAY)
      {
         /* Get the Internet Gateway Address */
        get_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&address, IP_ADDRES_LENGTH);
        search_to_start_at = search_and_replace(templates[ENUM_CHECK_BOX], "", buffer, FALSE, search_to_start_at);
        search_to_start_at = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
        search_to_start_at = search_and_replace(templates[ENUM_TEXT_BOX], address, buffer, TRUE, search_to_start_at);
        InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
        free(buffer);
        return;
      }
   }

   search_to_start_at = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
   search_to_start_at = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
   InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
   return;
}

void change_igway_parameters(Request_t* request)
{
   CHANGE_IGWAY_CONFIG_PARAMS_form_output_type* igway_changed_params;
   ULONG value = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	igway_changed_params = (CHANGE_IGWAY_CONFIG_PARAMS_form_output_type*)form_data_of_request(request);
   if (igway_changed_params == NULL)
   {
      display_ip_page_for_ethernet(request);
      return;
   }

   if (igway_changed_params->internet_gateway_port)
   {
      if (set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)igway_changed_params->igway_address) == CM_SET_SUCCESSFUL)
      {
         value = INTERNET_LAN_IS_GATEWAY;
         set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
         display_ip_page_for_ethernet(request);
         return;
      }
   }
   value = WAN_IS_GATEWAY;
   set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
   display_ip_page_for_ethernet(request);
}
#endif
/* ------------------- IP Confuguration -------------------------------- */

void display_ip_page_for_ethernet(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying Ethernet IP Page ...\n");

	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);

#if 0
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)ETHERNET_PORT, buffer);
	check_for_need_and_hide_irrelevent_fields(ETHERNET_PORT);
	/* We should not show ISP Assigned IP Address CHECKBOX for ethernet port 
	   hence comment that part */
	search_and_replace("#START_OF_COMMENT", "<!--", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "-->", buffer, TRUE, 0);
#endif

	display_ip_page(request, buffer, 0);

#if 0
	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
#endif

	ip_config_port = ETHERNET_PORT;
	free(buffer);
}

void display_ip_page_for_wan1(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying IP Configuration Page of WAN1...\n");

	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);
	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_1, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_1);

	search_and_replace("#START_OF_COMMENT", "", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "", buffer, TRUE, 0);
	display_ip_page(request, buffer, 1);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ip_config_port = WAN_PORT_1;
	free(buffer);
}

void display_ip_page_for_wan2(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 2))
	{
		return;
	}

	printf("Displaying IP Configuration Page for WAN2...\n");
	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_2, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_2);

	search_and_replace("#START_OF_COMMENT", "", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "", buffer, TRUE, 0);
	display_ip_page(request, buffer, 2);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ip_config_port = WAN_PORT_2;
	free(buffer);
}

void display_ip_page_for_wan3(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 3))
	{
		return;
	}

	printf("Displaying IP Configuration Page for WAN3...\n");
	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_3, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_3);

	search_and_replace("#START_OF_COMMENT", "", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "", buffer, TRUE, 0);
	display_ip_page(request, buffer, 3);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ip_config_port = WAN_PORT_3;
	free(buffer);
}

void display_ip_page(Request_t* request, BYTE* buffer, BYTE port_number)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	fill_the_ip_form_with_appropriate_values(buffer, port_number);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void change_ip_parameters(Request_t* request)
{
	CHANGE_IP_PARAMS_form_output_type* ip_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ip_changed_params = (CHANGE_IP_PARAMS_form_output_type*)form_data_of_request(request);
	if (ip_changed_params == NULL)
		return;

	make_changes_to_corresponding_port(ip_config_port, ip_changed_params);
   display_standard_main_page(request);
}

void	make_changes_to_corresponding_port(enum ip_port_types config_port, CHANGE_IP_PARAMS_form_output_type* ip_changed_params)
{
	switch(config_port)
	{
	case ETHERNET_PORT:
		save_the_value_from_ip_form(ip_changed_params, 0);
		break;
#if 0
	case WAN_PORT_1:
		save_the_value_from_ip_form(ip_changed_params, 1);
		break;
	case WAN_PORT_2:
		save_the_value_from_ip_form(ip_changed_params, 2);
		break;
	case WAN_PORT_3:
		save_the_value_from_ip_form(ip_changed_params, 3);
		break;
#endif
	default:
#ifdef _NAVDEBUG_
	   for (i=0;i <= 100; ++i)
			printf("make_changes_to_corresponding_port None of the case are matching *\n");
#endif
	  	break;
	}
}

void save_the_value_from_ip_form(CHANGE_IP_PARAMS_form_output_type* ip_changed_params, BYTE port_number)
{
   BYTE ip_address[] = "0.0.0.0", temp_string[20];
   ULONG value = 0;
   enum CM_SET_RESULTS set_results;

   if (ip_changed_params->isp_assigned)
   {
      set_parameter_by_name(CM_IP_SECTION, "IP Port Address", port_number+2, CM_STRING_FORMAT, (void*)(ip_address));
   }
   else
   {
     if(is_an_ip_address(ip_changed_params->ip_address_3))
       set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number+2, (void*)(ip_changed_params->ip_address_3), "WAN IP Port Address");
   }
   if(is_an_ip_address_mask(ip_changed_params->ip_address_3,ip_changed_params->net_mask_3))
      set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number+2, (void*)(ip_changed_params->net_mask_3), "WAN SubNetMask");

   if(is_an_ip_address(ip_changed_params->ip_address_1))
      set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, (void*)(ip_changed_params->ip_address_1), "Secured IP Port Address");

   if(is_an_ip_address_mask(ip_changed_params->ip_address_1,ip_changed_params->net_mask_1))
      set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, (void*)(ip_changed_params->net_mask_1), "Secured SubNetMask");

   set_value_and_handle_error_1(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, port_number+1, (void*)&ip_changed_params->dhcp_client, "DHCP Client");

   if (ip_changed_params->dhcp_client)
   {
#if 1
      set_parameter_by_name(CM_IP_SECTION, "IP Port Address", port_number+1, CM_STRING_FORMAT, (void*)(ip_address));
      set_parameter_by_name(CM_IP_SECTION, "IP Port Address Mask", port_number+1, CM_STRING_FORMAT, (void*)(ip_address));
#endif
   }
   else
   {
    if(is_an_ip_address(ip_changed_params->ip_address_2))
      set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number+1, (void*)(ip_changed_params->ip_address_2), "INSecured IP Port Address");
    if(is_an_ip_address_mask(ip_changed_params->ip_address_2,ip_changed_params->net_mask_2))
      set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number+1, (void*)(ip_changed_params->net_mask_2), "INSecured SubNetMask");
   }

/* Added by Sreelu for DNS Server... */
   /* DNS Primary Address */
   if (is_an_ip_address(ip_changed_params->local_server_address) && (strcmp (ip_changed_params->local_server_address, ip_address) != 0))
      set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)ip_changed_params->local_server_address) ;
   else
      printf ("Enter Valid Primary Server Address\n") ;
/* ...Added by Sreelu for DNS Server */


   /* DHCP Relay Agent */
   set_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, CM_NO_PORT_PARAMETER_PRESENT, (void*)&ip_changed_params->dhcp_relay_agent, "DHCP Relay Agent");
   if (ip_changed_params->dhcp_relay_agent)
   {
     if(is_an_ip_address(ip_changed_params->dhcp_server_ip_address))
       set_value_and_handle_error_2(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, CM_NO_PORT_PARAMETER_PRESENT,  (void*)(ip_changed_params->dhcp_server_ip_address), "DHCP Server IP Address");
   }
   else
   {
      set_value_and_handle_error_2(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, CM_NO_PORT_PARAMETER_PRESENT, (void*)(ip_address), "DHCP Server IP Address");
   }


   port_number = CM_NO_PORT_PARAMETER_PRESENT;
   if (is_an_ip_address(ip_changed_params->gateway_address))
      strcpy(temp_string, ip_changed_params->gateway_address);
   strcat(temp_string, ",1");
   set_value_and_handle_error_4(CM_IP_SECTION, "IP Default Route", port_number, (void*)temp_string, "Gateway address");

   /* Internet Gateway Parameters */
   if (ip_changed_params->internet_gateway_port)
   {
      if (!ip_changed_params->dhcp_client)
      {
         if( is_an_ip_address(ip_changed_params->internet_gateway_address) )
         {
          set_results = set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)ip_changed_params->internet_gateway_address);
          if (set_results == CM_SET_SUCCESSFUL)
          {
            value = INTERNET_LAN_IS_GATEWAY;
            set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
          }
          else
          {
            value = WAN_IS_GATEWAY;
            set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
          }
         }
      }
      else
      {
         set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)ip_address);
         value = INTERNET_LAN_IS_GATEWAY;
         set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
      }
   }
   else
   {
      value = WAN_IS_GATEWAY;
      set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
   }

	/* DHCP Host Name */

   set_value_and_handle_error_2 (CM_DHCP_SECTION, (void*)&dhcp.dhcp_host_name, CM_NO_PORT_PARAMETER_PRESENT,  (void*)(ip_changed_params->dhcp_host_name), "DHCP Host Name") ;

#if 0
	/*Default TTL*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, (void*)ip_changed_params->time_to_live, "Default TTL");

	/*Reassambly Timeout*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, (void*)ip_changed_params->reassembly_time_out, "Reassembly Timeout");
#endif
}

void fill_the_ip_form_with_appropriate_values(char* buffer, BYTE port_number)
{
	USHORT search_to_start_at = 0, i = 0;
   BYTE ip_address[20], isp_enabled, temp_string[20], address[IP_ADDRES_LENGTH];
	BYTE ip_addr_string[20];
   ULONG value = 0;

	number_of_saved_indices = 0;
#if 0          
	/* ISP Enable*/
   if (port_number > 0)
   {
      /* Check if ip address is '0.0.0.0' or not. if it is then ISP is enabled
         else ISP is not enabled */
      if (get_parameter(CM_IP_SECTION, 
                        (void*)&ip.port[0].config.ip_address, 
                        port_number, 
                        CM_STRING_FORMAT,
                        (void*)ip_address, 
                        20) == CM_GET_SUCCESSFUL)
      {
         if (!strcmpi(ip_address, "0.0.0.0"))
         {
            isp_enabled = TRUE;
         }
         else
         {
            isp_enabled = FALSE;
         }
      }
      else
      {
         isp_enabled = FALSE;
      }

      if (isp_enabled)
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
      else
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "       ", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
   }
   else
   {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "       ", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }
#endif

	/*Secure LAN Port IP Address*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, "Secured IP Port Address", search_to_start_at, buffer);

	/*Secure LAN Port Net Mask*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, "Secured IP Port Mask", search_to_start_at, buffer);

   port_number = CM_NO_PORT_PARAMETER_PRESENT;

	/* Gateway Address*/
   if (get_parameter_by_name(CM_IP_SECTION, "IP Default Route", port_number, CM_STRING_FORMAT, (void*)temp_string, 20 ) == CM_GET_SUCCESSFUL)
   {
      i = 0;
      while(temp_string[i] != ',')
      {
         ip_address[i] = temp_string[i];
         i++;
      }
      ip_address[i] = 0;
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], ip_address, buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
   }
   else
   {
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
   }
   /* DHCP Client Enabled */
   search_to_start_at = get_value_and_handle_error_1(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, 1, "DHCP Client", search_to_start_at, buffer);

	/*INSecure LAN Port IP Address*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 1, "INSecured IP Port Address", search_to_start_at, buffer);

	/*INSecure LAN Port Net Mask*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, 1, "INSecured IP Port Mask", search_to_start_at, buffer);

#if Ravi
   /* DNS Primary Address */

   get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void *)&ip_addr_string[0], 20) ;
   search_to_start_at = search_and_replace ("#___TEXT___#___", ip_addr_string, buffer, TRUE, search_to_start_at) ; 
#endif

   /* DHCP relay Agent */
   search_to_start_at = get_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, CM_NO_PORT_PARAMETER_PRESENT, "DHCP Relay Agent", search_to_start_at, buffer);

   /* DHCP Server IP Address */
	search_to_start_at = get_value_and_handle_error_2(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, CM_NO_PORT_PARAMETER_PRESENT, "DHCP Server IP Address", search_to_start_at, buffer);


   /* ISP Enabled or Not */
   if (get_parameter(CM_IP_SECTION, 
                     (void*)&ip.port[0].config.ip_address, 
                     2, /* 2 for WAN port */
                     CM_STRING_FORMAT,
                     (void*)ip_address, 
                     20) == CM_GET_SUCCESSFUL)
   {
      if (!strcmpi(ip_address, "0.0.0.0"))
      {
         isp_enabled = TRUE;
      }
      else
      {
         isp_enabled = FALSE;
      }
   }
   else
   {
         isp_enabled = FALSE;
   }
   if (isp_enabled)
   {
	   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
	   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
	   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }
   else
   {
	   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "       ", buffer, TRUE, search_to_start_at);
	   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
	   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }

   /* WAN Port IP Address */
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 2, "WAN IP Port Address", search_to_start_at, buffer);

   /* WAN Port Mask */
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, 2, "WAN Port Mask", search_to_start_at, buffer);

#if 0
	/*Default TTL*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, "Default TTL", search_to_start_at, buffer);

	/*Reassambly Timeout*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, "Reassembly Timeout", search_to_start_at, buffer);
#endif



   /* Check whether the value is present the current configuration and if not
   then assume WAN as default Port */
   if (get_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value, 0) == CM_GET_SUCCESSFUL)
   {
      /* Check whether the port is Internet LAN port or WAN */
      if (value == (BYTE)INTERNET_LAN_IS_GATEWAY)
      {
         /* Get the Internet Gateway Address */
        get_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&address, IP_ADDRES_LENGTH);
        search_to_start_at = search_and_replace(templates[ENUM_CHECK_BOX], "", buffer, FALSE, search_to_start_at);
        search_to_start_at = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
        search_to_start_at = search_and_replace(templates[ENUM_TEXT_BOX], address, buffer, TRUE, search_to_start_at);
      }
      else
      {
         search_to_start_at = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
         search_to_start_at = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
      }
   }
   else
   {
      search_to_start_at = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
      search_to_start_at = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
   }

/* DHCP Host Name */

   search_to_start_at = get_value_and_handle_error_13(CM_DHCP_SECTION, (void*)&dhcp.dhcp_host_name, CM_NO_PORT_PARAMETER_PRESENT, "DHCP Host Name", search_to_start_at, buffer) ;

/* Ravi on 14 Dec 1999 */
   /* DNS Primary Address */

   get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void *)&ip_addr_string[0], 20) ;
   search_to_start_at = search_and_replace ("#___TEXT___#___", ip_addr_string, buffer, TRUE, search_to_start_at) ; 

	number_of_saved_indices --;	/* Very Important statement */
}

#if 0 /* Not Reqd for Proxy ...*/
/* ------------------ Advanced IP Configuraton --------------------------- */

void display_advanced_ip_page(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying Advanced IP Page...\n");

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)ADVANCED_CONFIG, ADVANCED_IP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(ADVANCED_CONFIG);

	send_advanced_ip_page(request, ADVANCED_IP_CONFIG_PAGE_data_ptr);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, ADVANCED_IP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ip_config_port = ADVANCED_CONFIG;
}

void send_advanced_ip_page(Request_t* request, BYTE* buffer)
{
	fill_the_advanced_ip_form_with_appropriate_values(buffer);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void fill_the_advanced_ip_form_with_appropriate_values(BYTE* buffer)
{
	USHORT search_to_start_at = 0;
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT;
	enum CM_GET_RESULTS get_result;
	BYTE returned_string[STRING_LENGTH_FOR_GET];
	BYTE main_index, sub_index, default_route[IP_ADDRES_LENGTH], default_route_metric[METRIC_LENGTH];
	number_of_saved_indices = 0;
	
	/* IP Routing Enable*/
	search_to_start_at = get_value_and_handle_error_3(CM_IP_SECTION, "IP", port_number, "IP Port Enable", search_to_start_at, buffer);

	/*IP Node Address*/
	search_to_start_at = get_value_and_handle_error_8(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 0, "IP Node Address", search_to_start_at, buffer);

	/*Default TTL*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, "Default TTL", search_to_start_at, buffer);

	/*RIP Response TimeOut*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.update_time_interval, port_number, "RIP Response Timeout", search_to_start_at, buffer);

	/*Reassambly Timeout*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, "Reassembly Timeout", search_to_start_at, buffer);
		
	/*RIP route aging time*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.route_aging_timeout_value, port_number, "Rip route Aging Time", search_to_start_at, buffer);

	/*DHCP Client*/
	search_to_start_at = get_value_and_handle_error_1(CM_IP_SECTION, (void*)&ip.port[0].config.bootp_enabled, 0, "DHCP Client", search_to_start_at, buffer);

	 /*DHCP Relay Agent*/	
	search_to_start_at = get_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, port_number, "DHCP Relay Agent", search_to_start_at, buffer);

	 /*DHCP Server IP Address*/
	search_to_start_at = get_value_and_handle_error_2(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, port_number, "DHCP Server IP Address", search_to_start_at, buffer);

   /* Default Route and Metric */
	get_result = get_parameter_by_name(CM_IP_SECTION, "IP Default Route", port_number, CM_STRING_FORMAT, (void*)returned_string, STRING_LENGTH_FOR_GET);

	if (get_result == CM_LHS_STRING_NOT_FOUND_WHILE_GET)
	{	
		printf("String for IP Default Route not found\n");
	}
	else
	if (get_result == CM_RHS_STRING_NOT_FOUND_WHILE_GET)
	{
		printf("String for IP Default Route not found\n");
	}
	else
	if (get_result == CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA)
	{
		printf("NonNumeric Data found for IP Default Route\n");
	}
	else
	if(get_result != CM_GET_SUCCESSFUL)
	{
		printf("Result returned is unknown for IP Default Route\n");
	}
	if(get_result == CM_GET_SUCCESSFUL && returned_string)
	{
		main_index = 0;
		sub_index = 0;
		default_route[0] = 0;
		while(main_index < strlen(returned_string) && returned_string[main_index] != ',')
		{
			default_route[sub_index++] = returned_string[main_index++];
		}
		default_route[sub_index] = 0;
		sub_index = 0;
		main_index ++; /* Skip ','*/
		default_route_metric[0] = 0;
		if (main_index < strlen(returned_string))
		{
			while(main_index < strlen(returned_string))
			{
		 		default_route_metric[sub_index++] = returned_string[main_index++];
			}
			default_route_metric[sub_index] = 0;
		}
		old_default_route(default_route, default_route_metric, TRUE);
	}
	else
	{
	 	strcpy(default_route, "0.0.0.0");
		strcpy(default_route_metric, "0");
		old_default_route(default_route, default_route_metric, TRUE);
	}

	if(get_result == CM_GET_SUCCESSFUL && returned_string != NULL)
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], default_route, buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}
	else
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}

	if(get_result == CM_GET_SUCCESSFUL && returned_string != NULL)
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], default_route_metric, buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}
	else
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}

	number_of_saved_indices--;
}

void	old_default_route(BYTE* string1, BYTE* string2, BYTE is_to_save)
{
	static BYTE ip_address[20], metric[5];

	if (is_to_save)
	{
		strcpy(ip_address, string1);
		strcpy(metric, string2);
	}
	else
	{
		strcpy(string1, ip_address);
		strcpy(string2, metric);
	}
}


void change_advanced_ip_parameters(Request_t* request)
{
	CHANGE_ADVANCED_IP_PARAMS_form_output_type* ip_changed_params;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ip_changed_params = (CHANGE_ADVANCED_IP_PARAMS_form_output_type*)form_data_of_request(request);
	if (ip_changed_params == NULL)
	{
		return;
	}
	make_changes_to_advanced_config(ip_changed_params);
   display_standard_main_page(request);
}

void make_changes_to_advanced_config(CHANGE_ADVANCED_IP_PARAMS_form_output_type* advanced_ip_changed_params)
{
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT;
	USHORT search_to_start_at = 0, value;
   BYTE i, number_of_ports, buffer[50], buffer1[20], buffer2[10], temp_buffer[20];
	number_of_saved_indices = 0;

	/* IP Routing Enable*/
	set_value_and_handle_error_3(CM_IP_SECTION, "IP", port_number, (void*)&advanced_ip_changed_params->ip_routing_enable, "IP Routing Enable");

	/*Default TTL*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, (void*)advanced_ip_changed_params->default_ttl, "Default TTL");

	/*RIP Response TimeOut*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.update_time_interval, port_number, (void*)advanced_ip_changed_params->rip_response_time, "IP Address");

	/*Reassambly Timeout*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, (void*)advanced_ip_changed_params->reassembly_timeout, "Reassembly Timeout");
		
	/*RIP route aging time*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.route_aging_timeout_value, port_number, (void*)advanced_ip_changed_params->rip_route_aging_time,"RIP routing Aging Time");

	/*DHCP Client*/
  	set_value_and_handle_error_1(CM_IP_SECTION, (void*)&ip.port[0].config.bootp_enabled, 0, (void*)&advanced_ip_changed_params->dhcp_client, "DHCP Client 0");
	 /*DHCP Server IP Address*/
	set_value_and_handle_error_2(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, port_number, (void*)advanced_ip_changed_params->dhcp_server_ip_address, "DHCP IP Address");

	 /*DHCP Relay Agent*/	
	get_parameter(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, port_number, CM_STRING_FORMAT, (void*)buffer, 20);
	if (is_an_ip_address(buffer))
		set_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, port_number, (void*)&advanced_ip_changed_params->dhcp_relay_agent, "DHCP Relay Agent");
	else
	{
		advanced_ip_changed_params->dhcp_relay_agent = FALSE;
		set_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, port_number, (void*)&advanced_ip_changed_params->dhcp_relay_agent, "DHCP Relay Agent");
	}

	/*Default Route*/
	if (is_a_default_ip_address(advanced_ip_changed_params->default_route_ip_address))
		strcpy(buffer1, advanced_ip_changed_params->default_route_ip_address);
	else
	{
		old_default_route(buffer1, temp_buffer, FALSE);
	}
	
	value = atoi(advanced_ip_changed_params->metric);
	if (strlen(advanced_ip_changed_params->metric) > 0  && is_valid_string_to_read_data(advanced_ip_changed_params->metric) && value > 0 && value < 16) 
		strcpy(buffer2, advanced_ip_changed_params->metric);
	else
	{
		old_default_route(temp_buffer, buffer2, FALSE);
	}
	strcpy(buffer, buffer1);
	strcat(buffer, ",");
	strcat(buffer, buffer2);
	set_value_and_handle_error_4(CM_IP_SECTION, "IP Default Route", CM_NO_PORT_PARAMETER_PRESENT, buffer, "Default Route");
}
#endif /* ... Not Reqd for Proxy */
/*--------------------     WAN Configuration --------------------------*/

void display_wan_page_for_port1(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying Configuration Page for WAN1...\n");
/* Not Reqd for FIREWALL
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT1, WAN_CONFIG_PAGE_data_ptr);
*/
	display_wan_page(request, WAN_CONFIG_PAGE_data_ptr, 0);
/* Not Reqd for FIREWALL
	enable_hyperlink(replaced_anchor_index_in_the_buffer, WAN_CONFIG_PAGE_data_ptr);
*/
	wan_config_port = WAN_PORT1;
}

void display_wan_page_for_port2(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 2))
	{
		return;
	}

	printf("Displaying Configuration Page for WAN2...\n");
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT2, WAN_CONFIG_PAGE_data_ptr);
	display_wan_page(request, WAN_CONFIG_PAGE_data_ptr, 1);
	enable_hyperlink(replaced_anchor_index_in_the_buffer, WAN_CONFIG_PAGE_data_ptr);
	wan_config_port = WAN_PORT2;
}

void display_wan_page_for_port3(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if(!this_port_present_in_the_current_router(request, 3))
	{
		return;
	}

	printf("Displaying Configuration Page for WAN3...\n");
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT3, WAN_CONFIG_PAGE_data_ptr);
	display_wan_page(request, WAN_CONFIG_PAGE_data_ptr, 2);
	enable_hyperlink(replaced_anchor_index_in_the_buffer, WAN_CONFIG_PAGE_data_ptr);
	wan_config_port = WAN_PORT3;
}

void display_wan_page(Request_t* request, BYTE* buffer, BYTE port_number)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	fill_the_wan_form_with_appropriate_values(buffer, port_number);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void	fill_the_wan_form_with_appropriate_values(BYTE* buffer, BYTE port_number)
{
	USHORT search_to_start_at = 0, temp_loc;
	number_of_saved_indices = 0;

 /* Port Enable*/
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].enabled, port_number, "WAN Port Enable", search_to_start_at, buffer);

/* Sreelu */
  /* Script Enabled */
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].script_enabled, port_number, "WAN Port Script Enable", search_to_start_at, buffer);

  /* Restart script on failure */
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].restart_script_on_comm_failure, port_number, "WAN Port Script Restart on Failure", search_to_start_at, buffer);
/* Sreelu */

 /* Async Mode / Sync Mode */
	search_to_start_at = get_value_and_handle_error_6(CM_WAN_SECTION, (void*)&wan.port[0].asyncport, port_number, "Async/Sync", search_to_start_at, buffer);

 /* Baud Rate*/
	search_to_start_at = get_value_and_handle_error_7(CM_WAN_SECTION, (void*)&wan.port[0].port_speed, port_number, "Baud", search_to_start_at, buffer);
      
 /* External/Internal Clock */
	search_to_start_at = get_value_and_handle_error_10(CM_WAN_SECTION, (void*)&wan.port[0].InternalClk, port_number, "External/Internal clock", search_to_start_at, buffer);


 /* Clock Speed*/
	search_to_start_at = get_value_and_handle_error_7(CM_WAN_SECTION, (void*)&wan.port[0].sync_port_speed, port_number, "Clock Speed", search_to_start_at, buffer);
	
 /* Send Idle Flag*/
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].sync_xmit_idle_flags, port_number, "Send Idle Flag", search_to_start_at, buffer);


 /* Direct Connection */
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].direct_connect_enabled, port_number, "Direct Connection", search_to_start_at, buffer);

/* Jo */
/*  Always Dialing, Not configurable */
#if 0
	temp_loc = search_to_start_at;
 /* Answering/Dialing */
	search_to_start_at = get_value_and_handle_error_6(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer, port_number, "Answering/Dialing", search_to_start_at, buffer);

	search_to_start_at = temp_loc;
#endif
/* Jo */

 /* Modem Type */
	search_to_start_at = get_value_and_handle_error_11(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.strings.modem_type, port_number, "Modem Type ", search_to_start_at, buffer);

 /*Dial Number */
	search_to_start_at = get_value_and_handle_error_12(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.strings.modem_dial_number, port_number, "Dial Number", search_to_start_at, buffer);


#if 0  /* Not Reqd for Proxy */
 /*General Name */
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.general_name, port_number, "General Name", search_to_start_at, buffer);

 /*Specific Name */
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.specific_name, port_number, "Specific Name", search_to_start_at, buffer);

 /*Port Inactivity Timeout*/
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.idle_time, port_number, "Port Inactivity Timeout", search_to_start_at, buffer);
#endif /* Not Reqd for Proxy */

	number_of_saved_indices--;
}

void change_wan_parameters(Request_t* request)
{
	CHANGE_WAN_PARAMS_form_output_type* wan_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	wan_changed_params = (CHANGE_WAN_PARAMS_form_output_type*)form_data_of_request(request);
	if (wan_changed_params == NULL)
	{
		return;
	}
	make_changes_to_corresponding_wan_port(wan_config_port, wan_changed_params);
   display_standard_main_page(request);
}

void make_changes_to_corresponding_wan_port(enum wan_port_types wan_config_port, CHANGE_WAN_PARAMS_form_output_type* wan_changed_params)
{
	switch(wan_config_port)
	{
	  case WAN_PORT1:
	  save_the_values_from_wan_form(wan_changed_params, 0);
	  break;

	  case WAN_PORT2:
	  save_the_values_from_wan_form(wan_changed_params, 1);
	  break;

	  case WAN_PORT3:
	  save_the_values_from_wan_form(wan_changed_params, 2);
	  break;

	};
}

void  save_the_values_from_wan_form(CHANGE_WAN_PARAMS_form_output_type* wan_changed_params, BYTE port_number)
{
   wan_changed_params->mode = !(wan_changed_params->mode);
  /* wan_changed_params->connection = !(wan_changed_params->connection);*/

   set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].enabled, port_number, (void*)&wan_changed_params->wan_port_enable, "Port Enable");
   set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].asyncport, port_number, (void*)&wan_changed_params->mode, "Async/Sync Mode");
   if (wan_changed_params->mode)
     set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].port_speed, port_number, (void*)&wan_changed_params->baud_rate, "BaudRate");
   if (!wan_changed_params->mode)
   {
     set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].InternalClk, port_number, (void*)&wan_changed_params->clock, "External/Internal Clock");
     set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].sync_xmit_idle_flags, port_number, (void*)&wan_changed_params->send_idle_flag, "Send Idle Flag");
   }
   if (wan_changed_params->clock)
     set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].sync_port_speed, port_number, (void*)&wan_changed_params->clock_speed, "Clock Speed");
   set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].direct_connect_enabled, port_number, (void*)&wan_changed_params->direct_connect, "Direct Connect");
/* Jo Always dialing, Not configurable */
/* Jo   set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer, port_number, (void*)&wan_changed_params->connection, "Answering/Dialing"); */
   if (wan_changed_params->mode &&  !wan_changed_params->direct_connect)
     set_value_and_handle_error_2(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.strings.modem_dial_number, port_number, (void*)wan_changed_params->dial_number, "Dial Number");
/* Sreelu */
     set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].script_enabled, port_number, (void*)&wan_changed_params->script_enable, "Script Enable");
     set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].restart_script_on_comm_failure, port_number, (void*)&wan_changed_params->restart_failure, "Restart Script on Failure");
/* Sreelu */

#if 0 /* Not Reqd for Proxy */
   set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.general_name, port_number, (void*)wan_changed_params->general_name, "General Name");
   set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.specific_name, port_number, (void*)wan_changed_params->specific_name, "Specific Name");
   set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.idle_time, port_number, (void*)wan_changed_params->port_inactivity_timeout, "Port Inactivity TimeOut");
#endif /* Not Reqd for Proxy */
}														

/*-------------------------- Application Configuration ----------------*/

void display_application_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	printf("Displaying Application Configuration Page...\n");

	fill_the_application_form_with_appropriate_values(APPLICATION_CONFIG_PAGE_data_ptr);
	InitReturnBuffer(request, APPLICATION_CONFIG_PAGE_data_ptr, strlen(APPLICATION_CONFIG_PAGE_data_ptr), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(APPLICATION_CONFIG_PAGE_data_ptr);
}

void 	fill_the_application_form_with_appropriate_values(BYTE* buffer)
{
	USHORT search_to_start_at = 0;
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, password[100], decrypted_password[100];

	number_of_saved_indices = 0;

 /*Router Password */
/*	search_to_start_at = get_value_and_handle_error_2(CM_TELNET_SECTION, (void*)&telnet.password, port_number, "Router Password", search_to_start_at, buffer);*/
   if (get_parameter(CM_TELNET_SECTION, (void*)&telnet.password, port_number,
                     CM_STRING_FORMAT, (void*)password, 100) == CM_GET_SUCCESSFUL)
   {
      decrypt(password, decrypted_password);
      append_quotes(decrypted_password);
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_LONG_TEXT_BOX], decrypted_password, buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_LONG_TEXT_BOX;
   }
   else
   {
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_LONG_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_LONG_TEXT_BOX;
   }


 /* Server IP Address */
 	search_to_start_at = get_value_and_handle_error_8(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 0, "Server IP Address", search_to_start_at, buffer);

 /*WEB Server Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_WEB_SECTION, (void*)&web.enabled, port_number, "WEB Enabled", search_to_start_at, buffer);

 /* Telnet Server Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.enabled, port_number, "Telnet Enabled", search_to_start_at, buffer);

 /*TFTP Server Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_TFTP_SECTION, (void*)&tftp.enabled, port_number, "Tftp Enabled", search_to_start_at, buffer);

 /*Dumb TTY Managament Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.dumb_tty_enabled, port_number, "Dumb TTY Enabled", search_to_start_at, buffer);

#if 0 /* Not Reqd for Proxy */
 /* Ag Server enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_AG_SECTION, (void*)&ag.enabled, port_number, "Ag Enabled", search_to_start_at, buffer);

 /* Display Connection manager Menu*/
	search_to_start_at = get_value_and_handle_error_1(CM_AG_SECTION, (void*)&ag.show_connection_manager_menu, port_number, "Connection Mangager Menu", search_to_start_at, buffer);

 /*Ipx Receives Per Session*/
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.ipx_interface.receives_per_session, port_number, "Ipx Recv Per Session", search_to_start_at, buffer);
#endif /* Not Reqd for Proxy */

	number_of_saved_indices--;

}

void change_application_parameters(Request_t* request)
{
	CHANGE_APPLICATION_PARAMS_form_output_type* app_changed_params;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	app_changed_params = (CHANGE_APPLICATION_PARAMS_form_output_type*)form_data_of_request(request);
	if (app_changed_params == NULL)
	{
		return;
	}
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	make_changes_to_corresponding_app_port(app_changed_params);
   display_standard_main_page(request);
}

void make_changes_to_corresponding_app_port(CHANGE_APPLICATION_PARAMS_form_output_type* app_changed_params)
{
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT;

   set_value_and_handle_error_2(CM_TELNET_SECTION, (void*)&telnet.password, port_number, (void*)app_changed_params->router_password, "Router Password");

   set_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.enabled, port_number, (void*)&app_changed_params->telnet_server_enable, "Telnet Server");
   set_value_and_handle_error_1(CM_TFTP_SECTION, (void*)&tftp.enabled, port_number, (void*)&app_changed_params->tftp_server_enable, "TFTP Server");
   set_value_and_handle_error_1(CM_WEB_SECTION, (void*)&web.enabled, port_number, (void*)&app_changed_params->web_server_enable, "WEB Server");
   set_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.dumb_tty_enabled, port_number, (void*)&app_changed_params->dumb_terminal_management_enable, "DTTY Enabled");

#if 0 /* Not Reqd for Proxy */
   set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.ipx_interface.receives_per_session, port_number, (void*)app_changed_params->ipx_receives_per_session, "Ipx Recv");
#endif
#if 0 /* Not Reqd for Proxy */
   set_value_and_handle_error_1(CM_AG_SECTION, (void*)&ag.enabled, port_number, (void*)&app_changed_params->ag_server_enable, "Ag server");
   set_value_and_handle_error_1(CM_AG_SECTION, (void*)&ag.show_connection_manager_menu, port_number, (void*)&app_changed_params->display_connection_manager_menu, "Connection manager menu");
#endif /* Not Reqd for Proxy */
}

/* ---------------------------- PPP Section-----------------------------*/
void  display_ppp_cfg_page_for_wan1(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying PPP Configuration Page of WAN1...\n");

#if 0
	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT1, PPP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT1);
#endif

	display_ppp_page(request, PPP_CONFIG_PAGE_data_ptr, 0);

#if 0
	enable_hyperlink(replaced_anchor_index_in_the_buffer, PPP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
#endif

	ppp_config_port = WAN_PORT1;
}

void  display_ppp_cfg_page_for_wan2(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 2))
	{
		return;
	}

	printf("Displaying PPP Configuration Page of WAN2...\n");

	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT2, PPP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT2);

	display_ppp_page(request, PPP_CONFIG_PAGE_data_ptr, 1);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, PPP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ppp_config_port = WAN_PORT2;
}

void  display_ppp_cfg_page_for_wan3(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 3))
	{
		return;
	}

	printf("Displaying PPP Configuration Page of WAN3...\n");

	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT3, PPP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT3);

	display_ppp_page(request, PPP_CONFIG_PAGE_data_ptr, 2);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, PPP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ppp_config_port = WAN_PORT3;
}

void display_ppp_page(Request_t* request, BYTE* buffer, BYTE port_number)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
#if 0
	result = get_parameter_by_name(CM_PPP_SECTION, "PPP", CM_NO_PORT_PARAMETER_PRESENT, CM_INDEX_FORMAT, (void*)&ppp_enabled, NULL);
	if (result != CM_GET_SUCCESSFUL || !ppp_enabled)
	{
		InitReturnBuffer(request, notification_string, strlen(notification_string), HTML_CONTENT_TYPE, TRUE);
		return;
	}
#endif
	fill_the_ppp_form_with_appropriate_values(buffer, port_number);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void fill_the_ppp_form_with_appropriate_values(BYTE* buffer, BYTE port_number)
{
	USHORT search_to_start_at = 0;
   BYTE slip_enabled, answering_port;

	number_of_saved_indices = 0;


  /*PPP Enabled*/
  /* If Slip is enabled and if the port is dialing then it is not reqd check ppp port  */
  if (get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&slip_enabled, 0) != CM_GET_SUCCESSFUL)
  {
     slip_enabled = FALSE;
  }
  /* Is port answering */
  if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer, port_number, CM_INDEX_FORMAT, (void*)&answering_port, 0) != CM_GET_SUCCESSFUL)
  {
      answering_port = FALSE;
  }

   if (slip_enabled && !answering_port)
   {
      /* Skip PPP Enable - Checkbox */
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "       ", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }   
   else
   {
      /* Continue normally */
   	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, "PPP Enabled", search_to_start_at, buffer);
   }

  /*DataCompression Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_CCP_SECTION, (void*)&ccp.ports[0].enabled, port_number, "DataCompression Enabled", search_to_start_at, buffer);
      
  /*VJC Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_VJC_SECTION, (void*)&vjc.port[0].vjc_compression_enabled, port_number, "VJC Enabled", search_to_start_at, buffer);

#if 0 /* Note Reqd for Proxy  */
  /*Cipx Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_CIPX_SECTION, (void*)&cipx.port[0].cipx_compression_enabled, port_number, "Cipx Enabled", search_to_start_at, buffer);
#endif

  /*UserName*/
	search_to_start_at = get_value_and_handle_error_12(CM_PPP_SECTION, (void*)ppp.port[0].authentication.user_name, port_number, "UserName", search_to_start_at, buffer);

  /*Password*/
	search_to_start_at = get_value_and_handle_error_12(CM_PPP_SECTION, (void*)ppp.port[0].authentication.password, port_number, "Password", search_to_start_at, buffer);

  /*Periodic Timer*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout, port_number, "Periodic Timer", search_to_start_at, buffer);

  /*Number of Retries*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries , port_number, "Number of Retries", search_to_start_at, buffer);

   /* Slip Enabled */
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, "SLIP Enabled", search_to_start_at, buffer);
  
   /* CSlip Enabled */
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].cslip_enabled , port_number, "CSLIP Enabled", search_to_start_at, buffer);

   /* MTU */
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].slip_port.maximum_transmit_bufsize, port_number, "MTU", search_to_start_at, buffer);

   /*Dial On Demand Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand, port_number, "Dial On Demand Enabled", search_to_start_at, buffer);

  /*Hangup*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout,port_number, "Hangup", search_to_start_at, buffer);
   ppp.port[0].idle_timeout = ppp.port[0].idle_timeout / 60; /* Sreelu */


#if 0 /* Note REqd for Proxy  */
  /*Remote Port Setup*/
	search_to_start_at = get_value_and_handle_error_6(CM_PPP_SECTION, (void*)&ppp.port[0].client_only, port_number , "Remote Port Setup", search_to_start_at, buffer);
#endif

 
                  
#if 0 /* Note REqd for Proxy  */
  /*PAP Enabled*/
	search_to_start_at = get_value_and_handle_error_3(CM_PPP_SECTION, "PAP", port_number, "PAP Enabled", search_to_start_at, buffer);

  /*Chap Enabled*/
	search_to_start_at = get_value_and_handle_error_3(CM_PPP_SECTION, "CHAP", port_number, "Chap Enabled", search_to_start_at, buffer);
#endif
                
   number_of_saved_indices--;
}

void change_the_ppp_parameters(Request_t* request)
{
	CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	ppp_changed_params = (CHANGE_PPP_CONFIG_PAGE_form_output_type*)form_data_of_request(request);
	if (ppp_changed_params == NULL)
	{
		return;
	}
	make_changes_to_corresponding_ppp_port(ppp_config_port, ppp_changed_params);
   display_standard_main_page(request);
}

void make_changes_to_corresponding_ppp_port(enum wan_port_types ppp_config_port, CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params)
{
   switch(ppp_config_port)
   {
      case WAN_PORT1 :
      	save_the_values_from_ppp_form(ppp_changed_params, 0);
         break;

      case WAN_PORT2 :
      	save_the_values_from_ppp_form(ppp_changed_params, 1);
         break;

      case WAN_PORT3 :
      	save_the_values_from_ppp_form(ppp_changed_params, 2);
         break;

   }
}

void  save_the_values_from_ppp_form(CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params, BYTE port_number)
{
	BYTE answering,async;
	ULONG enabled = 1,not_enabled = 0;
   USHORT search_to_start_at = 0;

	if (ppp_changed_params->ppp_enabled)
	{
		/* Check whether this port is answring if so proceed , otherwise
		   if slip is disabled u can proceed */


		if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer, port_number, CM_INDEX_FORMAT, (void*)&answering, 0) == CM_GET_SUCCESSFUL)
		{
			if (answering)
			{
				set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, (void*)&ppp_changed_params->ppp_enabled, "PPP Enabled");
			}
			else
			/* Is Slip Enabled */
			if (!ppp_changed_params->slip_enabled)
			{
				set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, (void*)&ppp_changed_params->ppp_enabled, "PPP Enabled");
			}
		}
		else
		{
			/* Don't do anything if fail to know if port is answering */
		}
	}
	else
	{
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, (void*)&not_enabled, "PPP Enabled");
	}
   if(ppp_changed_params->ppp_enabled)
   {
	   set_value_and_handle_error_1(CM_CCP_SECTION, (void*)&ccp.ports[0].enabled, port_number, (void*)&ppp_changed_params->data_compression_enabled, "Data Compression Enabled");
	   set_value_and_handle_error_1(CM_VJC_SECTION, (void*)&vjc.port[0].vjc_compression_enabled, port_number, (void*)&ppp_changed_params->vjc_enabled, "VJC Enabled");
   }
   if(ppp_changed_params->ppp_enabled)
   {
	   set_value_and_handle_error_2(CM_PPP_SECTION, (void*)ppp.port[0].authentication.user_name, port_number, (void*)ppp_changed_params->user_name, "User Name");
	   set_value_and_handle_error_2(CM_PPP_SECTION, (void*)ppp.port[0].authentication.password, port_number, (void*)ppp_changed_params->password, "Password");
	   set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout, port_number, (void*)ppp_changed_params->periodic_timer, "Periodic Timer");
	   set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries, port_number, (void*)ppp_changed_params->num_of_retries, "Number Of Retries");
   }
	if (ppp_changed_params->slip_enabled)
	{
		if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer, port_number, CM_INDEX_FORMAT, (void*)&answering, 0) == CM_GET_SUCCESSFUL)
		{
			if (answering)
				set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, (void*)&ppp_changed_params->slip_enabled, "SLIP Enabled");
			else
			 if (!ppp_changed_params->ppp_enabled)
				 set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, (void*)&ppp_changed_params->slip_enabled, "SLIP Enabled");
		}
	}
	else
	{
	 	set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, (void*)&not_enabled, "SLIP Enabled");
	}
	if (ppp_changed_params->slip_enabled)
   {
	   set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].cslip_enabled , port_number, (void*)&ppp_changed_params->cslip_enabled, "CSLIP Enabled");
	   set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].slip_port.maximum_transmit_bufsize, port_number, (void*)ppp_changed_params->maximum_transmit_unit, "MTU");
   }
   get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].asyncport, port_number, CM_INDEX_FORMAT, (void*)&async, 0);
   /*get_value_and_handle_error_6(CM_WAN_SECTION, (void*)&wan.port[0].asyncport, port_number, "Async/Sync", search_to_start_at, buffer);*/
   if (async)
	   set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand, port_number, (void*)&ppp_changed_params->dial_on_demand_enabled, "Dial On Demand Enabled");
   else    /* Added by Sreelu */
   {     /* If Sync */
      set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, (void*)&not_enabled, "SLIP Enabled");
      set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, (void*)&enabled, "PPP Enabled");
	   set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand, port_number, (void*)&not_enabled, "Dial On Demand Enabled");
   }
   if (ppp_changed_params->dial_on_demand_enabled)
   {
      ppp.port[0].idle_timeout = ppp.port[0].idle_timeout * 60 ; /* Sreelu */
   	set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout, port_number, (void*)ppp_changed_params->hangup_time, "Hangup");
   }
}

/* ------------------------- Advanced PPP Configuration ---------------*/
void display_ppp_advanced_page(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying Advanced PPP Page...\n");

/*	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)ADVANCED_PPP_CONFIG, ADVAN_PPP_CONFIG_PAGE_data_ptr);  */
	check_for_need_and_hide_irrelevent_fields(ADVANCED_PPP_CONFIG);

	send_advanced_ppp_page(request, ADVAN_PPP_CONFIG_PAGE_data_ptr);

/*	enable_hyperlink(replaced_anchor_index_in_the_buffer, ADVAN_PPP_CONFIG_PAGE_data_ptr);  */
	show_the_hidden_fields();
}

void	send_advanced_ppp_page(Request_t* request, BYTE* buffer)
{
	fill_the_advanced_ppp_form_with_appropriate_values(buffer);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void	fill_the_advanced_ppp_form_with_appropriate_values(BYTE* buffer)
{
	BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, mlppp_enabled;
	USHORT search_to_start_at = 0;

	number_of_saved_indices = 0;

#if 0 /* Not reqd for FIREWALL */
	/* MLPPP */
   if (get_parameter_by_name(CM_PPP_SECTION, "MLPPP", port_number, CM_INDEX_FORMAT, (void*)&mlppp_enabled, 0) == CM_GET_SUCCESSFUL)
   {
      if (mlppp_enabled)
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
      else
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
   }
   else
   {
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }
#endif

	/* Echo Request - Maximum Number */   
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_unacknowledged_echo_requests, port_number, "Echo Request Max Number", search_to_start_at, buffer);	
	/* Echo Request - Send Interval Max*/   
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_echo_request_send_interval, port_number, "Echo Request Send Interval Max", search_to_start_at, buffer);	

	/* Termination Request - Maximum Number */
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_termination_requests, port_number, "Termination Request Max Number ", search_to_start_at, buffer);	
	/* Termination Request - Send interval Max*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_termination_request_send_interval, port_number, "Termination Send Interval Max", search_to_start_at, buffer);	

	/* Configuration Request - Maximum Number */
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_configuration_requests, port_number, "Configuration Requests Maximum Number", search_to_start_at, buffer);	
	/* Configuration Request - Send Interval Max*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_send_interval, port_number, "Configuration Requests Send interval Max", search_to_start_at, buffer);	
	/* Configuration Request - Backoff Interval Max*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_backoff_interval, port_number, "Configuration Requests Backoff Interval Max", search_to_start_at, buffer);	

	/* Printf*/																		   
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.printing_enabled, port_number, "PPP Printf", search_to_start_at, buffer);	
	/* LCP Printf*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.lcp_printing_enabled, port_number, "LCP Printf", search_to_start_at, buffer);	
	/* Alarm Printf*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.alarm_printing_enabled, port_number, "Alarm Printf", search_to_start_at, buffer);	
	/* NCP Printf*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.ncp_printing_enabled, port_number, "NCP Printf", search_to_start_at, buffer);	

	number_of_saved_indices --;	/* Very Importent statement */

}																						   

void change_advanced_ppp_parameters(Request_t* request)
{
	CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	ppp_changed_params = (CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type*)form_data_of_request(request);
	if (ppp_changed_params == NULL)
	{
		return;
	}
	make_changes_to_advanced_ppp_config(ppp_changed_params);
   display_standard_main_page(request);
}


void make_changes_to_advanced_ppp_config(CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type* advanced_ppp_changed_params)
{
		BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, value;

#if 0 /* Not Reqd for firewall */
      value = (BYTE)advanced_ppp_changed_params->multilink_enabled;
      set_parameter_by_name(CM_PPP_SECTION, "MLPPP", port_number, CM_INDEX_FORMAT, (void*)&value);  
#endif

	/* Echo Request - Maximum Number */   
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_unacknowledged_echo_requests, port_number, (void*)advanced_ppp_changed_params->max_number_echo_request, "Echo Request Max Number");
	/* Echo Request - Send Interval Max*/   
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_echo_request_send_interval, port_number, (void*)advanced_ppp_changed_params->send_interval_max_echo_request, "Echo Request Send Interval Max");

	/* */
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_termination_requests, port_number, (void*)advanced_ppp_changed_params->max_number_terminate_request, "Termination Send Max Number");
	/* */
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_termination_request_send_interval, port_number, (void*)advanced_ppp_changed_params->send_interval_max_terminate_request, "Termination Send Interval Max");
		
	
	/* Configuration Request - Maximum Number */
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_configuration_requests, port_number, (void*)advanced_ppp_changed_params->max_number_configuration_request, "Configuration Request - Maximum Number");
	/* Configuration Request - Send Interval Max*/
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_send_interval, port_number, (void*)advanced_ppp_changed_params->send_interval_max_configuration_request, "Configuration Request - Send Interval Max");
	/* Configuration Request - Backoff Interval Max*/
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_backoff_interval, port_number, (void*)advanced_ppp_changed_params->backoff_interval_max, "Configuration Request - Backoff Interval Max");
		
	/* Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.printing_enabled, port_number, (void*)&advanced_ppp_changed_params->printf_enabled, "Printf");
	/* LCP Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.lcp_printing_enabled, port_number, (void*)&advanced_ppp_changed_params->lcp_printf_enabled, "LCP Printf");
	/* Alarm Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.alarm_printing_enabled, port_number, (void*)&advanced_ppp_changed_params->alarm_printf_enabled, "Alarm Printf");
	/* NCP Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.ncp_printing_enabled, port_number, (void*)&advanced_ppp_changed_params->ncp_printf_enabled, "NCP Printf");
}

/* --------------------------- Util Functions --------------------------*/

/* NOTE: The following function assumes that search_string length is equal 
 			to replace_string length */

int search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at)
{
	USHORT buffer_length, i, j, search_string_starting_index;

	buffer_length = strlen(buffer);

	for(i = search_to_start_at + 1, j = 0; i <= buffer_length; ++i)
	{
		if (buffer[i] == search_string[j])
		{
			if ( j == 0) /*Remember where the search string starts in the buffer*/
				search_string_starting_index = i;

			if (j == (strlen(search_string)-1)) /* Search completed? */
			{
				if (required_to_replace)
					replace_string_starting_from_index(search_string, search_string_starting_index, replace_string, buffer);
				return (search_string_starting_index);
			}

			j++;
		}
		else
		{
			if (j)
			{
			  	i = search_string_starting_index;
		  		j = 0;
			}
		}
	}
#ifdef _NAVDEBUG_
		printf("Search String not found in the buffer %s\n", search_string);
#endif
	return(-1);
}

void replace_string_starting_from_index(BYTE* search_string, USHORT search_string_starting_index, char* replace_string, char* buffer)
{
	USHORT i, replace_string_length, search_string_length;

	replace_string_length = strlen(replace_string);
	search_string_length = strlen(search_string);

	for(i=0; i < search_string_length; ++i)
		buffer[search_string_starting_index+i] = 32;

	for(i=0; i < replace_string_length; ++i)
		buffer[search_string_starting_index+i] = replace_string[i];
}

USHORT	disable_hyperlink_and_change_text_colour(USHORT port_type, BYTE* buffer)
{
	USHORT port_number;
	USHORT i, search_to_start_at = 0, temp;

	port_number = port_type;

	for(i = 0;i < port_number;++i)
	{
		temp = search_and_replace("<A ","<!A", buffer, FALSE, search_to_start_at);
	   search_to_start_at = temp;
	}
	return (search_and_replace("<A ","<!A", buffer, TRUE, search_to_start_at));
}

void enable_hyperlink(USHORT replaced_anchor_index_in_the_buffer, BYTE* buffer)
{
	replace_string_starting_from_index(" ", replaced_anchor_index_in_the_buffer, "<A ", buffer);
}

void check_for_need_and_hide_irrelevent_fields()
{
}

void show_the_hidden_fields()
{
}

void revert_back_form(char* buffer)
{
	USHORT i;
   for(i=0; i <= number_of_saved_indices; ++i)
	{
		replace_string_starting_from_index(" ",saved_indices[i].string_starting_index, templates[saved_indices[i].template_type], buffer);
	}
	number_of_saved_indices = 0;
}

void write_the_setup_and_reboot(Request_t* request)
{  
	BYTE buffer[] = "Configuration is being written to Flash. Afterwards router will be rebooted and it is required to establish connection once again with the router for configuration";
   enum CM_WRITE_RESULTS write_results;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   write_results = cm_write_configuration();
   if (write_results != CM_WRITE_SUCCESS)
   {               
      printf("Failed to Write \n");      
   }
	else
	{
	   cm_deinitialize_configuration_manager(CM_OWNED_BY_HTTP);
	}
}

/* Added by Sreelu for SNTP.... */
void display_sntp_page(Request_t* request)
{
	BYTE *buffer, return_byte[10];
	char hrs[10], mins[10], time[10];
	int hour, minute, index;
	USHORT search_to_start_at = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	buffer = (BYTE *) malloc (strlen(SNTP_CLIENT_data_ptr));
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, SNTP_CLIENT_data_ptr);
	
	/* SNTP Client */
 	search_to_start_at = get_value_and_handle_error_3(CM_SNTP_SECTION, "SNTP", CM_NO_PORT_PARAMETER_PRESENT, "SNTP", search_to_start_at, buffer);
	
	/* SNTP Server Address */
	search_to_start_at = get_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Server IP Address", CM_NO_PORT_PARAMETER_PRESENT, "SNTP Server IP Address", search_to_start_at, buffer);

	/* Time Zone Standard Name */
	search_to_start_at = get_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP TimeZone Standard Name", CM_NO_PORT_PARAMETER_PRESENT, "SNTP TimeZone Standard Name", search_to_start_at, buffer);

	/* Offset from UTC */
	search_to_start_at = get_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Offset From UTC", CM_NO_PORT_PARAMETER_PRESENT, "SNTP Offset From UTC", search_to_start_at, buffer);

	/* DayLight Savings */
	search_to_start_at = get_value_and_handle_error_3(CM_SNTP_SECTION, "SNTP Daylight Savings", CM_NO_PORT_PARAMETER_PRESENT, "SNTP Daylight Savings", search_to_start_at, buffer);

	/* Offset for Daylight Savings */
	search_to_start_at = get_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Daylight Offset", CM_NO_PORT_PARAMETER_PRESENT, "SNTP Daylight Offset", search_to_start_at, buffer);

	/* Start Ordinal */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Day",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void*)&return_byte[0], 10);
	index = atoi(return_byte) - 1;
	search_to_start_at = search_and_replace("Ordinal", " ", buffer, FALSE, search_to_start_at);
	search_to_start_at = search_and_replace_with_index_for_menu_boxes(index, search_to_start_at, buffer);
	printf("Start Ordinal : %d\n", index);

	/* Start Day */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start WeekDay",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void*)&return_byte[0], 10);
	index = atoi(return_byte);
	search_to_start_at = search_and_replace("WeekDay", " ", buffer, FALSE, search_to_start_at);
	search_to_start_at = search_and_replace_with_index_for_menu_boxes(index, search_to_start_at, buffer);
	printf("Start Day : %d\n", index);

	/* Start Month */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Month",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void*)&return_byte[0], 10);
	index = atoi(return_byte) - 1;
	search_to_start_at = search_and_replace("Month", " ", buffer, FALSE, search_to_start_at);
	search_to_start_at = search_and_replace_with_index_for_menu_boxes(index, search_to_start_at, buffer);
	printf("Start Month : %d\n", index);

	/* Start Time */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Time Hour",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&hrs[0], 20);

	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight Start Time Minute",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&mins[0], 20);

	hour = atoi(hrs);
	minute = atoi(mins);
	sprintf(time, "%02d:%02d", hour, minute);
printf("Start Time : %s\n", time);
	search_to_start_at = search_and_replace("#___TEXT___#___", time, buffer, TRUE, search_to_start_at);
	
	/* End Ordinal */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Day",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void*)&return_byte[0], 10);
	index = atoi(return_byte) - 1;
	search_to_start_at = search_and_replace("Ordinal", " ", buffer, FALSE, search_to_start_at);
	search_to_start_at = search_and_replace_with_index_for_menu_boxes(index, search_to_start_at, buffer); 
	printf("End Ordinal : %d\n", index);

	/* End Day */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End WeekDay",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void*)&return_byte[0], 10);
	index = atoi(return_byte);
	search_to_start_at = search_and_replace("WeekDay", " ", buffer, FALSE, search_to_start_at);
	search_to_start_at = search_and_replace_with_index_for_menu_boxes(index, search_to_start_at, buffer);
	printf("End Day : %d\n", index);

	/* End Month */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Month",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void*)&return_byte[0], 10);
	index = atoi(return_byte) - 1 ;
	search_to_start_at = search_and_replace("Month", " ", buffer, FALSE, search_to_start_at);
	search_to_start_at = search_and_replace_with_index_for_menu_boxes(index, search_to_start_at, buffer);
	printf("End Month : %d\n", index);

	/* End Time */
	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Time Hour",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&hrs[0], 20);

	get_parameter_by_name (CM_SNTP_SECTION, "SNTP Daylight End Time Minute",
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&mins[0], 20);

	hour = atoi(hrs);
	minute = atoi(mins);
	sprintf(time, "%02d:%02d", hour, minute);
printf("Start Time : %s\n", time);
	search_to_start_at = search_and_replace("#___TEXT___#___", time, buffer, TRUE, search_to_start_at);
	
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free (buffer);
}

void change_sntp_parameters(Request_t* request)
{
	char time[10];
	int hrs, mins;
	CHANGE_SNTP_PARAMS_form_output_type *sntp_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	sntp_changed_params = (CHANGE_SNTP_PARAMS_form_output_type*)form_data_of_request(request);
	if (sntp_changed_params == NULL)
		return;

	if(sntp_changed_params->sntp_client)
		set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP", CM_NO_PORT_PARAMETER_PRESENT, (void*)&telnet_enabled_str, "SNTP");
	else
		set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP", CM_NO_PORT_PARAMETER_PRESENT, (void*)&telnet_disabled_str, "SNTP");

	if(sntp_changed_params->sntp_client)
	{
		printf("SNTP Enabled\n");
		if(validate_ip_address ((BYTE *)sntp_changed_params->ip_address) == FALSE)
		{
        	display_standard_main_page(request);
			return;					
		}

		if(is_an_ip_address ((BYTE *)sntp_changed_params->ip_address) == FALSE)
		{
        	display_standard_main_page(request);
			return;					
		}

		set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Server IP Address", CM_NO_PORT_PARAMETER_PRESENT, (void*)sntp_changed_params->ip_address, "SNTP");
		set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP TimeZone Standard Name", CM_NO_PORT_PARAMETER_PRESENT, (void*)sntp_changed_params->time_zone, "SNTP");
		if(!validate_time((BYTE *)sntp_changed_params->utc_offset, &time[0], &hrs, &mins))
		{
        	display_standard_main_page(request);
			return;					
		}
		set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Offset From UTC", CM_NO_PORT_PARAMETER_PRESENT, (void*)&time[0], "SNTP");
		if(sntp_changed_params->daylight_savings)
			set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Daylight Savings", CM_NO_PORT_PARAMETER_PRESENT, (void*)telnet_enabled_str, "SNTP");
		else
			set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Daylight Savings", CM_NO_PORT_PARAMETER_PRESENT, (void*)telnet_disabled_str, "SNTP");

		if(sntp_changed_params->daylight_savings)
		{
			printf("Daylight Enabled\n");
			set_value_and_handle_error_4(CM_SNTP_SECTION, "SNTP Daylight Offset", CM_NO_PORT_PARAMETER_PRESENT, (void*)sntp_changed_params->daylight_offset, "SNTP");
			sntp_changed_params->s_ordinal++;
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight Start Day", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&sntp_changed_params->s_ordinal);
			sntp_changed_params->e_ordinal++;
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight End Day", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&sntp_changed_params->e_ordinal);
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight Start WeekDay", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&sntp_changed_params->s_weekday);
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight End WeekDay", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&sntp_changed_params->e_weekday);
			sntp_changed_params->s_month++;
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight Start Month", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&sntp_changed_params->s_month);
			sntp_changed_params->e_month++;
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight End Month", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&sntp_changed_params->e_month);

			if(!validate_time(sntp_changed_params->start_time, &time[0], &hrs, &mins))
			{
         	display_standard_main_page(request);
				return;					
			}
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight Start Time Hour", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&hrs);
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight Start Time Minute", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&mins);

			if(!validate_time(sntp_changed_params->end_time, &time[0], &hrs, &mins))
			{
         	display_standard_main_page(request);
				return;					
			}
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight End Time Hour", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&hrs);
			set_parameter_by_name(CM_SNTP_SECTION, "SNTP Daylight End Time Minute", CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&mins);
		}
		else 
			printf("Daylight Disabled\n");
	}
	else
			printf("SNTP Disabled\n");
   display_standard_main_page(request);
}
/* ....Added by Sreelu for SNTP */

void display_filter_menu(Request_t* request)
{

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   InitReturnBuffer(request, FILTER_MAIN_MENU_data_ptr, strlen(FILTER_MAIN_MENU_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

#if 0
void give_the_background_logo(Request_t* request)
{
   InitReturnBuffer(request, BACKGROUND_LOGO_data_ptr, strlen(BACKGROUND_LOGO_data_ptr), GIF_CONTENT_TYPE, TRUE);
}
#endif


void give_the_background_logo(Request_t* request)
{
   InitReturnBuffer(request, BACKGROUND_LOGO_data_ptr, BACKGROUND_LOGO_compiled_buffer.data_size, GIF_CONTENT_TYPE, TRUE);
}


void give_the_mts_logo(Request_t* request)
{
   InitReturnBuffer(request, MTS_LOGO_data_ptr, MTS_LOGO_compiled_buffer.data_size, GIF_CONTENT_TYPE, TRUE);
}

void give_the_mtr_logo(Request_t* request)
{
   InitReturnBuffer(request, MTR_LOGO_data_ptr, MTR_LOGO_compiled_buffer.data_size, GIF_CONTENT_TYPE, TRUE);
}

void give_the_construction_logo(Request_t* request)
{
   InitReturnBuffer(request, CONSTRUCTION_LOGO_data_ptr, CONSTRUCTION_LOGO_compiled_buffer.data_size, GIF_CONTENT_TYPE, TRUE);
}

#if 0
#include "navcla.h"
void give_the_class(Request_t* request)
{  
   printf("Yahooooooooooo.................\n");
   InitReturnBuffer(request, navclass_data_ptr, navclass_compiled_buffer.data_size, UNKNOWN_CONTENT_TYPE, TRUE);
}

#include "nav.h"
void give_the_htm(Request_t* request)
{
   InitReturnBuffer(request, nav_data_ptr, strlen(nav_data_ptr), HTML_CONTENT_TYPE, TRUE);
}
#endif

