/*----------------------------------------------------------------------------
	File        : USERMGMT.C
	Author      : S.Srilakshmi & Neelu Gutch
	Description : Contains code to handle the user database Configuration.
----------------------------------------------------------------------------*/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "..\..\..\..\store\boot.h"
#include "..\..\..\..\include\redblack.h"
#include "\rtrware\applicat\userdata\kuser.h"
#include "\rtrware\applicat\userdata\vuserstr.h"

#include "..\..\..\..\include\udb.h"

extern USER_DATABASE_CLASS user_database;
TEMP_GROUP_PROFILE contents_of_group_entry_page[10];
TEMP_GROUP_PROFILE *ptr_to_add_time_permission;
USHORT GroupStatus[30];
USHORT selected_filter_type;

#define NUMBER_OF_ENTRIES_PER_PAGE 10
#define MAX_NO_OF_GROUP_ENTRIES    25
/*	Sreelu for Access Rights.... */
extern USHORT disable_the_link_to_display_prev_10(BYTE* , USHORT );

void *current_ten_ptr[NUMBER_OF_ENTRIES_PER_PAGE];
void *current_ptr_to_edit;
extern USHORT deleted_group;
/*....Sreelu for Access Rights */

#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

#include "usermgmt.h"

/* Added by Sreelu for Access Rights.... */
#include "ipdeft.h"  
#include "ipdeftfm.h"

#include "appdeft.h"  
#include "appdeftf.h"
#include "accrtsfm.h"
#include "vedipdft.h"
#include "vedapdft.h"
#include "edtipdft.h"
#include "edtipdfm.h"
#include "edtapdft.h"
#include "edtapdfm.h"
#include "filtmint.h"
#include "addfilft.h"
#include "addfilfm.h"
#include "vdelfilt.h"
#include "delfilft.h"
#include "delfilfm.h"

#include "gropmenu.h"
#include "addgroup.h"
#include "adgropfm.h"
#include "vedudb.h"
#include "edtgroup.h"
#include "edtgropf.h"
#include "timeperm.h"
#include "timprmfm.h"
#include "usermenu.h"
#include "adduser.h"
#include "aduserfm.h"
#include "edtuser.h"
#include "edtusrfm.h"
#include "vedusr.h"
#include "grpmaskm.h"
#include "grpmaskt.h"
#include "userdata.h"
#include "usrdeft.h"
#include "usrdeftm.h"




#define ADD_ENTRY 1
#define EDIT_ENTRY 2

int *counter=0;
int *usrcounter=0;
int *ptrgroup=0;
int *ptr_edit = 0;
BOOL flag_for_time_permission;
BOOL flag_edit = FALSE;

TEMP_GROUP_PROFILE contents_of_group_entry_page[10];
TEMP_USER_PROFILE contents_of_user_entry_page[10];
TEMP_GROUP_PROFILE *ptr_to_edit_time_permission;

USHORT hide_remaining_hyper_links_on_which_there_is_no_group_entry_for_user(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer);
USHORT hide_remaining_hyper_links_on_which_there_is_no_group_entry_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer);
BYTE save_the_number_of_group_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
void display_next_ten_group_entries(Request_t* request);
TEMP_GROUP_PROFILE* next_group_entry_from_where_display_is_reqd_to_continue(TEMP_GROUP_PROFILE* last_node, BYTE is_required_to_save);
void display_next_ten_group_entries(Request_t* request);
void display_the_table_for_time_restriction(Request_t* request);
void delete_the_group_entry(Request_t* request);
BYTE save_the_number_of_user_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
void delete_the_user_entry(Request_t* request);
int update_combo_box(int total_no_of_items, int no_of_selected_item,BYTE *buffer,int search_to_start_at);

extern enum UDB_MODIFY udb_group_insert(TEMP_GROUP_PROFILE *);
extern enum UDB_MODIFY udb_group_delete(TEMP_GROUP_PROFILE *);
extern enum UDB_MODIFY udb_group_edit(TEMP_GROUP_PROFILE *);

extern enum UDB_MODIFY udb_user_insert(TEMP_USER_PROFILE *);
extern enum UDB_MODIFY udb_user_delete(TEMP_USER_PROFILE *);
extern enum UDB_MODIFY udb_user_edit(TEMP_USER_PROFILE *);

extern enum UDB_MODIFY udb_ip_default_insert(TEMP_IP_DEFAULT *);
extern enum UDB_MODIFY udb_ip_default_delete(TEMP_IP_DEFAULT *);
extern enum UDB_MODIFY udb_ip_default_edit(TEMP_IP_DEFAULT *);

extern enum UDB_MODIFY udb_app_default_insert(TEMP_APP_DEFAULT *);
extern enum UDB_MODIFY udb_app_default_delete(TEMP_APP_DEFAULT *);
extern enum UDB_MODIFY udb_app_default_edit(TEMP_APP_DEFAULT *);

extern enum UDB_MODIFY udb_filter_insert(FILTER_DATA *);
extern enum UDB_MODIFY udb_filter_delete(FILTER_DATA *);
BYTE_ENUM (BOOLEAN) is_for_group_select = FALSE;
extern void set_group_filter_enabled(USHORT , ULONG *);
extern enum BOOLEAN is_filter_enabled(USHORT , ULONG *);
extern void set_group_filter_disabled(USHORT , ULONG *);
extern void change_filter_masks(int);
extern void display_standard_main_page(Request_t*);
/* ....Sreelu for Access Rights */

/* Neelu on 29/1/99 */
extern BYTE *my_itoa (long number, BYTE *buf, int radix) ; /* Sreelu */
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE*   templates[];
void display_ip_from_current_ten_ptrs();
void display_app_from_current_ten_ptrs();
void display_filter_from_current_ten_ptrs();
void display_group_status();

void order_group_numbers_in_ascending()
{
	GROUP_DATA *ptr_to_group;
	int index = 1;

	user_database.num_of_groups = 0;
	ptr_to_group = user_database.sptr_temp_group_data;
	while(ptr_to_group != NULL)
	{
		ptr_to_group->data->group_no = index;
		ptr_to_group = ptr_to_group->next_node;
		user_database.num_of_groups++;
		index++;
	}
}

void display_user_management_menu(Request_t* request)
{
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

#if 1
   register_debugger(display_ip_from_current_ten_ptrs, "CURRIP");
   register_debugger(display_app_from_current_ten_ptrs, "CURRAPP");
   register_debugger(display_filter_from_current_ten_ptrs, "CURRFILT");
   register_debugger(display_group_status, "GRPSTAT");
#endif
			
	InitReturnBuffer(request, USER_MANAGEMENT_data_ptr, strlen(USER_MANAGEMENT_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

/* Added by Sreelu for Userdatabase ....... */
void display_user_default_menu(Request_t* request)
{
   BYTE* buffer;
   USHORT search_to_start_at=0;   
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = (BYTE *) calloc(strlen(USER_DEFAULT_data_ptr), 1);
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
	strcpy(buffer, USER_DEFAULT_data_ptr);
	if(user_database.temp_enabled)
		search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at);

	if(user_database.temp_action == FORWARD_ACTION)
	{
		search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at);
		search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at);
	}
	else
	{
		search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at);
		search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at);
	}

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
}

void add_defaults_to_userdatabase_class(Request_t* request)
{
	USER_DEFAULT_DATA_form_output_type *default_data;

	default_data = (USER_DEFAULT_DATA_form_output_type *)form_data_of_request(request);
	user_database.temp_enabled = default_data->udb_enabled;

/*sri printf("Enabled : Action : %d : %d\n", default_data->udb_enabled, default_data->filter_action);	 */

	if(!user_database.temp_enabled)
		user_database.temp_action = (!default_data->filter_action) ? FORWARD_ACTION : FILTER_ACTION;
	else
		user_database.temp_action = FORWARD_ACTION;
		
#if 0	/* sritemp */
		if(!default_data->filter_action)
			user_database.temp_action = FORWARD_ACTION;
		else
			user_database.temp_action = FILTER_ACTION;
#endif
	
	InitReturnBuffer(request, USER_MANAGEMENT_data_ptr, strlen(USER_MANAGEMENT_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_user_database_menu(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!user_database.temp_enabled)
	{
		InitReturnBuffer(request, USER_MANAGEMENT_data_ptr, strlen(USER_MANAGEMENT_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	is_for_group_select = TRUE;
	InitReturnBuffer(request, USER_DATABASE_ENTRY_data_ptr, strlen(USER_DATABASE_ENTRY_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

/* Added by Neelu for Groups & Users..... */
void display_group_menu(Request_t* request)
{
	
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	 flag_for_time_permission = FALSE;
		InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_page_to_add_group_entry(Request_t* request)
{
   USHORT search_to_start_at=0;   
   BYTE* buffer;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	buffer = (BYTE *) calloc(strlen(ADD_GROUP_ENTRY_data_ptr), 1);
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
	strcpy(buffer, ADD_GROUP_ENTRY_data_ptr);

	search_to_start_at = search_and_replace("#___TEXT___#___                         ", "", buffer, TRUE, search_to_start_at); /* Groupname */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* GroupDesc */
	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* Audit Blacklist */
	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* Audit login */
	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* Defaulter login */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Groupname */
  	search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* defaulter Blacklist */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Groupname */
	
	ptr_to_edit_time_permission = (TEMP_GROUP_PROFILE *) calloc(sizeof(TEMP_GROUP_PROFILE), 1); /* Added by Sreelu */

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

BYTE display_the_table_called_from(BYTE new_value, BYTE is_to_save)
{
   static BYTE value = 0;
   if (is_to_save)
      value = new_value;
   else
      return value;
}

void display_the_table_for_time_restriction(Request_t* request)
{
	BYTE* buffer;
	USHORT search_to_start_at = 0;
	int i=0;
	TEMP_GROUP_PROFILE *ptr_group; /* sreeelu */

	if(!check_whether_user_is_authenticated_or_not(request))
	return;
   
	ptr_group = ptr_to_edit_time_permission;
		
	buffer = (BYTE *) calloc(strlen(TIME_PERMISSION_TABLE_data_ptr), 1);
	
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for time permission table \n");
		return;
	}
	strcpy(buffer, TIME_PERMISSION_TABLE_data_ptr);

	for(i=0;i<168;i++)
	{
			search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 
	}
	
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
}


void display_the_time_permission_table(Request_t* request)
{
	BYTE* buffer;
	USHORT search_to_start_at = 0;
	int i=0;
	TEMP_GROUP_PROFILE *ptr_group;  
	TIME_PERMISSION_TABLE_form_output_type *time_entry_to_add;
	
	ULONG Bitarray[24] = {1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,
			    16384,32768,65536,131072,262144,524288,1048576,2097152,
			    4194304,8388608};
	
	int ButtonId[168]; 
	int j=0,k=0,l=0,m=0;
	USHORT bitno;
	ULONG Time_Set = 16777215,Time_Permission[7];
	
	
	if(!check_whether_user_is_authenticated_or_not(request))
	return;
   
/*	ptr_group = (TEMP_GROUP_PROFILE *) current_ptr_to_edit;*/
	ptr_group =	ptr_to_edit_time_permission;
		
	buffer = (BYTE *) calloc(strlen(TIME_PERMISSION_TABLE_data_ptr), 1);
	
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for time permission table \n");
		return;
	}
	strcpy(buffer, TIME_PERMISSION_TABLE_data_ptr);

	time_entry_to_add = (TIME_PERMISSION_TABLE_form_output_type *) form_data_of_request(request);
	
	if(time_entry_to_add == NULL)
	{
		printf("USERMGMT : Request Failed to Get time prmissoin...");
		return;
	}
	for(i=0; i<7; i++)
	{
		Time_Permission[i] = ptr_group->user_permission[i];
		for(j=0; j<24; j++)
		{
			bitno = j % 24;
			if((Time_Permission[i] & Bitarray[bitno]) == Bitarray[bitno])
			{	
				ButtonId[k] = 1;
  			}
			else
			{ 
				ButtonId[k] = 0;
  			}
  			k++;
  		 }
	 }
	
	
	for(m=0;m<168;m++)
	{
		if(ButtonId[m] == 1)	
			search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 
		else
			search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at); 
			
	}
	 
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
}

void submit_user_permission(Request_t* request)
{
	TEMP_GROUP_PROFILE *ptr_group; /* sreeelu */
	BYTE* buffer, temp_buffer[40],temp_buffer1[40],temp_buffer3[40],temp_buffer4[40];
	USHORT search_to_start_at = 0;
	int ButtonId[168]; 
	int i=0,j=0,k=0,l=0;
/*	ULONG Bitarray[24] = {1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,
				    16384,32768,65536,131072,262144,524288,1048576,2097152,
				    4194304,8388608}; */

/*	ULONG Bitarray[24] ={0,1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,
					16383,32767,65535,131071,262143,524287,1048575,2097151,
					4194303,8388607};*/
	
	ULONG Bitarray[24] = {16777214,16777213,16777211,16777207,16777199, 16777183,
								16777151,16777087,16776959,16776703,16776191,16775167,
								16773119,16769023,16760831,16744447,16711679,16646143,16515071,
								16252927,15728639,14680063,12582911,8388607};
																								
  
					
	USHORT bitno;
	ULONG Time_Set = 16777215,Time_Permission[7];
	ULONG time_set = 0;
	TIME_PERMISSION_TABLE_form_output_type *time_entry_to_add;
	
	if(!check_whether_user_is_authenticated_or_not(request))
	return;
	
  	ptr_group = ptr_to_edit_time_permission; /* Sreelu */
/*sri  	ptr_group = (TEMP_GROUP_PROFILE *) current_ptr_to_edit; */

	time_entry_to_add = (TIME_PERMISSION_TABLE_form_output_type *) form_data_of_request(request);
	if(time_entry_to_add == NULL)
	{
		printf("USERMGMT : Request Failed to Get time prmissoin...");
		return;
	}
	
   if (display_the_table_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
		buffer = (BYTE *) calloc(strlen(ADD_GROUP_ENTRY_data_ptr), 1);
	}
   else
   {
		buffer = (BYTE *) calloc(strlen(EDIT_GROUP_ENTRY_data_ptr), 1);
	}
		
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}

   if (display_the_table_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
		strcpy(buffer, ADD_GROUP_ENTRY_data_ptr);
	}
	else
	{
		strcpy(buffer, EDIT_GROUP_ENTRY_data_ptr);
      
	}
	
	if (display_the_table_called_from(FALSE, FALSE) == ADD_ENTRY)
	{
		search_to_start_at = search_and_replace("#___TEXT___#___                         ", "", buffer, TRUE, search_to_start_at); /* Groupname */
		search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* GroupDesc */
		search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* Defaulter login */
		search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Groupname */
		search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* defaulter Blacklist */
		search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Groupname */
	}
   else
	{
		sprintf(temp_buffer, "%s", ptr_to_edit_time_permission->group_name);
		search_to_start_at = search_and_replace("#___TEXT___#___                         ", temp_buffer, buffer, TRUE, search_to_start_at); /* Groupname */
		
		sprintf(temp_buffer1, "%s",ptr_to_edit_time_permission->group_description);
		search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer1, buffer, TRUE, search_to_start_at); /* GroupDesc */
		
		if(ptr_to_edit_time_permission->defaulter_login_attempts == 1)
			search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ;  /* Defaulter login */
		else
			search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* Defaulter login */
	
		sprintf(temp_buffer3, "%d", ptr_to_edit_time_permission->defaulter_number_of_login_attempts);
		search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer3, buffer, TRUE, search_to_start_at); /* Groupname */
		
		if(ptr_to_edit_time_permission->defaulter_blacklisted_sites == 1)
			search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ;  /* Defaulter login */
		else
			search_to_start_at = search_and_replace("#__CBOX", "", buffer, TRUE, search_to_start_at) ;  /* Defaulter login */
			
	   sprintf(temp_buffer4, "%d",ptr_to_edit_time_permission->defaulter_number_of_attempts_of_blacklisted_sites);
		search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer4, buffer, TRUE, search_to_start_at); /* Groupname */
		
	}
	ButtonId[0] = time_entry_to_add->one;
	ButtonId[1] = time_entry_to_add->two;
	ButtonId[2] = time_entry_to_add->three;
	ButtonId[3] = time_entry_to_add->four;
	ButtonId[4] = time_entry_to_add->five;
	ButtonId[5] = time_entry_to_add->six;
	ButtonId[6] = time_entry_to_add->seven;
	ButtonId[7] = time_entry_to_add->eight;
	ButtonId[8] = time_entry_to_add->nine;
	ButtonId[9] = time_entry_to_add->ten;
	ButtonId[10] = time_entry_to_add->eleven;
	ButtonId[11] = time_entry_to_add->twelve;
	ButtonId[12] = time_entry_to_add->thirteen;
	ButtonId[13] = time_entry_to_add->fourteen;
	ButtonId[14] = time_entry_to_add->fifteen;
	ButtonId[15] = time_entry_to_add->sixteen;
	ButtonId[16] = time_entry_to_add->seventeen;
	ButtonId[17] = time_entry_to_add->eighteen;
	ButtonId[18] = time_entry_to_add->nineteen;
	ButtonId[19] = time_entry_to_add->twenty;
	ButtonId[20] = time_entry_to_add->twentyone;
	ButtonId[21] = time_entry_to_add->twentytwo;
	ButtonId[22] = time_entry_to_add->twentythree;
	ButtonId[23] = time_entry_to_add->twentyfour;
	ButtonId[24] = time_entry_to_add->mone;
	ButtonId[25] = time_entry_to_add->mtwo;
	ButtonId[26] = time_entry_to_add->mThree;
	ButtonId[27] = time_entry_to_add->mfour;
	ButtonId[28] = time_entry_to_add->mfive;
	ButtonId[29] = time_entry_to_add->msix;
	ButtonId[30] = time_entry_to_add->mseven;
	ButtonId[31] = time_entry_to_add->meight;
	ButtonId[32] = time_entry_to_add->mnine;
	ButtonId[33] = time_entry_to_add->mten;
	ButtonId[34] = time_entry_to_add->meleven;
	ButtonId[35] = time_entry_to_add->mtwelve;
	ButtonId[36] = time_entry_to_add->mthirteen;
	ButtonId[37] = time_entry_to_add->mfourteen;
	ButtonId[38] = time_entry_to_add->mfifteen;
	ButtonId[39] = time_entry_to_add->msixteen;
	ButtonId[40] = time_entry_to_add->mseventeen;
	ButtonId[41] = time_entry_to_add->meighteen;
	ButtonId[42] = time_entry_to_add->mnineteen;
	ButtonId[43] = time_entry_to_add->mtwenty;
	ButtonId[44] = time_entry_to_add->mtwentyone;
	ButtonId[45] = time_entry_to_add->mtwentytwo;
	ButtonId[46] = time_entry_to_add->mtwentythree;
	ButtonId[47] = time_entry_to_add->mtwentyfour;
	ButtonId[48] = time_entry_to_add->tuone;
	ButtonId[49] = time_entry_to_add->tutwo;
	ButtonId[50] = time_entry_to_add->tuThree;
	ButtonId[51] = time_entry_to_add->tufour;
	ButtonId[52] = time_entry_to_add->tufive;
	ButtonId[53] = time_entry_to_add->tusix;
	ButtonId[54] = time_entry_to_add->tuseven;
	ButtonId[55] = time_entry_to_add->tueight;
	ButtonId[56] = time_entry_to_add->tunine;
	ButtonId[57] = time_entry_to_add->tuten;
	ButtonId[58] = time_entry_to_add->tueleven;
	ButtonId[59] = time_entry_to_add->tutwelve;
	ButtonId[60] = time_entry_to_add->tuthirteen;
	ButtonId[61] = time_entry_to_add->tufourteen;
	ButtonId[62] = time_entry_to_add->tufifteen;
	ButtonId[63] = time_entry_to_add->tusixteen;
	ButtonId[64] = time_entry_to_add->tuseventeen;
	ButtonId[65] = time_entry_to_add->tueighteen;
	ButtonId[66] = time_entry_to_add->tunineteen;
	ButtonId[67] = time_entry_to_add->tutwenty;
	ButtonId[68] = time_entry_to_add->tutwentyone;
	ButtonId[69] = time_entry_to_add->tutwentytwo;
	ButtonId[70] = time_entry_to_add->tutwentythree;
	ButtonId[71] = time_entry_to_add->tutwentyfour;
	ButtonId[72] = time_entry_to_add->wone;
	ButtonId[73] = time_entry_to_add->wtwo;
	ButtonId[74] = time_entry_to_add->wThree;
	ButtonId[75] = time_entry_to_add->wfour;
	ButtonId[76] = time_entry_to_add->wfive;
	ButtonId[77] = time_entry_to_add->wsix;
	ButtonId[78] = time_entry_to_add->wseven;
	ButtonId[79] = time_entry_to_add->weight;
	ButtonId[80] = time_entry_to_add->wnine;
	ButtonId[81] = time_entry_to_add->wten;
	ButtonId[82] = time_entry_to_add->weleven;
	ButtonId[83] = time_entry_to_add->wtwelve;
	ButtonId[84] = time_entry_to_add->wthirteen;
	ButtonId[85] = time_entry_to_add->wfourteen;
	ButtonId[86] = time_entry_to_add->wfifteen;
	ButtonId[87] = time_entry_to_add->wsixteen;
	ButtonId[88] = time_entry_to_add->wseventeen;
	ButtonId[89] = time_entry_to_add->weighteen;
	ButtonId[90] = time_entry_to_add->wnineteen;
	ButtonId[91] = time_entry_to_add->wtwenty;
	ButtonId[92] = time_entry_to_add->wtwentyone;
	ButtonId[93] = time_entry_to_add->wtwentytwo;
	ButtonId[94] = time_entry_to_add->wtwentythree;
	ButtonId[95] = time_entry_to_add->wtwentyfour;
	ButtonId[96] = time_entry_to_add->tone;
	ButtonId[97] = time_entry_to_add->ttwo;
	ButtonId[98] = time_entry_to_add->tThree;
	ButtonId[99] = time_entry_to_add->tfour;
	ButtonId[100] = time_entry_to_add->tfive;
	ButtonId[101] = time_entry_to_add->tsix;
	ButtonId[102] = time_entry_to_add->tseven;
	ButtonId[103] = time_entry_to_add->teight;
	ButtonId[104] = time_entry_to_add->tnine;
	ButtonId[105] = time_entry_to_add->tten;
	ButtonId[106] = time_entry_to_add->televen;
	ButtonId[107] = time_entry_to_add->ttwelve;
	ButtonId[108] = time_entry_to_add->tthirteen;
	ButtonId[109] = time_entry_to_add->tfourteen;
	ButtonId[110] = time_entry_to_add->tfifteen;
	ButtonId[111] = time_entry_to_add->tsixteen;
	ButtonId[112] = time_entry_to_add->tseventeen;
	ButtonId[113] = time_entry_to_add->teighteen;
	ButtonId[114] = time_entry_to_add->tnineteen;
	ButtonId[115] = time_entry_to_add->ttwenty;
	ButtonId[116] = time_entry_to_add->ttwentyone;
	ButtonId[117] = time_entry_to_add->ttwentytwo;
	ButtonId[118] = time_entry_to_add->ttwentythree;
	ButtonId[119] = time_entry_to_add->ttwentyfour;
	ButtonId[120] = time_entry_to_add->fone;
	ButtonId[121] = time_entry_to_add->ftwo;
	ButtonId[122] = time_entry_to_add->fThree;
	ButtonId[123] = time_entry_to_add->ffour;
	ButtonId[124] = time_entry_to_add->ffive;
	ButtonId[125] = time_entry_to_add->fsix;
	ButtonId[126] = time_entry_to_add->fseven;
	ButtonId[127] = time_entry_to_add->feight;
	ButtonId[128] = time_entry_to_add->fnine;
	ButtonId[129] = time_entry_to_add->ften;
	ButtonId[130] = time_entry_to_add->feleven;
	ButtonId[131] = time_entry_to_add->ftwelve;
	ButtonId[132] = time_entry_to_add->fthirteen;
	ButtonId[133] = time_entry_to_add->ffourteen;
	ButtonId[134] = time_entry_to_add->ffifteen;
	ButtonId[135] = time_entry_to_add->fsixteen;
	ButtonId[136] = time_entry_to_add->fseventeen;
	ButtonId[137] = time_entry_to_add->feighteen;
	ButtonId[138] = time_entry_to_add->fnineteen;
	ButtonId[139] = time_entry_to_add->ftwenty;
	ButtonId[140] = time_entry_to_add->ftwentyone;
	ButtonId[141] = time_entry_to_add->ftwentytwo;
	ButtonId[142] = time_entry_to_add->ftwentythree;
	ButtonId[143] = time_entry_to_add->ftwentyfour;
	ButtonId[144] = time_entry_to_add->sone;
	ButtonId[145] = time_entry_to_add->stwo;
	ButtonId[146] = time_entry_to_add->sThree;
	ButtonId[147] = time_entry_to_add->sfour;
	ButtonId[148] = time_entry_to_add->sfive;
	ButtonId[149] = time_entry_to_add->ssix;
	ButtonId[150] = time_entry_to_add->sseven;
	ButtonId[151] = time_entry_to_add->seight;
	ButtonId[152] = time_entry_to_add->snine;
	ButtonId[153] = time_entry_to_add->sten;
	ButtonId[154] = time_entry_to_add->seleven;
	ButtonId[155] = time_entry_to_add->stwelve;
	ButtonId[156] = time_entry_to_add->sthirteen;
	ButtonId[157] = time_entry_to_add->sfourteen;
	ButtonId[158] = time_entry_to_add->sfifteen;
	ButtonId[159] = time_entry_to_add->ssixteen;
	ButtonId[160] = time_entry_to_add->sseventeen;
	ButtonId[161] = time_entry_to_add->seighteen;
	ButtonId[162] = time_entry_to_add->snineteen;
	ButtonId[163] = time_entry_to_add->stwenty;
	ButtonId[164] = time_entry_to_add->stwentyone;
	ButtonId[165] = time_entry_to_add->stwentytwo;
	ButtonId[166] = time_entry_to_add->stwentythree;
	ButtonId[167] = time_entry_to_add->stwentyfour;
   
	if (display_the_table_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
	
		for(i=0; i<7; i++)
	   {
		   Time_Permission[i] = 0xffffffffL;
	
		   for(j=0; j<24; j++)
		   {
			   if( ButtonId[k] == 0 )
			   {
				   bitno = j % 24;
				   Time_Permission[i] = Time_Permission[i] & Bitarray[bitno];
			   }
				   k++;
					ptr_group->user_permission[i]=Time_Permission[i];
					
		   }
	   }
	}
	else
	{
		for(i=0; i<7; i++)
	   {
		   Time_Permission[i] = 0xffffffffL;
	
		   for(j=0; j<24; j++)
		   {
			   if( ButtonId[k] == 0 )
			   {
				   bitno = j % 24;
				   Time_Permission[i] = Time_Permission[i] & Bitarray[bitno];
			   }
				   k++;
				   ptr_to_edit_time_permission->user_permission[i]=Time_Permission[i];
		   }
	   }
		
	}
	flag_for_time_permission = TRUE;
	flag_edit = TRUE;

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void add_the_group_entry(Request_t* request)
{
	TEMP_GROUP_PROFILE *group_entry;

	USHORT temp_value=0,temp_value1=0;
	enum UDB_MODIFY returnval;
	int i=0,no_of_login_att=0,no_of_blklisted_sites=0,no_of_groups=0;
	ULONG Time_Set = 16777215,Time_Permission[7];
	ADD_GROUP_ENTRY_form_output_type *group_entry_to_add;

  	group_entry = ptr_to_edit_time_permission; /* Sreelu */
/*sri	group_entry = (TEMP_GROUP_PROFILE *) current_ptr_to_edit;  */

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	group_entry_to_add = (ADD_GROUP_ENTRY_form_output_type *) form_data_of_request(request);
	if(group_entry_to_add == NULL)
	{
		printf("USERMGMT : Request Failed to Get ...");
		return;
	}
	
	no_of_groups = number_of_groups();
	if(no_of_groups > MAX_NO_OF_GROUP_ENTRIES)
	{
		printf("Not More than 25 groups can be added\n ");
		InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
      return ;

	}

	if(flag_for_time_permission == FALSE)
	{
		for(i=0;i<7;i++)
			group_entry->user_permission[i] = 0xffffffffL;
	}   
		
	if(!strcmpi(group_entry_to_add->time_permission,"Time Permission"))
   {
      display_the_table_called_from(ADD_ENTRY, TRUE);
/*		display_the_table_for_time_restriction(request);*/
		display_the_time_permission_table(request);
   	return;
   }
	
	strcpy(group_entry->group_name, group_entry_to_add->groupname);

	if (strcmp (group_entry_to_add->groupname, "") == 0)
	{
		InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
      return ;
	}
	
	strcpy(group_entry->group_description, group_entry_to_add->groupdesc);
	if (strcmp (group_entry_to_add->groupdesc, "") == 0)
	{
		InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
      return ;
	}
	
	if(group_entry_to_add->loginatt)
		group_entry->defaulter_login_attempts = 1;

	if(group_entry_to_add->loginatt)
	{
		no_of_login_att = atoi(group_entry_to_add->loattmpt);
		if(no_of_login_att < 0 || no_of_login_att > 32767)
		{
			InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
			return ;
		}
	
		group_entry->defaulter_number_of_login_attempts = no_of_login_att;
	}
	else
		group_entry->defaulter_number_of_login_attempts = 0;
	
	if(group_entry_to_add->black_list)
		group_entry->defaulter_blacklisted_sites = 1;
	
			
	if(group_entry_to_add->black_list)
	{
		no_of_blklisted_sites = atoi(group_entry_to_add->blklist);
		if(no_of_blklisted_sites < 0 || no_of_blklisted_sites > 32767)
		{
			InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
			return ;
		}

		group_entry->defaulter_number_of_attempts_of_blacklisted_sites = no_of_blklisted_sites;
	}
	else
		group_entry->defaulter_number_of_attempts_of_blacklisted_sites = 0;

	returnval =  udb_group_insert(group_entry);		

	switch (returnval)
	{
		case ILLEGAL_DATA:
			printf("Illegal Data Type\n");
			break;

		case INSERT_SUCCESSFUL:
		  	printf("Inserted Succesfully\n");
			break;

		case INSERT_USER_ALREADY_EXISTS:
			printf("Entry Already Exist\n");
			break;

		case INSERT_NO_MEMORY:
			printf("Insert No Memory\n");
			break;
	}		

	flag_for_time_permission = FALSE;

	free (group_entry);
	
	InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	
	return;
}

int number_of_groups()
{
	GROUP_DATA *ptr_to_group_no;
	int group_count =1;

	ptr_to_group_no = user_database.sptr_temp_group_data;
	while(ptr_to_group_no != NULL)
	{
		group_count = group_count+1;
		ptr_to_group_no = ptr_to_group_no->next_node;
	}
  return(group_count);
}
void display_ved_group_entry_page(Request_t* request)
{
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/

	BYTE* temp_page;
 	GROUP_DATA *temp_group_data;
	int count = 0;
   USHORT search_to_start_at=0;   
	TEMP_GROUP_PROFILE temp_group_entry;
	BYTE *buffer;	
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

 	if(user_database.sptr_temp_group_data == NULL)
	{
		printf("Global data pointer contains no entry\n");
		InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	 	
	}

   temp_group_data = user_database.sptr_temp_group_data;
	temp_page = (BYTE *) calloc(strlen(GROUP_VIEW_EDIT_DEL_USER_data_ptr), 1);
	
	if (temp_page == NULL)
	{
		printf("Out of memory failed to display group entry list.\n");
		return;
	}
	strcpy(temp_page, GROUP_VIEW_EDIT_DEL_USER_data_ptr);

		while(temp_group_data != NULL)
		{
			temp_group_entry = *(temp_group_data->data);
			search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___TEXT___#___", temp_group_data->data->group_name, temp_page, TRUE, search_to_start_at); 
			temp_group_data = temp_group_data->next_node;

			contents_of_group_entry_page[count] =  temp_group_entry;
			count = count+1;
			
			if(count > 10)
		  	{
				*counter = 1;
				break;
			}
		   		
		}
		if(count<10)
		{
			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_group_entry_to_display(count, search_to_start_at, temp_page);
			search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);

		}

		if(count >= 10)
		{
			search_to_start_at = search_and_replace("#$$#", " ", temp_page, TRUE, search_to_start_at);
		}
		
		InitReturnBuffer(request, temp_page, strlen(GROUP_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
		free(temp_page);
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_group_entry_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_group_entry_for_user(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < MAX_NO_OF_GROUP_ENTRIES - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

void display_next_ten_group_entries(Request_t* request)
{
	GROUP_DATA *tmp_group_data;
	BYTE *buffer,*temp_page;
	int i=0,count=0,value;
   USHORT search_to_start_at=0;   
	TEMP_GROUP_PROFILE temp_group_entry;
		
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(*counter == 0 )
	{
		InitReturnBuffer(request, temp_page, strlen(GROUP_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	}

	temp_page = (BYTE *) calloc(strlen(GROUP_VIEW_EDIT_DEL_USER_data_ptr), 1);
	
	if (temp_page == NULL)
	{
		printf("Out of memory failed to display group entry list.\n");
		return;
	}
	strcpy(temp_page, GROUP_VIEW_EDIT_DEL_USER_data_ptr);
	tmp_group_data = user_database.sptr_temp_group_data;

	value = *counter;
	if(*counter == 1)
	{
		for(i=0; i<10; i++)
		{
			tmp_group_data = tmp_group_data->next_node;
		}
	}
	
	if(*counter == 2)
	{
		for(i=0; i<20; i++)
		{
			tmp_group_data = tmp_group_data->next_node;
		}
	}
	
	if(tmp_group_data == NULL)
	{
		printf("There is no Eleventh Entry\n");
	}


		
	while(tmp_group_data != NULL)
	{
		temp_group_entry = *(tmp_group_data->data);
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___TEXT___#___", tmp_group_data->data->group_name, temp_page, TRUE, search_to_start_at); 
		contents_of_group_entry_page[count] =  temp_group_entry;
		tmp_group_data = tmp_group_data->next_node;

		count = count+1;
						
		if(count > 10)
		{
			*counter = 2;
			break;
		}
			
	}
	if(count<10)
	{
		search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_group_entry_to_display(count, search_to_start_at, temp_page);
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
	}
	if(count >= 10)
	{
		search_to_start_at = search_and_replace("#$$#", " ", temp_page, TRUE, search_to_start_at);
	}
	
	InitReturnBuffer(request, temp_page, strlen(GROUP_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}

void display_the_group_entry_for_editing(Request_t* request, TEMP_GROUP_PROFILE* group_entry)
{
	BYTE* buffer, temp_buffer[40],temp_buffer1[40],temp_buffer3[40],temp_buffer4[20];
	USHORT search_to_start_at;

	buffer = (BYTE *) calloc(strlen(EDIT_GROUP_ENTRY_data_ptr), 1);

	if (buffer == NULL)
	{
		printf("Out Of memory to display a Proxy Entry for editing\n");
		return;
	}
	strcpy(buffer, EDIT_GROUP_ENTRY_data_ptr);


   sprintf(temp_buffer, "%s", group_entry->group_name);
   search_to_start_at = search_and_replace("#___TEXT___#___                         ", temp_buffer, buffer, TRUE, search_to_start_at);

	sprintf(temp_buffer1, "%s", group_entry->group_description);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer1, buffer, TRUE, search_to_start_at);

	if(group_entry->defaulter_login_attempts == 1)
		search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 

   sprintf(temp_buffer3, "%d", group_entry->defaulter_number_of_login_attempts);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer3, buffer, TRUE, search_to_start_at);

	if(group_entry->defaulter_blacklisted_sites == 1)
		search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 

   sprintf(temp_buffer4, "%d", group_entry->defaulter_number_of_attempts_of_blacklisted_sites);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer4, buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_edit_group_entry_1(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	   ptr_to_edit_time_permission = &contents_of_group_entry_page[0]; 
		group_entry = contents_of_group_entry_page[0];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(1, TRUE);
}

void display_edit_group_entry_2(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	  ptr_to_edit_time_permission = &contents_of_group_entry_page[1]; 
		group_entry = contents_of_group_entry_page[1];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(2, TRUE);
}

void display_edit_group_entry_3(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
		ptr_to_edit_time_permission = &contents_of_group_entry_page[2]; 
		group_entry = contents_of_group_entry_page[2];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(3, TRUE);
}

void display_edit_group_entry_4(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
		ptr_to_edit_time_permission = &contents_of_group_entry_page[3]; 
		group_entry = contents_of_group_entry_page[3];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(4, TRUE);
}

void display_edit_group_entry_5(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		ptr_to_edit_time_permission = &contents_of_group_entry_page[4]; 
		group_entry = contents_of_group_entry_page[4];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(5, TRUE);
}

void display_edit_group_entry_6(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
			
		ptr_to_edit_time_permission = &contents_of_group_entry_page[5]; 
		group_entry = contents_of_group_entry_page[5];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(6, TRUE);
}

void display_edit_group_entry_7(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
		ptr_to_edit_time_permission = &contents_of_group_entry_page[6]; 
		group_entry = contents_of_group_entry_page[6];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(7, TRUE);
}

void display_edit_group_entry_8(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
		ptr_to_edit_time_permission = &contents_of_group_entry_page[7]; 
		group_entry = contents_of_group_entry_page[7];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(8, TRUE);
}

void display_edit_group_entry_9(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
		ptr_to_edit_time_permission = &contents_of_group_entry_page[8]; 
		group_entry = contents_of_group_entry_page[8];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(9, TRUE);
}

void display_edit_group_entry_10(Request_t* request)
{
	TEMP_GROUP_PROFILE group_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
		ptr_to_edit_time_permission = &contents_of_group_entry_page[9]; 
		group_entry = contents_of_group_entry_page[9];
		display_the_group_entry_for_editing(request, &group_entry);
	
		save_the_number_of_group_entry_being_edited(10, TRUE);
}

BYTE save_the_number_of_group_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}
void change_the_edited_group_entry(Request_t* request)
{
	EDIT_GROUP_ENTRY_form_output_type* edited_group_entry;
	BYTE edited_group_entry_index;
	TEMP_GROUP_PROFILE new_group_entry, old_group_entry;
	ULONG temp_value = 0,temp_value1 = 0;
   int unique_entry,i=0,no_of_login_att=0,no_of_blklisted_sites=0;
	enum UDB_MODIFY result;
	 
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	edited_group_entry = (EDIT_GROUP_ENTRY_form_output_type*)form_data_of_request(request);
	


   if (!strcmp(edited_group_entry->delete_entry, "Delete Entry"))
	{
		delete_the_group_entry(request);
		return;
	}

	if (!strcmp(edited_group_entry->time_permission, "Time Permission"))
	{
		display_the_table_called_from(EDIT_ENTRY,TRUE);
		display_the_time_permission_table(request);
		return;
	}

	edited_group_entry_index = save_the_number_of_group_entry_being_edited(NULL, FALSE);
	if(flag_edit == FALSE)
	{
		for(i=0;i<7;i++)
		{
			new_group_entry.user_permission[i] = 0xffffffffL;
		}
		
	}
	strcpy(new_group_entry.group_name,edited_group_entry->groupname);
	strcpy(new_group_entry.group_description,edited_group_entry->groupdesc);
	new_group_entry.defaulter_login_attempts = edited_group_entry->loginatt;
	if(edited_group_entry->loginatt)
	{
		no_of_login_att = atoi(edited_group_entry->loattmpt);
		if(no_of_login_att < 0 || no_of_login_att > 32767)
		{
			InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
			return ;
		}

		new_group_entry.defaulter_number_of_login_attempts = no_of_login_att;
	}
	else
		new_group_entry.defaulter_number_of_login_attempts = 0;
		
	new_group_entry.defaulter_blacklisted_sites = edited_group_entry->black_list;
	if(edited_group_entry->black_list)
	{
		no_of_blklisted_sites = atoi(edited_group_entry->blklist);
		if(no_of_blklisted_sites < 0 || no_of_blklisted_sites > 32767)
		{
			InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
			return ;
		}
		
		new_group_entry.defaulter_number_of_attempts_of_blacklisted_sites = no_of_blklisted_sites;
	}
	else
		new_group_entry.defaulter_number_of_attempts_of_blacklisted_sites = 0;
	
	for(i=0;i<7;i++)
	{
	 new_group_entry.user_permission[i] = ptr_to_edit_time_permission->user_permission[i];
	}
	result = udb_group_edit(&new_group_entry);
	switch (result)
	{
		case ILLEGAL_DATA:
			printf("Illegal Data Type\n");
			break;

		case INSERT_SUCCESSFUL:
			printf("Inserted Successfully\n");
			break;

		case INSERT_USER_ALREADY_EXISTS:
			printf("Entry Already Exist\n");
			break;

		case INSERT_NO_MEMORY:
			printf("Insert No Memory\n");
			break;
	}

	InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);

}

void delete_the_group_entry(Request_t* request)
{
	EDIT_GROUP_ENTRY_form_output_type* edited_group_entry;
	BYTE edited_group_entry_index;
	TEMP_GROUP_PROFILE new_group_entry; 
	GROUP_DATA *temp_group_data;
	enum UDB_MODIFY result,resultusr;
	USER_DATA *temp_user_data;
	
	int k=1;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
 
	edited_group_entry = (EDIT_GROUP_ENTRY_form_output_type*)form_data_of_request(request);
	

/*	edited_group_entry_index = save_the_number_of_group_entry_being_edited(NULL, FALSE);*/
	strcpy(new_group_entry.group_name,edited_group_entry->groupname);
	strcpy(new_group_entry.group_description,edited_group_entry->groupdesc);
	new_group_entry.defaulter_login_attempts = edited_group_entry->loginatt;
	new_group_entry.defaulter_number_of_login_attempts = atoi(edited_group_entry->loattmpt);
	new_group_entry.defaulter_blacklisted_sites = edited_group_entry->black_list;
	new_group_entry.defaulter_number_of_attempts_of_blacklisted_sites = atoi(edited_group_entry->blklist);
/*Neelu latest change*/
	temp_user_data =user_database.sptr_temp_user_data;/* Neelu latest change*/                                                                                                                                  	

	while(temp_user_data != NULL)
	{
		if(strcmp(edited_group_entry->groupname,temp_user_data->data->group_name) == NULL)
		{
			resultusr = udb_user_delete(temp_user_data->data);

			if (resultusr != DELETE_SUCCESSFUL)
			{
				printf("Configuration manager refused to delete the user entry \n");
				InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
				return;
			}
/*	         temp_user_data = temp_user_data->next_node;*/
       }
   	   temp_user_data = temp_user_data->next_node;
			if(temp_user_data == NULL)/*new on 14-09*/
			break;/*new on 14-09*/

		}
/* Neelu ends latest changes*/
	result = udb_group_delete(&new_group_entry);

	if (result != DELETE_SUCCESSFUL)
	{
		printf("Configuration manager refused to delete the entry \n");
		InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	/* Added by Sreelu for Filters..... */
	order_group_numbers_in_ascending(); 
	change_filter_masks(deleted_group);
/* .....Added by Sreelu for Filters */

	InitReturnBuffer(request, GROUP_MENU_data_ptr, strlen(GROUP_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

TEMP_GROUP_PROFILE* next_group_entry_from_where_display_is_reqd_to_continue(TEMP_GROUP_PROFILE* last_node, BYTE is_required_to_save)
{
	static TEMP_GROUP_PROFILE* saved_node;

	if (is_required_to_save)
		saved_node = last_node;
	else
		return saved_node;
} 
/*--------------------Neelu for User Entry--------------------------------*/ 

void display_user_menu(Request_t* request)
{
	
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}
void display_page_to_add_user_entry(Request_t* request)
{
   USHORT search_to_start_at=0;   
   BYTE* buffer;
	char name[40];
	GROUP_DATA *temp_group_data;
	int count=0;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	buffer = (BYTE *) calloc(strlen(ADD_USER_ENTRY_data_ptr), 1);

	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
	strcpy(buffer, ADD_USER_ENTRY_data_ptr);

	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Username */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Password */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Reconfirm Password */
	temp_group_data = user_database.sptr_temp_group_data;
	while(temp_group_data != NULL)
	{
		strcpy(name,temp_group_data->data->group_name);
		search_to_start_at = search_and_replace("#@@#", "   ", buffer, TRUE, search_to_start_at);/*New Addition*/
		search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at); /* Password */
		temp_group_data = temp_group_data->next_node;
		count++;

		if(count>MAX_NO_OF_GROUP_ENTRIES)
		break;

	}
	if(count<MAX_NO_OF_GROUP_ENTRIES)
      search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_group_entry_for_user(count, search_to_start_at, buffer);

	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Reconfirm Password */
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at); /* Password */
	

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}
void add_the_user_entry(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
	USHORT temp_value=0,temp_value1=0;
	enum UDB_MODIFY returnval;
	int count=0,i=0;
	GROUP_DATA *temp_group_data;
   char groupbuffer[MAX_NO_OF_GROUP_ENTRIES][40];

	ADD_USER_ENTRY_form_output_type *user_entry_to_add;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	user_entry_to_add = (ADD_USER_ENTRY_form_output_type *) form_data_of_request(request);
	if(user_entry_to_add == NULL)
	{
		printf("USERMGMT : Request Failed to Get User Entries...");
		return;
	}

	
   strcpy(user_entry.user_name, user_entry_to_add->username);

	if (strcmp (user_entry_to_add->username, "") == 0)
	{
		InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
      return ;
	}
	strcpy(user_entry.user_password, user_entry_to_add->password);
	
	if(strcmp(user_entry_to_add->password,user_entry_to_add->recpassword) != NULL)
	{
		printf("Invalid Password\n");
		InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
      return ;
	}
   
	
	temp_group_data =user_database.sptr_temp_group_data;                                                                                                                                  

	while(temp_group_data != NULL)
	{
		strcpy(groupbuffer[count],temp_group_data->data->group_name);
		count++;
		temp_group_data=temp_group_data->next_node;
 		
		if(count>MAX_NO_OF_GROUP_ENTRIES)
		break;
			
	}
	for(i=0;i<MAX_NO_OF_GROUP_ENTRIES;i++)
	{
		if(user_entry_to_add->group == i)
		strcpy(user_entry.group_name,groupbuffer[i]);
	}
	
	if(user_entry_to_add->defaulter == 0)
		user_entry.defaulter = 0;
  else if (user_entry_to_add->defaulter == 1)
		user_entry.defaulter = 1;
  else if (user_entry_to_add->defaulter == 2)
		user_entry.defaulter = 2;

	if(user_entry_to_add->Acstatus == 0)
		user_entry.account_status = 1;
	else if(user_entry_to_add->Acstatus == 1)
		user_entry.account_status = 0;

	returnval =  udb_user_insert(&user_entry);		
	switch (returnval)
	{
		case ILLEGAL_DATA:
			printf("Illegal Data Type\n");
			break;

		case INSERT_SUCCESSFUL:
			printf("Inserted Successfully\n");
			break;

		case INSERT_USER_ALREADY_EXISTS:
			printf("Entry Already Exist\n");
			break;

		case INSERT_NO_MEMORY:
			printf("Insert No Memory\n");
			break;
	}

	InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	return;
}
void display_user_entry_ved_page(Request_t* request)
{
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/

	BYTE* temp_page;
 	USER_DATA *temp_user_data;
	int count = 0;
   USHORT search_to_start_at=0;   
	TEMP_USER_PROFILE temp_user_entry;
	BYTE *buffer;	
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

 	if(user_database.sptr_temp_user_data == NULL)
	{
		printf("Global data pointer contains no  user entry\n");
		InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	 	
	}

   temp_user_data = user_database.sptr_temp_user_data;

	temp_page = (BYTE *) calloc(strlen(USER_VIEW_EDIT_DEL_USER_data_ptr), 1);


	if (temp_page == NULL)
	{
		printf("Out of memory failed to display user entry list.\n");
		return;
	}
	strcpy(temp_page, USER_VIEW_EDIT_DEL_USER_data_ptr);

		while(temp_user_data != NULL)
		{
		  
         temp_user_entry = *(temp_user_data->data);
			search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#________________________________________USN", temp_user_data->data->user_name, temp_page, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#________________________________________GR", temp_user_data->data->group_name, temp_page, TRUE, search_to_start_at);
/*			search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___TEXT___#___", temp_group_data->data->group_name, temp_page, TRUE, search_to_start_at); */
			temp_user_data = temp_user_data->next_node;

			contents_of_user_entry_page[count] =  temp_user_entry;
			count = count+1;
			
			if(count > 10)
		  	{
				*usrcounter = 1;
				break;
			}
		   		
		}
		if(count<10)
		{
			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_group_entry_to_display(count, search_to_start_at, temp_page);
			search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
		}
		if(count >= 10)
		{
			search_to_start_at = search_and_replace("#$$#", " ", temp_page, TRUE, search_to_start_at);
		}
				
		InitReturnBuffer(request, temp_page, strlen(USER_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
		free(temp_page);
}
						 
void display_next_ten_user_entries(Request_t* request)
{
	USER_DATA *tmp_user_data;
	BYTE *buffer,*temp_page;
	int i=0,count=0,value;
   USHORT search_to_start_at=0;   
	TEMP_USER_PROFILE temp_user_entry;
	int k =1,m=10;
		
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(*usrcounter == 0 )
	{
		InitReturnBuffer(request, temp_page, strlen(USER_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	}

	temp_page = (BYTE *) calloc(strlen(USER_VIEW_EDIT_DEL_USER_data_ptr), 1);

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display user entry list.\n");
		return;
	}
	strcpy(temp_page, USER_VIEW_EDIT_DEL_USER_data_ptr);
	tmp_user_data = user_database.sptr_temp_user_data;

	value = *usrcounter;
	
	
	if(*usrcounter == k)
	{
		for(i=0; i<m; i++)
		{
			tmp_user_data = tmp_user_data->next_node;
		}
		k = k+1;
		m = m+10;
	}

		
	if(tmp_user_data == NULL)
	{
		printf("There is no Eleventh Entry\n");
	}


		
	while(tmp_user_data != NULL)
	{
		temp_user_entry = *(tmp_user_data->data);
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		search_to_start_at = search_and_replace("#________________________________________USN", tmp_user_data->data->user_name, temp_page, TRUE, search_to_start_at);
		search_to_start_at = search_and_replace("#________________________________________GR", tmp_user_data->data->group_name, temp_page, TRUE, search_to_start_at);
		contents_of_user_entry_page[count] =  temp_user_entry;
		tmp_user_data = tmp_user_data->next_node;

		count = count+1;
						
		if(count > 10)
		{
/*			*usrcounter = 2;*/
			*usrcounter = *usrcounter+1;
			break;
		}
			
	}
	if(count<10)
	{
		search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_group_entry_to_display(count, search_to_start_at, temp_page);
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
	}
	if(count >= 10)
	{
		search_to_start_at = search_and_replace("#$$#", " ", temp_page, TRUE, search_to_start_at);
	}

	InitReturnBuffer(request, temp_page, strlen(USER_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}
int update_combo_box(int total_no_of_items, int no_of_selected_item,BYTE *buffer,int search_to_start_at)
{
	
	int i;
   for(i=0; i<total_no_of_items; ++i)
   {
 		if (i == (no_of_selected_item-1))
  		{
			search_to_start_at = search_and_replace("#_SELECT", "SELECTED", buffer, TRUE, search_to_start_at);
  		}
  		else
		{
			search_to_start_at= search_and_replace("#_SELECT", " ", buffer, TRUE, search_to_start_at);
		}
   }
	return(search_to_start_at);
}
void display_the_user_entry_for_editing(Request_t* request, TEMP_USER_PROFILE* user_entry)
{
	BYTE* buffer, temp_buffer[40],temp_buffer1[40],temp_buffer3[40],temp_buffer4[20];
	USHORT search_to_start_at,x,y,z,a,b,c;
	GROUP_DATA *temp_group_data,*tmp_group_data;
	char name[40];
	int count =0,selected_index=0;
	int index,indx,i,j;
	
	buffer = (BYTE *) calloc(strlen(EDIT_USER_ENTRY_data_ptr), 1);

	if (buffer == NULL)
	{
		printf("Out Of memory to display a Proxy Entry for editing\n");
		return;
	}
	strcpy(buffer, EDIT_USER_ENTRY_data_ptr);


   sprintf(temp_buffer, "%s", user_entry->user_name);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer, buffer, TRUE, search_to_start_at);

	sprintf(temp_buffer1, "%s", user_entry->user_password);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer1, buffer, TRUE, search_to_start_at);

	sprintf(temp_buffer1, "%s", user_entry->user_password);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer1, buffer, TRUE, search_to_start_at);

	temp_group_data = user_database.sptr_temp_group_data;
	tmp_group_data = user_database.sptr_temp_group_data;
	x= search_to_start_at;
	
	while(temp_group_data != NULL)
	{
		strcpy(name,temp_group_data->data->group_name);
 		search_to_start_at = search_and_replace("#@@#", "   ", buffer, TRUE, search_to_start_at);/*New Addition*/
		search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at); /* Password */
		temp_group_data = temp_group_data->next_node;
		count++;

		if(count>MAX_NO_OF_GROUP_ENTRIES)
		break;

	}
	if(count<MAX_NO_OF_GROUP_ENTRIES)
	{
      search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_group_entry_for_user(count, search_to_start_at, buffer);
   }
	while(tmp_group_data != NULL)
	{
      if(!strcmp(tmp_group_data->data->group_name,user_entry->group_name))
		{
			selected_index = selected_index+1;
			tmp_group_data = tmp_group_data->next_node;
			break;
		}
	  	 selected_index = selected_index+1;
		 tmp_group_data = tmp_group_data->next_node;
	}
	
	
	search_to_start_at =x;
	update_combo_box(count,selected_index,buffer,search_to_start_at);

	if(user_entry->defaulter == 0) index=0;
  	if(user_entry->defaulter == 1) index=1;
	if(user_entry->defaulter == 2) index=2;
	search_to_start_at= search_and_replace("Defaulter", " ", buffer, FALSE, search_to_start_at);
	
	for(i=0; i<index; i++)
	{
		search_to_start_at= search_and_replace("#_SELECT", " ", buffer, FALSE, search_to_start_at);
	}
		search_to_start_at = search_and_replace("#_SELECT", "SELECTED", buffer, TRUE, search_to_start_at);
 	 
	
	if(user_entry->account_status == 0) indx=0;
	if(user_entry->account_status == 1) indx=1; 

	search_to_start_at= search_and_replace("Account Status", " ", buffer, FALSE, search_to_start_at);
	for(j=0; j<indx; j++)
	{
		search_to_start_at= search_and_replace("#_SELECT", " ", buffer, FALSE, search_to_start_at);
	}
		search_to_start_at = search_and_replace("#_SELECT", "SELECTED", buffer, TRUE, search_to_start_at);
				
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_edit_user_entry_1(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[0];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(1, TRUE);
}
void display_edit_user_entry_2(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[1];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(2, TRUE);
}
void display_edit_user_entry_3(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[2];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(3, TRUE);
}
void display_edit_user_entry_4(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[3];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(4, TRUE);
}
void display_edit_user_entry_5(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[4];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(5, TRUE);
}
void display_edit_user_entry_6(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[5];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(6, TRUE);
}
void display_edit_user_entry_7(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[6];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(7, TRUE);
}
void display_edit_user_entry_8(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[7];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(8, TRUE);
}
void display_edit_user_entry_9(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[8];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(9, TRUE);
}

void display_edit_user_entry_10(Request_t* request)
{
	TEMP_USER_PROFILE user_entry;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
		if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
		user_entry = contents_of_user_entry_page[9];
		display_the_user_entry_for_editing(request, &user_entry);
	
		save_the_number_of_user_entry_being_edited(10, TRUE);
}
BYTE save_the_number_of_user_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}
void change_the_edited_user_entry(Request_t* request)
{
	EDIT_USER_ENTRY_form_output_type* edited_user_entry;
	BYTE edited_user_entry_index;
	BYTE *buffer;
	TEMP_USER_PROFILE new_user_entry, old_user_entry;
	ULONG temp_value = 0,temp_value1 = 0;
   int unique_entry,i=0,count=0,cnt =0,selected_index,p;
	enum UDB_MODIFY result;
	char groupbuffer[MAX_NO_OF_GROUP_ENTRIES][40];
	GROUP_DATA *tmp_group_data,*temp_group_data;
	USHORT search_to_start_at;	 
	int index,indx,a,j;

	
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = (BYTE *) calloc(strlen(EDIT_USER_ENTRY_data_ptr), 1);

	if (buffer == NULL)
	{
		printf("Out Of memory to display a Proxy Entry for editing\n");
		return;
	}
	strcpy(buffer, EDIT_USER_ENTRY_data_ptr);

	edited_user_entry = (EDIT_USER_ENTRY_form_output_type*)form_data_of_request(request);
	
	temp_group_data = user_database.sptr_temp_group_data;
	tmp_group_data = user_database.sptr_temp_group_data;


   if (!strcmp(edited_user_entry->delete_user_entry, "Delete User Entry"))
	{
		delete_the_user_entry(request);
		return;
	}

	
	edited_user_entry_index = save_the_number_of_user_entry_being_edited(NULL, FALSE);
	strcpy(new_user_entry.user_name,edited_user_entry->username);
	strcpy(new_user_entry.user_password,edited_user_entry->password);

	if(strcmp(edited_user_entry->password,edited_user_entry->recpassword) != NULL)
	{
		InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	
#if 0
	while(tmp_group_data != NULL)
	{
		if(count == edited_user_entry->group)
		{
			strcpy(new_user_entry->group_name,tmp_group_data->data->group_name);
			cnt=cnt+1;
			tmp_group_data = tmp_group_data->next_node;
			break;
		}
		cnt = cnt+1;
		tmp_group_data = tmp_group_data->next_node;
		
	}
	count = user_database.num_of_groups;
	selected_index = (edited_user_entry->group)+1;
#endif
	while(temp_group_data != NULL)
	{
		strcpy(groupbuffer[count],temp_group_data->data->group_name);
		count++;
		temp_group_data=temp_group_data->next_node;
 		
		if(count>MAX_NO_OF_GROUP_ENTRIES)
		break;
			
	}
	for(i=0;i<MAX_NO_OF_GROUP_ENTRIES;i++)
	{
		if(edited_user_entry->group == i)
		strcpy(new_user_entry.group_name,groupbuffer[i]);
	}
	while(tmp_group_data != NULL)
	{
      if(!strcmp(tmp_group_data->data->group_name,new_user_entry.group_name))
		{
			selected_index = selected_index+1;
			tmp_group_data = tmp_group_data->next_node;
			break;
		}
	  	 selected_index = selected_index+1;
		 tmp_group_data = tmp_group_data->next_node;
	}
	
	
	update_combo_box(count,selected_index,buffer,search_to_start_at);
	
	if(edited_user_entry->defaulter == 0)
	{
		new_user_entry.defaulter = 0;
		index = 0;
	}
	else if(edited_user_entry->defaulter == 1)
	{
		new_user_entry.defaulter = 1;
		index = 1;
	}
	else if(edited_user_entry->defaulter == 2)
	{
		new_user_entry.defaulter = 2;
		index = 2;
	}
	search_to_start_at= search_and_replace("Defaulter", " ", buffer, FALSE, search_to_start_at);
   
	for(a=0; a<index; a++)
	{
		search_to_start_at= search_and_replace("#_SELECT", " ", buffer, FALSE, search_to_start_at);
	}
		search_to_start_at = search_and_replace("#_SELECT", "SELECTED", buffer, TRUE, search_to_start_at);
	
	
	if(edited_user_entry->Acstatus == 0)
	{
		new_user_entry.account_status = 1;
		indx = 0;
	}
	else if(edited_user_entry->Acstatus == 1)
	{
		new_user_entry.account_status = 0;
		indx = 1;
	}
	search_to_start_at= search_and_replace("Account Status", " ", buffer, FALSE, search_to_start_at);
	
   for(j=0; j<indx; j++)
	{
		search_to_start_at= search_and_replace("#_SELECT", " ", buffer, FALSE, search_to_start_at);
	}
		search_to_start_at = search_and_replace("#_SELECT", "SELECTED", buffer, TRUE, search_to_start_at);

	
	
#if 0
	while(temp_group_data != NULL)
	{
		strcpy(groupbuffer[count],temp_group_data->data->group_name);
		count++;
		temp_group_data=temp_group_data->next_node;
 		
		if(count>MAX_NO_OF_GROUP_ENTRIES)
		break;
			
	}
	for(i=0;i<MAX_NO_OF_GROUP_ENTRIES;i++)
	{
		if(edited_user_entry->group == i)
		strcpy(new_user_entry->group_name,groupbuffer[i]);
	}
	while(tmp_group_data != NULL)
	{
      if(!strcmp(tmp_group_data->data->group_name,new_user_entry->group_name))
		{
			selected_index = selected_index+1;
			tmp_group_data = tmp_group_data->next_node;
			break;
		}
	  	 selected_index = selected_index+1;
		 tmp_group_data = tmp_group_data->next_node;
	}
	
	if(edited_user_entry->defaulter == 0)
		new_user_entry->defaulter = 0;
  else if (edited_user_entry->defaulter == 1)
		new_user_entry->defaulter = 1;
  else if (edited_user_entry->defaulter == 2)
		new_user_entry->defaulter = 2;

	if(edited_user_entry->Acstatus == 0)
		new_user_entry->account_status = 0;
	else if(edited_user_entry->Acstatus == 1)
		new_user_entry->account_status = 1;
#endif
	

	result = udb_user_edit(&new_user_entry);
	switch (result)
	{
		case ILLEGAL_DATA:
			printf("Illegal Data Type\n");
			break;

		case INSERT_SUCCESSFUL:
			printf("Inserted Successfully\n");
			break;

		case INSERT_USER_ALREADY_EXISTS:
			printf("Entry Already Exist\n");
			break;

		case INSERT_NO_MEMORY:
			printf("Insert No Memory\n");
			break;
	}

	free(buffer);
	InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);

}

void delete_the_user_entry(Request_t* request)
{

	EDIT_USER_ENTRY_form_output_type* edited_user_entry;
	BYTE edited_user_entry_index;
	TEMP_USER_PROFILE new_user_entry, old_user_entry;
	ULONG temp_value = 0,temp_value1 = 0;
   int unique_entry,i=0,count=0,cnt =0,selected_index;
	enum UDB_MODIFY result;
	char groupbuffer[MAX_NO_OF_GROUP_ENTRIES][40];
	GROUP_DATA *tmp_group_data;
	USHORT search_to_start_at;	 

	if(!check_whether_user_is_authenticated_or_not(request))
		return;


	edited_user_entry = (EDIT_USER_ENTRY_form_output_type*)form_data_of_request(request);
	
	tmp_group_data = user_database.sptr_temp_group_data;

	strcpy(new_user_entry.user_name,edited_user_entry->username);
	strcpy(new_user_entry.user_password,edited_user_entry->password);

	while(tmp_group_data != NULL)
	{
		if(count == edited_user_entry->group)
		{
			strcpy(new_user_entry.group_name,tmp_group_data->data->group_name);
			cnt=cnt+1;
			tmp_group_data = tmp_group_data->next_node;
			break;
		}
		cnt = cnt+1;
		tmp_group_data = tmp_group_data->next_node;
		
	}
	
	if(edited_user_entry->defaulter == 0)
		new_user_entry.defaulter = 0;
  else if (edited_user_entry->defaulter == 1)
		new_user_entry.defaulter = 1;
  else if (edited_user_entry->defaulter == 2)
		new_user_entry.defaulter = 2;

	if(edited_user_entry->Acstatus == 0)
		new_user_entry.account_status = 0;
	else if(edited_user_entry->Acstatus == 1)
		new_user_entry.account_status = 1;
	
	result = udb_user_delete(&new_user_entry);

	if (result != DELETE_SUCCESSFUL)
	{
		printf("Configuration manager refused to delete the entry \n");
		InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	InitReturnBuffer(request, USER_MENU_data_ptr, strlen(USER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);

}

/* Added by Sreelu for Access Rights & Filters..... */

/*---------------------------------------------------------------------------
			Functions for Handling IP Address Access Rights
						Started On 29 July 99
---------------------------------------------------------------------------*/
void display_access_rights_menu(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	InitReturnBuffer(request, ACCESS_RIGHTS_data_ptr, strlen(ACCESS_RIGHTS_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_ip_default_page(Request_t* request)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = (BYTE *) calloc(strlen(IP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, IP_DEFAULT_data_ptr);

	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(IP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free (buffer);
}

void delete_ip_default_data(Request_t* request, TEMP_IP_DEFAULT *ptr_data)
{
	if(udb_ip_default_delete(ptr_data) == DELETE_SUCCESSFUL)
		printf("IP Default Entry is Deleted Successfully\n");
	else
		printf("IP Default Entry is NOT found\n");

	InitReturnBuffer(request, USER_MANAGEMENT_data_ptr, strlen(USER_MANAGEMENT_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void add_ip_access_rights_to_list(Request_t* request)
{
	ADD_IP_DEFAULT_form_output_type *ptr_ip_deft;
	TEMP_IP_DEFAULT ip_default;
	int ret_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	ptr_ip_deft = (ADD_IP_DEFAULT_form_output_type *) form_data_of_request(request);
	strcpy(ip_default.lower_address, ptr_ip_deft->lower_address);
	strcpy(ip_default.upper_address, ptr_ip_deft->upper_address);
	ret_value = udb_ip_default_insert(&ip_default);

	switch (ret_value)
	{
		case ILLEGAL_DATA:
			printf("Illegal Data Type\n");
			break;

		case INSERT_SUCCESSFUL:
			printf("Inserted Successfully\n");
			break;

		case INSERT_USER_ALREADY_EXISTS:
			printf("Entry Already Exist\n");
			break;

		case INSERT_NO_MEMORY:
			printf("Insert No Memory\n");
			break;
	}		
	InitReturnBuffer(request, ACCESS_RIGHTS_data_ptr, strlen(ACCESS_RIGHTS_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

/*---------------------------------------------------------------------------
		This Function Puts the Next ten Entries that has to be displayed into 
		current_ten_ptr array.
---------------------------------------------------------------------------*/

void put_ten_ip_default_entries_to_current_ptr_array(Request_t* request, IP_DEFAULT_DATA *ptr_to_current_ip_default)
{
	IP_DEFAULT_DATA *ptr_data;
	int i;

	for(i=0; i<NUMBER_OF_ENTRIES_PER_PAGE; i++)
	{
		if(ptr_to_current_ip_default != NULL)
		{
			current_ten_ptr[i] = (void *) ptr_to_current_ip_default;
			ptr_to_current_ip_default = ptr_to_current_ip_default->next_node;
		}
		else
			current_ten_ptr[i] = NULL;
	}
}

/*---------------------------------------------------------------------------
						Templates are replaced with Values 
---------------------------------------------------------------------------*/
void fill_the_vedipdft_form_with_appropriate_values (BYTE *buffer)
{
	USHORT search_to_start_at = 0, i;
	IP_DEFAULT_DATA *ptr_data;

	for(i=0; i<NUMBER_OF_ENTRIES_PER_PAGE; i++)
	{
		ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[i];
		if(ptr_data != NULL)
		{
			search_to_start_at = search_and_replace("#SRE", "", buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#___IP__ADDRESS", ptr_data->data->lower_address, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#___IP__ADDRESS", ptr_data->data->upper_address, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#ERE", "", buffer, TRUE, search_to_start_at);
		}
		else
		{
			search_to_start_at = search_and_replace("#SRE", "<!--", buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#ERE", "-->", buffer, TRUE, search_to_start_at);
		}			
	}

	search_to_start_at = search_and_replace("#$$#", " ", buffer, TRUE, search_to_start_at);

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[9];
	if((ptr_data->next_node == NULL) || (ptr_data == NULL))
		search_to_start_at = disable_the_link_to_display_next_10(buffer, search_to_start_at);
}

void display_ved_ip_default_entries(Request_t* request)
{
	BYTE *buffer;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!user_database.num_of_ipdefaults)	
	{
		display_access_rights_menu(request);		
		return;
	}

	put_ten_ip_default_entries_to_current_ptr_array(request, user_database.sptr_temp_ip_default_data);
	buffer = (BYTE *) calloc(strlen(VIEW_EDIT_DEL_IP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, VIEW_EDIT_DEL_IP_DEFAULT_data_ptr);
	fill_the_vedipdft_form_with_appropriate_values (buffer);	
	InitReturnBuffer(request, buffer, strlen(VIEW_EDIT_DEL_IP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_ved_next_ip_default_entries(Request_t* request)
{
	BYTE *buffer;
	IP_DEFAULT_DATA *ptr_data;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[9];
	put_ten_ip_default_entries_to_current_ptr_array(request, ptr_data->next_node);
	buffer = (BYTE *) calloc(strlen(VIEW_EDIT_DEL_IP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, VIEW_EDIT_DEL_IP_DEFAULT_data_ptr);
	fill_the_vedipdft_form_with_appropriate_values (buffer);	
	InitReturnBuffer(request, buffer, strlen(VIEW_EDIT_DEL_IP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void change_the_edited_ip_access_rights_to_list(Request_t* request)
{
	EDIT_DELETE_IP_DEFAULT_form_output_type *edit_ip_access_rights;
	TEMP_IP_DEFAULT ip_default;
	IP_DEFAULT_DATA *ip_default_data;
	USHORT ret_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	edit_ip_access_rights = (EDIT_DELETE_IP_DEFAULT_form_output_type *) form_data_of_request(request);	
	
	strcpy(ip_default.lower_address, edit_ip_access_rights->lower_address); 
	strcpy(ip_default.upper_address, edit_ip_access_rights->upper_address);
 
	if (!strcmp(edit_ip_access_rights->DeleteIPDefaultButton, "Delete"))
	{
		delete_ip_default_data(request, &ip_default);
		return;
	}
	
	ret_value = udb_ip_default_edit(&ip_default);
	switch(ret_value)
	{
		case ILLEGAL_DATA :
			printf("IP Addresses Are not of Same Net\n");
			break;
		case EDIT_SUCCESSFUL :
			ip_default_data = (IP_DEFAULT_DATA *) current_ptr_to_edit;
			memcpy(ip_default_data->data, &ip_default, sizeof(TEMP_IP_DEFAULT));
			break;
		case EDIT_RECORD_NOT_FOUND :
			printf("Edit IP_DEFAULT RECORD_NOT_FOUND\n");
			break;
		case INSERT_USER_ALREADY_EXISTS :
			printf("Edit IP_DEFAULT Entry Already Exist\n");
			break;
	}
	InitReturnBuffer(request, ACCESS_RIGHTS_data_ptr, strlen(ACCESS_RIGHTS_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_ip_default_entry_for_editing_deleting(Request_t* request, IP_DEFAULT_DATA *ptr_data)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0;

	buffer = (BYTE *) calloc(strlen(EDIT_IP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, EDIT_IP_DEFAULT_data_ptr);

	search_to_start_at = search_and_replace("#___TEXT___#___", ptr_data->data->lower_address, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___", ptr_data->data->upper_address, buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(EDIT_IP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_ip_default_edit_delete_1(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[0];
	current_ptr_to_edit = current_ten_ptr[0];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_2(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[1];
	current_ptr_to_edit = current_ten_ptr[1];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_3(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[2];
	current_ptr_to_edit = current_ten_ptr[2];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_4(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[3];
	current_ptr_to_edit = current_ten_ptr[3];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_5(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[4];
	current_ptr_to_edit = current_ten_ptr[4];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_6(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[5];
	current_ptr_to_edit = current_ten_ptr[5];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_7(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[6];
	current_ptr_to_edit = current_ten_ptr[6];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_8(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[7];
	current_ptr_to_edit = current_ten_ptr[7];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_9(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[8];
	current_ptr_to_edit = current_ten_ptr[8];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

void display_ip_default_edit_delete_10(Request_t* request)
{
	IP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[9];
	current_ptr_to_edit = current_ten_ptr[9];
	display_ip_default_entry_for_editing_deleting(request, ptr_data);
}

/*-------------Functions for Handling Application Access Rights-------------*/
void display_app_default_page(Request_t* request)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	buffer = (BYTE *) calloc(strlen(APP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, APP_DEFAULT_data_ptr);
		
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(APP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free (buffer);
}

void delete_app_default_data(Request_t* request, TEMP_APP_DEFAULT *ptr_data)
{
	if(udb_app_default_delete(ptr_data) == DELETE_SUCCESSFUL)
		printf("IP Default Entry is Deleted Successfully\n");
	else
		printf("IP Default Entry is NOT found\n");

	InitReturnBuffer(request, ACCESS_RIGHTS_data_ptr, strlen(ACCESS_RIGHTS_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void add_app_access_rights_to_list(Request_t* request)
{
	ADD_APP_DEFAULT_form_output_type *ptr_app_deft;
	TEMP_APP_DEFAULT app_default;
	int ret_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	ptr_app_deft = (ADD_APP_DEFAULT_form_output_type *) form_data_of_request(request);
	app_default.lower_port = atoi(ptr_app_deft->lower_port);
	app_default.upper_port = atoi(ptr_app_deft->upper_port);
	if(ptr_app_deft->protocol == 0) app_default.protocol = TCP_PROTOCOL;
	if(ptr_app_deft->protocol == 1) app_default.protocol = UDP_PROTOCOL;
	if(ptr_app_deft->protocol == 2) app_default.protocol = TCP_UDP_PROTOCOL;

	/*sri printf("Port : %d, %d :: Protocol : %d\n", app_default.lower_port, app_default.upper_port, app_default.protocol); */
	ret_value = udb_app_default_insert(&app_default);

	switch (ret_value)
	{
		case ILLEGAL_DATA:
			printf("Illegal Data Type\n");
			break;

		case INSERT_NO_MEMORY:
			printf("Insert No Memory\n");
			break;

		case INSERT_SUCCESSFUL:
			printf("Inserted Successfully\n");
			break;

		case INSERT_USER_ALREADY_EXISTS:
			printf("Entry Already Exist\n");
			break;
	}		
	InitReturnBuffer(request, ACCESS_RIGHTS_data_ptr, strlen(ACCESS_RIGHTS_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_app_default_entry_for_editing(Request_t* request, TEMP_APP_DEFAULT *ptr_data)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0, index, i;
	char buf[10];

	buffer = (BYTE *) calloc(strlen(APP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, APP_DEFAULT_data_ptr);
	my_itoa(ptr_data->lower_port, buf, 10);
	search_to_start_at = search_and_replace("#___TEXT___#___", buf, buffer, TRUE, search_to_start_at);
	my_itoa(ptr_data->upper_port, buf, 10);
	search_to_start_at = search_and_replace("#___TEXT___#___", buf, buffer, TRUE, search_to_start_at);

	if(ptr_data->protocol == TCP_PROTOCOL) index = 0;
	if(ptr_data->protocol == UDP_PROTOCOL) index = 1;
	if(ptr_data->protocol == TCP_UDP_PROTOCOL) index = 2;

	for(i=0; i < index; i++)
	{
		search_to_start_at = search_and_replace(templates[ENUM_MENU], " ", buffer, FALSE, search_to_start_at);
  	}
	search_to_start_at = search_and_replace(templates[ENUM_MENU], "selected", buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(APP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

/*---------------------------------------------------------------------------
		This Function Puts the Next ten Entries that has to be displayed into 
		current_ten_ptr array.
---------------------------------------------------------------------------*/

void put_ten_app_default_entries_to_current_ptr_array(Request_t* request, APP_DEFAULT_DATA *ptr_to_current_app_default)
{
	APP_DEFAULT_DATA *ptr_data;
	int i;

	for(i=0; i<NUMBER_OF_ENTRIES_PER_PAGE; i++)
	{
		if(ptr_to_current_app_default != NULL)
		{
			current_ten_ptr[i] = (void *) ptr_to_current_app_default;
			ptr_to_current_app_default = ptr_to_current_app_default->next_node;
		}
		else
			current_ten_ptr[i] = NULL;
	}
}

void fill_the_vedapdft_form_with_appropriate_values (BYTE *buffer)
{
	USHORT search_to_start_at = 0, i;
	APP_DEFAULT_DATA *ptr_data;
	char buf[10];

	for(i=0; i<NUMBER_OF_ENTRIES_PER_PAGE; i++)
	{
		ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[i];
		if(ptr_data != NULL)
		{
			search_to_start_at = search_and_replace("#SRE", "", buffer, TRUE, search_to_start_at);
			my_itoa(ptr_data->data->lower_port, buf, 10);
			search_to_start_at = search_and_replace("#_PRT", buf, buffer, TRUE, search_to_start_at);
			my_itoa(ptr_data->data->upper_port, buf, 10);
			search_to_start_at = search_and_replace("#_PRT", buf, buffer, TRUE, search_to_start_at);
			if(ptr_data->data->protocol == TCP_PROTOCOL) strcpy(buf, "TCP");
			if(ptr_data->data->protocol == UDP_PROTOCOL) strcpy(buf, "UDP");
			if(ptr_data->data->protocol == TCP_UDP_PROTOCOL) strcpy(buf, "TCP&UDP");
			search_to_start_at = search_and_replace("#_PROTOCOL", buf, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#ERE", "", buffer, TRUE, search_to_start_at); 
		}
		else
		{
			search_to_start_at = search_and_replace("#SRE", "<!--", buffer, TRUE, search_to_start_at); 
			search_to_start_at = search_and_replace("#ERE", "-->", buffer, TRUE, search_to_start_at);
		}			
	}

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[9];
	if((ptr_data->next_node == NULL) || (ptr_data == NULL))
		search_to_start_at = disable_the_link_to_display_next_10(buffer, search_to_start_at);
}

void display_ved_app_default_entries(Request_t* request)
{
	BYTE *buffer;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	if(!user_database.num_of_appdefaults)	
	{
		display_access_rights_menu(request);		
		return;
	}

	put_ten_app_default_entries_to_current_ptr_array(request, user_database.sptr_temp_app_default_data);
	buffer = (BYTE *) calloc(strlen(VIEW_EDIT_DEL_APP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, VIEW_EDIT_DEL_APP_DEFAULT_data_ptr);
	fill_the_vedapdft_form_with_appropriate_values (buffer);	
	InitReturnBuffer(request, buffer, strlen(VIEW_EDIT_DEL_APP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_ved_next_app_default_entries(Request_t* request)
{
	BYTE *buffer;
	APP_DEFAULT_DATA *ptr_data;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[9];
	put_ten_app_default_entries_to_current_ptr_array(request, ptr_data->next_node);
	buffer = (BYTE *) calloc(strlen(VIEW_EDIT_DEL_APP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, VIEW_EDIT_DEL_APP_DEFAULT_data_ptr);
	fill_the_vedapdft_form_with_appropriate_values (buffer);	
	InitReturnBuffer(request, buffer, strlen(VIEW_EDIT_DEL_APP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void change_the_edited_app_access_rights_to_list(Request_t* request)
{
	EDIT_DELETE_APP_DEFAULT_form_output_type *edit_app_access_rights;
	TEMP_APP_DEFAULT app_default;
	USHORT ret_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	edit_app_access_rights = (EDIT_DELETE_APP_DEFAULT_form_output_type *) form_data_of_request(request);	
	
	app_default.lower_port = atoi(edit_app_access_rights->lower_port); 
	app_default.upper_port = atoi(edit_app_access_rights->upper_port);
	if(edit_app_access_rights->protocol == 0) app_default.protocol = TCP_PROTOCOL;
	if(edit_app_access_rights->protocol == 1) app_default.protocol = UDP_PROTOCOL;
	if(edit_app_access_rights->protocol == 2) app_default.protocol = TCP_UDP_PROTOCOL;

	if (!strcmp(edit_app_access_rights->DeleteAPPDefaultButton, "Delete"))
	{
		delete_app_default_data(request, &app_default);
		return;
	}
	
	ret_value = udb_app_default_edit(&app_default);
	switch(ret_value)
	{
		case EDIT_SUCCESSFUL :
			printf("Edit APP_DEFAULT SUCCESSFUL\n");
			break;
		case EDIT_RECORD_NOT_FOUND :
			printf("Edit APP_DEFAULT RECORD_NOT_FOUND\n");
			break;
		case INSERT_USER_ALREADY_EXISTS :
			printf("Edit IP_DEFAULT Entry Already Exist\n");
			break;
	}
	InitReturnBuffer(request, ACCESS_RIGHTS_data_ptr, strlen(ACCESS_RIGHTS_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_app_default_entry_for_editing_deleting(Request_t* request, APP_DEFAULT_DATA *ptr_data)
{
	BYTE *buffer;
	char buf[10];
	USHORT search_to_start_at = 0, index, i;

	buffer = (BYTE *) calloc(strlen(EDIT_APP_DEFAULT_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, EDIT_APP_DEFAULT_data_ptr);
	my_itoa(ptr_data->data->lower_port, buf, 10);
	search_to_start_at = search_and_replace("#___TEXT___#___", buf, buffer, TRUE, search_to_start_at);
	my_itoa(ptr_data->data->upper_port, buf, 10);
	search_to_start_at = search_and_replace("#___TEXT___#___", buf, buffer, TRUE, search_to_start_at);

	if(ptr_data->data->protocol == TCP_PROTOCOL) index = 0;
	if(ptr_data->data->protocol == UDP_PROTOCOL) index = 1;
	if(ptr_data->data->protocol == TCP_UDP_PROTOCOL) index = 2;

	for(i=0; i < index; i++)
	{
		search_to_start_at = search_and_replace(templates[ENUM_MENU], " ", buffer, FALSE, search_to_start_at);
  	}
	search_to_start_at = search_and_replace(templates[ENUM_MENU], "selected", buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(EDIT_APP_DEFAULT_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_app_default_edit_delete_1(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[0];
	current_ptr_to_edit = current_ten_ptr[0];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_2(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[1];
	current_ptr_to_edit = current_ten_ptr[1];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_3(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[2];
	current_ptr_to_edit = current_ten_ptr[2];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_4(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[3];
	current_ptr_to_edit = current_ten_ptr[3];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_5(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[4];
	current_ptr_to_edit = current_ten_ptr[4];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_6(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[5];
	current_ptr_to_edit = current_ten_ptr[5];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_7(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[6];
	current_ptr_to_edit = current_ten_ptr[6];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_8(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[7];
	current_ptr_to_edit = current_ten_ptr[7];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_9(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[8];
	current_ptr_to_edit = current_ten_ptr[8];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

void display_app_default_edit_delete_10(Request_t* request)
{
	APP_DEFAULT_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[9];
	current_ptr_to_edit = current_ten_ptr[9];
	display_app_default_entry_for_editing_deleting(request, ptr_data);
}

/*---------------------------------------------------------------------------
				Functions for Handling Filter Configuration
							Started On 4 August 99
---------------------------------------------------------------------------*/
void display_application_filter_page(Request_t* request)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	is_for_group_select = FALSE;
	buffer = (BYTE *) calloc(strlen(ADD_UDB_FILTER_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, ADD_UDB_FILTER_data_ptr);
	search_to_start_at = search_and_replace("#__FILTER__TYPE", "Application", buffer, TRUE, search_to_start_at);

	selected_filter_type = APPLICATION_FILTER;
	search_to_start_at = search_and_replace("#DIP", "<!--", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#EDIP", "-->", buffer, TRUE, search_to_start_at);

	search_to_start_at = search_and_replace("#APP", " ", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___TEXT___#___TEXT___#___#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#_PRT", "", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#EAPP", " ", buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(ADD_UDB_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free (buffer);
}

void display_domain_ipaddress_filter_page(Request_t* request, BYTE *buffer)
{
	USHORT search_to_start_at = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	search_to_start_at = search_and_replace("#DIP", "", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___TEXT___#___TEXT___#___#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#EDIP", "", buffer, TRUE, search_to_start_at);

	search_to_start_at = search_and_replace("#APP", "<!--", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#EAPP", "-->", buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(ADD_UDB_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free (buffer);
}

void display_domain_filter_page(Request_t* request)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0;

	buffer = (BYTE *) calloc(strlen(ADD_UDB_FILTER_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, ADD_UDB_FILTER_data_ptr);

	search_to_start_at = search_and_replace("#__FILTER__TYPE", "Domain Name", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#_IP__ADD__DOMAIN__NAME", "Domain Name", buffer, TRUE, search_to_start_at);

   is_for_group_select = FALSE;
	selected_filter_type = DOMAIN_NAME_FILTER;
	display_domain_ipaddress_filter_page(request, buffer);
}

void display_ipaddress_filter_page(Request_t* request)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0;

	buffer = (BYTE *) calloc(strlen(ADD_UDB_FILTER_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, ADD_UDB_FILTER_data_ptr);

	search_to_start_at = search_and_replace("#__FILTER__TYPE", "IP Address", buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#_IP__ADD__DOMAIN__NAME", "IP Address", buffer, TRUE, search_to_start_at);

   is_for_group_select = FALSE;
	selected_filter_type = IP_ADDRESS_FILTER;
	display_domain_ipaddress_filter_page(request, buffer);
}

void display_filter_main_menu(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	is_for_group_select = FALSE;
	InitReturnBuffer(request, USER_FILTER_MENU_data_ptr, strlen(USER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void delete_filter_data(Request_t* request, FILTER_DATA *ptr_data)
{
	if(udb_filter_delete(ptr_data) == DELETE_SUCCESSFUL)
		printf("Filter Entry is Deleted Successfully\n");
	else
		printf("Filter Entry is NOT found\n");

	InitReturnBuffer(request, USER_MANAGEMENT_data_ptr, strlen(USER_MANAGEMENT_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void add_filters_to_list(Request_t* request)
{
	ADD_UDB_FILTER_DATA_form_output_type *ptr_to_filter_data;
	FILTER_DATA data;		
	TEMP_FILTER_HEADER header;
	int ret_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	ptr_to_filter_data = (ADD_UDB_FILTER_DATA_form_output_type *) form_data_of_request(request);
	header.type = selected_filter_type;
	header.mask = 0;
	header.action = ptr_to_filter_data->filter_action; /* sritemp */
	header.length = 0;
	switch(selected_filter_type)
	{
		case APPLICATION_FILTER :
			data.port = atoi(ptr_to_filter_data->port_number);
			if(ptr_to_filter_data->protocol == 0) data.protocol = TCP_PROTOCOL;
			if(ptr_to_filter_data->protocol == 1) data.protocol = UDP_PROTOCOL;
/*			if(ptr_to_filter_data->protocol == 2) data.protocol = TCP_UDP_PROTOCOL; */
			break;

		case IP_ADDRESS_FILTER :
		case DOMAIN_NAME_FILTER	:
			data.port = data.protocol = 0; 
			strcpy(data.address, ptr_to_filter_data->address);
			header.length = strlen(data.address);
			break;
	}
	data.header = &header;
	ret_value = udb_filter_insert(&data);

	switch (ret_value)
	{
		case INSERT_NO_MEMORY:
			printf("Insert No Memory\n");
			break;

		case INSERT_SUCCESSFUL:
			printf("Inserted Successfully\n");
			break;

		case INSERT_USER_ALREADY_EXISTS:
			printf("Entry Already Exist\n");
			break;

		case ILLEGAL_DATA:
			printf("Illegal Data Type\n");
			break;
	}		
	InitReturnBuffer(request, USER_FILTER_MENU_data_ptr, strlen(USER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

/*---------------------------------------------------------------------------
		This Function Puts the Next ten Entries that has to be displayed into 
		current_ten_ptr array.
---------------------------------------------------------------------------*/

void put_ten_filter_entries_to_current_ptr_array(Request_t* request, FILTER_DATA *ptr_to_current_filter)
{
	FILTER_DATA *ptr_data;
	int i;

	for(i=0; i<NUMBER_OF_ENTRIES_PER_PAGE; i++)
	{
		if(ptr_to_current_filter != NULL)
		{
			current_ten_ptr[i] = (void *) ptr_to_current_filter;
			ptr_to_current_filter = ptr_to_current_filter->next_node;
		}
		else
			current_ten_ptr[i] = NULL;
	}
}

void put_ten_filter_entries_to_current_ptr_array_when_udb_is_disabled(Request_t* request, FILTER_DATA *ptr_to_filter, USHORT FilterType)
{
	int i = 0;

/*sri printf("Sree: FilterType - %d\n", FilterType); */
	while(1)
	{
		if(i >= NUMBER_OF_ENTRIES_PER_PAGE)
			break;

		if(ptr_to_filter != NULL)
		{
			if(ptr_to_filter->header->action == FilterType)				
			{
				current_ten_ptr[i] = (void *) ptr_to_filter;
				i++;
			}
			ptr_to_filter = ptr_to_filter->next_node;
		}
		else
		{
			current_ten_ptr[i] = NULL;
		 	i++;
		}
	}
}

void fill_filter_fields_for_view_delete(FILTER_DATA *data, char *type, char *address, char *port, char *protocol, char *action)
{
	if(data->header->action == FILTER_ACTION) strcpy(action, "Block");
	if(data->header->action == FORWARD_ACTION) strcpy(action, "Allow");
	my_itoa(data->port, port, 10);

	switch(data->header->type)
	{
		case APPLICATION_FILTER :
			strcpy(type, "APP");
			strcpy(address, "NONE");

			if(data->protocol == TCP_PROTOCOL) strcpy(protocol, "TCP");
			if(data->protocol == UDP_PROTOCOL) strcpy(protocol, "UDP");
/*			if(data->protocol == TCP_UDP_PROTOCOL) strcpy(protocol, "TCP&UDP"); */
			break;
		case IP_ADDRESS_FILTER :
		case DOMAIN_NAME_FILTER	:
			strcpy(type, "DOM");
			strcpy(protocol, "NONE");				
			strcpy(address, data->address);
			if(data->header->length > 40)
				*(address+40) = '\0';
		/*sri printf("String is : %s\n", address); */
			break;
	}
	if(data->header->type == IP_ADDRESS_FILTER)
		strcpy(type, "IP");
}

void fill_the_vdelfilt_form_with_appropriate_values (BYTE *buffer)
{
	USHORT search_to_start_at = 0, i;
	FILTER_DATA *ptr_data;
	char type[20], address[260], port[20], protocol[20], action[20];

	for(i=0; i<NUMBER_OF_ENTRIES_PER_PAGE; i++)
	{
		ptr_data = (FILTER_DATA *) current_ten_ptr[i];
		if(ptr_data != NULL)
		{
			fill_filter_fields_for_view_delete(ptr_data, type, address, port, protocol, action);
			search_to_start_at = search_and_replace("#SRE", "", buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#_PRT", type, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___#___TEXT___#___", address, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#_PRT", port, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#_PROTOCOL", protocol, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#___TEXT___#___", action, buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#ERE", " ", buffer, TRUE, search_to_start_at);
		}
		else
		{
			search_to_start_at = search_and_replace("#SRE", "<!--", buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace("#ERE", "-->", buffer, TRUE, search_to_start_at);
		}			
	}

	search_to_start_at = search_and_replace("#$$#", " ", buffer, TRUE, search_to_start_at);

	ptr_data = (FILTER_DATA *) current_ten_ptr[9];

	if((ptr_data->next_node == NULL) || (ptr_data == NULL))
	{
		/*sri printf("Disabling Next Link\n");		*/
		search_to_start_at = disable_the_link_to_display_next_10(buffer, search_to_start_at);
	}
}

void display_prev_filter_page(Request_t* request)
{
	if(!is_for_group_select)
		display_filter_main_menu(request);
	else
		display_user_database_menu(request);
}

void display_ved_filter_entries(Request_t* request)
{
	BYTE *buffer;
	USHORT FilterType;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	if(!user_database.num_of_filters)	
	{
		display_filter_main_menu(request);		
		return;
	}

	if(!user_database.temp_enabled)
		put_ten_filter_entries_to_current_ptr_array_when_udb_is_disabled(request, user_database.sptr_temp_filter_data, (USHORT) ((user_database.temp_action) ? FILTER_ACTION : FORWARD_ACTION));
	else	
		put_ten_filter_entries_to_current_ptr_array(request, user_database.sptr_temp_filter_data);

	buffer = (BYTE *) calloc(strlen(VIEW_DELETE_UDB_FILTER_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, VIEW_DELETE_UDB_FILTER_data_ptr);
	fill_the_vdelfilt_form_with_appropriate_values (buffer);	
	InitReturnBuffer(request, buffer, strlen(VIEW_DELETE_UDB_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_ved_next_filter_entries(Request_t* request)
{
	BYTE *buffer;
	FILTER_DATA *ptr_data;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[9];
#if 0
if(ptr_data != NULL)
	printf("Filter Entries r : %d - %d\n", ptr_data->next_node->port, ptr_data->next_node->protocol);
else
	printf("Filter is NULL\n");
#endif

	if(!user_database.temp_enabled)
		put_ten_filter_entries_to_current_ptr_array_when_udb_is_disabled(request, ptr_data->next_node, (USHORT) ((user_database.temp_action) ? FILTER_ACTION : FORWARD_ACTION));
	else	
		put_ten_filter_entries_to_current_ptr_array(request, ptr_data->next_node);

	buffer = (BYTE *) calloc(strlen(VIEW_DELETE_UDB_FILTER_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, VIEW_DELETE_UDB_FILTER_data_ptr);
	fill_the_vdelfilt_form_with_appropriate_values (buffer);	
	InitReturnBuffer(request, buffer, strlen(VIEW_DELETE_UDB_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void change_the_deleted_filter_to_list(Request_t* request)
{
	DELETE_UDB_FILTER_DATA_form_output_type *delete_filter;
	FILTER_DATA filter;
	USHORT ret_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	delete_filter = (DELETE_UDB_FILTER_DATA_form_output_type *) form_data_of_request(request);
	memcpy(&filter, (FILTER_DATA *) current_ptr_to_edit, sizeof(FILTER_DATA));
	
	if (!strcmp(delete_filter->DeleteFilterButton, "Delete"))
	{
		delete_filter_data(request, &filter);
		return;
	}
	
	InitReturnBuffer(request, USER_MANAGEMENT_data_ptr, strlen(USER_MANAGEMENT_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_filter_entry_for_editing_deleting(Request_t* request, FILTER_DATA *ptr_data)
{
	BYTE *buffer;
	USHORT search_to_start_at = 0;
	char type[20], address[260], port[20], protocol[20], action[20];

	buffer = (BYTE *) calloc(strlen(DELETE_UDB_FILTER_data_ptr), 1);
	if(buffer == NULL)
	{
		printf("WEB:Not enough memory\n");
	   return;
	}
	strcpy(buffer, DELETE_UDB_FILTER_data_ptr);
	fill_filter_fields_for_view_delete(ptr_data, type, address, port, protocol, action);

	search_to_start_at = search_and_replace("#___TEXT___#___", type, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___#___TEXT___#___", address, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___", port, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___", protocol, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#___TEXT___#___", action, buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(DELETE_UDB_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_group_select_page(Request_t* request, FILTER_DATA *ptr_data)
{
	int i;
   USHORT search_to_start_at=0;   
	char StrToReplace[100], buff[10], sbuf[10], ebuf[10];
   BYTE* buffer;
	GROUP_DATA *ptr_to_group;
	FILTER_DATA *ptr_to_filter;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_to_filter = (FILTER_DATA *) current_ptr_to_edit;
	buffer = (BYTE *) calloc(strlen(GROUP_MASK_data_ptr), 1);
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
	strcpy(buffer, GROUP_MASK_data_ptr);

	ptr_to_group = user_database.sptr_temp_group_data;
	for(i = 1; i <= MAX_NO_OF_GROUP_ENTRIES; i++)
	{
		my_itoa (i, buff, 10);
		strcpy(StrToReplace, "Group");
		strcat(StrToReplace, buff);
		strcat(StrToReplace, "___TEXT___#___TEXT___#___TEXT___#___#");

		strcpy(sbuf, "#S");
		strcat(sbuf, buff);

		strcpy(ebuf, "#E");
		strcat(ebuf, buff);

		if(ptr_to_group != NULL)		
		{
/* Display groups which belongs to (Default Action Type) or 
    										  (Same as that of Filter Action)  */

/*sri printf("\nFilter %s : %d : %d : %x : %d", ptr_to_group->data->group_name, ptr_to_group->filter_action, ptr_to_filter->header->action, ptr_to_filter->header->mask, ptr_to_group->count); */
			if(is_filter_enabled (ptr_to_group->data->group_no, (ULONG *) &ptr_to_filter->header->mask))
			{
/* These selected groups should be displayed & checked.... */
				search_to_start_at = search_and_replace(sbuf, "", buffer, TRUE, search_to_start_at);
				search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at);
				search_to_start_at = search_and_replace(StrToReplace, ptr_to_group->data->group_name, buffer, TRUE, search_to_start_at);
				search_to_start_at = search_and_replace(ebuf, "", buffer, TRUE, search_to_start_at);
				GroupStatus[ptr_to_group->data->group_no] = TO_BE_UNCHECKED;
			}
			else
			{
				if((ptr_to_group->filter_action == DEFAULT_ACTION) || (ptr_to_group->filter_action == ptr_to_filter->header->action) || (ptr_to_group->count == 0))
				{
/* These selected groups should be displayed & not checked.... */
					search_to_start_at = search_and_replace(sbuf, "", buffer, TRUE, search_to_start_at);
					search_to_start_at = search_and_replace(StrToReplace, ptr_to_group->data->group_name, buffer, TRUE, search_to_start_at);
					search_to_start_at = search_and_replace(ebuf, "", buffer, TRUE, search_to_start_at);
					GroupStatus[ptr_to_group->data->group_no] = TO_BE_CHECKED;
				}
				else
				{
/* These selected groups should not be displayed.... */
					search_to_start_at = search_and_replace(sbuf, "<!--", buffer, TRUE, search_to_start_at);
					search_to_start_at = search_and_replace(ebuf, "-->", buffer, TRUE, search_to_start_at);
					GroupStatus[ptr_to_group->data->group_no] = GRP_NOT_SELECTED;
				}
			}
			ptr_to_group = ptr_to_group->next_node;
		}
		else
		{
			search_to_start_at = search_and_replace(sbuf, "<!--", buffer, TRUE, search_to_start_at);
			search_to_start_at = search_and_replace(ebuf, "-->", buffer, TRUE, search_to_start_at);
			GroupStatus[i] = GRP_NOT_SELECTED;
		}
	}
	InitReturnBuffer(request, buffer, strlen(GROUP_MASK_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void change_group_mask_parameters(Request_t* request)
{
	int i, *enable;
	GROUP_MASK_DATA_form_output_type *ptr_to_group_select;
	GROUP_DATA *ptr_to_group;
	FILTER_DATA *ptr_to_filter;

	ptr_to_filter = (FILTER_DATA *) current_ptr_to_edit;
	ptr_to_group = user_database.sptr_temp_group_data;
	ptr_to_group_select = (GROUP_MASK_DATA_form_output_type *)form_data_of_request(request);
	enable = (int *) ptr_to_group_select;
	for(i = 1; i <= MAX_NO_OF_GROUP_ENTRIES; i++)
	{
		if(ptr_to_group != NULL)
		{
			switch(GroupStatus[i])
			{
				case TO_BE_CHECKED :
					if(*enable)
					{
						set_group_filter_enabled(ptr_to_group->data->group_no, (ULONG *) &ptr_to_filter->header->mask); 
					 	ptr_to_group->count++;
						ptr_to_group->filter_action = ptr_to_group->data->allow_sites = ptr_to_filter->header->action;
					}
					break;
				case TO_BE_UNCHECKED :
					if(!*enable)
					{
						set_group_filter_disabled(ptr_to_group->data->group_no, (ULONG *) &ptr_to_filter->header->mask); 
					 	ptr_to_group->count--;
					}
					break;
				case GRP_NOT_SELECTED :
					break;
			}
			if(!ptr_to_group->count)
			{
				ptr_to_group->filter_action = DEFAULT_ACTION;
			}
			ptr_to_group = ptr_to_group->next_node;
		}						
		enable++;
	}
	display_ved_filter_entries(request);
}

void display_filter_delete_1(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[0];
	current_ptr_to_edit = current_ten_ptr[0];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_2(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[1];
	current_ptr_to_edit = current_ten_ptr[1];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_3(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[2];
	current_ptr_to_edit = current_ten_ptr[2];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_4(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[3];
	current_ptr_to_edit = current_ten_ptr[3];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_5(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[4];
	current_ptr_to_edit = current_ten_ptr[4];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_6(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[5];
	current_ptr_to_edit = current_ten_ptr[5];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_7(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[6];
	current_ptr_to_edit = current_ten_ptr[6];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_8(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[7];
	current_ptr_to_edit = current_ten_ptr[7];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_9(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[8];
	current_ptr_to_edit = current_ten_ptr[8];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void display_filter_delete_10(Request_t* request)
{
	FILTER_DATA *ptr_data;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_data = (FILTER_DATA *) current_ten_ptr[9];
	current_ptr_to_edit = current_ten_ptr[9];
	if(!is_for_group_select)
		display_filter_entry_for_editing_deleting(request, ptr_data);
	else
		display_group_select_page(request, ptr_data);
}

void order_group_numbers_in_ascending_and_set_other_parameters()
{
	GROUP_DATA *ptr_to_group;
	FILTER_DATA *ptr_to_filter;
	int index = 1, j;
	
	ptr_to_group = user_database.sptr_temp_group_data;
	user_database.num_of_groups = 0;
	while(ptr_to_group != NULL)
	{
		ptr_to_group->data->group_no = index;
		ptr_to_group->count = 0;
		user_database.num_of_filters = 0;
		ptr_to_filter = user_database.sptr_temp_filter_data;
		while(ptr_to_filter != NULL)
		{
			if(is_filter_enabled (ptr_to_group->data->group_no, (ULONG *) &ptr_to_filter->header->mask))
			{
				ptr_to_group->count++;
			}
			ptr_to_filter = ptr_to_filter->next_node;
			user_database.num_of_filters++;
		}
		ptr_to_group->filter_action = ptr_to_group->data->allow_sites;
		ptr_to_group = ptr_to_group->next_node;
		user_database.num_of_groups++;
		index++;
	}
}		

void display_filters_for_group_select_menu(Request_t* request)
{
	is_for_group_select = TRUE;
	order_group_numbers_in_ascending_and_set_other_parameters();
	display_ved_filter_entries(request);
	return;
}
/* .....Added by Sreelu for Access Rights & Filters */

/* Added by Sreelu for UDB Download...... */
void download_user_database(Request_t* request)
{
	int ret_value;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ret_value = udb_user_update_after_changes();
	switch(ret_value)
	{	
		case UPDATE_NO_MEMORY :
			printf("Failed to Update Userdatabase : No Memory\n");
			break;
		case UPDATE_SUCCESSFUL :
			printf("Userdatabase Updated Successfully\n");
			break;
	}
   display_standard_main_page(request);
}
/* ......Added by Sreelu for UDB Download */

/* Added by Sreelu for Debug...... */
void display_ip_from_current_ten_ptrs()
{
	int i;
	IP_DEFAULT_DATA *ptr_data;

	for(i=0; i<10; i++)
	{
		ptr_data = (IP_DEFAULT_DATA *) current_ten_ptr[i];
		if(ptr_data != NULL) 
			printf("\n%d. [%s] : [%s]", i, ptr_data->data->lower_address, ptr_data->data->upper_address);
	}
}

void display_app_from_current_ten_ptrs()
{
	int i;
	APP_DEFAULT_DATA *ptr_data;

	for(i=0; i<10; i++)
	{
		ptr_data = (APP_DEFAULT_DATA *) current_ten_ptr[i];
		if(ptr_data != NULL) 
			printf("\n%d. [%d] : [%d] : [%d]", i, ptr_data->data->lower_port, ptr_data->data->upper_port, ptr_data->data->protocol);
	}
}

void display_filter_from_current_ten_ptrs()
{
	int i;
	FILTER_DATA *ptr_data;

	for(i=0; i<10; i++)
	{
		ptr_data = (FILTER_DATA *) current_ten_ptr[i];
		if(ptr_data != NULL) 
		switch(ptr_data->header->type)
		{
			case APPLICATION_FILTER :
				printf("\nApp    - [%d] : [%d]", ptr_data->port, ptr_data->protocol);
				break;
			case IP_ADDRESS_FILTER  :
			case DOMAIN_NAME_FILTER :
				printf("\nDom|IP - [%s] ", ptr_data->address);
				break;
		}
	}
}

void display_group_status()
{
	int i;
	
	printf("Group No              Group Status\n ");
	printf("--------					------------ \n ");
	for(i=1; i<=25; i++)
		printf("   %d								%d\n", i, GroupStatus[i]);		
}
/* ......Added by Sreelu for Debug */

