/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "httpd.h"
#include "util.h"
#include "authoriz.h"


/*** UUDECODE taken from public domain code, see notice ****/

const static char six2pr[64] = {
    'A','B','C','D','E','F','G','H','I','J','K','L','M',
    'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
    'a','b','c','d','e','f','g','h','i','j','k','l','m',
    'n','o','p','q','r','s','t','u','v','w','x','y','z',
    '0','1','2','3','4','5','6','7','8','9','+','/'
};

static unsigned char pr2six[256];

static int pr2six_was_initialized = FALSE ; 

void base64_decode( char *input_data, 
		    char *output_data , 
		   int outbufsize , 
		   int *output_length) 
{
#define DEC(c) pr2six[(int)c]
#define MAXVAL 63


   int nbytesdecoded, j;
   char *bufin ;
   unsigned char *bufout ;
   int nprbytes;

bufout = (unsigned char *) output_data ;

if (! pr2six_was_initialized )
  {
      for(j=0; j<256; j++) pr2six[j] = MAXVAL+1;

      for(j=0; j<64; j++) pr2six[(int)six2pr[j]] = (unsigned char) j;

      pr2six_was_initialized = TRUE ; 
  }



   /* Strip leading whitespace. */

   while(*input_data==' ' || *input_data == '\t') input_data++;

   /* Figure out how many characters are in the input buffer.
    * If this would decode into more bytes than would fit into
    * the output buffer, adjust the number of input bytes downwards.
    */
   bufin = input_data;
   while(pr2six[(int)*(bufin++)] <= MAXVAL);
   nprbytes = bufin - input_data - 1;
   nbytesdecoded = ((nprbytes+3)/4) * 3;
   if(nbytesdecoded > outbufsize) {
      nprbytes = (outbufsize*4)/3;
   }

   bufin = input_data;
   
   while (nprbytes > 0) {
      *(bufout++) = (unsigned char) (DEC(*bufin) << 2 | DEC(bufin[1]) >> 4);
      *(bufout++) = (unsigned char) (DEC(bufin[1]) << 4 | DEC(bufin[2]) >> 2);
      *(bufout++) = (unsigned char) (DEC(bufin[2]) << 6 | DEC(bufin[3]));
      bufin += 4;
      nprbytes -= 4;
   }
   
   if(nprbytes & 03) {
      if(pr2six[(int)bufin[-2]] > MAXVAL) {
         nbytesdecoded -= 2;
      } else {
         nbytesdecoded -= 1;
      }
   }

   *output_length = nbytesdecoded;
}













 Word_t scheme_names[] = {
  { "Basic", 5  ,  BASIC_AUTHORIZATION } 
  } ; 

 WordList_t scheme_list = { scheme_names , 1 } ; 


void parse_auothorization_information(
	      char *begin_info , 
	      int info_length , 
	      AuthorizationInformation_t *authorization)
{
char *scheme_string  ; 
int scheme_length ; 
int scheme ; 

char *encoded_usr_passwd ; 
int encoded_usr_passwd_length ; 

char decoded_usr_passwd[ 2*MAX_USERID_LENGTH + 1 ] ; 
int decoded_usr_passwd_length ; 
int i ; 
char *password ; 
int password_length ; 

authorization->scheme = NO_AUTHORIZATION ; 

scheme_string  = begin_info ; 

get_next_word(&scheme_string , &scheme_length , begin_info + info_length  ) ; 

scheme = find_word_case_insensitive( scheme_string , scheme_length, 
				    &scheme_list ) ; 


switch( scheme ) {
 case BASIC_AUTHORIZATION: {
   authorization->scheme = BASIC_AUTHORIZATION ; 
   encoded_usr_passwd = scheme_string + scheme_length ; 
   get_next_word( &encoded_usr_passwd, &encoded_usr_passwd_length, 
		 begin_info + info_length  ) ; 
   
   base64_decode( encoded_usr_passwd, 
		 decoded_usr_passwd,  2*MAX_USERID_LENGTH + 1, 
		 &decoded_usr_passwd_length) ; 


   
   for(i = 0 ; 
       (i < decoded_usr_passwd_length) && (decoded_usr_passwd[i]!=':') &&
       ( i < MAX_USERID_LENGTH - 1  ) ; 
       i++ )
     {
       authorization->user_name[i] = decoded_usr_passwd[i] ; 
     }
    authorization->user_name[i] = 0 ; 

   if (decoded_usr_passwd[i]==':')
     {
       password = decoded_usr_passwd + i + 1 ; 
       password_length = decoded_usr_passwd_length - i - 1 ; 
       for(i = 0 ; 
	   (i < password_length) && 
	   ( i < MAX_USERID_LENGTH - 1  ) ; 
	   i++ )
	 {
	   authorization->password[i] = password[i] ; 
	 }
       authorization->password[i] = 0 ; 
     }
   else
     {
       authorization->password[0] = 0 ; 
     }

 }


 }


}



