/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef DATATRAN_H
#define DATATRAN_H

#include "..\..\prochttp\src\reqlist.h"

#define DT_MAX_NOF_BUFFERS 20
/** DT stands for data transfer ***/

typedef struct _OperationStatus_t {
  void (*do_operation)(void *,struct _OperationStatus_t *) ; 
            /*** (DataTransferStatus_t *, OperationStatus_t *)  */
  void (*close_operation)(struct _OperationStatus_t *) ; 
  void *handle ; 
  enum { START_OPERATION, IN_OPERATION, END_OPERATION } status ; 
} OperationStatus_t ; 

#define MAX_NOF_OPERATIONS 10


typedef struct  _DataTransferStatus_t  { 
  OperationStatus_t io_operations[MAX_NOF_OPERATIONS]; 
  int nof_operations ; 
  int current_operation_number ; 
  int application_has_set_next_operation ; 
  int next_operation_set_by_application ; 
  int end_of_processing  ; 
  int socket_should_be_closed ; 
             /** if you set this, set also end_of_processing, unless you 
             **  set it from close_operation function  *****/
  void *data_buffers[DT_MAX_NOF_BUFFERS] ; 
  int buffer_sizes[DT_MAX_NOF_BUFFERS] ; 
  int nof_buffers ; 
} DataTransferStatus_t ; 

void InitDataTransferStatus( DataTransferStatus_t *transfer_status); 



void ContinueDataTransfer(DataTransferStatus_t *transfer_status,
			  int single_iteration);

void InitNonBlockingOutput(Request_t *request , 
			 OperationStatus_t *operation_status);

void InitSimpleConstStringInput(OperationStatus_t *operation_status, 
				char *string);
/*** DOES NOT MAKE COPY OF THE STRING !!!! *****/

void InitHeaderInput(ResponseHeaderInformation_t *header_info , 
			 OperationStatus_t *operation_status);



void DataTransfer(Request_t *request ); 

void OneIterationDataTransfer(Request_t *request );


void AddBuffer( DataTransferStatus_t *transfer_status , void *buffer, int len);


void AddStringBuffer( DataTransferStatus_t *transfer_status , char *buffer);

void   GenericSimpleFreeState( OperationStatus_t *operation_status);

void DoFreeParameter(void *parameter, DataTransferStatus_t *data_transfer);

void set_next_operation_by_application(DataTransferStatus_t *transfer_status,
				       int operation_number );


void InitReturnNotFound(Request_t *request, 
			    char *error_message, 
			    int error_message_should_be_copied);

void InitReturnForbidden(Request_t *request, 
			    char *error_message, 
			    int error_message_should_be_copied);

void InitReturnUnauthorized(Request_t *request, 
			    char * challenge, 
			    char *error_message, 
			    int error_message_should_be_copied);


#endif /** DATATRAN_H **/


