/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "httpd.h"
#include "lstnsock.h"
#include "procreq.h"
#include "util.h"
#include "..\..\sysdep\src\tcprw.h"
#include "resphead.h"
#include "formphas.h"
#include "incall.h"
#include "cfgmgr.h"

void tmr_Wait(long nCount, long nMilliSecondsPerCount);

void check_for_new_connections(ListenSocketsList_t *listen_sockets, 
			       RequestList_t *request_list )
{
int i_listen_socket ; 
struct sockaddr_in client_address ; 

int addr_length ; 

int new_client_was_found ; 

Socket_t new_client_socket ; 

for (i_listen_socket = 0 ; 
     i_listen_socket < listen_sockets->nof_listen_sockets ; 
     i_listen_socket++ )
  {

    accept_new_connection(listen_sockets->sockets[i_listen_socket].socket,
			  &new_client_socket, &new_client_was_found,
			  &client_address, &addr_length);

    if (new_client_was_found) 
      {
			add_new_request(request_list, &new_client_socket,  &client_address, 
			addr_length ) ; 
      }


  }
} 

 Word_t methods[] = {
  { "GET", 3 ,  GET_METHOD } , 
  { "HEAD" , 4 , HEAD_METHOD } , 
  { "PUT" , 3 , PUT_METHOD } , 
  { "POST" , 4 , POST_METHOD } ,
  { "DELETE" , 6 ,  DELETE_METHOD } , 
  { "LINK" , 4 , LINK_METHOD } , 
  { "UNLINK" , 6 , UNLINK_METHOD }  } ; 

 WordList_t methods_list = { methods, 7 } ; 


 void parse_http_header_line1(Request_t *request, int *no_http_version) 
{
char *p ; 
int length ; 
char *end_of_buffer ; 

end_of_buffer =  request->status.header_data +
                        request->status.nof_chars_in_header ; 

p = request->status.header_data ; 


get_next_word( &p , &length ,end_of_buffer ); 

request->params.method = find_word_case_insensitive( p , length, &methods_list) ; 

request->params.uri = p + length  ; 
get_next_word(&request->params.uri, &request->params.uri_length,end_of_buffer);

request->params.http_version = request->params.uri +
                                request->params.uri_length ;
get_next_word(&request->params.http_version, 
	       &request->params.http_version_length,end_of_buffer);

*no_http_version = (  &request->params.http_version_length == 0 ) ; 

}
 


Word_t content_type_options[] = {
  { "multipart/form-data", 19 ,  CONTENT_TYPE_MULTIPART_FORM  } , 
  { "application/x-www-form-urlencoded", 33 , CONTENT_TYPE_URL_ENCODE   } , 
};

 WordList_t content_type_option_list = { content_type_options, 2 } ; 


enum { CONTENT_TYPE_PARAM_BOUNDARY } ; 

Word_t content_type_parameters[] = {
  { "boundary", 8 ,  CONTENT_TYPE_PARAM_BOUNDARY  } , 
};

 WordList_t content_type_parameter_list = { content_type_parameters , 1 } ; 



void parse_content_type_information( char *line_start , 
				     int   line_length , 
				     RequestParams_t *request_params)
{

char *field_name; 
int field_name_length ; 

char *content_type ;
int content_type_length ; 

char *attribtues[5], *values[5] ; 
int att_length[5], value_length[5] ; 
int nof_pairs ; 


int parameter ; 
int i_pair ; 


parse_mime_header_type_line(line_start, line_length, 
			    &field_name,  &field_name_length, 
			    &content_type,  &content_type_length, 
			    5, 
			    attribtues, att_length, 
			    values,  value_length, 
			    &nof_pairs ) ; 


request_params->content_type  = 
  find_word_case_insensitive(content_type , content_type_length ,  
			     &content_type_option_list ) ; 

HTTP_TRACE("header-parse", sprintf(tmp_trace, 
                    "content type:%.*s length: %d result %d",
		    content_type_length , content_type, 
		    content_type_length , request_params->content_type )) ; 

if (request_params->content_type ==  NOT_FOUND_IN_WORD_LIST)
  {
    request_params->content_type = NO_CONTENT_TYPE ; 
    HTTP_REPORT_ERROR("Unknown Content Type ") ; 
  }

/**** now process parameters ***********/




for(i_pair = 0 ; i_pair < nof_pairs ; i_pair++)
  {
    parameter = find_word_case_insensitive(attribtues[i_pair], 
					 att_length[i_pair] ,  
					 &content_type_parameter_list ) ; 

    switch(parameter)
      {
      case  CONTENT_TYPE_PARAM_BOUNDARY: {
	request_params->boundary = values[i_pair] ; 
	request_params->boundary_length = value_length[i_pair] ; 
	break ; 
      }
      }

  }
}




#if 0 

void parse_content_type_information( char *info , 
				     int   info_length , 
				     RequestParams_t *request_params)
{
char *start_parameter ; 
char *start_attribute ; 
char *start_content_type ; 
int parameter_length ; 
int attribute_length ; 

int content_type_length ; 

int parameter ; 

start_content_type = info ; 
while (*start_content_type == ' ')
  {
    start_content_type++ ; 
  }



content_type_length = 0 ; 
while ( (content_type_length < info_length ) &&
        (start_content_type[content_type_length] != ',') &&  
                         /*** rfc 1867 specified ',' though all
                         *** the others specify ';' ******/
        (start_content_type[content_type_length] != ';') &&
        (start_content_type[content_type_length] != ' ') &&
        (start_content_type[content_type_length] != '\n') &&
        (start_content_type[content_type_length] != '\r') )
  {
    content_type_length++ ; 
  }

request_params->content_type  = 
  find_word_case_insensitive(start_content_type , content_type_length ,  
			     &content_type_option_list ) ; 

if (request_params->content_type ==  NOT_FOUND_IN_WORD_LIST)
  {
    request_params->content_type = NO_CONTENT_TYPE ; 
    HTTP_REPORT_ERROR("Unknown Content Type ") ; 
  }

/**** now process parameters ***********/

start_parameter = start_content_type + content_type_length ; 


while (1)
  {

    while ( ( *start_parameter == ',' ) || 
                            /*** rfc 1867 specified ',' though all
			    **** the others specify ';' ******/
	   ( *start_parameter == ';' ) ||
	   ( *start_parameter == ' ' )  )
      {
	start_parameter++ ; 
      }

    if ( ( *start_parameter == '\n' ) ||
        ( *start_parameter == '\r' ) ||
        (start_parameter  - info >= info_length ) )
      {
	break ; 
      }


    parameter_length = 0 ; 
    while ((start_parameter[parameter_length] != '=' ) && 
	   (start_parameter + parameter_length - info < info_length ) )
      {
	parameter_length++ ; 
      }


    start_attribute = start_parameter + parameter_length + 1 ; 
    if (*start_attribute == '\"' ) /*** quoted string ***/
      {
	start_attribute++ ; 
	attribute_length = 0 ; 
	while (start_attribute[attribute_length] != '\"' )
	  {
	    attribute_length++ ; 
	  }
      }
    else /*** token and not quoted string ***/
      {
	attribute_length = 0 ; 
	while ( (start_attribute[attribute_length] != ' ' ) &&
                (start_attribute[attribute_length] != '\n' ) &&
                (start_attribute[attribute_length] != '\r' ) &&
                (start_attribute[attribute_length] != ';' ) &&
                (start_attribute[attribute_length] != ',' )  )
	  {
	    attribute_length++ ; 
	  }
      }

    
    parameter = find_word_case_insensitive(start_parameter, 
					 parameter_length ,  
					 &content_type_parameter_list ) ; 


    switch(parameter)
      {
      case  CONTENT_TYPE_PARAM_BOUNDARY: {
	request_params->boundary = start_attribute ; 
	request_params->boundary_length = attribute_length ; 
	break ; 
      }
      }

    start_parameter = start_parameter + attribute_length  ; 

  }
}


#endif



enum {  FIELD_HEADER_AUTHORIZATION, 
        FIELD_HEADER_CONTENT_LENGTH, 
        FIELD_HEADER_IF_MODIFIED_SINCE,
        FIELD_HEADER_CONTENT_TYPE } ; 
 Word_t field_names[] = {
  { "Authorization", 13 ,  FIELD_HEADER_AUTHORIZATION } , 
  { "Content-Length", 14 , FIELD_HEADER_CONTENT_LENGTH } , 
  { "If-Modified-Since" , 17 , FIELD_HEADER_IF_MODIFIED_SINCE  } , 
  { "Content-type" , 12 , FIELD_HEADER_CONTENT_TYPE  } , 
  } ; 

 WordList_t field_name_list = { field_names , 4 } ; 


void parse_http_header_header_fields(Request_t *request)
{
/** should add res code here *****/

char *field_start, *end_of_header  ; 
int field_length ; 
int field_type ; 
int info_length ; 

set_null_date( &request->params.if_modified_since ) ; 
request->params.authorization.scheme  = NO_AUTHORIZATION ; 
request->params.content_length = NO_CONTENT_LENGTH ; 

request->params.content_type = NO_CONTENT_TYPE ; 

end_of_header =  request->status.header_data + 
                           request->status.nof_chars_in_header; 

field_start = request->status.beginning_of_header_fields ; 

while ( (*field_start != '\r' ) && (*field_start != '\n') &&
       (field_start < end_of_header ) )
  {
    field_length = 0 ; 
    while ((field_start[field_length] != ':') &&
	   (field_start[field_length] != '\r') &&
	   (field_start[field_length] != '\n') &&
	   (field_start + field_length < end_of_header) )
      {
	field_length++ ; 
      }


    info_length = 0 ; 
    while ((field_start[field_length+info_length] != '\r') &&
	   (field_start[field_length+info_length] != '\n') &&
	   (field_start + field_length + info_length < end_of_header) )
      {
	info_length++ ; 
      }



    field_type = find_word_case_insensitive(field_start, field_length ,  
			   &field_name_list ) ; 

    switch(field_type) {
    case FIELD_HEADER_IF_MODIFIED_SINCE: {
      HTTP_TRACE("header-parse", 
		 sprintf(tmp_trace, " if modified since %s29\n", 
			 field_start + field_length + 1) ) ; 
      parse_http_date( field_start + field_length + 1,
		      &request->params.if_modified_since );
      break ; 
    }
    case FIELD_HEADER_CONTENT_LENGTH: {
      request->params.content_length = atoi(field_start + field_length + 1); 
      break ; 
    }
    case FIELD_HEADER_AUTHORIZATION: {
      parse_auothorization_information( field_start + field_length + 1 , 
				       info_length , 
				       &request->params.authorization );

      break ; 
    }

    case FIELD_HEADER_CONTENT_TYPE: {
      parse_content_type_information( field_start , 
				       field_length + info_length , 
				        &request->params);
      break ; 
    }

    }

    field_start+= field_length + info_length  ; 
    while ((*field_start != '\n') &&
	   (field_start  < end_of_header) )
      {
	field_start++ ; 
      }
    field_start++ ; 
  }

}


 void process_http_header( Request_t * request )
{
int nof_bytes_received ; 
int i_incoming_byte ; 
char *p, *beginning_of_available_space ; 
int no_http_version ; 

int client_closed_connection , returned_error ; 


/*HTTP_TRACE_MSG("proc-trace", "In process_http_header"); */


beginning_of_available_space =  &request->status.header_data[
                                  request->status.nof_chars_in_header] ; 



#ifdef BLOCKING_IO_ONLY

read_data_from_socket_until_delimiter(request->socket, 
      beginning_of_available_space, 
      MAX_HEADER_SIZE-request->status.nof_chars_in_header,
      &nof_bytes_received, 
      &client_closed_connection, &returned_error, '\n' ) ; 


#else /*** non-blocking IO ****/

read_available_data_from_socket(request->socket, 
      beginning_of_available_space, 
      MAX_HEADER_SIZE-request->status.nof_chars_in_header,
      &nof_bytes_received, 
      &client_closed_connection, &returned_error ) ; 
#endif /*** Blovking/non-blocking IO ***/


request->status.total_bytes_read_for_header += nof_bytes_received ; 


/*HTTP_TRACE("read-head", 
          sprintf(tmp_trace, " got %d bytes error = %d", nof_bytes_received,
                       returned_error)) ; */

/* Added by Ravi & Naveen on 12 July 1999 ... */
if (client_closed_connection)
{
	shutdown_socket(&request->socket);
	request->status.process_status = SOCKET_IS_CLOSED;
	return;
}
/* ... Added by Ravi & Naveen on 12 July 1999 */


if (nof_bytes_received == 0 )
  {
    return ; 
  }

if (nof_bytes_received == -1 )
  {
    return ; /*** should test for various errors ********/
  }

for (i_incoming_byte = 0, p = beginning_of_available_space ; 
     i_incoming_byte < nof_bytes_received ; 
     i_incoming_byte++, p++,  request->status.nof_chars_in_header++  )
  {
   switch (*p) {
     case '\r' : { 
                 if (request->status.header_line_status == AFTER_CR_LF)
                    { 
		      request->status.header_line_status = AFTER_CR_LF_CR;
		    }
		 else
                    { 
		      request->status.header_line_status = AFTER_CR;
		    }
		 break ; 
	       }
     case '\n' : { 
                 if ( (request->status.header_line_status == IN_LINE) ||
                      (request->status.header_line_status == AFTER_CR) )
		   {
		     request->status.header_line_status = AFTER_CR_LF ; 
		   }
		 else /** either CR_LF or CR_LF_CR ****/
		   {
		     request->status.header_line_status = AFTER_CR_LF_CR_LF ; 
		   }
		 break ; 
		 }
     /** we allow here a \n without \r to be also considered end of line **/
     default : { request->status.header_line_status = IN_LINE ; break ; }
     }

   if (request->status.http_header_status == HTTP_HEADER_LINE1)
     {
       if  (request->status.header_line_status == AFTER_CR_LF)
	 {
	   parse_http_header_line1(request, &no_http_version) ; 
	   if (no_http_version)
	     {
	       request->status.beginning_of_header_fields = NULL ; 
	       request->status.process_status = HTTP_HEADER_DONE ; 
	       return ; 
	     }
	   else
	     {
	       request->status.beginning_of_header_fields =
		 request->status.header_data + 
                      request->status.nof_chars_in_header + 1 ; 
	       request->status.http_header_status= HTTP_HEADER_ADDITIONAL_INFO;
	       request->status.header_line_status =  IN_LINE ; 
	     }
	 } /*** end if we just finished line 1 **********/
     } /** end of if we are in line 1 ***/
   else /** request->status.http_header_status is HTTP_HEADER_ADDITIONAL_INFO*/
     {
       if (request->status.header_line_status == AFTER_CR_LF_CR_LF)
	 {
	   parse_http_header_header_fields( request) ; 
	   request->status.process_status = HTTP_HEADER_DONE ; 
	   return ; 
	 }	   
     }
    
 } /** for loop over all incoming chars *****/

}





void do_response_initialization(Request_t *request )
{
if (request->response_initialization_function != NULL)
  {
    request->response_initialization_function(request) ;
  }
else
  {
    request->status.process_status =IN_SEND_RESPONSE_HEADER ; 
  } 


}


void process_request( Request_t *request )
{
	BYTE processed = FALSE;
if ( (request->status.process_status == WEB_PROCESSING_DONE ) ||
    (request->status.process_status ==  HTTP_HEADER )  )
  {
	HTTP_TRACE_MSG("trace", "process status == WEB_PROCESSING_DONE or HTTP_HEADER") ; 
    process_http_header( request ) ; 
#ifdef  BLOCKING_IO_ONLY
    while (request->status.process_status !=  HTTP_HEADER_DONE)
      {
	process_http_header( request ) ; 
      }
#endif
	processed = TRUE;
  }

if (request->status.process_status ==  HTTP_HEADER_DONE )
  {
	HTTP_TRACE_MSG("trace", "process status == HTTP_HEADER_DONE") ; 
    dispatch_www_handler(request ) ; 
	 processed = TRUE;
  }



if (request->status.process_status == IN_FORM_PROCESSING )
  {
	HTTP_TRACE_MSG("trace", "process status == IN_FORM_PROCESSING") ; 
    do_form_processing_phase (request ) ; 
#ifdef  BLOCKING_IO_ONLY
    while (request->status.process_status == IN_FORM_PROCESSING )
      {
	 do_form_processing_phase( request ) ; 
      }
#endif
	processed = TRUE;
  }




if (request->status.process_status ==  IN_RESPONSE_INITIALIZATION)
  {
	HTTP_TRACE_MSG("trace", "process status == IN_RESPONSE_INITIALIZATION") ; 
    do_response_initialization (request ) ; 
#ifdef  BLOCKING_IO_ONLY
    while (request->status.process_status == IN_RESPONSE_INITIALIZATION )
      {
	 do_response_initialization( request ) ; 
      }
#endif
	processed = TRUE;
  }


if (request->status.process_status == IN_SEND_RESPONSE_HEADER)
  {
	HTTP_TRACE_MSG("trace", "process status == IN_SEND_RESPONSE_HEADER") ; 
    process_response_header(request) ; 
#ifdef  BLOCKING_IO_ONLY
    while (request->status.process_status == IN_SEND_RESPONSE_HEADER)
      {
	process_response_header(request) ; 
      }
#endif
	processed = TRUE;
   }


if (request->status.process_status ==  WEB_PROCESSING )
  {
	HTTP_TRACE_MSG("trace", "process status == WEB_PROCESSING") ; 
    do_web_processing(request ) ; 
#ifdef  BLOCKING_IO_ONLY
    while ( (request->status.process_status !=  WEB_PROCESSING_DONE) &&
	    (request->status.process_status !=  SOCKET_IS_CLOSED) )
      {
	 do_web_processing( request ) ; 
      }
#endif
	processed = TRUE;
  }
 	if (processed == FALSE)
	{
		printf("Control came to right place\n");
/*		cm_deinitialize_configuration_manager(CM_OWNED_BY_HTTP);*/
	}
	 	
}


void process_requests( RequestList_t *request_list, 
		      WWWRequestDispatcher_t *web_dispatcher ) 
{

RequestNode_t *current_node, *next_node ; 

for(current_node = request_list->first ; 
    current_node != NULL ; 
    )
  {
/*  	 printf("Processing Request on a Socket\n");*/
    process_request(&current_node->request ) ; 

    next_node = current_node->next ; 

    if (current_node->request.status.process_status == SOCKET_IS_CLOSED)
      {
	HTTP_TRACE_MSG("trace", "SOCKET_IS_CLOSED") ; 
	delete_request( current_node, request_list) ; 
      }
	HTTP_TRACE("trace", sprintf( tmp_trace, "on to next node (%8.8lX)", next_node ) ) ; 
    current_node = next_node ; 

  }

}







