/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef REQLIST_H
#define REQLIST_H

#define MAX_HEADER_SIZE 4096 
#define MAX_URI_SIZE 1024 
#define MAX_VERSION_SIZE 16


#include "..\..\prochttp\src\authoriz.h"

enum { NO_CONTENT_LENGTH  = -1 } ; 

typedef struct {
  enum { GET_METHOD , HEAD_METHOD , PUT_METHOD , POST_METHOD, 
	 DELETE_METHOD , LINK_METHOD , UNLINK_METHOD, UNKOWN_METHOD } method ; 
  char *uri; 
  int uri_length ; 
  int pos_uri_processing ; 
  char *http_version; 
  int http_version_length ; 
  HttpDate_t if_modified_since ; 
  AuthorizationInformation_t authorization ; 
  int content_length ; 
  enum {  NO_CONTENT_TYPE , CONTENT_TYPE_URL_ENCODE,
         CONTENT_TYPE_MULTIPART_FORM } content_type ; 
  char *boundary ;      /*** Used if content type id multipart/fordata ****/
  int boundary_length ; /***** Seprating between parts ********************/
} RequestParams_t ; 



typedef struct {
  enum { HTTP_HEADER , 
	 HTTP_HEADER_DONE, 
	 IN_FORM_PROCESSING, 
	 IN_RESPONSE_INITIALIZATION, 
	 IN_SEND_RESPONSE_HEADER, 
         WEB_PROCESSING, 
         WEB_PROCESSING_DONE, 
         SOCKET_IS_CLOSED } process_status ; 
  enum { HTTP_HEADER_LINE1, HTTP_HEADER_ADDITIONAL_INFO } 
           http_header_status ; 
  enum { IN_LINE , AFTER_CR, AFTER_CR_LF, AFTER_CR_LF_CR, AFTER_CR_LF_CR_LF } 
                        header_line_status ; 
  char header_data[MAX_HEADER_SIZE] ; 
  char *beginning_of_header_fields ; 
  int nof_chars_in_header ; 
  int total_bytes_read_for_header; /*** including maybe bytes belongin to
                                  ***** POST information added after header
                                  ****/
} RequestStatus_t ; 

#define MAX_CHARS_FOR_DATE_TEXT 50 

#include "..\..\prochttp\src\conttype.h"



typedef  enum { STATUS_OK, FORBIDDEN, NOT_AUTHORIZED, NOT_CHANGED, NOT_FOUND }
 HttpStatusType_t ; 

#define HTTP_NO_REFRESH -1
#define MAX_REFRESH_URL 200 

typedef struct {
  HttpStatusType_t status ; 
  int content_length ; /** if NO_CONTENT_LENGTH then invalid ***/
  char string_content_length[10] ; 
  HttpContentType_t content_type ; 
  char *chalange ; /** authorization chalange, in case of NOT_AUTHORIZED
                   *** status  ****/
  HttpDate_t last_modified ; 
  char last_modified_text[MAX_CHARS_FOR_DATE_TEXT] ; 
  char current_date_text[MAX_CHARS_FOR_DATE_TEXT]  ; 
  char *additional_fields_info ; 
  int refresh ; /*** for client pull. equals to NO_REFRESH if not **/
  char refresh_text[8];
  char refresh_url[MAX_REFRESH_URL] ; 
  int was_sent ; 
} ResponseHeaderInformation_t ; 

typedef struct _Request_t {
  RequestStatus_t status ; 
  RequestParams_t params ; 
  Socket_t socket ; 
  struct sockaddr_in client_address ; 
  void  (*response_initialization_function)(struct _Request_t *) ; 
  ResponseHeaderInformation_t header_info ; 
  struct _DataTransferStatus_t *response_header_status ; 
  int response_entity_exists ; 
  void  (*response_entity_function)(struct _Request_t *) ; 
  void *response_entity_handle ; 
  int close_socket_after_entity ; 
  struct _FormProsseingPhaseData_t *form_phase ; 
} Request_t ; 

typedef struct _RequestNode_t  {
  Request_t request ; 
  struct _RequestNode_t *next, *prev; 
} RequestNode_t ; 


typedef struct {
  RequestNode_t *first, *last ; 
} RequestList_t ; 


void init_requests_memory_management(void); 

void init_request_list(RequestList_t *request_list ) ; 


void add_new_request(RequestList_t *request_list, Socket_t *new_socket, 
		     struct sockaddr_in *client_address, 
		     int client_address_length);


void delete_request(RequestNode_t *request_node,
		    RequestList_t *request_list ); 


#endif /*** REQLIST_H **/





