/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "httpd.h"
#include "reqlist.h"
#include "util.h"
#include "datatran.h"



#include "uridata.h"
#include "..\..\htmlform\src\formpars.h"

#include "formphas.h"

void do_uri_parsing(Request_t *request, UriParseDictionary_t *dict);


void use_parse_result( Request_t *request, ParseResults_t *parse_results ) 
{
switch(parse_results->segment_type) {
 case  CONTINUE_PARSING: {
   do_uri_parsing(request, 
		  ( UriParseDictionary_t *)parse_results->next_dictionary ) ;
   break ; 
 }
 case  ATTACH_PROCESS_FUNCTION: {
   request->response_initialization_function = 
                                 parse_results->initialization_function ; 
   request->status.process_status =  IN_RESPONSE_INITIALIZATION ; 
   request->form_phase = NULL ; 
   break ; 
 }
 case  PROCESS_FORM: {
   request->response_initialization_function = 
                                 parse_results->initialization_function ; 
   
   request->status.process_status =  IN_FORM_PROCESSING  ; 
   init_form_variables(request,  parse_results->form_description_struct,
		       parse_results->upload_function ) ; 
   break ; 
 }
 }
}

#define MAX_SEGMENT_LENGTH 100

void do_uri_parsing(Request_t *request, UriParseDictionary_t *dict)
{
char *beginning_of_segment ; 
int word_length ; 
int remaining_chars ; 
int word_index ; 

char segment_buffer[MAX_SEGMENT_LENGTH];
char *temp_beginning_of_segment ; 
char *temp_segment_out ; 

beginning_of_segment = request->params.uri + 
                                 request->params.pos_uri_processing ; 

remaining_chars =  request->params.uri_length - 
                                  request->params.pos_uri_processing ; 
word_length = 0 ; 
while ((word_length < remaining_chars) &&
       (beginning_of_segment[word_length] != '?') &&
       (beginning_of_segment[word_length] != '#') &&
       (beginning_of_segment[word_length] != '/') )
  {
    word_length++ ; 
  }




temp_beginning_of_segment = beginning_of_segment;
temp_segment_out = segment_buffer ; 

if (request->params.uri_length != 1) 	/* this is to get the index for */
{													/* the root page when only address */
													/* is specified. 
														Eg: ras.multitech.com instead of
															ras.multitech.com/main1	*/
	copy_field( &temp_beginning_of_segment,
		   beginning_of_segment + word_length, 
	   	&temp_segment_out, 
		   temp_segment_out + MAX_SEGMENT_LENGTH , 
		   '/' ) ; 



	word_index = find_word_case_sensitive(segment_buffer ,  
				   temp_segment_out - segment_buffer - 1 ,  
				   dict->segment_name_dictionary  ); 

	if (word_length < remaining_chars)
  	{
   	 request->params.pos_uri_processing += (word_length + 1) ; 
	}	
}
else
	word_index = 0;

HTTP_TRACE("uri parse", sprintf(tmp_trace, " found %s \n", 
   (word_index!=-1)? dict->segment_name_dictionary->words[word_index].word:
                     "NOT FOUND") ) ; 
                                   


if (word_index == -1)
  {
    use_parse_result( request, dict->default_to_do ) ; 
  }
else
  {
    use_parse_result( request, &dict->what_to_do_on_segment[word_index] ) ; 
  }
}


void dispatch_www_handler(Request_t *request )
{


HTTP_TRACE_MSG("dispatch", "in dispatch_www_handler") ; 
HTTP_TRACE("dispatch", sprintf( tmp_trace, "request = %8.8lX", request ));

/*** set the defaults *******/
HTTP_TRACE_MSG("dispatch", "1") ; 
request->close_socket_after_entity = TRUE ; 
HTTP_TRACE_MSG("dispatch", "2") ; 
request->response_header_status = malloc(sizeof(DataTransferStatus_t) );
HTTP_TRACE_MSG("dispatch", "3") ; 

HTTP_TRACE_MSG("dispatch", "before call to InitDataTransferStatus") ; 
InitDataTransferStatus(request->response_header_status); 
HTTP_TRACE_MSG("dispatch", "after call to InitDataTransferStatus") ; 

request->response_header_status->nof_operations = 2 ; 

HTTP_TRACE_MSG("dispatch", "before call to InitNonBlockingOutput") ; 
InitNonBlockingOutput(request,
		      &request->response_header_status->io_operations[1]);
HTTP_TRACE_MSG("dispatch", "after call to InitNonBlockingOutput") ; 

request->response_header_status->end_of_processing = FALSE ;
request->response_header_status->socket_should_be_closed = FALSE ;


request->params.pos_uri_processing = 1 ; /** for the / ****/

request->header_info.status = STATUS_OK ; 
request->header_info.content_length = NO_CONTENT_LENGTH ; 
request->header_info.chalange = NULL ; 
request->header_info.additional_fields_info = NULL ; 
request->header_info.refresh =  HTTP_NO_REFRESH ; 
request->header_info.refresh_url[0] = 0 ; 
request->header_info.was_sent = FALSE ; 

HTTP_TRACE_MSG("dispatch", "before call to set_null_date") ; 
set_null_date(&request->header_info.last_modified) ; 
HTTP_TRACE_MSG("dispatch", "after call to set_null_date") ; 

HTTP_TRACE_MSG("dispatch", "before call to do_uri_parsing") ; 
do_uri_parsing( request, root_dispatch_ptr  );
HTTP_TRACE_MSG("dispatch", "after call to do_uri_parsing") ; 

HTTP_TRACE_MSG("dispatch", "before call to InitHeaderInput") ; 
InitHeaderInput(&request->header_info, 
		&request->response_header_status->io_operations[0] ) ; 
HTTP_TRACE_MSG("dispatch", "after call to do_uri_parsing") ; 
		

if ( request->form_phase != NULL )
  {
HTTP_TRACE_MSG("dispatch", "before call to init_form_processing") ; 
    init_form_processing_phase(request) ; 
HTTP_TRACE_MSG("dispatch", "after call to init_form_processing") ; 
  }

HTTP_TRACE_MSG("dispatch", "exiting dispatch_www_handler") ; 
}



