/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef UTIL_H
#define UTIL_H

#include "..\..\prochttp\src\httpd.h"

#include "..\..\sysdep\src\syslib.h"




typedef struct {
  char *word ; 
  int length ; 
  int index ; 
} Word_t ; 

typedef struct {
  Word_t *words ; 
  int nof_words ; 
} WordList_t ; 


#define NOT_FOUND_IN_WORD_LIST -1 

int find_word_case_insensitive(char *word, int word_length ,  
			   WordList_t *word_list  ) ; 

int find_word_case_sensitive(char *word, int word_length ,  
			   WordList_t *word_list  );


void get_next_word(char **p , int *length, char *end_of_buf)  ; 
/**** on input p points to a buffer, on output it will point to the next word
***** and length will be the length of the word. word is defined as anything 
***** between whitespace. if \n \r or 0 are found a word length of 
***** 0 is returned.
****/

void copy_date_struct(HttpDate_t *source, HttpDate_t *dest);

void set_null_date(HttpDate_t * ) ; 

int test_if_date_is_null(HttpDate_t *date);


void wait_time(int time_in_ms) ; 


void local_date_to_GMT_text(HttpDate_t *date,
			  char *text_buffer);

#ifdef UNIX_EMULATION
#include <time.h>
void  convert_time_t_to_http_date(time_t *time ,
				  HttpDate_t *http_date );
#endif

void get_current_date(HttpDate_t *date);


void parse_http_date(char *date_string, HttpDate_t *date );

void convert_timedate_to_GMT_timedate(HttpDate_t *date, 
				     HttpDate_t *gmt_date );

int compare_dates(HttpDate_t *date1 , HttpDate_t *date2  );
/**** returns true if date1 is later than date 2 ****/



void parse_mime_header_type_line( char *buffer , 
				  int   buffer_length , 
				  char **field_name, 
                                  int *field_name_length , 
                                  char **field_value, 
                                  int *field_value_length , 
                                  int max_nof_attribtues_value_pairs,
                                  char **attributes, 
                                  int *attributes_length, 
                                  char **values, 
                                  int *values_length, 
                                  int *nof_attribtues_value_pairs );
/***** parse a line of the form:
        Content-type: multipart/form-data;boundary=xxxxxx
    or
        Content-type: multipart/form-data;boundary="xxxxxx"
***************/









#endif /******** UTIL_H *******/








