/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#ifdef  SPECIAL_CST


#include "httpd.h"

int socket(
	int domain, 
	int type,
	int protocol,
	sohandle *sockp ) 
{
return socket_SYSCALL(domain, type, protocol, sockp ) ; 
}

 
int bind(
	sohandle sock,
	caddr_t name,
	int namelen)
{
return bind_SYSCALL(sock, name, namelen ) ; 
} 

int listen(
	sohandle sock,
	int backlog)
{
return listen_SYSCALL(sock, backlog) ; 
} 

int accept(
	sohandle sock,				/* socket to accept on */
	caddr_t name,
	int *anamelen,
	sohandle *asockp,			/* accepted socket */
	struct timeval *timeo)
{
return accept_SYSCALL(sock, name, anamelen, asockp, timeo ) ; 
}

int send(
	sohandle sock,
	caddr_t buf,
	int len,
	int flags,
	int *actual)
{
return send_SYSCALL(sock, buf, len, flags, actual ) ; 
}

int recv(
	sohandle sock,
	caddr_t buf,
	int len,
	int flags,
	int *actual)
{
return recv_SYSCALL(sock, buf, len, flags, actual ) ; 
} 

int shutdown(
	sohandle sock,
	int how)
{
return shutdown_SYSCALL(sock, how) ; 
}

int setsockopt(
	sohandle sock,
	int level,
	int name,
	caddr_t val,
	int valsize)
{
return setsockopt_SYSCALL(sock, level , name, val, valsize ) ; 
}


#endif
