/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef TCPRW_H
#define TCPRW_H

#include "..\..\sysdep\src\tcpinter.h"

void read_available_data_from_socket(Socket_t socket , 
				    void *buffer , 
				    int max_bytes_to_read, 
				    int *nof_bytes_actually_read , 
				    int *client_closed_the_socket,
				    int *error); 

/***** Does a non-blocking read *********/

void read_data_from_socket(Socket_t socket , 
				    void *buffer , 
				    int max_bytes_to_read, 
				    int *nof_bytes_actually_read , 
				    int *client_closed_the_socket,
				    int *error);
/***** Does a blocking read *********/



void read_data_from_socket_until_delimiter(Socket_t socket , 
				    void *buffer , 
				    int max_bytes_to_read, 
				    int *nof_bytes_actually_read , 
				    int *client_closed_the_socket,
				    int *error , 
				    char delimiter ); 
/** used when only blocking IO is available ********/




void initialize_new_server_socket(
	    Socket_t *server_socket, 
	    Port_t port_address, 
	    int backlog, 
	    int *error );


void accept_new_connection(Socket_t server_socket , 
			   Socket_t *new_client_socket, 
			   int *new_client_was_found,
			   struct sockaddr_in *client_address,
			   int *addr_length );


void write_data_to_socket(Socket_t *socket, 
			  void *data, 
			  int length, 
			  int *nof_bytes_written, 
			  int *client_closed_the_socket,
			  int *error);

void shutdown_socket(Socket_t *socket);

#endif /*** TCPRW_H ******/
