#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
#include "\rtrware\store\boot.h"
/* ... Naveen.P.N.*/
#include "incall.h"
#include "cfgmgr.h"
#include <flashmgr.h>
#include "\rtrware\stacks\ip\kdns.h"
#include "\rtrware\stacks\ip\vdnsstr.h"

#define CM_MAXIMUM_NUMBER_OF_PORTS 10
#define STRING_LENGTH_FOR_GET 	  200
#define CM_NUMBER_OF_VIRTUAL_IPX_PORTS 4

/* Local Prototype ... */
void enable_either_ppp_or_slip();
enum CM_GET_RESULTS get_parameter(enum CM_SECTIONS section_to_which_it_belongs_to, void* vptr_parameter_ID,
											 USHORT port_number, enum CM_RETURN_TYPE expected_format_of_return_value, 
						 					 void* vptr_return_value, USHORT string_length);

enum CM_GET_RESULTS get_parameter_by_name(enum CM_SECTIONS section_to_which_it_belongs_to, BYTE* bptr_lhs_string,
											 			USHORT port_number, enum CM_RETURN_TYPE expected_format_of_return_value, 
						 					 			void* vptr_return_value, USHORT string_length);

BYTE get_the_section_number(enum CM_SECTIONS section);
BYTE* get_lhs_string(ULONG offset, CONFIGURATION_TABLE* configuration_table, BYTE* lhs_para_str);
PARAMETER_NODE* match_the_lhs_string_in_the_linked_list_and_return_rhs_string(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* rhs_string, USHORT port_number, BYTE* port_number_matched);
PARAMETER_NODE* match_the_lhs_string_in_the_linked_list_and_return_rhs_string(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* rhs_string, USHORT port_number, BYTE* port_number_matched);
void convert_to_lower_case(BYTE* the_string);
BYTE is_valid_string_to_read_data(BYTE* buffer);
enum CM_SET_RESULTS set_parameter(enum CM_SECTIONS section_to_which_it_belongs_to, void* vptr_parameter_ID,
								 					 USHORT port_number, USHORT format_got,
								 					 void* vptr_new_value);
enum CM_SET_RESULTS set_parameter_by_name(enum CM_SECTIONS section_to_which_it_belongs_to, 
														BYTE* bptr_lhs_string,
								 					   USHORT port_number, USHORT format_got,
								 					 	void* vptr_new_value);
BYTE check_whether_value_is_with_in_limits(USHORT lower_limit, ULONG upper_limit, ULONG value);
enum CM_WRITE_RESULTS cm_write_configuration();
int cm_flash_write_block(BYTE *, BYTE *, int, enum BOOLEAN) ;
void cm_start_flash_write(PARAMETER_NODE* sptr_list);
void cm_last_setup_block_written();
int cm_flash_write_block(BYTE *bptr_src, BYTE *bptr_dest, int length, enum BOOLEAN last_block);
void cm_wait_for_flash_write_completion ();
PARAMETER_NODE* insert_missing_string_without_port(BYTE section_number, BYTE* lhs_string, BYTE* rhs_string);
PARAMETER_NODE* insert_missing_string_with_port(BYTE section_number, BYTE port_number, BYTE* lhs_string, BYTE* rhs_string);
PARAMETER_NODE* get_authentication_method(PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, USHORT port_number, BYTE* port_number_matched, BYTE* authentication_type, BYTE is_local_required);
PARAMETER_NODE* set_authentication_method(PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, USHORT port_number, BYTE* port_number_matched, BYTE authentication_type);
void remove_ppp_authentication_strings(BYTE port_number);
void form_a_pap_only_local_string(BYTE* buffer, BYTE port_number);
void form_a_chap_only_local_string(BYTE* buffer, BYTE port_number);
void form_a_pap_and_chap_local_string(BYTE* buffer, BYTE port_number);
void form_a_pap_only_remote_string(BYTE* buffer, BYTE port_number);
void form_a_chap_only_remote_string(BYTE* buffer, BYTE port_number);
void form_a_pap_and_chap_remote_string(BYTE* buffer, BYTE port_number);
BYTE get_string_until_delimiter(BYTE search_to_start_at, BYTE delimiter, BYTE* src_string, BYTE* dest_string);
PARAMETER_NODE* creat_new_node_at_the_end_of_section(USHORT section_number, PARAMETER_NODE* new_node);
void fill_static_route_struct_from_buffer(STRUCT_STATIC_ROUTE* static_route, BYTE* buffer);
void resolve_port_wan_speed(BYTE port_number, void* vptr_new_value);
void resolve_ipx_autolearn(void* vptr_new_value, USHORT format_got);
void resolve_port_ipx_network_number(USHORT port_number, void* vptr_new_value);
void resolve_port_ip_address(USHORT port_number, USHORT format_got, void* vptr_new_value);
void	resolve_port_remote_ip_addres(USHORT port_number, void* vptr_new_value);
void modify_ppp_string(BYTE* string1, BYTE port_number, BYTE* string2, BYTE* string3, BYTE* new_string);
PARAMETER_NODE* get_ppp_string(BYTE* string1, BYTE port_number, BYTE* string2, BYTE* string3);
void resolve_dial_on_demand(BYTE port_number);
BYTE is_mlppp_enabled();
void insert_mlppp_strings();
void remove_mlppp_strings();
void remove_ppp_string(USHORT port_number);

/* sudha 19 Jan 1999 */
enum TEST_RESULT is_user_defined_port_range_unique(USHORT lower_port,USHORT higher_port,USHORT protocol);

USHORT get_next_application_port_which_needs_re_entry(USHORT first_port_number);
BYTE is_re_entry_needed_for_application_port(USHORT port_number);

void set_ftp_port_numbers_in_global_structure(BYTE ftp_ctrl, USHORT ftp_prev_port_number);
BOOL IsStrNumericAndValid(char *Str);
void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port);
BYTE *get_physical_port(USHORT port_number);

extern USHORT get_port_index (USHORT protocol_type, USHORT protocol_port_number);
extern void set_protocol_port_number (USHORT protocol_type, USHORT port_number, USHORT application_index);

void dummy_fn();
/* ... Local Prototype */

extern DNS_CLASS dns;
extern USHORT update_crc (USHORT, BYTE *, ULONG) ;
extern int schedule_flash_write (char *src_ptr, char *dest_ptr, unsigned short block_length,void (*fptr_block_write_complete)(), char *buffer_to_free) ;
extern reset();
extern BYTE* DownloadFlag;
extern BYTE* process_back_slash(BYTE* string);
extern update_the_number_of_filters_present();
extern void encrypt (char *src, char *dest) ;
extern BYTE *to_upper_string (BYTE*);
extern void cm_convert_tag_list_to_cnf_format(PARAMETER_NODE* sptr_last_node);
extern USHORT get_insecured_lan_port_number();
extern BYTE is_an_gateway_address(BYTE* address);
extern USHORT get_wan_port_number();

/*------------------------------------------------------------------------*/
/*                                 GLOBALS                                */

BYTE vjc_string[] = "IPCP,Compression,2,Auto,Negotiation Not Required,Negotiable,H4,002D0F00";

/*--------------------------------------------------------------------------*/
enum CM_GET_RESULTS get_parameter(enum CM_SECTIONS section_to_which_it_belongs_to, void* vptr_parameter_ID,
											 USHORT port_number, enum CM_RETURN_TYPE expected_format_of_return_value, 
						 					 void* vptr_return_value, USHORT string_length)
{
 	BYTE lhs_string[200], section_number, *string_ptr, i, *temp_string, port_number_matched;
	UNION_RETURN_VALUE*  uptr_return_value;
	PARAMETER_NODE* search_to_start_at, *node;
	ULONG offset;
   BYTE temp_buffer[200], number_of_ports;

   number_of_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS) + lsl_control(GET_NUMBER_OF_LAN_PORTS);
	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return ;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return ;
	}	 
	uptr_return_value = (UNION_RETURN_VALUE*)vptr_return_value;
   if (expected_format_of_return_value == CM_STRING_FORMAT)
	   string_ptr = uptr_return_value->string;
   else
      string_ptr = temp_buffer;


	/* Get the section to which this field belongs to and find the lhs string */
	section_number = get_the_section_number(section_to_which_it_belongs_to);
	offset = (BYTE*)vptr_parameter_ID - array_of_ptrs_to_global_class_structres[section_number];

   if (vptr_parameter_ID == (void*)&vjc.port[0].vjc_compression_enabled && section_to_which_it_belongs_to == CM_VJC_SECTION)
   {
      node = get_ppp_string("PPP Port Option", port_number, "IPCP", "Compression");
      if (node)
      {
			switch(expected_format_of_return_value)
			{
				case CM_STRING_FORMAT:
					strcpy(string_ptr, "enabled");
					return CM_GET_SUCCESSFUL;	
				case CM_INDEX_FORMAT:
					uptr_return_value->byte_value = 1;
					return CM_GET_SUCCESSFUL;	
				default:
					return CM_GET_SUCCESSFUL;	
			}
      }
      else
      {
			switch(expected_format_of_return_value)
			{
				case CM_STRING_FORMAT:
					strcpy(string_ptr, "disabled");
					return CM_GET_SUCCESSFUL;	
				case CM_INDEX_FORMAT:
					uptr_return_value->byte_value = 0;
					return CM_GET_SUCCESSFUL;	
				default:
					return CM_GET_SUCCESSFUL;	
			}
      }
   }

	temp_string = get_lhs_string(offset, sptr_to_configuration_table[section_number], lhs_string);
	if(lhs_string == NULL)
	{
		return CM_LHS_STRING_NOT_FOUND_WHILE_GET;
	}
	search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
	/* if the section is not the last section */
	if (section_number == CM_NUMBER_OF_SECTIONS - 1)
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
	   if (port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
		}
		else
		{
			for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
				if (search_to_start_at == NULL)
					return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
		}
	}
	else
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
		if(port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
		}
		else
		{
			for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
				if (search_to_start_at == NULL)
					return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
		}
	}
	if(string_ptr == NULL)
	{
		printf("String %s not found in configuration \n", lhs_string);
		return CM_RHS_STRING_NOT_FOUND_WHILE_GET;
	}

	/* Formatting for Some string like modem name etc ... */
	if (section_to_which_it_belongs_to == CM_WAN_SECTION && vptr_parameter_ID == (void*)&wan.port[0].modem_info.strings.modem_type)
	{
		process_back_slash(string_ptr);
	}
	/* ... Formatting for Some string like modem name etc */

	switch(expected_format_of_return_value)
	{
	  case CM_STRING_FORMAT:
		  	return CM_GET_SUCCESSFUL;
	  case CM_USHORT_FORMAT:
	  		if(!is_valid_string_to_read_data(string_ptr))
			{
				printf("NonNumeric Data found for %s\n", lhs_string);
				return CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA;
			}
	  		sscanf(string_ptr,"%6d",&(uptr_return_value->ushort_value));
	  		return CM_GET_SUCCESSFUL;
	  case CM_ULONG_FORMAT:
	  		if(!is_valid_string_to_read_data(string_ptr))
			{
				printf("NonNumeric Data found for %s\n", lhs_string);
				return CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA;
			}
	  		sscanf(string_ptr, "%9d", &(uptr_return_value->ulong_value));
	  		return CM_GET_SUCCESSFUL;
	  case CM_BYTE_FORMAT:
	  		if(!is_valid_string_to_read_data(string_ptr))
			{
				printf("NonNumeric Data found for %s\n", lhs_string);
				return CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA;
			}
	  		sscanf(string_ptr, "%3d", &(uptr_return_value->byte_value));
         return CM_GET_SUCCESSFUL;
     case CM_INDEX_FORMAT:
		  	convert_to_lower_case(string_ptr);
			if (!strcmpi(string_ptr, "enabled"))
         {
				uptr_return_value->byte_value = 1;
         }
			else
			if (!strcmpi(string_ptr, "disabled"))
         {
				uptr_return_value->byte_value  = 0;
         }
#if 0 /* Not Required for Proxy Server */
			else
			if ((offset == array_of_offset_and_section_type[0].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[0].section_type))
			{
				/*Then this is Spanning Tree State Field*/
				if(!strcmpi(string_ptr, "disable"))
				{
					uptr_return_value->byte_value = 0;
				}
				else
				if(!strcmpi(string_ptr, "listening"))
				{
					uptr_return_value->byte_value = 1;
				}
				else
				if(!strcmpi(string_ptr, "learning"))
				{
					uptr_return_value->byte_value = 2;
				}
				else
				if(!strcmpi(string_ptr, "blocking"))
				{
					uptr_return_value->byte_value = 3;
				}
				else
				if(!strcmpi(string_ptr, "forwarding"))
				{
					uptr_return_value->byte_value = 4;
				}
				else
				{
					printf("Spanning Tree Port State value does not match with standard value, setting it to disabled\n");
					uptr_return_value->byte_value = 0;
				}
			}
#endif /* Not Required for Proxy Server */
			else
			if((offset == array_of_offset_and_section_type[2].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[2].section_type))
			{
				/*Then this is WAN Port ClockSpeed*/
				if(!strcmpi(string_ptr, "4800"))
					uptr_return_value->byte_value = 0;
				else
				if(!strcmpi(string_ptr, "9600"))
					uptr_return_value->byte_value = 1;
				else
				if(!strcmpi(string_ptr, "19200"))
					uptr_return_value->byte_value = 2;
				else
				if(!strcmpi(string_ptr, "38400"))
					uptr_return_value->byte_value = 3;
				else
				if(!strcmpi(string_ptr, "57600"))
					uptr_return_value->byte_value = 4;
				else
				if(!strcmpi(string_ptr, "64000"))
					uptr_return_value->byte_value = 5;
				else
				if(!strcmpi(string_ptr, "128000"))
					uptr_return_value->byte_value = 6;
				else
				if(!strcmpi(string_ptr, "256000"))
					uptr_return_value->byte_value = 7;
				else
				if(!strcmpi(string_ptr, "512000"))
					uptr_return_value->byte_value = 8;
				else
				if(!strcmpi(string_ptr, "1024000"))
					uptr_return_value->byte_value = 9;
				else
				if(!strcmpi(string_ptr, "1536000"))
					uptr_return_value->byte_value = 10;
				else
				if(!strcmpi(string_ptr, "2048000"))
					uptr_return_value->byte_value = 11;
				else
				{
					printf("WAN Clock Speed did not match! setting it to 64000\n");
					uptr_return_value->byte_value = 5;
				}
			}
			else
			if((offset == array_of_offset_and_section_type[1].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[1].section_type))
			{															  
				/*Then this is WAN Port BaudRate*/
				if(!strcmpi(string_ptr, "300"))
					uptr_return_value->byte_value = 0;
				else
				if(!strcmpi(string_ptr, "600"))
					uptr_return_value->byte_value = 1;
				else
				if(!strcmpi(string_ptr, "1200"))
					uptr_return_value->byte_value = 2;
				else
				if(!strcmpi(string_ptr, "2400"))
					uptr_return_value->byte_value = 3;
				else
				if(!strcmpi(string_ptr, "4800"))
					uptr_return_value->byte_value = 4;
				else
				if(!strcmpi(string_ptr, "9600"))
					uptr_return_value->byte_value = 5;
				else
				if(!strcmpi(string_ptr, "19200"))
					uptr_return_value->byte_value = 6;
				else
				if(!strcmpi(string_ptr, "38400"))
					uptr_return_value->byte_value = 7;
				else
				if(!strcmpi(string_ptr, "57600"))
					uptr_return_value->byte_value = 8;
				else
				if(!strcmpi(string_ptr, "115200"))
					uptr_return_value->byte_value = 9;
				else
				if(!strcmpi(string_ptr, "230400"))
					uptr_return_value->byte_value = 10;
				else
				if(!strcmpi(string_ptr, "460800"))
					uptr_return_value->byte_value = 11;
				else
				{
					printf("WAN Baud Rate did not match! setting it to 19200\n");
					uptr_return_value->byte_value = 6;
				}
			}
			else
			if((offset == array_of_offset_and_section_type[3].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[3].section_type))
			{
				if (!strcmpi(string_ptr, "type_ii"))
					uptr_return_value->byte_value = 0;
				else
				if (!strcmpi(string_ptr, "snap"))
					uptr_return_value->byte_value = 1;
				else
				{
					printf("IP Frame Type did not match! setting to TYPE_II");
					uptr_return_value->byte_value = 0;
				}
			}
			else
			{
/*				printf("ATTENTION: INDEX_FORMAT required but there is no match for the string %s <--> %s\n", lhs_string, string_ptr);*/
/*				return ;
	 			uptr_return_value->byte_value = ;*/
			}
			return(CM_GET_SUCCESSFUL);
	  default:
	  	printf("Return type unknown. Returning string\n");
		return(CM_GET_SUCCESSFUL);
	}
}

enum CM_GET_RESULTS get_parameter_by_name(enum CM_SECTIONS section_to_which_it_belongs_to, BYTE* bptr_lhs_string,
											 			USHORT port_number, enum CM_RETURN_TYPE expected_format_of_return_value, 
						 					 			void* vptr_return_value, USHORT string_length)
{
 	BYTE section_number, *string_ptr, i, port_number_matched;
	UNION_RETURN_VALUE*  uptr_return_value;
	PARAMETER_NODE* search_to_start_at;
   BYTE temp_buffer[200], number_of_ports, mlppp_enabled;
	BYTE authentication_type ;
   number_of_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS) + lsl_control(GET_NUMBER_OF_LAN_PORTS);

	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return ;
	}

	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return ;
	}	 

   uptr_return_value = (UNION_RETURN_VALUE*)vptr_return_value;
   if (expected_format_of_return_value == CM_STRING_FORMAT)
	   string_ptr = uptr_return_value->string;
   else
      string_ptr = temp_buffer;

	/* Get the section to which this field belongs to and find the lhs string */
	section_number = get_the_section_number(section_to_which_it_belongs_to);
   if (!strcmpi(bptr_lhs_string, "MLPPP"))
   {
      mlppp_enabled = is_mlppp_enabled();
      if (expected_format_of_return_value == CM_STRING_FORMAT)
         strcpy(string_ptr, mlppp_enabled?"enabled":"disabled");
      else
			uptr_return_value->byte_value = mlppp_enabled;
      return CM_GET_SUCCESSFUL;
   }

	if (!strcmpi(bptr_lhs_string, "PAP"))
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
		search_to_start_at = get_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1],port_number, &port_number_matched, &authentication_type, 1);
		if (search_to_start_at && port_number_matched && (authentication_type == CM_ONLY_PAP_ENABLED || authentication_type == CM_BOTH_PAP_AND_CHAP_ENABLED))
		{	
			switch(expected_format_of_return_value)
			{
				case CM_STRING_FORMAT:
					strcpy(string_ptr, "enabled");
					return CM_GET_SUCCESSFUL;	
				case CM_INDEX_FORMAT:
					uptr_return_value->byte_value = 1;
					return CM_GET_SUCCESSFUL;	
				default:
					break;
			}
		}
		else
		{
			switch(expected_format_of_return_value)
			{
				case CM_STRING_FORMAT:
					strcpy(string_ptr, "disabled");
					return CM_GET_SUCCESSFUL;	
				case CM_INDEX_FORMAT:
					uptr_return_value->byte_value = 0;
					return CM_GET_SUCCESSFUL;	
				default:
					break;
			}
		}
	}
	else
	if (!strcmpi(bptr_lhs_string, "CHAP"))
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
		search_to_start_at = get_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1],port_number, &port_number_matched, &authentication_type, 1);
		if (search_to_start_at && port_number_matched && (authentication_type == CM_ONLY_CHAP_ENABLED || authentication_type == CM_BOTH_PAP_AND_CHAP_ENABLED))
		{
			switch(expected_format_of_return_value)
			{
				case CM_STRING_FORMAT:
					strcpy(string_ptr, "enabled");
					return CM_GET_SUCCESSFUL;	
				case CM_INDEX_FORMAT:
					uptr_return_value->byte_value = 1;
					return CM_GET_SUCCESSFUL;	
				default:
					break;
			}
		}
		else
		{
			switch(expected_format_of_return_value)
			{
				case CM_STRING_FORMAT:
					strcpy(string_ptr, "disabled");
					return CM_GET_SUCCESSFUL;	
				case CM_INDEX_FORMAT:
					uptr_return_value->byte_value = 0;
					return CM_GET_SUCCESSFUL;	
				default:
					break;
			}
		}
	}
	/* if the section is not the last section */
	if (section_number == CM_NUMBER_OF_SECTIONS - 1)
	{
		
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
	   if (port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(bptr_lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
		}
		else
		{
			for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(bptr_lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
				if (search_to_start_at == NULL)
					return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
		}
	}
	else
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
		if(port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(bptr_lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
		}
		else
		{
			for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(bptr_lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
				if (search_to_start_at == NULL)
					return CM_RHS_STRING_NOT_FOUND_WHILE_GET;	
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
		}
	}
	if(string_ptr == NULL)
	{
		printf("String %s not found in configuration\n", bptr_lhs_string);
		return CM_RHS_STRING_NOT_FOUND_WHILE_GET;
	}
	switch(expected_format_of_return_value)
	{
	  case CM_STRING_FORMAT:
		  	return CM_GET_SUCCESSFUL;
	  case CM_USHORT_FORMAT:
	  		if(!is_valid_string_to_read_data(string_ptr))
			{
				printf("NonNumeric Data found for %s\n", bptr_lhs_string);
				return CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA;
			}
	  		sscanf(string_ptr,"%6d",&(uptr_return_value->ushort_value));
	  		return CM_GET_SUCCESSFUL;
	  case CM_ULONG_FORMAT:
	  		if(!is_valid_string_to_read_data(string_ptr))
			{
				printf("NonNumeric Data found for %s\n", bptr_lhs_string);
				return CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA;
			}
	  		sscanf(string_ptr, "%9d", &(uptr_return_value->ulong_value));
	  		return CM_GET_SUCCESSFUL;
	  case CM_BYTE_FORMAT:
	  		if(!is_valid_string_to_read_data(string_ptr))
			{
				printf("NonNumeric Data found for %s\n", bptr_lhs_string);
				return CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA;
			}
	  		sscanf(string_ptr, "%3d", &(uptr_return_value->byte_value));
         return CM_GET_SUCCESSFUL;
     case CM_INDEX_FORMAT:
		  	convert_to_lower_case(string_ptr);
			if (!strcmpi(string_ptr, "enabled"))
         {
				uptr_return_value->byte_value = 1;
         }
			else
			if (!strcmpi(string_ptr, "disabled"))
         {
				uptr_return_value->byte_value  = 0;
         }
#if 0 /* Not Required for Proxy Server */
			else
			if (strcmpi(bptr_lhs_string, "spanning tree port state") == 0)
			{
				/*Then this is Spanning Tree State Field*/
				if(!strcmpi(string_ptr, "disable"))
				{
					uptr_return_value->byte_value = 0;
				}
				else
				if(!strcmpi(string_ptr, "listening"))
				{
					uptr_return_value->byte_value = 1;
				}                        
				else
				if(!strcmpi(string_ptr, "learning"))
				{
					uptr_return_value->byte_value = 2;
				}
				else
				if(!strcmpi(string_ptr, "blocking"))
				{
					uptr_return_value->byte_value = 3;
				}
				else
				if(!strcmpi(string_ptr, "forwarding"))
				{
					uptr_return_value->byte_value = 4;
				}
				else
				{
					printf("Spanning Tree Port State value does not match with standard value, setting it to disabled\n");
					uptr_return_value->byte_value = 0;
				}
			}
#endif /* Not Required for Proxy Server */
			else
			if(strcmpi(bptr_lhs_string, "wan port synchronous speed") == 0)
			{
				/*Then this is WAN Port ClockSpeed*/
				if(!strcmpi(string_ptr, "4800"))
					uptr_return_value->byte_value = 0;
				else
				if(!strcmpi(string_ptr, "9600"))
					uptr_return_value->byte_value = 1;
				else
				if(!strcmpi(string_ptr, "19200"))
					uptr_return_value->byte_value = 2;
				else
				if(!strcmpi(string_ptr, "38400"))
					uptr_return_value->byte_value = 3;
				else
				if(!strcmpi(string_ptr, "57600"))
					uptr_return_value->byte_value = 4;
				else
				if(!strcmpi(string_ptr, "64000"))
					uptr_return_value->byte_value = 5;
				else
				if(!strcmpi(string_ptr, "128000"))
					uptr_return_value->byte_value = 6;
				else
				if(!strcmpi(string_ptr, "256000"))
					uptr_return_value->byte_value = 7;
				else
				if(!strcmpi(string_ptr, "512000"))
					uptr_return_value->byte_value = 8;
				else
				if(!strcmpi(string_ptr, "1024000"))
					uptr_return_value->byte_value = 9;
				else
				if(!strcmpi(string_ptr, "1536000"))
					uptr_return_value->byte_value = 10;
				else
				if(!strcmpi(string_ptr, "2048000"))
					uptr_return_value->byte_value = 11;
				else
				{
					printf("WAN Clock Speed did not match! setting it to 64000\n");
					uptr_return_value->byte_value = 5;
				}
			}
			else
			if(strcmpi(bptr_lhs_string, "wan port speed") == 0)
			{															  
				/*Then this is WAN Port BaudRate*/
				if(!strcmpi(string_ptr, "300"))
					uptr_return_value->byte_value = 0;
				else
				if(!strcmpi(string_ptr, "600"))
					uptr_return_value->byte_value = 1;
				else
				if(!strcmpi(string_ptr, "1200"))
					uptr_return_value->byte_value = 2;
				else
				if(!strcmpi(string_ptr, "2400"))
					uptr_return_value->byte_value = 3;
				else
				if(!strcmpi(string_ptr, "4800"))
					uptr_return_value->byte_value = 4;
				else
				if(!strcmpi(string_ptr, "9600"))
					uptr_return_value->byte_value = 5;
				else
				if(!strcmpi(string_ptr, "19200"))
					uptr_return_value->byte_value = 6;
				else
				if(!strcmpi(string_ptr, "38400"))
					uptr_return_value->byte_value = 7;
				else
				if(!strcmpi(string_ptr, "57600"))
					uptr_return_value->byte_value = 8;
				else
				if(!strcmpi(string_ptr, "115200"))
					uptr_return_value->byte_value = 9;
				else
				if(!strcmpi(string_ptr, "230400"))
					uptr_return_value->byte_value = 10;
				else
				if(!strcmpi(string_ptr, "460800"))
					uptr_return_value->byte_value = 11;
				else
				{
					printf("WAN Baud Rate did not match! setting it to 19200\n");
					uptr_return_value->byte_value = 6;
				}
			}
			else
			if(strcmpi(bptr_lhs_string, "ip port frame type")==0)
			{
				if (!strcmpi(string_ptr, "type_ii"))
					uptr_return_value->byte_value = 0;
				else
				if (!strcmpi(string_ptr, "snap"))
					uptr_return_value->byte_value = 1;
				else
				{
					printf("IP Frame Type did not match! setting to TYPE_II");
					uptr_return_value->byte_value = 0;
				}
			}
			else
			{
/*				printf("ATTENTION: INDEX_FORMAT required but there is no match for the string %s %s\n", bptr_lhs_string, string_ptr);*/
/*				return ;
	 			uptr_return_value->byte_value = ;*/
			}
			return(CM_GET_SUCCESSFUL);
	  default:
	  	printf("Return type unknown. Returning string\n");
		return(CM_GET_SUCCESSFUL);
	}
}

BYTE get_the_section_number(enum CM_SECTIONS section)
{
	return((BYTE)section);
}

BYTE* get_lhs_string(ULONG offset, CONFIGURATION_TABLE* configuration_table, BYTE* lhs_para_str)
{
	ULONG i = 0;
	BYTE *ptr_to_eq_sign, *save_lhs_para_str;
	while (1)
	{
		if (configuration_table->function[i].cptr_parameter_string == NULL)
			break;  

		if (configuration_table->function[i].parameter_1 ==	offset)
		{
			strcpy (lhs_para_str, configuration_table->function[i].cptr_parameter_string);
 			if ((ptr_to_eq_sign = strchr (lhs_para_str, '=')) == NULL)
			{
				return (NULL);				
			}
			ptr_to_eq_sign--;
			*ptr_to_eq_sign = '\0';				  
			save_lhs_para_str = lhs_para_str;
			return (save_lhs_para_str);	 
		}			
		i++;
	}
	return (NULL);
}	  


PARAMETER_NODE* match_the_lhs_string_in_the_linked_list_and_return_rhs_string(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* rhs_string, USHORT port_number, BYTE* port_number_matched)
{
	BYTE temp_string[200], main_index = 0, sub_index = 0, temp_buffer[100];

	convert_to_lower_case(lhs_string);
	search_to_start_at = search_to_start_at->next;
	while (search_to_start_at && search_to_start_at != start_of_next_section)
	{
		while (search_to_start_at->parameter[main_index] != '=') /* Also check for some limit TAKE CARE */
		{
			temp_string[sub_index++] = search_to_start_at->parameter[main_index++];
		}
		temp_string[sub_index-1] = 0;
		convert_to_lower_case(temp_string);
		if(strcmpi(lhs_string, temp_string) == 0)
		{
			main_index += 2;
			if(port_number != CM_NO_PORT_PARAMETER_PRESENT)
			{
				sub_index = 0;
				while(search_to_start_at->parameter[main_index] != ',')
				{
					temp_string[sub_index++] = search_to_start_at->parameter[main_index++];
				}
				temp_string[sub_index] = 0;
            main_index ++; /* Skip ,  */

            sprintf(temp_buffer, "%02d\0", port_number);
				if (strcmpi(temp_buffer, temp_string) == 0)
					*(port_number_matched) = TRUE;
				else
				{
					*(port_number_matched) = FALSE;
					return search_to_start_at;
				}
			}
			sub_index = 0;
			while(main_index < strlen(search_to_start_at->parameter) && search_to_start_at->parameter[main_index] != '\n' && search_to_start_at->parameter[main_index] != '\r' && search_to_start_at->parameter[main_index] != '\0')
			{
				rhs_string[sub_index++] = search_to_start_at->parameter[main_index++];
			}
			rhs_string[sub_index] = 0;
			return search_to_start_at;
		}
		sub_index = 0;
		main_index = 0;
		search_to_start_at = search_to_start_at->next;
	}
   return NULL;
}



PARAMETER_NODE* get_authentication_method(PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, USHORT port_number, BYTE* port_number_matched, BYTE* authentication_type, BYTE is_local_required)
{
	BYTE temp_string[200], main_index = 0, sub_index = 0, temp_buffer[100];
	BYTE local_buffer[50];

	search_to_start_at = search_to_start_at->next;
	while (search_to_start_at && search_to_start_at != start_of_next_section)
	{
		while (search_to_start_at->parameter[main_index] != '=') /* Also check for some limit TAKE CARE */
		{
			temp_string[sub_index++] = search_to_start_at->parameter[main_index++];
		}
		temp_string[sub_index-1] = 0;
		convert_to_lower_case(temp_string);
		if (is_local_required)
		{
			 strcpy(local_buffer, "ppp port option");
		}
		else
		{
			 strcpy(local_buffer, "ppp port remote option");
		}

		if(strcmpi(local_buffer, temp_string) == 0)
		{
			main_index += 2;
			dummy_fn();
			/* Port Number */
			main_index = get_string_until_delimiter(main_index, ',', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */
         sprintf(temp_buffer, "%02d\0", port_number);
			if (strcmpi(temp_string, temp_buffer) != 0 )
			{
				*(port_number_matched) = FALSE;
				goto continue_searching;
			}

			/* LCP*/
			main_index = get_string_until_delimiter(main_index, ',', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */
			convert_to_lower_case(temp_string);
			if (strcmpi(temp_string , "lcp") != 0)
			{
				*(port_number_matched) = FALSE;
				goto continue_searching;
			}

			/* Authentication */
			main_index = get_string_until_delimiter(main_index, ' ', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */
			convert_to_lower_case(temp_string);
			if (strcmpi(temp_string , "authentication") != 0)
			{
				*(port_number_matched) = FALSE;
				goto continue_searching;
			}
			if (!is_local_required)
			{
				*(port_number_matched) = TRUE;
				return search_to_start_at;
			}

			/* */
			main_index = get_string_until_delimiter(main_index, ',', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */
			convert_to_lower_case(temp_string);
			if (!(strcmpi("(pap)", temp_string)))
			{
				*(authentication_type) = CM_ONLY_PAP_ENABLED;
				*(port_number_matched) = TRUE;
				return search_to_start_at;
			}

			/* Number */
			main_index = get_string_until_delimiter(main_index, ',', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */

			/* Auto */
			main_index = get_string_until_delimiter(main_index, ',', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */

			/* */
			main_index = get_string_until_delimiter(main_index, ',', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */

			main_index = get_string_until_delimiter(main_index, ',', search_to_start_at->parameter, temp_string);
         main_index ++; /* Skip ,  */

			convert_to_lower_case(temp_string);
			*(port_number_matched) = TRUE;
			if (!(strcmpi("negotiable", temp_string)))
			{
				*(authentication_type) = CM_BOTH_PAP_AND_CHAP_ENABLED;
				return search_to_start_at;
			}
			else
			{
				*(authentication_type) = CM_ONLY_CHAP_ENABLED;
				return search_to_start_at;
			}
		}
continue_searching: 
		sub_index = 0;
		main_index = 0;
		search_to_start_at = search_to_start_at->next;
	}
	*(authentication_type) = CM_NO_AUTHENTICATION;
	*(port_number_matched) = TRUE;
   return NULL;
}


PARAMETER_NODE* set_authentication_method(PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, USHORT port_number, BYTE* port_number_matched, BYTE authentication_type)
{
	PARAMETER_NODE* new_node, *remote_node;
	BYTE pap_enabled_before, chap_enabled_before, previous_authentication_type;


	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_PPP_SECTION];
	search_to_start_at = get_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[CM_PPP_SECTION+1],port_number, port_number_matched, &previous_authentication_type, 1);
	if (port_number_matched && (previous_authentication_type == CM_ONLY_PAP_ENABLED || previous_authentication_type == CM_BOTH_PAP_AND_CHAP_ENABLED))
	{
		pap_enabled_before = TRUE;
	}
	else
	{
		pap_enabled_before = FALSE;
	}


	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_PPP_SECTION];
	search_to_start_at = get_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[CM_PPP_SECTION+1],port_number, port_number_matched, &previous_authentication_type, 1);
	if (port_number_matched && (previous_authentication_type == CM_ONLY_CHAP_ENABLED || previous_authentication_type == CM_BOTH_PAP_AND_CHAP_ENABLED))
	{
		chap_enabled_before = TRUE;
	}
	else
	{
		chap_enabled_before = FALSE;
	}


	if (authentication_type == CM_ENABLE_PAP && chap_enabled_before == FALSE)
	{
		remove_ppp_authentication_strings(port_number);
		if (!(new_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, new_node)))
			return NULL;
		form_a_pap_only_local_string(new_node->parameter, port_number);

		if (!(remote_node=creat_new_node_at_the_end_of_section(CM_PPP_SECTION, remote_node)))
			return NULL;
		form_a_pap_only_remote_string(remote_node->parameter, port_number);
	}
	else
	if (authentication_type == CM_ENABLE_PAP && chap_enabled_before == TRUE)
	{
		remove_ppp_authentication_strings(port_number);
		if (!(new_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, new_node)))
			return NULL;
		form_a_pap_and_chap_local_string(new_node->parameter, port_number);
		if (!(remote_node= creat_new_node_at_the_end_of_section(CM_PPP_SECTION, remote_node)))
			return NULL;
		form_a_pap_and_chap_remote_string(remote_node->parameter, port_number);
	}
	else
	if (authentication_type == CM_DISABLE_PAP && chap_enabled_before == FALSE)
	{
		remove_ppp_authentication_strings(port_number);
	}
	else
	if (authentication_type == CM_DISABLE_PAP && chap_enabled_before == TRUE)
	{
		remove_ppp_authentication_strings(port_number);
		if (!(new_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, new_node)))
			return NULL;
		form_a_chap_only_local_string(new_node->parameter, port_number);
		if (!(remote_node= creat_new_node_at_the_end_of_section(CM_PPP_SECTION, remote_node)))
			return NULL;
		form_a_chap_only_remote_string(remote_node->parameter, port_number);
	}
	else
	if (authentication_type == CM_ENABLE_CHAP && pap_enabled_before == TRUE)
	{
		remove_ppp_authentication_strings(port_number);
		if (!(new_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, new_node)))
			return NULL;
		form_a_pap_and_chap_local_string(new_node->parameter, port_number);
		if (!(remote_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, remote_node)))
			return NULL;
		form_a_pap_and_chap_remote_string(remote_node->parameter, port_number);
	}
	else
	if (authentication_type == CM_ENABLE_CHAP && pap_enabled_before == FALSE)
	{
		remove_ppp_authentication_strings(port_number);
		if (!(new_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, new_node)))
			return NULL;
		form_a_chap_only_local_string(new_node->parameter, port_number);
		if (!(remote_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, remote_node)))
			return NULL;
		form_a_chap_only_remote_string(remote_node->parameter, port_number);
	}
	else
	if (authentication_type == CM_DISABLE_CHAP && pap_enabled_before == TRUE)
	{
		remove_ppp_authentication_strings(port_number);
		if (!(new_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, new_node)))
			return NULL;
		form_a_pap_only_local_string(new_node->parameter, port_number);
		if (!(remote_node = creat_new_node_at_the_end_of_section(CM_PPP_SECTION, remote_node)))
			return NULL;
		form_a_pap_only_remote_string(remote_node->parameter, port_number);
		return;
	}
	else
	if (authentication_type == CM_DISABLE_CHAP && pap_enabled_before == FALSE)
	{
		remove_ppp_authentication_strings(port_number);
		return;
	}
}


PARAMETER_NODE* creat_new_node_at_the_end_of_section(USHORT section_number, PARAMETER_NODE* new_node)
{
	PARAMETER_NODE* next_section_first_node, *current_section_last_node;
   new_node = (PARAMETER_NODE*) malloc (sizeof (ULONG) * 2 + 200) ;
  	if (new_node == NULL)
  	{
     	printf("Not Enough Memory to insert \n");
     	return NULL;
  	}
  	next_section_first_node = sptr_to_each_section_in_the_configuration[section_number+1];
  	current_section_last_node = next_section_first_node->previous;
  	new_node->next = next_section_first_node;
  	new_node->previous = current_section_last_node;
  	next_section_first_node->previous = new_node;
  	current_section_last_node->next = new_node;
	return new_node;	
}

void remove_ppp_authentication_strings(BYTE port_number)
{
#if 1
	PARAMETER_NODE* search_to_start_at;
	BYTE port_number_matched = FALSE, authentication_type;

	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_PPP_SECTION];
	search_to_start_at = get_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[CM_PPP_SECTION+1], port_number, &port_number_matched, &authentication_type, 1);
	if (!port_number_matched || search_to_start_at == NULL)
	{
	 	goto remove_remote_authentication_protocol;
	}


	search_to_start_at->next->previous = search_to_start_at->previous;
	search_to_start_at->previous->next = search_to_start_at->next;
	free(search_to_start_at);

remove_remote_authentication_protocol:
	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_PPP_SECTION];
	search_to_start_at = get_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[CM_PPP_SECTION+1], port_number, &port_number_matched, &authentication_type, 0);
	if (!port_number_matched || search_to_start_at == NULL)
	{
	 	return;
	}

	search_to_start_at->next->previous = search_to_start_at->previous;
	search_to_start_at->previous->next = search_to_start_at->next;

	free(search_to_start_at);
#endif
}

void form_a_pap_only_local_string(BYTE* buffer, BYTE port_number)
{
	BYTE temp_buffer[10];
	strcpy(buffer, "PPP Port Option = ");
   sprintf(temp_buffer, "%02d\0", port_number);
	strcat(buffer, temp_buffer);
	strcat(buffer, ",LCP,Authentication (PAP),3,Auto,Negotiation Not Required,Not Negotiable,H2,c023");
	strcat(buffer, "\n");
	return;
}

void form_a_chap_only_local_string(BYTE* buffer, BYTE port_number)
{
	BYTE temp_buffer[10];
	strcpy(buffer, "PPP Port Option = ");
   sprintf(temp_buffer, "%02d\0", port_number);
	strcat(buffer, temp_buffer);
	strcat(buffer, ",LCP,Authentication (CHAP),3,Auto,Negotiation Not Required,Not Negotiable,H3,c22305");
	strcat(buffer, "\n");
	return;
}

void form_a_pap_and_chap_local_string(BYTE* buffer, BYTE port_number)
{
	BYTE temp_buffer[10];
	strcpy(buffer, "PPP Port Option = ");
   sprintf(temp_buffer, "%02d\0", port_number);
	strcat(buffer, temp_buffer);
	strcat(buffer, ",LCP,Authentication (CHAP),3,Auto,Negotiation Not Required,Negotiable,H3,c22305");
	strcat(buffer, "\n");
	return;
}

void form_a_pap_only_remote_string(BYTE* buffer, BYTE port_number)
{
	BYTE temp_buffer[10];
	strcpy(buffer, "PPP Port Remote Option = ");
   sprintf(temp_buffer, "%02d\0", port_number);
	strcat(buffer, temp_buffer);
	strcat(buffer, ",LCP,Authentication (PAP),3,Auto,Negotiation Not Required,Not Negotiable,H2,c023");
	strcat(buffer, "\n");
	return;
}

void form_a_chap_only_remote_string(BYTE* buffer, BYTE port_number)
{
	BYTE temp_buffer[10];
	strcpy(buffer, "PPP Port Remote Option = ");
   sprintf(temp_buffer, "%02d\0", port_number);
	strcat(buffer, temp_buffer);
	strcat(buffer, ",LCP,Authentication (CHAP),3,Auto,Negotiation Not Required,Not Negotiable,H3,c22305");
	strcat(buffer, "\n");
	return;
}

void form_a_pap_and_chap_remote_string(BYTE* buffer, BYTE port_number)
{
	BYTE temp_buffer[10];
	strcpy(buffer, "PPP Port Remote Option = ");
   sprintf(temp_buffer, "%02d\0", port_number);
	strcat(buffer, temp_buffer);
	strcat(buffer, ",LCP,Authentication (CHAP),3,Auto,Negotiation Not Required,Negotiable,H3,c22305");
	strcat(buffer, "\n");
	return;
 }


BYTE get_string_until_delimiter(BYTE search_to_start_at, BYTE delimiter, BYTE* src_string, BYTE* dest_string)
{
	BYTE sub_index = 0;
	while(src_string[search_to_start_at] != delimiter)
	{
		dest_string[sub_index++] = src_string[search_to_start_at++];
	}
	dest_string[sub_index] = 0;
	return search_to_start_at;
}

PARAMETER_NODE* match_the_lhs_string_in_the_linked_list_and_write_the_new_value(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* new_value_string, USHORT port_number, BYTE* port_number_matched)
{
	BYTE temp_string[200], main_index = 0, sub_index = 0;
   BYTE temp_buffer[100];

	convert_to_lower_case(lhs_string);
	search_to_start_at = search_to_start_at->next;
	while (search_to_start_at && search_to_start_at != start_of_next_section)
	{
		while (search_to_start_at->parameter[main_index] != '=') /* Also check for some limit TAKE CARE */
		{
			temp_string[sub_index++] = search_to_start_at->parameter[main_index++];
		}
		temp_string[sub_index-1] = 0;
		convert_to_lower_case(temp_string);
		if(strcmpi(lhs_string, temp_string) == 0)
		{
			main_index += 2;
			if(port_number != CM_NO_PORT_PARAMETER_PRESENT)
			{
				sub_index = 0;
				while(search_to_start_at->parameter[main_index] != ',')
				{
					temp_string[sub_index++] = search_to_start_at->parameter[main_index++];
				}
				temp_string[sub_index] = 0;
            main_index ++; /* Skip the , */

            sprintf(temp_buffer, "%02d\0", port_number);
				if (strcmpi(temp_buffer, temp_string) == 0)
					*(port_number_matched) = TRUE;
				else
				{
					*(port_number_matched) = FALSE;
					return search_to_start_at;
				}
			}
			for(sub_index=0; sub_index < strlen(new_value_string); ++sub_index)
				search_to_start_at->parameter[main_index++] = new_value_string[sub_index];

			search_to_start_at->parameter[main_index] = '\n';
			search_to_start_at->parameter[main_index+1] = 0;
			return (search_to_start_at);
		}
		sub_index = 0;
		main_index = 0;
		search_to_start_at = search_to_start_at->next;
	}
   return NULL;
}

void convert_to_lower_case(BYTE* the_string)
{
	USHORT string_length,i;
   return;
	string_length = strlen(the_string);
	for(i=0;i<string_length; ++i)
		if (the_string[i] >= 'A' && the_string[i] <= 'Z')
			the_string[i] += 32;
}

BYTE is_valid_string_to_read_data(BYTE* buffer)
{
	USHORT i, buffer_length;

	buffer_length = strlen(buffer);
	for(i=0; i<buffer_length; ++i)
	{
		if (buffer[i] >= '0' && buffer[i] <= '9')
			continue;
		return(FALSE);
	}
	return(TRUE);
}


enum CM_SET_RESULTS set_parameter(enum CM_SECTIONS section_to_which_it_belongs_to, void* vptr_parameter_ID,
								 					 USHORT port_number, USHORT format_got,
								 					 void* vptr_new_value)
{
 	BYTE lhs_string[200], section_number, *string_ptr, i, j, temp_buffer[200], *temp_lhs_string, port_number_matched;
	UNION_RETURN_VALUE*  uptr_new_value;
   BYTE* local_byte, wan_enabled;
   USHORT* local_ushort;
   ULONG* local_ulong, temp;
	ULONG offset, value_to_validate;
	PARAMETER_NODE* search_to_start_at, *node;
   BYTE value, number_of_ports, ppp_enabled, slip_enabled, number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);
	BYTE ip_address[STRING_LENGTH_FOR_GET], subnet_mask[STRING_LENGTH_FOR_GET];
/*   void* temp1, *temp2;*/
	BYTE temp_ip_address[STRING_LENGTH_FOR_GET];
	BYTE ftp_ctrl = 0;
	USHORT ftp_prev_port_number = 0;
	char temp_string_for_ftp[10];

   number_of_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS) + lsl_control(GET_NUMBER_OF_LAN_PORTS);

	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{ 
		printf("SET:Configuration Manager Owned by None \n");
		return ;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return ;
	}	 

   /* If DHCP Client is enabled and if we are trying to set IP Addressa and
      mask for Internet LAN just return */
   if ( port_number == 1 /* Internet LAN */ && section_to_which_it_belongs_to == CM_IP_SECTION && ((vptr_parameter_ID == (void*)&ip.port[0].config.ip_address) || (vptr_parameter_ID == (void*)&ip.port[0].config.subnetmask)))
   {
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, port_number, CM_INDEX_FORMAT, (void*)&value, 0);
      if (value) /* Yes DHCP is Enabled, go out */
         return CM_SET_SUCCESSFUL;
   }

	/* If wan port 'x' is disabled don't save any parameters for PPP port
	   'x'
	*/
   if (section_to_which_it_belongs_to == CM_PPP_SECTION && port_number != CM_NO_PORT_PARAMETER_PRESENT)
   {
      /* Get the status of wan port */
      if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&wan_enabled, 0) == CM_GET_SUCCESSFUL)
      {
         if (!wan_enabled)
         {
            return CM_ERROR_WHILE_VALIDATING;
         }
      }
      else
         return CM_ERROR_WHILE_VALIDATING;
   }

	uptr_new_value = (UNION_RETURN_VALUE*)vptr_new_value;
	section_number = get_the_section_number(section_to_which_it_belongs_to);
	offset = (BYTE*)vptr_parameter_ID - array_of_ptrs_to_global_class_structres[section_number];

	if (vptr_parameter_ID == (void*)&telnet.password && format_got == CM_STRING_FORMAT)
	{
	  	string_ptr = uptr_new_value->string;
		encrypt(to_upper_string(string_ptr), temp_buffer);
		strcpy(string_ptr, temp_buffer);
	}

#if 0
	/* For any WAN port if it is client only do not allow the user to change
	   local ip address of that wan port */

	if (section_to_which_it_belongs_to == CM_IP_SECTION && 
			port_number > 0 && /* i.e for WAN Ports */
			vptr_parameter_ID == (void*)&ip.port[0].config.ip_address)
	{
		get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].client_only, port_number-1, CM_INDEX_FORMAT, (void*)&value, 0);
		if (value && format_got == CM_STRING_FORMAT)
			/* set the local IP address to the LAN ip address */
		{	
			string_ptr = (BYTE*)vptr_new_value;
			get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 0, CM_STRING_FORMAT, (void*)temp_buffer, 100);
			if (strcmpi(string_ptr, temp_buffer))
			{
				printf("Client Only is enabled on this port, failed to change Local IP Address\n");
			  	return CM_SET_SUCCESSFUL;
			}
		}
	}
#endif

	switch(format_got)
	{
	  	case CM_STRING_FORMAT:
			string_ptr = uptr_new_value->string;
	  		break;
		case CM_BYTE_FORMAT:
         local_byte = (BYTE*)vptr_new_value;
			sprintf(temp_buffer, "%d\0", *(local_byte));
			string_ptr = temp_buffer;
         value_to_validate = (ULONG)(*local_byte);
			break;
      case CM_INDEX_FORMAT:
         local_byte = (BYTE*)vptr_new_value;
#if 0 /* Not Required for Proxy Server */
			if ((offset == array_of_offset_and_section_type[0].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[0].section_type))
			{
				/*Then this is Spanning Tree State Field*/
				if(*(local_byte) == 0)
					strcpy(temp_buffer, "disable");
				else
				if(*(local_byte) == 1)
					strcpy(temp_buffer, "listening");
				else
				if(*(local_byte) == 2)
					strcpy(temp_buffer, "learning");
				else
				if(*(local_byte) == 3)
					strcpy(temp_buffer, "blocking");
				else
				if(*(local_byte) == 4)
					strcpy(temp_buffer, "forwarding");
				else
				{
					printf("Spanning Tree State Field got a invalid value assumed default (disable)\n");
					strcpy(temp_buffer, "disable");
				}
			}
			else
#endif /* Not Required for Proxy Server */
			if((offset == array_of_offset_and_section_type[1].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[1].section_type))
			{
				if (*(local_byte) == 0)
					strcpy(temp_buffer, "300");
				else
				if (*(local_byte) == 1)
					strcpy(temp_buffer, "600");
				else
				if (*(local_byte) == 2)
					strcpy(temp_buffer, "1200");
				else
				if (*(local_byte) == 3)
					strcpy(temp_buffer, "2400");
				else
				if (*(local_byte) == 4)
					strcpy(temp_buffer, "4800");
				else
				if (*(local_byte) == 5)
					strcpy(temp_buffer, "9600");
				else
				if (*(local_byte) == 6)
					strcpy(temp_buffer, "19200");
				else
				if (*(local_byte) == 7)
					strcpy(temp_buffer, "38400");
				else
				if (*(local_byte) == 8)
					strcpy(temp_buffer, "57600");
				else
				if (*(local_byte) == 9)
					strcpy(temp_buffer, "115200");
				else
				if (*(local_byte) == 10)
					strcpy(temp_buffer, "230400");
				else
				if (*(local_byte) == 11)
					strcpy(temp_buffer, "460800");
				else
				{
					printf("Invalid BaudRate setting to default (19200)\n");
					strcpy(temp_buffer, "19200");
				}
			}
			else
			if((offset == array_of_offset_and_section_type[2].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[2].section_type))
			{
				if(*(local_byte) == 0)
					strcpy(temp_buffer, "4800");
				else
				if(*(local_byte) == 1)
					strcpy(temp_buffer, "9600");
				else
				if(*(local_byte) == 2)
					strcpy(temp_buffer, "19200");
				else
				if(*(local_byte) == 3)
					strcpy(temp_buffer, "38400");
				else
				if(*(local_byte) == 4)
					strcpy(temp_buffer, "57600");
				else
				if(*(local_byte) == 5)
					strcpy(temp_buffer, "64000");
				else
				if(*(local_byte) == 6)
					strcpy(temp_buffer, "128000");
				else
				if(*(local_byte) == 7)
					strcpy(temp_buffer, "256000");
				else
				if(*(local_byte) == 8)
					strcpy(temp_buffer, "512000");
				else
				if(*(local_byte) == 9)
					strcpy(temp_buffer, "102400");
				else
				if(*(local_byte) == 10)
					strcpy(temp_buffer, "1536000");
				else
				if(*(local_byte) == 11)
					strcpy(temp_buffer, "2048000");
				else
				{
					printf("Invalid clock speed, assuming default (128000)\n");
					strcpy(temp_buffer, "128000");
				}
			}
			else
			if((offset == array_of_offset_and_section_type[3].offset) && (section_to_which_it_belongs_to == array_of_offset_and_section_type[3].section_type))
			{
				if (*(local_byte) == 0)
					strcpy(temp_buffer, "TYPE_II");
				else
					strcpy(temp_buffer, "SNAP");
			}
			else
			if (*(local_byte))
         {
				strcpy(temp_buffer, "enabled");
         }
			else
         {
				strcpy(temp_buffer, "disabled");
         }
			string_ptr = temp_buffer;
			break;
		case CM_USHORT_FORMAT:
         local_ushort = (USHORT*)vptr_new_value;
			sprintf(temp_buffer, "%d\0", *(local_ushort));
			string_ptr = temp_buffer;
         value_to_validate = (ULONG)(*local_ushort);
			break;
		case CM_ULONG_FORMAT:
         local_ulong = (ULONG*)vptr_new_value;
			sprintf(temp_buffer, "%d\0", *(local_ulong));
			string_ptr = temp_buffer;
         value_to_validate = (ULONG)(*local_ulong);
			break;
		default:
			printf("Format of the value to set is unknown");
			return CM_UNKNOWN_FORMAT;
	}
	temp_lhs_string = get_lhs_string(offset, sptr_to_configuration_table[section_number], lhs_string);
	if(lhs_string == NULL)
	{
/*		printf("While Writing, failed to get LHS String for the offset %d in the Configuration Table %d\n", offset);*/
		return ;
	}

#if 1
	/* Verification in progress ...*/
   i = 0;
	while(field_validation_lib[i].verification_function != NULL)
	{
		if (offset == field_validation_lib[i].offset && section_to_which_it_belongs_to == field_validation_lib[i].section_type)
		{  
         /* For these fields string length should not be zero, because
            atleast zero should be entred */
         if (strlen(string_ptr) == 0)
         {
				return CM_ERROR_WHILE_VALIDATING;
         }

         /* Check if the value given contains numeric characters */
         if (!is_valid_string_to_read_data(string_ptr))
         {
				return CM_ERROR_WHILE_VALIDATING;
         }

         if (format_got == CM_STRING_FORMAT)
         {
            value_to_validate = atoi(string_ptr);
         }
/*         printf("SET:%s Needs Verification\n", lhs_string);*/
			if (! field_validation_lib[i].verification_function(field_validation_lib[i].min_limit, field_validation_lib[i].max_limit, value_to_validate))
				return CM_ERROR_WHILE_VALIDATING;
/*         printf("Data validation Successful\n");*/
		}
      ++i;
	}

	if (section_to_which_it_belongs_to == CM_IP_SECTION && vptr_parameter_ID == (void*)&ip.port[0].config.default_gateway)
	{
		if (!is_an_ip_address(string_ptr))
		{
			return CM_ERROR_WHILE_VALIDATING;
		}
	}
	if (section_to_which_it_belongs_to == CM_IP_SECTION && vptr_parameter_ID == (void*)&ip.port[0].config.ip_address)
	{ /* Ip Address of lan and wan */
		if (!is_an_ip_address(string_ptr) || !(dot2ulong(string_ptr)))
		{
         if (port_number == 1 /* Internet LAN */)
         {
            get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
            if (!strcmpi(ip_address, "0.0.0.0"))
            {
               /* If the prev address is 0.0.0.0 then enable DHCP Client
                  because the current IP Address is not Valid */
               value = 1;
               set_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, port_number, CM_INDEX_FORMAT, (void*)&value);
            }
         }
/*			printf("Validation Failed on IP Address Validation\n");*/
			return CM_ERROR_WHILE_VALIDATING;
		}
/*			printf("Validation SuccessFul on IP Address Validation\n");*/
	}
	if (section_to_which_it_belongs_to == CM_IP_SECTION && vptr_parameter_ID == (void*)&ip.port[0].config.subnetmask)
	{ /* Subnet mask */
		if (get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET) != CM_GET_SUCCESSFUL)
		{
         if (port_number == 1 /* Internet LAN */)
         {
            get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
            if (!strcmpi(ip_address, "0.0.0.0"))
            {
               /* If the prev address is 0.0.0.0 then enable DHCP Client
                  because the current IP Address is not Valid */
               value = 1;
               set_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, port_number, CM_INDEX_FORMAT, (void*)&value);
            }
         }
			return CM_ERROR_WHILE_VALIDATING;
		}
		if (!is_an_ip_address_mask(ip_address, string_ptr))
		{	
/*			printf("Validation Failed on IP Address Mask Validation\n");*/
         if (port_number == 1)
         {
            get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
            if (!strcmpi(ip_address, "0.0.0.0"))
            {
               /* If the prev address is 0.0.0.0 then enable DHCP Client
                  because the current IP Address is not Valid */
               value = 1;
               set_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, port_number, CM_INDEX_FORMAT, (void*)&value);
            }
         }
			return CM_ERROR_WHILE_VALIDATING;
		}
/*			printf("Validation SuccessFul on IP Address Mask\n");*/
	}
	if (section_to_which_it_belongs_to == CM_IP_SECTION && vptr_parameter_ID == (void*)&ip.port[0].config.point_to_point_remote_ip_address)
	{ /* Remote Ip Address */
		if (get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, CM_STRING_FORMAT, (void*)&ip_address, STRING_LENGTH_FOR_GET)  != CM_GET_SUCCESSFUL)
		{
			return CM_ERROR_WHILE_VALIDATING;
		}
		if (get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, CM_STRING_FORMAT, (void*)&subnet_mask, STRING_LENGTH_FOR_GET)  != CM_GET_SUCCESSFUL)
		{
			return CM_ERROR_WHILE_VALIDATING;
		}
		if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, string_ptr, subnet_mask))
		{	
/*			printf("Validation Failed on Remote IP Address Validation\n");*/
			return CM_ERROR_WHILE_VALIDATING;
		}
/*			printf("Validation Failed on Remote IP Address Validation\n");*/
	}
	if (section_to_which_it_belongs_to == CM_DHCP_SECTION && vptr_parameter_ID == (void*)&dhcp.config.server_ip_address)
	{ /* DHCP server Ip address */
		if (!is_an_ip_address(string_ptr))
		{	
/*			printf("Validation Failed on DHCP IP Address Validation\n");*/			return CM_ERROR_WHILE_VALIDATING;
			return CM_ERROR_WHILE_VALIDATING;
		}
/*		printf("Validation Failed on DHCP IP Address Validation\n");*/
	}
   if (section_to_which_it_belongs_to == CM_IP_SECTION && vptr_parameter_ID == (void*)&ip.internet_gateway_address)
   {
      /* If DHCP Client is Enabled then it is not reqd to validate */
		if (!is_an_gateway_address(string_ptr))
      {
         /* Make WAN as Internet Gateway */
         value = get_wan_port_number();
         set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
		   return CM_ERROR_WHILE_VALIDATING;
      }
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, 2, CM_INDEX_FORMAT, (void*)&value, 0);
      if (!value)
      {
         temp = dot2ulong(string_ptr);
         if (!temp)
         {
               /* Make WAN as Internet Gateway */
               value = get_wan_port_number();
               set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
		         return CM_ERROR_WHILE_VALIDATING;
         }
         
		   if (get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, get_insecured_lan_port_number(), CM_STRING_FORMAT, (void*)&ip_address, STRING_LENGTH_FOR_GET)  != CM_GET_SUCCESSFUL)
		   {
            /* Make WAN as Internet Gateway */
            value = get_wan_port_number();
            set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
		      return CM_ERROR_WHILE_VALIDATING;
		   }
		   if (get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, get_insecured_lan_port_number(), CM_STRING_FORMAT, (void*)&subnet_mask, STRING_LENGTH_FOR_GET)  != CM_GET_SUCCESSFUL)
		   {
            /* Make WAN as Internet Gateway */
            value = get_wan_port_number();
            set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
		      return CM_ERROR_WHILE_VALIDATING;
		   }
		   if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, string_ptr, subnet_mask))
		   {	
            /* Make WAN as Internet Gateway */
            value = get_wan_port_number();
            set_parameter(CM_IP_SECTION, (void*)&ip.internet_gateway_port, CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, (void*)&value);
		      return CM_ERROR_WHILE_VALIDATING;
		   }
      }
   }
   else
   if (section_to_which_it_belongs_to == CM_DHCP_SECTION && vptr_parameter_ID == (void*)&dhcp.config.server_ip_address)
   {
		if (!is_an_ip_address(string_ptr))
		{
         /* Now Disbale DHCP Relay Agent */
         value = 0;
         set_parameter(CM_DHCP_SECTION,  (void*)&dhcp.config.relay_agent_enabled, CM_NO_PORT_PARAMETER_PRESENT, CM_INDEX_FORMAT, (void*)&value);
			return CM_ERROR_WHILE_VALIDATING;
		}
   }

/* sudha 19 Aug 1999. For ftp configurable ctrl & data ports */
	if ((section_to_which_it_belongs_to == CM_PROXY_SECTION) && 
		(vptr_parameter_ID == (void*)&proxy_server.ftp_ctrl_conn_port))
	{
		if(get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_ctrl_conn_port, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_ftp, 10) != CM_GET_SUCCESSFUL)
			printf("Get Parameter Failed\n");

			ftp_prev_port_number = atoi(temp_string_for_ftp);
	}

	if ((section_to_which_it_belongs_to == CM_PROXY_SECTION) && 
		(vptr_parameter_ID == (void*)&proxy_server.ftp_data_conn_port))
	{
		if(get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_data_conn_port, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_ftp, 10) != CM_GET_SUCCESSFUL)
			printf("Get Parameter Failed\n");

			ftp_prev_port_number = atoi(temp_string_for_ftp);
	}


#if 0 /* Not Required for Proxy Server */
	if (section_to_which_it_belongs_to == CM_IPX_SECTION && vptr_parameter_ID == (void*)&ipx_class.port[0].network)
	{
		if (strlen(string_ptr) > 8 || strlen(string_ptr) == 0)
			return CM_ERROR_WHILE_VALIDATING;
		if (!is_valid_ipx_network_number(string_ptr))
			return CM_ERROR_WHILE_VALIDATING;
/*		format_the_ipx_network_number(string_ptr);*/
	}
#endif /* Not Required for Proxy Server */
#endif

	if (section_number == CM_NUMBER_OF_SECTIONS - 1)
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
	   if (port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
         {
            if (insert_missing_string_without_port(section_number, lhs_string, string_ptr) != NULL)
            {
					goto end_of_function;
            }
            else
            {
               return CM_NOT_ENOUGH_MEMORY; 
            }
         }
		}
		else
      {
			for(i=1;i<= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
   			if (search_to_start_at == NULL)
            {
               if (insert_missing_string_with_port(section_number, port_number, lhs_string, string_ptr) != NULL)
               {
						goto end_of_function;
               }
               else
               {
                  return CM_NOT_ENOUGH_MEMORY; 
               }
            }
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
      }
	}
	else
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
		if(port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
 			if (search_to_start_at == NULL)
         {
            if (insert_missing_string_without_port(section_number, lhs_string, string_ptr) != NULL)
            {
					goto end_of_function;
            }
            else
            {
               return CM_NOT_ENOUGH_MEMORY; 
            }
         }
		}
		else
      {
			for(i=1;i<=CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
				if (search_to_start_at == NULL)
            {
               if (insert_missing_string_with_port(section_number, port_number, lhs_string, string_ptr) != NULL)
               {
						goto end_of_function;
               }
               else
               {
                  return CM_NOT_ENOUGH_MEMORY; 
               }
            }
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
      }
	}



	/* Resolving InterDependencies ... */
end_of_function:

	switch(section_to_which_it_belongs_to)
	{
		case CM_WAN_SECTION:
			if (vptr_parameter_ID == (void*)&wan.port[0].port_speed)
			{
				resolve_port_wan_speed(port_number, temp_buffer);
			}
#if 0
         else
         if (vptr_parameter_ID == (void*)&wan.port[0].modem_info.configured_auto_answer && port_number < number_of_ports) 
         {
            set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].connection_method.answering_enabled, port_number, format_got, vptr_new_value);
            set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].connection_method.answering_enabled, port_number, format_got, vptr_new_value);
         }
#endif
         else
         if (vptr_parameter_ID == (void*)&wan.port[0].enabled)
         {
/* Added on 08/12/1997 to fix a bug (Too Few Buffers.....) when we enable
   wan port using WEB... */
            if ((format_got == CM_STRING_FORMAT && (strcmpi(string_ptr, "enabled") == 0)) || (format_got == CM_INDEX_FORMAT && *((BYTE*)vptr_new_value)) )
            {
               /* Is PPP enabled */
               if (get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&ppp_enabled, 0) != CM_GET_SUCCESSFUL)
               {
                  ppp_enabled = FALSE;
               }

               /* Is Slip enabled */
               if (get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&slip_enabled, 0) != CM_GET_SUCCESSFUL)
               {
                  slip_enabled = FALSE;
               }

               /* If either ppp or slip is enabled don't do anything */
               if (ppp_enabled || slip_enabled)
                  break;
               
               /* If none of them are enabled then enable PPP by default */
               value = 1;
               set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&value);
            }
            else
            {
               /* Disable PPP */
               value = 0;
               set_parameter_by_name(CM_PPP_SECTION, "PPP Port", port_number, CM_INDEX_FORMAT, (void*)&value);

               /* Disable SLIP */
               value = 0;
               set_parameter_by_name(CM_PPP_SECTION, "PPP Port SLIP", port_number, CM_INDEX_FORMAT, (void*)&value);
            }
/* ...Added on 08/12/1997 to fix a bug (Too Few Buffers.....) when we enable
   wan port using WEB*/
         }
         if (vptr_parameter_ID == (void*)&wan.port[0].modem_info.configured_auto_answer)
			{
            if ((format_got == CM_STRING_FORMAT && !strcmpi(string_ptr, "enabled")) || (format_got == CM_INDEX_FORMAT && *((BYTE*)vptr_new_value)) )
				{
					/* Don't do anything */
				}
				else
				{
					/* If it is dialing then check if both SLIP and PPP are enabled 
					   if so enable only PPP
					*/
					get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&ppp_enabled, 0);
					get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&slip_enabled, 0);
					if (ppp_enabled && slip_enabled)
					{
						/* Switch off SLIP */
						slip_enabled = 0;
						set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&slip_enabled);
					}
				}
			}

			break;
		case CM_IP_SECTION:
         if (vptr_parameter_ID == (void*)&ip.port[0].config.dhcp_client_enabled)
         {
            if ((format_got == CM_STRING_FORMAT && strcmpi(string_ptr, "enabled")) || (format_got == CM_INDEX_FORMAT && *((BYTE*)vptr_new_value)))   
            {
               /* Somebody trying to enable the DHCP client hence Zero out 
                  Internet LAN's IP Address and Subnet Mask
               */
               strcpy(temp_ip_address, "0.0.0.0");
               set_parameter_by_name(CM_IP_SECTION, "IP Port Address", 1/*Internet LAN*/, CM_STRING_FORMAT, (void*)temp_ip_address);
               set_parameter_by_name(CM_IP_SECTION, "IP Port Address Mask", 1/*Internet LAN*/, CM_STRING_FORMAT, (void*)temp_ip_address);
            }
         }
         if (vptr_parameter_ID == (void*)&ip.port[0].config.bootp_enabled)
         {
            if ( (format_got == CM_STRING_FORMAT && strcmpi(string_ptr, "enabled")) || (format_got == CM_INDEX_FORMAT && *((BYTE*)vptr_new_value)) )
            {
               i = 1;
/*             set_parameter_by_name(CM_IP_SECTION, "IP Port BOOTP", 0, CM_INDEX_FORMAT, (void*)&i);*/
            }
            else
            {
               i = 0;
               for(j=0;j<=3;++j)
                set_parameter_by_name(CM_IP_SECTION, "IP Port BOOTP", j, CM_INDEX_FORMAT, (void*)&i);
            }
         }
         else
			if (vptr_parameter_ID == (void*)&ip.port[0].config.ip_address)
			{
				resolve_port_ip_address(port_number, format_got, vptr_new_value);
			}
			else
			if (vptr_parameter_ID == (void*)&ip.port[0].config.point_to_point_remote_ip_address)
			{
				resolve_port_remote_ip_addres(port_number, vptr_new_value);
			}
			break;
#if 0 /* Not Required for Proxy Server */
		case CM_IPX_SECTION:
			if (vptr_parameter_ID == (void*)&ipx_class.port[0].network  && port_number > 3)
			{
				resolve_port_ipx_network_number(port_number, vptr_new_value);
			}
			else
			if (port_number == 0 && vptr_parameter_ID == (void*)&ipx_class.port[0].learn_network_address)
			{
				resolve_ipx_autolearn(vptr_new_value, format_got);
			}
			break;
#endif
		case CM_PPP_SECTION:
			if (vptr_parameter_ID == (void*)&ppp.port[0].slip_enabled)
			{
				if ((format_got == CM_INDEX_FORMAT && *((BYTE*)vptr_new_value))  || ((format_got == CM_STRING_FORMAT) && !strcmpi((BYTE*)vptr_new_value, "enabled")))
					strcpy(temp_buffer, "2014");
				else
					strcpy(temp_buffer, "1500");
				set_parameter_by_name(CM_LSL_SECTION, "LSL Port Maximum Buffer Size", port_number+number_of_lan_ports, CM_STRING_FORMAT, temp_buffer);
			}
#if 0   /* Not Reqd for Proxy... */
			else
			if (vptr_parameter_ID == (void *)&ppp.port[0].client_only)
			{
				if ((format_got == CM_INDEX_FORMAT && *((BYTE*)vptr_new_value))  || ((format_got == CM_STRING_FORMAT) && !strcmpi((BYTE*)vptr_new_value, "enabled")))
				{
					get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 0, CM_STRING_FORMAT, (void*)temp_ip_address, STRING_LENGTH_FOR_GET);
					set_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 0, CM_STRING_FORMAT, (void*)temp_ip_address);

               get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.bootp_enabled, 0, CM_INDEX_FORMAT, (void*)&value, 0);
               i = value;
               set_parameter_by_name(CM_IP_SECTION, "IP Port BOOTP", port_number+1, CM_INDEX_FORMAT, (void*)&i);
				}
            else
            {
               i = 0;
               set_parameter_by_name(CM_IP_SECTION, "IP Port BOOTP", port_number+1, CM_INDEX_FORMAT, (void*)&i);
            }
			}
#endif /* ...Not Reqd for Proxy */

			else
			if (vptr_parameter_ID == (void*)&ppp.port[0].dial_on_demand && ((format_got == CM_STRING_FORMAT && !strcmpi((BYTE*)vptr_new_value, "enabled")) || (format_got == CM_INDEX_FORMAT && (*((BYTE*)vptr_new_value) == 1))))
			{
				resolve_dial_on_demand(port_number);
			}
         break;
      case CM_VJC_SECTION:
			if (vptr_parameter_ID == (void*)&vjc.port[0].vjc_compression_enabled && ((format_got == CM_STRING_FORMAT && !strcmpi((BYTE*)vptr_new_value, "enabled")) || (format_got == CM_INDEX_FORMAT && (*((BYTE*)vptr_new_value) == 1))))
         {
            node = get_ppp_string("PPP Port Option", port_number, "IPCP", "Compression");
            if (node == NULL)
            {
               insert_missing_string_with_port(CM_PPP_SECTION, port_number, "PPP Port Option", vjc_string);
               insert_missing_string_with_port(CM_PPP_SECTION, port_number, "PPP Port Remote Option", vjc_string);
            }
         }
         else
         {
            remove_ppp_string(port_number);
         }
         break;

/* For FTP Configurable Port Numbers. Ravi 26/08/99 */
      case CM_PROXY_SECTION:
			if (vptr_parameter_ID == (void*)&proxy_server.ftp_ctrl_conn_port)
         {
				ftp_ctrl = 1;				
				set_ftp_port_numbers_in_global_structure(ftp_ctrl, ftp_prev_port_number);
			}
      
			if (vptr_parameter_ID == (void*)&proxy_server.ftp_data_conn_port)
         {
				ftp_ctrl = 0;				
				set_ftp_port_numbers_in_global_structure(ftp_ctrl, ftp_prev_port_number);
			}
         
		default:
			break;
	}
	/* ... Resolving InterDependencies */


	return CM_SET_SUCCESSFUL;
}

enum CM_SET_RESULTS set_parameter_by_name(enum CM_SECTIONS section_to_which_it_belongs_to, 
														BYTE* bptr_lhs_string,
								 					   USHORT port_number, USHORT format_got,
								 					 	void* vptr_new_value)
{
 	BYTE section_number, *string_ptr, i, temp_buffer[200], port_number_matched, temp[100];
	UNION_RETURN_VALUE*  uptr_new_value;
	PARAMETER_NODE* search_to_start_at;
   BYTE* local_byte, wan_enabled;
   USHORT* local_ushort;
   ULONG* local_ulong;
   ULONG value_to_validate;
   BYTE number_of_ports, authentication_type;

	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{ 
		printf("SET:Configuration Manager Owned by None \n");
		return ;
	}	 

	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return ;
	}	 


   number_of_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS) + lsl_control(GET_NUMBER_OF_LAN_PORTS);

   /* Do Not allow Frame To be changed for IP-WAN Ports */
   if (port_number > 0 && !(strcmpi(bptr_lhs_string, "IP Port Frame Type")))
   {
      return CM_SET_SUCCESSFUL;
   }

	uptr_new_value = (UNION_RETURN_VALUE*)vptr_new_value;
	/* Get the section to which this field belongs to */
	section_number = get_the_section_number(section_to_which_it_belongs_to);

/* The following code was removed by Naveen. This is taken care in
   get_parameter  and for setting dependencies get_parameter
   will not help. get_parameter_by_name will help us to make
   dependencies check
*/
#if 0
	/* If wan port 'x' is disabled don't save any parameters for PPP port
	   'x'
	*/

   if (section_to_which_it_belongs_to == CM_PPP_SECTION)
   {
      /* Get the status of wan port */
      if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&wan_enabled, 0) == CM_GET_SUCCESSFUL)
      {
         if (!wan_enabled)
         {
            return CM_ERROR_WHILE_VALIDATING;
         }
      }
      else
         return CM_ERROR_WHILE_VALIDATING;
   }
#endif

   if(!strcmpi(bptr_lhs_string, "MLPPP"))
   {
		switch(format_got)
		{
			case CM_STRING_FORMAT: 	
				string_ptr = uptr_new_value->string;
				if (!strcmpi(string_ptr, "enabled"))
            {
               if (is_mlppp_enabled())
               {
                  return CM_SET_SUCCESSFUL;
               }
               else
               {
                  insert_mlppp_strings();
                  return CM_SET_SUCCESSFUL;
               }
            }
				else
            {
               if (!is_mlppp_enabled())
               {
                  return CM_SET_SUCCESSFUL;
               }
               else
               {
                  remove_mlppp_strings();
                  return CM_SET_SUCCESSFUL;
               }
            }
               
				break;
			case CM_INDEX_FORMAT:
         	local_byte = (BYTE*)vptr_new_value;
				if (*local_byte)
            {
               if (is_mlppp_enabled())
               {
                  return CM_SET_SUCCESSFUL;
               }
               else
               {
                  insert_mlppp_strings();
                  return CM_SET_SUCCESSFUL;
               }
            }
				else
            {
               if (!is_mlppp_enabled())
               {
                  return CM_SET_SUCCESSFUL;
               }
               else
               {
                  remove_mlppp_strings();
                  return CM_SET_SUCCESSFUL;
               }
            }
				break;
			default:
				break;
		}
   }
   else
	if (!strcmpi(bptr_lhs_string, "PAP"))
	{
		switch(format_got)
		{
			case CM_STRING_FORMAT: 	
				string_ptr = uptr_new_value->string;
				if (!strcmpi(string_ptr, "enabled"))
					authentication_type = CM_ENABLE_PAP;
				else
					authentication_type = CM_DISABLE_PAP;
				break;
			case CM_INDEX_FORMAT:
         	local_byte = (BYTE*)vptr_new_value;
				if (*local_byte)
					authentication_type = CM_ENABLE_PAP;
				else
					authentication_type = CM_DISABLE_PAP;
				break;
			default:
				break;
		}
		if (authentication_type == CM_ENABLE_PAP)
		{
		}
		else
		{
		}
		set_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1],port_number, &port_number_matched, authentication_type);
		return CM_SET_SUCCESSFUL;
	}
	else
	if (!strcmpi(bptr_lhs_string, "CHAP"))
	{
		switch(format_got)
		{
			case CM_STRING_FORMAT: 	
				string_ptr = uptr_new_value->string;
				if (!strcmpi(string_ptr, "enabled"))
					authentication_type = CM_ENABLE_CHAP;
				else
					authentication_type = CM_DISABLE_CHAP;
				break;
			case CM_INDEX_FORMAT:
         	local_byte = (BYTE*)vptr_new_value;
				if (*local_byte)
					authentication_type = CM_ENABLE_CHAP;
				else
					authentication_type = CM_DISABLE_CHAP;
				break;
			default:
				break;
		}
		if (authentication_type == CM_ENABLE_CHAP)
		{
		}
		else
		{
		}
		set_authentication_method(search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1],port_number, &port_number_matched, authentication_type);
		return CM_SET_SUCCESSFUL;
	}

	switch(format_got)
	{
	  	case CM_STRING_FORMAT:
			string_ptr = uptr_new_value->string;
	  		break;
		case CM_BYTE_FORMAT:
         local_byte = (BYTE*)vptr_new_value;
			sprintf(temp_buffer, "%d\0", *(local_byte));
			string_ptr = temp_buffer;
         value_to_validate = (ULONG)(*local_byte);
			break;
      case CM_INDEX_FORMAT:
         local_byte = (BYTE*)vptr_new_value;
#if 0 /* Not Required for Proxy Server */
			if (strcmpi(bptr_lhs_string, "spanning tree port state") == 0)
			{
				/*Then this is Spanning Tree State Field*/
				if(*(local_byte) == 0)
					strcpy(temp_buffer, "disable");
				else
				if(*(local_byte) == 1)
					strcpy(temp_buffer, "listening");
				else
				if(*(local_byte) == 2)
					strcpy(temp_buffer, "learning");
				else
				if(*(local_byte) == 3)
					strcpy(temp_buffer, "blocking");
				else
				if(*(local_byte) == 4)
					strcpy(temp_buffer, "forwarding");
				else                     
				{
					printf("Spanning Tree State Field got a invalid value, assuming default (disable)\n");
					strcpy(temp_buffer, "disable");
				}
			}
			else
#endif /* Not Required for Proxy Server */
			if(strcmpi(bptr_lhs_string, "wan port speed") == 0)
			{
				if (*(local_byte) == 0)
					strcpy(temp_buffer, "300");
				else
				if (*(local_byte) == 1)
					strcpy(temp_buffer, "600");
				else
				if (*(local_byte) == 2)
					strcpy(temp_buffer, "1200");
				else
				if (*(local_byte) == 3)
					strcpy(temp_buffer, "2400");
				else
				if (*(local_byte) == 4)
					strcpy(temp_buffer, "4800");
				else
				if (*(local_byte) == 5)
					strcpy(temp_buffer, "9600");
				else
				if (*(local_byte) == 6)
					strcpy(temp_buffer, "19200");
				else
				if (*(local_byte) == 7)
					strcpy(temp_buffer, "38400");
				else
				if (*(local_byte) == 8)
					strcpy(temp_buffer, "57600");
				else
				if (*(local_byte) == 9)
					strcpy(temp_buffer, "115200");
				else
				if (*(local_byte) == 10)
					strcpy(temp_buffer, "230400");
				else
				if (*(local_byte) == 11)
					strcpy(temp_buffer, "460800");
				else
				{
					printf("Invalid BaudRate Index, assuming default (19200)\n");
					strcpy(temp_buffer, "19200");
				}
			}
			else
			if(strcmpi(bptr_lhs_string, "wan port synchronous speed") == 0)
			{
				if(*(local_byte) == 0)
					strcpy(temp_buffer, "4800");
				else
				if(*(local_byte) == 1)
					strcpy(temp_buffer, "9600");
				else
				if(*(local_byte) == 2)
					strcpy(temp_buffer, "19200");
				else
				if(*(local_byte) == 3)
					strcpy(temp_buffer, "38400");
				else
				if(*(local_byte) == 4)
					strcpy(temp_buffer, "57600");
				else
				if(*(local_byte) == 5)
					strcpy(temp_buffer, "64000");
				else
				if(*(local_byte) == 6)
					strcpy(temp_buffer, "128000");
				else
				if(*(local_byte) == 7)
					strcpy(temp_buffer, "256000");
				else
				if(*(local_byte) == 8)
					strcpy(temp_buffer, "512000");
				else
				if(*(local_byte) == 9)
					strcpy(temp_buffer, "102400");
				else
				if(*(local_byte) == 10)
					strcpy(temp_buffer, "1536000");
				else
				if(*(local_byte) == 11)
					strcpy(temp_buffer, "2048000");
				else
				{
					printf("Invalid clock speed, assuming default (128000)\n");
					strcpy(temp_buffer, "128000");
				}
			}
			else
			if(strcmpi(bptr_lhs_string, "ip port frame type")==0)
			{
				if (*(local_byte) == 0)
					strcpy(temp_buffer, "TYPE_II");
				else
					strcpy(temp_buffer, "SNAP");
			}
			else
			if (*(local_byte))
         {
/*            printf("SET:Enabled\n");*/
				strcpy(temp_buffer, "enabled");
         }
			else
         {
/*            printf("SET:Disabled\n");*/
				strcpy(temp_buffer, "disabled");
         }
			string_ptr = temp_buffer;
			break;
		case CM_USHORT_FORMAT:
         local_ushort = (USHORT*)vptr_new_value;
			sprintf(temp_buffer, "%d\0", *(local_ushort));
			string_ptr = temp_buffer;
         value_to_validate = (USHORT)(*local_ushort);
			break;
		case CM_ULONG_FORMAT:
         local_ulong = (ULONG*)vptr_new_value;
			sprintf(temp_buffer, "%d\0", *(local_ulong));
			string_ptr = temp_buffer;
         value_to_validate = (ULONG)(*local_ulong);
			break;
		default:
			printf("Format of the value to set is unknown");
			return CM_UNKNOWN_FORMAT;
	}
	section_number = get_the_section_number(section_to_which_it_belongs_to);

	if (!strcmpi(bptr_lhs_string, "IP Default Route"))
	{
		strcpy(temp, string_ptr);
		temp[strlen(temp)-2] = 0;
		if (!is_an_ip_address(temp))
		{
			return CM_ERROR_WHILE_VALIDATING;
		}
	}

	/* Formatting for Some string like modem name etc ... */
	convert_to_lower_case(string_ptr);
	if (!strcmpi(bptr_lhs_string, "wan port modem type"))
	{
		process_back_slash(string_ptr);
	}
	/* ... Formatting for Some string like modem name etc */

#if 0
	/* Verification in progress ...*/
	i = 0;
	while(field_validation_lib[i].verification_function != NULL)
	{
		if (offset == field_validation_lib[i].offset && section_to_which_it_belongs_to == field_validation_lib[i].section_type)
		{
			if (! field_validation_lib[i].verification_function(field_validation_lib[i].min_limit, field_validation_lib[i].max_limitm ulong_value, value_to_validate))
				return CM_ERROR_WHILE_VALIDATING;
		}
	}
#endif
	/* Resolving InterDependencies ...*/


	if (section_number == CM_NUMBER_OF_SECTIONS - 1)
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
	   if (port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(bptr_lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
         {
            if (insert_missing_string_without_port(section_number, bptr_lhs_string, string_ptr) != NULL)
            {
   				return CM_SET_SUCCESSFUL;
            }
            else
            {
               return CM_NOT_ENOUGH_MEMORY; 
            }
         }
		}
		else
			for(i=1;i<= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(bptr_lhs_string, search_to_start_at, NULL, string_ptr, port_number, &port_number_matched);
				if (search_to_start_at == NULL)
            {
               if (insert_missing_string_with_port(section_number, port_number, bptr_lhs_string, string_ptr) != NULL)
               {
   	   			return CM_SET_SUCCESSFUL;
               }
               else
               {
                  return CM_NOT_ENOUGH_MEMORY; 
               }
            }
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
	}
	else
	{
		search_to_start_at = sptr_to_each_section_in_the_configuration[section_number];
		if(port_number == CM_NO_PORT_PARAMETER_PRESENT)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(bptr_lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
         {
            if (insert_missing_string_without_port(section_number, bptr_lhs_string, string_ptr) != NULL)
            {
   	   	   return CM_SET_SUCCESSFUL;
            }
            else
            {
               return CM_NOT_ENOUGH_MEMORY; 
            }
         }
		}
		else
			for(i=1;i<=CM_MAXIMUM_NUMBER_OF_PORTS;++i)
			{
				search_to_start_at = match_the_lhs_string_in_the_linked_list_and_write_the_new_value(bptr_lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_number+1], string_ptr, port_number, &port_number_matched);
				if (search_to_start_at == NULL)
            {
               if (insert_missing_string_with_port(section_number, port_number, bptr_lhs_string, string_ptr) != NULL)
               {
      	   	   return CM_SET_SUCCESSFUL;
               }
               else
               {
                  return CM_NOT_ENOUGH_MEMORY; 
               }
            }
				if (port_number_matched && (port_number != CM_NO_PORT_PARAMETER_PRESENT))
					break;
			}
	}
	return CM_SET_SUCCESSFUL;
}


BYTE check_whether_value_is_with_in_limits(USHORT lower_limit, ULONG upper_limit, ULONG value)
{
/*   printf("Checking... %d - %d - %d\n", lower_limit, upper_limit, value);*/
	if (value >= lower_limit && value <= upper_limit)
		return TRUE;
	else
		return FALSE;
}

enum CM_WRITE_RESULTS cm_write_configuration()
{
   BYTE temp_buffer1[20], temp_buffer2[20], temp, dns_addr[20];
   ULONG value1, value2;
   
	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{ 
		printf("SET:Configuration Manager Owned by None \n");
		return ;
	} 
	 
#if 1
   get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 1, CM_STRING_FORMAT, (void*)temp_buffer1, 100);
   get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, 1, CM_STRING_FORMAT, (void*)temp_buffer2, 100);
   value1 = dot2ulong(temp_buffer1);
   value2 = dot2ulong(temp_buffer2);
   if (!value1 || !value2)
   {
      temp = 1;
      set_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, 1, CM_INDEX_FORMAT, (void*)&temp);
   }
#endif

   enable_either_ppp_or_slip();

   update_the_number_of_filters_present();

/* Added by Sreelu for DNS */
/* DNS Server Address1 & DNS Server Address2 are same */

      get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&dns_addr[0], 20);				

      set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address2",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &dns_addr);
	
	
/* Added by Sreelu for DNS */

   cm_convert_tag_list_to_cnf_format(NULL);
   printf("Flash Write in Progress...\n");
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon the configuration is not written through configuration manager */
		return CM_WRITE_SUCCESS;
	}	 
	cm_start_flash_write (cfgmgr_class.sptr_to_first_node);
	cm_wait_for_flash_write_completion() ;

	*DownloadFlag = WARM_BOOT_MODE;
	Reset();
	return CM_WRITE_SUCCESS;
}

/* ---------------------------------------------------------------------- */
BYTE *cm_last_allocated_block, *cm_last_allocated_block_destination ;
int cm_last_allocated_block_length ;


void cm_start_flash_write(PARAMETER_NODE* sptr_list)
{
	USHORT accumulated_crc = 0xFFFF, i;
	PARAMETER_NODE* sptr_temp, *sptr_next_node = cfgmgr_class.sptr_to_first_node;
	int this_string_length ;
	ULONG setup_length = 0L ;
	HeaderType *sptr_dram_setup_header, *sptr_flash_setup_header = (HeaderType *)FL_CFG_HDR ;
	BYTE *sptr_flash_setup = (BYTE *)sptr_flash_setup_header->DnLdAddr ;
	BYTE temp_header[512] ;

	/* Make sure this is done before anything */
	memcpy (&temp_header[0], sptr_flash_setup_header, 512) ;

	cm_last_allocated_block = NULL ;
	cm_last_allocated_block_length = 0 ;
	cm_last_allocated_block_destination = NULL ;

	while (sptr_next_node != NULL)
	{
		this_string_length = strlen(&sptr_next_node->parameter[0]) ;
		setup_length = setup_length + (ULONG) this_string_length ;
		cm_flash_write_block(&sptr_next_node->parameter[0], sptr_flash_setup, this_string_length, FALSE) ;
		sptr_flash_setup += (ULONG)this_string_length ;
		accumulated_crc = update_crc(accumulated_crc, &sptr_next_node->parameter[0], this_string_length) ;

		sptr_temp = sptr_next_node->next ;
		free (sptr_next_node) ;
		sptr_next_node = sptr_temp ;
		if (sptr_next_node->next == NULL)
		{
		}
	}
	cm_flash_write_block ("\x0\x0", sptr_flash_setup, 2, TRUE) ;
/*	cm_flash_write_block ("\x0\x0", sptr_flash_setup, 2, FALSE) ;*/
	setup_length += 2L ;

	accumulated_crc = update_crc(accumulated_crc, "\x0\x0\x0\x0", 4) ;

	sptr_dram_setup_header = (HeaderType *)&temp_header[0] ;

	sptr_dram_setup_header->CodeLength = setup_length ;
	sptr_dram_setup_header->CRC = accumulated_crc ;
	cm_flash_write_block ((BYTE *)sptr_dram_setup_header, (BYTE *)FL_CFG_HDR, 512, TRUE) ;

   for ( i = 0 ; i < 0xffff ; ++i);
}


void cm_last_setup_block_written ()
{
}

/*
	This is to be called only from Telnet.
	length can never be more than 512
*/
int cm_flash_write_block(BYTE *bptr_src, BYTE *bptr_dest, int length, enum BOOLEAN last_block)
{
	int number_of_bytes_to_copy = length ;

	if (cm_last_allocated_block == NULL)
	{
		cm_last_allocated_block = malloc (512) ;
		if (cm_last_allocated_block == NULL)
		{
			return (0) ;
		}
		cm_last_allocated_block_length = 0 ;
		cm_last_allocated_block_destination = bptr_dest ;
	}

	if ((512 - cm_last_allocated_block_length) < length)
	{
		number_of_bytes_to_copy = 512 - cm_last_allocated_block_length ;
		memcpy (cm_last_allocated_block+cm_last_allocated_block_length, bptr_src, number_of_bytes_to_copy) ;
		schedule_flash_write (cm_last_allocated_block, cm_last_allocated_block_destination, 512, NULL, cm_last_allocated_block) ;
		cm_last_allocated_block = malloc (512) ;
		if (cm_last_allocated_block == NULL)
		{
			return (0) ;
		}
		cm_last_allocated_block_length = 0 ;
		bptr_src += number_of_bytes_to_copy ;
		number_of_bytes_to_copy = length - number_of_bytes_to_copy ;
		cm_last_allocated_block_destination += 512 ;
	}
	memcpy (cm_last_allocated_block+cm_last_allocated_block_length, bptr_src, number_of_bytes_to_copy) ;
	cm_last_allocated_block_length += number_of_bytes_to_copy ;
	if (last_block == TRUE)
	{
		schedule_flash_write (cm_last_allocated_block, cm_last_allocated_block_destination, 512, cm_last_setup_block_written, cm_last_allocated_block) ;
		cm_last_allocated_block = NULL ;
		cm_last_allocated_block_length = 0 ;
		cm_last_allocated_block_destination = NULL ;
	}
}

void cm_wait_for_flash_write_completion ()
{
	int i = 0 ;

	printf ("Waiting for flash write to complete.....\n") ;
	while (i < NUMBER_OF_FLASH_PROMS)
	{
		if (flash_accessibility[i] != FLASH_ACCESSIBLE)
		{
			i = 0 ;
		}
		else
			i++ ;
	}
}

PARAMETER_NODE* insert_missing_string_without_port(BYTE section_number, BYTE* lhs_string, BYTE* rhs_string)
{
   ULONG max_parameter_length;
	PARAMETER_NODE* new_node, *next_section_first_node, *current_section_last_node, *temp_node;

   max_parameter_length = 200;
   new_node = (PARAMETER_NODE*) malloc (sizeof (ULONG) * 2 + max_parameter_length) ;
   if (new_node == NULL)
   {
      printf("Not Enough Memory to insert \n");
      return NULL;
   }
   if (section_number == CM_NUMBER_OF_SECTIONS-1)
   {
      temp_node = sptr_to_each_section_in_the_configuration[section_number];
      while (temp_node->next)
         temp_node = temp_node->next;
      temp_node->next = new_node;
      new_node->previous = temp_node;
      new_node->next = NULL;
   }
   else
   {
      next_section_first_node = sptr_to_each_section_in_the_configuration[section_number+1];
      current_section_last_node = next_section_first_node->previous;
      new_node->next = next_section_first_node;
      new_node->previous = current_section_last_node;
      next_section_first_node->previous = new_node;
      current_section_last_node->next = new_node;
   }

   strcpy(new_node->parameter, lhs_string);
   strcat(new_node->parameter, " = ");
   strcat(new_node->parameter, rhs_string);
	strcat(new_node->parameter, "\n");
   return new_node;
}

PARAMETER_NODE* insert_missing_string_with_port(BYTE section_number, BYTE port_number, BYTE* lhs_string, BYTE* rhs_string)
{
   ULONG max_parameter_length;
	PARAMETER_NODE* new_node, *next_section_first_node, *current_section_last_node, *temp_node;
   BYTE temp_buffer_2[200];

   max_parameter_length = 200 ;
	new_node = (PARAMETER_NODE*) malloc (sizeof (ULONG) * 2 + max_parameter_length) ;
   if (new_node == NULL)
   {
      printf("Not Enough Memory to insert missing string\n");
      return NULL;
   }
   if (section_number == CM_NUMBER_OF_SECTIONS-1)
   {
      temp_node = sptr_to_each_section_in_the_configuration[section_number];
      while (temp_node->next)
         temp_node = temp_node->next;
      temp_node->next = new_node;
      new_node->previous = temp_node;
      new_node->next = NULL;
   }
   else
   {
      next_section_first_node = sptr_to_each_section_in_the_configuration[section_number+1];
      current_section_last_node = next_section_first_node->previous;
      new_node->next = next_section_first_node;
      new_node->previous = current_section_last_node;
      next_section_first_node->previous = new_node;
      current_section_last_node->next = new_node;
   }

   strcpy(new_node->parameter, lhs_string);
   strcat(new_node->parameter, " = ");
   sprintf(temp_buffer_2, "%02d\0", port_number);
   strcat(new_node->parameter, temp_buffer_2);
   strcat(new_node->parameter, ",");
   strcat(new_node->parameter, rhs_string);
	strcat(new_node->parameter, "\n");
   return new_node;
}



void fill_static_route_struct_from_buffer(STRUCT_STATIC_ROUTE* static_route, BYTE* buffer)
{
   BYTE j,k;
	BYTE portch[10];		
	j = k = 0;

	while (buffer[j] != '=') ++j;

	j += 2;/* Skip '=' sign  and Space */

	while(buffer[j] != ',')
	{
		static_route->ip_address[k++] = buffer[j++];
	}
	static_route->ip_address[k] = 0;

	k = 0;
	j++;
	while(buffer[j] != ',')
	{
		static_route->gateway_address[k++] = buffer[j++];
	}
	static_route->gateway_address[k] = 0;

	k = 0;
	j++;
	while(buffer[j] != ',')
	{
		static_route->address_mask[k++] = buffer[j++];
	}
	static_route->address_mask[k] = 0;

	k = 0;
	j++;
	while(buffer[j] != ',' )
	{
		static_route->metric[k++] = buffer[j++];
	}
	static_route->metric[k] = 0;

	k = 0;
	j++;
	while(buffer[j] != ';' && buffer[j] != '\0')
	{
		static_route->port[k++] = buffer[j++];
	}
	static_route->port[k] = 0;
}  




void dummy_fn()
{
	int i;
	i = 0;
}

/*                    Resolving Interdependencies Functions ...            */
void resolve_port_wan_speed(BYTE port_number, void* vptr_new_value)
{
   BYTE number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);
	set_parameter(CM_LSL_SECTION, (void*)&lsl.port[0].rfc1213_ifEntry.ifSpeed, port_number+number_of_lan_ports, CM_STRING_FORMAT, vptr_new_value);
}

#if 0 /* Not Required for Proxy Server */
void resolve_ipx_autolearn(void* vptr_new_value, USHORT format_got)
{
	set_parameter(CM_IPX_SECTION, (void*)&ipx_class.port[0].learn_network_address, 1, format_got, vptr_new_value);
	set_parameter(CM_IPX_SECTION, (void*)&ipx_class.port[0].learn_network_address, 2, format_got, vptr_new_value);
	set_parameter(CM_IPX_SECTION, (void*)&ipx_class.port[0].learn_network_address, 3, format_got, vptr_new_value);
}

void resolve_port_ipx_network_number(USHORT port_number, void* vptr_new_value)
{
	modify_ppp_string("PPP Port Option", port_number-CM_NUMBER_OF_VIRTUAL_IPX_PORTS, "IPXCP", "Network Number", (BYTE*)vptr_new_value);
	modify_ppp_string("PPP Port Remote Option", port_number-CM_NUMBER_OF_VIRTUAL_IPX_PORTS, "IPXCP", "Network Number", (BYTE*)vptr_new_value);
}
#endif /* Not Required for Proxy Server */

void resolve_port_ip_address(USHORT port_number, USHORT format_got, void* vptr_new_value)
{
	USHORT number_of_wan_ports, i ;
	BYTE  value, temp, number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);

   if (port_number > number_of_lan_ports-1)
	   modify_ppp_string("PPP Port Option", port_number-number_of_lan_ports, "IPCP", "IP Address", (BYTE*)vptr_new_value);

	if (port_number == 0)
	{
		set_parameter_by_name(CM_SNMP_SECTION, "SNMP Local Internet Address", CM_NO_PORT_PARAMETER_PRESENT, format_got, vptr_new_value);

#if 0
		/* For each client only port, set the Local IP address to the LAN Port
		IP address */
		number_of_wan_ports = lsl_control (GET_NUMBER_OF_WAN_PORTS) ;
		for (i = 1 ; i <= number_of_wan_ports ; i++)
		{
			get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].client_only, i-1, CM_INDEX_FORMAT, (void*)&value, 0);
			if (value)
				/* set the local IP address to the LAN ip address */
			{
				temp = 1 ;
				set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, i, CM_STRING_FORMAT, vptr_new_value);
				set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.remote_access_enabled, i, CM_INDEX_FORMAT, (void*)&temp);
			}
			else
			{
				temp = 0 ;
				set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.remote_access_enabled, i, CM_INDEX_FORMAT, (void*)&temp);
			}
		}
#endif
	}
}

void	resolve_port_remote_ip_addres(USHORT port_number, void* vptr_new_value)
{
   BYTE number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);   
   if (port_number == number_of_lan_ports)
   	modify_ppp_string("PPP Port Remote Option", port_number-number_of_lan_ports, "IPCP", "IP Address", (BYTE*)vptr_new_value);
}

void modify_ppp_string(BYTE* string1, BYTE port_number, BYTE* string2, BYTE* string3, BYTE* new_string)
{
	PARAMETER_NODE* node;
	USHORT string_length, i;

	node = get_ppp_string(string1, port_number, string2, string3);
	if (!node)
		return;

	string_length = strlen(node->parameter);
	i = string_length - 1;
	while(node->parameter[i] != ',')
	{
		i--;
	}
	node->parameter[i+1] = 0;
	strcat(node->parameter, new_string);
	strcat(node->parameter, "\n");
}

PARAMETER_NODE* get_ppp_string(BYTE* string1, BYTE port_number, BYTE* string2, BYTE* string3)
{
	BYTE buffer[60];
	PARAMETER_NODE* search_to_start_at;

	sprintf(buffer, "%s = %02d\0", string1, port_number);

	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_PPP_SECTION];
	while (search_to_start_at && search_to_start_at != sptr_to_each_section_in_the_configuration[CM_PPP_SECTION+1])
	{
		search_to_start_at = search_to_start_at->next;
#if 0
		if (!strstr(buffer, search_to_start_at->parameter)
	    	&& !strstr(string2, search_to_start_at->parameter)
		 	&& !strstr(string3, search_to_start_at->parameter))
#endif
      if ((strstr (search_to_start_at->parameter, buffer)) &&
          (strstr (search_to_start_at->parameter, string2)) &&
          (strstr (search_to_start_at->parameter, string3)))
			 	return search_to_start_at;
	}
	return NULL;
}

void resolve_dial_on_demand(BYTE port_number)
{
	BYTE value = 0, string[40];

	set_parameter_by_name(CM_IP_SECTION,  "IP Port RIP Send Responses", port_number+1, CM_INDEX_FORMAT, (void*)&value);
#if 0 /* Not Required for Proxy Server */
	set_parameter_by_name(CM_IPX_SECTION, "IPX Port Periodic RIP", port_number+4, CM_INDEX_FORMAT, (void*)&value);
	set_parameter_by_name(CM_IPX_SECTION, "IPX Port Periodic SAP", port_number+4, CM_INDEX_FORMAT, (void*)&value);
#endif /* Not Required for Proxy Server */
	strcpy(string, "0");
	set_parameter_by_name(CM_IP_SECTION,  "IP RIP Route Aging Timeout", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)string);
#if 0 /* Not Required for Proxy Server */
	set_parameter_by_name(CM_IPX_SECTION, "IPX Port Periodic RIP Tx Timer", port_number+4, CM_STRING_FORMAT, (void*)string);
	set_parameter_by_name(CM_IPX_SECTION, "IPX Port Periodic SAP Tx Timer", port_number+4, CM_STRING_FORMAT, (void*)string);
	set_parameter_by_name(CM_IPX_SECTION, "IPX Port RIP Age Timer", port_number+4, CM_STRING_FORMAT, (void*)string);
	set_parameter_by_name(CM_IPX_SECTION, "IPX Port SAP Age Timer", port_number+4, CM_STRING_FORMAT, (void*)string);
	strcpy(string, "disabled");
	set_parameter_by_name(CM_SPANTREE_SECTION, "Spanning Tree Port State", port_number+2, CM_STRING_FORMAT, (void*)string);
#endif /* Not Required for Proxy Server */
}

/*                    ...Resolving Interdependencies Functions             */


BYTE is_mlppp_enabled()
{
   if (get_ppp_string("PPP Port Option", 0, "LCP", "EPD") != NULL) 
   {
      return TRUE;
   }
   else
   {
      return FALSE;
   }
}

void insert_mlppp_strings()
{
   USHORT number_of_wan_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS), port_number;
   for( port_number = 0 ; port_number < number_of_wan_ports ; ++port_number)
   {
      insert_missing_string_with_port(CM_PPP_SECTION, port_number, "PPP Port Option", "LCP,EPD,19,Auto,Negotiation Not Required,Not Negotiable,H7,03000000000000");
      insert_missing_string_with_port(CM_PPP_SECTION, port_number, "PPP Port Remote Option", "LCP,EPD,19,Auto,Negotiation Not Required,Negotiable,H7,03000000000000");

      insert_missing_string_with_port(CM_PPP_SECTION, port_number, "PPP Port Option", "LCP,MRRU,17,Auto,Negotiation Not Required,Negotiable,D2,1600");
      insert_missing_string_with_port(CM_PPP_SECTION, port_number, "PPP Port Remote Option", "LCP,MRRU,17,Auto,Negotiation Not Required,Negotiable,D2,1600");
   }
}

void remove_mlppp_strings()
{
   PARAMETER_NODE* node;
   USHORT number_of_wan_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS), port_number;
   for( port_number = 0 ; port_number < number_of_wan_ports ; ++port_number)
   {
      node = get_ppp_string("PPP Port Option", port_number, "LCP" ,"EPD");
      if (node)
      {
         node->next->previous = node->previous;
         node->previous->next = node->next;
         free(node);
      }

      node = get_ppp_string("PPP Port Remote Option", port_number, "LCP" ,"EPD");
      if (node)
      {
         node->next->previous = node->previous;
         node->previous->next = node->next;
         free(node);
      }

      node = get_ppp_string("PPP Port Option", port_number, "LCP" ,"MRRU");
      if (node)
      {
         node->next->previous = node->previous;
         node->previous->next = node->next;
         free(node);
      }

      node = get_ppp_string("PPP Port Remote Option", port_number, "LCP" ,"MRRU");
      if (node)
      {
         node->next->previous = node->previous;
         node->previous->next = node->next;
         free(node);
      }

   }
}

void remove_ppp_string(USHORT port_number)
{
   PARAMETER_NODE* node;

   node = get_ppp_string("PPP Port Option", port_number, "IPCP", "Compression");
   if (node)
   {
      node->next->previous = node->previous;
      node->previous->next = node->next;
      free(node);
   }

   node = get_ppp_string("PPP Port Remote Option", port_number, "IPCP", "Compression");
   if (node)
   {
      node->next->previous = node->previous;
      node->previous->next = node->next;
      free(node);
   }

}

/* The Following function enables the the PPP if corr. WAN port is enabled
*/   
void enable_either_ppp_or_slip()
{      
    USHORT port_number;
    BYTE wan_enabled, enabled = 1, not_enabled = 0;
    BYTE slip_enabled, async_enabled, ans_enabled, ppp_enabled;

    for ( port_number = 0 ; port_number < ppp.number_of_ppp_ports ; ++port_number )
    {
       /* Is WAN enabled */
       if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&wan_enabled, 0) != CM_GET_SUCCESSFUL)
       {
           wan_enabled = FALSE;
       }

#if 0
       if(get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&slip_enabled, 0) != CM_GET_SUCCESSFUL)
       {
           slip_enabled = FALSE;
       }
       if(get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&ppp_enabled, 0) != CM_GET_SUCCESSFUL)
       {
           ppp_enabled = FALSE;
       }
       if(get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.configured_auto_answer,port_number, CM_INDEX_FORMAT, (void *)&ans_enabled,  0) != CM_GET_SUCCESSFUL)
       {
           ans_enabled = FALSE;
       }
#endif
       if(get_parameter(CM_WAN_SECTION, (void *)&wan.port[0].asyncport,port_number, CM_INDEX_FORMAT, (void *)&async_enabled, 0) != CM_GET_SUCCESSFUL)
       {
           async_enabled = FALSE;
       }
       if (wan_enabled) 
       {
/* Sreelu 27 Aug 1998  Is Slip Enabled */   

#if 0
          if (async_enabled && !ans_enabled)  /* Async & Dialing */
          {
            if(!slip_enabled)
                set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&enabled);
            if(slip_enabled)
                set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&not_enabled);
          }
          
          if (!async_enabled)  /* If Sync */
          {
                set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&enabled);
                set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&not_enabled);
          }
       }/* End of Wan_enabled */
       else 
       {
         set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&not_enabled);
         set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&not_enabled);
       }
#endif
       if (!async_enabled)  /* If Sync */
       {
             set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&enabled);
             set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&not_enabled);
       }
/* Enable PPP if wan enabled */
       set_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].enabled, port_number, CM_INDEX_FORMAT, (void*)&wan_enabled);
    } /* If WAN Ends */
  }
}

#if PROXY_SERVER

extern USHORT is_the_link_member_of_some_bundle (port_number) ;

char *modem_states[] =
{
   "IDLE",
   "OFFLINE",
   "ONLINE",
   "SEND INIT COMMAND",  /* "SEND COMMAND A", */
   "SEND INIT COMMAND",  /* "SEND COMMAND T", */
   "SEND INIT COMMAND",  /* "SEND COMMAND REST", */
   "WAIT FOR OK",
   "DIAL NUMBER", /* "DIAL A", */
   "DIAL NUMBER", /* "DIAL T", */
   "DIAL NUMBER", /* "DIAL REST", */
   "WAIT FOR CONNECT MESSAGE",
   "WAIT FOR RING",
   "HANGUP DTR DOWN",
   "HANGUP CHECK CD",
   "SEND HANGUP STRING",
   "SEND BREAK",
   "DELAY ONLINE",
   "DTR DIAL LINK DOWN",
   "DTR DIAL DTR UP",
   "DTR DIAL CHECK ONLINE",
   "CALLBACK",
   "ABSENT",
} ;

ULONG proxy_get_local_ip_address (USHORT port_number)
{
   USHORT virtual_port_number ;

   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
   if (virtual_port_number < NUMBER_OF_SERIAL_PORTS)
      port_number = virtual_port_number ;

   return (ip.port[ppp.number_of_lan_ports + port_number].config.ip_address) ;
}

ULONG proxy_get_remote_ip_address (USHORT port_number)
{
   USHORT virtual_port_number ;

   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
   if (virtual_port_number < NUMBER_OF_SERIAL_PORTS)
      port_number = virtual_port_number ;

   return (ip.port[ppp.number_of_lan_ports + port_number].config.point_to_point_remote_ip_address) ;
}

ULONG proxy_get_subnet_mask (USHORT port_number)
{
   USHORT virtual_port_number ;

   virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
   if (virtual_port_number < NUMBER_OF_SERIAL_PORTS)
      port_number = virtual_port_number ;

   return (ip.port[ppp.number_of_lan_ports + port_number].config.subnetmask) ;
}



BYTE get_port_status (USHORT port_number)
{
   int state = wan.port[port_number].modem_info.status.state ;
   USHORT virtual_port_number ;
   BYTE_ENUM (WAN_LINK_STATUS) port_status ;

   if (wan.port[port_number].enabled == FALSE)
      return (DISABLED) ;

   if (state > MDM_STATE_LAST_STATE)
      state = MDM_STATE_LAST_STATE ;

   if ((wan.port[port_number].direct_connect_enabled == TRUE) ||
					   	(!wan.port[port_number].asyncport))
      state = WAN_LINK_UP ;

   switch (state)
   {
      case (MDM_STATE_IDLE) :
         port_status = IDLE ;
         break ;

      case (MDM_STATE_OFFLINE) :
         port_status = OFFLINE ;
         break ;

      case (MDM_STATE_ONLINE) :
      case (MDM_STATE_DELAY_ONLINE) :
         if (ppp.port[port_number].slip_on)
            return (SLIP_CLIENT_UP) ;
         
         if (ppp.port[port_number].state != PPP_OPENED_STATE)
         {
            /* Physical Link up */
            port_status = WAN_LINK_UP ;
         }
         else
         {
#ifdef __MLPPP__
            virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
            if (virtual_port_number >= NUMBER_OF_SERIAL_PORTS)
               virtual_port_number = ppp.port[port_number].virtual_port_number;
            if (mlppp.port[virtual_port_number].ncp[PPP_IP_NCP_STACK_INDEX].state != PPP_OPENED_STATE)
#else
            if (ppp.port[port_number].ncp[PPP_IP_NCP_STACK_INDEX].state != PPP_OPENED_STATE)
#endif
            {
               /* LCP UP */
               port_status = LCP_UP ;
            }
            else
            {
               /* PPP/MLPPP client up */
#ifdef __MLPPP__
               if (is_the_link_member_of_some_bundle (port_number) < NUMBER_OF_SERIAL_PORTS)
                  port_status = MLPPP_CLIENT_UP ;
               else
                  port_status = PPP_CLIENT_UP ;
#else
               port_status = PPP_CLIENT_UP ;
#endif
            }
         }
         break ;

      case (MDM_STATE_CMD_A) :
      case (MDM_STATE_CMD_T) :
      case (MDM_STATE_CMD_REST) :
         port_status = SEND_INIT_COMMAND ;
         break ;

      case (MDM_STATE_WAIT_OK) :
         port_status = WAIT_FOR_OK ;
         break ;

      case (MDM_STATE_DIAL_A) :
      case (MDM_STATE_DIAL_T) :
      case (MDM_STATE_DIAL_REST) :
         port_status = DIAL_NUMBER ;
         break ;

      case (MDM_STATE_WAIT_CONN) :
         port_status = WAIT_FOR_CONNECT ;
         break ;

      case (MDM_STATE_WAIT_RING) :
      case (MDM_STATE_HUP_DTR_DN) :
      case (MDM_STATE_HUP_CHK_CD) :
      case (MDM_STATE_HUP_STR) :
      case (MDM_STATE_BREAK) :
      case (MDM_STATE_DTR_DIAL_LINK_DN) :
      case (MDM_STATE_DTR_DIAL_DTR_DN) :
      case (MDM_STATE_DTR_DIAL_DTR_UP) :
      case (MDM_STATE_DTR_DIAL_CHK_ONLINE) :
      case (MDM_STATE_CALLBACK) :
      case (MDM_STATE_LAST_STATE) :
         port_status = WAN_PORT_STATUS_NUMBER_OF_STATES ;
         break ;
   }
   return ((BYTE) port_status) ;
}


ULONG get_baud_rate (USHORT port_number)
{

	if (wan.port[port_number].asyncport)
	   return (wan.port[port_number].port_speed) ;
	else if (wan.port[port_number].InternalClk)
	   return (wan.port[port_number].sync_port_speed) ;

	return 0;
}


char *get_modem_name (USHORT port_number, char *modem_name_string, int modem_name_string_length)
{
   if (wan.port[port_number].direct_connect_enabled)
   {
      strcpy (modem_name_string, "No Modem - Direct Connection") ;
   }
   else
   {
	   if (wan.port[port_number].asyncport)
   	   strncpy (modem_name_string, wan.port[port_number].modem_info.strings.modem_type, modem_name_string_length-1) ;
		else
			strcpy(modem_name_string, "<Synchronous connection>");
      modem_name_string[modem_name_string_length-1] = 0 ;
   }
   return (modem_name_string) ;
}


char *get_modem_connect_message (USHORT port_number, char *connect_message_string, int connect_message_string_length)
{
   char* temp_ptr;

   strncpy (connect_message_string, &wan.port[port_number].statistics.modem_connect_message[0], connect_message_string_length-1) ;
   connect_message_string[connect_message_string_length-1] = 0 ;

   temp_ptr = strchr(connect_message_string, '\r');
   if (temp_ptr != NULL)
      *temp_ptr = 0;

   return (connect_message_string) ;
}


char *get_ppp_user_name (USHORT port_number, char *user_name, int user_name_length)
{
   strncpy (user_name, ppp.port[port_number].authentication.user_name, user_name_length-1) ;
   user_name[user_name_length-1] = 0 ;

   return (user_name) ;
}

ULONG get_connection_up_time (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_up_time) ;
}

ULONG get_connection_tx_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_bytes_transmitted) ;
}


ULONG get_connection_rx_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_bytes_received) ;
}


ULONG get_aggregate_rx_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_bytes_rxed) ;
}


ULONG get_aggregate_tx_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_bytes_txed) ;
}


ULONG get_number_of_calls (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_calls) ;
}


ULONG get_aggregate_connection_time (USHORT port_number)
{
   return (wan.port[port_number].statistics.aggregate_connection_time) ;
}

/* Vidy added the following 4 functions 31/10/97 */

ULONG get_connection_tx_packet_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_packets_transmitted) ;
}


ULONG get_connection_rx_packet_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_packets_received) ;
}

ULONG get_aggregate_rx_packet_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_packets_rxed) ;
}


ULONG get_aggregate_tx_packet_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_packets_txed) ;
}

#endif



/* ???????????????????????????????????????????????????????????????????????? 
	1. Is string length required for Set operation ? Not Reqd.
	2. sscanf % for ushort and ulong ? max field length.
	3. validation scheme for set_parameter_by_name ? Is it reqd?
	4. If the cfgmgr is owned by none and if the function is called then return ?
	5. validation of ip address is pending.
   ???????????????????????????????????????????????????????????????????????? */

/* Ramana added the following functions for NAT, Filters and Link Control */

/*
 * update_count_in_ini : 
 *        Increments the count in RHS for the given LHS based
 *        on flag which can be CM_INCREMENT_COUNT or CM_DECREMENT_COUNT.
 *
*/
void update_count_in_ini (BYTE *lhs_string, BYTE flag,USHORT port_num)
{
   BYTE   count_value[5];
	ULONG value = 0;

   strcpy(count_value,"0");
	get_parameter_by_name(CM_PROXY_SECTION, 
							lhs_string,
							port_num,
							CM_STRING_FORMAT,
							(void*)&count_value, 5);

   sscanf(count_value,"%lu",&value);
	if (flag == CM_INCREMENT_COUNT)
		value++;
	else {
		value--;
		if (value <= 0) value = 0;
	}
   
   sprintf(count_value,"%lu",value);
	set_parameter_by_name(CM_PROXY_SECTION, 
							lhs_string,
							port_num,
							CM_STRING_FORMAT,
                     (void*)&count_value);
   return;
}


enum TEST_RESULT is_user_defined_port_range_unique(USHORT lower_port,USHORT higher_port,USHORT protocol)
{
	int index1,index2;
	USHORT temp_protocol = 0;
	PARAMETER_NODE *ptr_to_node;
	STRUCT_PROXY_ENTRY proxy_entry;
	STRUCT_PROXY_ENTRY *ptr_to_proxy_entry;
	STRUCT_PROXY_USER_ENTRY proxy_user_entry;
	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_entry;
	
	if ( protocol == 17 || protocol == 1)
		temp_protocol = 11; /* UDP protocol in hex format */	
	
	if ( protocol == 0 )
		temp_protocol = 6; /* TCP protocol in hex format */

	if ( higher_port == 0 )
	{
		index1 = lower_port;
		ptr_to_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy", (void *) &proxy_entry);
		if ( ptr_to_node != NULL )
		{
			ptr_to_proxy_entry = (STRUCT_PROXY_ENTRY *) &proxy_entry;
			while ( ptr_to_proxy_entry != NULL )
			{
				if ( (index1 == ptr_to_proxy_entry->port) && (temp_protocol == ptr_to_proxy_entry->protocol))	
					return PROXY_ENTRY;
				if ( ptr_to_node != NULL )
				   ptr_to_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_node, (void *) &proxy_entry);
				if ( ptr_to_node == NULL )
					break;
				ptr_to_proxy_entry = (STRUCT_PROXY_ENTRY *) &proxy_entry;
			}
		}
	   ptr_to_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy User App", (void *) &proxy_user_entry);
		if (ptr_to_node == NULL)
			return UNIQUE_ENTRY;
		else
		{
			ptr_to_proxy_user_entry = (STRUCT_PROXY_USER_ENTRY *) &proxy_user_entry;
			while ( ptr_to_proxy_user_entry != NULL )
			{
				if ( ptr_to_proxy_user_entry->higher_port == 0 )
				{
					index2 = ptr_to_proxy_user_entry->lower_port;
					if (( index1 == index2 ) && ( temp_protocol == ptr_to_proxy_user_entry->protocol ))	
						return PROXY_RANGE_ENTRY;
				}
				else
				{
					for ( index2 = ptr_to_proxy_user_entry->lower_port;
						index2 <= ptr_to_proxy_user_entry->higher_port;index2++)
					{
						if (( index1 == index2 ) && ( temp_protocol == ptr_to_proxy_user_entry->protocol ))	
							return PROXY_RANGE_ENTRY;
					}
				}
				if ( ptr_to_node != NULL )
				   ptr_to_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_node, (void *) &proxy_user_entry);
			
				if ( ptr_to_node == NULL )
					return UNIQUE_ENTRY;

				ptr_to_proxy_user_entry = (STRUCT_PROXY_USER_ENTRY *) &proxy_user_entry;
			}
		}
	}
	else
	{
		for (index1 = lower_port; index1 <= higher_port; index1++)
		{
		   ptr_to_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy", (void *) &proxy_entry);
			if ( ptr_to_node != NULL )
			{
				ptr_to_proxy_entry = (STRUCT_PROXY_ENTRY *) &proxy_entry;
				while ( ptr_to_proxy_entry != NULL )
				{
					if ( (index1 == ptr_to_proxy_entry->port) && (temp_protocol == ptr_to_proxy_entry->protocol))	
						return PROXY_ENTRY;
					if ( ptr_to_node != NULL )
					   ptr_to_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_node, (void *) &proxy_entry);
					if ( ptr_to_node == NULL )
						break;
					ptr_to_proxy_entry = (STRUCT_PROXY_ENTRY *) &proxy_entry;
				}
			}
	   	ptr_to_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy User App", (void *) &proxy_user_entry);
			if (ptr_to_node == NULL)
				return UNIQUE_ENTRY;
			else
			{
				ptr_to_proxy_user_entry = (STRUCT_PROXY_USER_ENTRY *) &proxy_user_entry;
				while ( ptr_to_proxy_user_entry != NULL )
				{
					if ( ptr_to_proxy_user_entry->higher_port == 0 )
					{
						index2 = ptr_to_proxy_user_entry->lower_port;
						if (( index1 == index2 ) && ( temp_protocol == ptr_to_proxy_user_entry->protocol ))	
							return PROXY_RANGE_ENTRY;
					}
					else
					{
						for ( index2 = ptr_to_proxy_user_entry->lower_port;
							index2 <= ptr_to_proxy_user_entry->higher_port;index2++)
						{
							if (( index1 == index2 ) && ( temp_protocol == ptr_to_proxy_user_entry->protocol ))	
								return PROXY_RANGE_ENTRY;
						}
					}
					if ( ptr_to_node != NULL )
					   ptr_to_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_node, (void *) &proxy_user_entry);
				
					if ( ptr_to_node == NULL )
						return UNIQUE_ENTRY;

					ptr_to_proxy_user_entry = (STRUCT_PROXY_USER_ENTRY *) &proxy_user_entry;
				}
			}
		}
	}		
	return UNIQUE_ENTRY;
}


int set_ip_address_for_autodetection(BYTE *ip_address)
{
	BYTE res_ip_address[20];
	enum CM_INIT_RESULTS init_res;
		
	printf("\nIP Address = %x",ip_address);
	
   init_res = cm_initialize_configuration_manager (CM_OWNED_BY_DTTY);
			
   convert_ip_address_to_dot_format (&res_ip_address[0],*(ULONG*)ip_address);
		
/*	printf("\nIP Address1 = %s",res_ip_address);
	printf("\nIP Address2 = %x",ip_address); */
	
   switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address,
				0, CM_STRING_FORMAT,&res_ip_address[0]))
	{
				case CM_ERROR_WHILE_VALIDATING:
					printf("\nFail");
               return -1;

				case CM_NOT_ENOUGH_MEMORY:
					printf("\nFail1");
               return -1;
				
	}
  
	
	cm_write_configuration();
   wait_for_flash_write_completion() ; 
	cm_deinitialize_configuration_manager(5);
	return 0;
	

}

BYTE is_re_entry_needed_for_application_port(USHORT port_number)
{
	USHORT ftp_ctrl_port = 0, ftp_data_port = 0;
	char temp_string_for_FTP[10];

	switch(port_number)
	{
#if 0 /* sudha 19 Aug 1999.For FTP configurable ctrl & data ports */
		case FTP20:
		case FTP21:
#endif
		case SSL_FTP989:
		case SSL_FTP990:
		case Q931_VOIP_900:
		case Q931_VOIP_902:
		case RTP_VOIP_5004:
		case RTP_VOIP_5006:
		case RTCP_VOIP_5005:
		case RTCP_VOIP_5007:
			return TRUE;
		default:
			break;
	}

	get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_ctrl_conn_port, 
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

	ftp_ctrl_port = atoi(temp_string_for_FTP);

	get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_data_conn_port, 
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

	ftp_data_port = atoi(temp_string_for_FTP);

	if ((port_number == ftp_ctrl_port) || (port_number == ftp_data_port))
		return TRUE;

	return FALSE;
}

USHORT get_next_application_port_which_needs_re_entry(USHORT first_port_number)
{
	USHORT next_port_number = 0;
	USHORT ftp_ctrl_port = 0, ftp_data_port = 0;
	char temp_string_for_FTP[10];

	switch(first_port_number)
	{
#if 0 /* sudha 19 Aug 1999. For FTP configurable ctrl & data ports */
		case FTP20:
			next_port_number = FTP21;
			break;
		case FTP21:
			next_port_number = FTP20;
			break; 
#endif
		case SSL_FTP989:
			next_port_number = SSL_FTP990;
			break;
		case SSL_FTP990:
			next_port_number = SSL_FTP989;
			break;
		case Q931_VOIP_900:
			next_port_number = Q931_VOIP_902;
			break;
		case Q931_VOIP_902:
			next_port_number = Q931_VOIP_900;
			break;
		case RTP_VOIP_5004:
			next_port_number = RTP_VOIP_5006;
			break;
		case RTP_VOIP_5006:
			next_port_number = RTP_VOIP_5004;
			break;
		case RTCP_VOIP_5005:
			next_port_number = RTCP_VOIP_5007;
			break;
		case RTCP_VOIP_5007:
			next_port_number = RTCP_VOIP_5005;
			break;
		default:
			get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_ctrl_conn_port, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

			ftp_ctrl_port = atoi(temp_string_for_FTP);

			get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_data_conn_port, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

			ftp_data_port = atoi(temp_string_for_FTP);

			if (first_port_number == ftp_ctrl_port)
				next_port_number = ftp_data_port;
			else if (first_port_number == ftp_data_port)
				next_port_number = ftp_ctrl_port;

			break;
	}

	return (next_port_number);
}

void set_ftp_port_numbers_in_global_structure(BYTE ftp_ctrl, USHORT prev_port)
{
	USHORT protocol, port_index = 0, ftp_ctrl_port = 0, ftp_data_port = 0;
	char temp_string_for_FTP[10];

	if (ftp_ctrl)
	{
		get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_ctrl_conn_port, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

		ftp_ctrl_port = atoi(temp_string_for_FTP);

		if (ftp_ctrl_port == 0)
			ftp_ctrl_port = FTP21;
	}
	else
	{
		get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_data_conn_port, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

		ftp_data_port = atoi(temp_string_for_FTP);

		if (ftp_data_port == 0)
			ftp_data_port = FTP20;

	}

	protocol = 0x0006; /* TCP Protocol */
	port_index = get_port_index (protocol,prev_port);

	if ( port_index != 0xFF )
	{
		if (ftp_ctrl)
			set_protocol_port_number(protocol, ftp_ctrl_port, port_index);
		else
			set_protocol_port_number(protocol, ftp_data_port, port_index);
	}

	protocol = 0x0011; /* UDP Protocol */
	port_index = get_port_index (protocol,prev_port);

	if (port_index != 0xFF)
	{
		if (ftp_ctrl)
			set_protocol_port_number(protocol, ftp_ctrl_port, port_index);
		else
			set_protocol_port_number(protocol, ftp_data_port, port_index);
	}
		
	return;
}

BOOL IsStrNumericAndValid(char *Str)
{
	char *tmpStr;
	int	LenStr;
	ULONG Value;

	tmpStr = Str;

	while (*Str)
		if (*Str < '0' || *Str > '9')
			return FALSE;
		else
			Str++;

	LenStr = strlen(tmpStr);	//If string id more than 5 digits error
	if (LenStr > 5)
		return FALSE;

	sscanf(tmpStr, "%ld", &Value);

	if (Value > 0xFFFFl)
		return FALSE;

	return TRUE;
}

void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port)
{
	char temp_string_for_FTP[10];

   get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_ctrl_conn_port, 
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

	*ctrl_port = atoi(temp_string_for_FTP);

   get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_data_conn_port, 
		CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string_for_FTP, 10);

	*data_port = atoi(temp_string_for_FTP);

	return;

}

BYTE *get_physical_port(USHORT port_number)
{
	switch(port_number)
	{
		case 0: return("Secured LAN");
		case 1: return("Internet LAN");
		case 2: return("WAN");
	}
}


