#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
#include "\rtrware\store\boot.h"
/* ... Naveen.P.N.*/
#include "incall.h"
#include "cfgmgr.h"
#include <flashmgr.h>

extern enum TEST udb_user_initialize();	
extern enum TEST udb_user_deinitialize();	

BYTE* array_of_ptrs_to_global_class_structres[] = 
{
	(BYTE*)&lsl, 
   (BYTE*)&socket_class, 
   (BYTE*)&ip, 
/*   (BYTE*)&ipx_class, */
   (BYTE*)&ppp, 
   (BYTE*)&ccp, 
/*   (BYTE*)&cipx, */
   (BYTE*)&vjc, 
   (BYTE*)&snmp, 
/*   (BYTE*)&stp_class,*/
   (BYTE*)&wan, 
   (BYTE*)&tcp, 
   (BYTE*)&telnet, 
   (BYTE*)&tftp, 
/*   (BYTE*)&spx, */
/*   (BYTE*)&ag, */
   (BYTE*)&dhcp,
#if WEB
   (BYTE*)&web,
#endif
   (BYTE*)&proxy_server
};

PARAMETER_NODE* sptr_to_each_section_in_the_configuration[CM_MAX_NUMBER_OF_SECTIONS];

CONFIGURATION_TABLE*  sptr_to_configuration_table[CM_NUMBER_OF_SECTIONS] =
{
 &lsl_configuration_table,
 &socket_configuration_table,
 &ip_configuration_table,
/* &ipx_configuration_table,*/
 &ppp_configuration_table,
 &ccp_configuration_table,
/* &cipx_configuration_table,*/
 &vjc_configuration_table,
 &snmp_configuration_table,
/* &stp_configuration_table,*/
 &wan_configuration_table,
 &tcp_configuration_table,
 &telnet_configuration_table,
 &tftp_configuration_table,
/* &spx_configuration_table,*/
/* &ag_configuration_table,*/
 &dhcp_configuration_table,
#if WEB
 &web_configuration_table,
#endif
 &proxy_configuration_table,
 &user_online_configuration_table
 };

STRUCT_OF_OFFSET_SECTION_TYPE array_of_offset_and_section_type[] = 
{	
  	{NULL, NULL},
  	{offsetof(WAN_CLASS, port[0].port_speed), CM_WAN_SECTION},
  	{offsetof(WAN_CLASS, port[0].sync_port_speed), CM_WAN_SECTION},
	{offsetof(IP_CLASS,  port[0].config.lsl_packet_type), CM_IP_SECTION}
};

STRUCT_OFFSET_AND_PTR_TO_VALIDATION_FUNCTION field_validation_lib[] =
{
/* 
	{offsetof(STP_CLASS, port[0].path_cost), CM_SPANTREE_SECTION, check_whether_value_is_with_in_limits, 0, 99999},
	{offsetof(IPX_CLASS, port[0].maximum_number_of_netbios_hops), CM_IPX_SECTION, check_whether_value_is_with_in_limits, 1, 16},
	{offsetof(IPX_CLASS, port[0].periodic_RIP_tx_timer), CM_IPX_SECTION, check_whether_value_is_with_in_limits, 30, 32767},
	{offsetof(IPX_CLASS, port[0].RIP_age_timer), CM_IPX_SECTION, check_whether_value_is_with_in_limits, 0, 32767},
	{offsetof(IPX_CLASS, port[0].transport_time), CM_IPX_SECTION, check_whether_value_is_with_in_limits, 1, 255},
	{offsetof(IPX_CLASS, port[0].periodic_SAP_tx_timer), CM_IPX_SECTION, check_whether_value_is_with_in_limits, 30, 32767},
	{offsetof(IPX_CLASS, port[0].SAP_age_timer), CM_IPX_SECTION, check_whether_value_is_with_in_limits, 0, 32767},
*/
	{offsetof(PPP_CLASS, port[0].idle_timeout), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 0, 546*60},
	{offsetof(PPP_CLASS, port[0].authentication.timeout), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 5, 65535},
	{offsetof(PPP_CLASS, port[0].authentication.maximum_number_of_retries), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 3, 65535},
	{offsetof(PPP_CLASS, maximum_number_of_unacknowledged_echo_requests), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 1, 20},
	{offsetof(PPP_CLASS, maximum_echo_request_send_interval), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 0, 65535},
	{offsetof(PPP_CLASS, maximum_number_of_termination_requests), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 1, 20},
	{offsetof(PPP_CLASS, maximum_termination_request_send_interval), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 0, 65535},
	{offsetof(PPP_CLASS, maximum_number_of_configuration_requests), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 3, 65535},
	{offsetof(PPP_CLASS, maximum_configuration_request_send_interval), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 5, 65535},
	{offsetof(PPP_CLASS, maximum_configuration_request_backoff_interval), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 5, 65535},
	{offsetof(PPP_CLASS, port[0].slip_port.maximum_transmit_bufsize) , CM_PPP_SECTION, check_whether_value_is_with_in_limits, 100, 1006},
/*
	{offsetof(AG_CLASS, line_info_array[0].line_vars.idle_time), CM_AG_SECTION, check_whether_value_is_with_in_limits, 0, 32767},
	{offsetof(AG_CLASS, ipx_interface.receives_per_session), CM_AG_SECTION, check_whether_value_is_with_in_limits, 4, 32},
*/

/* IP SECTION validate function list ...*/
	{offsetof(IP_CLASS, port[0].config.metric), CM_IP_SECTION, check_whether_value_is_with_in_limits, 1, 16},
	{offsetof(IP_CLASS, mib.ipDefaultTTL), CM_IP_SECTION, check_whether_value_is_with_in_limits, 2, 255},
	{offsetof(IP_CLASS, rip.config.update_time_interval), CM_IP_SECTION, check_whether_value_is_with_in_limits, 1, 65535},
	{offsetof(IP_CLASS, mib.ipReasmTimeout), CM_IP_SECTION, check_whether_value_is_with_in_limits, 0, 65535},
	{offsetof(IP_CLASS, rip.config.route_aging_timeout_value), CM_IP_SECTION, 0, 65535},
 /*@@@ pending default route metric */
/* ... IP SECTION validate function list */

/* IPX SECTION validate function list ...*/
/* ... IPX SECTION validate function list */

/* SpanningTree SECTION validate function list ...*/
/* ... SpanningTree SECTION validate function list */

/* PPP SECTION validate function list ...*/
	{offsetof(PPP_CLASS, port[0].lcp_mibs.pppLinkStatusLocalMRU), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 1500, 4500},
	{offsetof(PPP_CLASS, port[0].lcp_mibs.pppLinkStatusRemoteMRU), CM_PPP_SECTION, check_whether_value_is_with_in_limits, 1500, 4500},
/* ... PPP SECTION validate function list */

/* WAN SECTION validate function list ...*/
/* ... WAN SECTION validate function list */

/* APPLICATION SECTION validate function list ...*/
          
/* ... APPLICATION SECTION validate function list */
 	{NULL, NULL, NULL, NULL, NULL}
};

STRUCT_OFFSET_AND_RESOLVE_DEPENDENCIES_FUNCTION dependency_function_lib[] =
{
	{NULL, NULL, NULL}
};
CONFIGURATION_MANAGER_CLASS cfgmgr_class = {CM_OWNED_BY_NONE, NULL, 0};


STRUCT_STRINGS_AND_CORR_FUNCTIONS function_lib_for_insert_delete_edit_and_get[]=
{
	{"IP Static Route Table Entries", 	insert_a_static_route, 		remove_a_static_route, 		edit_a_static_route, 	get_first_entry_for_static_route, 							get_next_entry_for_static_route, 							get_previous_entry_for_static_route},
	{"IP Port Filter", 						insert_ip_port_filter, 		remove_ip_port_filter, 		edit_ip_port_filter, 	get_first_entry_for_ip_port_filter_main_function, 		get_next_entry_for_ip_port_filter_main_function, 		get_previous_entry_for_ip_port_filter},
	{"IP Address Filter", 					insert_ip_address_filter, 	remove_ip_address_filter, 	edit_ip_address_filter, get_first_entry_for_ip_address_filter_main_function, 	get_next_entry_for_ip_address_filter_main_function,  	get_previous_entry_for_ip_address_filter},
	{"IP ICMP Filter", 						insert_ip_icmp_filter, 		remove_ip_icmp_filter, 		edit_ip_icmp_filter, 	get_next_entry_for_ip_icmp_filter, 							get_next_entry_for_ip_icmp_filter, 							get_previous_entry_for_ip_icmp_filter},
/* sudha 19 Jan 1999... */

   {"Proxy User App",	insert_proxy_user_entry,
							remove_proxy_user_entry, 
							edit_proxy_user_entry, 
							get_first_proxy_user_entry, 
							get_next_proxy_user_entry, 
							get_previous_proxy_user_entry},

/* ...sudha 19 Jan 1999 */


   {"Proxy",                           insert_proxy_entry, 		   remove_proxy_entry, 		   edit_proxy_entry, 	   get_first_proxy_entry, 		                           get_next_proxy_entry, 		                           get_previous_proxy_entry},

/*	{"IPX Filter", 							insert_ipx_filter, 			remove_ipx_filter, 			edit_ipx_filter, 			get_first_entry_for_ipx_filter_main_function, 			get_next_entry_for_ipx_filter_main_function, 			get_previous_entry_for_ipx_filter},
*/
/*
	{"STP Filter", 							insert_stp_filter, 			remove_stp_filter, 			edit_stp_filter, 			get_first_entry_for_stp_filter_main_function, 			get_next_entry_for_stp_filter_main_function, 			get_previous_entry_for_stp_filter},
*/

   {"Proxy Server Global Address List",   insert_nat_global_address, remove_nat_global_address, edit_nat_global_address,get_first_nat_global_address, get_next_nat_global_address,  get_previous_nat_global_address },
   
   {"NAT_Static Mapping",              insert_nat_static_mapping, remove_nat_static_mapping, edit_nat_static_mapping,get_first_nat_static_mapping,    get_next_nat_static_mapping,  get_previous_nat_static_mapping },
   
   {"NAT_Dynamic Mapping",             insert_nat_dynamic_mapping,remove_nat_dynamic_mapping,edit_nat_dynamic_mapping,get_first_nat_dynamic_mapping,  get_next_nat_dynamic_mapping, get_previous_nat_dynamic_mapping },
   {"Proxy Destination Filter",	insert_proxy_filter,
							remove_proxy_filter, 
							edit_proxy_filter, 
							get_first_proxy_filter, 
							get_next_proxy_filter, 
							get_previous_proxy_filter},
	{"Proxy Source Filter",	insert_proxy_filter,
							remove_proxy_filter, 
							edit_proxy_filter, 
							get_first_proxy_filter, 
							get_next_proxy_filter, 
							get_previous_proxy_filter},
	{"Proxy Application Filter",	insert_proxy_filter,
							remove_proxy_filter, 
							edit_proxy_filter, 
							get_first_proxy_filter, 
							get_next_proxy_filter, 
							get_previous_proxy_filter},
	{"Proxy MAC Filter",	insert_proxy_filter,
							remove_proxy_filter, 
							edit_proxy_filter, 
							get_first_proxy_filter, 
							get_next_proxy_filter, 
							get_previous_proxy_filter},
	{"Proxy DNS Filter",	insert_proxy_filter,
							remove_proxy_filter, 
							edit_proxy_filter, 
							get_first_proxy_filter, 
							get_next_proxy_filter, 
							get_previous_proxy_filter},

	{NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};


/* -------------------------------------------------------------------- */

/* Local Prototype ... */
enum CM_INIT_RESULTS cm_initialize_configuration_manager(enum CM_AGENT_TYPE agent_type);
void cm_deinitialize_configuration_manager(enum CM_AGENT_TYPE agent_type);
void cm_keep_alive_configuration_manager(enum CM_AGENT_TYPE agent_type);
void cm_free_linked_list (PARAMETER_NODE* sptr_list);
PARAMETER_NODE* cm_read_setup_and_build_linked_list_for_each_line(BYTE* start_of_cfg);
void cm_decrement_configuration_manager_lifetime();
/* ... Local Prototype */

extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern BYTE cm_initialise_dhcp_address_range_list();
void  cm_free_tag_list(BYTE free_cfgmgr_class_list);

enum CM_INIT_RESULTS cm_initialize_configuration_manager(enum CM_AGENT_TYPE agent_type)
{
	PARAMETER_NODE* sptr_to_first_node;
	BYTE* cfg_start ;
	HeaderType* cfg_hdr ;

	if (cfgmgr_class.owner != CM_OWNED_BY_NONE)
	{
/* Chidanand - 10 May 1997 */
		if ((cfgmgr_class.owner == agent_type) && (agent_type == CM_OWNED_BY_UIM))
		{
			cfgmgr_class.cfg_mgr_timer = CM_LIFE_TIME;
			return CM_INIT_SUCCESSFUL;
		}
/* Chidanand - 10 May 1997 */

		switch (cfgmgr_class.owner)
		{
			case CM_OWNED_BY_SNMP:
				return CM_MANAGER_IS_SNMP;
			case CM_OWNED_BY_TELNET:
				return CM_MANAGER_IS_TELNET;
			case CM_OWNED_BY_HTTP:
				return CM_MANAGER_IS_HTTP;
			case CM_OWNED_BY_UIM:
				return CM_MANAGER_IS_UIM;
			case CM_OWNED_BY_DTTY:
				return CM_MANAGER_IS_DTTY;
			default:
				printf("Unknown module is using Configuration Manager\n");
				break;
		}
	}

	cfg_hdr = (HeaderType *) FL_CFG_HDR;
   cfg_start = (BYTE *) cfg_hdr->DnLdAddr;  
	if (agent_type != CM_OWNED_BY_UIM) /* For Roucon it is not required to form linked list i.e. read setup from flash */
	{
	   sptr_to_first_node = cm_read_setup_and_build_linked_list_for_each_line(cfg_start);
		if (sptr_to_first_node == NULL)
		{
			return CM_INIT_FAILED_NOT_ENOUGH_MEMORY;		
		}
		cfgmgr_class.sptr_to_first_node = sptr_to_first_node; 
	}
	else
	{
		cfgmgr_class.sptr_to_first_node = NULL; 
	}
	cfgmgr_class.owner = agent_type;
	cfgmgr_class.cfg_mgr_timer = CM_LIFE_TIME;

   if (cm_initialise_dhcp_address_range_list() == FALSE)
   {
      printf("Not enough memory to initialize configuration manager\n");
      cm_deinitialize_configuration_manager(agent_type);
   }
	udb_user_initialize();	/* Added by Sreelu for User Database */
	return CM_INIT_SUCCESSFUL;
}

void cm_deinitialize_configuration_manager(enum CM_AGENT_TYPE agent_type)
{  
	if (agent_type != cfgmgr_class.owner)
		return;
   printf("Deinitialization Of Configuration Manager is in progress...");
	if (agent_type != CM_OWNED_BY_UIM)
   {
      cm_free_tag_list(TRUE);
		cm_free_linked_list(cfgmgr_class.sptr_to_first_node);
   }
   printf("Done\n");
	cfgmgr_class.sptr_to_first_node = NULL; 
	cfgmgr_class.owner = CM_OWNED_BY_NONE;
	udb_user_deinitialize();  /* Added by Sreelu for User Database */
}

void cm_keep_alive_configuration_manager(enum CM_AGENT_TYPE agent_type)
{
	if (agent_type != cfgmgr_class.owner)
		return;
	cfgmgr_class.cfg_mgr_timer = CM_LIFE_TIME;
}

void cm_decrement_configuration_manager_lifetime()
{
 	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		return;
	}
	cfgmgr_class.cfg_mgr_timer--;
	if (cfgmgr_class.cfg_mgr_timer == 0)
	{
/*		printf("Configuration Manager Expired. Deinitializing ...\n");*/
		cm_deinitialize_configuration_manager(cfgmgr_class.owner);
	}
}
/* -------------------------------------------------------------------- */

void cm_free_linked_list (PARAMETER_NODE* sptr_list)
{
	PARAMETER_NODE *sptr_temp ;
	while (sptr_list != NULL)
	{
		sptr_temp = sptr_list->next ;
		free (sptr_list) ;
	  	sptr_list = sptr_temp ;
	}
	return ;
}

PARAMETER_NODE* cm_read_setup_and_build_linked_list_for_each_line(BYTE* start_of_cfg)
{
	PARAMETER_NODE *ptr_to_list, *ptr_to_current_struct, *dup_ptr_to_list;
	int i;
	int no_of_blocks = 0 ;
	int max_parameter_length ;
	int cfg_string_number = 0 ;
	ULONG mem_size = 0;
	BYTE start_of_new_section;
	USHORT index_to_sections = 0;

	index_to_sections = 0;
	start_of_new_section = FALSE;

	max_parameter_length = get_max_parameter_length (start_of_cfg) ;
	dup_ptr_to_list = ptr_to_list = (PARAMETER_NODE*) malloc (sizeof (ULONG) * 2 + max_parameter_length) ;
	mem_size += (sizeof (ULONG) * 2 + max_parameter_length);

	ptr_to_list->next = NULL ;
	ptr_to_list->previous = NULL ;

	if (ptr_to_list == NULL)
	{
		printf ("Not enough memory for Reading Setup from Flash 1\n") ;
		return (NULL) ;
	} 
	no_of_blocks++ ;
	ptr_to_current_struct = ptr_to_list;
	ptr_to_current_struct->previous = NULL;

	while (*start_of_cfg)
	{
		i = 0;
		cfg_string_number++ ;
		while ((*start_of_cfg != '\n') && (*start_of_cfg != '\r'))
		{
			if (i >= max_parameter_length-1)
			{
				i++ ;
				while ((*start_of_cfg) && (*start_of_cfg != '\r') && (*start_of_cfg != '\n'))
					start_of_cfg++ ;
				break ;
			}
			if (*start_of_cfg == '[' && *(start_of_cfg+1)=='[')
				start_of_new_section = TRUE;
			ptr_to_current_struct->parameter[i++] = *start_of_cfg++; 
		}
		ptr_to_current_struct->parameter[i++] = '\n';
		ptr_to_current_struct->parameter[i] = '\0';
		start_of_cfg++;

		if (start_of_new_section)
		{
			sptr_to_each_section_in_the_configuration[index_to_sections++] = ptr_to_current_struct;
			start_of_new_section = FALSE;
		}
		max_parameter_length = get_max_parameter_length (start_of_cfg) ;
		ptr_to_current_struct->next = (PARAMETER_NODE*) malloc (sizeof(ULONG) * 2 + max_parameter_length);
		if (ptr_to_current_struct->next == NULL)
		{
			cm_free_linked_list (dup_ptr_to_list) ;
			printf ("Not enough memory for Reading Setup from Flash 2\n") ;
			return (NULL) ;
		}
		/*
		   Set the previous and next pointers of the newly
		   allocated block to NULL
		*/
		ptr_to_current_struct->next->next = NULL ;
		ptr_to_current_struct->next->previous = NULL ;
		mem_size += (sizeof(ULONG) * 2 + max_parameter_length);
		no_of_blocks++ ;
		ptr_to_current_struct->next->previous = ptr_to_current_struct;
		ptr_to_current_struct = ptr_to_current_struct->next;
	}
	ptr_to_current_struct->previous->next = NULL;
	return (dup_ptr_to_list);
}




