#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
#include "\rtrware\store\boot.h"
/* ... Naveen.P.N.*/
#include "incall.h"
#include "cfgmgr.h"
#include <flashmgr.h>


#define NUMBER_OF_IPX_VIRTUAL_PORTS 4
#define CM_MAXIMUM_NUMBER_OF_PORTS 10

#define STRING_LENGTH_FOR_GET 	  200


/* Extern Decleration starts here ... */
extern PARAMETER_NODE* match_the_lhs_string_in_the_linked_list_and_return_rhs_string(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* rhs_string, USHORT port_number, BYTE* port_number_matched);
extern void fill_static_route_struct_from_buffer(STRUCT_STATIC_ROUTE* static_route, BYTE* buffer);
extern void convert_to_lower_case(BYTE* the_string);
extern PARAMETER_NODE* insert_missing_string_with_port(BYTE section_number, BYTE port_number, BYTE* lhs_string, BYTE* rhs_string);
extern BYTE is_valid_string_to_read_data(BYTE* buffer);
/* ... Extern Decleration ends here */


/* Local Prototype decleration starts here... */
BYTE total_numbers_ipx_filters_in_the_current_node(PARAMETER_NODE* node);
BYTE total_numbers_stp_filters_in_the_current_node(PARAMETER_NODE* node);
BYTE total_numbers_ip_port_filters_in_the_current_node(PARAMETER_NODE* node);
BYTE total_numbers_ip_address_filters_in_the_current_node(PARAMETER_NODE* node);
BYTE total_numbers_ters_in_the_current_node(PARAMETER_NODE* node);

BYTE the_lastly_given_filter_in_the_current_node(BYTE new_value, BYTE is_to_save);
void get_lhs_string_from_node(current_node, lhs_string);
BYTE lastly_given_filter_type(BYTE new_value, BYTE is_to_save);
BYTE lastly_given_filter_port(BYTE new_value, BYTE is_to_save);
BYTE get_the_value_for(BYTE starting_from, BYTE* buffer, BYTE* value);
void update_the_number_of_filters_present();
USHORT get_the_total_number_of_ipx_filters();
USHORT get_the_total_number_of_ip_port_filters();
USHORT get_the_total_number_of_ip_address_filters();
USHORT get_the_total_number_of_stp_filters();
USHORT get_the_total_number_of_ip_icmp_filter();
BYTE total_number_of_proxy_entries_in_the_current_node(PARAMETER_NODE* node);
BYTE search_for_a_entry(STRUCT_PROXY_ENTRY* proxy_entry, BYTE* bptr_lhs_string);

/* sudha 19 Jan 1999... */
BYTE total_number_of_proxy_user_entries_in_the_current_node(PARAMETER_NODE* node);
BYTE search_for_a_user_entry(STRUCT_PROXY_USER_ENTRY* proxy_entry, BYTE* bptr_lhs_string);
extern void update_count_in_ini (BYTE *lhs_string, BYTE flag,USHORT port_num);
extern enum TEST_RESULT is_user_defined_port_range_unique(USHORT lower_port, USHORT higher_port,USHORT protocol);

extern USHORT get_next_application_port_which_needs_re_entry(USHORT first_port_number);
extern BYTE is_re_entry_needed_for_application_port(USHORT port_number);

/* sudha 19 Jan 1999... */

/* ... Local Prototype decleration ends here */

BYTE proxy_entry_string_in_ini_file[] = "Proxy Server Application List";
BYTE proxy_user_entry_string_in_ini_file[] = "Proxy Application Info";

BYTE num_proxy_user_entries_in_ini[]  = "Proxy Server User Defined Description";
BYTE num_proxy_reserved_entries_in_ini[]  = "Proxy Server Number of Applications";


/* Following Functions are for special strings which doesn't have offset and
   some have common lhs string ... Can Copy the following 6 functions + others
	to optimized Configuration Manager ....*/

PARAMETER_NODE* cm_insert_string(enum CM_SECTIONS section_to_which_it_belongs_to, 
										  BYTE* bptr_lhs_string, 
		  								  void* vptr_rhs)
{
	BYTE i = 0;
	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return NULL;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return NULL;
	}	 
	while (function_lib_for_insert_delete_edit_and_get[i].insert_function != NULL)
	{
		if (!strcmpi(function_lib_for_insert_delete_edit_and_get[i].lhs_string, bptr_lhs_string))	
		{
			return(function_lib_for_insert_delete_edit_and_get[i].insert_function(section_to_which_it_belongs_to, bptr_lhs_string, vptr_rhs));
		}
		++i;
	}
	printf("Failed to Insert %s, because of no match in the library\n", bptr_lhs_string);	
	return NULL;
}


enum CM_REMOVE_STRING_RESULTS cm_remove_string(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, void* vptr_rhs)
{
	BYTE i = 0;
	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return ;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return ;
	}	 
	while (function_lib_for_insert_delete_edit_and_get[i].insert_function != NULL)
	{
		if (!strcmpi(function_lib_for_insert_delete_edit_and_get[i].lhs_string, bptr_lhs_string))	
		{
			return(function_lib_for_insert_delete_edit_and_get[i].remove_function(section_to_which_it_belongs_to, bptr_lhs_string, vptr_rhs));
		}
		++i;
	}
	printf("Failed to Remove %s, because of no match in the library\n", bptr_lhs_string);	
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}

enum CM_EDIT_STRING_RESULTS cm_edit_string(enum CM_SECTIONS section_to_which_it_belongs_to, 
													    BYTE* bptr_lhs_string, 
														 void* vptr_old_rhs,
														 void* vptr_new_rhs)
{
	BYTE i = 0;
	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return ;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return ;
	}	 
	while (function_lib_for_insert_delete_edit_and_get[i].insert_function != NULL)
	{
		if (!strcmpi(function_lib_for_insert_delete_edit_and_get[i].lhs_string, bptr_lhs_string))	
		{
			return(function_lib_for_insert_delete_edit_and_get[i].edit_function(section_to_which_it_belongs_to, bptr_lhs_string, vptr_old_rhs, vptr_new_rhs));
		}
		++i;
	}
	printf("Failed to edit %s, because of no match in the library\n", bptr_lhs_string);	
	return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
}

PARAMETER_NODE* cm_get_first_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
											  BYTE* bptr_lhs_string, 
											  void* vptr_rhs)
{
	BYTE i = 0;
	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return NULL;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return NULL;
	}	 
	while (function_lib_for_insert_delete_edit_and_get[i].insert_function != NULL)
	{
		if (!strcmpi(function_lib_for_insert_delete_edit_and_get[i].lhs_string, bptr_lhs_string))	
		{
			return(function_lib_for_insert_delete_edit_and_get[i].get_first_entry_function(section_to_which_it_belongs_to, bptr_lhs_string, vptr_rhs));
		}
		++i;
	}
	printf("Failed to Get First Entry %s, because of no match in the library\n", bptr_lhs_string);	
	return NULL;
}

PARAMETER_NODE* cm_get_next_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	BYTE i = 0, lhs_string[200];

	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return NULL;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return NULL;
	}	 
	get_lhs_string_from_node(current_node, lhs_string);

   if (strstr(lhs_string ,"Global Address List") != NULL)
	{
		strcpy(lhs_string, "Proxy Server Global Address List");
	}
	else
   if (strstr(lhs_string ,"Server Mapped Address List") != NULL)
	{
		strcpy(lhs_string, "NAT_Static Mapping");
	}
	else
   if (strstr(lhs_string ,"Server Local Internet Servers") != NULL)
	{
		strcpy(lhs_string, "NAT_Dynamic Mapping");
	}
/* sudha 19 Jan 1999... */

	else
   if (strstr(lhs_string ,"Proxy Application Info") != NULL)
	{
		strcpy(lhs_string, "Proxy User App");
	}

/* ...sudha 19 Jan 1999 */

	else
   if (strstr(lhs_string ,"Proxy Server Forbidden Address List") != NULL)
	{
		strcpy(lhs_string, "Proxy Destination Filter");
	}
	else
   if (strstr(lhs_string ,"Proxy Server Restricted Client List") != NULL)
	{
		strcpy(lhs_string, "Proxy Source Filter");
	}
	else
   if (strstr(lhs_string ,"Proxy Server Restricted Application List") != NULL)
	{
		strcpy(lhs_string, "Proxy Application Filter");
	}
	else
   if (strstr(lhs_string ,"Proxy Server Restricted MAC Address List") != NULL)
	{
		strcpy(lhs_string, "Proxy MAC Filter");
	}
	else
   if (strstr(lhs_string ,"Proxy Server Restricted Domain Name List") != NULL)
	{
		strcpy(lhs_string, "Proxy DNS Filter");
	}
   else
   if (strstr(lhs_string ,"Proxy Server Port Privileged User List") != NULL)
	{
		strcpy(lhs_string, "Privileged User Address");
	}
	else
 	if (strstr(lhs_string ,"IPX") != NULL)
	{
		strcpy(lhs_string, "IPX Filter");
	}
	else
	if (strstr(lhs_string ,"Spanning") != NULL)
	{
		strcpy(lhs_string, "STP Filter");
	}
	else
	if (strstr(lhs_string ,"Port") != NULL)
	{
		strcpy(lhs_string, "IP Port Filter");
	}
	else
	if (strstr(lhs_string ,"Address") != NULL)
	{
		strcpy(lhs_string, "IP Address Filter");
	}
	else
	if (strstr(lhs_string ,"ICMP") != NULL)
	{
		strcpy(lhs_string, "IP ICMP Filter");
	}
	else
	if (strstr(lhs_string ,"Static") != NULL)
	{
		strcpy(lhs_string, "IP Static Route Table Entries");
	}
	else
	if (strstr(lhs_string ,"Proxy") != NULL)
	{
		strcpy(lhs_string, "Proxy");
	}

	while (function_lib_for_insert_delete_edit_and_get[i].insert_function != NULL)
	{
		if (!strcmpi(function_lib_for_insert_delete_edit_and_get[i].lhs_string, lhs_string))	
		{
			return(function_lib_for_insert_delete_edit_and_get[i].get_next_entry_function(section_to_which_it_belongs_to, current_node, vptr_rhs));
		}
		++i;
	}
	printf("Failed to Get Next Entry %s, because of no match in the library\n", lhs_string);	
	return NULL;
}

PARAMETER_NODE* cm_get_previous_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	BYTE i = 0, lhs_string[200];

	get_lhs_string_from_node(current_node, lhs_string);
	if (cfgmgr_class.owner == CM_OWNED_BY_NONE)
	{
		printf("Configuration manager not owned by anybody\n");
		return NULL;
	}	 
	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
	{ /* For Roucon set and get are not supported */
		return NULL;
	}	 

	while (function_lib_for_insert_delete_edit_and_get[i].insert_function != NULL)
	{
		if (!strcmpi(function_lib_for_insert_delete_edit_and_get[i].lhs_string, lhs_string))	
		{
			return(function_lib_for_insert_delete_edit_and_get[i].get_previous_entry_function(section_to_which_it_belongs_to, current_node, vptr_rhs));
		}
		++i;
	}
	printf("Failed to Get Previous Entry %s, because of no match in the library\n", lhs_string);	
	return NULL;
}

/*************************************************************************
					FUNCTION'S TO HANDLE STATIC ROUTE STARTS HERE...
**************************************************************************/


PARAMETER_NODE* insert_a_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
												  BYTE* bptr_lhs_string, 
				  								  void* vptr_rhs)
{
   ULONG max_parameter_length;
	PARAMETER_NODE* new_node, *next_section_first_node, *current_section_last_node;
   BYTE buffer[200];
   STRUCT_STATIC_ROUTE* static_route;
	BYTE metric,port;
   char portch[10];
	USHORT port_number;
	BYTE ip_address[STRING_LENGTH_FOR_GET], subnet_mask[STRING_LENGTH_FOR_GET];
	BYTE value;

   static_route = (STRUCT_STATIC_ROUTE*)vptr_rhs;
	if (!is_a_static_ip_address(static_route->ip_address, static_route->address_mask))
	{
		printf("Not a Valid IP Address\n");
		return NULL;
	}

	if (!is_a_static_ip_address_mask(static_route->ip_address, static_route->address_mask))
	{
		printf("Not a Valid Ip Address Mask\n");
		return NULL;
	}
/*	if (!is_an_ip_address(static_route->gateway_address))
	{
		printf("Gateway Address, Not a valid IP Address \n");
		return NULL;
	}*/
	if ((strcmp(static_route->gateway_address, "") == 0) ||
	   (strcmp(static_route->gateway_address, "DHCP Assigned") == 0)||
      (strcmp(static_route->gateway_address, "ISP Assigned") == 0)) 
	
      strcpy(static_route->gateway_address,"0.0.0.0");

	if (!is_valid_string_to_read_data(static_route->metric))
   {
      return NULL;
   }
   metric = atoi(static_route->metric);
	if (metric < 1 || metric > 16)
	{
		printf("Metric is out of range\n");
		return NULL;
	}

/* Added by Neelu to support Port in Static Route */
	port = atoi(static_route->port);
	if(port == 0)
	{
		port_number = 0;
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, CM_STRING_FORMAT, (void*)subnet_mask, STRING_LENGTH_FOR_GET);

		if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, static_route->gateway_address, subnet_mask))
		{	
			return NULL;
		}
	}
	else if(port == 1)
	{
		port_number = 1;
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, port_number, CM_INDEX_FORMAT, (void*)&value, 0);
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, CM_STRING_FORMAT, (void*)subnet_mask, STRING_LENGTH_FOR_GET);
		      
		if (value) /* Yes DHCP is Enabled, go out */
		{
			strcpy(static_route->gateway_address,"0.0.0.0");
		}
		else
		{
			if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, static_route->gateway_address, subnet_mask))
			{	
					printf("Validation Failed For Internet Lan on Remote IP Address Validation\n");
					return NULL;
			}
		}
	}
	else if(port == 2)
	{
		port_number = 2;
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, CM_STRING_FORMAT, (void*)subnet_mask, STRING_LENGTH_FOR_GET);
		      
		if (!strcmpi(ip_address, "0.0.0.0")) /* check for ISP */
		{
			strcpy(static_route->gateway_address,"0.0.0.0");
		}
		else
		{
		 	if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, static_route->gateway_address, subnet_mask))
			{	
					return NULL;
			}
		}
	}
/* Added by Neelu to support Port in Static Route */

   max_parameter_length = 200;
   new_node = (PARAMETER_NODE*) malloc (sizeof (ULONG) * 2 + max_parameter_length) ;
   if (new_node == NULL)
   {
      printf("Not Enough Memory to insert the string\n");
      return NULL;
   }
   next_section_first_node = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1];
   current_section_last_node = next_section_first_node->previous;
   new_node->next = next_section_first_node;
   new_node->previous = current_section_last_node;
   next_section_first_node->previous = new_node;
   current_section_last_node->next = new_node;

   strcpy(buffer, static_route->ip_address);
   strcat(buffer, ",");
   strcat(buffer, static_route->gateway_address);
   strcat(buffer, ",");
   strcat(buffer, static_route->address_mask);
   strcat(buffer, ",");
   strcat(buffer, static_route->metric);
   strcat(buffer, ",");					/* Neelu */
   strcat(buffer, static_route->port);	/* Neelu */

	strcpy(new_node->parameter, bptr_lhs_string);
	strcat(new_node->parameter, " = ");
	strcat(new_node->parameter, buffer);
	strcat(new_node->parameter, ";");
	strcat(new_node->parameter, "\n");
	return new_node;
}

 
enum CM_REMOVE_STRING_RESULTS remove_a_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
																	 BYTE* bptr_lhs_string, void* vptr_rhs)
{
	PARAMETER_NODE* search_to_start_at;
	BYTE string_ptr[200], port_number = CM_NO_PORT_PARAMETER_PRESENT, port_number_matched, buffer[200];
	STRUCT_STATIC_ROUTE* static_route;

	static_route = (STRUCT_STATIC_ROUTE*)vptr_rhs;
	strcpy(buffer, static_route->ip_address);
	strcat(buffer, ",");
	strcat(buffer, static_route->gateway_address);
	strcat(buffer, ",");
	strcat(buffer, static_route->address_mask);
	strcat(buffer, ",");
	strcat(buffer, static_route->metric);
	strcat(buffer, ",");
	strcat(buffer, static_route->port);/* Neelu */
	strcat(buffer, ";");/* Neelu */

	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	do
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(bptr_lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], string_ptr, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
			return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;	
	}while(strcmpi(buffer, string_ptr) != 0);

	search_to_start_at->previous->next = search_to_start_at->next;
	search_to_start_at->next->previous = search_to_start_at->previous;
	free(search_to_start_at);
	return CM_REMOVING_STRING_SUCCESSFUL;
}

enum CM_EDIT_STRING_RESULTS edit_a_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
													    		BYTE* bptr_lhs_string, 
														 		void* vptr_old_rhs,
														 		void* vptr_new_rhs)
{
	
	PARAMETER_NODE* search_to_start_at;
	BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, port_number_matched, temp_buffer[200], rhs_string[200], metric, port;
   STRUCT_STATIC_ROUTE* old_static_route, *new_static_route;
	USHORT port_num;
	BYTE ip_address[STRING_LENGTH_FOR_GET], subnet_mask[STRING_LENGTH_FOR_GET];
	BYTE value;

   new_static_route = (STRUCT_STATIC_ROUTE*)vptr_new_rhs;
	if (!is_a_static_ip_address(new_static_route->ip_address, new_static_route->address_mask))
	{
		printf("Not a Valid IP Address\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}
	if (!is_a_static_ip_address_mask(new_static_route->ip_address, new_static_route->address_mask))
	{
		printf("Not a Valid Ip Address Mask\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}
/*	if (!is_an_ip_address(new_static_route->gateway_address))
	{
		printf("Gateway Address, IP Address are not on same network\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}*/
	if ((strcmp(new_static_route->gateway_address, "") == 0) ||
		(strcmp(new_static_route->gateway_address, "ISP Assigned") == 0) ||
		(strcmp(new_static_route->gateway_address, "DHCP Assigned") == 0))	
		strcpy(new_static_route->gateway_address,"0.0.0.0");

	if (!is_valid_string_to_read_data(new_static_route->metric))
   {
      return CM_EDITING_FAILED_ON_VALIDATION;
   }
	metric = atoi(new_static_route->metric);
	if (metric < 1 || metric > 16)
	{
		printf("Metric is out of range\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}

/* Added by Neelu to Support Port for Static Routes */
	port = atoi(new_static_route->port);
	if(port == 0)
	{
		port_num = 0;
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_num, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_num, CM_STRING_FORMAT, (void*)subnet_mask, STRING_LENGTH_FOR_GET);
		
		if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, new_static_route->gateway_address, subnet_mask))
		{	
			return NULL;
		}
	}
	else if(port == 1)
	{
		port_number = 1;
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.dhcp_client_enabled, port_num, CM_INDEX_FORMAT, (void*)&value, 0);
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_num, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_num, CM_STRING_FORMAT, (void*)subnet_mask, STRING_LENGTH_FOR_GET);
		      
		if (value) /* Yes DHCP is Enabled, go out */
		{
			strcpy(new_static_route->gateway_address,"0.0.0.0");
		}
		else
		{
			if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, new_static_route->gateway_address, subnet_mask))
			{	
					return NULL;
			}
		}
	}
	else if(port == 2)
	{
		port_number = 2;
		
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_num, CM_STRING_FORMAT, (void*)ip_address, STRING_LENGTH_FOR_GET);
      get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_num, CM_STRING_FORMAT, (void*)subnet_mask, STRING_LENGTH_FOR_GET);
		      
		if (!strcmpi(ip_address, "0.0.0.0")) /* check for ISP */
		{
			strcpy(new_static_route->gateway_address,"0.0.0.0");
		}
		else
		{
		 	if (!local_ip_address_and_remote_ip_address_on_same_network(ip_address, new_static_route->gateway_address, subnet_mask))
			{	
					return NULL;
			}
		}
	}

   old_static_route = (STRUCT_STATIC_ROUTE*)vptr_old_rhs;
	
	if ((strcmp(old_static_route->gateway_address, "") == 0) ||
		(strcmp(old_static_route->gateway_address, "ISP Assigned") == 0))			
		strcpy(old_static_route->gateway_address,"0.0.0.0");

	strcpy(rhs_string, old_static_route->ip_address);
   strcat(rhs_string, ",");
   strcat(rhs_string, old_static_route->gateway_address);
   strcat(rhs_string, ",");
   strcat(rhs_string, old_static_route->address_mask);
   strcat(rhs_string, ",");
   strcat(rhs_string, old_static_route->metric);
	strcat(rhs_string, ",");
   strcat(rhs_string, old_static_route->port);
	strcat(rhs_string, ";");

	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	
	do
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(bptr_lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], temp_buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
		{
			printf("Failed to search for the entry to be edited\n");
			return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;	
		}
	}while(strcmpi(rhs_string, temp_buffer) != 0);

   strcpy(rhs_string, new_static_route->ip_address);
   strcat(rhs_string, ",");
   strcat(rhs_string, new_static_route->gateway_address);
   strcat(rhs_string, ",");
   strcat(rhs_string, new_static_route->address_mask);
   strcat(rhs_string, ",");
   strcat(rhs_string, new_static_route->metric);
   strcat(rhs_string, ",");
   strcat(rhs_string, new_static_route->port);

	strcpy(search_to_start_at->parameter, bptr_lhs_string);
	strcat(search_to_start_at->parameter, " = ");
	strcat(search_to_start_at->parameter, rhs_string);
	strcat(search_to_start_at->parameter, ";");
	strcat(search_to_start_at->parameter, "\n");
	return CM_STRING_EDIT_SUCCESSFUL;
}

PARAMETER_NODE* get_first_entry_for_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
																 BYTE* bptr_lhs_string, 
																 void* vptr_rhs)
{
	PARAMETER_NODE* search_to_start_at;
	BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, port_number_matched, buffer[200];
   STRUCT_STATIC_ROUTE* static_route;

	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(bptr_lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
	if (search_to_start_at == NULL)
		return NULL;	
	if (vptr_rhs == NULL)
	   return search_to_start_at;
		
   static_route = (STRUCT_STATIC_ROUTE*)vptr_rhs;
	fill_static_route_struct_from_buffer(static_route, search_to_start_at->parameter);
   return search_to_start_at;
}

PARAMETER_NODE* get_next_entry_for_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	BYTE current_node_lhs_string[100], lhs_string[100], i = 0;
	PARAMETER_NODE* current_temp_node, *next_node;
   STRUCT_STATIC_ROUTE* static_route;

	if (!current_node) return NULL;
	while (current_node->parameter[i] != '=')
	{
		lhs_string[i] = current_node->parameter[i];
		i++;
	}
	lhs_string[i-1] = 0;
	current_temp_node = current_node;
	while (current_temp_node->next  && current_temp_node->next != sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1])
	{
		next_node = current_temp_node->next;
		i = 0;
		while (next_node->parameter[i] != '=')
		{
			current_node_lhs_string[i] = next_node->parameter[i];
			i++;
		}
		current_node_lhs_string[i-1] = 0;
		convert_to_lower_case(current_node_lhs_string);
		convert_to_lower_case(lhs_string);
		if (strcmpi(lhs_string, current_node_lhs_string) == 0)
		{
			if (vptr_rhs == NULL)
				return next_node;
         static_route = (STRUCT_STATIC_ROUTE*)vptr_rhs;
	      fill_static_route_struct_from_buffer(static_route, next_node->parameter);
			return next_node;
		}
		current_temp_node = current_temp_node->next;
	}
	return NULL;
}

PARAMETER_NODE* get_previous_entry_for_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	BYTE current_node_lhs_string[100], lhs_string[100], i = 0;
	PARAMETER_NODE* current_temp_node, *previous_node;
   STRUCT_STATIC_ROUTE* static_route;

	if (!current_node) return NULL;
	while (current_node->parameter[i] != '=')
	{
		lhs_string[i] = current_node->parameter[i];
		i++;
	}
	lhs_string[i-1] = 0;
	current_temp_node = current_node;
	while (current_temp_node != sptr_to_each_section_in_the_configuration[0] && current_temp_node->previous != sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to - 1])
	{
		previous_node = current_temp_node->previous;
		i = 0;
		while (previous_node->parameter[i] != '=')
		{
			current_node_lhs_string[i] = previous_node->parameter[i];
			i++;
		}
		current_node_lhs_string[i-1] = 0;
		convert_to_lower_case(current_node_lhs_string);
		convert_to_lower_case(lhs_string);
		if (strcmpi(lhs_string, current_node_lhs_string) == 0)
		{
			if (vptr_rhs == NULL)
				return previous_node;
         static_route = (STRUCT_STATIC_ROUTE*)vptr_rhs;
	      fill_static_route_struct_from_buffer(static_route, previous_node->parameter);
			return previous_node;
		}
		current_temp_node = current_temp_node->previous;
	}
	return NULL;
}
/*************************************************************************
					... FUNCTION'S TO HANDLE STATIC ROUTE ENDS HERE
**************************************************************************/


#if 0 /* This code is not required for Proxy Server */
/*************************************************************************
					FUNCTION'S TO HANDLE IPX Filter Starts HERE ...
**************************************************************************/




PARAMETER_NODE* insert_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs)
{
	STRUCT_IPX_FILTER* ipx_filter, temp_filter;
	BYTE lhs_string[100], i, rhs_string[200];
	PARAMETER_NODE* node, *temp_node;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_rhs;

	/* Validation ... */
	if (strlen(ipx_filter->network_number) > 8 || strlen(ipx_filter->network_number) == 0)
		return NULL;	
	if (!is_valid_ipx_network_number(ipx_filter->network_number)) 
		return NULL;

	if (strlen(ipx_filter->node_number) > 12 || strlen(ipx_filter->node_number) == 0)
		return NULL;	
	if (!is_valid_ipx_network_number(ipx_filter->node_number)) /* No Confusion please, this function just checks for bounds ok. I will adjust in the future */ 
		return NULL;

	if (strlen(ipx_filter->socket_number) > 4 || strlen(ipx_filter->socket_number) == 0)	
		return NULL;	
	if (!is_valid_ipx_network_number(ipx_filter->socket_number)) /* No Confusion please, this function just checks for bounds ok. I will adjust in the future */ 
		return NULL;
	/* ... Validation */


	strcpy(lhs_string, "IPX ");

	switch(ipx_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}

	/* Check whether a node already present so that we can append the
		new entry to it  Note: iff number of filters present is less then
		3 (Magic Number!!!) 
	*/
	temp_filter = *(ipx_filter);
	node = get_first_entry_for_ipx_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter);

	while(node)
	{
		if (total_numbers_ipx_filters_in_the_current_node(node) < 3)
		{
			/* Already a node is there just go and append there */
#if 0
			strcat(node->parameter, ipx_filter->network_number);
			strcat(node->parameter, " ");
			strcat(node->parameter, ipx_filter->node_number);
			strcat(node->parameter, " ");
			strcat(node->parameter, ipx_filter->socket_number);
#endif	

			/* Remove '\n' to append new entry */
			node->parameter[strlen(node->parameter)-1] = 0; 			

			strcat(node->parameter, ",");
			sprintf(rhs_string, "%08s %012s %04s\0", ipx_filter->network_number, ipx_filter->node_number, ipx_filter->socket_number);
			strcat(node->parameter, rhs_string);
			strcat(node->parameter, "\n");
			temp_node = node; /* Save the current node to return */
			if (ipx_filter->physical_port == ETHERNET_PORT)
			{
				for(i=1;i<NUMBER_OF_IPX_VIRTUAL_PORTS;++i)
				{
					node = node->next;
					node->parameter[strlen(node->parameter)-1] = 0; 			

					strcat(node->parameter, ",");
					sprintf(rhs_string, "%08s %012s %04s\0", ipx_filter->network_number, ipx_filter->node_number, ipx_filter->socket_number);
					strcat(node->parameter, rhs_string);
					strcat(node->parameter, "\n");
				}
			}
			return temp_node;
		}
		node = get_next_entry_for_ipx_filter(section_to_which_it_belongs_to, node, (void*)&temp_filter);
	}

	/* We did not get right place for insertion lets create a new node */
#if 0
	strcpy(rhs_string, ipx_filter->network_number);
	strcat(rhs_string, " ");
	strcat(rhs_string, ipx_filter->node_number);
	strcat(rhs_string, " ");
	strcat(rhs_string, ipx_filter->socket_number);
#endif
	sprintf(rhs_string, "%08s %012s %04s\0", ipx_filter->network_number, ipx_filter->node_number, ipx_filter->socket_number);

  	switch(ipx_filter->physical_port)
  	{
  		case ETHERNET_PORT:
  			for(i=0;i<NUMBER_OF_IPX_VIRTUAL_PORTS;++i)
  			{
				if (i == NUMBER_OF_IPX_VIRTUAL_PORTS-1)
				{
					node = insert_missing_string_with_port(CM_IPX_SECTION, ipx_filter->physical_port + i, lhs_string, rhs_string);
					if (node)
						return node;
				}

  				if (insert_missing_string_with_port(CM_IPX_SECTION, ipx_filter->physical_port + i, lhs_string, rhs_string) == NULL)	
  					return NULL;
  			}

  		case WAN_PORT_1:
  		case WAN_PORT_2:
  		case WAN_PORT_3:
			node = insert_missing_string_with_port(CM_IPX_SECTION, ipx_filter->physical_port + NUMBER_OF_IPX_VIRTUAL_PORTS - 1, lhs_string, rhs_string);
  			return(node);
  		default:
  			return NULL;
	}
}

enum CM_REMOVE_STRING_RESULTS remove_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_IPX_FILTER* ipx_filter, temp_filter;
	BYTE lhs_string[100], saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node, *temp_node;
	BYTE filters_available_in_the_same_buffer = FALSE, i, temp_saved_index, temp_main_index;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_rhs;
	strcpy(lhs_string, "IPX ");

	switch(ipx_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}

	/* Prepare a string using given data, i.e data  from the filter 
	  to  delete */
	sprintf(temp_buffer2, "%08s %012s %04s\0", ipx_filter->network_number, ipx_filter->node_number, ipx_filter->socket_number);

	temp_filter = *(ipx_filter);
	if ((node = get_first_entry_for_ipx_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter)) == NULL)
	{
		printf("Get First Entry Failed to get the required string to remove\n");
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' and ',' */
		while (node->parameter[main_index++] != ',');

		do
		{
			sub_index = 0;
			saved_index = main_index - 1;

			/* Read a Filter Entry into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];
			temp_buffer1[sub_index] = 0;

			/* Are the filters Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
				/* Now We have to Blank Out from saved_index to  main_index */
				if ((node->parameter[main_index] == 0 || node->parameter[main_index] == '\n') && total_numbers_ipx_filters_in_the_current_node(node) == 1)
				{
					/* Now No More Entries are there in this line let us free this node */
					if (ipx_filter->physical_port > 0)
					{
						node->previous->next = node->next;
						node->next->previous = node->previous;
						free(node); /* If it is Ethernet Port free 4 nodes */
						return CM_REMOVING_STRING_SUCCESSFUL;
					}

					temp_node = node;
					for(i=0;i<NUMBER_OF_IPX_VIRTUAL_PORTS;++i)
					{
						node = temp_node;
						temp_node = node->next;
						node->previous->next = node->next;
						node->next->previous = node->previous;
						free(node); /* If it is Ethernet Port free 4 nodes */
					}
					return CM_REMOVING_STRING_SUCCESSFUL;
				}

				/* Some More Entries are there in this line let us remove given filter */

				/* Skip ',' 
				if (node->parameter[main_index] != '\n' && node->parameter[main_index] != 0)
					main_index ++; Not Reqd */

				temp_saved_index = saved_index;
				temp_main_index = main_index;

				while (node->parameter[main_index] != 0)
					node->parameter[saved_index++] = node->parameter[main_index++];
	   		node->parameter[saved_index] = 0;

				if (ipx_filter->physical_port == ETHERNET_PORT)
				{
					for(i=1;i<NUMBER_OF_IPX_VIRTUAL_PORTS;++i)
					{
						saved_index = temp_saved_index;
						main_index = temp_main_index;
						node = node->next;
						while (node->parameter[main_index] != 0)
							node->parameter[saved_index++] = node->parameter[main_index++];
	   				node->parameter[saved_index] = 0;
					}
				}

				/* We have done our work. lets go back */
				return CM_REMOVING_STRING_SUCCESSFUL;
			}
			else
			{
				/* The Match failed between given filter and the read filter 
					if some more filters are there then lets continue reading 
					them otherwise let us try to read filter from next line/node */

				if (node->parameter[main_index] == 0)		
					filters_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					filters_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (filters_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_entry_for_ipx_filter(CM_IPX_SECTION, node, (void*)&temp_filter);
	}
	while (node);
	printf("Failed to search node  for removing entry from filter\n");
	/* Ohhh No , after doing all these stuffs we failed to match the filter
	   lets kick the caller ...Caller Take this */
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}

enum CM_EDIT_STRING_RESULTS edit_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs)
{
	
	enum CM_REMOVE_STRING_RESULTS delete_result;
	STRUCT_IPX_FILTER* ipx_filter;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_new_rhs;

	/* Validation ... */
	if (strlen(ipx_filter->network_number) > 8 || strlen(ipx_filter->network_number) == 0)
		return CM_EDITING_FAILED_ON_VALIDATION;	
	if (!is_valid_ipx_network_number(ipx_filter->network_number)) 
		return CM_EDITING_FAILED_ON_VALIDATION;

	if (strlen(ipx_filter->node_number) > 12 || strlen(ipx_filter->node_number) == 0)
		return CM_EDITING_FAILED_ON_VALIDATION;	
	if (!is_valid_ipx_network_number(ipx_filter->node_number)) /* No Confusion please, this function just checks for bounds ok. I will adjust in the future */ 
		return CM_EDITING_FAILED_ON_VALIDATION;

	if (strlen(ipx_filter->socket_number) > 4 || strlen(ipx_filter->socket_number) == 0)	
		return CM_EDITING_FAILED_ON_VALIDATION;	
	if (!is_valid_ipx_network_number(ipx_filter->socket_number)) /* No Confusion please, this function just checks for bounds ok. I will adjust in the future */ 
		return CM_EDITING_FAILED_ON_VALIDATION;
	/* ... Validation */

	delete_result = remove_ipx_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	if ( insert_ipx_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	return CM_STRING_EDIT_SUCCESSFUL; 

#if 0	
			*** OLD CODE . I DON'T THINK IT IS GOOD ***
	STRUCT_IPX_FILTER* ipx_filter, *ipx_new_filter, temp_filter;
	BYTE lhs_string[100], saved_index, main_index, sub_index, i, temp_buffer1[200], temp_buffer2[200], filters_available_in_the_same_buffer = FALSE;
	PARAMETER_NODE* node;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_old_rhs;
	ipx_new_filter = (STRUCT_IPX_FILTER*)vptr_new_rhs;

	strcpy(lhs_string, "IPX ");

	switch(ipx_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	}

	/* Prepare a string using given data, i.e data  from the filter 
	  to  edit */
	sprintf(temp_buffer2, "%08s %012s %04s\0", ipx_new_filter->network_number, ipx_new_filter->node_number, ipx_new_filter->socket_number);

	temp_filter = *(ipx_filter);
	if ((node = get_first_entry_for_ipx_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter)) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;

	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' and ',' */
		while (node->parameter[main_index++] != ',');

		do
		{
			sub_index = 0;
			saved_index = main_index;

			/* Read a Filter Entry into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0)
				temp_buffer1[sub_index++] = node->parameter[main_index++];
			temp_buffer1[sub_index] = 0;

			/* Are the filters Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
				/* Lets overwrite the new Stuff */
				i = 0;
				while(saved_index < main_index)
					node->parameter[saved_index++] = temp_buffer2[i++];

				/* We have done our work. lets go back */
				return CM_STRING_EDIT_SUCCESSFUL;
			}
			else
			{
				/* The Match failed between given filter and the read filter 
					if some more filters are there then lets continue reading 
					them otherwise let us try to read filter from next line/node */

				if (node->parameter[main_index] == 0)		
					filters_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					filters_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (filters_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_entry_for_ipx_filter(CM_IPX_SECTION, node, (void*)&temp_filter);
	}
	while (node);

	/* Ohhh No , after doing all these stuffs we failed to match the filter
	   lets kick the caller ...Caller Take this */
	return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
#endif
}


/* Note: To this function if u give section number and lhs string
			i will going to search the ipx filter  and fill the
			reqd things in the structre addres of which u typecasted to void*.
			I have one request here fill the port number and filter type in the
			STRUCTURE while sending . This is IMPORTANT.
*/


PARAMETER_NODE* get_first_entry_for_ipx_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, 
																				 BYTE* bptr_lhs_string, 
																				 void* vptr_rhs)
{
	STRUCT_IPX_FILTER* ipx_filter;
	PARAMETER_NODE* node;
	BYTE i, j;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_rhs;

	for(i=0 ; i<4 ; ++i) /* Replace this magic 4 by constant - 4 filter types */
	{
		ipx_filter->filter_type = i;
		for(j=0;j<4;++j) /* Replace this 4 by constant - 4 ports */
		{
			ipx_filter->physical_port = j;
			node = get_first_entry_for_ipx_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)ipx_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				the_lastly_given_filter_in_the_current_node(1, TRUE);
				return node;
			}
		}
	}
	return NULL;
}

PARAMETER_NODE* get_first_entry_for_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs)
{
	
	STRUCT_IPX_FILTER* ipx_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200];
	BYTE network_number[NETWORK_NUMBER_LENGTH], node_number[NODE_NUMBER_LENGTH], socket_number[SOCKET_NUMBER_LENGTH];
	PARAMETER_NODE* search_to_start_at;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_rhs;

	port_number = ipx_filter->physical_port;
#if 0
	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)
		return NULL;
#endif
	/* If the port number is for WAN then add 3 to it  to make correct search*/
	if (port_number > 0)
		port_number +=	(NUMBER_OF_IPX_VIRTUAL_PORTS-1);

	strcpy(lhs_string, "IPX ");

	switch(ipx_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}
	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
			return NULL;	
		if (port_number_matched)
			break;
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This is not required
				while (buffer[i++] != ','); */

		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

#if 0
		sscanf(temp_buffer, "%s %s %s", network_number, node_number, socket_number);
		strcpy(ipx_filter->network_number, network_number);
		strcpy(ipx_filter->node_number, node_number);
		strcpy(ipx_filter->socket_number, socket_number);
#endif
		i = j = 0;

		while(temp_buffer[i] != ' ')
			ipx_filter->network_number[j++] = temp_buffer[i++];
		ipx_filter->network_number[j] = 0;

		i++;
		j = 0;
		while(temp_buffer[i] != ' ')
			ipx_filter->node_number[j++] = temp_buffer[i++];
		ipx_filter->node_number[j] = 0;


		i++;
		j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0)
			ipx_filter->socket_number[j++] = temp_buffer[i++];
		ipx_filter->socket_number[j] = 0;

		return search_to_start_at;
	}
	return NULL;
}



PARAMETER_NODE* get_next_entry_for_ipx_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_IPX_FILTER* ipx_filter;
	PARAMETER_NODE* node;
	BYTE i, starting_point, port_number, j, filter_type;

	filter_type = lastly_given_filter_type(NULL, FALSE);
	port_number = lastly_given_filter_port(NULL, FALSE);

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_rhs;

	ipx_filter->physical_port = port_number;
	ipx_filter->filter_type  = filter_type;

	node = get_next_entry_for_ipx_filter(section_to_which_it_belongs_to, current_node, (void*)ipx_filter);
	if (node != NULL)
	{
		return node;
	}
	starting_point = port_number+1;
	for(i=filter_type;i<4;++i) /* Replace this magic 4 by constant */
	{
		ipx_filter->filter_type = i;
		for(j=starting_point;j<4;++j)
		{
			ipx_filter->physical_port = j;
			node = get_first_entry_for_ipx_filter(section_to_which_it_belongs_to, NULL, (void*)ipx_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				the_lastly_given_filter_in_the_current_node(1, TRUE);
				return node;
			}
		}
		starting_point = 0;
	}
	return NULL;
}



PARAMETER_NODE* get_next_entry_for_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	
	STRUCT_IPX_FILTER* ipx_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200], main_index, sub_index;
	BYTE network_number[NETWORK_NUMBER_LENGTH], node_number[NODE_NUMBER_LENGTH], socket_number[SOCKET_NUMBER_LENGTH];
	BYTE prev_count, total;
	PARAMETER_NODE* search_to_start_at;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_rhs;
	port_number = ipx_filter->physical_port;

#if 0
	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)  /* Replace this with max no ports */
		return NULL;
#endif

	/* If the port number is for WAN then add 3 to it  to make correct search*/
	if (port_number > 0)
		port_number +=	(NUMBER_OF_IPX_VIRTUAL_PORTS-1);

	strcpy(lhs_string, "IPX ");

	switch(ipx_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}


	prev_count = the_lastly_given_filter_in_the_current_node(NULL, FALSE);
	total = total_numbers_ipx_filters_in_the_current_node(current_node);
	if (prev_count < total)
	{
		/* one more entry we can read from the cuurent node itself */
		/* Skip first prev_count entries */
		for(i=0;i<=prev_count;++i)
			while(current_node->parameter[main_index++] != ','); /* There is no need to check for '\0', because we are sure that one more entry exists */
		/* Read  the next entry */
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			temp_buffer[sub_index++] = current_node->parameter[main_index++];
		temp_buffer[sub_index]  = 0; /* Terminate the String */

		i = j = 0;
		while(temp_buffer[i] != ' ')
			ipx_filter->network_number[j++] = temp_buffer[i++];
		ipx_filter->network_number[j] = 0;

		i++;
		j = 0;
		while(temp_buffer[i] != ' ')
			ipx_filter->node_number[j++] = temp_buffer[i++];
		ipx_filter->node_number[j] = 0;


		i++;
		j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0)
			ipx_filter->socket_number[j++] = temp_buffer[i++];
		ipx_filter->socket_number[j] = 0;


		the_lastly_given_filter_in_the_current_node(prev_count+1, TRUE);
		return current_node;
	}
	else
	{
		/* get next matching node */
		search_to_start_at = current_node;
		for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return NULL;	
			if (port_number_matched)
				break;
		}
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This not required
			while (buffer[i++] != ','); */
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		i = j = 0;

		while(temp_buffer[i] != ' ')
			ipx_filter->network_number[j++] = temp_buffer[i++];
		ipx_filter->network_number[j] = 0;

		i++;
		j = 0;
		while(temp_buffer[i] != ' ')
			ipx_filter->node_number[j++] = temp_buffer[i++];
		ipx_filter->node_number[j] = 0;


		i++;
		j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0 && temp_buffer[i] != '\n')
			ipx_filter->socket_number[j++] = temp_buffer[i++];
		ipx_filter->socket_number[j] = 0;


		the_lastly_given_filter_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}





PARAMETER_NODE* get_previous_entry_for_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	PARAMETER_NODE* node, *prev_node;
	STRUCT_IPX_FILTER temp_ipx_filter, *ipx_filter;

	ipx_filter = (STRUCT_IPX_FILTER*)vptr_rhs;
	node = get_first_entry_for_ipx_filter_main_function(section_to_which_it_belongs_to, NULL, (void*)ipx_filter);

	if (node == NULL)
		return NULL;

	if (node == current_node)
	{
		return NULL;
	}
 
	while (node  && node != current_node)
	{
		prev_node = node;
	  	temp_ipx_filter = *(ipx_filter);
		node = get_next_entry_for_ipx_filter_main_function(section_to_which_it_belongs_to, node, (void*)ipx_filter);
	}
	if (!node)
		return NULL;

	*(ipx_filter) = temp_ipx_filter;
	return prev_node;
}


BYTE total_numbers_ipx_filters_in_the_current_node(PARAMETER_NODE* node)
{
	/* Here i am searching for number of ','s -> this count will give me
	   the number of filter entries in the node */
	BYTE number_of_filters = 0, i;

	for(i=0;i<=strlen(node->parameter);++i)
		if (node->parameter[i] == ',')
			number_of_filters++;
	return number_of_filters;
}	

/*************************************************************************
					... FUNCTION'S TO HANDLE IPX Filter ENDS HERE
**************************************************************************/



/*************************************************************************
					FUNCTION'S TO HANDLE SPANTREE Filter Starts HERE ...
**************************************************************************/

BYTE total_numbers_stp_filters_in_the_current_node(PARAMETER_NODE* node)
{
	/* Here i am searching for number of ','s -> this count will give me
	   the number of filter entries in the node */
	BYTE number_of_filters = 0, i;

	for(i=0;i<=strlen(node->parameter);++i)
		if (node->parameter[i] == ',')
			number_of_filters++;
	return number_of_filters;
}	


PARAMETER_NODE* insert_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs)
{
	STRUCT_STP_FILTER* stp_filter, temp_filter;
	BYTE lhs_string[100], i, rhs_string[200];
	PARAMETER_NODE* node;

	stp_filter = (STRUCT_STP_FILTER*)vptr_rhs;
	strcpy(lhs_string, "Spanning Tree ");


	if (strlen(stp_filter->ethernet_address) > 12 || strlen(stp_filter->ethernet_address) == 0)
		return NULL;	
	if (!is_valid_ipx_network_number(stp_filter->ethernet_address)) 
		return NULL;

	switch(stp_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}

	/* Check whether a node already present so that we can append the
		new entry to it  Note: iff number of filters present is less then
		3 (Magic Number!!!) 
	*/
	temp_filter = *(stp_filter);
	node = get_first_entry_for_stp_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter);

	while(node)
	{
		if (total_numbers_stp_filters_in_the_current_node(node) < 3)
		{
			/* Already a node is there just go and append there */

			/* Remove '\n' to append new entry */
			node->parameter[strlen(node->parameter)-1] = 0; 			

			strcat(node->parameter, ",");
			sprintf(rhs_string, "%012s\0", stp_filter->ethernet_address);
			strcat(node->parameter, rhs_string);
			strcat(node->parameter, "\n");
			return node;
		}
		node = get_next_entry_for_stp_filter(section_to_which_it_belongs_to, node, (void*)&temp_filter);
	}

	/* We did not get right place for insertion lets create a new node */
	sprintf(rhs_string, "%012s\0", stp_filter->ethernet_address);

  	switch(stp_filter->physical_port)
  	{
  		case ETHERNET_PORT:
  			return(insert_missing_string_with_port(CM_SPANTREE_SECTION, stp_filter->physical_port, lhs_string, rhs_string));
  		case WAN_PORT_1:
  			return(insert_missing_string_with_port(CM_SPANTREE_SECTION, stp_filter->physical_port, lhs_string, rhs_string));
  		case WAN_PORT_2:
  			return(insert_missing_string_with_port(CM_SPANTREE_SECTION, stp_filter->physical_port, lhs_string, rhs_string));
  		case WAN_PORT_3:
  			return(insert_missing_string_with_port(CM_SPANTREE_SECTION, stp_filter->physical_port, lhs_string, rhs_string));
  		default:
  			return NULL;
	}
}

enum CM_REMOVE_STRING_RESULTS remove_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_STP_FILTER* stp_filter, temp_filter;
	BYTE lhs_string[100], saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node, *temp_node;
	BYTE filters_available_in_the_same_buffer = FALSE, i;

	stp_filter = (STRUCT_STP_FILTER*)vptr_rhs;
	strcpy(lhs_string, "Spanning Tree ");

	switch(stp_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}

	/* Prepare a string using given data, i.e data  from the filter 
	  to  delete */
	sprintf(temp_buffer2, "%012s\0", stp_filter->ethernet_address);

	temp_filter = *(stp_filter);
	if ((node = get_first_entry_for_stp_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter)) == NULL)
	{
		printf("Get First Entry Failed to get the required string to remove\n");
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' and ',' */
		while (node->parameter[main_index++] != ',');

		do
		{
			sub_index = 0;
			saved_index = main_index - 1;

			/* Read a Filter Entry into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];
			temp_buffer1[sub_index] = 0;

			/* Are the filters Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
				/* Now We have to Blank Out from saved_index to  main_index */
				if ((node->parameter[main_index] == 0 || node->parameter[main_index] == '\n') && total_numbers_stp_filters_in_the_current_node(node) == 1)
				{
					/* Now No More Entries are there in this line let us free this node */
					node->previous->next = node->next;
					node->next->previous = node->previous;
					free(node); 
					return CM_REMOVING_STRING_SUCCESSFUL;
				}

				/* Some More Entries are there in this line let us remove given filter */

				/* Skip ',' 
				if (node->parameter[main_index] != '\n' && node->parameter[main_index] != 0)
					main_index ++; Not Reqd */

				while (node->parameter[main_index] != 0)
					node->parameter[saved_index++] = node->parameter[main_index++];
	   		node->parameter[saved_index] = 0;

				/* We have done our work. lets go back */
				return CM_REMOVING_STRING_SUCCESSFUL;
			}
			else
			{
				/* The Match failed between given filter and the read filter 
					if some more filters are there then lets continue reading 
					them otherwise let us try to read filter from next line/node */

				if (node->parameter[main_index] == 0)		
					filters_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					filters_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (filters_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_entry_for_stp_filter(CM_SPANTREE_SECTION, node, (void*)&temp_filter);
	}
	while (node);
	printf("Failed to search node  for removing entry from filter\n");
	/* Ohhh No , after doing all these stuffs we failed to match the filter
	   lets kick the caller ...Caller Take this */
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}

enum CM_EDIT_STRING_RESULTS edit_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs)
{
	enum CM_REMOVE_STRING_RESULTS delete_result;
	STRUCT_STP_FILTER* stp_filter;

	/* Validation ... */
	stp_filter = (STRUCT_STP_FILTER*)vptr_new_rhs;

	if (strlen(stp_filter->ethernet_address) > 12 || strlen(stp_filter->ethernet_address) == 0)
		return CM_EDITING_FAILED_ON_VALIDATION;	
	if (!is_valid_ipx_network_number(stp_filter->ethernet_address)) 
		return CM_EDITING_FAILED_ON_VALIDATION;
	/* ... Validation */

	delete_result = remove_stp_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	if ( insert_stp_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	return CM_STRING_EDIT_SUCCESSFUL;
}


PARAMETER_NODE* get_first_entry_for_stp_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, 
																				 BYTE* bptr_lhs_string, 
																				 void* vptr_rhs)
{
	STRUCT_STP_FILTER* stp_filter;
	PARAMETER_NODE* node;
	BYTE i, j;

	stp_filter = (STRUCT_STP_FILTER*)vptr_rhs;

	for(i=0;i<4;++i) /* Replace this magic 4 by constant - 4 filter types */
	{
		stp_filter->filter_type = i;
		for(j=0;j<4;++j) /* Replace this 4 by constant - 4 ports */
		{
			stp_filter->physical_port = j;
			node = get_first_entry_for_stp_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)stp_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				return node;
			}
		}
	}
	return NULL;
}

PARAMETER_NODE* get_first_entry_for_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs)
{
	
	STRUCT_STP_FILTER* stp_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200];
	PARAMETER_NODE* search_to_start_at;

	stp_filter = (STRUCT_STP_FILTER*)vptr_rhs;

	port_number = stp_filter->physical_port;

	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)
		return NULL;


	strcpy(lhs_string, "Spanning Tree ");

	switch(stp_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}
	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
			return NULL;	
		if (port_number_matched)
			break;
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This is not required
				while (buffer[i++] != ','); */
		j = 0;
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		i = j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0)
			stp_filter->ethernet_address[j++] = temp_buffer[i++];
		stp_filter->ethernet_address[j] = 0;
		the_lastly_given_filter_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}


PARAMETER_NODE* get_next_entry_for_stp_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_STP_FILTER* stp_filter;
	PARAMETER_NODE* node;
	BYTE i, starting_point, port_number, j, filter_type;

	filter_type = lastly_given_filter_type(NULL, FALSE);
	port_number = lastly_given_filter_port(NULL, FALSE);

	stp_filter = (STRUCT_STP_FILTER*)vptr_rhs;
	stp_filter->physical_port = port_number;
	stp_filter->filter_type  = filter_type;
	node = get_next_entry_for_stp_filter(section_to_which_it_belongs_to, current_node, (void*)stp_filter);
	if (node != NULL)
	{
		return node;
	}
	starting_point = port_number+1;
	for(i=filter_type;i<4;++i) /* Replace this magic 4 by constant */
	{
		stp_filter->filter_type = i;
		for(j=starting_point;j<4;++j)
		{
			stp_filter->physical_port = j;
			node = get_first_entry_for_stp_filter(section_to_which_it_belongs_to, NULL, (void*)stp_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				the_lastly_given_filter_in_the_current_node(1, TRUE);
				return node;
			}
		}
		starting_point = 0;
	}
	return NULL;
}


PARAMETER_NODE* get_next_entry_for_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_STP_FILTER* stp_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200], main_index, sub_index;
	BYTE prev_count, total;
	PARAMETER_NODE* search_to_start_at;

	stp_filter = (STRUCT_STP_FILTER*)vptr_rhs;
	port_number = stp_filter->physical_port;

	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)  /* Replace this with max no ports */
		return NULL;

	strcpy(lhs_string, "Spanning Tree ");

	switch(stp_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}


	prev_count = the_lastly_given_filter_in_the_current_node(NULL, FALSE);
	total = total_numbers_stp_filters_in_the_current_node(current_node);
	if (prev_count < total)
	{
		/* one more entry we can read from the cuurent node itself */
		/* Skip first prev_count entries */
		for(i=0;i<=prev_count;++i)
			while(current_node->parameter[main_index++] != ','); /* There is no need to check for '\0', because we are sure that one more entry exists */

		/* Read  the next entry */
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			temp_buffer[sub_index++] = current_node->parameter[main_index++];
		temp_buffer[sub_index]  = 0; /* Terminate the String */
		i = j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0)
			stp_filter->ethernet_address[j++] = temp_buffer[i++];
		stp_filter->ethernet_address[j] = 0;

		the_lastly_given_filter_in_the_current_node(prev_count+1, TRUE);
		return current_node;
	}
	else
	{
		/* get next matching node */
		search_to_start_at = current_node;
		for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return NULL;	
			if (port_number_matched)
				break;
		}
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This not required
			while (buffer[i++] != ','); */
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		i = j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0 && temp_buffer[i] != '\n')
			stp_filter->ethernet_address[j++] = temp_buffer[i++];
		stp_filter->ethernet_address[j] = 0;

		the_lastly_given_filter_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_previous_entry_for_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
}
/*************************************************************************
					... FUNCTION'S TO HANDLE SPANTREE Filter ENDS HERE
**************************************************************************/

#endif /* ... This Code not required for Proxy Server */


/*************************************************************************
					FUNCTION'S TO HANDLE IP Port Filter Starts HERE ...
**************************************************************************/
BYTE total_numbers_ip_port_filters_in_the_current_node(PARAMETER_NODE* node)
{
	/* Here i am searching for number of ','s -> this count will give me
	   the number of filter entries in the node */
	BYTE number_of_filters = 0, i;

	for(i=0;i<=strlen(node->parameter);++i)
		if (node->parameter[i] == ',')
			number_of_filters++;
	return (number_of_filters/2);
}	


PARAMETER_NODE* insert_ip_port_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs)
{
	STRUCT_IP_PORT_FILTER* ip_filter, temp_filter;
	BYTE lhs_string[100], rhs_string[200];
	PARAMETER_NODE* node;

	ip_filter = (STRUCT_IP_PORT_FILTER*)vptr_rhs;

	if (strlen(ip_filter->protocol_port) > 4 && strlen(ip_filter->protocol_port) == 0)
		return NULL;	
	if (!is_valid_ipx_network_number(ip_filter->protocol_port)) /* No Confusion please, this function just checks for bounds(ok). I will adjust in the future */ 
		return NULL;
	strcpy(lhs_string, "IP ");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Port");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Port");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Port");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Port");
			break;
		default:
			return NULL;
	}

	/* Check whether a node already present so that we can append the
		new entry to it  Note: iff number of filters present is less then
		3 (Magic Number!!!) 
	*/
	temp_filter = *(ip_filter);
	node = get_first_entry_for_ip_port_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter);

	while(node)
	{
		if (total_numbers_ip_port_filters_in_the_current_node(node) < 3)
		{
			/* Already a node is there just go and append there */

			/* Remove '\n' to append new entry */
			node->parameter[strlen(node->parameter)-1] = 0; 			

			strcat(node->parameter, ",");
			if (ip_filter->protocol == PROTOCOL_TCP)
				sprintf(rhs_string, "TCP,%04s\0", ip_filter->protocol_port);
			else
				sprintf(rhs_string, "UDP,%04s\0", ip_filter->protocol_port);

			strcat(node->parameter, rhs_string);
			strcat(node->parameter, "\n");
			return node;
		}
		node = get_next_entry_for_ip_port_filter(section_to_which_it_belongs_to, node, (void*)&temp_filter);
	}

	/* We did not get right place for insertion lets create a new node */
	if (ip_filter->protocol == PROTOCOL_TCP)
		sprintf(rhs_string, "TCP,%04s\0", ip_filter->protocol_port);
	else
		sprintf(rhs_string, "UDP,%04s\0", ip_filter->protocol_port);
		

 	return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
#if 0
  	switch(ip_filter->physical_port)
  	{
  		case ETHERNET_PORT:
#if 0 /* Not Required for FIREWALL */
  		case WAN_PORT_1:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
  		case WAN_PORT_2:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
  		case WAN_PORT_3:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
#endif
  		default:
  			return NULL;
	}
#endif
}

enum CM_REMOVE_STRING_RESULTS remove_ip_port_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_IP_PORT_FILTER* ip_filter, temp_filter;
	BYTE lhs_string[100], saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node;
	BYTE filters_available_in_the_same_buffer = FALSE;

	ip_filter = (STRUCT_IP_PORT_FILTER*)vptr_rhs;
	strcpy(lhs_string, "IP ");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Port");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Port");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Port");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Port");
			break;
		default:
			return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}

	/* Prepare a string using given data, i.e data  from the filter 
	  to  delete */
	if (ip_filter->protocol == PROTOCOL_TCP)
		sprintf(temp_buffer2, "TCP,%04s\0", ip_filter->protocol_port);
	else
		sprintf(temp_buffer2, "UDP,%04s\0", ip_filter->protocol_port);
		
	temp_filter = *(ip_filter);
	if ((node = get_first_entry_for_ip_port_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter)) == NULL)
	{
		printf("Get First Entry Failed to get the required string to remove\n");
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' and ',' */
		while (node->parameter[main_index++] != ',');

		do
		{
			sub_index = 0;
			saved_index = main_index - 1;

			/* Read a Filter Entry into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 2 ',' will be there hence read one again to get the full
			    entry */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];
			temp_buffer1[sub_index] = 0;
			/* Are the filters Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
				/* Now We have to Blank Out from saved_index to  main_index */
				if ((node->parameter[main_index] == 0 || node->parameter[main_index] == '\n') && total_numbers_ip_port_filters_in_the_current_node(node) == 1)
				{
					/* Now No More Entries are there in this line let us free this node */
					node->previous->next = node->next;
					node->next->previous = node->previous;
					free(node); /* If it is Ethernet Port free 4 nodes */
					return CM_REMOVING_STRING_SUCCESSFUL;
				}

				/* Some More Entries are there in this line let us remove given filter */

				/* Skip ',' 
				if (node->parameter[main_index] != '\n' && node->parameter[main_index] != 0)
					main_index ++; Not Reqd */

				while (node->parameter[main_index] != 0)
					node->parameter[saved_index++] = node->parameter[main_index++];
	   		node->parameter[saved_index] = 0;

				/* We have done our work. lets go back */
				return CM_REMOVING_STRING_SUCCESSFUL;
			}
			else
			{
				/* The Match failed between given filter and the read filter 
					if some more filters are there then lets continue reading 
					them otherwise let us try to read filter from next line/node */

				if (node->parameter[main_index] == 0)		
					filters_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					filters_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (filters_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_entry_for_ip_port_filter(CM_IP_SECTION, node, (void*)&temp_filter);
	}
	while (node);
	printf("Failed to search node  for removing entry from filter\n");
	/* Ohhh No , after doing all these stuffs we failed to match the filter
	   lets kick the caller ...Caller Take this */
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}

enum CM_EDIT_STRING_RESULTS edit_ip_port_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs)
{
	
	enum CM_REMOVE_STRING_RESULTS delete_result;
	STRUCT_IP_PORT_FILTER* ip_filter;

	/* Validation ... */
	ip_filter = (STRUCT_IP_PORT_FILTER*)vptr_new_rhs;
	if (strlen(ip_filter->protocol_port) > 4 && strlen(ip_filter->protocol_port) == 0)
		return CM_EDITING_FAILED_ON_VALIDATION;	
	if (!is_valid_ipx_network_number(ip_filter->protocol_port)) /* No Confusion please, this function just checks for bounds ok. I will adjust in the future */ 
		return CM_EDITING_FAILED_ON_VALIDATION;
	/* ... Validation  */

	delete_result = remove_ip_port_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	if ( insert_ip_port_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	return CM_STRING_EDIT_SUCCESSFUL; 
}

PARAMETER_NODE* get_first_entry_for_ip_port_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs)
{
	STRUCT_IP_PORT_FILTER* ip_filter;
	PARAMETER_NODE* node;
	BYTE i, j;
   USHORT number_of_physical_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS) + lsl_control(GET_NUMBER_OF_WAN_PORTS) ;

	ip_filter = (STRUCT_IP_PORT_FILTER*)vptr_rhs;

	for(i=0;i<4;++i) /* Replace this magic 4 by constant - 4 filter types */
	{
		ip_filter->filter_type = i;
		for(j=0;j<number_of_physical_ports;++j)
		{
			ip_filter->physical_port = j;
			node = get_first_entry_for_ip_port_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)ip_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				return node;
			}
		}
	}
	return NULL;
}

PARAMETER_NODE* get_first_entry_for_ip_port_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs)
{
	STRUCT_IP_PORT_FILTER* ip_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200];
	PARAMETER_NODE* search_to_start_at;

	ip_filter = (STRUCT_IP_PORT_FILTER*)vptr_rhs;

	port_number = ip_filter->physical_port;

	/* If invalid port number get lost */
#if 0
	if (port_number > 1) 
		return NULL;
#endif

	strcpy(lhs_string, "IP ");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Port");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Port");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Port");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Port");
			break;
		default:
			return NULL;
	}
	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
			return NULL;	
		if (port_number_matched)
			break;
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This is not required
				while (buffer[i++] != ','); */

		j = 0;
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		if (!strcmpi(temp_buffer, "TCP"))
		{
			ip_filter->protocol = PROTOCOL_TCP;
		}
		else
		{
			ip_filter->protocol = PROTOCOL_UDP;
		}

		j = 0;
		i++; /* Skip ',' */
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			ip_filter->protocol_port[j++] = buffer[i++];
		ip_filter->protocol_port[j] = 0;

		the_lastly_given_filter_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}



PARAMETER_NODE* get_next_entry_for_ip_port_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_IP_PORT_FILTER* ip_filter;
	PARAMETER_NODE* node;
	BYTE i, starting_point, port_number, j, filter_type;
   USHORT number_of_physical_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS) + lsl_control(GET_NUMBER_OF_WAN_PORTS) ;

	filter_type = lastly_given_filter_type(NULL, FALSE);
	port_number = lastly_given_filter_port(NULL, FALSE);

	ip_filter = (STRUCT_IP_PORT_FILTER*)vptr_rhs;
	ip_filter->physical_port = port_number;
	ip_filter->filter_type  = filter_type;
	node = get_next_entry_for_ip_port_filter(section_to_which_it_belongs_to, current_node, (void*)ip_filter);
	if (node != NULL)
	{
		return node;
	}
	starting_point = port_number+1;
	for(i=filter_type;i<4;++i) /* Replace this magic 4 by constant */
	{
		ip_filter->filter_type = i;
		for(j=starting_point;j<number_of_physical_ports;++j)
		{
			ip_filter->physical_port = j;
			node = get_first_entry_for_ip_port_filter(section_to_which_it_belongs_to, NULL, (void*)ip_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				the_lastly_given_filter_in_the_current_node(1, TRUE);
				return node;
			}
		}
		starting_point = 0;
	}
	return NULL;
}


PARAMETER_NODE* get_next_entry_for_ip_port_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_IP_PORT_FILTER* ip_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, main_index, sub_index, protocol[10];
	BYTE prev_count, total;
	PARAMETER_NODE* search_to_start_at;

	ip_filter = (STRUCT_IP_PORT_FILTER*)vptr_rhs;
	port_number = ip_filter->physical_port;

#if 0
	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)  /* Replace this with max no ports */
		return NULL;
#endif

	strcpy(lhs_string, "IP ");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Port");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Port");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Port");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Port");
			break;
		default:
			return NULL;
	}


	prev_count = the_lastly_given_filter_in_the_current_node(NULL, FALSE);
	total = total_numbers_ip_port_filters_in_the_current_node(current_node);
	if (prev_count < total)
	{
		/* one more entry we can read from the cuurent node itself */
		/* Skip first prev_count entries */

		main_index = 0;
		for(i=0;i<=2*prev_count;++i)
			while(current_node->parameter[main_index++] != ','); /* There is no need to check for '\0', because we are sure that one more entry exists */

		/* Read  the next entry */
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			protocol[sub_index++] = current_node->parameter[main_index++];
		protocol[sub_index]  = 0; /* Terminate the String */

		if (!strcmpi(protocol, "TCP"))
		{
			ip_filter->protocol = PROTOCOL_TCP;
		}
		else
		{
			ip_filter->protocol = PROTOCOL_UDP;
		}


		main_index++;
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			ip_filter->protocol_port[sub_index++] = current_node->parameter[main_index++];
		ip_filter->protocol_port[sub_index]  = 0; /* Terminate the String */

		the_lastly_given_filter_in_the_current_node(prev_count+1, TRUE);
		return current_node;
	}
	else
	{
		/* get next matching node */
		search_to_start_at = current_node;
		for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return NULL;	
			if (port_number_matched)
				break;
		}
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This not required
			while (buffer[i++] != ','); */

		j = 0;

		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			protocol[j++] = buffer[i++];
		protocol[j] = 0;

		if (!strcmpi(protocol, "TCP"))
		{
			ip_filter->protocol = PROTOCOL_TCP;
		}
		else
		{
			ip_filter->protocol = PROTOCOL_UDP;
		}

		i++;
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			ip_filter->protocol_port[j++] = buffer[i++];
		ip_filter->protocol_port[j] = 0;

		the_lastly_given_filter_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_previous_entry_for_ip_port_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
}
/*************************************************************************
					... FUNCTION'S TO HANDLE IP Port Filter ENDS HERE
**************************************************************************/


/*************************************************************************
					FUNCTION'S TO HANDLE IP Addrss Filter Starts HERE ...
**************************************************************************/
BYTE total_numbers_ip_address_filters_in_the_current_node(PARAMETER_NODE* node)
{
	/* Here i am searching for number of ','s -> this count will give me
	   the number of filter entries in the node */
	BYTE number_of_filters = 0, i;

	for(i=0;i<=strlen(node->parameter);++i)
		if (node->parameter[i] == ',')
			number_of_filters++;
	return number_of_filters;
}	

PARAMETER_NODE* insert_ip_address_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
							BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_IP_ADDRESS_FILTER* ip_filter, temp_filter;
	BYTE lhs_string[100], rhs_string[200];
	PARAMETER_NODE* node;

	ip_filter = (STRUCT_IP_ADDRESS_FILTER*)vptr_rhs;

	if (!is_an_ip_address(ip_filter->ip_address))
	{
		printf("Not a Valid IP Address\n");
		return NULL;
	}

	strcpy(lhs_string, "IP ");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}

	/* Check whether a node already present so that we can append the
		new entry to it  Note: iff number of filters present is less then
		3 (Magic Number!!!) 
	*/
	temp_filter = *(ip_filter);
	node = get_first_entry_for_ip_address_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter);

	while(node)
	{
		if (total_numbers_ip_address_filters_in_the_current_node(node) < 3)
		{
			/* Already a node is there just go and append there */

			/* Remove '\n' to append new entry */
			node->parameter[strlen(node->parameter)-1] = 0; 			

			strcat(node->parameter, ",");
			sprintf(rhs_string, "%s\0", ip_filter->ip_address);
			strcat(node->parameter, rhs_string);
			strcat(node->parameter, "\n");
			return node;
		}
		node = get_next_entry_for_ip_address_filter(section_to_which_it_belongs_to, node, (void*)&temp_filter);
	}

	/* We did not get right place for insertion lets create a new node */
	sprintf(rhs_string, "%s\0", ip_filter->ip_address);
	return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));

#if 0
  	switch(ip_filter->physical_port)
  	{
  		case ETHERNET_PORT:
#if 0 /* Not Required for FIREWALL */
  		case WAN_PORT_1:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
  		case WAN_PORT_2:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
  		case WAN_PORT_3:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
#endif
  		default:
  			return NULL;
	}
#endif

}

enum CM_REMOVE_STRING_RESULTS remove_ip_address_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
												BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_IP_ADDRESS_FILTER* ip_filter, temp_filter;
	BYTE lhs_string[100], saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node;
	BYTE filters_available_in_the_same_buffer = FALSE;

	ip_filter = (STRUCT_IP_ADDRESS_FILTER*)vptr_rhs;
	strcpy(lhs_string, "IP");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}

	/* Prepare a string using given data, i.e data  from the filter 
	  to  delete */
	sprintf(temp_buffer2, "%s\0", ip_filter->ip_address);

	temp_filter = *(ip_filter);
	if ((node = get_first_entry_for_ip_address_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_filter)) == NULL)
	{
		printf("Get First Entry Failed to get the required string to remove\n");
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' and ',' */
		while (node->parameter[main_index++] != ',');

		do
		{
			sub_index = 0;
			saved_index = main_index - 1;

			/* Read a Filter Entry into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];
			temp_buffer1[sub_index] = 0;

			/* Are the filters Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
				/* Now We have to Blank Out from saved_index to  main_index */
				if ((node->parameter[main_index] == 0 || node->parameter[main_index] == '\n') && total_numbers_ip_address_filters_in_the_current_node(node) == 1)
				{
					/* Now No More Entries are there in this line let us free this node */
					node->previous->next = node->next;
					node->next->previous = node->previous;
					free(node); 
					return CM_REMOVING_STRING_SUCCESSFUL;
				}

				/* Some More Entries are there in this line let us remove given filter */

				/* Skip ',' 
				if (node->parameter[main_index] != '\n' && node->parameter[main_index] != 0)
					main_index ++; Not Reqd */

				while (node->parameter[main_index] != 0)
					node->parameter[saved_index++] = node->parameter[main_index++];
	   		node->parameter[saved_index] = 0;

				/* We have done our work. lets go back */
				return CM_REMOVING_STRING_SUCCESSFUL;
			}
			else
			{
				/* The Match failed between given filter and the read filter 
					if some more filters are there then lets continue reading 
					them otherwise let us try to read filter from next line/node */

				if (node->parameter[main_index] == 0)		
					filters_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					filters_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (filters_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_entry_for_ip_address_filter(CM_IP_SECTION, node, (void*)&temp_filter);
	}
	while (node);
	printf("Failed to search node  for removing entry from filter\n");
	/* Ohhh No , after doing all these stuffs we failed to match the filter
	   lets kick the caller ...Caller Take this */
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}

enum CM_EDIT_STRING_RESULTS edit_ip_address_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
									    BYTE* bptr_lhs_string, void* vptr_old_rhs,
										 void* vptr_new_rhs)
{
	enum CM_REMOVE_STRING_RESULTS delete_result;
	STRUCT_IP_ADDRESS_FILTER* ip_filter;

	/* Validation ... */
	ip_filter = (STRUCT_IP_ADDRESS_FILTER*) vptr_new_rhs;
	if (!is_an_ip_address(ip_filter->ip_address))
	{
		printf("Not a Valid IP Address\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}
	/* ... Validation */

	delete_result = remove_ip_address_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	if ( insert_ip_address_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	return CM_STRING_EDIT_SUCCESSFUL;
}

PARAMETER_NODE* get_first_entry_for_ip_address_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, 
																				 BYTE* bptr_lhs_string, 
																				 void* vptr_rhs)
{
	STRUCT_IP_ADDRESS_FILTER* ip_filter;
	PARAMETER_NODE* node;
	BYTE i, j;
   USHORT number_of_physical_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS) + lsl_control(GET_NUMBER_OF_WAN_PORTS) ;

	ip_filter = (STRUCT_IP_ADDRESS_FILTER*)vptr_rhs;

	for(i=0;i<4;++i) /* Replace this magic 4 by constant - 4 filter types */
	{
		ip_filter->filter_type = i;
		for(j=0;j<number_of_physical_ports;++j) 
		{
			ip_filter->physical_port = j;
			node = get_first_entry_for_ip_address_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)ip_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				return node;
			}
		}
	}
	return NULL;
}

PARAMETER_NODE* get_first_entry_for_ip_address_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
						  BYTE* bptr_lhs_string, void* vptr_rhs)
{
	
	STRUCT_IP_ADDRESS_FILTER* ip_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200];
	PARAMETER_NODE* search_to_start_at;

	ip_filter = (STRUCT_IP_ADDRESS_FILTER*)vptr_rhs;

	port_number = ip_filter->physical_port;

#if 0
	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)
		return NULL;
#endif

	strcpy(lhs_string, "IP ");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}
	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
			return NULL;	
		if (port_number_matched)
			break;
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This is not required
				while (buffer[i++] != ','); */

		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		i = j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0)
			ip_filter->ip_address[j++] = temp_buffer[i++];
		ip_filter->ip_address[j] = 0;
		the_lastly_given_filter_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_next_entry_for_ip_address_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_IP_ADDRESS_FILTER* ip_filter;
	PARAMETER_NODE* node;
	BYTE i, starting_point, port_number, j, filter_type;
   USHORT number_of_physical_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS) + lsl_control(GET_NUMBER_OF_WAN_PORTS) ;

	filter_type = lastly_given_filter_type(NULL, FALSE);
	port_number = lastly_given_filter_port(NULL, FALSE);

	ip_filter = (STRUCT_IP_ADDRESS_FILTER*)vptr_rhs;
	ip_filter->physical_port = port_number;
	ip_filter->filter_type  = filter_type;
	node = get_next_entry_for_ip_address_filter(section_to_which_it_belongs_to, current_node, (void*)ip_filter);
	if (node != NULL)
	{
		return node;
	}
	starting_point = port_number+1;
	for(i=filter_type;i<4;++i) /* Replace this magic 4 by constant */
	{
		ip_filter->filter_type = i;
		for(j=starting_point;j<number_of_physical_ports;++j)
		{
			ip_filter->physical_port = j;
			node = get_first_entry_for_ip_address_filter(section_to_which_it_belongs_to, NULL, (void*)ip_filter);
			if (node != NULL)
			{
				lastly_given_filter_type(i, TRUE);
				lastly_given_filter_port(j, TRUE);
				the_lastly_given_filter_in_the_current_node(1, TRUE);
				return node;
			}
		}
		starting_point = 0;
	}
	return NULL;
}



PARAMETER_NODE* get_next_entry_for_ip_address_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_IP_ADDRESS_FILTER* ip_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200], main_index, sub_index;
	BYTE prev_count, total;
	PARAMETER_NODE* search_to_start_at;

	ip_filter = (STRUCT_IP_ADDRESS_FILTER*)vptr_rhs;
	port_number = ip_filter->physical_port;

#if 0
	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)  /* Replace this with max no ports */
		return NULL;
#endif

	strcpy(lhs_string, "IP ");

	switch(ip_filter->filter_type)
	{
		case FILTER_ON_DESTINATION:
			strcat(lhs_string, "Filter Destination Address");
			break;
		case FILTER_ON_SOURCE:
			strcat(lhs_string, "Filter Source Address");
			break;
		case FORWARD_ON_DESTINATION:
			strcat(lhs_string, "Forward Destination Address");
			break;
		case FORWARD_ON_SOURCE:
			strcat(lhs_string, "Forward Source Address");
			break;
		default:
			return NULL;
	}


	prev_count = the_lastly_given_filter_in_the_current_node(NULL, FALSE);
	total = total_numbers_ip_address_filters_in_the_current_node(current_node);
	if (prev_count < total)
	{
		/* one more entry we can read from the cuurent node itself */
		/* Skip first prev_count entries */
		for(i=0;i<=prev_count;++i)
			while(current_node->parameter[main_index++] != ','); /* There is no need to check for '\0', because we are sure that one more entry exists */

		/* Read  the next entry */
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			temp_buffer[sub_index++] = current_node->parameter[main_index++];
		temp_buffer[sub_index]  = 0; /* Terminate the String */
		i = j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0)
			ip_filter->ip_address[j++] = temp_buffer[i++];
		ip_filter->ip_address[j] = 0;

		the_lastly_given_filter_in_the_current_node(prev_count+1, TRUE);
		return current_node;
	}
	else
	{
		/* get next matching node */
		search_to_start_at = current_node;
		for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
		{
			search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
			if (search_to_start_at == NULL)
				return NULL;	
			if (port_number_matched)
				break;
		}
	}
	if (port_number_matched)	
	{
		i = 0;
		/* Skip the port number  -> This not required
			while (buffer[i++] != ','); */
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		i = j = 0;
		while(temp_buffer[i] != ' ' && temp_buffer[i] != ',' && temp_buffer[i] != 0 && temp_buffer[i] != '\n')
			ip_filter->ip_address[j++] = temp_buffer[i++];
		ip_filter->ip_address[j] = 0;

		the_lastly_given_filter_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_previous_entry_for_ip_address_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
}
/*************************************************************************
					... FUNCTION'S TO HANDLE IP Address Filter ENDS HERE
**************************************************************************/





/*************************************************************************
					FUNCTION'S TO HANDLE IP ICMP Filter Starts HERE ...
**************************************************************************/
PARAMETER_NODE* insert_ip_icmp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
						 BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_IP_ICMP_FILTER* ip_filter, temp_filter;

	BYTE lhs_string[100], rhs_string[200];

	ip_filter = (STRUCT_IP_ICMP_FILTER*)vptr_rhs;
	strcpy(lhs_string, "IP Port ICMP Packet Types");

	temp_filter = *(ip_filter);

	/* We did not get right place for insertion lets create a new node */
	if(ip_filter->echo_reply)
		strcpy(rhs_string, "enable");
	else
		strcpy(rhs_string, "disable");

	if(ip_filter->destination_unreachable)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->source_quench)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->redirect)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->echo_request)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->time_exceeded)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->parameter_problem)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->time_stamp_request)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->time_stamp_reply)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->address_mask_request)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

	if(ip_filter->address_mask_reply)
		strcat(rhs_string, ",enable");
	else
		strcat(rhs_string, ",disable");

  	return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));

#if 0
	switch (ip_filter->physical_port)
	{
		case ETHERNET_PORT:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
		case WAN_PORT_1:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
#if 0 /* Not Required for FIREWALL */
		case WAN_PORT_2:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
	
		case WAN_PORT_3:
  			return(insert_missing_string_with_port(CM_IP_SECTION, ip_filter->physical_port, lhs_string, rhs_string));
#endif
	}
#endif	
}

enum CM_REMOVE_STRING_RESULTS remove_ip_icmp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
											  	BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_IP_ICMP_FILTER* ip_filter;
	BYTE port_number, port_number_matched = FALSE, lhs_string[100], i, buffer[200];
	PARAMETER_NODE* search_to_start_at;


	ip_filter = (STRUCT_IP_ICMP_FILTER*)vptr_rhs;
	strcpy(lhs_string, "IP Port ICMP Packet Types");
	port_number = ip_filter->physical_port;

	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	for(i=0 ; i<=CM_MAXIMUM_NUMBER_OF_PORTS ; ++i)
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
		{
			printf("String not found to remove IP ICMP Filter for port %d\n", port_number);
			return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;	
		}
		if (port_number_matched)
			break;
	}
	search_to_start_at->next->previous = search_to_start_at->previous;
	search_to_start_at->previous->next = search_to_start_at->next;
	free(search_to_start_at);
	return CM_REMOVING_STRING_SUCCESSFUL;
}

enum CM_EDIT_STRING_RESULTS edit_ip_icmp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
										BYTE* bptr_lhs_string, void* vptr_old_rhs,
										void* vptr_new_rhs)
{
	
	
	enum CM_REMOVE_STRING_RESULTS delete_result;
	delete_result = remove_ip_icmp_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	if ( insert_ip_icmp_filter(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	return CM_STRING_EDIT_SUCCESSFUL; 
}


PARAMETER_NODE* get_first_entry_for_ip_icmp_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, 
						 BYTE* bptr_lhs_string, void* vptr_rhs)
{
#if 0
	STRUCT_IP_ICMP_FILTER* ip_filter;
	PARAMETER_NODE* node;
	BYTE j;

	ip_filter = (STRUCT_IP_ICMP_FILTER*)vptr_rhs;

	for(j=0;j<4;++j) /* Replace this 4 by constant - 4 ports */
	{
		ip_filter->physical_port = j;
		node = get_first_entry_for_ip_icmp_filter(section_to_which_it_belongs_to, bptr_lhs_string, (void*)ip_filter);
		if (node != NULL)
		{
			lastly_given_filter_port(j, TRUE);
			return node;
		}
	}
	return NULL;
#endif
}

PARAMETER_NODE* get_first_entry_for_ip_icmp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
						 BYTE* bptr_lhs_string, void* vptr_rhs)
{
#if 0
	STRUCT_IP_ICMP_FILTER* ip_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, j, port_number_matched, temp_buffer[200];
	PARAMETER_NODE* search_to_start_at;

	ip_filter = (STRUCT_IP_ICMP_FILTER*)vptr_rhs;

	port_number = ip_filter->physical_port;

#if 0
	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)
		return NULL;
#endif

	strcpy(lhs_string, "IP Port ICMP Packet Types");

	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
			return NULL;	
		if (port_number_matched)
			break;
	}

	if (port_number_matched)	
	{
		i = 0;
		i = get_the_value_for(i, buffer, &(ip_filter->echo_reply));
		i = get_the_value_for(i, buffer, &(ip_filter->destination_unreachable));
		i = get_the_value_for(i, buffer, &(ip_filter->source_quench));
		i = get_the_value_for(i, buffer, &(ip_filter->redirect));
		i = get_the_value_for(i, buffer, &(ip_filter->echo_request));
		i = get_the_value_for(i, buffer, &(ip_filter->time_exceeded));
		i = get_the_value_for(i, buffer, &(ip_filter->parameter_problem));
		i = get_the_value_for(i, buffer, &(ip_filter->time_stamp_request));
		i = get_the_value_for(i, buffer, &(ip_filter->time_stamp_reply));
		i = get_the_value_for(i, buffer, &(ip_filter->address_mask_request));
		i = get_the_value_for(i, buffer, &(ip_filter->address_mask_reply));

		return search_to_start_at;
	}
	return NULL;
#endif
}


BYTE get_the_value_for(BYTE starting_from, BYTE* buffer, BYTE* value)
{
	BYTE j = 0, i = starting_from, temp_buffer[10];

	while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
		temp_buffer[j++] = buffer[i++];
	temp_buffer[j] = 0;
	if (!strcmpi(temp_buffer, "enable"))
		*(value) = TRUE;
	else
		*(value) = FALSE;
	return ++i;
}

PARAMETER_NODE* get_next_entry_for_ip_icmp_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
#if 0	
	STRUCT_IP_ICMP_FILTER* ip_filter;
	PARAMETER_NODE* node;
	BYTE j, port_number;

	ip_filter = (STRUCT_IP_ICMP_FILTER*)vptr_rhs;
	port_number = lastly_given_filter_port(NULL, FALSE);
	node = get_next_entry_for_ip_icmp_filter(section_to_which_it_belongs_to, current_node, vptr_rhs);
	if (node != NULL)
	{
		return node;
	}
	for(j=port_number+1;j<4;++j) /* Replace this 4 by constant - 4 ports */
	{
		ip_filter->physical_port = j;
		node = get_first_entry_for_ip_icmp_filter(section_to_which_it_belongs_to, NULL, (void*)ip_filter);
		if (node != NULL)
		{
			lastly_given_filter_port(j, TRUE);
			return node;
		}
	}
	return NULL;
#endif
}


PARAMETER_NODE* get_next_entry_for_ip_icmp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
     
	STRUCT_IP_ICMP_FILTER* ip_filter, temp_ip_filter;
	BYTE lhs_string[100], port_number, buffer[200], i, port_number_matched;
	BYTE prev_count;
	PARAMETER_NODE* search_to_start_at;

	ip_filter = (STRUCT_IP_ICMP_FILTER*)vptr_rhs;
	port_number = ip_filter->physical_port;

#if 0
	/* If invalid port number get lost */
	if (port_number > WAN_PORT_3)  /* Replace this with max no ports */
		return NULL;
#endif

	strcpy(lhs_string, "IP Port ICMP Packet Types");
	prev_count = the_lastly_given_filter_in_the_current_node(NULL, FALSE);
	/* get next matching node */
	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	for(i=1;i <= CM_MAXIMUM_NUMBER_OF_PORTS;++i)
	{
		search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(lhs_string, search_to_start_at, sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to+1], buffer, port_number, &port_number_matched);
		if (search_to_start_at == NULL)
		{
			/* set all the values in the structure to zero i.e. all the icmp options 
	   		 are disabled */
			memset(&temp_ip_filter, 0, sizeof(temp_ip_filter));
			temp_ip_filter.physical_port = port_number;
			search_to_start_at = insert_ip_icmp_filter(section_to_which_it_belongs_to, NULL, (void*)&temp_ip_filter);
			if(search_to_start_at)
				*(ip_filter) = temp_ip_filter;
			return search_to_start_at;
		}
		if (port_number_matched)
			break;
	}
	if (port_number_matched)	
	{
		i = 0;
		i = get_the_value_for(i, buffer, &(ip_filter->echo_reply));
		i = get_the_value_for(i, buffer, &(ip_filter->destination_unreachable));
		i = get_the_value_for(i, buffer, &(ip_filter->source_quench));
		i = get_the_value_for(i, buffer, &(ip_filter->redirect));
		i = get_the_value_for(i, buffer, &(ip_filter->echo_request));
		i = get_the_value_for(i, buffer, &(ip_filter->time_exceeded));
		i = get_the_value_for(i, buffer, &(ip_filter->parameter_problem));
		i = get_the_value_for(i, buffer, &(ip_filter->time_stamp_request));
		i = get_the_value_for(i, buffer, &(ip_filter->time_stamp_reply));
		i = get_the_value_for(i, buffer, &(ip_filter->address_mask_request));
		i = get_the_value_for(i, buffer, &(ip_filter->address_mask_reply));

		return search_to_start_at;
	}
	return NULL;
      
}

PARAMETER_NODE* get_previous_entry_for_ip_icmp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
}
/*************************************************************************
					... FUNCTION'S TO HANDLE IP ICMP Filter ENDS HERE
**************************************************************************/


void	get_lhs_string_from_node(PARAMETER_NODE* node, BYTE* lhs_string)
{
	BYTE index = 0;

	if (lhs_string == NULL)	
		return;
	if (node == NULL)
		return;
	index = 0;
	while(node->parameter[index] != '=')
	{
		lhs_string[index] = node->parameter[index];
		index++;
	}
	lhs_string[index-1] = 0;
	return;
}

BYTE lastly_given_filter_type(BYTE new_value, BYTE is_to_save)
{
	static BYTE filter_type;

	if (is_to_save)
		filter_type = new_value;
	else	
		return filter_type;
}

BYTE lastly_given_filter_port(BYTE new_value, BYTE is_to_save)
{
	static BYTE filter_port;

	if (is_to_save)
		filter_port = new_value;
	else	
		return filter_port;
}


void update_the_number_of_filters_present()
{
	PARAMETER_NODE* search_to_start_at, *new_node, *current_section_first_node, *current_section_seconde_node;
	BYTE port_number, port_number_matched, buffer[200];
	USHORT number_of_filters_present;

	/* IP */
	port_number = CM_NO_PORT_PARAMETER_PRESENT;
	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_IP_SECTION];
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string("IP Number of Filtering Database Entries", search_to_start_at, sptr_to_each_section_in_the_configuration[CM_IP_SECTION+1], buffer, port_number, &port_number_matched);
	number_of_filters_present = get_the_total_number_of_ip_port_filters() + get_the_total_number_of_ip_address_filters() + get_the_total_number_of_ip_icmp_filter();
	sprintf(buffer, "%d\0", number_of_filters_present);
	if (search_to_start_at)
	{
		strcpy(search_to_start_at->parameter, "IP Number of Filtering Database Entries = ");
		strcat(search_to_start_at->parameter, buffer);
		strcat(search_to_start_at->parameter, "\n");
	}
	else
	{
	   new_node = (PARAMETER_NODE*)malloc(sizeof (ULONG) * 2 + 200);
		if (new_node == NULL)
			return;

		strcpy(new_node->parameter, "IP Number of Filtering Database Entries = ");
		strcat(new_node->parameter, buffer);
		strcat(new_node->parameter, "\n");

		current_section_first_node = sptr_to_each_section_in_the_configuration[CM_IP_SECTION];
		current_section_seconde_node = current_section_first_node->next;

		new_node->next = current_section_seconde_node;
		new_node->previous = current_section_first_node;

		current_section_first_node->next = new_node;
		current_section_seconde_node->previous = new_node;
	}
#if 0  /* Not Required for Proxy Server */
	/* IPX */
	port_number = CM_NO_PORT_PARAMETER_PRESENT;
	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_IPX_SECTION];
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string("IPX Number of Filtering Database Entries", search_to_start_at, sptr_to_each_section_in_the_configuration[CM_IPX_SECTION+1], buffer, port_number, &port_number_matched);
	number_of_filters_present = get_the_total_number_of_ipx_filters(); 
	sprintf(buffer, "%d\0", number_of_filters_present);
	if (search_to_start_at)
	{
		strcpy(search_to_start_at->parameter, "IPX Number of Filtering Database Entries = ");
		strcat(search_to_start_at->parameter, buffer);
		strcat(search_to_start_at->parameter, "\n");
	}
	else
	{
	   new_node = (PARAMETER_NODE*)malloc(sizeof (ULONG) * 2 + 200);
		if (new_node == NULL)
			return;

		strcpy(new_node->parameter, "IPX Number of Filtering Database Entries = ");
		strcat(new_node->parameter, buffer);
		strcat(new_node->parameter, "\n");

		current_section_first_node = sptr_to_each_section_in_the_configuration[CM_IPX_SECTION];;
		current_section_seconde_node = current_section_first_node->next;

		new_node->next = current_section_seconde_node;
		new_node->previous = current_section_first_node;

		current_section_first_node->next = new_node;
		current_section_seconde_node->previous = new_node;
	}
#endif

#if 0
	/* STP */
	port_number = CM_NO_PORT_PARAMETER_PRESENT;
	search_to_start_at = sptr_to_each_section_in_the_configuration[CM_SPANTREE_SECTION];
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string("Spanning Tree Number of Filtering Database Entries", search_to_start_at, sptr_to_each_section_in_the_configuration[CM_SPANTREE_SECTION+1], buffer, port_number, &port_number_matched);
	number_of_filters_present = get_the_total_number_of_stp_filters(); 
	sprintf(buffer, "%d\0", number_of_filters_present);
	if (search_to_start_at)
	{
		strcpy(search_to_start_at->parameter, "Spanning Tree Number of Filtering Database Entries = ");
		strcat(search_to_start_at->parameter, buffer);
		strcat(search_to_start_at->parameter, "\n");
	}
	else
	{
	   new_node = (PARAMETER_NODE*)malloc(sizeof (ULONG) * 2 + 200);
		if (new_node == NULL)
			return;

		strcpy(new_node->parameter, "Spanning Tree Number of Filtering Database Entries = ");
		strcat(new_node->parameter, buffer);
		strcat(new_node->parameter, "\n");

		current_section_first_node = sptr_to_each_section_in_the_configuration[CM_SPANTREE_SECTION];
		current_section_seconde_node = current_section_first_node->next;

		new_node->next = current_section_seconde_node;
		new_node->previous = current_section_first_node;

		current_section_first_node->next = new_node;
		current_section_seconde_node->previous = new_node;
	}
#endif
}

#if 0  /* Not Required for Proxy Server */
USHORT get_the_total_number_of_ipx_filters()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	BYTE rhs_string[200];
	STRUCT_IPX_FILTER temp_ipx_struct;

	node = cm_get_first_entry(CM_IPX_SECTION, "IPX Filter", (void*)&temp_ipx_struct);
	while (node)
	{
		node = cm_get_next_entry(CM_IPX_SECTION, node, (void*)&temp_ipx_struct);
		count ++;	
	}
	return count;
}
#endif /* Not Required for Proxy Server */

USHORT get_the_total_number_of_ip_port_filters()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	STRUCT_IP_PORT_FILTER temp_ip_port_struct;

	node = cm_get_first_entry(CM_IP_SECTION, "IP Port Filter", (void*)&temp_ip_port_struct);
	while (node)
	{
		node = cm_get_next_entry(CM_IP_SECTION, node, (void*)&temp_ip_port_struct);
		count ++;	
	}
	return count;
}


USHORT get_the_total_number_of_ip_address_filters()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	STRUCT_IP_ADDRESS_FILTER temp_ip_address_struct;

	node = cm_get_first_entry(CM_IP_SECTION, "IP Address Filter", (void*)&temp_ip_address_struct);
	while (node)
	{
		node = cm_get_next_entry(CM_IP_SECTION, node, (void*)&temp_ip_address_struct);
		count ++;	
	}
	return count;
}

#if 0 /* This code not required */
USHORT get_the_total_number_of_stp_filters()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	BYTE rhs_string[200];
	STRUCT_STP_FILTER temp_stp_struct;

	node = cm_get_first_entry(CM_SPANTREE_SECTION, "STP Filter", (void*)&temp_stp_struct);
	while (node)
	{
		node = cm_get_next_entry(CM_SPANTREE_SECTION, node, (void*)&temp_stp_struct);
		count ++;	
	}
   if (count)
   	return count;
   else
      return 256;
}
#endif

USHORT get_the_total_number_of_ip_icmp_filter()
{
	STRUCT_IP_ICMP_FILTER ip_filter;
	BYTE i;
	PARAMETER_NODE* node;

	for(i=0;i<1;++i) /* ### Take Care Pending */
	{
		ip_filter.physical_port = i;
	   node = cm_get_first_entry(CM_IP_SECTION, "IP ICMP Filter", (void*)&ip_filter);
	}
  return 1; /* ### Take Care Pending */
}	
BYTE the_lastly_given_filter_in_the_current_node(BYTE new_value, BYTE is_to_save)
{
	static BYTE value;
	if (is_to_save)
		value = new_value;
	else
		return value;
}


#if 1
/*-------------------------- Proxy Server ... ----------------------------- */
BYTE the_lastly_given_proxy_entry_in_the_current_node(BYTE new_value, BYTE is_to_save)
{
	static BYTE value;
	if (is_to_save)
		value = new_value;
	else
		return value;
}

BYTE total_number_of_proxy_entries_in_the_current_node(PARAMETER_NODE* node)
{
	/* Here i am searching for number of ','s -> this count will give me
	   the number of entries in the node */
	BYTE number_of_entries = 0, i;

	for(i=0;i<=strlen(node->parameter);++i)
		if (node->parameter[i] == ',')
			number_of_entries++;
	return ((number_of_entries+1)/2);
}	

PARAMETER_NODE* insert_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs)
{
	STRUCT_PROXY_ENTRY* proxy_entry, temp_entry;
	BYTE rhs_string[200];
	PARAMETER_NODE* node;
   static BYTE re_entry = 0;
   
	proxy_entry = (STRUCT_PROXY_ENTRY*)vptr_rhs;

	/* Validation ... */
	/* ... Validation */

	/* For FTP(20,21), SSL-FTP(989,990), Q931(900,902), RTP(5004,5006),
		RTCP(5005,5007) ports */

	if ((is_re_entry_needed_for_application_port(proxy_entry->port) == TRUE) 
		&&	(re_entry == 0))
   {
      re_entry = 1;
      proxy_entry->port = get_next_application_port_which_needs_re_entry(proxy_entry->port);
      insert_proxy_entry(section_to_which_it_belongs_to, bptr_lhs_string, vptr_rhs);
      proxy_entry->port = get_next_application_port_which_needs_re_entry(proxy_entry->port);
      re_entry = 0;
   }

   if (search_for_a_entry(proxy_entry, bptr_lhs_string) == TRUE)
   {
      printf("Can't Add Duplicate Proxy Entry .......\n");
      return NULL;
   }


	/* Check whether a node already present so that we can append the
		new entry to it  Note: iff number of entries present is less then
		3 (Magic Number!!!) 
	*/
	temp_entry = *(proxy_entry);
	node = get_first_proxy_entry(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_entry);

	while (node)
	{
		if (total_number_of_proxy_entries_in_the_current_node(node) < 5) /* 5 = Max number of entries in a Node */
		{
			/* Already a node is there just go and append there */

			/* Remove '\n' to append new entry */
			node->parameter[strlen(node->parameter)-1] = 0; 			
			sprintf(rhs_string, "%04X,%04X\0", !proxy_entry->protocol?0006:0x0011, proxy_entry->port);

			strcat(node->parameter, ",");
			strcat(node->parameter, rhs_string);
			strcat(node->parameter, "\n");
         if (node != NULL)
      		update_count_in_ini (num_proxy_reserved_entries_in_ini, CM_INCREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
			return node;
		}
		node = get_next_proxy_entry(section_to_which_it_belongs_to, node, (void*)&temp_entry);
	}

	/* We did not get right place for insertion lets create a new node */
	sprintf(rhs_string, "%04X,%04X\0", !proxy_entry->protocol?0006:0x0011, proxy_entry->port);
   node = insert_missing_string_without_port(CM_PROXY_SECTION, proxy_entry_string_in_ini_file,  rhs_string);
	if (node != NULL)
		update_count_in_ini (num_proxy_reserved_entries_in_ini, CM_INCREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
	return (node);

#if 0
   /* Special handling for FTP ...........  20 and 21 are FTP ports */
   if (proxy_entry->port != 20 && proxy_entry->port != 21)
      return(insert_missing_string_without_port(CM_PROXY_SECTION, proxy_entry_string_in_ini_file,  rhs_string));
   else
   {
      if (proxy_entry->port == 20)
      {
         insert_missing_string_without_port(CM_PROXY_SECTION, proxy_entry_string_in_ini_file,  rhs_string);
      	sprintf(rhs_string, "%04X,%04X\0", !proxy_entry->protocol?0006:0x0011, 21);
         retrurn(insert_missing_string_without_port(CM_PROXY_SECTION, proxy_entry_string_in_ini_file,  rhs_string));
      }
      else
      if (proxy_entry->port == 21)
      {
         insert_missing_string_without_port(CM_PROXY_SECTION, proxy_entry_string_in_ini_file,  rhs_string);
      	sprintf(rhs_string, "%04X,%04X\0", !proxy_entry->protocol?0006:0x0011, 20);
         return(insert_missing_string_without_port(CM_PROXY_SECTION, proxy_entry_string_in_ini_file,  rhs_string));
      }
   }
#endif
}


enum CM_REMOVE_STRING_RESULTS remove_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_PROXY_ENTRY* proxy_entry, temp_entry;
	BYTE saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node;
	BYTE entries_available_in_the_same_buffer = FALSE;
   static BYTE re_entry = 0;

	proxy_entry = (STRUCT_PROXY_ENTRY*)vptr_rhs;

	/* For FTP(20,21), SSL-FTP(989,990), Q931(900,902), RTP(5004,5006),
		RTCP(5005,5007) ports */

   if ((is_re_entry_needed_for_application_port(proxy_entry->port) == TRUE) 
		&& (re_entry == 0))
   {
      re_entry = 1;
      proxy_entry->port = get_next_application_port_which_needs_re_entry(proxy_entry->port);
      remove_proxy_entry(section_to_which_it_belongs_to, bptr_lhs_string, vptr_rhs);
      proxy_entry->port = get_next_application_port_which_needs_re_entry(proxy_entry->port);
      re_entry = 0;
   }

	/* Prepare a string using given data, i.e data  from the entry
	  to  delete */
   sprintf(temp_buffer2, "%04X,%04X", !proxy_entry->protocol?6:0x11, proxy_entry->port);

	temp_entry= *(proxy_entry);
	if ((node = get_first_proxy_entry(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_entry)) == NULL)
	{
		printf("Get First Entry Failed to get the required string to remove\n");
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' */
		while (node->parameter[main_index++] != '=');

      /* Skip Space */
      main_index++;

		do
		{
			sub_index = 0;
			saved_index = main_index;

			/* Read a Protocol into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 2 ',' (i.e. protocol,port) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Port ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index] = 0;

			/* Are the Proxy Entries Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
				/* Now We have to Blank Out from saved_index to  main_index */
				if ((node->parameter[main_index] == 0 || node->parameter[main_index] == '\n') && total_number_of_proxy_entries_in_the_current_node(node) == 1)
				{
					/* Now No More Entries are there in this line let us free this node */
					node->previous->next = node->next;
					node->next->previous = node->previous;
					free(node); 
					update_count_in_ini (num_proxy_reserved_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);

					return CM_REMOVING_STRING_SUCCESSFUL;
				}

				/* Some More Entries are there in this line let us remove given entry */

            /* Now main_index will be pointing to ',' but it should be  skipped
               hence increment the main_index */
            if (node->parameter[main_index] == ',')
               main_index++;
            else
            {
               /* Last entry in the node ! */
               node->parameter[saved_index-1] = '\n';
               node->parameter[saved_index] = 0;
					update_count_in_ini (num_proxy_reserved_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
					return CM_REMOVING_STRING_SUCCESSFUL;
            }

				while (node->parameter[main_index] != 0)
					node->parameter[saved_index++] = node->parameter[main_index++];
	   		node->parameter[saved_index] = 0;

				/* We have done our work. lets go back */
				update_count_in_ini (num_proxy_reserved_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
				return CM_REMOVING_STRING_SUCCESSFUL;
			}
			else
			{
				/* The Match failed between given entry and the read entry
					if some more entries are there then lets continue reading 
					them otherwise let us try to read entry from next line/node */

				if (node->parameter[main_index] == 0)		
					entries_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					entries_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (entries_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_proxy_entry(CM_PROXY_SECTION, node, (void*)&temp_entry);
	}
	while (node);
	printf("Failed to search node  for removing entry \n");
	/* Ohhh No , after doing all these stuffs we failed to match the entry
	*/
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}


enum CM_EDIT_STRING_RESULTS edit_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs)
{
	
	enum CM_REMOVE_STRING_RESULTS delete_result;
	STRUCT_PROXY_ENTRY* proxy_entry;

	/* Validation ... */
	/* ... Validation  */

	proxy_entry = (STRUCT_PROXY_ENTRY*)vptr_new_rhs;

   if (search_for_a_entry(proxy_entry, bptr_lhs_string) == TRUE)
   {
      printf("This modifed Proxy entry is a duplicate entry .......\n");
      return NULL;
   }

	delete_result = remove_proxy_entry(section_to_which_it_belongs_to, bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	if ( insert_proxy_entry(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	return CM_STRING_EDIT_SUCCESSFUL; 
}



PARAMETER_NODE* get_first_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
												  BYTE* bptr_lhs_string, 
												  void* vptr_rhs)
{
	STRUCT_PROXY_ENTRY* proxy_entry;
	BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, buffer[200], i, j, port_number_matched, temp_buffer[200];
	PARAMETER_NODE* search_to_start_at;
   ULONG temp_value;

	proxy_entry = (STRUCT_PROXY_ENTRY*)vptr_rhs;

	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(proxy_entry_string_in_ini_file, search_to_start_at, NULL, buffer, port_number, &port_number_matched);
	if (search_to_start_at == NULL)
   	return NULL;	
	if (TRUE)	
	{
		i = 0;
		j = 0;
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		if (!strcmpi(temp_buffer, "0006"))
		{
			proxy_entry->protocol = 0x0006;
		}
		else
		{
			proxy_entry->protocol = 0x0011;
		}

		j = 0;
		i++; /* Skip ',' */
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->port = (USHORT)temp_value;

		the_lastly_given_proxy_entry_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_next_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_PROXY_ENTRY* proxy_entry;
	BYTE port_number, buffer[200], i, j, port_number_matched, temp_buffer[200], main_index, sub_index, protocol[10];
	BYTE prev_count, total;
	PARAMETER_NODE* search_to_start_at;
   ULONG temp_value;

	proxy_entry = (STRUCT_PROXY_ENTRY*)vptr_rhs;

	prev_count = the_lastly_given_proxy_entry_in_the_current_node(NULL, FALSE);
	total = total_number_of_proxy_entries_in_the_current_node(current_node);
	if (prev_count < total)
	{
		/* one more entry we can read from the current node itself */
		/* Skip first prev_count entries */

		main_index = 0;
		for(i=0;i<2*prev_count;++i)
			while(current_node->parameter[main_index++] != ','); /* There is no need to check for '\0', because we are sure that one more entry exists */

		/* Read  the next entry */
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			protocol[sub_index++] = current_node->parameter[main_index++];
		protocol[sub_index]  = 0; /* Terminate the String */

		if (!strcmpi(protocol, "0006"))
		{
			proxy_entry->protocol = 0x0006;
		}
		else
		{
			proxy_entry->protocol = 0x0011;
		}


		main_index++;
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			temp_buffer[sub_index++] = current_node->parameter[main_index++];
		temp_buffer[sub_index]  = 0; /* Terminate the String */

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->port = (USHORT)temp_value;

		the_lastly_given_proxy_entry_in_the_current_node(prev_count+1, TRUE);
		return current_node;
	}
	/* get next matching node */
   search_to_start_at = current_node;
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(proxy_entry_string_in_ini_file, search_to_start_at, NULL, buffer, CM_NO_PORT_PARAMETER_PRESENT, &port_number_matched);
	if (search_to_start_at == NULL)
		return NULL;	

	if (TRUE)	
	{
		i = 0;
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			protocol[j++] = buffer[i++];
		protocol[j] = 0;

		if (!strcmpi(protocol, "0006"))
		{
			proxy_entry->protocol = 0x0006;
		}
		else
		{
			proxy_entry->protocol = 0x00011;
		}

		i++; /* Skip ',' */
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->port = (USHORT)temp_value;
		the_lastly_given_proxy_entry_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_previous_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
}

BYTE search_for_a_entry(STRUCT_PROXY_ENTRY* proxy_entry, BYTE* bptr_lhs_string)
{
	STRUCT_PROXY_ENTRY temp_entry;
	BYTE saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node;
	BYTE entries_available_in_the_same_buffer = FALSE;

   sprintf(temp_buffer2, "%04X,%04X", !proxy_entry->protocol?0006:0x0011, proxy_entry->port);
	if ((node = get_first_proxy_entry(CM_PROXY_SECTION, bptr_lhs_string, (void*)&temp_entry)) == NULL)
	{
		return FALSE;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' */
		while (node->parameter[main_index++] != '=');

      /* Skip Space */
      main_index++;

		do
		{
			sub_index = 0;
			saved_index = main_index;

			/* Read a Protocol into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 2 ',' (i.e. protocol,port) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Port ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index] = 0;

			/* Are the Proxy Entries Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
            return TRUE;
			}
			else
			{
				/* The Match failed between given entry and the read entry
					if some more entries are there then lets continue reading 
					them otherwise let us try to read entry from next line/node */

				if (node->parameter[main_index] == 0)		
					entries_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					entries_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (entries_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_proxy_entry(CM_PROXY_SECTION, node, (void*)&temp_entry);
	}
	while (node);
   return FALSE;
}
/*-------------------------- ... Proxy Server ----------------------------- */

/*----------------- ... Proxy Server User Defined Entries ----------------- */

BYTE the_lastly_given_proxy_user_entry_in_the_current_node(BYTE new_value, BYTE is_to_save)
{
	static BYTE value;
	if (is_to_save)
		value = new_value;
	else
		return value;
}

BYTE total_number_of_proxy_user_entries_in_the_current_node(PARAMETER_NODE* node)
{
	/* Here i am searching for number of ','s -> this count will give me
	   the number of entries in the node */
	BYTE number_of_entries = 0, i;

	for(i=0;i<=strlen(node->parameter);++i)
		if (node->parameter[i] == ',')
			number_of_entries++;
	return ((number_of_entries+1)/4);
}	

PARAMETER_NODE* insert_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs)
{
	STRUCT_PROXY_USER_ENTRY* proxy_entry, temp_entry;
	BYTE rhs_string[200];
	PARAMETER_NODE* node;
   
	proxy_entry = (STRUCT_PROXY_USER_ENTRY*)vptr_rhs;

	/* Validation ... */
	if ( (proxy_entry->lower_port == 0) || 
		( strcmp(proxy_entry->descrptn,"") == 0))
	{
      printf("Entry values are not proper .......\n");
      return NULL;
	}
	if ( is_user_defined_port_range_unique(proxy_entry->lower_port, proxy_entry->higher_port,proxy_entry->protocol) != UNIQUE_ENTRY)
	{
      printf("Range entries conflicting with existing range entries .......\n");
      return NULL;
	}
	/* ... Validation */

   if (search_for_a_user_entry(proxy_entry, bptr_lhs_string) == TRUE)
   {
      printf("Can't Add Duplicate Proxy User Entry .......\n");
      return NULL;
   }


	/* Check whether a node already present so that we can append the
		new entry to it  Note: iff number of entries present is less then
		2 (Magic Number!!!) 
	*/
	temp_entry = *(proxy_entry);
	node = get_first_proxy_user_entry(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_entry);

	while (node)
	{
		if (total_number_of_proxy_user_entries_in_the_current_node(node) < 2) /* 2 = Max number of entries in a Node */
		{
			/* Already a node is there just go and append there */

			/* Remove '\n' to append new entry */
			node->parameter[strlen(node->parameter)-1] = 0; 			
			sprintf(rhs_string, "%04X,%04X,%04X,%s\0", !proxy_entry->protocol?0006:0x0011, 
				proxy_entry->lower_port,proxy_entry->higher_port,proxy_entry->descrptn);

			strcat(node->parameter, ",");
			strcat(node->parameter, rhs_string);
			strcat(node->parameter, "\n");
         if (node != NULL)
			{
      		update_count_in_ini (num_proxy_user_entries_in_ini, CM_INCREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
      		update_count_in_ini (num_proxy_reserved_entries_in_ini, CM_INCREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
			}
			return node;
		}
		node = get_next_proxy_user_entry(section_to_which_it_belongs_to, node, (void*)&temp_entry);
	}

	/* We did not get right place for insertion lets create a new node */
	sprintf(rhs_string, "%04X,%04X,%04X,%s\0", !proxy_entry->protocol?0006:0x0011, 
		proxy_entry->lower_port, proxy_entry->higher_port, proxy_entry->descrptn);
   node = insert_missing_string_without_port(CM_PROXY_SECTION, proxy_user_entry_string_in_ini_file,  rhs_string);
	if (node != NULL)
	{
		update_count_in_ini (num_proxy_user_entries_in_ini, CM_INCREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
		update_count_in_ini (num_proxy_reserved_entries_in_ini, CM_INCREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);

	}
	return (node);

}


enum CM_REMOVE_STRING_RESULTS remove_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs)
{
	STRUCT_PROXY_USER_ENTRY* proxy_entry, temp_entry;
	BYTE saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node;
	BYTE entries_available_in_the_same_buffer = FALSE;

	proxy_entry = (STRUCT_PROXY_USER_ENTRY*)vptr_rhs;

	/* Prepare a string using given data, i.e data  from the entry
	  to  delete */
   sprintf(temp_buffer2, "%04X,%04X,%04X,%s", !proxy_entry->protocol?6:0x11, 
		proxy_entry->lower_port, proxy_entry->higher_port, proxy_entry->descrptn);

	temp_entry= *(proxy_entry);
	if ((node = get_first_proxy_user_entry(section_to_which_it_belongs_to, bptr_lhs_string, (void*)&temp_entry)) == NULL)
	{
		printf("Get First User Entry Failed to get the required string to remove\n");
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' */
		while (node->parameter[main_index++] != '=');

      /* Skip Space */
      main_index++;

		do
		{
			sub_index = 0;
			saved_index = main_index;

			/* Read a Protocol into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 4 ',' (i.e. protocol,lower_port, higher_port, descrptn) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Lower Port ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 4 ',' (i.e. protocol,lower_port, higher_port, descrptn) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Higher Port ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 4 ',' (i.e. protocol,lower_port, higher_port, descrptn) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Descrption ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index] = 0;

			/* Are the Proxy Entries Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
				/* Now We have to Blank Out from saved_index to  main_index */
				if ((node->parameter[main_index] == 0 || node->parameter[main_index] == '\n') && total_number_of_proxy_user_entries_in_the_current_node(node) == 1)
				{
					/* Now No More Entries are there in this line let us free this node */
					node->previous->next = node->next;
					node->next->previous = node->previous;
					free(node); 
					update_count_in_ini (num_proxy_user_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
					update_count_in_ini (num_proxy_reserved_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
					return CM_REMOVING_STRING_SUCCESSFUL;
				}

				/* Some More Entries are there in this line let us remove given entry */

            /* Now main_index will be pointing to ',' but it should be  skipped
               hence increment the main_index */
            if (node->parameter[main_index] == ',')
               main_index++;
            else
            {
               /* Last entry in the node ! */
               node->parameter[saved_index-1] = '\n';
               node->parameter[saved_index] = 0;
					update_count_in_ini (num_proxy_user_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
					update_count_in_ini (num_proxy_reserved_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
					return CM_REMOVING_STRING_SUCCESSFUL;
            }

				while (node->parameter[main_index] != 0)
					node->parameter[saved_index++] = node->parameter[main_index++];
	   		node->parameter[saved_index] = 0;

				/* We have done our work. lets go back */
				update_count_in_ini (num_proxy_user_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
				update_count_in_ini (num_proxy_reserved_entries_in_ini,
											CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
				return CM_REMOVING_STRING_SUCCESSFUL;
			}
			else
			{
				/* The Match failed between given entry and the read entry
					if some more entries are there then lets continue reading 
					them otherwise let us try to read entry from next line/node */

				if (node->parameter[main_index] == 0)		
					entries_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					entries_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (entries_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_proxy_user_entry(CM_PROXY_SECTION, node, (void*)&temp_entry);
	}
	while (node);
	printf("Failed to search node  for removing entry \n");
	/* Ohhh No , after doing all these stuffs we failed to match the entry
	*/
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}


enum CM_EDIT_STRING_RESULTS edit_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs)
{
	
	enum CM_REMOVE_STRING_RESULTS delete_result;
	STRUCT_PROXY_USER_ENTRY* proxy_entry;
	STRUCT_PROXY_USER_ENTRY* old_proxy_entry;

	/* Validation ... */
	/* ... Validation  */

	proxy_entry = (STRUCT_PROXY_USER_ENTRY*)vptr_new_rhs;
	if ( (proxy_entry->lower_port == 0) || 
		( strcmp(proxy_entry->descrptn,"") == 0))
	{
      printf("Entry values are not proper .......\n");
      return NULL;
	}

	old_proxy_entry = (STRUCT_PROXY_USER_ENTRY*)vptr_old_rhs;

	/* Check if the specified old user entry exists */
	if (search_for_a_user_entry (old_proxy_entry,bptr_lhs_string) == FALSE)
	{
		printf("The given user defined entry does not exist.......\n");
		return NULL;
	}

	/* Check if the specified new user entry already exists */
   if (search_for_a_user_entry(proxy_entry, bptr_lhs_string) == TRUE)
   {
      printf("This modified Proxy user entry is a duplicate entry .......\n");
      return NULL;
   }

	delete_result = remove_proxy_user_entry(section_to_which_it_belongs_to, bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	if ( insert_proxy_user_entry(section_to_which_it_belongs_to, bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;
	return CM_STRING_EDIT_SUCCESSFUL; 
}



PARAMETER_NODE* get_first_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
												  BYTE* bptr_lhs_string, 
												  void* vptr_rhs)
{
	STRUCT_PROXY_USER_ENTRY* proxy_entry;
	BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, buffer[200], i, j, port_number_matched, temp_buffer[200];
	PARAMETER_NODE* search_to_start_at;
   ULONG temp_value;

	proxy_entry = (STRUCT_PROXY_USER_ENTRY*)vptr_rhs;

	search_to_start_at = sptr_to_each_section_in_the_configuration[section_to_which_it_belongs_to];
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(proxy_user_entry_string_in_ini_file, search_to_start_at, NULL, buffer, port_number, &port_number_matched);
	if (search_to_start_at == NULL)
   	return NULL;	
	if (TRUE)	
	{
		i = 0;
		j = 0;
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		if (!strcmpi(temp_buffer, "0006"))
		{
			proxy_entry->protocol = 0x0006;
		}
		else
		{
			proxy_entry->protocol = 0x0011;
		}

		j = 0;
		i++; /* Skip ',' */
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->lower_port = (USHORT)temp_value;

		j = 0;
		i++; /* Skip ',' */
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->higher_port = (USHORT)temp_value;

		j = 0;
		i++; /* Skip ',' */
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		strcpy(proxy_entry->descrptn,temp_buffer);

		the_lastly_given_proxy_user_entry_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_next_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
	STRUCT_PROXY_USER_ENTRY* proxy_entry;
	BYTE port_number, buffer[200], i, j, port_number_matched, temp_buffer[200], main_index, sub_index, protocol[10];
	BYTE prev_count, total;
	PARAMETER_NODE* search_to_start_at;
   ULONG temp_value;

	proxy_entry = (STRUCT_PROXY_USER_ENTRY*)vptr_rhs;

	prev_count = the_lastly_given_proxy_user_entry_in_the_current_node(NULL, FALSE);
	total = total_number_of_proxy_user_entries_in_the_current_node(current_node);
	if (prev_count < total)
	{
		/* one more entry we can read from the current node itself */
		/* Skip first prev_count entries */

		main_index = 0;
		for(i=0;i<4*prev_count;++i)
			while(current_node->parameter[main_index++] != ','); /* There is no need to check for '\0', because we are sure that one more entry exists */

		/* Read  the next entry */
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			protocol[sub_index++] = current_node->parameter[main_index++];
		protocol[sub_index]  = 0; /* Terminate the String */

		if (!strcmpi(protocol, "0006"))
		{
			proxy_entry->protocol = 0x0006;
		}
		else
		{
			proxy_entry->protocol = 0x0011;
		}


		main_index++;
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			temp_buffer[sub_index++] = current_node->parameter[main_index++];
		temp_buffer[sub_index]  = 0; /* Terminate the String */

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->lower_port = (USHORT)temp_value;


		main_index++;
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			temp_buffer[sub_index++] = current_node->parameter[main_index++];
		temp_buffer[sub_index]  = 0; /* Terminate the String */

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->higher_port = (USHORT)temp_value;


		main_index++;
		sub_index = 0;
		while(current_node->parameter[main_index] != ',' && current_node->parameter[main_index] != 0 && current_node->parameter[main_index] != '\n')
			temp_buffer[sub_index++] = current_node->parameter[main_index++];
		temp_buffer[sub_index]  = 0; /* Terminate the String */

		strcpy(proxy_entry->descrptn, temp_buffer);

		the_lastly_given_proxy_user_entry_in_the_current_node(prev_count+1, TRUE);
		return current_node;
	}
	/* get next matching node */
   search_to_start_at = current_node;
	search_to_start_at = match_the_lhs_string_in_the_linked_list_and_return_rhs_string(proxy_user_entry_string_in_ini_file, search_to_start_at, NULL, buffer, CM_NO_PORT_PARAMETER_PRESENT, &port_number_matched);
	if (search_to_start_at == NULL)
		return NULL;	

	if (TRUE)	
	{
		i = 0;
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			protocol[j++] = buffer[i++];
		protocol[j] = 0;

		if (!strcmpi(protocol, "0006"))
		{
			proxy_entry->protocol = 0x0006;
		}
		else
		{
			proxy_entry->protocol = 0x00011;
		}

		i++; /* Skip ',' */
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->lower_port = (USHORT)temp_value;

		i++; /* Skip ',' */
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

      sscanf(temp_buffer, "%x", &temp_value);
      proxy_entry->higher_port = (USHORT)temp_value;

		i++; /* Skip ',' */
		j = 0;
		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = 0;

		strcpy(proxy_entry->descrptn, temp_buffer);

		the_lastly_given_proxy_user_entry_in_the_current_node(1, TRUE);
		return search_to_start_at;
	}
	return NULL;
}

PARAMETER_NODE* get_previous_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs)
{
}

BYTE search_for_a_user_entry(STRUCT_PROXY_USER_ENTRY* proxy_entry, BYTE* bptr_lhs_string)
{
	STRUCT_PROXY_USER_ENTRY temp_entry;
	BYTE saved_index, main_index, sub_index, temp_buffer1[200], temp_buffer2[200];
	PARAMETER_NODE* node;
	BYTE entries_available_in_the_same_buffer = FALSE;

   sprintf(temp_buffer2, "%04X,%04X,%04X,%s", !proxy_entry->protocol?0006:0x0011, 
		proxy_entry->lower_port, proxy_entry->higher_port, proxy_entry->descrptn);
	if ((node = get_first_proxy_user_entry(CM_PROXY_SECTION, bptr_lhs_string, (void*)&temp_entry)) == NULL)
	{
		return FALSE;
	}
	do
	{
		main_index = 0;

		/* Lets skip  LHS string , '=' */
		while (node->parameter[main_index++] != '=');

      /* Skip Space */
      main_index++;

		do
		{
			sub_index = 0;
			saved_index = main_index;

			/* Read a Protocol into a buffer */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 4 ',' (i.e. protocol,lower_port, higher_port, descprtn) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Lower Port ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 4 ',' (i.e. protocol,lower_port, higher_port, descrptn) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Higher Port ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index++] = node->parameter[main_index++];

			/* In this 4 ',' (i.e. protocol,lower_port, higher_port, descrptn) 
            will be there, hence read one again to get the full
			   entry */

         /* Reading Descrption ... */
			while (node->parameter[main_index] != ',' && node->parameter[main_index] != 0 && node->parameter[main_index] != '\n')
				temp_buffer1[sub_index++] = node->parameter[main_index++];

			temp_buffer1[sub_index] = 0;

			/* Are the Proxy Entries Matching */
			if (!strcmpi(temp_buffer1, temp_buffer2))
			{
            return TRUE;
			}
			else
			{
				/* The Match failed between given entry and the read entry
					if some more entries are there then lets continue reading 
					them otherwise let us try to read entry from next line/node */

				if (node->parameter[main_index] == 0)		
					entries_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++ ; /* Skip the ',' */
					entries_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (entries_available_in_the_same_buffer);

		/* Lets Try to read a next line/node with match */
		node = get_next_proxy_user_entry(CM_PROXY_SECTION, node, (void*)&temp_entry);
	}
	while (node);
   return FALSE;
}
/*------------------... Proxy Server User Defined Entries---------------- */

#endif


