/*	$Modname: cipxapi.c$  $version: 1.3$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 03/30/95 titus Added API functions to set the PPP negotiated CIPX options
1.3 04/06/95 titus Changes for Windows 95 testing and for new configurable parameters
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "cipx.h"
/************************************************************************************/
void cipx_compress_header (USHORT transmit_port_number, IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes)
{
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state;

	if (cipx.enabled == TRUE)
		{
		if ((transmit_port_number < NUMBER_OF_CIPX_PORTS) && (transmit_port_number < cipx.number_of_ports))
			{
			if (cipx.port[transmit_port_number].cipx_compression_enabled == TRUE)
				{
				sptr_line_compression_state =	&cipx.port[transmit_port_number].line_compression_state;

				compress_header (ptr_to_sptr_ipx_packet, usptr_number_of_bytes, sptr_line_compression_state);
				}
			else
				{
				++cipx.statistics.cipx_compression_disabled_for_transmit_port;

#ifdef DEBUG
				cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: cipx compression for transmit port number %u is disabled\n",
					transmit_port_number);
#endif
				}
			}
		else
			{
			++cipx.statistics.transmit_port_number_was_invalid;

			cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: transmit port number %u is invalid\n", transmit_port_number);
			}
		}
	else
		{
#ifdef DEBUG
		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: cipx compression/decompression disabled\n");
#endif
		}
}
/************************************************************************************/
enum PROCESS_RESULT cipx_uncompress_header (USHORT receive_port_number, IPX_PACKET **ptr_to_sptr_ipx_packet,
	USHORT *usptr_number_of_bytes)
{
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state;
	enum PROCESS_RESULT return_code;

	if (cipx.enabled == TRUE)
		{
		if ((receive_port_number < NUMBER_OF_CIPX_PORTS) && (receive_port_number < cipx.number_of_ports))
			{
			if (cipx.port[receive_port_number].cipx_compression_enabled == TRUE)
				{
				sptr_line_compression_state =	&cipx.port[receive_port_number].line_compression_state;

				return_code = uncompress_header (ptr_to_sptr_ipx_packet, usptr_number_of_bytes, sptr_line_compression_state);
				
				return (return_code);
				}
			else
				{
				++cipx.statistics.cipx_compression_disabled_for_receive_port;

#ifdef DEBUG
				cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: cipx compression for receive port number %u is disabled\n",
					receive_port_number);
#endif
				}
			}
		else
			{
			++cipx.statistics.receive_port_number_was_invalid;

#ifdef DEBUG
			cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: receive port number %u is invalid\n", receive_port_number);
#endif
			}
		}
	else
		{
#ifdef DEBUG
		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: cipx compression/decompression disabled\n");
#endif
		}

	return (CONTINUE_PROCESSING);
}
/************************************************************************************/
BYTE cipx_get_maximum_connection_states (USHORT real_port_number)
{
	if ((real_port_number < NUMBER_OF_CIPX_PORTS) && (real_port_number < cipx.number_of_ports))
		{
		return (cipx.port[real_port_number].line_compression_state.maximum_number_of_slots);
		}
	else
		{
		return (0x00);
		}
}
/************************************************************************************/
enum BOOLEAN cipx_get_compress_slot_number (USHORT real_port_number)
{
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state;

	if ((real_port_number < NUMBER_OF_CIPX_PORTS) && (real_port_number < cipx.number_of_ports))
		{
		sptr_line_compression_state = &cipx.port[real_port_number].line_compression_state;

		return (enum BOOLEAN) (sptr_line_compression_state->slot_number_compression_enabled);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
enum TEST cipx_set_maximum_connection_states (USHORT real_port_number, BYTE maximum_number_of_slots)
{
	if ((real_port_number < NUMBER_OF_CIPX_PORTS) && (real_port_number < cipx.number_of_ports))
		{
		cipx.port[real_port_number].line_compression_state.maximum_number_of_slots = maximum_number_of_slots;

		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
/************************************************************************************/
enum TEST cipx_set_compress_slot_number (USHORT real_port_number, enum BOOLEAN compress_slot_number)
{
	if ((real_port_number < NUMBER_OF_CIPX_PORTS) && (real_port_number < cipx.number_of_ports))
		{
		cipx.port[real_port_number].line_compression_state.slot_number_compression_enabled = compress_slot_number;

		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}


