/*	$Modname: cipxtxen.c$  $version: 1.4$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 02/06/95 titus
1.3 03/30/95 titus Changes for new configurable parameters
1.4 04/06/95 titus Changes for Windows 95 testing
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "cipx.h"
/************************************************************************************/
static enum BOOLEAN check_if_slot_number_changed_from_last_packet_sent (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state);
static void include_slot_number_in_compressed_header (CIPX_CONNECTION_STATE *sptr_connection_state, BYTE *bptr_change_mask,
	BYTE **ptr_to_bptr_cipx_header);
static void include_ipx_checksum_in_compressed_header (IPX_HEADER *sptr_ipx_header, BYTE *bptr_change_mask,
	BYTE **ptr_to_bptr_cipx_header);
static void include_length_of_packet_in_compressed_header (IPX_HEADER *sptr_ipx_header, BYTE *bptr_change_mask,
	BYTE **ptr_to_bptr_cipx_header);
static enum BOOLEAN check_if_task_number_changed (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header);
static void include_task_number_of_client_in_compressed_header (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	BYTE *bptr_change_mask,	BYTE **ptr_to_bptr_cipx_header);
/************************************************************************************/
enum BOOLEAN cipx_check_if_any_changes_to_fields_that_we_didnot_expect_to_change (IPX_HEADER *sptr_ipx_header,
	IPX_HEADER *sptr_old_ipx_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type,	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	if (sptr_old_ncp_header != NULL)
		{
		if (((sptr_line_compression_state->ipx_checksum_enabled == FALSE) &&
			(sptr_ipx_header->checksum != sptr_old_ipx_header->checksum)) ||
			(sptr_ipx_header->packet_type != sptr_old_ipx_header->packet_type) ||
			(sptr_ipx_header->transport_control_hop_count != sptr_old_ipx_header->transport_control_hop_count) ||
			(sptr_ncp_header->packet_type != sptr_old_ncp_header->packet_type))
			{
			cipx_printf (CIPX_ALARM_PRINTF, "CIPX: unexpected fields have changed\n");

			if (sptr_line_compression_state->confirmed_initial_packet_enabled == TRUE)
				{
				*eptr_send_cipx_packet_type = TYPE_CONFIRMED_INITIAL;
				}
			else
				{
				*eptr_send_cipx_packet_type = TYPE_UNCONFIRMED_INITIAL;
				}

			return (TRUE);
			}
		}
	else
		{
		if (((sptr_line_compression_state->ipx_checksum_enabled == FALSE) &&
			(sptr_ipx_header->checksum != sptr_old_ipx_header->checksum)) ||
			(sptr_ipx_header->packet_type != sptr_old_ipx_header->packet_type) ||
			(sptr_ipx_header->transport_control_hop_count != sptr_old_ipx_header->transport_control_hop_count))
			{
			cipx_printf (CIPX_ALARM_PRINTF, "CIPX: unexpected fields have changed\n");

			if (sptr_line_compression_state->confirmed_initial_packet_enabled == TRUE)
				{
				*eptr_send_cipx_packet_type = TYPE_CONFIRMED_INITIAL;
				}
			else
				{
				*eptr_send_cipx_packet_type = TYPE_UNCONFIRMED_INITIAL;
				}

			return (TRUE);
			}
		}

	return (FALSE);
}
/************************************************************************************/
enum BOOLEAN cipx_check_if_no_changes_to_fields_that_were_expected_to_change (IPX_HEADER *sptr_ipx_header,
	IPX_HEADER *sptr_old_ipx_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type,	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	PARAMETER_NOT_USED (sptr_ipx_header);
	PARAMETER_NOT_USED (sptr_old_ipx_header);

	if (sptr_old_ncp_header != NULL)
		{
		if (sptr_ncp_header->sequence_number != (sptr_old_ncp_header->sequence_number + 1))
			{
			cipx_printf (CIPX_ALARM_PRINTF, "CIPX: Unexpected change to sequence number field: %u -> %u\n",
				sptr_old_ncp_header->sequence_number, sptr_ncp_header->sequence_number);

			if (sptr_line_compression_state->confirmed_initial_packet_enabled == TRUE)
				{
				*eptr_send_cipx_packet_type = TYPE_CONFIRMED_INITIAL;
				}
			else
				{
				*eptr_send_cipx_packet_type = TYPE_UNCONFIRMED_INITIAL;
				}

			return (TRUE);
			}
		}

	return (FALSE);
}
/************************************************************************************/
void send_cipx_regular_packet (IPX_PACKET **ptr_to_sptr_ipx_packet, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	USHORT *usptr_number_of_bytes)
{
	BYTE *bptr_packet_header;

	bptr_packet_header = (BYTE *) &(*ptr_to_sptr_ipx_packet)->ipx_header;

	--bptr_packet_header;

	*bptr_packet_header = TYPE_REGULAR;

	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) (bptr_packet_header - sizeof (UNION_MAC_HEADER));

	*usptr_number_of_bytes += (USHORT) LENGTH_OF_CIPX_REGULAR_HEADER;

#ifdef DEBUG
	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);

	print_header_in_regular_packet (*ptr_to_sptr_ipx_packet, TRANSMIT_MODE, TO_LOWER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif
}
/************************************************************************************/
void send_cipx_confirmed_initial_packet (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header, USHORT header_length,
	IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes)
{
	BYTE *bptr_cipx_header;

	cipx_update_connection_state_with_new_header (sptr_connection_state, sptr_ipx_header, header_length);

	bptr_cipx_header = (BYTE *) sptr_ipx_header;

	--bptr_cipx_header;

	++sptr_connection_state->last_confirmed_initial_packet_id;

	*bptr_cipx_header = sptr_connection_state->last_confirmed_initial_packet_id;

	--bptr_cipx_header;

	*bptr_cipx_header = sptr_connection_state->slot_number;

	--bptr_cipx_header;

	*bptr_cipx_header = TYPE_CONFIRMED_INITIAL;

	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) (bptr_cipx_header - sizeof (UNION_MAC_HEADER));

	*usptr_number_of_bytes += (USHORT) LENGTH_OF_CONFIRMED_INITIAL_HEADER;

	sptr_line_compression_state->last_transmitted_slot_number = sptr_connection_state->slot_number;

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], TRANSMIT_MODE, NEW, sptr_connection_state,
		sptr_line_compression_state);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);

	print_header_in_initial_packet (*ptr_to_sptr_ipx_packet, TRANSMIT_MODE, TO_LOWER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

	++cipx.statistics.type_confirmed_initial_packets_transmitted;
}
/************************************************************************************/
void send_cipx_unconfirmed_initial_packet (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header, USHORT header_length,
	IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes)
{
	BYTE *bptr_cipx_header;

	cipx_update_connection_state_with_new_header (sptr_connection_state, sptr_ipx_header, header_length);

	bptr_cipx_header = (BYTE *) sptr_ipx_header;

	--bptr_cipx_header;

	*bptr_cipx_header = sptr_connection_state->slot_number;

	--bptr_cipx_header;

	*bptr_cipx_header = TYPE_UNCONFIRMED_INITIAL;

	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) (bptr_cipx_header - sizeof (UNION_MAC_HEADER));

	*usptr_number_of_bytes += (USHORT) LENGTH_OF_UNCONFIRMED_INITIAL_HEADER;

	sptr_line_compression_state->last_transmitted_slot_number = sptr_connection_state->slot_number;

	sptr_connection_state->unconfirmed_initial_packet = TRUE;

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], TRANSMIT_MODE, NEW, sptr_connection_state,
		sptr_line_compression_state);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);

	print_header_in_initial_packet (*ptr_to_sptr_ipx_packet, TRANSMIT_MODE, TO_LOWER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

	++cipx.statistics.type_unconfirmed_initial_packets_transmitted;
}
/************************************************************************************/
void cipx_figure_out_which_of_the_fields_changed (BYTE *bptr_change_mask, enum BOOLEAN *eptr_send_ncp_uncompressed,
	IPX_HEADER *sptr_ipx_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	BYTE **ptr_to_bptr_cipx_header, CIPX_CONNECTION_STATE *sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	PARAMETER_NOT_USED (eptr_send_ncp_uncompressed);

	if (sptr_line_compression_state->slot_number_compression_enabled == TRUE)
		{
		if ((sptr_line_compression_state->confirmed_initial_packet_enabled == FALSE) &&
			(sptr_connection_state->unconfirmed_initial_packet == TRUE))
			{
			if (check_if_slot_number_changed_from_last_packet_sent (sptr_line_compression_state, sptr_connection_state) == TRUE)
				{
				include_slot_number_in_compressed_header (sptr_connection_state, bptr_change_mask, ptr_to_bptr_cipx_header);
				}
			}
		else
			{
			include_slot_number_in_compressed_header (sptr_connection_state, bptr_change_mask, ptr_to_bptr_cipx_header);
			}
		}
	else
		{
		include_slot_number_in_compressed_header (sptr_connection_state, bptr_change_mask, ptr_to_bptr_cipx_header);
		}

	if (sptr_line_compression_state->ipx_checksum_enabled == TRUE)
		{
		include_ipx_checksum_in_compressed_header (sptr_ipx_header, bptr_change_mask, ptr_to_bptr_cipx_header);
		}

	if (sptr_line_compression_state->determine_length_from_mac_header_enabled == FALSE)
		{
		include_length_of_packet_in_compressed_header (sptr_ipx_header, bptr_change_mask, ptr_to_bptr_cipx_header);
		}

	if (sptr_old_ncp_header != NULL && *eptr_send_ncp_uncompressed == FALSE)
		{
		if (check_if_task_number_changed (sptr_ncp_header, sptr_old_ncp_header) == TRUE)
			{
			include_task_number_of_client_in_compressed_header (sptr_ncp_header, bptr_change_mask, ptr_to_bptr_cipx_header);
			}
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_slot_number_changed_from_last_packet_sent (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state)
{
	if (sptr_connection_state->slot_number != sptr_line_compression_state->last_transmitted_slot_number)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static void include_slot_number_in_compressed_header (CIPX_CONNECTION_STATE *sptr_connection_state, BYTE *bptr_change_mask,
	BYTE **ptr_to_bptr_cipx_header)
{
	**ptr_to_bptr_cipx_header = sptr_connection_state->slot_number;

	*bptr_change_mask = *bptr_change_mask | SLOT_NUMBER_FIELD;

	++(*ptr_to_bptr_cipx_header);
}
/************************************************************************************/
static void include_ipx_checksum_in_compressed_header (IPX_HEADER *sptr_ipx_header, BYTE *bptr_change_mask,
	BYTE **ptr_to_bptr_cipx_header)
{
	**ptr_to_bptr_cipx_header = (BYTE) (sptr_ipx_header->checksum >> NUMBER_OF_BITS_IN_BYTE);

	++(*ptr_to_bptr_cipx_header);
	
	**ptr_to_bptr_cipx_header = sptr_ipx_header->checksum;

	*bptr_change_mask = *bptr_change_mask | CHECKSUM_FIELD;

	++(*ptr_to_bptr_cipx_header);
}
/************************************************************************************/
static void include_length_of_packet_in_compressed_header (IPX_HEADER *sptr_ipx_header, BYTE *bptr_change_mask,
	BYTE **ptr_to_bptr_cipx_header)
{
	USHORT length;

	length = net_to_host_short (sptr_ipx_header->length);

	if (sptr_ipx_header->length <= ONE_TWENTY_SEVEN)
		{
		**ptr_to_bptr_cipx_header = (BYTE) length;

		++(*ptr_to_bptr_cipx_header);
		}
	else
		{
		if (sptr_ipx_header->length < ONE_NINETY_TWO)
			{
			**ptr_to_bptr_cipx_header = (BYTE) (length >> NUMBER_OF_BITS_IN_BYTE);

			**ptr_to_bptr_cipx_header = **ptr_to_bptr_cipx_header | TWO_BYTE_LENGTH;

			++(*ptr_to_bptr_cipx_header);

			**ptr_to_bptr_cipx_header = length;

			++(*ptr_to_bptr_cipx_header);
			}
		else
			{
			**ptr_to_bptr_cipx_header = THREE_BYTE_LENGTH;

			++(*ptr_to_bptr_cipx_header);

			**ptr_to_bptr_cipx_header = (BYTE) (length >> NUMBER_OF_BITS_IN_BYTE);

			++(*ptr_to_bptr_cipx_header);

			**ptr_to_bptr_cipx_header = length;

			++(*ptr_to_bptr_cipx_header);
			}
		}

	*bptr_change_mask = *bptr_change_mask | LENGTH_FIELD;
}
/************************************************************************************/
static enum BOOLEAN check_if_task_number_changed (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header)
{
	if (sptr_ncp_header->task_number != sptr_old_ncp_header->task_number)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static void include_task_number_of_client_in_compressed_header (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	BYTE *bptr_change_mask,	BYTE **ptr_to_bptr_cipx_header)
{
	**ptr_to_bptr_cipx_header = sptr_ncp_header->task_number;

	*bptr_change_mask = *bptr_change_mask | TASK_NUMBER_FIELD;

	++(*ptr_to_bptr_cipx_header);
}
/************************************************************************************/
void cipx_update_connection_state_with_new_header (CIPX_CONNECTION_STATE *sptr_connection_state,
	IPX_HEADER *sptr_ipx_header, USHORT header_length)
{
	memset ((void *) &sptr_connection_state->uncompressed_header[0], 0x00, MAXIMUM_HEADER_LENGTH);

	memcpy ((void *) &sptr_connection_state->uncompressed_header[0], (const void *) sptr_ipx_header, header_length);

	sptr_connection_state->header_length = header_length;
}
/************************************************************************************/
void send_cipx_compressed_packet (IPX_PACKET **ptr_to_sptr_ipx_packet, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, USHORT header_length, BYTE **ptr_to_bptr_cipx_header, BYTE *bptr_cipx_header,
	IPX_HEADER *sptr_ipx_header, USHORT *usptr_number_of_bytes)
{
	USHORT length;

	length = (USHORT) (*ptr_to_bptr_cipx_header - bptr_cipx_header);

#ifdef DEBUG
	cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: length of compressed header is %u\n", length);
#endif

	*ptr_to_bptr_cipx_header = (BYTE *) sptr_ipx_header;

  	sptr_line_compression_state->last_transmitted_slot_number = sptr_connection_state->slot_number;

  	header_length -= length;

  	*ptr_to_bptr_cipx_header += header_length;

	memcpy ((void *) *ptr_to_bptr_cipx_header, (const void *) bptr_cipx_header, length);

	*usptr_number_of_bytes -= header_length;

	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) (*ptr_to_bptr_cipx_header - sizeof (UNION_MAC_HEADER));

	++cipx.statistics.type_compressed_packets_transmitted;
}

