/*	$Modname: vjcprnt.c$  $version: 1.3$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/25/94 titus
1.2 08/26/94 titus Add Copyright
1.3 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<string.h>
#include	<stdarg.h>
#include	<stdio.h>
#include	"vjc.h"
#include "vvjcprnt.h"
/**************************************************************************/
void vjc_printf (enum VJC_PRINTF_GROUPS printf_group, const char *cptr_format, ...)
{
	BYTE_ENUM (BOOLEAN) print_string;
	va_list argptr;

	va_start (argptr, cptr_format);

	if (vjc.print_class.vjc_print_switch_on == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case VJC_PRINTF:

			print_string = vjc.print_class.vjc_printing_enabled;

			break;

		case VJC_INIT_PRINTF:

			print_string = vjc.print_class.init_printing_enabled;

			break;

		case VJC_COMPRESS_PRINTF:

			print_string = vjc.print_class.compress_printing_enabled;

			break;

		case VJC_UNCOMPRESS_PRINTF:

			print_string = vjc.print_class.uncompress_printing_enabled;

			break;

		case VJC_ENCODE_PRINTF:

			print_string = vjc.print_class.encode_printing_enabled;

			break;

		case VJC_DECODE_PRINTF:

			print_string = vjc.print_class.decode_printing_enabled;

			break;

		case VJC_CHECKSUM_PRINTF:

			print_string = vjc.print_class.checksum_printing_enabled;

			break;

		case VJC_STRING_PRINTF:

			print_string = vjc.print_class.string_printing_enabled;

			break;

		case VJC_ALARM_PRINTF:

			print_string = vjc.print_class.alarm_printing_enabled;

			break;

		case VJC_MEMORY_PRINTF:

			print_string = vjc.print_class.memory_printing_enabled;

			break;

		case VJC_DATA_PRINTF:

			print_string = vjc.print_class.data_printing_enabled;

			break;

		case VJC_DIAGNOSTIC_PRINTF:

			print_string = vjc.print_class.diagnostic_printing_enabled;

			break;

		default:

			print_string = FALSE;

			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format, argptr);
		}

	va_end (argptr);
}
/************************************************************************************/
void print_compressed_header_in_packet (IP_PACKET *sptr_ip_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, USHORT number_of_bytes, LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	BYTE *bptr_compressed_header;
	BYTE change_mask;
	USHORT checksum;
	VJC_PORT_CLASS *sptr_port_class;

	if (vjc.print_class.vjc_print_switch_on == TRUE)
		{
		bptr_compressed_header = (BYTE *) &sptr_ip_packet->header;

		change_mask = *bptr_compressed_header;

		vjc_printf (VJC_DATA_PRINTF, "VJC: %s: COMPRESSED %s: %x", cptr_vjc_communication_modes[mode],
			cptr_vjc_packet_direction[packet_direction], change_mask);

		++bptr_compressed_header;

		sptr_port_class = get_pointer_to_port_class_for_the_specified_line_compression_state (sptr_line_compression_state);

		if (sptr_port_class->connection_id_compression_enabled == FALSE)
			{
			vjc_printf (VJC_DATA_PRINTF, ", %x", *bptr_compressed_header);

			++bptr_compressed_header;

			checksum = *bptr_compressed_header;

			++bptr_compressed_header;

			checksum = (USHORT) ((checksum << NUMBER_OF_BITS_IN_BYTE) + *bptr_compressed_header);

			vjc_printf (VJC_DATA_PRINTF, ", %x", checksum);

			++bptr_compressed_header;
			}
		else
			{
			if ((change_mask & DELTA_CONNECTION_IDENTIFIER) != 0x00)
				{
				vjc_printf (VJC_DATA_PRINTF, ", %x", *bptr_compressed_header);

				++bptr_compressed_header;
				}

			checksum = *bptr_compressed_header;

			++bptr_compressed_header;

			checksum = (USHORT) ((checksum << NUMBER_OF_BITS_IN_BYTE) + *bptr_compressed_header);

			vjc_printf (VJC_DATA_PRINTF, ", %x", checksum);

			++bptr_compressed_header;
			}

		if ((change_mask != DELTA_NO_CHANGES) && (change_mask != DELTA_SPECIAL_I) && (change_mask != DELTA_SPECIAL_D))
			{
			if ((change_mask & DELTA_URGENT_POINTER) != 0x00)
				{
				vjc_printf (VJC_DATA_PRINTF, ", %u", *bptr_compressed_header);

				++bptr_compressed_header;
				}

			if ((change_mask & DELTA_WINDOW_SIZE) != 0x00)
				{
				vjc_printf (VJC_DATA_PRINTF, ", %u", *bptr_compressed_header);

				++bptr_compressed_header;
				}

			if ((change_mask & DELTA_ACKNOWLEDGMENT_NUMBER) != 0x00)
				{
				vjc_printf (VJC_DATA_PRINTF, ", %u", *bptr_compressed_header);

				++bptr_compressed_header;
				}

			if ((change_mask & DELTA_SEQUENCE_NUMBER) != 0x00)
				{
				vjc_printf (VJC_DATA_PRINTF, ", %u", *bptr_compressed_header);

				++bptr_compressed_header;
				}

			if ((change_mask & DELTA_PACKET_ID) != 0x00)
				{
				vjc_printf (VJC_DATA_PRINTF, ", %u", *bptr_compressed_header);

				++bptr_compressed_header;
				}

			vjc_printf (VJC_DATA_PRINTF, ", %u", number_of_bytes);

			vjc_printf (VJC_DATA_PRINTF, "\n");
			}
		else
			{
			vjc_printf (VJC_DATA_PRINTF, "\n");
			}
		}

	return;
}
/************************************************************************************/
void print_uncompressed_header_in_packet (IP_PACKET *sptr_ip_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction)
{
	IP_HEADER *sptr_ip_header;
	TCP_HEADER *sptr_tcp_header;

	if (vjc.print_class.vjc_print_switch_on == TRUE)
		{
		sptr_ip_header = &sptr_ip_packet->header;

		sptr_tcp_header = get_pointer_to_tcp_header (sptr_ip_header);

		vjc_printf (VJC_DATA_PRINTF, "VJC: %s: UNCOMPRESSED %s:", cptr_vjc_communication_modes[mode],
			cptr_vjc_packet_direction[packet_direction]);

		vjc_printf (VJC_DATA_PRINTF, "%u, %x,", sptr_ip_header->protocol, sptr_tcp_header->checksum);

		vjc_printf (VJC_DATA_PRINTF, "%u, %u,", net_to_host_short (sptr_tcp_header->window_size),
			net_to_host_long (sptr_tcp_header->acknowledgment_number));

		vjc_printf (VJC_DATA_PRINTF, "%u, %u\n", net_to_host_long (sptr_tcp_header->sequence_number),
			net_to_host_short (sptr_ip_header->identifier));
		}

	return;
}
/************************************************************************************/
void print_connection_state (BYTE *uncompressed_header, enum COMMUNICATION_MODE mode, enum HEADER_AGE header_age,
	CONNECTION_STATE *sptr_connection_state)
{
	IP_HEADER *sptr_ip_header;
	TCP_HEADER *sptr_tcp_header;

	if (vjc.print_class.vjc_print_switch_on == TRUE)
		{
		sptr_ip_header = (IP_HEADER *) uncompressed_header;

		sptr_tcp_header = get_pointer_to_tcp_header (sptr_ip_header);

		vjc_printf (VJC_DATA_PRINTF, "VJC: %s: CONNECTION STATE %s:", cptr_vjc_communication_modes[mode],
			cptr_vjc_header_age[header_age]);

		vjc_printf (VJC_DATA_PRINTF, "%u, %x,", sptr_ip_header->protocol, sptr_tcp_header->checksum);

		vjc_printf (VJC_DATA_PRINTF, "%u, %u,", net_to_host_short (sptr_tcp_header->window_size),
			net_to_host_long (sptr_tcp_header->acknowledgment_number));

		vjc_printf (VJC_DATA_PRINTF, "%u, %u,", net_to_host_long (sptr_tcp_header->sequence_number),
			net_to_host_short (sptr_ip_header->identifier));

		if (sptr_connection_state != NULL)
			{
			vjc_printf (VJC_DATA_PRINTF, "%u, <%u>\n", net_to_host_short (sptr_ip_header->total_length),
				sptr_connection_state->header_length);
			}
		else
			{
			vjc_printf (VJC_DATA_PRINTF, "%u\n", net_to_host_short (sptr_ip_header->total_length));
			}
		}
}
