/*	$Modname: vvjcstr.h$  $version: 1.3$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/25/94 titus
1.2 08/26/94 titus Add Copyright
1.3 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _VVJCSTR_H_	
#define _VVJCSTR_H_


/*
 * "state" data for each active tcp conversation on the wire. This is basically a copy of the entire TCP/IP header from
 * the last packet together with a small identifier the transmit & receive ends of the line use to locate the saved header.
 */

typedef struct CONNECTION_STATE 
{
	struct CONNECTION_STATE *sptr_connection_state_next; 						/* next most recently used connection_state
																									(used by transmit only) */
	USHORT 						header_length; 										/* size of header (used by receive only) */
	BYTE	 						connection_identifier; 								/* connection id associated with this connection_state */
	BYTE 							uncompressed_header[MAXIMUM_HEADER_LENGTH]; 	/* tcp/ip hdr from most recent packet */
} CONNECTION_STATE;


/*
 * all the state data for one serial line (we need one of these per line).
 */

typedef struct LINE_COMPRESSION_STATE
{
	CONNECTION_STATE 			*sptr_last_connection_state; 													/* pointer to the most recently used
																																transmitted_connection_state */
	BYTE 							last_received_connection_identifier; 										/* last received connection id */
	BYTE 							last_transmitted_connection_identifier; 									/* last transmitted connection id */
	BYTE_ENUM (BOOLEAN) 		valid_flag;																				/* line compression state flag */
	CONNECTION_STATE 			transmitted_connection_states[MAXIMUM_NUMBER_OF_CONNECTION_STATES];	/* transmit connection states */
	CONNECTION_STATE 			received_connection_states[MAXIMUM_NUMBER_OF_CONNECTION_STATES]; 		/* receive connection states */
} LINE_COMPRESSION_STATE;


typedef struct VJC_STATISTICS_CLASS
{
	ULONG 		type_error_packets_received;
	ULONG 		type_ip_packets_received;
	ULONG 		type_tcp_uncompressed_packets_received;
	ULONG 		type_tcp_compressed_packets_received;
	ULONG 		bad_header_events;
	ULONG 		type_ip_packets_transmitted;
	ULONG 		type_tcp_uncompressed_packets_transmitted;
	ULONG 		type_tcp_compressed_packets_transmitted;
	ULONG 		bandwidth_in_bytes_saved_by_header_compression;
	ULONG 		matching_connection_state_was_the_most_recently_used_one;
	ULONG 		least_recently_used_connection_state_was_replaced;
	ULONG 		matching_connection_state_was_found;
	ULONG 		transmit_port_number_was_invalid;
	ULONG 		vjc_compression_disabled_for_transmit_port;
	ULONG 		vjc_compression_disabled_for_receive_port;
	ULONG 		receive_port_number_was_invalid;
} VJC_STATISTICS_CLASS;


typedef	struct VJC_PRINT_CLASS
{
	BYTE_ENUM (BOOLEAN) 			vjc_print_switch_on;
	BYTE_ENUM (BOOLEAN) 			vjc_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			init_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			compress_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			uncompress_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			encode_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			decode_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			checksum_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			string_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			memory_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			data_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			diagnostic_printing_enabled;
} VJC_PRINT_CLASS;


typedef struct VJC_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN) 			vjc_compression_enabled;
	BYTE_ENUM (BOOLEAN) 			connection_id_compression_enabled;
	LINE_COMPRESSION_STATE 		line_compression_state;
} VJC_PORT_CLASS;


typedef struct VJC_CLASS
{
	BYTE_ENUM (BOOLEAN) 		enabled;
	BYTE_ENUM (BOOLEAN) 		align_header_on_4_byte_boundary_enabled;
	VJC_PORT_CLASS 			port[NUMBER_OF_VJC_PORTS];
	VJC_STATISTICS_CLASS 	statistics;
	VJC_PRINT_CLASS 			print_class;
} VJC_CLASS;

#endif


/* vjcapi.c */

BYTE vj_compress_tcp_header (USHORT transmit_port_number, IP_PACKET **ptr_to_sptr_ip_packet,
	USHORT *usptr_number_of_bytes);
void vj_uncompress_tcp_header (USHORT receive_port_number, IP_PACKET **ptr_to_sptr_ip_packet,
	USHORT *usptr_number_of_bytes, BYTE type_of_packet);
BYTE vj_get_maximum_connection_states (USHORT real_port_number);
enum BOOLEAN vj_get_compress_connection_id (USHORT real_port_number);


/* vjcinit.c */

enum TEST initialize_vjc (ULONG clock_ticks_per_second);


/* vjctxck.c */

enum TYPE_OF_PACKET vjc_compress_tcp_header (IP_PACKET **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes,
	LINE_COMPRESSION_STATE *sptr_line_compression_state);
TCP_HEADER *get_pointer_to_tcp_header (IP_HEADER *sptr_ip_header);


/* vjctxen.c */

void figure_out_which_of_the_fields_changed (BYTE *bptr_change_mask, enum BOOLEAN *eptr_send_uncompressed,
	TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header, ULONG *ulptr_delta_sequence_number,
	ULONG *ulptr_delta_acknowledgment_number, BYTE **ptr_to_bptr_compressed_header);
void look_for_special_case_encodings (BYTE *bptr_change_mask, enum BOOLEAN *eptr_send_uncompressed,
	USHORT header_length, IP_HEADER *sptr_ip_header, IP_HEADER *sptr_old_ip_header,
	ULONG delta_sequence_number, ULONG acknowledgment_number, BYTE **ptr_to_bptr_compressed_header, BYTE *compressed_header);
void check_for_change_in_packet_identifier_or_whether_tcp_push_flag_is_set (BYTE *bptr_change_mask,
	IP_HEADER *sptr_ip_header,	IP_HEADER *sptr_old_ip_header, TCP_HEADER *sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header);
void	update_connection_state_with_new_header (USHORT *usptr_checksum, CONNECTION_STATE *sptr_connection_state,
	TCP_HEADER *sptr_tcp_header, IP_HEADER *sptr_ip_header, USHORT header_length);
void send_uncompressed_packet (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE *sptr_connection_state, IP_HEADER *sptr_ip_header, USHORT header_length, IP_PACKET *sptr_ip_packet);
void insert_compressed_header_into_original_packet_in_place_of_old_header (IP_PACKET **ptr_to_sptr_ip_packet,
	LINE_COMPRESSION_STATE *sptr_line_compression_state, CONNECTION_STATE *sptr_connection_state, BYTE change_mask,
	USHORT header_length, USHORT checksum,	BYTE **ptr_to_bptr_compressed_header, BYTE *compressed_header,
	IP_HEADER *sptr_ip_header, USHORT *usptr_number_of_bytes);
VJC_PORT_CLASS *get_pointer_to_port_class_for_the_specified_line_compression_state (LINE_COMPRESSION_STATE
	*sptr_line_compression_state);


/* vjcrx.c */

IP_PACKET *vjc_uncompress_tcp_header (IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes, BYTE type_of_packet,
	LINE_COMPRESSION_STATE *sptr_line_compression_state);


/* vjcutil.c */

void encode_possibly_zero_delta (enum VJC_FIELD_TYPE field_type, BYTE *bptr_change_mask, USHORT delta,
	BYTE **ptr_to_bptr_compressed_header);
void encode_non_zero_delta (enum VJC_FIELD_TYPE field_type, BYTE *bptr_change_mask, USHORT delta,
	BYTE **ptr_to_bptr_compressed_header);
void decode_long (ULONG *ulptr_field, BYTE **ptr_to_bptr_compressed_header);
void decode_short (USHORT *usptr_field, BYTE **ptr_to_bptr_compressed_header);
void decode_value (USHORT *usptr_field, BYTE **ptr_to_bptr_compressed_header);

#ifndef __LSL__
	USHORT host_to_net_short (USHORT host_order_short_value);
	USHORT net_to_host_short (USHORT net_order_short_value);
	ULONG host_to_net_long (ULONG host_order_long_value);
	ULONG net_to_host_long (ULONG net_order_long_value);
#endif /* __LSL__ */


/* vjcprnt.c */

void vjc_printf (enum VJC_PRINTF_GROUPS printf_group, const char *cptr_format, ...);
void print_compressed_header_in_packet (IP_PACKET *sptr_ip_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, USHORT number_of_bytes, LINE_COMPRESSION_STATE *sptr_line_compression_state);
void print_uncompressed_header_in_packet (IP_PACKET *sptr_ip_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction);
void print_connection_state (BYTE *uncompressed_header, enum COMMUNICATION_MODE mode, enum HEADER_AGE header_age,
	CONNECTION_STATE *sptr_connection_state);


/* prototypes external to VJC */

extern void ppp_register_vj_compression (USHORT port_number, BYTE (*fptr_vj_compress_tcp_header)
	(USHORT real_port_number, void **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes),
	BYTE (*fptr_vj_get_maximum_connection_states) (USHORT real_port_number),
	enum BOOLEAN (*fptr_vj_get_compress_connection_id) (USHORT real_port_number),
	void (*fptr_vj_uncompress_tcp_header) (USHORT receive_port_number, void **ptr_to_sptr_ip_packet,
	USHORT *usptr_number_of_bytes, BYTE type_of_packet));


