/****************************************************************************/
/* 
	This file contains the init routines of ethernet. initialize_ethernet_cont-
	roller() is called from main. This function is put in \rtrware\store\vrtrwstr
	.h file in the device drivers structure. initialize_routerware_software
	function calls this. we just register with lsl with all the entry points
	for tx, rx, timer and control. presently control function is not being used
	as we have no use of this presently.
*/
/****************************************************************************/

#include	"defs.h"
#include	<stdarg.h>
#include	"ethernet.h"

enum TEST ethernet_control (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);

static void initialize_ethernet_tx_descriptors (USHORT port_number);
static void initialize_ethernet_rx_descriptors (USHORT port_number, USHORT buffer_size);
extern	void ethernet_init(ULONG localio,void *);	

ETHERNET_CLASS		ethernet;
ULONG	EthRxError;
ULONG EthTxError;
ULONG	NetRcvOverFlow;

ETHERNET_ADDRESS ether_address;

#if ETHER_DEBUG
void change_print_status();
void device_driver_mem_debug();
void device_driver_buffer_debug();
#endif
#if STATUS_DEBUG
void show_ethernet_port_statistics();
#endif

/****************************************************************************/
/*
	This is called from main. Registering with lsl , initialization of Rx & Tx
	descriptors are done from here.
*/
/****************************************************************************/
enum TEST initialize_ethernet_controller(ULONG clock_ticks_per_second)
{
	USHORT buffer_size = 1520;
   USHORT port_number, number_of_ethernet_ports;

	PARAMETER_NOT_USED (clock_ticks_per_second);

#if ETHER_DEBUG
#if STATUS_DEBUG   
   register_debugger(change_print_status, "edebug");
   register_debugger(device_driver_mem_debug, "ememdebug");
	/* Added By Ravi */
   register_debugger(device_driver_buffer_debug, "ebufdebug");
	/* Added By Ravi */
#endif
#endif

#if STATUS_DEBUG  
   register_debugger(show_ethernet_port_statistics, "lan stat");
#endif   

   number_of_ethernet_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);

   for ( port_number = 0 ; port_number < number_of_ethernet_ports ; ++port_number)
   {
		if(!(lsl_control (REGISTER_LOW_LEVEL_DEVICE_DRIVER,

                        "Ethernet Driver",

		                  ETHERNET_DEVICE_DRIVER,

		                  (enum TEST (*) (ULONG protocol_stack_id,
                                        USHORT port_number, 
				                            USHORT virtual_port_number, 
                                        void *sptr_tx_buffer,
				                            USHORT number_of_bytes,	
                                        enum BOOLEAN bridged_packet, 
				                            enum BOOLEAN protocol_packet,
				                            void (*fptr_tx_completion) (USHORT port_number, 
					                         void *sptr_ethernet_buffer))
                        )send_ethernet_packet,

		                  (void (*) (USHORT port_number)) ethernet_packet_transmitted,

		                  (enum BOOLEAN (*) (USHORT port_number, 
                                           void **vptr_buffer, 
				                               USHORT *usptr_number_of_bytes_rxed)
                        ) ethernet_packet_received,

      		            NULL,

	   	               (enum TEST (*) (enum DEVICE_CONTROL_OPERATION command, 
				                            ULONG parameter_0, 
                                        ULONG parameter_1)
                        ) ethernet_control,

		                  (void (*) (USHORT port_number,void *vptr_buffer)
                        )ethernet_return_buffer_to_device_driver,

		                  &ethernet.port[port_number].device_driver_id)))
      {
			printf("\n\r ETHERNET INIT FAILED \n\r");
			return(FAIL);
		}

      /* The code commented by Naveen. Call is made with port number instead of constant
         lsl_control (DEVICE_DRIVER_GET_MAC_ADDRESS,ETHERNET_PORT_NUMBER,&ether_address); 
      */
         lsl_control (DEVICE_DRIVER_GET_MAC_ADDRESS, port_number, &ether_address);

      /* add all the buffers descriptors to freelist suitably */
	      initialize_ethernet_tx_descriptors(port_number);

      /* The code commented by Naveen. Call is made with port number instead of constant
	      buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, ETHERNET_PORT_NUMBER);
      */
	      buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, port_number);

	      initialize_ethernet_rx_descriptors(port_number, buffer_size);

#ifdef DEBUG
	      printf ("AUI=%d, LocalIO=%x\n\r", ethernet.port[port_number].port_is_AUI,
				      ethernet.port[port_number].ethernet_local_io_value);
#endif
	      if (ethernet.port[port_number].ethernet_local_io_value == 0) 
         {
            if (ethernet.port[port_number].port_is_AUI) 
            {
               switch(port_number)
               {
                  /* If the port being initialized is first port then call 
                     corresponding Initialization Function for AUI*/
                  case ETHERNET_PORT_1 :  
                           ethernet_init_for_SCC1(0x31,&ether_address);
      			            printf("ETHERNET: Ethernet Port %04X initialized for AUI\n\r", port_number);
                           break;

                  /* If the port being initialized is second port then call 
                     corresponding Initialization Function for AUI*/
                  case ETHERNET_PORT_2 :
                           ethernet_init_for_SCC2(0x31,&ether_address);
      			            printf("ETHERNET: Ethernet Port %04X initialized for AUI\n\r", port_number);
                           break;

                  /* Control will come here if there is no Initialization 
                     function available , Alarm the user */
                  default :
                           printf("ETHERNET: Initialization function is not available for port %04X\n", port_number);
               }
            } 
            else 
            {
               switch(port_number)
               {
                  /* If the port being initialized is first port then call 
                     corresponding Initialization Function for UTP*/
                  case ETHERNET_PORT_1 :  
            			      ethernet_init_for_SCC1(0xE7,&ether_address);
      			            printf("ETHERNET: Ethernet Port %04X initialized for UTP/10BASET MAC Address: %08X%04X \n\r", port_number, ether_address._ulong, ether_address._ushort);
                           break;

                  /* If the port being initialized is second port then call 
                     corresponding Initialization Function for UTP*/
                  case ETHERNET_PORT_2 :
			                  ethernet_init_for_SCC2(0xE7,&ether_address);
      			            printf("ETHERNET: Ethernet Port %04X initialized for UTP/10BASET MAC Address: %08X%04X \n\r", port_number, ether_address._ulong, ether_address._ushort);
                           break;

                  /* Control will come here if there is no Initialization 
                     function available , Alarm the user */
                  default :
                           printf("ETHERNET: Initialization function is not available for port %04X\n", port_number);
               }
		      }
	      } 
         else 
         {
            switch(port_number)
            {
               /* If the port being initialized is first port then call 
                  corresponding Initialization Function for LocalIO*/
               case ETHERNET_PORT_1 :  
		                  ethernet_init_for_SCC1(ethernet.port[port_number].ethernet_local_io_value,&ether_address);
      		            printf("ETHERNET: Ethernet Port %04X initialized for LocalIO\n\r", port_number);
                        break;

               /* If the port being initialized is second port then call 
                  corresponding Initialization Function for LocalIO */
               case ETHERNET_PORT_2 :
   		               ethernet_init_for_SCC2(ethernet.port[port_number].ethernet_local_io_value,&ether_address);
      		            printf("ETHERNET: Ethernet Port %04X initialized for LocalIO\n\r", port_number);
                        break;

               /* Control will come here if there is no Initialization 
                  function available , Alarm the user */
               default :
                        printf("ETHERNET: Initialization function is not available for port %04X\n", port_number);
            }
	      }
   }
	return(PASS);
}
/****************************************************************************/
/*	initialize_ethernet_tx_descriptors.
	In ethernet port class we have declared ETHERNET_TX_DESCRIPTORS which is 
	defined in nvethstr.h. 
	All the tx descriptors are added to free_tx_list.
*/
/****************************************************************************/
static void initialize_ethernet_tx_descriptors (USHORT port_number)
{
	USHORT number_of_tx_descriptors;

	for (number_of_tx_descriptors = 0; number_of_tx_descriptors < NUMBER_OF_ETHERNET_TX_BUFFERS; ++number_of_tx_descriptors)
	{
		ethernet.port[port_number].tx_descriptor[number_of_tx_descriptors].in_use = FALSE;
		ethernet.port[port_number].tx_descriptor[number_of_tx_descriptors].device_driver_buffer = FALSE;
		ethernet.port[port_number].tx_descriptor[number_of_tx_descriptors].sptr_tx_packet = NULL;
		ethernet.port[port_number].tx_descriptor[number_of_tx_descriptors].fptr_tx_complete = NULL;

		add_entry_to_list (&ethernet.port[port_number].free_tx_list,
		   &ethernet.port[port_number].tx_descriptor[number_of_tx_descriptors].links);
	}
}

/****************************************************************************/
/*
	initialize_ethernet_rx_descriptors
	All the rx descriptors are added to free_rx_list if a free buffer is found
	otherwise they are added to rx_descriptor_need_buffer_list.
*/
/****************************************************************************/
static void initialize_ethernet_rx_descriptors (USHORT port_number, USHORT buffer_size)
{
	USHORT number_of_rx_descriptors;
	/* Added By ravi */
	int ethernet_count = 0;
	/* Added By ravi */

	for (number_of_rx_descriptors = 0; number_of_rx_descriptors < NUMBER_OF_ETHERNET_RX_BUFFERS; ++number_of_rx_descriptors)
	{
		ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].buffer_size = buffer_size;
		ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer =
		(ETHERNET_BUFFER *)	device_driver_malloc (port_number, ethernet.port[port_number].device_driver_id, (USHORT) NULL);

#if ETHER_DEBUG      
      if ( ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer == NULL )
      {
         printf("ETHERNET: Shortage of buffer\n");
      }
#endif

#ifdef DEBUG
		printf("\n\r for ethernet %d buffer  %p",number_of_rx_descriptors,ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer);
#endif
		ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].number_of_bytes_rxed = 0x0000;

		if(ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer == NULL )
   		add_entry_to_list (&ethernet.port[port_number].rx_descriptor_need_buffer_list,
	   		&ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].links);
	   else
		{
		   add_entry_to_list (&ethernet.port[port_number].free_rx_list,
			&ethernet.port[port_number].rx_descriptor[number_of_rx_descriptors].links);
		
	  		ethernet_count++;
		}
	}
	
/*	printf("\n EthernetInit : The Number of Descriptor in Free_rx_list on Port , %d ,  are :  %d", port_number, ethernet_count); */

}

/****************************************************************************/
/*  ethernet_control 
	presently not supported 
*/
/****************************************************************************/
enum TEST ethernet_control (enum DEVICE_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
}

/****************************************************************************/
/*
	ether_printf
	presently calls the actual printf library routine. The first argument is 
	to be made an int. So that if it is more than the DEBUG_VALUE printf(..)
	is called otherwise it will just return.
*/
/****************************************************************************/
void ether_printf (const char *cptr_format, ...)
{
	va_list argptr;
	va_start (argptr,cptr_format);

	printf (cptr_format,argptr);

	va_end (argptr);
}

/* Naveen ... */
#if ETHER_DEBUG
#if STATUS_DEBUG
extern int ether_debugger_on;
void change_print_status()
{
#define NO  0
#define YES 1
   if (ether_debugger_on)
      ether_debugger_on = NO;
   else
      ether_debugger_on = YES;
#undef YES
#undef NO
}  

extern int number_of_device_driver_allocations[];

void device_driver_mem_debug()
{
   printf("The number of device driver allocations are Port 0: %d       Port 1: %d\n", number_of_device_driver_allocations[0], number_of_device_driver_allocations[1]);
}

/* Added By Ravi ... */
void device_driver_buffer_debug()
{
	ETHERNET_RX_DESCRIPTOR *sptr_free_rx_descriptor;
	int  i,j,k,l ;

		for (i=0, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_first_entry_in_list (&ethernet.port[0].free_rx_list);
			  sptr_free_rx_descriptor != NULL;
			  i++, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)&sptr_free_rx_descriptor->links));

		for (j=0, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_first_entry_in_list (&ethernet.port[0].current_rx_list);
			  sptr_free_rx_descriptor != NULL;
			  j++, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)&sptr_free_rx_descriptor->links));

		for (k=0, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_first_entry_in_list (&ethernet.port[0].rx_descriptor_need_buffer_list);
			  sptr_free_rx_descriptor != NULL;
			  k++, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)&sptr_free_rx_descriptor->links));

		for (l=0, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_first_entry_in_list (&ethernet.port[0].scheduled_rx_list);
			  sptr_free_rx_descriptor != NULL;
			  l++, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)&sptr_free_rx_descriptor->links));


		
		printf("\n");
      printf("E-DEBUG: Free Rx List               : %d \n", i);
      printf("E-DEBUG: Scheduled Rx List          : %d \n", l);
      printf("E-DEBUG: Current Rx List            : %d \n", j);
      printf("E-DEBUG: Need Buffer List           : %d \n", k);
		printf("\n");
}
/* ... Added By Ravi  */
#endif
#endif


#if STATUS_DEBUG
extern ULONG number_of_unautorized_packets;
void show_ethernet_port_statistics()
{
   printf("                                         LAN1       LAN2     \n\
ͻ\n\
 Number of Packet Transmitted       %010d%010d\n\
ĺ\n\
 Number of Bytes  Transmitted       %010d%010d\n\
ĺ\n\
 Number of Packet TO Transmit       %010d%010d\n\
ĺ\n\
 Number of Rejected Transmit Packets%010d%010d\n\
ĺ\n\
 Number of Transmit Errors          %010d%010d\n",
            ethernet.port[0].statistics.number_of_packets_txed,
            ethernet.port[1].statistics.number_of_packets_txed,

            ethernet.port[0].statistics.number_of_bytes_txed,
            ethernet.port[1].statistics.number_of_bytes_txed,

            ethernet.port[0].statistics.number_of_packets_to_tx,
            ethernet.port[1].statistics.number_of_packets_to_tx,

            ethernet.port[0].statistics.number_of_rejected_tx_packets,
            ethernet.port[1].statistics.number_of_rejected_tx_packets,

            ethernet.port[0].statistics.number_of_tx_errors,
            ethernet.port[1].statistics.number_of_tx_errors
            );

   printf("\
ĺ\n\
 Number of Packet Received          %010d%010d\n\
ĺ\n\
 Number of Bytes Received           %010d%010d\n\
ĺ\n\
 Number of Receive Errors           %010d%010d\n\
ĺ\n\
 Number of Receive Queue Overflows  %010d%010d\n\
ͼ\
   ",
     ethernet.port[0].statistics.number_of_packets_rxed,
     ethernet.port[1].statistics.number_of_packets_rxed,

     ethernet.port[0].statistics.number_of_bytes_rxed,
     ethernet.port[1].statistics.number_of_bytes_rxed,

     ethernet.port[0].statistics.number_of_rx_errors,
     ethernet.port[1].statistics.number_of_rx_errors,

     ethernet.port[0].statistics.number_of_rx_queue_overflows,
     ethernet.port[1].statistics.number_of_rx_queue_overflows
   );

   printf("\n\
Ŀ\n\
NUMBER OF UNAUTHORIZED PACKETS:%10d\n\
\n",
           number_of_unautorized_packets);
}
#endif

/* ... Naveen */
